# State recovery backtrack for Spritz
This directory contains Python implementation of state recovery backtrack  and its optimizations for cipher Spritz.

To start the backtrack, invoke [benchmark.py](./benchmark.py). Help can be printed out with switch ```-h```. The script expects state file generated by [generate.py](../../generate/generate.py) on its stdin. Optimizations can be switched on with appropriate switches.

By default, after ich run of benchark, it will dump all stats into timestamp named file, it can be prevented with switch ```-nsl```. Statssfile can be quite large for bigger experiments. To print past experiment stats, use [print_stats.py](./print_stats.py).

##### Note on terminology
To simulate complexity of estimate, switch ```-ns``` will force backtrack to continue even after correct state is found.

All prefix check optimizations can be turned on with ```-pc -pcc -pccw -pcg```. Change order optimization is turned on with ```-lgo```, order of guessed values is changed with ```-kgo```.

# Extrakcia stavu prehľadávaním pre šifru Spritz
Tento adresár obsahuje implementáciu prehľadávania s návratom a jej optimalizácie pre šifry Spritz.

Na začatie prehľadávania je potrebné spustiť skript [benchmark.py](./benchmark.py). Popis všetkých nastavení sa vypíše pomocou prepínača ```-h```. Skript očakáva na štandardnom vstupe súbor so stavmi vygenerovaný pomocou [generate.py](../../generate/generate.py). Jednotlivé optimalizácie sa zapínajú príslušnými prepínačmi.

Benchmark po každom spustení uloží všetky štatistiky o experimente aj do súboru. Pre väčšie experimenty sú uložené dáta pomerne veľké, toto správanie sa dá vypnút pomocou ```-nsl```. Na vypísanie uložených dát sa dá použiť skript [print_stats.py](./print_stats.py).

##### Poznámka k terminológii
Pre simulovanie teoretických odhadov prepínač ```-ns``` vynúti prehľadávanie pokračovať aj po nájdení správneho stavu.

Všetky optimalizácie konzistentnosti s prefixom sa zapnú prepínačmi ```-pc -pcc -pccw -pcg```. Pre optimalizáciu zmeny poradia je prepínač ```-lgo```, pre zmenu poradia skúšaných hodnôt ```-kgo```.
