#include "matrix.h"
#define EXP_NO "sada1.h"
#define NETTYPE "Echostate"
#define NETPREFIX "EC"


#define transTime 3
#define alpha 0.01

#define inputSets 100
#define testSets 100
#define EPOCH_COUNT 150

#define NET_FILENAME "x1-normal-100x"//".net"

//chceme resetovat kontext?
//#define DO_RESET


#ifdef DO_RESET
#define RESET_STATEMENT resetState(n);
#else
#pragma warning (disable: 4390)
#define RESET_STATEMENT ;
#endif

#include "input.h"


#define dimI dimInput
#define dimJ 10
#define dimK dimOutput
#define dimIJ dimI+dimJ

using namespace std;


void init_w( Matrix& m ){
	for(int i=0; i<m.h; i++)
		for(int j=0; j<m.w; j++){
			float r = (float)rand()/RAND_MAX;
			if( r<0.1 )
				m[i][j] = -0.47;
			else if( r<0.2 )
				m[i][j] = 0.47;
			else
				m[i][j] = 0;
		}
}


void init_wIn( Matrix& m ){
	for(int i=0; i<m.h; i++)
		for(int j=0; j<m.w; j++){
			float r = (float)rand()/RAND_MAX;
			if( r<0.5 )
				m[i][j] = -0.1;
			else
				m[i][j] = 0.1;
		}
}


void init_wOut( Matrix& m ){
	for( int i=0; i<m.h; i++ )
		for( int j=0; j<m.w; j++ ){
			float r = (float)rand()/RAND_MAX;
			m[i][j] = 2*(r-0.5);
		}
}

void init_state( Vector& v ){
	for( int i=0; i<v.size; i++ )
		v.val[i] = (NUM)rand()/RAND_MAX;
}

Vector vecBias(1);

struct net {
	Matrix v;
	Matrix m;
	Matrix w;
	Vector netHidden;
	Vector netOut;
	Vector y;
	Vector x;
	Vector o;
	Vector dNetHidden;
	Vector dNetOut;
	Vector delta;
	//
	Vector oTemp;
	Vector xy;
	Vector xy2;
};	

void initNet( net& n){
	//matice vah
	n.v = Matrix( dimJ, dimI );
	n.m = Matrix( dimJ, dimJ );
	n.w = Matrix( dimK, dimIJ+1 );
	init_wIn( n.v );
	init_w( n.m );
	init_wOut( n.w );
	//stav
	n.y = Vector(dimJ);
	init_state(n.y);
	//vystup a pomocne vektory
	n.o = Vector(dimK);
	n.oTemp = Vector(dimK);
	n.xy = Vector(dimIJ);
	n.xy2 = Vector(dimIJ+1);
	//aloku vektor pre delty
	n.delta = Vector(dimK);
	vecBias.val[0] = 0;
}


void resetState( net& n ){
	//zresetujeme stav
	int j;
	for( j=0; j<dimJ; j++)
		n.y.val[j] = 0.0;//rand2();
}

Vector activate( net& n ){
	Vector p1 = n.v*n.x;
	Vector p2 = n.m*n.y;
	Vector res(dimJ);
	int j;
	for( j=0; j<dimJ; j++ )
		res.val[j] = p1.val[j] + p2.val[j];
	return res;
}

#include "netReadWrite.h"


Vector getActivities( char* inputStr, net& n ){
	//spocitat novy vnutorny stav
	n.x = getSyllabe( inputStr );
	n.netHidden = activate( n );
	n.y = Sigmoid( n.netHidden );
	//vypocitat vystup
	n.xy = (n.x,n.y);
	n.xy2 = (n.xy, vecBias );
	n.netOut = n.w*n.xy2;
	//SOFTMAX//n.o = Sigmoid( n.netOut );
	n.o = softMax( n.netOut );
	return n.o;
}

#include "testWord.h"


void train( net& n ){
	initInput();
	resetState(n);

	Vector oldY(0);
	Vector d(0);
	int t,i,j,k;

	int trainMax = (inputLen-1)*WORDSEG;
	int progressUnit = trainMax/20;
	for( i=0; i<trainMax/progressUnit; i++ )
		cout<<"*"<<flush;
	cout<<endl;

	//pociatocny prechod
	for( t=0; t<transTime*WORDSEG; t++ ){
		getActivities( getInputStr(t), n );
	}

	//trenovanie
	for( t=0; t<trainMax; t++ ){
		//resetovanie stavu, ak sme na hranici slov
		if( t % WORDSEG == 0)
			RESET_STATEMENT
		//progres
		if( t%progressUnit == (progressUnit-1) )
			cout<<"*"<<flush;
		oldY = n.y;
		getActivities( getInputStr(t), n );
		d = getOutput(t);
		//SOFTMAX//n.dNetOut = DerivSigm( n.o );

		//upravit vahy delta pravidlom
		for( k=0; k<dimK; k++){
			//spocitame delta_ok
			//SOFTMAX//n.delta.val[k] = (d.val[k]-n.o.val[k]) * n.dNetOut.val[k];
			n.delta.val[k] = (d.val[k]-n.o.val[k]);
			//alpha
			n.delta.val[k] = n.delta.val[k] * alpha;
			for( j=0; j<dimIJ+1; j++ ){
				n.w[k][j] = n.w[k][j] + n.delta.val[k]*n.xy2.val[j];
			}
		}
	}
	cout<<endl;
}


void test(net& n, int testSetCount = testSets){
	int wordNum;
	int i,t,k;
	Vector d(0);

	//premenne na sledovanie chyb
	int errCount = 0;
	int errCountMod[WORDSEG];
	int countMod[WORDSEG];
	//vynulujeme polia
	for( i=0; i<WORDSEG; i++ ){
		errCountMod[i] = 0;
		countMod[i] = 0;
	}
	//abs. chyba
	float errAbs = 0;

	int testLen = testSetCount * WORDCOUNT;
	initInput( testLen );

	for( t=0; t<testLen*WORDSEG; t++ ){
		//resetovanie stavu, ak sme na hranici slov	
		if( t % WORDSEG == 0)
			RESET_STATEMENT
	
		getActivities( getInputStr(t), n );
		d = getOutput(t);

		wordNum = applyDiscriminatorNum( applyOneHotFilter(n.o) );
		if(wordNum!=-1){
			if(!(codeWords[wordNum]==d)){
				errCountMod[t%WORDSEG]++;					
				errCount++;
			}
			countMod[t%WORDSEG]++;
		}

		errAbs += d.dist( n.o );
	}
	cout<<"Chyby:";
	for( k=0; k<WORDSEG; k++)
		cout<<"  "<<errCountMod[k]<<"/"<<countMod[k];
	cout<<endl;
	cout<<"Abs. chyba: "<<(errAbs/testLen)<<endl;
}



	


int main(int argc, char* argv[])
{
	unsigned int seed =(unsigned)time( NULL );
	srand(seed);

	Vector input(dimI);
	Vector d(dimK);
	int i;
	char buf[WORDSIZE+1];

	initCodeWords();

	net n;
	initNet(n);
	
	//TESTOVANIE NATRENOVANEJ SIETE
	if(argc>1){
		ReadNet( n, argv[1] );
		
		#include "test.h"

		return 0;
	}


	//TRENOVANIE
	int epoch;
	char net_fileName[100];
	for( epoch=0; epoch<EPOCH_COUNT; epoch++ ){
		cout<<"epocha "<<epoch<<endl;
		train(n);

		Vector tmp = n.y;
		test(n,1);

		if(epoch%10==0){
			for( i=0; i<WORDCOUNT && i<1000; i++){
				RESET_STATEMENT
				testWord( arrWords[i], n);
			}
			cout<<"----------------------------"<<endl;
			#include "test.h"
		}
		n.y = tmp;
		//zapis siet
		if( ((epoch+1)==5) || ((epoch+1)==10) || ((epoch+1)==20) || ((epoch+1)==50) ){
			sprintf( net_fileName, "%s%d.net", NET_FILENAME, (epoch+1) );
			cout<<"Zapisujem subor "<<net_fileName<<endl;
			WriteNet( n, net_fileName );
		}
	}
	sprintf( net_fileName, "%s%d.net", NET_FILENAME, epoch );
	cout<<"Zapisujem subor "<<net_fileName<<endl;
	WriteNet( n, net_fileName );

	cout<<"trenovanie ukoncene"<<endl;
	cout<<endl;


//TESTOVANIE
	test(n);
	cout<<endl;
	cout<<"-------------------------------"<<endl;
	cout<<"epoch count: "<<EPOCH_COUNT<<endl;
	cout<<"inputLen "<<inputLen<<endl;
	cout<<"EXP_NO "<<EXP_NO<<endl;
	cout<<"pocet skrytych neuronov "<<dimJ<<endl;
	cout<<"\t <random seed "<<seed<<">"<<endl;

	delete []inputSeq;
	return 0;
}

