#include "matrix.h"
#include "echostate.h"
#include EXP_NO
#include "input.h"

vector<Vector> codeWords;
vector<Vector> arrCons;
vector<Vector> arrVoc;



#define inputLen (inputSets*WORDCOUNT)
using namespace std;

char *inputSeq = new char[inputLen*WORDSIZE];

void shuffleSeq( int* seq, int seqLen){
	int tmpNdx, randNdx, i;
	for( i=0; i<seqLen; i++ ){
		randNdx = rand()%seqLen;
		tmpNdx = seq[i];
		seq[i] = seq[randNdx];
		seq[randNdx] = tmpNdx;
	}
}


//#define BIPOLAR_SIGMOID
#ifdef BIPOLAR_SIGMOID
	inline NUM sigmoid( NUM z ){
		z = LAMBDA*z;
		return ( 2/ (1+exp(-z)))-1;
	}

	inline NUM derivSigm( NUM z ){
		return LAMBDA*0.5*(1-z*z);
	}
#else
	inline NUM sigmoid( NUM z ){
		z = LAMBDA*z;
		return 1 / (1+exp(-z));
	}

	inline NUM derivSigm( NUM z ){
		return LAMBDA*z*(1-z);
	}
#endif



void initCodeWords(void){
	int i;
	//kodove slabiky
	for( i=0; i<L_ARRSYL; i++ ){
		codeWords.push_back( getSyllabe(arrSyl[i]) );
	}

}

void initInput(long length){
	assert(inputLen>=length);
	int i;
	int *inputNdx = new int[inputLen];
	int lastNum = -1;
	int thisNum = -1;
	for( i=0; i<length; i++ ){
//		while( lastNum == thisNum )
			thisNum = rand()%WORDCOUNT;
		inputNdx[i] = thisNum;
		thisNum = lastNum;
	}

	for( i=0; i<length; i++ ){
		memcpy( inputSeq+WORDSIZE*i, arrWords[inputNdx[i]], WORDSIZE*sizeof(char) );
	}

	delete []inputNdx;

}

int applyDiscriminatorNum( Vector v){
	int ndx = 0;
	NUM minErr = v.dist(codeWords[ndx]);
	NUM err;
	for( int i=1; i<codeWords.size(); i++ ){
		err = v.dist(codeWords[i]);
		if(err<minErr){
			minErr = err;
			ndx = i;
		}
	}
	if(minErr<0.0001)
		return ndx;		
	else
		return -1;
}


Vector applyToleranceFilter( Vector &v, NUM tol ){
	Vector r = v;
	for( int i=0; i<r.size; i++ ){
		if( fabs(r.val[i])<tol )
			r.val[i] = 0;
		else
		if( fabs(r.val[i]-1)<tol )
			r.val[i] = 1;
	}
	return r;
}


Vector Sigmoid( Vector v){
	for(int i=0; i<v.size; i++)
		v.val[i] = sigmoid( v.val[i] );
	return v;
}

Vector DerivSigm( Vector v){
	for(int i=0; i<v.size; i++)
		v.val[i] = derivSigm( v.val[i] );
	return v;
}


Vector softMax( Vector v ){
	int i;
	NUM sumE = 0;
	for(i=0; i<v.size; i++){
		v.val[i] = exp( v.val[i] );
		sumE = sumE + v.val[i];
	}
	for(i=0; i<v.size; i++){
		v.val[i] = v.val[i]/sumE;
	}
	return v;
}



Vector getInput(int t){
	return getSyllabe( SEEK( inputSeq, t ) );
}

Vector getOutput(int t){
	return getInput( t+1 );
}

char * getInputStr(int t){
	return SEEK( inputSeq, t );
}

char * getOutputStr(int t){
	return getInputStr(t+1);
}

void getIndexPair( int& n1, int& n2 ){
	int index1 = rand()%WORDCOUNT;
	int index2 = index1;
	while( (index2%FRAMECOUNT) == (index1%FRAMECOUNT) )
		index2 = rand()%WORDCOUNT;
	n1 = index1;
	n2 = index2;
}



int compare( const void *arg1, const void *arg2 ){
	NUM a1 = *((NUM*)arg1);
	NUM a2 = *((NUM*)arg2);
	if( a1<a2 ) return 1;
	else if (a2<a1) return -1;
	else return 0;
}

