#ifndef matrix_h
#define matrix_h


#include <memory>
#include <iostream>
#include <vector>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>	
#include <math.h>
#include <time.h>
#include <assert.h>


#define OP_DIV 0
#define OP_ADD 1

#define J_SIZE 2
#define E_ZERO 1e-100
#define E_ZERO2 1e-10


using namespace std;
#define NUM double

struct jItem {
	int op;
	int destNdx;
	int srcNdx;
	NUM coef;
};

class Vector{
 public:
	 int size;
	 NUM* val;
	 
	 Vector operator , (const Vector& v);
	 void operator = (const Vector& v);
	 bool operator == (const Vector& v);
	 void print();
	 void print2();
	 int print3(NUM tol);
	 void print4();
	 int print5();
	 void addNoise(float ammount);
	 NUM sumVal();

	 NUM dist(const Vector& v);

	 Vector( const Vector& v);
	 Vector( int _size=0 );
	 ~Vector();
};

class Matrix{
 public:
	int w;
	int h;
	NUM** val;

    NUM* operator [] (int ndx); 
	Vector operator *( Vector& v);
	Matrix operator * (Matrix& m);
	Matrix operator ! ();
	Matrix invert();
	void setIdent();

	void rowDiv( int ndx, NUM coef );
	void rowAdd( int destNdx, int srcNdx, NUM coef );
	void colDiv( int ndx, NUM coef );
	void colAdd( int destNdx, int srcNdx, NUM coef );

	void operator = (const Matrix& m);

	void print();
	void printClean();
	bool isIdent();

	Matrix( int _h=0, int _w=0 );
	Matrix( const Matrix& m );
	~Matrix();
};

#endif
