from toycalc.lex import tokenizer

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [INITIAL[(start_nt or 'program', close_with or 'EOF')]]
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        action = TABLE[stack[-1]].get(token.type)

        if action is None:
            nonterminals = { nt for nt, right, action in RULES }
            choices = { repr(k) for k in TABLE[stack[-1]] if k not in nonterminals }
            raise ParseError(token.location, "Unexpected {}, expected {}".format(
                repr(token.type), ', '.join(sorted(choices))))

        is_shift, action_value = action

        if is_shift:
            results.append(token)
            stack.append(action_value)
            token = next(tok_iter)
        else:
            if action_value is None: break
            left, right, rule_action = RULES[action_value]
            n = len(right)

            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(rule_action(ctx, *args))

            del stack[len(stack) - n:]
            new_is_shift, new_state = TABLE[stack[-1]][left]
            assert new_is_shift
            stack.append(new_state)

    return results[0]

INITIAL = {('program', 'EOF'): 0}
RULES = [('sum', ('sum', '+', 'product'), 
(lambda ctx, a, op, b: a + b)
), ('sum', ('sum', '-', 'product'), 
(lambda ctx, a, op, b: a - b)
), ('sum', ('product',), 
(lambda ctx, e: e)
), ('statement', ('sum',), 
(lambda ctx, e: print(e))
), ('power', ('value', '^', 'factor'), 
(lambda ctx, a, op, b: a ** b)
), ('power', ('value',), 
(lambda ctx, e: e)
), ('factor', ('-', 'factor'), 
(lambda ctx, op, e: -e)
), ('factor', ('power',), 
(lambda ctx, e: e)
), ('product', ('product', '*', 'factor'), 
(lambda ctx, a, op, b: a * b)
), ('product', ('product', '/', 'factor'), 
(lambda ctx, a, op, b: a // b)
), ('product', ('factor',), 
(lambda ctx, e: e)
), ('value', ('NUMBER',), 
(lambda ctx, t: t.value)
), ('value', ('(', 'sum', ')'), 
(lambda ctx, l, e, r: e)
), ('program', ('statement', ';', 'program'), 
(lambda ctx, a, b, c: None)
), ('program', (), 
(lambda ctx: None)
)]
TABLE = [{'value': (True, 9), '-': (True, 1), 'sum': (True, 2), 'statement': (True, 6), 'factor': (True, 4), 'power': (True, 5), 'EOF': (False, 14), 'product': (True, 7), '(': (True, 8), 'NUMBER': (True, 3), 'program': (True, 10)}, {'-': (True, 1), 'value': (True, 9), 'power': (True, 5), 'factor': (True, 26), '(': (True, 8), 'NUMBER': (True, 3)}, {';': (False, 3), '-': (True, 27), '+': (True, 28)}, {'-': (False, 11), ';': (False, 11), '*': (False, 11), '/': (False, 11), '^': (False, 11), '+': (False, 11)}, {'+': (False, 10), '-': (False, 10), ';': (False, 10), '*': (False, 10), '/': (False, 10)}, {'+': (False, 7), '-': (False, 7), ';': (False, 7), '*': (False, 7), '/': (False, 7)}, {';': (True, 33)}, {'+': (False, 2), '-': (False, 2), ';': (False, 2), '*': (True, 35), '/': (True, 36)}, {'-': (True, 11), 'sum': (True, 12), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 15), 'product': (True, 16), '(': (True, 17), 'NUMBER': (True, 13)}, {'-': (False, 5), ';': (False, 5), '*': (False, 5), '/': (False, 5), '^': (True, 22), '+': (False, 5)}, {'EOF': (False, None)}, {'-': (True, 11), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 37), '(': (True, 17), 'NUMBER': (True, 13)}, {')': (True, 38), '+': (True, 30), '-': (True, 31)}, {'-': (False, 11), '*': (False, 11), '/': (False, 11), ')': (False, 11), '^': (False, 11), '+': (False, 11)}, {')': (False, 7), '+': (False, 7), '*': (False, 7), '/': (False, 7), '-': (False, 7)}, {')': (False, 10), '+': (False, 10), '*': (False, 10), '/': (False, 10), '-': (False, 10)}, {')': (False, 2), '+': (False, 2), '*': (True, 19), '/': (True, 20), '-': (False, 2)}, {'-': (True, 11), 'sum': (True, 23), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 15), 'product': (True, 16), '(': (True, 17), 'NUMBER': (True, 13)}, {')': (False, 5), '*': (False, 5), '/': (False, 5), '-': (False, 5), '^': (True, 25), '+': (False, 5)}, {'-': (True, 11), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 21), '(': (True, 17), 'NUMBER': (True, 13)}, {'-': (True, 11), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 32), '(': (True, 17), 'NUMBER': (True, 13)}, {'-': (False, 8), '+': (False, 8), '*': (False, 8), '/': (False, 8), ')': (False, 8)}, {'-': (True, 1), 'value': (True, 9), 'power': (True, 5), 'factor': (True, 24), '(': (True, 8), 'NUMBER': (True, 3)}, {')': (True, 29), '+': (True, 30), '-': (True, 31)}, {'+': (False, 4), '-': (False, 4), ';': (False, 4), '*': (False, 4), '/': (False, 4)}, {'-': (True, 11), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 39), '(': (True, 17), 'NUMBER': (True, 13)}, {';': (False, 6), '-': (False, 6), '+': (False, 6), '*': (False, 6), '/': (False, 6)}, {'-': (True, 1), 'value': (True, 9), 'factor': (True, 4), 'power': (True, 5), 'product': (True, 40), '(': (True, 8), 'NUMBER': (True, 3)}, {'-': (True, 1), 'value': (True, 9), 'factor': (True, 4), 'power': (True, 5), 'product': (True, 41), '(': (True, 8), 'NUMBER': (True, 3)}, {'-': (False, 12), '*': (False, 12), '/': (False, 12), ')': (False, 12), '^': (False, 12), '+': (False, 12)}, {'-': (True, 11), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 15), 'product': (True, 42), '(': (True, 17), 'NUMBER': (True, 13)}, {'-': (True, 11), 'value': (True, 18), 'power': (True, 14), 'factor': (True, 15), 'product': (True, 43), '(': (True, 17), 'NUMBER': (True, 13)}, {')': (False, 9), '+': (False, 9), '*': (False, 9), '/': (False, 9), '-': (False, 9)}, {'value': (True, 9), '-': (True, 1), 'sum': (True, 2), 'statement': (True, 6), 'factor': (True, 4), 'power': (True, 5), 'EOF': (False, 14), 'product': (True, 7), '(': (True, 8), 'NUMBER': (True, 3), 'program': (True, 34)}, {'EOF': (False, 13)}, {'-': (True, 1), 'value': (True, 9), 'power': (True, 5), 'factor': (True, 44), '(': (True, 8), 'NUMBER': (True, 3)}, {'-': (True, 1), 'value': (True, 9), 'power': (True, 5), 'factor': (True, 45), '(': (True, 8), 'NUMBER': (True, 3)}, {')': (False, 6), '+': (False, 6), '*': (False, 6), '/': (False, 6), '-': (False, 6)}, {'-': (False, 12), ';': (False, 12), '*': (False, 12), '/': (False, 12), '^': (False, 12), '+': (False, 12)}, {'-': (False, 4), '+': (False, 4), '*': (False, 4), '/': (False, 4), ')': (False, 4)}, {';': (False, 1), '-': (False, 1), '+': (False, 1), '*': (True, 35), '/': (True, 36)}, {'+': (False, 0), '-': (False, 0), ';': (False, 0), '*': (True, 35), '/': (True, 36)}, {'-': (False, 0), '+': (False, 0), '*': (True, 19), '/': (True, 20), ')': (False, 0)}, {')': (False, 1), '+': (False, 1), '*': (True, 19), '/': (True, 20), '-': (False, 1)}, {'+': (False, 8), '-': (False, 8), ';': (False, 8), '*': (False, 8), '/': (False, 8)}, {';': (False, 9), '-': (False, 9), '+': (False, 9), '*': (False, 9), '/': (False, 9)}]
