from toycalc.lex import tokenizer

handlers = {
    "+": lambda l, r: l + r,
    "-": lambda l, r: l - r,
    "*": lambda l, r: l * r,
    "/": lambda l, r: l // r,
}

def left_associative(l, ops, rs):
    for op, r in zip(ops, rs):
        handler = handlers[op.type]
        l = handler(l, r)
    return l

from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [close_with or 'EOF', start_nt or 'program']
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        stack_top = stack[-1]

        if isinstance(stack_top, int):
            rule, action = RULES[stack_top]
            stack.pop()
            n = len(rule)
            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(action(ctx, *args))

        elif stack_top not in TABLE:
            if token.type != stack_top:
                raise ParseError(token.location, "Expected " + stack_top)
            stack.pop()
            if not stack: break
            results.append(token)
            token = next(tok_iter)

        else:
            row = TABLE[stack_top]
            if token.type not in row:
                raise ParseError(token.location, "Unexpected {}, expected {}".format(
                    repr(token.type), ', '.join(sorted(repr(k) for k in row))))
            rule_num = row[token.type]
            rule, action = RULES[rule_num]
            stack.pop()
            stack.append(rule_num)
            stack.extend(reversed(rule))

    return results[0]

RULES = [(('product', 'sum__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda _ctx, _loc, rs, ops, _all, l: (
left_associative(l, ops, rs)
), normal_vars=['l'], list_vars=['ops', 'rs']))
), (('^', 'factor'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('-', 'factor'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('e', v2)], user=lambda _ctx, e, _loc, _all: (
-e
), normal_vars=['e'], list_vars=[]))
), (('power',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _loc, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('factor', 'product__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda _ctx, _loc, rs, ops, _all, l: (
left_associative(l, ops, rs)
), normal_vars=['l'], list_vars=['ops', 'rs']))
), (('sum__2', 'product', 'sum__1'), 
(lambda ctx, v1, v2, v3: [v1, ('rs', v2), v3])
), ((), 
(lambda ctx: [])
), (('statement', ';', 'program__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('sum',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _loc, _all: (
print(e)
), normal_vars=['e'], list_vars=[]))
), (('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda t, _ctx, _loc, _all: (
t.value
), normal_vars=['t'], list_vars=[]))
), (('(', 'sum', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _ctx, e, _loc, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('program__1',), 
(combine_action(root=lambda ctx, v1: [v1], user=lambda _ctx, _loc, _all: (
None
), normal_vars=[], list_vars=[]))
), (('value', 'power__1'), 
(combine_action(root=lambda ctx, v1, v2: [('a', v1), v2], user=lambda _all, _ctx, a, b, _loc: (
a if b is None else a ** b
), normal_vars=['a', 'b'], list_vars=[]))
), (('product__2', 'factor', 'product__1'), 
(lambda ctx, v1, v2, v3: [v1, ('rs', v2), v3])
), ((), 
(lambda ctx: [])
), (('*',), 
(lambda ctx, v1: [('ops', v1)])
), (('/',), 
(lambda ctx, v1: [('ops', v1)])
), (('+',), 
(lambda ctx, v1: [('ops', v1)])
), (('-',), 
(lambda ctx, v1: [('ops', v1)])
)]
TABLE = {'sum': {'(': 0, '-': 0, 'NUMBER': 0}, 'power__1': {'^': 1, ';': 2, '*': 2, '/': 2, ')': 2, '-': 2, '+': 2}, 'factor': {'(': 4, '-': 3, 'NUMBER': 4}, 'product': {'(': 5, '-': 5, 'NUMBER': 5}, 'sum__1': {'-': 6, ';': 7, '+': 6, ')': 7}, 'program__1': {'(': 8, '-': 8, 'NUMBER': 8, 'EOF': 9}, 'statement': {'(': 10, '-': 10, 'NUMBER': 10}, 'value': {'(': 12, 'NUMBER': 11}, 'program': {'(': 13, '-': 13, 'NUMBER': 13, 'EOF': 13}, 'power': {'(': 14, 'NUMBER': 14}, 'product__1': {'-': 16, '*': 15, '/': 15, ')': 16, ';': 16, '+': 16}, 'product__2': {'*': 17, '/': 18}, 'sum__2': {'-': 20, '+': 19}}
