from toycalc.lex import tokenizer
from toycalc.ast import *

handlers = {
    "+": Add,
    "-": Sub,
    "*": Mul,
    "/": Div,
}

def left_associative(l, ops, rs):
    for op, r in zip(ops, rs):
        handler = handlers[op.type]
        l = handler(op.location, l, r)
    return l

from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [close_with or 'EOF', start_nt or 'expr']
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        stack_top = stack[-1]

        if isinstance(stack_top, int):
            rule, action = RULES[stack_top]
            stack.pop()
            n = len(rule)
            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(action(ctx, *args))

        elif stack_top not in TABLE:
            if token.type != stack_top:
                raise ParseError(token.location, "Expected " + stack_top)
            stack.pop()
            if not stack: break
            results.append(token)
            token = next(tok_iter)

        else:
            row = TABLE[stack_top]
            if token.type not in row:
                raise ParseError(token.location, "Unexpected {}, expected {}".format(
                    repr(token.type), ', '.join(sorted(repr(k) for k in row))))
            rule_num = row[token.type]
            rule, action = RULES[rule_num]
            stack.pop()
            stack.append(rule_num)
            stack.extend(reversed(rule))

    return results[0]

RULES = [(('-', 'factor'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('e', v2)], user=lambda _ctx, e, _all, _loc: (
UnaryMin(_loc, e)
), normal_vars=['e'], list_vars=[]))
), (('power',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), (('product__2', 'factor', 'product__1'), 
(lambda ctx, v1, v2, v3: [v1, ('rs', v2), v3])
), ((), 
(lambda ctx: [])
), (('sum',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), (('+',), 
(lambda ctx, v1: [('ops', v1)])
), (('-',), 
(lambda ctx, v1: [('ops', v1)])
), (('^', 'factor'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('product', 'sum__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda ops, _ctx, rs, _all, _loc, l: (
left_associative(l, ops, rs)
), normal_vars=['l'], list_vars=['ops', 'rs']))
), (('sum__2', 'product', 'sum__1'), 
(lambda ctx, v1, v2, v3: [v1, ('rs', v2), v3])
), ((), 
(lambda ctx: [])
), (('factor', 'product__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda ops, _ctx, rs, _all, _loc, l: (
left_associative(l, ops, rs)
), normal_vars=['l'], list_vars=['ops', 'rs']))
), (('value', 'power__1'), 
(combine_action(root=lambda ctx, v1, v2: [('a', v1), v2], user=lambda _ctx, a, b, _all, _loc: (
a if b is None else Pow(_loc, a, b)
), normal_vars=['a', 'b'], list_vars=[]))
), (('*',), 
(lambda ctx, v1: [('ops', v1)])
), (('/',), 
(lambda ctx, v1: [('ops', v1)])
), (('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _ctx, n, _all, _loc: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
Embedded(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), (('(', 'sum', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=['e'], list_vars=[]))
)]
TABLE = {'factor': {'EMBEDEXPR': 1, '(': 1, 'NUMBER': 1, '-': 0}, 'sum': {'EMBEDEXPR': 9, '(': 9, 'NUMBER': 9, '-': 9}, 'expr': {'EMBEDEXPR': 4, '(': 4, 'NUMBER': 4, '-': 4}, 'sum__2': {'+': 5, '-': 6}, 'product__1': {'+': 3, ':)': 3, '-': 3, '/': 2, ')': 3, '*': 2}, 'sum__1': {'+': 10, ')': 11, '-': 10, ':)': 11}, 'product': {'EMBEDEXPR': 12, '(': 12, 'NUMBER': 12, '-': 12}, 'power': {'EMBEDEXPR': 13, '(': 13, 'NUMBER': 13}, 'product__2': {'*': 14, '/': 15}, 'value': {'EMBEDEXPR': 17, '(': 18, 'NUMBER': 16}, 'power__1': {'+': 8, ':)': 8, '-': 8, '/': 8, ')': 8, '*': 8, '^': 7}}
