
from context import flatten
from toylua.lex import tokenizer
from toylua.ast import *


def values(tokens):
    return [t.value for t in tokens]

def assignment_or_functioncall(exps, assignment):
    # Assignments and function calls use the same grammar rule, to keep it LL.
    # Based on exprstat() and assignment() in lparser.c.
    if not assignment:
        if not isinstance(exps[0], FunctionCall):
            raise ParseError(exps[0].location, 'Expected assignment or function call')
        return exps[0]
    else:
        for e in exps:
            if not isinstance(e, (Name, Dot, Brackets)):
                raise ParseError(e.location, 'Invalid lvalue')
        return Assignment(exps[0].location, exps, assignment)

def process_suffixedexp(base, suffixes):
    for suffix_fn in suffixes:
        base = suffix_fn(base)
    return base

def left_associative(symbols):
    symbols = iter(symbols)
    left = next(symbols)
    while True:
        try:
            op = next(symbols)
            right = next(symbols)
            left = BinOp(op.location, left, op.type, right)
        except StopIteration:
            return left

def check_key(e, errloc):
    if not isinstance(e, Name):
        raise ParseError(errloc, "Unexpected '='")
    return String(e.location, e.name)


from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [close_with or 'EOF', start_nt or 'chunk']
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        stack_top = stack[-1]

        if isinstance(stack_top, int):
            rule, action = RULES[stack_top]
            stack.pop()
            n = len(rule)
            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(action(ctx, *args))

        elif stack_top not in TABLE:
            if token.type != stack_top:
                raise ParseError(token.location, "Expected " + stack_top)
            stack.pop()
            if not stack: break
            results.append(token)
            token = next(tok_iter)

        else:
            row = TABLE[stack_top]
            if token.type not in row:
                raise ParseError(token.location, "Unexpected {}, expected {}".format(
                    repr(token.type), ', '.join(sorted(repr(k) for k in row))))
            rule_num = row[token.type]
            rule, action = RULES[rule_num]
            stack.pop()
            stack.append(rule_num)
            stack.extend(reversed(rule))

    return results[0]

RULES = [(('exp7__1', 'exp7'), 
(combine_action(root=lambda ctx, v1, v2: [v1, ('e', v2)], user=lambda _loc, _all, _ctx, e, op: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), (('exp8',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _all, e, _ctx: (
e
), normal_vars=['e'], list_vars=[]))
), (('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), (('NAME', 'parlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('n', v1), v2], user=lambda _loc, p, _all, _ctx, n: (
[n.value, p or []]
), normal_vars=['n', 'p'], list_vars=[]))
), (('.', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [('d', v1), ('n', v2)], user=lambda _loc, _all, d, _ctx, n: (
lambda left: Dot(d.location, left, n.value)
), normal_vars=['d', 'n'], list_vars=[]))
), (('[', 'exp', ']'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('d', v1), ('e', v2), (None, v3)], user=lambda _loc, _all, d, e, _ctx: (
lambda left: Brackets(d.location, left, e)
), normal_vars=['d', 'e'], list_vars=[]))
), ((':', 'NAME', 'args'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('d', v1), ('n', v2), ('a', v3)], user=lambda _loc, _all, d, a, _ctx, n: (
lambda left: FunctionCall(d.location, left, n.value, a[1])
), normal_vars=['a', 'd', 'n'], list_vars=[]))
), (('args',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda _loc, _all, a, _ctx: (
lambda left: FunctionCall(a[0], left, None, a[1])
), normal_vars=['a'], list_vars=[]))
), (('^', 'exp7'), 
(lambda ctx, v1, v2: [('op', v1), ('r', v2)])
), ((), 
(lambda ctx: [])
), (('{', 'tableconstructor__1', '}'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _loc, _all, _ctx, f: (
TableConstructor(_loc, flatten(f))
), normal_vars=['f'], list_vars=[]))
), (('function', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('b', v2)], user=lambda _loc, b, _all, _ctx: (
Function(_loc, None, b[0], b[1])
), normal_vars=['b'], list_vars=[]))
), (('exp4', 'exp3__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _all, _ctx: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('<',), 
(lambda ctx, v1: [(None, v1)])
), (('>',), 
(lambda ctx, v1: [(None, v1)])
), (('<=',), 
(lambda ctx, v1: [(None, v1)])
), (('>=',), 
(lambda ctx, v1: [(None, v1)])
), (('~=',), 
(lambda ctx, v1: [(None, v1)])
), (('==',), 
(lambda ctx, v1: [(None, v1)])
), (('exp7', 'exp6__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _all, _ctx: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), ((';',), 
(lambda ctx, v1: [(None, v1)])
), ((), 
(lambda ctx: [])
), (('suffixedexp_suffix', 'suffixedexp__1'), 
(lambda ctx, v1, v2: [('s', v1), v2])
), ((), 
(lambda ctx: [])
), (('=', 'exp', ',', 'exp', 'stat_for__1', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7, v8: [(None, v1), ('e1', v2), (None, v3), ('e2', v4), v5, (None, v6), ('b', v7), (None, v8)], user=lambda e1, _loc, _all, e3, _ctx, b, e2: (
lambda loc, n: NumericFor(loc, n, e1, e2, e3, b)
), normal_vars=['b', 'e1', 'e2', 'e3'], list_vars=[]))
), (('stat_for__2', 'in', 'explist', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6: [v1, (None, v2), ('e', v3), (None, v4), ('b', v5), (None, v6)], user=lambda _loc, _all, e, _ctx, b, n: (
lambda loc, n1: GenericFor(loc, values([n1]+n), e, b)
), normal_vars=['b', 'e'], list_vars=['n']))
), ((':', 'NAME'), 
(lambda ctx, v1, v2: [(None, v1), ('c', v2)])
), ((), 
(lambda ctx: [])
), (('(', 'args__1', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _loc, _all, e, _ctx: (
(_loc, e or [])
), normal_vars=['e'], list_vars=[]))
), (('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda t, _loc, _all, _ctx: (
(t.location, [t])
), normal_vars=['t'], list_vars=[]))
), (('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _loc, _all, s, _ctx: (
(s.location, [s.value])
), normal_vars=['s'], list_vars=[]))
), (('[', 'exp', ']', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('k', v2), (None, v3), (None, v4), ('v', v5)], user=lambda _loc, _all, k, v, _ctx: (
Field(_loc, k, v)
), normal_vars=['k', 'v'], list_vars=[]))
), (('exp', 'field__1'), 
(combine_action(root=lambda ctx, v1, v2: [('a', v1), v2], user=lambda _loc, b, _all, a, _ctx: (
Field(a.location, check_key(a, _loc), b) if b else Field(a.location, None, a)
), normal_vars=['a', 'b'], list_vars=[]))
), (('and', 'exp3', 'exp2__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('::', 'NAME', '::'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), (None, v3)], user=lambda _loc, _all, _ctx, n: (
Label(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ((';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
None
), normal_vars=[], list_vars=[]))
), (('suffixedexp', 'stat__1'), 
(combine_action(root=lambda ctx, v1, v2: [('p', v1), v2], user=lambda _loc, p, _all, a, _ctx: (
assignment_or_functioncall(p, a)
), normal_vars=['a'], list_vars=['p']))
), (('label',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _loc, _all, s, _ctx: (
s
), normal_vars=['s'], list_vars=[]))
), (('break',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
Break(_loc)
), normal_vars=[], list_vars=[]))
), (('goto', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('n', v2)], user=lambda _loc, _all, _ctx, n: (
Goto(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('b', v2), (None, v3)], user=lambda _loc, b, _all, _ctx: (
BlockStatement(_loc, b)
), normal_vars=['b'], list_vars=[]))
), (('while', 'exp', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), (None, v5)], user=lambda _loc, b, _all, e, _ctx: (
While(_loc, e, b)
), normal_vars=['b', 'e'], list_vars=[]))
), (('repeat', 'block', 'until', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), ('b', v2), (None, v3), ('e', v4)], user=lambda _loc, b, _all, e, _ctx: (
Repeat(_loc, b, e)
), normal_vars=['b', 'e'], list_vars=[]))
), (('if', 'exp', 'then', 'block', 'stat__3', 'stat__4', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5, v6, (None, v7)], user=lambda _loc, b, _all, e, _ctx: (
If(_loc, e, b)
), normal_vars=[], list_vars=['b', 'e']))
), (('for', 'NAME', 'stat_for'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('s', v3)], user=lambda _loc, _all, _ctx, s, n: (
s(_loc, n)
), normal_vars=['n', 's'], list_vars=[]))
), (('function', 'funcname', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda _loc, b, _all, _ctx, n: (
Function(_loc, n, b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), (('local', 'stat_local'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('s', v2)], user=lambda _loc, _all, s, _ctx: (
s(_loc)
), normal_vars=['s'], list_vars=[]))
), (('EMBEDSTAT',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _all, e, _ctx: (
EmbedStatement(e.location, e.value)
), normal_vars=['e'], list_vars=[]))
), (('NAME',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _loc, _all, _ctx, n: (
Name(n.location, n.value)
), normal_vars=['n'], list_vars=[]))
), (('(', 'exp', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _loc, _all, e, _ctx: (
e
), normal_vars=['e'], list_vars=[]))
), (('else', 'block'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('exp', 'explist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda _loc, _all, e, _ctx: (
e
), normal_vars=[], list_vars=['e']))
), (('or', 'exp2', 'exp__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('exp6__2', 'exp7', 'exp6__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('(', 'funcbody__1', ')', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), v2, (None, v3), ('b', v4), (None, v5)], user=lambda _loc, b, _all, a, _ctx: (
(flatten(a), b)
), normal_vars=['a', 'b'], list_vars=[]))
), (('..', 'exp4'), 
(lambda ctx, v1, v2: [('op', v1), ('r', v2)])
), ((), 
(lambda ctx: [])
), ((',',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
None
), normal_vars=[], list_vars=[]))
), ((';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
None
), normal_vars=[], list_vars=[]))
), (('*',), 
(lambda ctx, v1: [(None, v1)])
), (('/',), 
(lambda ctx, v1: [(None, v1)])
), (('%',), 
(lambda ctx, v1: [(None, v1)])
), ((',', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('e3', v2)])
), ((), 
(lambda ctx: [])
), (('return', 'retstat__1', 'retstat__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, v3], user=lambda _loc, _all, e, _ctx: (
Return(_loc, e)
), normal_vars=['e'], list_vars=[]))
), (('retstat',), 
(lambda ctx, v1: [('ss', v1)])
), ((), 
(lambda ctx: [])
), (('NAME', 'funcname__1', 'funcname__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), v2, v3], user=lambda _loc, c, _all, _ctx, n: (
FuncName(values(n), c.value if c else None)
), normal_vars=['c'], list_vars=['n']))
), ((',', 'suffixedexp', 'stat__2'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('p', v2), v3])
), ((), 
(lambda ctx: [])
), ((',', 'exp', 'explist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), v3])
), ((), 
(lambda ctx: [])
), (('fieldlist',), 
(lambda ctx, v1: [('l', v1)])
), ((), 
(lambda ctx: [])
), (('field', 'fieldlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('f', v1), v2], user=lambda _loc, _all, _ctx, l, f: (
[f, l]
), normal_vars=['f', 'l'], list_vars=[]))
), (('explist',), 
(lambda ctx, v1: [('e', v1)])
), ((), 
(lambda ctx: [])
), (('+',), 
(lambda ctx, v1: [(None, v1)])
), (('-',), 
(lambda ctx, v1: [(None, v1)])
), ((',', 'parlist'), 
(lambda ctx, v1, v2: [(None, v1), ('p', v2)])
), ((), 
(lambda ctx: [])
), (('simpleexp', 'exp8__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda _loc, _all, r, _ctx, l, op: (
BinOp(op.location, l, op.type, r) if r else l
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), (('parlist',), 
(lambda ctx, v1: [('a', v1)])
), ((), 
(lambda ctx: [])
), (('exp6', 'exp5__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _all, _ctx: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('exp5', 'exp4__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda _loc, _all, r, _ctx, l, op: (
BinOp(op.location, l, op.type, r) if r else l
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ((',', 'NAME', 'stat_for__2'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ((), 
(lambda ctx: [])
), (('function', 'NAME', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda _loc, b, _all, _ctx, n: (
lambda loc: LocalFunction(loc, FuncName([n.value], None), b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), (('NAME', 'stat_local__1', 'stat_local__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('ns', v1), v2, v3], user=lambda _loc, _all, _ctx, es, ns: (
lambda loc: Local(loc, values(ns), es)
), normal_vars=['es'], list_vars=['ns']))
), (('nil',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
LuaNil(_loc)
), normal_vars=[], list_vars=[]))
), (('false',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
LuaFalse(_loc)
), normal_vars=[], list_vars=[]))
), (('true',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
LuaTrue(_loc)
), normal_vars=[], list_vars=[]))
), (('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _loc, _all, _ctx, n: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _loc, _all, s, _ctx: (
String(_loc, s.value)
), normal_vars=['s'], list_vars=[]))
), (('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _all, e, _ctx: (
EmbedExpression(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), (('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _all, _ctx: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), (('functiondef',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda _loc, _all, _ctx, f: (
f
), normal_vars=['f'], list_vars=[]))
), (('suffixedexp',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _all, e, _ctx: (
e
), normal_vars=['e'], list_vars=[]))
), (('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda t, _loc, _all, _ctx: (
t
), normal_vars=['t'], list_vars=[]))
), (('stat__2', '=', 'explist'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), ('a', v3)])
), ((), 
(lambda ctx: [])
), (('primaryexp', 'suffixedexp__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda _loc, _all, e, s, _ctx: (
process_suffixedexp(e, s)
), normal_vars=['e'], list_vars=['s']))
), ((',', 'NAME', 'stat_local__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3])
), ((), 
(lambda ctx: [])
), (('stat', 'block__1'), 
(lambda ctx, v1, v2: [('ss', v1), v2])
), ((), 
(lambda ctx: [])
), (('exp3', 'exp2__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _all, _ctx: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('exp2', 'exp__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _all, _ctx: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('=', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('fieldlist',), 
(lambda ctx, v1: [('f', v1)])
), ((), 
(lambda ctx: [])
), (('exp3__2', 'exp4', 'exp3__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('block',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda _loc, _all, a, _ctx: (
a
), normal_vars=['a'], list_vars=[]))
), (('exp5__2', 'exp6', 'exp5__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('elseif', 'exp', 'then', 'block', 'stat__3'), 
(lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5])
), ((), 
(lambda ctx: [])
), (('explist',), 
(lambda ctx, v1: [('e', v1)])
), ((), 
(lambda ctx: [])
), (('.', 'NAME', 'funcname__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ((), 
(lambda ctx: [])
), (('block__1', 'block__2'), 
(combine_action(root=lambda ctx, v1, v2: [v1, v2], user=lambda ss, _loc, _all, _ctx: (
Block(flatten(ss))
), normal_vars=[], list_vars=['ss']))
), (('not',), 
(lambda ctx, v1: [('op', v1)])
), (('#',), 
(lambda ctx, v1: [('op', v1)])
), (('-',), 
(lambda ctx, v1: [('op', v1)])
), (('fieldsep', 'fieldlist__2'), 
(lambda ctx, v1, v2: [(None, v1), v2])
), ((), 
(lambda ctx: [])
), (('=', 'explist'), 
(lambda ctx, v1, v2: [(None, v1), ('es', v2)])
), ((), 
(lambda ctx: [])
)]
TABLE = {'exp7': {'(': 1, 'NAME': 1, 'false': 1, 'function': 1, '-': 0, 'nil': 1, 'true': 1, '...': 1, '{': 1, 'EMBEDEXPR': 1, '#': 0, 'NUMBER': 1, 'not': 0, 'STRING': 1}, 'parlist': {'NAME': 3, '...': 2}, 'suffixedexp_suffix': {'[': 5, '.': 4, ':': 6, 'STRING': 7, '{': 7, '(': 7}, 'exp8__1': {'repeat': 9, 'NAME': 9, '::': 9, 'if': 9, 'and': 9, 'until': 9, '</lua>': 9, ')': 9, 'return': 9, 'local': 9, 'EMBEDSTAT': 9, '/': 9, '~=': 9, '==': 9, '<=': 9, '^': 8, 'else': 9, '}': 9, '@@@': 9, 'then': 9, 'for': 9, '*': 9, '%': 9, 'break': 9, '>': 9, ']': 9, 'end': 9, 'elseif': 9, '(': 9, '-': 9, '<': 9, ',': 9, '..': 9, 'while': 9, 'function': 9, '+': 9, 'or': 9, ';': 9, '>=': 9, 'do': 9, 'goto': 9, '=': 9}, 'tableconstructor': {'{': 10}, 'functiondef': {'function': 11}, 'exp3': {'(': 12, 'NAME': 12, 'false': 12, 'nil': 12, 'not': 12, '-': 12, 'true': 12, '...': 12, '{': 12, 'STRING': 12, '#': 12, 'NUMBER': 12, 'function': 12, 'EMBEDEXPR': 12}, 'exp3__2': {'==': 18, '~=': 17, '<=': 15, '>=': 16, '>': 14, '<': 13}, 'exp6': {'(': 19, 'NAME': 19, 'false': 19, 'nil': 19, 'not': 19, '-': 19, 'true': 19, '...': 19, '{': 19, 'STRING': 19, '#': 19, 'NUMBER': 19, 'function': 19, 'EMBEDEXPR': 19}, 'retstat__2': {'elseif': 21, ';': 20, 'end': 21, 'until': 21, '</lua>': 21, 'else': 21}, 'suffixedexp__1': {'[': 22, 'elseif': 23, 'if': 23, 'until': 23, 'local': 23, 'EMBEDSTAT': 23, ':': 22, '<=': 23, '^': 23, '}': 23, '*': 23, '%': 23, ']': 23, '(': 22, '.': 22, '..': 23, '{': 22, 'function': 23, '>=': 23, 'goto': 23, 'STRING': 22, 'repeat': 23, '/': 23, '::': 23, 'and': 23, '</lua>': 23, ')': 23, 'for': 23, '~=': 23, 'else': 23, 'or': 23, '@@@': 23, 'then': 23, 'do': 23, '>': 23, '-': 23, 'return': 23, '<': 23, '==': 23, 'break': 23, 'while': 23, '+': 23, 'NAME': 23, ';': 23, 'end': 23, '=': 23, ',': 23}, 'suffixedexp': {'NAME': 106, '(': 106}, 'stat_for': {',': 25, 'in': 25, '=': 24}, 'funcname__2': {':': 26, '(': 27}, 'args': {'{': 29, '(': 28, 'STRING': 30}, 'stat_for__2': {',': 90, 'in': 91}, 'exp2__1': {'repeat': 34, 'NAME': 34, '::': 34, 'if': 34, 'and': 33, 'until': 34, '</lua>': 34, ')': 34, 'for': 34, 'EMBEDSTAT': 34, 'elseif': 34, 'else': 34, 'or': 34, 'end': 34, 'function': 34, 'do': 34, '}': 34, ']': 34, '(': 34, 'return': 34, 'then': 34, ',': 34, 'break': 34, 'while': 34, ';': 34, '@@@': 34, 'local': 34, 'goto': 34, '=': 34}, 'label': {'::': 35}, 'stat': {'repeat': 43, 'NAME': 37, '::': 38, 'if': 44, 'do': 41, '(': 37, 'for': 45, 'EMBEDSTAT': 48, 'break': 39, 'while': 42, ';': 36, 'local': 47, 'goto': 40, 'function': 46}, 'fieldlist__2': {'[': 76, 'NAME': 76, '(': 76, 'false': 76, 'nil': 76, 'not': 76, '-': 76, 'true': 76, '...': 76, '{': 76, 'STRING': 76, '#': 76, 'NUMBER': 76, '}': 77, 'function': 76, 'EMBEDEXPR': 76}, 'stat__4': {'else': 51, 'end': 52}, 'explist': {'(': 53, 'NAME': 53, 'false': 53, 'nil': 53, 'not': 53, '-': 53, 'true': 53, '...': 53, '{': 53, 'STRING': 53, '#': 53, 'NUMBER': 53, 'function': 53, 'EMBEDEXPR': 53}, 'exp__1': {'repeat': 55, 'NAME': 55, '::': 55, 'if': 55, 'until': 55, '</lua>': 55, ')': 55, 'for': 55, 'EMBEDSTAT': 55, 'elseif': 55, 'else': 55, 'or': 54, 'end': 55, 'function': 55, 'do': 55, '}': 55, ']': 55, '(': 55, 'return': 55, 'then': 55, ',': 55, 'break': 55, 'while': 55, ';': 55, '@@@': 55, 'local': 55, 'goto': 55, '=': 55}, 'exp6__1': {'repeat': 57, 'NAME': 57, '::': 57, 'if': 57, 'and': 57, 'until': 57, '</lua>': 57, ')': 57, 'return': 57, 'local': 57, 'EMBEDSTAT': 57, '/': 56, '~=': 57, '==': 57, '<=': 57, 'else': 57, '}': 57, '@@@': 57, 'then': 57, 'for': 57, '*': 56, '%': 56, 'break': 57, '>': 57, ']': 57, 'end': 57, 'elseif': 57, '(': 57, '-': 57, '<': 57, ',': 57, '..': 57, 'while': 57, 'function': 57, '+': 57, 'or': 57, ';': 57, '>=': 57, 'do': 57, 'goto': 57, '=': 57}, 'funcbody': {'(': 58}, 'exp4__1': {'repeat': 60, 'NAME': 60, '::': 60, 'if': 60, 'and': 60, 'until': 60, '</lua>': 60, ')': 60, 'local': 60, 'EMBEDSTAT': 60, 'elseif': 60, '~=': 60, '==': 60, '<=': 60, 'else': 60, '}': 60, '@@@': 60, 'then': 60, 'for': 60, 'or': 60, 'break': 60, ']': 60, 'end': 60, '>': 60, '(': 60, 'return': 60, '<': 60, ',': 60, '..': 59, 'while': 60, 'function': 60, ';': 60, '>=': 60, 'do': 60, 'goto': 60, '=': 60}, 'fieldsep': {',': 61, ';': 62}, 'exp6__2': {'%': 65, '*': 63, '/': 64}, 'exp8': {'STRING': 85, 'NAME': 85, '{': 85, 'false': 85, 'function': 85, 'nil': 85, 'NUMBER': 85, 'EMBEDEXPR': 85, '(': 85, 'true': 85, '...': 85}, 'primaryexp': {'NAME': 49, '(': 50}, 'block__2': {'elseif': 70, 'else': 70, 'end': 70, 'until': 70, '</lua>': 70, 'return': 69}, 'funcname': {'NAME': 71}, 'stat__2': {',': 72, '=': 73}, 'explist__1': {'repeat': 75, 'elseif': 75, '::': 75, 'if': 75, 'local': 75, '</lua>': 75, ')': 75, 'for': 75, 'EMBEDSTAT': 75, 'NAME': 75, 'else': 75, 'function': 75, 'do': 75, '(': 75, 'return': 75, ',': 74, 'break': 75, 'while': 75, 'until': 75, ';': 75, 'end': 75, 'goto': 75}, 'fieldlist': {'[': 78, 'NAME': 78, '(': 78, 'false': 78, 'nil': 78, 'not': 78, '-': 78, 'true': 78, '...': 78, '{': 78, 'STRING': 78, '#': 78, 'NUMBER': 78, 'function': 78, 'EMBEDEXPR': 78}, 'retstat__1': {'(': 79, 'NAME': 79, '</lua>': 80, 'false': 79, 'else': 80, 'nil': 79, 'elseif': 80, 'not': 79, '-': 79, 'true': 79, '...': 79, '{': 79, 'until': 80, 'STRING': 79, '#': 79, ';': 80, 'NUMBER': 79, 'end': 80, 'function': 79, 'EMBEDEXPR': 79}, 'stat_local__1': {'repeat': 108, 'elseif': 108, '::': 108, 'if': 108, 'local': 108, '</lua>': 108, 'for': 108, 'EMBEDSTAT': 108, 'NAME': 108, 'else': 108, 'function': 108, 'do': 108, '(': 108, 'return': 108, ',': 107, 'break': 108, 'while': 108, 'until': 108, ';': 108, 'end': 108, 'goto': 108, '=': 108}, 'parlist__1': {',': 83, ')': 84}, 'stat_for__1': {',': 66, 'do': 67}, 'funcbody__1': {'NAME': 86, ')': 87, '...': 86}, 'exp5': {'(': 88, 'NAME': 88, 'false': 88, 'nil': 88, 'not': 88, '-': 88, 'true': 88, '...': 88, '{': 88, 'STRING': 88, '#': 88, 'NUMBER': 88, 'function': 88, 'EMBEDEXPR': 88}, 'exp4': {'(': 89, 'NAME': 89, 'false': 89, 'nil': 89, 'not': 89, '-': 89, 'true': 89, '...': 89, '{': 89, 'STRING': 89, '#': 89, 'NUMBER': 89, 'function': 89, 'EMBEDEXPR': 89}, 'field': {'[': 31, 'NAME': 32, '(': 32, 'false': 32, 'nil': 32, 'not': 32, '-': 32, 'true': 32, '...': 32, '{': 32, 'STRING': 32, '#': 32, 'NUMBER': 32, 'function': 32, 'EMBEDEXPR': 32}, 'stat_local': {'NAME': 93, 'function': 92}, 'simpleexp': {'NAME': 102, 'STRING': 98, 'false': 95, 'function': 101, '(': 102, 'NUMBER': 97, '...': 100, 'nil': 94, '{': 103, 'true': 96, 'EMBEDEXPR': 99}, 'stat__1': {'repeat': 105, 'NAME': 105, '::': 105, 'if': 105, 'until': 105, '</lua>': 105, 'for': 105, 'EMBEDSTAT': 105, 'elseif': 105, 'else': 105, 'function': 105, 'do': 105, '(': 105, 'return': 105, ',': 104, 'break': 105, 'while': 105, ';': 105, 'end': 105, 'local': 105, 'goto': 105, '=': 104}, 'retstat': {'return': 68}, 'exp5__2': {'-': 82, '+': 81}, 'block__1': {'repeat': 109, 'NAME': 109, '::': 109, 'if': 109, '</lua>': 110, 'elseif': 110, 'local': 109, '(': 109, 'return': 110, 'for': 109, 'EMBEDSTAT': 109, 'break': 109, 'while': 109, 'until': 110, 'else': 110, ';': 109, 'end': 110, 'do': 109, 'goto': 109, 'function': 109}, 'exp2': {'(': 111, 'NAME': 111, 'false': 111, 'nil': 111, 'not': 111, '-': 111, 'true': 111, '...': 111, '{': 111, 'STRING': 111, '#': 111, 'NUMBER': 111, 'function': 111, 'EMBEDEXPR': 111}, 'exp': {'(': 112, 'NAME': 112, 'false': 112, 'nil': 112, 'not': 112, '-': 112, 'true': 112, '...': 112, '{': 112, 'STRING': 112, '#': 112, 'NUMBER': 112, 'function': 112, 'EMBEDEXPR': 112}, 'field__1': {',': 114, ';': 114, '}': 114, '=': 113}, 'tableconstructor__1': {'[': 115, 'NAME': 115, '(': 115, 'false': 115, 'nil': 115, 'not': 115, '-': 115, 'true': 115, '...': 115, '{': 115, 'STRING': 115, '#': 115, 'NUMBER': 115, '}': 116, 'function': 115, 'EMBEDEXPR': 115}, 'exp3__1': {'repeat': 118, 'NAME': 118, '::': 118, 'if': 118, 'and': 118, 'local': 118, '</lua>': 118, ')': 118, 'for': 118, 'EMBEDSTAT': 118, 'elseif': 118, '<=': 117, ',': 118, 'else': 118, '}': 118, '@@@': 118, 'then': 118, 'or': 118, 'end': 118, ']': 118, '>': 117, '(': 118, 'return': 118, '<': 117, '==': 117, 'break': 118, '~=': 117, 'until': 118, 'function': 118, 'while': 118, ';': 118, '>=': 117, 'do': 118, 'goto': 118, '=': 118}, 'chunk': {'repeat': 119, 'NAME': 119, '::': 119, 'if': 119, '(': 119, 'local': 119, '</lua>': 119, 'return': 119, 'for': 119, 'EMBEDSTAT': 119, 'break': 119, 'do': 119, 'while': 119, ';': 119, 'goto': 119, 'function': 119}, 'exp5__1': {'repeat': 121, 'NAME': 121, '::': 121, 'if': 121, '-': 120, 'until': 121, '</lua>': 121, ')': 121, 'local': 121, 'EMBEDSTAT': 121, 'elseif': 121, '~=': 121, '==': 121, '<=': 121, 'else': 121, '}': 121, '@@@': 121, 'then': 121, 'for': 121, 'or': 121, 'break': 121, ']': 121, 'end': 121, '>': 121, '(': 121, 'return': 121, '<': 121, ',': 121, '..': 121, 'while': 121, 'function': 121, '+': 120, 'and': 121, ';': 121, '>=': 121, 'do': 121, 'goto': 121, '=': 121}, 'stat__3': {'else': 123, 'elseif': 122, 'end': 123}, 'args__1': {'(': 124, 'NAME': 124, 'false': 124, 'nil': 124, 'not': 124, '-': 124, ')': 125, 'true': 124, '...': 124, '{': 124, 'STRING': 124, '#': 124, 'NUMBER': 124, 'function': 124, 'EMBEDEXPR': 124}, 'funcname__1': {'.': 126, ':': 127, '(': 127}, 'block': {'repeat': 128, 'elseif': 128, '::': 128, 'if': 128, '(': 128, 'local': 128, '</lua>': 128, 'return': 128, 'goto': 128, 'for': 128, 'EMBEDSTAT': 128, 'break': 128, 'NAME': 128, 'until': 128, 'while': 128, ';': 128, 'end': 128, 'do': 128, 'else': 128, 'function': 128}, 'exp7__1': {'#': 130, '-': 131, 'not': 129}, 'fieldlist__1': {',': 132, '}': 133, ';': 132}, 'stat_local__2': {'repeat': 135, 'NAME': 135, '::': 135, 'if': 135, '(': 135, 'until': 135, '</lua>': 135, 'return': 135, 'goto': 135, 'for': 135, 'EMBEDSTAT': 135, 'break': 135, 'elseif': 135, 'do': 135, 'while': 135, ';': 135, 'else': 135, 'local': 135, 'end': 135, 'function': 135, '=': 134}}
