#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals
from grako.parsing import graken, Parser


__version__ = (2015, 5, 4, 21, 37, 53, 0)

__all__ = [
    'peggrammarParser',
    'peggrammarSemantics',
    'main'
]


class peggrammarParser(Parser):
    def __init__(self, whitespace=None, nameguard=True, **kwargs):
        super(peggrammarParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=None,
            eol_comments_re=None,
            **kwargs
        )

    @graken()
    def _start_(self):
        self._sum_()
        self.ast['@'] = self.last_node
        self._check_eof()

    @graken()
    def _sum_(self):
        self._product_()
        self.ast['l'] = self.last_node

        def block1():
            with self._group():
                with self._choice():
                    with self._option():
                        self._token('+')
                    with self._option():
                        self._token('-')
                    self._error('expecting one of: + -')
            self.ast.setlist('ops', self.last_node)
            self._product_()
            self.ast.setlist('rs', self.last_node)
        self._closure(block1)

        self.ast._define(
            ['l'],
            ['ops', 'rs']
        )

    @graken()
    def _product_(self):
        self._factor_()
        self.ast['l'] = self.last_node

        def block1():
            with self._group():
                with self._choice():
                    with self._option():
                        self._token('*')
                    with self._option():
                        self._token('/')
                    self._error('expecting one of: * /')
            self.ast.setlist('ops', self.last_node)
            self._factor_()
            self.ast.setlist('rs', self.last_node)
        self._closure(block1)

        self.ast._define(
            ['l'],
            ['ops', 'rs']
        )

    @graken()
    def _factor_(self):
        with self._choice():
            with self._option():
                self._token('-')
                self._factor_()
                self.ast['m'] = self.last_node
            with self._option():
                self._power_()
                self.ast['p'] = self.last_node
            self._error('no available options')

        self.ast._define(
            ['m', 'p'],
            []
        )

    @graken()
    def _power_(self):
        self._value_()
        self.ast['l'] = self.last_node
        with self._optional():
            self._token('^')
            self._factor_()
            self.ast['r'] = self.last_node

        self.ast._define(
            ['l', 'r'],
            []
        )

    @graken()
    def _value_(self):
        with self._choice():
            with self._option():
                self._number_()
                self.ast['@'] = self.last_node
            with self._option():
                self._embedloc_()
                self.ast['@'] = self.last_node
            with self._option():
                self._token('(')
                self._sum_()
                self.ast['@'] = self.last_node
                self._token(')')
            self._error('no available options')

    @graken()
    def _number_(self):
        self._pattern(r'[0-9]+')
        self.ast['n'] = self.last_node

        self.ast._define(
            ['n'],
            []
        )

    @graken()
    def _embedloc_(self):
        self._embed_EMBEDEXPR_()
        self.ast['e'] = self.last_node

        self.ast._define(
            ['e'],
            []
        )

    @graken()
    def _embed_EMBEDEXPR_(self):
        with self._ifnot():
            pass


class peggrammarSemantics(object):
    def start(self, ast):
        return ast

    def sum(self, ast):
        return ast

    def product(self, ast):
        return ast

    def factor(self, ast):
        return ast

    def power(self, ast):
        return ast

    def value(self, ast):
        return ast

    def number(self, ast):
        return ast

    def embedloc(self, ast):
        return ast

    def embed_EMBEDEXPR(self, ast):
        return ast


def main(filename, startrule, trace=False, whitespace=None, nameguard=None):
    import json
    with open(filename) as f:
        text = f.read()
    parser = peggrammarParser(parseinfo=False)
    ast = parser.parse(
        text,
        startrule,
        filename=filename,
        trace=trace,
        whitespace=whitespace,
        nameguard=nameguard)
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(ast, indent=2))
    print()

if __name__ == '__main__':
    import argparse
    import string
    import sys

    class ListRules(argparse.Action):
        def __call__(self, parser, namespace, values, option_string):
            print('Rules:')
            for r in peggrammarParser.rule_list():
                print(r)
            print()
            sys.exit(0)

    parser = argparse.ArgumentParser(description="Simple parser for peggrammar.")
    parser.add_argument('-l', '--list', action=ListRules, nargs=0,
                        help="list all rules and exit")
    parser.add_argument('-n', '--no-nameguard', action='store_true',
                        dest='no_nameguard',
                        help="disable the 'nameguard' feature")
    parser.add_argument('-t', '--trace', action='store_true',
                        help="output trace information")
    parser.add_argument('-w', '--whitespace', type=str, default=string.whitespace,
                        help="whitespace specification")
    parser.add_argument('file', metavar="FILE", help="the input file to parse")
    parser.add_argument('startrule', metavar="STARTRULE",
                        help="the start rule for parsing")
    args = parser.parse_args()

    main(
        args.file,
        args.startrule,
        trace=args.trace,
        whitespace=args.whitespace,
        nameguard=not args.no_nameguard
    )
