
from context import flatten
from toylua.lex import tokenizer
from toylua.ast import *


def values(tokens):
    return [t.value for t in tokens]

def assignment_or_functioncall(exps, assignment):
    # Assignments and function calls use the same grammar rule, to keep it LL.
    # Based on exprstat() and assignment() in lparser.c.
    if not assignment:
        if not isinstance(exps[0], FunctionCall):
            raise ParseError(exps[0].location, 'Expected assignment or function call')
        return exps[0]
    else:
        for e in exps:
            if not isinstance(e, (Name, Dot, Brackets)):
                raise ParseError(e.location, 'Invalid lvalue')
        return Assignment(exps[0].location, exps, assignment)

def process_suffixedexp(base, suffixes):
    for suffix_fn in suffixes:
        base = suffix_fn(base)
    return base

def left_associative(symbols):
    symbols = iter(symbols)
    left = next(symbols)
    while True:
        try:
            op = next(symbols)
            right = next(symbols)
            left = BinOp(op.location, left, op.type, right)
        except StopIteration:
            return left

def check_key(e, errloc):
    if not isinstance(e, Name):
        raise ParseError(errloc, "Unexpected '='")
    return String(e.location, e.name)


from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [close_with or 'EOF', start_nt or 'chunk']
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        stack_top = stack[-1]

        if isinstance(stack_top, int):
            rule, action = RULES[stack_top]
            stack.pop()
            n = len(rule)
            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(action(ctx, *args))

        elif stack_top not in TABLE:
            if token.type != stack_top:
                raise ParseError(token.location, "Expected " + stack_top)
            stack.pop()
            if not stack: break
            results.append(token)
            token = next(tok_iter)

        else:
            row = TABLE[stack_top]
            if token.type not in row:
                raise ParseError(token.location, "Unexpected {}, expected {}".format(
                    repr(token.type), ', '.join(sorted(repr(k) for k in row))))
            rule_num = row[token.type]
            rule, action = RULES[rule_num]
            stack.pop()
            stack.append(rule_num)
            stack.extend(reversed(rule))

    return results[0]

RULES = [(('.', 'NAME', 'funcname__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ((), 
(lambda ctx: [])
), (('exp6__2', 'exp7', 'exp6__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('exp5', 'exp4__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda r, _all, l, _loc, _ctx, op: (
BinOp(op.location, l, op.type, r) if r else l
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), (('exp3__2', 'exp4', 'exp3__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('=', 'exp', ',', 'exp', 'stat_for__1', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7, v8: [(None, v1), ('e1', v2), (None, v3), ('e2', v4), v5, (None, v6), ('b', v7), (None, v8)], user=lambda e2, _all, _loc, _ctx, e3, e1, b: (
lambda loc, n: NumericFor(loc, n, e1, e2, e3, b)
), normal_vars=['b', 'e1', 'e2', 'e3'], list_vars=[]))
), (('stat_for__2', 'in', 'explist', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6: [v1, (None, v2), ('e', v3), (None, v4), ('b', v5), (None, v6)], user=lambda n, _all, _loc, _ctx, e, b: (
lambda loc, n1: GenericFor(loc, values([n1]+n), e, b)
), normal_vars=['b', 'e'], list_vars=['n']))
), (('exp4', 'exp3__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _ctx, _all: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('and', 'exp3', 'exp2__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('or', 'exp2', 'exp__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('field', 'fieldlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('f', v1), v2], user=lambda l, _loc, _ctx, _all, f: (
[f, l]
), normal_vars=['f', 'l'], list_vars=[]))
), ((';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
None
), normal_vars=[], list_vars=[]))
), (('suffixedexp', 'stat__1'), 
(combine_action(root=lambda ctx, v1, v2: [('p', v1), v2], user=lambda a, _loc, _ctx, _all, p: (
assignment_or_functioncall(p, a)
), normal_vars=['a'], list_vars=['p']))
), (('label',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda s, _loc, _ctx, _all: (
s
), normal_vars=['s'], list_vars=[]))
), (('break',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
Break(_loc)
), normal_vars=[], list_vars=[]))
), (('goto', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('n', v2)], user=lambda n, _loc, _ctx, _all: (
Goto(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('b', v2), (None, v3)], user=lambda _loc, _ctx, _all, b: (
BlockStatement(_loc, b)
), normal_vars=['b'], list_vars=[]))
), (('while', 'exp', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), (None, v5)], user=lambda _loc, _ctx, e, b, _all: (
While(_loc, e, b)
), normal_vars=['b', 'e'], list_vars=[]))
), (('repeat', 'block', 'until', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), ('b', v2), (None, v3), ('e', v4)], user=lambda _loc, _ctx, e, b, _all: (
Repeat(_loc, b, e)
), normal_vars=['b', 'e'], list_vars=[]))
), (('if', 'exp', 'then', 'block', 'stat__3', 'stat__4', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5, v6, (None, v7)], user=lambda _loc, _ctx, e, b, _all: (
If(_loc, e, b)
), normal_vars=[], list_vars=['b', 'e']))
), (('for', 'NAME', 'stat_for'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('s', v3)], user=lambda n, s, _loc, _ctx, _all: (
s(_loc, n)
), normal_vars=['n', 's'], list_vars=[]))
), (('function', 'funcname', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda n, _loc, _ctx, _all, b: (
Function(_loc, n, b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), (('local', 'stat_local'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('s', v2)], user=lambda s, _loc, _ctx, _all: (
s(_loc)
), normal_vars=['s'], list_vars=[]))
), (('EMBEDSTAT',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _ctx, e, _all: (
EmbedStatement(e.location, e.value)
), normal_vars=['e'], list_vars=[]))
), (('::', 'NAME', '::'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), (None, v3)], user=lambda n, _loc, _ctx, _all: (
Label(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('NAME', 'funcname__1', 'funcname__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), v2, v3], user=lambda n, _loc, _ctx, _all, c: (
FuncName(values(n), c.value if c else None)
), normal_vars=['c'], list_vars=['n']))
), (('{', 'tableconstructor__1', '}'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _loc, _ctx, _all, f: (
TableConstructor(_loc, flatten(f))
), normal_vars=['f'], list_vars=[]))
), (('NAME',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda n, _loc, _ctx, _all: (
Name(n.location, n.value)
), normal_vars=['n'], list_vars=[]))
), (('(', 'exp', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _loc, _ctx, e, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('explist',), 
(lambda ctx, v1: [('e', v1)])
), ((), 
(lambda ctx: [])
), (('=', 'explist'), 
(lambda ctx, v1, v2: [(None, v1), ('es', v2)])
), ((), 
(lambda ctx: [])
), (('fieldlist',), 
(lambda ctx, v1: [('l', v1)])
), ((), 
(lambda ctx: [])
), (('<',), 
(lambda ctx, v1: [(None, v1)])
), (('>',), 
(lambda ctx, v1: [(None, v1)])
), (('<=',), 
(lambda ctx, v1: [(None, v1)])
), (('>=',), 
(lambda ctx, v1: [(None, v1)])
), (('~=',), 
(lambda ctx, v1: [(None, v1)])
), (('==',), 
(lambda ctx, v1: [(None, v1)])
), (('exp6', 'exp5__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _ctx, _all: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('stat', 'block__1'), 
(lambda ctx, v1, v2: [('ss', v1), v2])
), ((), 
(lambda ctx: [])
), (('elseif', 'exp', 'then', 'block', 'stat__3'), 
(lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5])
), ((), 
(lambda ctx: [])
), (('stat__2', '=', 'explist'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), ('a', v3)])
), ((), 
(lambda ctx: [])
), (('primaryexp', 'suffixedexp__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda s, _loc, _ctx, e, _all: (
process_suffixedexp(e, s)
), normal_vars=['e'], list_vars=['s']))
), (('return', 'retstat__1', 'retstat__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, v3], user=lambda _loc, _ctx, e, _all: (
Return(_loc, e)
), normal_vars=['e'], list_vars=[]))
), (('.', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [('d', v1), ('n', v2)], user=lambda n, _loc, _ctx, d, _all: (
lambda left: Dot(d.location, left, n.value)
), normal_vars=['d', 'n'], list_vars=[]))
), (('[', 'exp', ']'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('d', v1), ('e', v2), (None, v3)], user=lambda _loc, _ctx, d, e, _all: (
lambda left: Brackets(d.location, left, e)
), normal_vars=['d', 'e'], list_vars=[]))
), ((':', 'NAME', 'args'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('d', v1), ('n', v2), ('a', v3)], user=lambda n, _all, a, _loc, _ctx, d: (
lambda left: FunctionCall(d.location, left, n.value, a[1])
), normal_vars=['a', 'd', 'n'], list_vars=[]))
), (('args',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda a, _loc, _ctx, _all: (
lambda left: FunctionCall(a[0], left, None, a[1])
), normal_vars=['a'], list_vars=[]))
), (('exp', 'explist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda _loc, _ctx, e, _all: (
e
), normal_vars=[], list_vars=['e']))
), (('function', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('b', v2)], user=lambda _loc, _ctx, _all, b: (
Function(_loc, None, b[0], b[1])
), normal_vars=['b'], list_vars=[]))
), (('fieldsep', 'fieldlist__2'), 
(lambda ctx, v1, v2: [(None, v1), v2])
), ((), 
(lambda ctx: [])
), ((',', 'exp', 'explist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), v3])
), ((), 
(lambda ctx: [])
), (('parlist',), 
(lambda ctx, v1: [('a', v1)])
), ((), 
(lambda ctx: [])
), (('fieldlist',), 
(lambda ctx, v1: [('f', v1)])
), ((), 
(lambda ctx: [])
), (('function', 'NAME', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda n, _loc, _ctx, _all, b: (
lambda loc: LocalFunction(loc, FuncName([n.value], None), b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), (('NAME', 'stat_local__1', 'stat_local__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('ns', v1), v2, v3], user=lambda ns, _loc, _ctx, es, _all: (
lambda loc: Local(loc, values(ns), es)
), normal_vars=['es'], list_vars=['ns']))
), (('not',), 
(lambda ctx, v1: [('op', v1)])
), (('#',), 
(lambda ctx, v1: [('op', v1)])
), (('-',), 
(lambda ctx, v1: [('op', v1)])
), (('exp3', 'exp2__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _ctx, _all: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), (('NAME', 'parlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('n', v1), v2], user=lambda n, _loc, _ctx, _all, p: (
[n.value, p or []]
), normal_vars=['n', 'p'], list_vars=[]))
), ((',', 'parlist'), 
(lambda ctx, v1, v2: [(None, v1), ('p', v2)])
), ((), 
(lambda ctx: [])
), (('block__1', 'block__2'), 
(combine_action(root=lambda ctx, v1, v2: [v1, v2], user=lambda _loc, _ctx, _all, ss: (
Block(flatten(ss))
), normal_vars=[], list_vars=['ss']))
), (('simpleexp', 'exp8__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda r, _all, l, _loc, _ctx, op: (
BinOp(op.location, l, op.type, r) if r else l
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ((',',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
None
), normal_vars=[], list_vars=[]))
), ((';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
None
), normal_vars=[], list_vars=[]))
), (('+',), 
(lambda ctx, v1: [(None, v1)])
), (('-',), 
(lambda ctx, v1: [(None, v1)])
), (('nil',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
LuaNil(_loc)
), normal_vars=[], list_vars=[]))
), (('false',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
LuaFalse(_loc)
), normal_vars=[], list_vars=[]))
), (('true',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
LuaTrue(_loc)
), normal_vars=[], list_vars=[]))
), (('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda n, _loc, _ctx, _all: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda s, _loc, _ctx, _all: (
String(_loc, s.value)
), normal_vars=['s'], list_vars=[]))
), (('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _ctx, e, _all: (
EmbedExpression(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), (('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _loc, _ctx, _all: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), (('functiondef',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda _loc, _ctx, _all, f: (
f
), normal_vars=['f'], list_vars=[]))
), (('suffixedexp',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _ctx, e, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda _loc, _ctx, t, _all: (
t
), normal_vars=['t'], list_vars=[]))
), ((',', 'NAME', 'stat_local__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3])
), ((), 
(lambda ctx: [])
), ((';',), 
(lambda ctx, v1: [(None, v1)])
), ((), 
(lambda ctx: [])
), (('exp5__2', 'exp6', 'exp5__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), ((',', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('e3', v2)])
), ((), 
(lambda ctx: [])
), (('(', 'args__1', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _loc, _ctx, e, _all: (
(_loc, e or [])
), normal_vars=['e'], list_vars=[]))
), (('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda _loc, _ctx, t, _all: (
(t.location, [t])
), normal_vars=['t'], list_vars=[]))
), (('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda s, _loc, _ctx, _all: (
(s.location, [s.value])
), normal_vars=['s'], list_vars=[]))
), (('[', 'exp', ']', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('k', v2), (None, v3), (None, v4), ('v', v5)], user=lambda _loc, _ctx, v, k, _all: (
Field(_loc, k, v)
), normal_vars=['k', 'v'], list_vars=[]))
), (('exp', 'field__1'), 
(combine_action(root=lambda ctx, v1, v2: [('a', v1), v2], user=lambda a, _loc, _ctx, _all, b: (
Field(a.location, check_key(a, _loc), b) if b else Field(a.location, None, a)
), normal_vars=['a', 'b'], list_vars=[]))
), (('exp2', 'exp__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _ctx, _all: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('(', 'funcbody__1', ')', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), v2, (None, v3), ('b', v4), (None, v5)], user=lambda a, _loc, _ctx, _all, b: (
(flatten(a), b)
), normal_vars=['a', 'b'], list_vars=[]))
), (('..', 'exp4'), 
(lambda ctx, v1, v2: [('op', v1), ('r', v2)])
), ((), 
(lambda ctx: [])
), (('else', 'block'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('*',), 
(lambda ctx, v1: [(None, v1)])
), (('/',), 
(lambda ctx, v1: [(None, v1)])
), (('%',), 
(lambda ctx, v1: [(None, v1)])
), (('retstat',), 
(lambda ctx, v1: [('ss', v1)])
), ((), 
(lambda ctx: [])
), ((':', 'NAME'), 
(lambda ctx, v1, v2: [(None, v1), ('c', v2)])
), ((), 
(lambda ctx: [])
), (('^', 'exp7'), 
(lambda ctx, v1, v2: [('op', v1), ('r', v2)])
), ((), 
(lambda ctx: [])
), (('=', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), ((',', 'NAME', 'stat_for__2'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ((), 
(lambda ctx: [])
), (('exp7', 'exp6__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _loc, _ctx, _all: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('exp7__1', 'exp7'), 
(combine_action(root=lambda ctx, v1, v2: [v1, ('e', v2)], user=lambda _loc, _ctx, e, _all, op: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), (('exp8',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _ctx, e, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('explist',), 
(lambda ctx, v1: [('e', v1)])
), ((), 
(lambda ctx: [])
), ((',', 'suffixedexp', 'stat__2'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('p', v2), v3])
), ((), 
(lambda ctx: [])
), (('suffixedexp_suffix', 'suffixedexp__1'), 
(lambda ctx, v1, v2: [('s', v1), v2])
), ((), 
(lambda ctx: [])
), (('block',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda a, _loc, _ctx, _all: (
a
), normal_vars=['a'], list_vars=[]))
)]
TABLE = {'funcname__1': {':': 1, '(': 1, '.': 0}, 'exp6__1': {'function': 3, '<': 3, 'if': 3, '=': 3, 'EMBEDSTAT': 3, 'end': 3, '==': 3, 'elseif': 3, 'NAME': 3, '~=': 3, '*': 2, 'while': 3, 'until': 3, ';': 3, 'EOF': 3, ']': 3, '(': 3, ',': 3, 'for': 3, 'goto': 3, '+': 3, 'then': 3, 'break': 3, '..': 3, 'repeat': 3, 'return': 3, 'local': 3, 'else': 3, 'or': 3, 'and': 3, '}': 3, '-': 3, 'do': 3, '>': 3, '>=': 3, '<=': 3, '/': 2, ')': 3, '%': 2, '::': 3}, 'exp4': {'function': 4, 'true': 4, '(': 4, 'false': 4, 'STRING': 4, 'nil': 4, 'NAME': 4, 'not': 4, 'NUMBER': 4, 'EMBEDEXPR': 4, '#': 4, '{': 4, '...': 4, '-': 4}, 'exp3__1': {'function': 6, '<': 5, 'if': 6, '=': 6, 'EMBEDSTAT': 6, 'for': 6, '==': 5, '>': 5, 'NAME': 6, 'else': 6, 'end': 6, 'while': 6, 'until': 6, ';': 6, 'EOF': 6, ']': 6, '(': 6, ',': 6, 'goto': 6, 'then': 6, 'break': 6, ')': 6, 'repeat': 6, 'return': 6, 'local': 6, 'and': 6, '}': 6, 'do': 6, '~=': 5, 'elseif': 6, '>=': 5, '<=': 5, 'or': 6, '::': 6}, 'stat_for': {'in': 8, ',': 8, '=': 7}, 'exp3': {'function': 9, 'true': 9, '(': 9, 'false': 9, 'STRING': 9, 'nil': 9, 'NAME': 9, 'not': 9, 'NUMBER': 9, 'EMBEDEXPR': 9, '#': 9, '{': 9, '...': 9, '-': 9}, 'exp2__1': {'function': 11, 'end': 11, 'if': 11, '=': 11, 'EMBEDSTAT': 11, 'EOF': 11, 'elseif': 11, 'NAME': 11, 'else': 11, 'while': 11, 'until': 11, ';': 11, ']': 11, '(': 11, ',': 11, 'for': 11, 'goto': 11, 'then': 11, 'break': 11, ')': 11, 'repeat': 11, 'return': 11, 'local': 11, 'and': 10, '}': 11, 'do': 11, '::': 11, 'or': 11}, 'funcname': {'NAME': 29}, 'fieldlist': {'function': 14, 'true': 14, '(': 14, 'false': 14, 'STRING': 14, 'nil': 14, 'NAME': 14, 'not': 14, '[': 14, 'NUMBER': 14, 'EMBEDEXPR': 14, '#': 14, '{': 14, '...': 14, '-': 14}, 'stat': {'function': 25, 'for': 24, 'goto': 19, 'if': 23, 'EMBEDSTAT': 27, 'break': 18, '::': 17, 'NAME': 16, 'repeat': 22, ';': 15, 'while': 21, 'local': 26, 'do': 20, '(': 16}, 'label': {'::': 28}, 'exp__1': {'function': 13, 'end': 13, 'if': 13, '=': 13, 'EMBEDSTAT': 13, 'EOF': 13, 'elseif': 13, 'or': 12, 'else': 13, 'while': 13, 'until': 13, ';': 13, ']': 13, '(': 13, ',': 13, 'for': 13, 'goto': 13, 'then': 13, 'break': 13, ')': 13, 'repeat': 13, 'return': 13, 'local': 13, '}': 13, 'do': 13, '::': 13, 'NAME': 13}, 'tableconstructor': {'{': 30}, 'primaryexp': {'NAME': 31, '(': 32}, 'explist__1': {'function': 63, 'for': 63, 'if': 63, 'EMBEDSTAT': 63, 'EOF': 63, '::': 63, 'NAME': 63, 'else': 63, 'end': 63, 'while': 63, 'until': 63, 'local': 63, '(': 63, ',': 62, 'goto': 63, 'break': 63, ')': 63, 'repeat': 63, 'return': 63, ';': 63, 'do': 63, 'elseif': 63}, 'stat_local__2': {'function': 36, 'end': 36, 'goto': 36, 'if': 36, 'do': 36, 'EMBEDSTAT': 36, 'EOF': 36, 'elseif': 36, 'NAME': 36, 'repeat': 36, 'return': 36, 'local': 36, 'else': 36, 'while': 36, 'until': 36, ';': 36, '=': 35, '::': 36, '(': 36, 'for': 36, 'break': 36}, 'fieldlist__2': {'function': 37, 'true': 37, '(': 37, 'false': 37, 'STRING': 37, 'nil': 37, 'NAME': 37, 'not': 37, '[': 37, 'NUMBER': 37, 'EMBEDEXPR': 37, '}': 38, '#': 37, '{': 37, '...': 37, '-': 37}, 'exp3__2': {'<': 39, '>': 40, '~=': 43, '==': 44, '>=': 42, '<=': 41}, 'block__1': {'function': 46, 'for': 46, 'goto': 46, 'if': 46, 'EMBEDSTAT': 46, 'repeat': 46, '::': 46, 'NAME': 46, 'break': 46, 'return': 47, ';': 46, 'else': 47, 'end': 47, 'while': 46, 'EOF': 47, 'local': 46, 'do': 46, 'until': 47, 'elseif': 47, '(': 46}, 'parlist': {'NAME': 75, '...': 74}, 'stat__1': {'function': 51, 'end': 51, 'if': 51, '=': 50, 'EMBEDSTAT': 51, 'EOF': 51, 'elseif': 51, 'NAME': 51, 'else': 51, 'while': 51, 'until': 51, ';': 51, '(': 51, 'for': 51, ',': 50, 'goto': 51, 'break': 51, 'repeat': 51, 'return': 51, 'local': 51, 'do': 51, '::': 51}, 'suffixedexp': {'NAME': 52, '(': 52}, 'exp5': {'function': 45, 'true': 45, '(': 45, 'false': 45, 'STRING': 45, 'nil': 45, 'NAME': 45, 'not': 45, 'NUMBER': 45, 'EMBEDEXPR': 45, '#': 45, '{': 45, '...': 45, '-': 45}, 'suffixedexp_suffix': {'STRING': 57, ':': 56, '.': 54, '{': 57, '(': 57, '[': 55}, 'explist': {'function': 58, 'true': 58, '(': 58, 'false': 58, 'STRING': 58, 'nil': 58, 'NAME': 58, 'not': 58, 'NUMBER': 58, 'EMBEDEXPR': 58, '#': 58, '{': 58, '...': 58, '-': 58}, 'functiondef': {'function': 59}, 'fieldlist__1': {'}': 61, ',': 60, ';': 60}, 'exp5__2': {'+': 82, '-': 83}, 'funcbody__1': {')': 65, 'NAME': 64, '...': 64}, 'tableconstructor__1': {'function': 66, 'true': 66, '(': 66, 'false': 66, 'STRING': 66, 'nil': 66, 'NAME': 66, 'not': 66, '[': 66, 'NUMBER': 66, 'EMBEDEXPR': 66, '}': 67, '#': 66, '{': 66, '...': 66, '-': 66}, 'stat_local': {'function': 68, 'NAME': 69}, 'exp7__1': {'-': 72, '#': 71, 'not': 70}, 'exp2': {'function': 73, 'true': 73, '(': 73, 'false': 73, 'STRING': 73, 'nil': 73, 'NAME': 73, 'not': 73, 'NUMBER': 73, 'EMBEDEXPR': 73, '#': 73, '{': 73, '...': 73, '-': 73}, 'retstat__1': {'function': 33, 'true': 33, '(': 33, 'false': 33, 'STRING': 33, 'nil': 33, 'until': 34, 'NAME': 33, 'not': 33, 'NUMBER': 33, 'else': 34, 'end': 34, 'EMBEDEXPR': 33, 'EOF': 34, ';': 34, '#': 33, '{': 33, 'elseif': 34, '...': 33, '-': 33}, 'block': {'function': 78, 'for': 78, 'goto': 78, 'if': 78, 'EMBEDSTAT': 78, 'end': 78, '::': 78, 'NAME': 78, 'repeat': 78, 'return': 78, ';': 78, 'else': 78, 'while': 78, 'until': 78, 'local': 78, 'do': 78, 'elseif': 78, 'EOF': 78, '(': 78, 'break': 78}, 'exp8': {'true': 79, 'STRING': 79, 'EMBEDEXPR': 79, '...': 79, 'false': 79, '{': 79, 'nil': 79, '(': 79, 'NAME': 79, 'function': 79, 'NUMBER': 79}, 'args__1': {'function': 129, 'true': 129, '(': 129, 'false': 129, 'STRING': 129, 'nil': 129, ')': 130, 'NAME': 129, 'not': 129, 'NUMBER': 129, 'EMBEDEXPR': 129, '#': 129, '{': 129, '...': 129, '-': 129}, 'fieldsep': {',': 80, ';': 81}, 'simpleexp': {'true': 86, 'STRING': 88, 'EMBEDEXPR': 89, '...': 90, 'false': 85, '{': 93, 'nil': 84, '(': 92, 'NAME': 92, 'function': 91, 'NUMBER': 87}, 'stat_local__1': {'function': 95, 'for': 95, 'if': 95, '=': 95, 'EMBEDSTAT': 95, 'EOF': 95, '::': 95, 'NAME': 95, 'else': 95, 'end': 95, 'while': 95, 'until': 95, 'local': 95, '(': 95, ',': 94, 'goto': 95, 'break': 95, 'repeat': 95, 'return': 95, ';': 95, 'do': 95, 'elseif': 95}, 'retstat__2': {'end': 97, 'until': 97, 'EOF': 97, 'elseif': 97, 'else': 97, ';': 96}, 'exp5__1': {'function': 99, '<': 99, 'if': 99, '=': 99, 'EMBEDSTAT': 99, 'end': 99, '==': 99, '>': 99, 'NAME': 99, '~=': 99, 'while': 99, 'until': 99, ';': 99, 'EOF': 99, ']': 99, '(': 99, ',': 99, 'for': 99, 'goto': 99, '+': 98, 'then': 99, 'break': 99, ')': 99, 'repeat': 99, 'return': 99, 'local': 99, 'else': 99, 'and': 99, '}': 99, 'do': 99, '..': 99, 'elseif': 99, '>=': 99, '<=': 99, 'or': 99, '-': 98, '::': 99}, 'stat_for__1': {',': 100, 'do': 101}, 'retstat': {'return': 53}, 'args': {'STRING': 104, '(': 102, '{': 103}, 'field': {'function': 106, 'true': 106, '(': 106, 'false': 106, 'STRING': 106, 'nil': 106, 'NAME': 106, 'not': 106, '[': 105, 'NUMBER': 106, 'EMBEDEXPR': 106, '#': 106, '{': 106, '...': 106, '-': 106}, 'funcbody': {'(': 108}, 'exp': {'function': 107, 'true': 107, '(': 107, 'false': 107, 'STRING': 107, 'nil': 107, 'NAME': 107, 'not': 107, 'NUMBER': 107, 'EMBEDEXPR': 107, '#': 107, '{': 107, '...': 107, '-': 107}, 'exp4__1': {'function': 110, 'end': 110, '(': 110, '..': 109, 'EMBEDSTAT': 110, '<': 110, '==': 110, 'elseif': 110, 'NAME': 110, '~=': 110, 'while': 110, 'until': 110, ';': 110, 'EOF': 110, ']': 110, 'if': 110, 'for': 110, '=': 110, ',': 110, 'goto': 110, 'then': 110, 'break': 110, ')': 110, 'repeat': 110, 'return': 110, 'local': 110, 'else': 110, 'and': 110, '}': 110, 'do': 110, '>': 110, '>=': 110, '<=': 110, 'or': 110, '::': 110}, 'stat__4': {'end': 112, 'else': 111}, 'exp6__2': {'*': 113, '/': 114, '%': 115}, 'block__2': {'end': 117, 'until': 117, 'EOF': 117, 'elseif': 117, 'else': 117, 'return': 116}, 'suffixedexp__1': {'end': 134, '(': 133, '<': 134, 'elseif': 134, 'NAME': 134, '[': 133, 'until': 134, ']': 134, 'for': 134, ',': 134, 'STRING': 133, 'goto': 134, 'then': 134, 'break': 134, '..': 134, '~=': 134, 'local': 134, 'and': 134, '}': 134, '>': 134, '>=': 134, '^': 134, '%': 134, 'function': 134, 'EOF': 134, '=': 134, 'EMBEDSTAT': 134, 'repeat': 134, '==': 134, '::': 134, 'or': 134, 'else': 134, '*': 134, 'while': 134, ':': 133, '+': 134, '.': 133, 'if': 134, 'return': 134, ';': 134, 'do': 134, '{': 133, '<=': 134, '/': 134, ')': 134, '-': 134}, 'funcname__2': {'(': 119, ':': 118}, 'exp8__1': {'function': 121, '<': 121, '(': 121, '=': 121, 'EMBEDSTAT': 121, 'end': 121, '==': 121, 'elseif': 121, 'NAME': 121, '~=': 121, '*': 121, 'while': 121, 'until': 121, ';': 121, 'EOF': 121, ']': 121, 'if': 121, 'for': 121, ',': 121, 'or': 121, 'goto': 121, '<=': 121, '+': 121, 'then': 121, 'break': 121, '..': 121, 'repeat': 121, 'return': 121, 'local': 121, 'else': 121, 'and': 121, '}': 121, '-': 121, 'do': 121, '>': 121, '>=': 121, '^': 120, '/': 121, ')': 121, '%': 121, '::': 121}, 'field__1': {';': 123, '}': 123, ',': 123, '=': 122}, 'stat_for__2': {'in': 125, ',': 124}, 'exp6': {'function': 126, 'true': 126, '(': 126, 'false': 126, 'STRING': 126, 'nil': 126, 'NAME': 126, 'not': 126, 'NUMBER': 126, 'EMBEDEXPR': 126, '#': 126, '{': 126, '...': 126, '-': 126}, 'exp7': {'function': 128, 'true': 128, '(': 128, 'false': 128, 'STRING': 128, 'nil': 128, 'NAME': 128, 'not': 127, 'NUMBER': 128, 'EMBEDEXPR': 128, '#': 127, '{': 128, '...': 128, '-': 127}, 'parlist__1': {')': 77, ',': 76}, 'stat__2': {',': 131, '=': 132}, 'stat__3': {'elseif': 48, 'else': 49, 'end': 49}, 'chunk': {'function': 135, 'for': 135, 'goto': 135, 'if': 135, 'EMBEDSTAT': 135, 'EOF': 135, '::': 135, 'NAME': 135, 'repeat': 135, 'return': 135, ';': 135, 'while': 135, 'local': 135, 'do': 135, '(': 135, 'break': 135}}
