

from mgr.lex import tokenizer
from collections import namedtuple
from context import flatten

MgrGrammar = namedtuple('MgrGrammar', 'preface properties rules')
# rules is a list of (SimpleRule|ExtendedRule)

SimpleRule = namedtuple('SimpleRule', 'left right action')
# right is a list of str

ExtendedRule = namedtuple('ExtendedRule', 'left right action')
# right is a list of (Symbol|Subrule|SubruleReference)

Symbol = namedtuple('Symbol', 'label append value')

Subrule = namedtuple('Subrule', 'branches type')
# branches is a list of SubruleBranch

SubruleBranch = namedtuple('SubruleBranch', 'items')
# items is a list of (Symbol|Subrule|SubruleReference)

SubruleReference = namedtuple('SubruleReference', 'index')


from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [INITIAL[(start_nt or 'start', close_with or 'EOF')]]
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        action = TABLE[stack[-1]].get(token.type)

        if action is None:
            nonterminals = { nt for nt, right, action in RULES }
            choices = { repr(k) for k in TABLE[stack[-1]] if k not in nonterminals }
            raise ParseError(token.location, "Unexpected {}, expected {}".format(
                repr(token.type), ', '.join(sorted(choices))))

        is_shift, action_value = action

        if is_shift:
            results.append(token)
            stack.append(action_value)
            token = next(tok_iter)
        else:
            if action_value is None: break
            left, right, rule_action = RULES[action_value]
            n = len(right)

            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(rule_action(ctx, *args))

            del stack[len(stack) - n:]
            new_is_shift, new_state = TABLE[stack[-1]][left]
            assert new_is_shift
            stack.append(new_state)

    return results[0]

INITIAL = {('start', 'EOF'): 0}
RULES = [('start', ('PREFACE', 'properties', 'rules'), 
(lambda ctx,p,d,r: MgrGrammar(p.value, d, flatten(r)))
), ('subbranch', ('eitems',), 
(lambda ctx,es: SubruleBranch(flatten(es)))
), ('eitem', ('NAME',), 
(lambda ctx,v: Symbol(None, False, v.value))
), ('eitem', ('NAME', '=', 'NAME'), 
(lambda ctx,l,_,v: Symbol(l.value, False, v.value))
), ('eitem', ('NAME', '+', '=', 'NAME'), 
(lambda ctx,l,_,__,v: Symbol(l.value, True, v.value))
), ('eitem', ('(', 'subbranch', 'subbranches', ')', 'suffix'), 
(lambda ctx,_,b,bs,__,s: Subrule(flatten([b,bs]), s))
), ('eitem', ('SUBRULEREF',), 
(lambda ctx,r: SubruleReference(r.value))
), ('rules', ('rule', 'rules'), 
(lambda ctx,x,xs: [x,xs])
), ('rules', (), 
(lambda ctx: [])
), ('names', ('NAME', 'names'), 
(lambda ctx,n,ns: [n.value,ns])
), ('names', (), 
(lambda ctx: [])
), ('rule', ('NAME', '=', 'names', 'ACTION'), 
(lambda ctx,l,_,rs,a: SimpleRule(l.value, flatten(rs), a.value))
), ('rule', ('NAME', ':', 'ebranch', 'ebranches'), 
(lambda ctx,l,_,b,bs: [ExtendedRule(l.value, r, a) for r, a in flatten([b,bs])])
), ('subbranches', ('|', 'subbranch', 'subbranches'), 
(lambda ctx,_,b,bs: [b,bs])
), ('subbranches', (), 
(lambda ctx: [])
), ('ebranch', ('eitems', 'ACTION'), 
(lambda ctx,r,a: (flatten(r), a.value))
), ('ebranches', ('|', 'ebranch', 'ebranches'), 
(lambda ctx,_,b,bs: [b,bs])
), ('ebranches', (), 
(lambda ctx: [])
), ('suffix', ('?',), 
(lambda ctx,a: "?")
), ('suffix', ('*',), 
(lambda ctx,a: "*")
), ('suffix', (), 
(lambda ctx: None)
), ('properties', ('ACTION',), 
(lambda ctx,a: eval(a.value))
), ('properties', (), 
(lambda ctx: {})
), ('eitems', ('eitem', 'eitems'), 
(lambda ctx,e,es: [e,es])
), ('eitems', (), 
(lambda ctx: [])
)]
TABLE = [{'start': (True, 1), 'PREFACE': (True, 2)}, {'EOF': (False, None)}, {'EOF': (False, 22), 'properties': (True, 3), 'ACTION': (True, 4), 'NAME': (False, 22)}, {'rules': (True, 5), 'EOF': (False, 8), 'rule': (True, 6), 'NAME': (True, 7)}, {'EOF': (False, 21), 'NAME': (False, 21)}, {'EOF': (False, 0)}, {'rules': (True, 40), 'EOF': (False, 8), 'rule': (True, 6), 'NAME': (True, 7)}, {'=': (True, 8), ':': (True, 9)}, {'names': (True, 29), 'ACTION': (False, 10), 'NAME': (True, 30)}, {'SUBRULEREF': (True, 10), 'eitem': (True, 11), 'ACTION': (False, 24), 'ebranch': (True, 12), '(': (True, 13), 'NAME': (True, 15), 'eitems': (True, 14)}, {'SUBRULEREF': (False, 6), '(': (False, 6), 'ACTION': (False, 6), 'NAME': (False, 6)}, {'SUBRULEREF': (True, 10), 'eitem': (True, 11), 'ACTION': (False, 24), '(': (True, 13), 'eitems': (True, 27), 'NAME': (True, 15)}, {'ebranches': (True, 31), '|': (True, 32), 'EOF': (False, 17), 'NAME': (False, 17)}, {'SUBRULEREF': (True, 18), 'eitem': (True, 19), ')': (False, 24), '|': (False, 24), '(': (True, 20), 'NAME': (True, 23), 'subbranch': (True, 22), 'eitems': (True, 21)}, {'ACTION': (True, 33)}, {'=': (True, 16), 'SUBRULEREF': (False, 2), '+': (True, 17), 'ACTION': (False, 2), '(': (False, 2), 'NAME': (False, 2)}, {'NAME': (True, 26)}, {'=': (True, 28)}, {'SUBRULEREF': (False, 6), '(': (False, 6), '|': (False, 6), ')': (False, 6), 'NAME': (False, 6)}, {'SUBRULEREF': (True, 18), 'eitem': (True, 19), '|': (False, 24), '(': (True, 20), 'eitems': (True, 36), ')': (False, 24), 'NAME': (True, 23)}, {'SUBRULEREF': (True, 18), 'eitem': (True, 19), ')': (False, 24), '|': (False, 24), '(': (True, 20), 'NAME': (True, 23), 'subbranch': (True, 38), 'eitems': (True, 21)}, {'|': (False, 1), ')': (False, 1)}, {'|': (True, 41), ')': (False, 14), 'subbranches': (True, 42)}, {'=': (True, 24), 'SUBRULEREF': (False, 2), '+': (True, 25), '(': (False, 2), '|': (False, 2), ')': (False, 2), 'NAME': (False, 2)}, {'NAME': (True, 37)}, {'=': (True, 39)}, {'SUBRULEREF': (False, 3), '(': (False, 3), 'ACTION': (False, 3), 'NAME': (False, 3)}, {'ACTION': (False, 23)}, {'NAME': (True, 44)}, {'ACTION': (True, 45)}, {'names': (True, 46), 'ACTION': (False, 10), 'NAME': (True, 30)}, {'EOF': (False, 12), 'NAME': (False, 12)}, {'SUBRULEREF': (True, 10), 'eitem': (True, 11), 'ACTION': (False, 24), 'ebranch': (True, 34), '(': (True, 13), 'NAME': (True, 15), 'eitems': (True, 14)}, {'|': (False, 15), 'EOF': (False, 15), 'NAME': (False, 15)}, {'ebranches': (True, 35), '|': (True, 32), 'EOF': (False, 17), 'NAME': (False, 17)}, {'EOF': (False, 16), 'NAME': (False, 16)}, {'|': (False, 23), ')': (False, 23)}, {'SUBRULEREF': (False, 3), '(': (False, 3), '|': (False, 3), ')': (False, 3), 'NAME': (False, 3)}, {'|': (True, 41), ')': (False, 14), 'subbranches': (True, 48)}, {'NAME': (True, 43)}, {'EOF': (False, 7)}, {'SUBRULEREF': (True, 18), 'eitem': (True, 19), ')': (False, 24), '|': (False, 24), '(': (True, 20), 'eitems': (True, 21), 'subbranch': (True, 47), 'NAME': (True, 23)}, {')': (True, 49)}, {'SUBRULEREF': (False, 4), '(': (False, 4), '|': (False, 4), ')': (False, 4), 'NAME': (False, 4)}, {'SUBRULEREF': (False, 4), '(': (False, 4), 'ACTION': (False, 4), 'NAME': (False, 4)}, {'EOF': (False, 11), 'NAME': (False, 11)}, {'ACTION': (False, 9)}, {'|': (True, 41), ')': (False, 14), 'subbranches': (True, 50)}, {')': (True, 51)}, {'SUBRULEREF': (False, 20), 'ACTION': (False, 20), '(': (False, 20), '?': (True, 52), 'suffix': (True, 53), '*': (True, 54), 'NAME': (False, 20)}, {')': (False, 13)}, {'SUBRULEREF': (False, 20), '(': (False, 20), '?': (True, 55), ')': (False, 20), '|': (False, 20), 'suffix': (True, 56), '*': (True, 57), 'NAME': (False, 20)}, {'SUBRULEREF': (False, 18), '(': (False, 18), 'ACTION': (False, 18), 'NAME': (False, 18)}, {'SUBRULEREF': (False, 5), '(': (False, 5), 'ACTION': (False, 5), 'NAME': (False, 5)}, {'SUBRULEREF': (False, 19), '(': (False, 19), 'ACTION': (False, 19), 'NAME': (False, 19)}, {'SUBRULEREF': (False, 18), '(': (False, 18), '|': (False, 18), ')': (False, 18), 'NAME': (False, 18)}, {'SUBRULEREF': (False, 5), '(': (False, 5), '|': (False, 5), ')': (False, 5), 'NAME': (False, 5)}, {'SUBRULEREF': (False, 19), '(': (False, 19), '|': (False, 19), ')': (False, 19), 'NAME': (False, 19)}]
