
from context import Token
from context import ParserContext as BaseParserContext

parsers = {}
from .toycalc_out import parse as parse_toycalc
parsers['toycalc'] = parse_toycalc
from .toypython_out import parse as parse_toypython
parsers['toypython'] = parse_toypython
from .toylua_out import parse as parse_toylua
parsers['toylua'] = parse_toylua

embeds = [('toypython', 'EMBEDEXPR', 'toycalc', None, '%calc(', ')'), ('toylua', 'EMBEDEXPR', 'toycalc', None, '%calc(', ')'), ('toycalc', 'EMBEDSTAT', 'toylua', 'chunk', '<?lua', '?>'), ('toypython', 'EMBEDSTAT', 'toylua', 'chunk', '<?lua', '?>'), ('toycalc', 'EMBEDSTAT', 'toylua', 'chunk', '%lua{', '}'), ('toypython', 'EMBEDSTAT', 'toylua', 'chunk', '%lua{', '}'), ('toycalc', 'EMBEDEXPR', 'toylua', 'exp', '%lua(', ')'), ('toypython', 'EMBEDEXPR', 'toylua', 'exp', '%lua(', ')'), ('toycalc', 'EMBEDSTAT', 'toypython', 'file_input', '<?py', '?>'), ('toylua', 'EMBEDSTAT', 'toypython', 'file_input', '<?py', '?>'), ('toycalc', 'EMBEDSTAT', 'toypython', 'file_input', '%py{', '}'), ('toylua', 'EMBEDSTAT', 'toypython', 'file_input', '%py{', '}'), ('toycalc', 'EMBEDEXPR', 'toypython', 'eval_input', '%py(', ')'), ('toylua', 'EMBEDEXPR', 'toypython', 'eval_input', '%py(', ')')]

class ParserContext(BaseParserContext):
    def embed_token(self, outer_language):
        loc = self.location
        for outer, token_type, inner, start, opener, closer in embeds:
            if outer == outer_language and self.peek(len(opener)) == opener:
                self.advance(len(opener))
                inner_ast = self.parsers[inner](self, start, closer)
                return Token(loc, token_type, inner_ast)

ParserContext.parsers = parsers
ParserContext.embeds = embeds

def parse_text(input):
    ctx = ParserContext(input)
    return parse_toylua(ctx)
