
from context import flatten
from toylua.lex import tokenizer
from toylua.ast import *


def values(tokens):
    return [t.value for t in tokens]


from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [INITIAL[(start_nt or 'chunk', close_with or 'EOF')]]
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        action = TABLE[stack[-1]].get(token.type)

        if action is None:
            nonterminals = { nt for nt, right, action in RULES }
            choices = { repr(k) for k in TABLE[stack[-1]] if k not in nonterminals }
            raise ParseError(token.location, "Unexpected {}, expected {}".format(
                repr(token.type), ', '.join(sorted(choices))))

        is_shift, action_value = action

        if is_shift:
            results.append(token)
            stack.append(action_value)
            token = next(tok_iter)
        else:
            if action_value is None: break
            left, right, rule_action = RULES[action_value]
            n = len(right)

            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(rule_action(ctx, *args))

            del stack[len(stack) - n:]
            new_is_shift, new_state = TABLE[stack[-1]][left]
            assert new_is_shift
            stack.append(new_state)

    return results[0]

INITIAL = {('exp', ')'): 0, ('chunk', 'EOF'): 1, ('chunk', '?>'): 2, ('chunk', '}'): 3}
RULES = [('block__2', ('retstat',), 
(lambda ctx, v1: [('ss', v1)])
), ('block__2', (), 
(lambda ctx: [])
), ('block__1', ('stat', 'block__1'), 
(lambda ctx, v1, v2: [('ss', v1), v2])
), ('block__1', (), 
(lambda ctx: [])
), ('funcname__2', (':', 'NAME'), 
(lambda ctx, v1, v2: [(None, v1), ('c', v2)])
), ('funcname__2', (), 
(lambda ctx: [])
), ('funcbody', ('(', 'funcbody__1', ')', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), v2, (None, v3), ('b', v4), (None, v5)], user=lambda _all, _ctx, _loc, b, a: (
(flatten(a), b)
), normal_vars=['a', 'b'], list_vars=[]))
), ('parlist', ('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), ('parlist', ('NAME', 'parlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('n', v1), v2], user=lambda _all, p, n, _ctx, _loc: (
[n.value, p or []]
), normal_vars=['n', 'p'], list_vars=[]))
), ('tableconstructor', ('{', 'tableconstructor__1', '}'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _all, f, _ctx, _loc: (
TableConstructor(_loc, flatten(f))
), normal_vars=[], list_vars=['f']))
), ('namelist', ('NAME', 'namelist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('ns', v1), v2], user=lambda _all, _ctx, _loc, ns: (
values(ns)
), normal_vars=[], list_vars=['ns']))
), ('prefixexp', ('var',), 
(combine_action(root=lambda ctx, v1: [('v', v1)], user=lambda _all, v, _ctx, _loc: (
v
), normal_vars=['v'], list_vars=[]))
), ('prefixexp', ('functioncall',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda _all, f, _ctx, _loc: (
f
), normal_vars=['f'], list_vars=[]))
), ('prefixexp', ('(', 'exp', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _all, e, _ctx, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), ('varlist', ('var', 'varlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('v', v1), v2], user=lambda _all, v, _ctx, _loc: (
v
), normal_vars=[], list_vars=['v']))
), ('varlist__1', (',', 'var', 'varlist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('v', v2), v3])
), ('varlist__1', (), 
(lambda ctx: [])
), ('funcname__1', ('.', 'NAME', 'funcname__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ('funcname__1', (), 
(lambda ctx: [])
), ('tableconstructor__2', ('fieldsep', 'tableconstructor__1'), 
(lambda ctx, v1, v2: [(None, v1), v2])
), ('tableconstructor__2', (), 
(lambda ctx: [])
), ('functioncall', ('prefixexp', 'args'), 
(combine_action(root=lambda ctx, v1, v2: [('p', v1), ('a', v2)], user=lambda _all, p, _ctx, _loc, a: (
FunctionCall(a[0], p, None, a[1])
), normal_vars=['a', 'p'], list_vars=[]))
), ('functioncall', ('prefixexp', ':', 'NAME', 'args'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [('p', v1), ('d', v2), ('n', v3), ('a', v4)], user=lambda _all, d, n, _ctx, _loc, p, a: (
FunctionCall(d.location, p, n.value, a[1])
), normal_vars=['a', 'd', 'n', 'p'], list_vars=[]))
), ('args', ('(', 'args__1', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _all, e, _ctx, _loc: (
(_loc, e or [])
), normal_vars=['e'], list_vars=[]))
), ('args', ('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda _all, _ctx, _loc, t: (
(t.location, [t])
), normal_vars=['t'], list_vars=[]))
), ('args', ('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _all, s, _ctx, _loc: (
(s.location, [s.value])
), normal_vars=['s'], list_vars=[]))
), ('parlist__1', (',', 'parlist'), 
(lambda ctx, v1, v2: [(None, v1), ('p', v2)])
), ('parlist__1', (), 
(lambda ctx: [])
), ('namelist__1', (',', 'NAME', 'namelist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3])
), ('namelist__1', (), 
(lambda ctx: [])
), ('exp', ('nil',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
LuaNil(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('false',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
LuaFalse(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('true',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
LuaTrue(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _all, n, _ctx, _loc: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('exp', ('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _all, s, _ctx, _loc: (
String(_loc, s.value)
), normal_vars=['s'], list_vars=[]))
), ('exp', ('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _all, e, _ctx, _loc: (
EmbedExpression(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), ('exp', ('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('functiondef',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda _all, f, _ctx, _loc: (
f
), normal_vars=['f'], list_vars=[]))
), ('exp', ('prefixexp',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _all, e, _ctx, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), ('exp', ('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda _all, _ctx, _loc, t: (
t
), normal_vars=['t'], list_vars=[]))
), ('exp', ('exp', 'or', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', 'and', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '<', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '>', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '<=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '>=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '~=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '==', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '..', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '+', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '-', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '*', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '/', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '%', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '^', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda _all, _ctx, op, _loc, l, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('not', 'exp'), 
(combine_action(root=lambda ctx, v1, v2: [('op', v1), ('e', v2)], user=lambda _all, e, op, _ctx, _loc: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), ('exp', ('#', 'exp'), 
(combine_action(root=lambda ctx, v1, v2: [('op', v1), ('e', v2)], user=lambda _all, e, op, _ctx, _loc: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), ('exp', ('-', 'exp'), 
(combine_action(root=lambda ctx, v1, v2: [('op', v1), ('e', v2)], user=lambda _all, e, op, _ctx, _loc: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), ('args__1', ('explist',), 
(lambda ctx, v1: [('e', v1)])
), ('args__1', (), 
(lambda ctx: [])
), ('stat__1', ('elseif', 'exp', 'then', 'block', 'stat__1'), 
(lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5])
), ('stat__1', (), 
(lambda ctx: [])
), ('functiondef', ('function', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('b', v2)], user=lambda _all, _ctx, _loc, b: (
Function(_loc, None, b[0], b[1])
), normal_vars=['b'], list_vars=[]))
), ('stat', (';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
None
), normal_vars=[], list_vars=[]))
), ('stat', ('varlist', '=', 'explist'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('v', v1), (None, v2), ('e', v3)], user=lambda _all, v, e, _ctx, _loc: (
Assignment(v[0].location, v, e)
), normal_vars=['e', 'v'], list_vars=[]))
), ('stat', ('functioncall',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda _all, f, _ctx, _loc: (
f
), normal_vars=['f'], list_vars=[]))
), ('stat', ('label',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _all, s, _ctx, _loc: (
s
), normal_vars=['s'], list_vars=[]))
), ('stat', ('break',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
Break(_loc)
), normal_vars=[], list_vars=[]))
), ('stat', ('goto', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('n', v2)], user=lambda _all, n, _ctx, _loc: (
Goto(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('stat', ('do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('b', v2), (None, v3)], user=lambda _all, _ctx, _loc, b: (
BlockStatement(_loc, b)
), normal_vars=['b'], list_vars=[]))
), ('stat', ('while', 'exp', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), (None, v5)], user=lambda _all, e, _ctx, b, _loc: (
While(_loc, e, b)
), normal_vars=['b', 'e'], list_vars=[]))
), ('stat', ('repeat', 'block', 'until', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), ('b', v2), (None, v3), ('e', v4)], user=lambda _all, e, _ctx, b, _loc: (
Repeat(_loc, b, e)
), normal_vars=['b', 'e'], list_vars=[]))
), ('stat', ('if', 'exp', 'then', 'block', 'stat__1', 'stat__2', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5, v6, (None, v7)], user=lambda _all, e, _ctx, b, _loc: (
If(_loc, e, b)
), normal_vars=[], list_vars=['b', 'e']))
), ('stat', ('for', 'NAME', '=', 'exp', ',', 'exp', 'stat__3', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10: [(None, v1), ('n', v2), (None, v3), ('e1', v4), (None, v5), ('e2', v6), v7, (None, v8), ('b', v9), (None, v10)], user=lambda _all, e2, _loc, e1, n, _ctx, e3, b: (
NumericFor(_loc, n, e1, e2, e3, b)
), normal_vars=['b', 'e1', 'e2', 'e3', 'n'], list_vars=[]))
), ('stat', ('for', 'namelist', 'in', 'explist', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('ns', v2), (None, v3), ('e', v4), (None, v5), ('b', v6), (None, v7)], user=lambda _all, e, _ctx, _loc, ns, b: (
GenericFor(_loc, ns, e, b)
), normal_vars=['b', 'e', 'ns'], list_vars=[]))
), ('stat', ('function', 'funcname', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda _all, n, _ctx, b, _loc: (
Function(_loc, n, b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), ('stat', ('local', 'function', 'NAME', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), (None, v2), ('n', v3), ('b', v4)], user=lambda _all, n, _ctx, b, _loc: (
LocalFunction(_loc, FuncName([n.value], None), b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), ('stat', ('local', 'namelist', 'stat__4'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3], user=lambda es, _all, _ctx, _loc, ns: (
Local(_loc, ns, es)
), normal_vars=['es', 'ns'], list_vars=[]))
), ('stat', ('EMBEDSTAT',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _all, e, _ctx, _loc: (
EmbedStatement(e.location, e.value)
), normal_vars=['e'], list_vars=[]))
), ('fieldsep', (',',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
None
), normal_vars=[], list_vars=[]))
), ('fieldsep', (';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _all, _ctx, _loc: (
None
), normal_vars=[], list_vars=[]))
), ('field', ('[', 'exp', ']', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('k', v2), (None, v3), (None, v4), ('v', v5)], user=lambda _all, v, _ctx, k, _loc: (
Field(_loc, k, v)
), normal_vars=['k', 'v'], list_vars=[]))
), ('field', ('NAME', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), (None, v2), ('v', v3)], user=lambda _all, n, v, _ctx, _loc: (
Field(_loc, String(_loc, n.value), v)
), normal_vars=['n', 'v'], list_vars=[]))
), ('field', ('exp',), 
(combine_action(root=lambda ctx, v1: [('v', v1)], user=lambda _all, v, _ctx, _loc: (
Field(v.location, None, v)
), normal_vars=['v'], list_vars=[]))
), ('var', ('NAME',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _all, n, _ctx, _loc: (
Name(n.location, n.value)
), normal_vars=['n'], list_vars=[]))
), ('var', ('prefixexp', '[', 'exp', ']'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [('p', v1), ('d', v2), ('e', v3), (None, v4)], user=lambda _all, d, e, _ctx, _loc, p: (
Brackets(d.location, p, e)
), normal_vars=['d', 'e', 'p'], list_vars=[]))
), ('var', ('prefixexp', '.', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('p', v1), (None, v2), ('n', v3)], user=lambda _all, p, n, _ctx, _loc: (
Dot(p.location, p, n.value)
), normal_vars=['n', 'p'], list_vars=[]))
), ('block', ('block__1', 'block__2'), 
(combine_action(root=lambda ctx, v1, v2: [v1, v2], user=lambda ss, _all, _ctx, _loc: (
Block(flatten(ss))
), normal_vars=[], list_vars=['ss']))
), ('retstat__2', (';',), 
(lambda ctx, v1: [(None, v1)])
), ('retstat__2', (), 
(lambda ctx: [])
), ('explist', ('exp', 'explist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda _all, e, _ctx, _loc: (
e
), normal_vars=[], list_vars=['e']))
), ('label', ('::', 'NAME', '::'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), (None, v3)], user=lambda _all, n, _ctx, _loc: (
Label(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('explist__1', (',', 'exp', 'explist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), v3])
), ('explist__1', (), 
(lambda ctx: [])
), ('funcname', ('NAME', 'funcname__1', 'funcname__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), v2, v3], user=lambda _all, n, c, _ctx, _loc: (
FuncName(values(n), c.value if c else None)
), normal_vars=['c'], list_vars=['n']))
), ('chunk', ('block',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda _all, _ctx, _loc, a: (
a
), normal_vars=['a'], list_vars=[]))
), ('funcbody__1', ('parlist',), 
(lambda ctx, v1: [('a', v1)])
), ('funcbody__1', (), 
(lambda ctx: [])
), ('stat__2', ('else', 'block'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ('stat__2', (), 
(lambda ctx: [])
), ('tableconstructor__1', ('field', 'tableconstructor__2'), 
(lambda ctx, v1, v2: [('f', v1), v2])
), ('tableconstructor__1', (), 
(lambda ctx: [])
), ('stat__3', (',', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('e3', v2)])
), ('stat__3', (), 
(lambda ctx: [])
), ('stat__4', ('=', 'explist'), 
(lambda ctx, v1, v2: [(None, v1), ('es', v2)])
), ('stat__4', (), 
(lambda ctx: [])
), ('retstat__1', ('explist',), 
(lambda ctx, v1: [('e', v1)])
), ('retstat__1', (), 
(lambda ctx: [])
), ('retstat', ('return', 'retstat__1', 'retstat__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, v3], user=lambda _all, e, _ctx, _loc: (
Return(_loc, e)
), normal_vars=['e'], list_vars=[]))
)]
TABLE = [{'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 726), '...': (True, 290), 'STRING': (True, 289)}, {'block__1': (True, 678), '::': (True, 679), 'break': (True, 680), ';': (True, 696), 'if': (True, 681), 'varlist': (True, 682), 'EMBEDSTAT': (True, 683), 'function': (True, 684), 'EOF': (False, 3), 'functioncall': (True, 685), 'do': (True, 686), 'while': (True, 687), 'prefixexp': (True, 690), 'goto': (True, 689), 'stat': (True, 688), 'var': (True, 18), 'block': (True, 691), 'for': (True, 692), 'label': (True, 693), 'local': (True, 694), 'return': (False, 3), 'chunk': (True, 695), 'NAME': (True, 15), '(': (True, 25), 'repeat': (True, 697)}, {'block__1': (True, 4), '::': (True, 5), 'break': (True, 6), '?>': (False, 3), ';': (True, 24), 'if': (True, 7), 'varlist': (True, 8), 'EMBEDSTAT': (True, 9), 'function': (True, 10), 'functioncall': (True, 11), 'do': (True, 12), 'while': (True, 13), 'prefixexp': (True, 17), 'goto': (True, 16), 'stat': (True, 14), 'var': (True, 18), 'block': (True, 19), 'for': (True, 20), 'label': (True, 21), 'local': (True, 22), 'return': (False, 3), 'chunk': (True, 23), 'NAME': (True, 15), '(': (True, 25), 'repeat': (True, 26)}, {'block__1': (True, 40), '::': (True, 41), 'break': (True, 42), ';': (True, 58), 'if': (True, 43), 'varlist': (True, 44), 'EMBEDSTAT': (True, 45), 'function': (True, 46), 'functioncall': (True, 47), 'do': (True, 48), 'while': (True, 49), 'prefixexp': (True, 52), '}': (False, 3), 'goto': (True, 51), 'stat': (True, 50), 'var': (True, 18), 'block': (True, 53), 'for': (True, 54), 'label': (True, 55), 'local': (True, 56), 'return': (False, 3), 'chunk': (True, 57), 'NAME': (True, 15), '(': (True, 25), 'repeat': (True, 59)}, {'block__2': (True, 37), '?>': (False, 1), 'return': (True, 38), 'retstat': (True, 39)}, {'NAME': (True, 68)}, {'::': (False, 67), 'break': (False, 67), '(': (False, 67), 'if': (False, 67), 'EMBEDSTAT': (False, 67), 'function': (False, 67), 'do': (False, 67), 'while': (False, 67), 'NAME': (False, 67), 'repeat': (False, 67), 'for': (False, 67), 'local': (False, 67), 'return': (False, 67), ';': (False, 67), '?>': (False, 67), 'goto': (False, 67)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 638), 'true': (True, 126), 'STRING': (True, 125)}, {'=': (True, 635)}, {'::': (False, 78), 'break': (False, 78), '(': (False, 78), 'if': (False, 78), 'EMBEDSTAT': (False, 78), 'function': (False, 78), 'do': (False, 78), 'while': (False, 78), 'NAME': (False, 78), 'goto': (False, 78), 'for': (False, 78), 'local': (False, 78), 'return': (False, 78), ';': (False, 78), '?>': (False, 78), 'repeat': (False, 78)}, {'NAME': (True, 184), 'funcname': (True, 662)}, {'.': (False, 12), '::': (False, 65), 'break': (False, 65), '?>': (False, 65), '{': (False, 12), 'if': (False, 65), 'EMBEDSTAT': (False, 65), 'function': (False, 65), 'do': (False, 65), 'while': (False, 65), 'NAME': (False, 65), 'repeat': (False, 65), 'STRING': (False, 12), ':': (False, 12), 'for': (False, 65), 'local': (False, 65), 'return': (False, 65), '[': (False, 12), ';': (False, 65), '(': (False, 12), 'goto': (False, 65)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 698), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 700), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 675), '::': (True, 5), 'break': (True, 6), '?>': (False, 3), 'if': (True, 7), 'varlist': (True, 8), 'EMBEDSTAT': (True, 9), 'function': (True, 10), 'functioncall': (True, 11), 'do': (True, 12), 'while': (True, 13), 'prefixexp': (True, 17), 'NAME': (True, 15), 'repeat': (True, 26), 'stat': (True, 14), 'var': (True, 18), 'for': (True, 20), 'label': (True, 21), 'local': (True, 22), 'return': (False, 3), ';': (True, 24), '(': (True, 25), 'goto': (True, 16)}, {'.': (False, 84), ':': (False, 84), '{': (False, 84), '=': (False, 84), '[': (False, 84), ',': (False, 84), '(': (False, 84), 'STRING': (False, 84)}, {'NAME': (True, 35)}, {'.': (True, 27), 'STRING': (True, 34), ':': (True, 28), '(': (True, 29), 'tableconstructor': (True, 30), 'args': (True, 31), '{': (True, 32), '[': (True, 33)}, {'.': (False, 11), ':': (False, 11), '{': (False, 11), '=': (False, 16), 'varlist__1': (True, 67), '[': (False, 11), ',': (True, 66), '(': (False, 11), 'STRING': (False, 11)}, {'?>': (False, 95)}, {'namelist': (True, 723), 'NAME': (True, 724)}, {'::': (False, 66), 'break': (False, 66), '(': (False, 66), 'if': (False, 66), 'EMBEDSTAT': (False, 66), 'function': (False, 66), 'do': (False, 66), 'while': (False, 66), 'NAME': (False, 66), 'repeat': (False, 66), 'for': (False, 66), 'local': (False, 66), 'return': (False, 66), ';': (False, 66), '?>': (False, 66), 'goto': (False, 66)}, {'namelist': (True, 727), 'NAME': (True, 728), 'function': (True, 729)}, {'?>': (False, None)}, {'::': (False, 63), 'break': (False, 63), '?>': (False, 63), 'if': (False, 63), 'EMBEDSTAT': (False, 63), 'function': (False, 63), 'do': (False, 63), 'while': (False, 63), 'NAME': (False, 63), 'goto': (False, 63), 'for': (False, 63), 'local': (False, 63), 'return': (False, 63), ';': (False, 63), '(': (False, 63), 'repeat': (False, 63)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 764), '...': (True, 290), 'STRING': (True, 289)}, {'block__1': (True, 299), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'goto': (True, 310), 'stat': (True, 309), 'var': (True, 18), 'block': (True, 740), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'repeat': (True, 317)}, {'NAME': (True, 36)}, {'NAME': (True, 62)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 88), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '::': (False, 24), 'break': (False, 24), '?>': (False, 24), '{': (False, 24), 'if': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'do': (False, 24), 'while': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), 'STRING': (False, 24), ':': (False, 24), 'for': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), ';': (False, 24), '(': (False, 24), 'repeat': (False, 24)}, {'.': (False, 21), '::': (False, 21), 'break': (False, 21), '?>': (False, 21), '{': (False, 21), 'if': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'do': (False, 21), 'while': (False, 21), ';': (False, 21), 'repeat': (False, 21), 'STRING': (False, 21), ':': (False, 21), 'for': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'NAME': (False, 21), '(': (False, 21), 'goto': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 151), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 167), 'true': (True, 178), 'STRING': (True, 177)}, {'.': (False, 25), '::': (False, 25), 'break': (False, 25), '?>': (False, 25), '{': (False, 25), 'if': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'repeat': (False, 25), 'do': (False, 25), 'while': (False, 25), 'NAME': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), ';': (False, 25), '(': (False, 25), 'goto': (False, 25)}, {'::': (False, 68), 'break': (False, 68), '(': (False, 68), 'if': (False, 68), 'EMBEDSTAT': (False, 68), 'function': (False, 68), 'do': (False, 68), 'while': (False, 68), 'NAME': (False, 68), 'goto': (False, 68), 'for': (False, 68), 'local': (False, 68), 'return': (False, 68), ';': (False, 68), '?>': (False, 68), 'repeat': (False, 68)}, {'.': (False, 86), ':': (False, 86), '{': (False, 86), '=': (False, 86), '[': (False, 86), ',': (False, 86), '(': (False, 86), 'STRING': (False, 86)}, {'?>': (False, 87)}, {'?>': (False, 107), ';': (False, 107), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), 'prefixexp': (True, 746), 'function': (True, 743), '#': (True, 744), 'functioncall': (True, 745), 'explist': (True, 752), 'true': (True, 747), 'STRING': (True, 748), '-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 754), 'var': (True, 753), 'retstat__1': (True, 760), '{': (True, 755), 'nil': (True, 756), 'NAME': (True, 757), '(': (True, 758), 'not': (True, 759), '...': (True, 761), 'NUMBER': (True, 762)}, {'?>': (False, 0)}, {'block__2': (True, 108), '}': (False, 1), 'return': (True, 109), 'retstat': (True, 110)}, {'NAME': (True, 111)}, {'::': (False, 67), 'break': (False, 67), 'if': (False, 67), 'EMBEDSTAT': (False, 67), 'function': (False, 67), 'do': (False, 67), 'while': (False, 67), '}': (False, 67), 'repeat': (False, 67), 'for': (False, 67), 'NAME': (False, 67), 'local': (False, 67), 'return': (False, 67), ';': (False, 67), '(': (False, 67), 'goto': (False, 67)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 115), 'true': (True, 126), 'STRING': (True, 125)}, {'=': (True, 155)}, {'::': (False, 78), 'break': (False, 78), 'if': (False, 78), 'EMBEDSTAT': (False, 78), 'function': (False, 78), 'do': (False, 78), 'while': (False, 78), '}': (False, 78), 'goto': (False, 78), 'for': (False, 78), 'NAME': (False, 78), 'local': (False, 78), 'return': (False, 78), ';': (False, 78), '(': (False, 78), 'repeat': (False, 78)}, {'NAME': (True, 184), 'funcname': (True, 185)}, {'.': (False, 12), '::': (False, 65), 'break': (False, 65), '{': (False, 12), 'if': (False, 65), 'EMBEDSTAT': (False, 65), 'function': (False, 65), 'do': (False, 65), 'while': (False, 65), 'NAME': (False, 65), 'repeat': (False, 65), 'STRING': (False, 12), ':': (False, 12), 'for': (False, 65), 'local': (False, 65), 'return': (False, 65), '[': (False, 12), '}': (False, 65), ';': (False, 65), '(': (False, 12), 'goto': (False, 65)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 201), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 210), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 229), '::': (True, 41), 'break': (True, 42), 'if': (True, 43), 'varlist': (True, 44), 'EMBEDSTAT': (True, 45), 'function': (True, 46), 'functioncall': (True, 47), 'do': (True, 48), 'while': (True, 49), 'prefixexp': (True, 52), 'NAME': (True, 15), 'repeat': (True, 59), 'stat': (True, 50), 'var': (True, 18), 'for': (True, 54), 'label': (True, 55), 'local': (True, 56), 'return': (False, 3), '}': (False, 3), ';': (True, 58), '(': (True, 25), 'goto': (True, 51)}, {'NAME': (True, 246)}, {'.': (True, 27), 'STRING': (True, 256), ':': (True, 251), '(': (True, 252), 'tableconstructor': (True, 253), 'args': (True, 254), '{': (True, 255), '[': (True, 33)}, {'}': (False, 95)}, {'namelist': (True, 60), 'NAME': (True, 61)}, {'::': (False, 66), 'break': (False, 66), 'if': (False, 66), 'EMBEDSTAT': (False, 66), 'function': (False, 66), 'do': (False, 66), 'while': (False, 66), '}': (False, 66), 'repeat': (False, 66), 'for': (False, 66), 'NAME': (False, 66), 'local': (False, 66), 'return': (False, 66), ';': (False, 66), '(': (False, 66), 'goto': (False, 66)}, {'namelist': (True, 63), 'NAME': (True, 64), 'function': (True, 65)}, {'}': (False, None)}, {'::': (False, 63), 'break': (False, 63), 'if': (False, 63), 'EMBEDSTAT': (False, 63), 'function': (False, 63), 'do': (False, 63), 'while': (False, 63), '}': (False, 63), 'goto': (False, 63), 'for': (False, 63), 'NAME': (False, 63), 'local': (False, 63), 'return': (False, 63), ';': (False, 63), '(': (False, 63), 'repeat': (False, 63)}, {'block__1': (True, 299), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'goto': (True, 310), 'stat': (True, 309), 'var': (True, 18), 'block': (True, 312), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'repeat': (True, 317)}, {'in': (True, 321)}, {'in': (False, 29), 'namelist__1': (True, 323), ',': (True, 324), '=': (True, 325)}, {'args': (True, 1062), '{': (True, 32), 'tableconstructor': (True, 30), '(': (True, 29), 'STRING': (True, 34)}, {'::': (False, 105), 'break': (False, 105), 'if': (False, 105), 'EMBEDSTAT': (False, 105), 'function': (False, 105), 'do': (False, 105), 'while': (False, 105), '}': (False, 105), 'repeat': (False, 105), 'for': (False, 105), '=': (True, 1213), 'local': (False, 105), 'return': (False, 105), 'NAME': (False, 105), ';': (False, 105), '(': (False, 105), 'goto': (False, 105), 'stat__4': (True, 1214)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 1215), ';': (False, 29), '}': (False, 29), 'repeat': (False, 29), 'for': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), 'NAME': (False, 29), ',': (True, 1216), '(': (False, 29), 'goto': (False, 29)}, {'NAME': (True, 1218)}, {'prefixexp': (True, 849), '(': (True, 25), 'NAME': (True, 15), 'var': (True, 848), 'functioncall': (True, 850)}, {'=': (False, 14)}, {'::': (True, 878)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), '/': (False, 39), 'and': (False, 39), ')': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ')': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 227), '(': (True, 228)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 230), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '<': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), ')': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'.': (True, 257), '..': (False, 38), '~=': (False, 38), '==': (False, 38), 'tableconstructor': (True, 261), '/': (False, 38), '<': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 262), 'STRING': (True, 258), '-': (False, 38), ')': (False, 38), ':': (True, 259), 'or': (False, 38), '{': (True, 263), '>': (False, 38), '[': (True, 264), 'and': (False, 38), ',': (False, 38), '(': (True, 260), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), '>': (False, 32), 'and': (False, 32), ')': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '<': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), ')': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 271), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '<': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), '/': (False, 31), ')': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '/': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), '-': (False, 37), ')': (False, 37), 'or': (False, 37), '>': (False, 37), 'and': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'..': (True, 91), '-': (True, 92), '+': (True, 93), '==': (True, 95), ')': (False, 93), 'or': (True, 96), '<': (True, 102), '/': (True, 98), '>': (True, 99), 'explist__1': (True, 100), 'and': (True, 97), '^': (True, 101), '>=': (True, 105), ',': (True, 94), '*': (True, 104), '~=': (True, 103), '%': (True, 106), '<=': (True, 107)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '>': (False, 11), '<': (False, 11), '^': (False, 11), '~=': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), ')': (False, 11), ':': (False, 11), 'or': (False, 11), '/': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {')': (False, 58)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 318), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '<': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), '/': (False, 30), ')': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), ')': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), ',': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 319), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 320), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {')': (True, 322)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '<': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), '-': (False, 36), 'and': (False, 36), 'or': (False, 36), '>': (False, 36), ')': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '/': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), '-': (False, 33), '<': (False, 33), 'or': (False, 33), '>': (False, 33), 'and': (False, 33), ')': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 441), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 442), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 443), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 444), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 445), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 446), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 447), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 448), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 470), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {')': (False, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 472), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 493), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 494), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 495), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 496), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 501), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'exp': (True, 502), 'functioncall': (True, 73), 'var': (True, 81), 'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), '{': (True, 83), 'function': (True, 71), '#': (True, 72), 'nil': (True, 84), 'STRING': (True, 76), 'true': (True, 75), '(': (True, 86), 'not': (True, 87), 'prefixexp': (True, 74), 'NAME': (True, 85), '...': (True, 89), 'NUMBER': (True, 90)}, {'}': (False, 87)}, {';': (False, 107), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'prefixexp': (True, 137), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'explist': (True, 509), '}': (False, 107), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 510), 'var': (True, 145), 'retstat__1': (True, 511), '{': (True, 146), 'nil': (True, 148), 'NAME': (True, 186), '(': (True, 150), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'}': (False, 0)}, {'::': (True, 516)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'tableconstructor': (True, 116), 'EMBEDEXPR': (True, 120), '{': (True, 121), 'NUMBER': (True, 131), 'function': (True, 122), '#': (True, 123), 'nil': (True, 119), '...': (True, 130), 'functioncall': (True, 117), 'not': (True, 128), 'exp': (True, 503), 'NAME': (True, 124), 'true': (True, 126), 'STRING': (True, 125)}, {'..': (False, 31), '+': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '~=': (False, 31), '*': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), 'then': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '/': (False, 37), '<': (False, 37), 'then': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (True, 504), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), '/': (False, 39), 'and': (False, 39), 'then': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'.': (False, 12), '..': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '~=': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), 'and': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), '<': (False, 12), 'then': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '~=': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), '[': (False, 11), 'and': (False, 11), 'then': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), 'then': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 35), '~=': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '+': (False, 35), '*': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), '/': (False, 35), '<': (False, 35), 'then': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 625), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'funcbody': (True, 626), '(': (True, 627)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 629), 'true': (True, 126), 'STRING': (True, 125)}, {'.': (False, 84), '..': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), 'then': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 34), '+': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '~=': (False, 34), '*': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), 'then': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'..': (False, 32), '+': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '~=': (False, 32), '*': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), 'then': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 639), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 641), 'true': (True, 126), 'STRING': (True, 125)}, {'.': (True, 663), '..': (False, 38), '+': (False, 38), '==': (False, 38), 'tableconstructor': (True, 667), '/': (False, 38), '^': (False, 38), '~=': (False, 38), '*': (False, 38), 'args': (True, 668), 'STRING': (True, 664), '-': (False, 38), '<': (False, 38), ':': (True, 665), 'or': (False, 38), '{': (True, 669), '>': (False, 38), '[': (True, 670), 'and': (False, 38), 'then': (False, 38), '(': (True, 666), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 36), '~=': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '+': (False, 36), '*': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), 'then': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '/': (False, 33), '<': (False, 33), 'then': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), ';': (False, 39), '}': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), '/': (False, 39), '<': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), ';': (False, 35), '}': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 1000), '(': (True, 1001)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1002), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), ',': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), '}': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'.': (True, 156), '..': (False, 38), '~=': (False, 38), '==': (False, 38), '{': (True, 160), '/': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 161), ';': (False, 38), '}': (False, 38), 'STRING': (True, 157), '-': (False, 38), '<': (False, 38), ':': (True, 158), 'or': (False, 38), 'tableconstructor': (True, 162), '>': (False, 38), '[': (True, 163), 'and': (False, 38), ',': (False, 38), '(': (True, 159), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), ';': (False, 32), '}': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), ';': (False, 34), '}': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 187), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), ';': (False, 31), '}': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '/': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), ';': (False, 37), '}': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '>': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), ',': (False, 83), '==': (True, 234), 'or': (True, 235), '<': (True, 240), '/': (True, 237), '>': (True, 238), 'and': (True, 236), '^': (True, 239), '~=': (True, 241), '*': (True, 242), '>=': (True, 243), '%': (True, 244), ';': (False, 83), '}': (False, 83), '<=': (True, 245)}, {'tableconstructor__2': (True, 247), ';': (True, 248), 'fieldsep': (True, 249), ',': (True, 250), '}': (False, 20)}, {'..': (False, 11), '.': (False, 11), '~=': (False, 11), ',': (False, 11), '==': (False, 11), '{': (False, 11), '>': (False, 11), '^': (False, 11), '+': (False, 11), '*': (False, 11), '}': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '/': (False, 11), '[': (False, 11), 'and': (False, 11), ';': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 266), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 268), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), ';': (False, 30), '}': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '/': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), '}': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '=': (True, 273), '>': (False, 84), '[': (False, 84), '<': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 279), '...': (True, 290), 'STRING': (True, 289)}, {'}': (True, 297)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 298), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), ';': (False, 36), '}': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '/': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), ';': (False, 33), '}': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '>': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'prefixexp': (True, 329), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), 'exp': (True, 344), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'explist': (True, 335), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'NAME': (True, 913)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), ',': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), '}': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '>': (False, 25), '[': (False, 25), '<': (False, 25), ';': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 914)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 918), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 920), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), ',': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), '}': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '>': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), ',': (False, 24), '==': (False, 24), '{': (False, 24), '>': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), '}': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '/': (False, 24), '[': (False, 24), 'and': (False, 24), ';': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 924), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 763), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (False, 31), '+': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '~=': (False, 31), ']': (False, 31), '*': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), ']': (False, 37), '*': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '/': (False, 37), '<': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'-': (True, 362), '^': (True, 370), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '<': (True, 363), '~=': (True, 371), ']': (True, 372), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), ']': (False, 39), '*': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), '/': (False, 39), 'and': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'.': (False, 12), '..': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '~=': (False, 12), ']': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), 'and': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), '<': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '~=': (False, 11), ']': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), '[': (False, 11), 'and': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 854), '(': (True, 855)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), ']': (False, 35), '*': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 867), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), ']': (False, 30), '*': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 873), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), ']': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 34), '+': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '~=': (False, 34), ']': (False, 34), '*': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'..': (False, 32), '+': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '~=': (False, 32), ']': (False, 32), '*': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 880), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 883), 'true': (True, 178), 'STRING': (True, 177)}, {'.': (True, 905), '..': (False, 38), '+': (False, 38), '==': (False, 38), 'tableconstructor': (True, 909), '/': (False, 38), '^': (False, 38), '~=': (False, 38), ']': (False, 38), '*': (False, 38), 'args': (True, 910), 'STRING': (True, 906), '-': (False, 38), '<': (False, 38), ':': (True, 907), 'or': (False, 38), '{': (True, 911), '>': (False, 38), '[': (True, 912), 'and': (False, 38), '(': (True, 908), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 36), '~=': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '+': (False, 36), ']': (False, 36), '*': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), ']': (False, 33), '*': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '/': (False, 33), '<': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'.': (True, 927), 'funcname__1': (True, 928), '(': (False, 18), ':': (False, 18)}, {'funcbody': (True, 929), '(': (True, 930)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), '}': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 239), '~=': (False, 57), '*': (False, 57), ';': (False, 57), '}': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'block__2': (True, 347), 'end': (False, 1), 'return': (True, 348), 'retstat': (True, 349)}, {'NAME': (True, 350)}, {'::': (False, 67), 'break': (False, 67), 'if': (False, 67), 'EMBEDSTAT': (False, 67), 'function': (False, 67), 'do': (False, 67), 'while': (False, 67), 'NAME': (False, 67), 'repeat': (False, 67), 'for': (False, 67), 'end': (False, 67), 'local': (False, 67), 'return': (False, 67), ';': (False, 67), '(': (False, 67), 'goto': (False, 67)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 351), 'true': (True, 126), 'STRING': (True, 125)}, {'=': (True, 352)}, {'::': (False, 78), 'break': (False, 78), 'if': (False, 78), 'EMBEDSTAT': (False, 78), 'function': (False, 78), 'do': (False, 78), 'while': (False, 78), 'NAME': (False, 78), 'goto': (False, 78), 'for': (False, 78), 'end': (False, 78), 'local': (False, 78), 'return': (False, 78), ';': (False, 78), '(': (False, 78), 'repeat': (False, 78)}, {'NAME': (True, 184), 'funcname': (True, 378)}, {'.': (False, 12), '::': (False, 65), 'break': (False, 65), '{': (False, 12), 'if': (False, 65), 'EMBEDSTAT': (False, 65), 'function': (False, 65), 'do': (False, 65), 'while': (False, 65), 'NAME': (False, 65), 'repeat': (False, 65), 'STRING': (False, 12), ':': (False, 12), 'for': (False, 65), 'end': (False, 65), 'local': (False, 65), 'return': (False, 65), '[': (False, 12), ';': (False, 65), '(': (False, 12), 'goto': (False, 65)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 380), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 383), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 418), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'repeat': (True, 206), 'stat': (True, 198), 'var': (True, 18), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'goto': (True, 199)}, {'NAME': (True, 427)}, {'.': (True, 27), 'STRING': (True, 433), ':': (True, 428), '(': (True, 429), 'tableconstructor': (True, 430), 'args': (True, 431), '{': (True, 432), '[': (True, 33)}, {'end': (True, 434)}, {'namelist': (True, 435), 'NAME': (True, 436)}, {'::': (False, 66), 'break': (False, 66), 'if': (False, 66), 'EMBEDSTAT': (False, 66), 'function': (False, 66), 'do': (False, 66), 'while': (False, 66), ';': (False, 66), 'repeat': (False, 66), 'for': (False, 66), 'end': (False, 66), 'local': (False, 66), 'return': (False, 66), 'NAME': (False, 66), '(': (False, 66), 'goto': (False, 66)}, {'namelist': (True, 437), 'NAME': (True, 438), 'function': (True, 439)}, {'::': (False, 63), 'break': (False, 63), 'if': (False, 63), 'EMBEDSTAT': (False, 63), 'function': (False, 63), 'do': (False, 63), 'while': (False, 63), 'NAME': (False, 63), 'goto': (False, 63), 'for': (False, 63), 'end': (False, 63), 'local': (False, 63), 'return': (False, 63), ';': (False, 63), '(': (False, 63), 'repeat': (False, 63)}, {'block__1': (True, 299), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'goto': (True, 310), 'stat': (True, 309), 'var': (True, 18), 'block': (True, 440), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'repeat': (True, 317)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1183), 'true': (True, 221), 'STRING': (True, 220)}, {'..': (False, 31), '+': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '~=': (False, 31), '*': (False, 31), 'do': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), 'do': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '/': (False, 37), '<': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '<': (True, 1053), '>': (True, 1052), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'do': (True, 1204), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '<=': (True, 1060)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), 'do': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), '/': (False, 39), 'and': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'.': (False, 12), '..': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '~=': (False, 12), '*': (False, 12), 'do': (False, 12), 'STRING': (False, 12), '-': (False, 12), 'and': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), '<': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '~=': (False, 11), '*': (False, 11), 'do': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), '[': (False, 11), 'and': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1209), '(': (True, 1210)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), 'do': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1211), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), 'do': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1217), 'true': (True, 221), 'STRING': (True, 220)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'do': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 34), '+': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '~=': (False, 34), '*': (False, 34), 'do': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'..': (False, 32), '+': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '~=': (False, 32), '*': (False, 32), 'do': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 379), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 382), 'true': (True, 221), 'STRING': (True, 220)}, {'.': (True, 419), '..': (False, 38), '+': (False, 38), '==': (False, 38), 'tableconstructor': (True, 423), '/': (False, 38), '^': (False, 38), '~=': (False, 38), '*': (False, 38), 'do': (False, 38), 'args': (True, 424), 'STRING': (True, 420), '-': (False, 38), '<': (False, 38), ':': (True, 421), 'or': (False, 38), '{': (True, 425), '>': (False, 38), '[': (True, 426), 'and': (False, 38), '(': (True, 422), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 36), '~=': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '+': (False, 36), '*': (False, 36), 'do': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), 'do': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '/': (False, 33), '<': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '<': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), '-': (False, 62), ')': (False, 62), 'or': (False, 62), '/': (False, 62), 'and': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 497), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'}': (False, 2), 'return': (False, 2)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 101), '~=': (False, 56), '*': (False, 56), '-': (False, 56), 'and': (False, 56), ')': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1122), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1124), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1141), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1142), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1143), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1145), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1148), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1149), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1160), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1161), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1164), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1165), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1168), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1169), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1171), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'::': (False, 68), 'break': (False, 68), 'if': (False, 68), 'EMBEDSTAT': (False, 68), 'function': (False, 68), 'do': (False, 68), 'while': (False, 68), '}': (False, 68), 'goto': (False, 68), 'for': (False, 68), 'NAME': (False, 68), 'local': (False, 68), 'return': (False, 68), ';': (False, 68), '(': (False, 68), 'repeat': (False, 68)}, {'}': (False, 100)}, {'{': (False, 80), 'EMBEDEXPR': (False, 80), 'function': (False, 80), '#': (False, 80), '}': (False, 80), 'true': (False, 80), 'STRING': (False, 80), '-': (False, 80), 'false': (False, 80), '[': (False, 80), 'nil': (False, 80), 'NAME': (False, 80), '(': (False, 80), 'not': (False, 80), '...': (False, 80), 'NUMBER': (False, 80)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1184), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'{': (False, 79), 'EMBEDEXPR': (False, 79), 'function': (False, 79), '#': (False, 79), '}': (False, 79), 'true': (False, 79), 'STRING': (False, 79), '-': (False, 79), 'false': (False, 79), '[': (False, 79), 'nil': (False, 79), 'NAME': (False, 79), '(': (False, 79), 'not': (False, 79), '...': (False, 79), 'NUMBER': (False, 79)}, {'NAME': (True, 1206)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1205), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '::': (False, 24), 'break': (False, 24), '{': (False, 24), 'if': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'do': (False, 24), 'while': (False, 24), '}': (False, 24), 'goto': (False, 24), 'STRING': (False, 24), ':': (False, 24), 'for': (False, 24), 'NAME': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), ';': (False, 24), '(': (False, 24), 'repeat': (False, 24)}, {'.': (False, 21), '::': (False, 21), 'break': (False, 21), '{': (False, 21), 'if': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'do': (False, 21), 'while': (False, 21), ';': (False, 21), '}': (False, 21), 'repeat': (False, 21), 'STRING': (False, 21), ':': (False, 21), 'for': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'NAME': (False, 21), '(': (False, 21), 'goto': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1208), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 25), '::': (False, 25), 'break': (False, 25), '{': (False, 25), 'if': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'repeat': (False, 25), 'do': (False, 25), 'while': (False, 25), '}': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), 'NAME': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), ';': (False, 25), '(': (False, 25), 'goto': (False, 25)}, {'NAME': (True, 265)}, {'.': (False, 25), '..': (False, 25), '~=': (False, 25), '==': (False, 25), '{': (False, 25), '>': (False, 25), '<': (False, 25), '^': (False, 25), '+': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), ')': (False, 25), ':': (False, 25), 'or': (False, 25), '/': (False, 25), '[': (False, 25), 'and': (False, 25), ',': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 267)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 269), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), '>': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'and': (False, 24), 'STRING': (False, 24), '-': (False, 24), ')': (False, 24), ':': (False, 24), 'or': (False, 24), '/': (False, 24), '[': (False, 24), '<': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), 'and': (False, 21), ':': (False, 21), ')': (False, 21), 'or': (False, 21), '>': (False, 21), '[': (False, 21), '<': (False, 21), ',': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 274), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 275), 'true': (True, 178), 'STRING': (True, 177)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '>': (False, 86), '<': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), ')': (False, 86), ':': (False, 86), 'or': (False, 86), '/': (False, 86), '[': (False, 86), 'and': (False, 86), ',': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'}': (True, 400)}, {'args': (True, 270), '{': (True, 263), 'tableconstructor': (True, 261), '(': (True, 260), 'STRING': (True, 258)}, {'-': (True, 362), '^': (True, 370), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '<': (True, 363), '~=': (True, 371), ']': (True, 672), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {')': (True, 272)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '/': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'and': (False, 22), 'STRING': (False, 22), '-': (False, 22), ')': (False, 22), ':': (False, 22), 'or': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ',': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 101), '~=': (False, 57), '*': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), '/': (False, 57), 'and': (False, 57), ')': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'.': (False, 23), '..': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '<': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), 'and': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), ')': (False, 23), ',': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 296), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'}': (True, 353)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 381), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'NUMBER': (True, 295), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'exp': (True, 712), 'NAME': (True, 288), '...': (True, 290), 'STRING': (True, 289)}, {'..': (False, 31), '+': (False, 31), '==': (False, 31), '>': (False, 31), '<': (False, 31), '^': (False, 31), '~=': (False, 31), '*': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), '/': (False, 31), ')': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), '-': (False, 37), ')': (False, 37), 'or': (False, 37), '/': (False, 37), 'and': (False, 37), '<': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'-': (True, 401), ')': (True, 716), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '<': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), '-': (False, 39), ')': (False, 39), 'or': (False, 39), '/': (False, 39), 'and': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 719), '...': (True, 290), 'STRING': (True, 289)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '~=': (False, 11), '*': (False, 11), 'and': (False, 11), 'STRING': (False, 11), '-': (False, 11), ')': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), '[': (False, 11), '<': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 721), '(': (True, 722)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ')': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 725), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '<': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), '/': (False, 30), ')': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 730), '...': (True, 290), 'STRING': (True, 289)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '/': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), ')': (False, 84), 'or': (False, 84), '>': (False, 84), '[': (False, 84), '<': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 34), '+': (False, 34), '==': (False, 34), '/': (False, 34), '<': (False, 34), '^': (False, 34), '~=': (False, 34), '*': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), ')': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'..': (False, 36), '~=': (False, 36), '==': (False, 36), '/': (False, 36), '<': (False, 36), '^': (False, 36), '+': (False, 36), '*': (False, 36), '-': (False, 36), 'and': (False, 36), 'or': (False, 36), '>': (False, 36), ')': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'.': (False, 12), '..': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '<': (False, 12), '^': (False, 12), '~=': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), ')': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 731), '...': (True, 290), 'STRING': (True, 289)}, {'.': (True, 732), '..': (False, 38), '+': (False, 38), '==': (False, 38), 'tableconstructor': (True, 736), '/': (False, 38), '<': (False, 38), '^': (False, 38), '~=': (False, 38), '*': (False, 38), 'args': (True, 737), 'STRING': (True, 733), '-': (False, 38), ')': (False, 38), ':': (True, 734), 'or': (False, 38), '{': (True, 738), '>': (False, 38), '[': (True, 739), 'and': (False, 38), '(': (True, 735), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '+': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '~=': (False, 32), '*': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), '>': (False, 32), 'and': (False, 32), ')': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), '-': (False, 33), ')': (False, 33), 'or': (False, 33), '/': (False, 33), 'and': (False, 33), '<': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), ',': (False, 82), '==': (True, 234), 'or': (True, 235), '<': (True, 240), '/': (True, 237), '>': (True, 238), 'and': (True, 236), '^': (True, 239), '~=': (True, 241), '*': (True, 242), '>=': (True, 243), '%': (True, 244), ';': (False, 82), '}': (False, 82), '<=': (True, 245)}, {'.': (False, 9), '::': (False, 9), 'break': (False, 9), '?>': (False, 9), '{': (False, 9), 'if': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'do': (False, 9), 'while': (False, 9), 'NAME': (False, 9), 'goto': (False, 9), 'STRING': (False, 9), ':': (False, 9), 'for': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), ';': (False, 9), '(': (False, 9), 'repeat': (False, 9)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 239), '~=': (False, 55), '*': (False, 55), ';': (False, 55), '}': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'block__2': (True, 517), 'until': (False, 1), 'return': (True, 518), 'retstat': (True, 519)}, {'NAME': (True, 520)}, {'::': (False, 67), 'break': (False, 67), 'if': (False, 67), 'EMBEDSTAT': (False, 67), 'function': (False, 67), 'do': (False, 67), 'while': (False, 67), 'NAME': (False, 67), 'repeat': (False, 67), 'for': (False, 67), 'until': (False, 67), 'local': (False, 67), 'return': (False, 67), ';': (False, 67), '(': (False, 67), 'goto': (False, 67)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 522), 'true': (True, 126), 'STRING': (True, 125)}, {'=': (True, 540)}, {'::': (False, 78), 'break': (False, 78), 'if': (False, 78), 'EMBEDSTAT': (False, 78), 'function': (False, 78), 'do': (False, 78), 'while': (False, 78), 'NAME': (False, 78), 'goto': (False, 78), 'for': (False, 78), 'until': (False, 78), 'local': (False, 78), 'return': (False, 78), ';': (False, 78), '(': (False, 78), 'repeat': (False, 78)}, {'NAME': (True, 184), 'funcname': (True, 541)}, {'.': (False, 12), '::': (False, 65), 'break': (False, 65), '{': (False, 12), 'if': (False, 65), 'EMBEDSTAT': (False, 65), 'function': (False, 65), 'do': (False, 65), 'while': (False, 65), 'NAME': (False, 65), 'repeat': (False, 65), 'STRING': (False, 12), ':': (False, 12), 'for': (False, 65), 'until': (False, 65), 'local': (False, 65), 'return': (False, 65), '[': (False, 12), ';': (False, 65), '(': (False, 12), 'goto': (False, 65)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 543), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 544), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 545), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'repeat': (True, 317), 'stat': (True, 309), 'var': (True, 18), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'goto': (True, 310)}, {'NAME': (True, 546)}, {'.': (True, 27), 'STRING': (True, 553), ':': (True, 548), '(': (True, 549), 'tableconstructor': (True, 550), 'args': (True, 551), '{': (True, 552), '[': (True, 33)}, {'until': (True, 554)}, {'namelist': (True, 555), 'NAME': (True, 556)}, {'::': (False, 66), 'break': (False, 66), 'if': (False, 66), 'EMBEDSTAT': (False, 66), 'function': (False, 66), 'do': (False, 66), 'while': (False, 66), ';': (False, 66), 'repeat': (False, 66), 'for': (False, 66), 'until': (False, 66), 'local': (False, 66), 'return': (False, 66), 'NAME': (False, 66), '(': (False, 66), 'goto': (False, 66)}, {'namelist': (True, 557), 'NAME': (True, 558), 'function': (True, 559)}, {'::': (False, 63), 'break': (False, 63), 'if': (False, 63), 'EMBEDSTAT': (False, 63), 'function': (False, 63), 'do': (False, 63), 'while': (False, 63), 'NAME': (False, 63), 'goto': (False, 63), 'for': (False, 63), 'until': (False, 63), 'local': (False, 63), 'return': (False, 63), ';': (False, 63), '(': (False, 63), 'repeat': (False, 63)}, {'block__1': (True, 299), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'goto': (True, 310), 'stat': (True, 309), 'var': (True, 18), 'block': (True, 561), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'repeat': (True, 317)}, {'}': (True, 857)}, {'-': (True, 401), ')': (True, 410), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 101), '~=': (False, 55), '*': (False, 55), '-': (False, 55), '<': (False, 55), 'or': (False, 55), '>': (False, 55), 'and': (False, 55), ')': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'prefixexp': (True, 452), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), 'exp': (True, 467), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'explist': (True, 458), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'.': (False, 23), '::': (False, 23), 'break': (False, 23), '?>': (False, 23), '{': (False, 23), 'if': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'repeat': (False, 23), 'do': (False, 23), 'while': (False, 23), 'NAME': (False, 23), 'STRING': (False, 23), ':': (False, 23), 'for': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), ';': (False, 23), '(': (False, 23), 'goto': (False, 23)}, {'in': (False, 10)}, {'NAME': (True, 471)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 476), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 417), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '/': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'local': (False, 31), 'return': (False, 31), '<': (False, 31), ',': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '*': (False, 31), 'do': (False, 31), ';': (False, 31), '}': (False, 31), 'repeat': (False, 31), 'for': (False, 31), '>': (False, 31), 'NAME': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), ',': (False, 37), 'if': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '*': (False, 37), 'do': (False, 37), '}': (False, 37), 'repeat': (False, 37), 'for': (False, 37), '/': (False, 37), '>': (False, 37), ';': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), ',': (False, 38), 'tableconstructor': (True, 360), 'if': (False, 38), '^': (False, 38), 'args': (True, 359), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 361), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 357), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 354), '+': (False, 38), '==': (False, 38), '{': (True, 358), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), '}': (False, 38), 'goto': (False, 38), 'STRING': (True, 355), ':': (True, 356), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), ',': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '/': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), '*': (False, 39), 'do': (False, 39), '}': (False, 39), 'goto': (False, 39), 'for': (False, 39), '>': (False, 39), ';': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 506), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), 'NAME': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), '}': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 507), '(': (True, 508)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), ',': (False, 35), '/': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'local': (False, 35), 'return': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), '*': (False, 35), 'do': (False, 35), '}': (False, 35), 'repeat': (False, 35), 'for': (False, 35), '>': (False, 35), ';': (False, 35), '<=': (False, 35)}, {'::': (False, 64), 'break': (False, 64), 'if': (False, 64), 'EMBEDSTAT': (False, 64), 'function': (False, 64), 'do': (False, 64), 'while': (False, 64), ';': (False, 64), '}': (False, 64), 'goto': (False, 64), 'for': (False, 64), 'local': (False, 64), 'return': (False, 64), 'NAME': (False, 64), '(': (False, 64), 'repeat': (False, 64)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 514), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), '^': (False, 33), 'while': (False, 33), 'NAME': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'local': (False, 33), 'return': (False, 33), '<': (False, 33), ',': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'repeat': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '*': (False, 33), 'do': (False, 33), '}': (False, 33), 'goto': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), ';': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), ',': (False, 30), 'if': (False, 30), '^': (False, 30), 'while': (False, 30), '/': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), 'local': (False, 30), 'return': (False, 30), '<': (False, 30), 'NAME': (False, 30), '(': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), '*': (False, 30), 'do': (False, 30), '}': (False, 30), 'goto': (False, 30), 'for': (False, 30), '>': (False, 30), ';': (False, 30), '<=': (False, 30)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 515), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), ',': (False, 84), '/': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), '}': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), ';': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), 'NAME': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'local': (False, 36), 'return': (False, 36), 'and': (False, 36), ',': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '*': (False, 36), 'do': (False, 36), '}': (False, 36), 'repeat': (False, 36), 'for': (False, 36), '/': (False, 36), '>': (False, 36), ';': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), 'and': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), '<': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), ';': (False, 12), '}': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 521), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'..': (True, 523), '::': (False, 93), '~=': (True, 535), 'break': (False, 93), '>': (True, 531), '^': (True, 533), 'while': (False, 93), '-': (True, 524), 'and': (True, 529), 'or': (True, 528), 'explist__1': (True, 532), 'local': (False, 93), 'return': (False, 93), '<': (True, 534), ',': (True, 526), '(': (False, 93), 'if': (False, 93), '>=': (True, 537), '%': (True, 538), 'goto': (False, 93), '+': (True, 525), '==': (True, 527), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 536), 'do': (False, 93), ';': (False, 93), '}': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '/': (True, 530), 'NAME': (False, 93), '<=': (True, 539)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), ',': (False, 32), 'if': (False, 32), '^': (False, 32), 'while': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '*': (False, 32), 'do': (False, 32), '}': (False, 32), 'goto': (False, 32), 'for': (False, 32), '/': (False, 32), '>': (False, 32), ';': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), ',': (False, 34), '>': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'local': (False, 34), 'return': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'if': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '*': (False, 34), 'do': (False, 34), '}': (False, 34), 'goto': (False, 34), 'for': (False, 34), '/': (False, 34), ';': (False, 34), '<=': (False, 34)}, {'end': (False, 87)}, {';': (False, 107), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), 'prefixexp': (True, 576), 'function': (True, 573), '#': (True, 574), 'functioncall': (True, 575), 'explist': (True, 582), 'true': (True, 577), 'STRING': (True, 578), '-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 584), 'var': (True, 583), 'retstat__1': (True, 590), '{': (True, 585), 'end': (False, 107), 'nil': (True, 586), 'NAME': (True, 587), '(': (True, 588), 'not': (True, 589), '...': (True, 591), 'NUMBER': (True, 592)}, {'end': (False, 0)}, {'::': (True, 599)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (True, 393), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'prefixexp': (True, 887), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), 'exp': (True, 902), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'explist': (True, 893), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '<': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), ')': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ',': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'NAME': (True, 1090)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), ',': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), '}': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1093)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1095), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1117), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), 'NAME': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), ',': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), '}': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), ';': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '/': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), 'NAME': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), '}': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '>': (False, 24), ';': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 1123), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 617), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 618), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 619), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 620), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 621), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 622), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 623), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 624), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 765), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 768), 'true': (True, 178), 'STRING': (True, 177)}, {'.': (False, 85), ':': (False, 85), '{': (False, 85), '=': (False, 85), '[': (False, 85), ',': (False, 85), '(': (False, 85), 'STRING': (False, 85)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 770), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 773), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 774), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 775), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 776), 'true': (True, 178), 'STRING': (True, 177)}, {'funcbody': (True, 778), '(': (True, 779)}, {'-': (True, 401), ')': (True, 917), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'end': (True, 542)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '<': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), 'and': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), ')': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'..': (False, 55), '~=': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 925), '+': (False, 55), '*': (False, 55), 'do': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '<': (True, 1053), '>': (True, 1052), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'do': (True, 1056), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '<=': (True, 1060)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 628), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'tableconstructor': (True, 116), 'EMBEDEXPR': (True, 120), '{': (True, 121), 'NUMBER': (True, 131), 'function': (True, 122), '#': (True, 123), 'nil': (True, 119), '...': (True, 130), 'functioncall': (True, 117), 'not': (True, 128), 'exp': (True, 630), 'NAME': (True, 124), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 631), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 632), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 633), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 634), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 637), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 640), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 642), 'true': (True, 126), 'STRING': (True, 125)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 656), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 671), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'tableconstructor': (True, 116), 'EMBEDEXPR': (True, 120), '{': (True, 121), 'NUMBER': (True, 131), 'function': (True, 122), '#': (True, 123), 'nil': (True, 119), '...': (True, 130), 'functioncall': (True, 117), 'not': (True, 128), 'exp': (True, 673), 'NAME': (True, 124), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), 'functioncall': (True, 117), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), '(': (True, 127), '{': (True, 121), 'not': (True, 128), 'exp': (True, 674), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), 'functioncall': (True, 117), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), '(': (True, 127), '{': (True, 121), 'not': (True, 128), 'exp': (True, 676), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 677), 'true': (True, 126), 'STRING': (True, 125)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 699), 'true': (True, 126), 'STRING': (True, 125)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), ';': (False, 9), '}': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 703), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 702), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 704), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 705), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 706), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 707), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 708), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 709), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 710), '...': (True, 290), 'STRING': (True, 289)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'and': (False, 13), 'STRING': (False, 13), '-': (False, 13), ')': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 711), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'NUMBER': (True, 295), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'exp': (True, 713), 'NAME': (True, 288), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 714), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 715), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 717), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 718), '...': (True, 290), 'STRING': (True, 289)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), ',': (False, 57), 'if': (False, 57), '^': (True, 533), 'while': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), '*': (False, 57), 'do': (False, 57), '}': (False, 57), 'repeat': (False, 57), 'for': (False, 57), '/': (False, 57), '>': (False, 57), ';': (False, 57), '<=': (False, 57)}, {'end': (False, 2), 'return': (False, 2)}, {'NAME': (True, 796)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'do': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '>': (False, 25), '[': (False, 25), '<': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 798)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 800), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '..': (False, 24), '~=': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '+': (False, 24), '*': (False, 24), 'do': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'do': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '>': (False, 21), '[': (False, 21), 'and': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 804), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 805), 'true': (True, 178), 'STRING': (True, 177)}, {'::': (False, 68), 'break': (False, 68), 'if': (False, 68), 'EMBEDSTAT': (False, 68), 'function': (False, 68), 'do': (False, 68), 'while': (False, 68), 'NAME': (False, 68), 'goto': (False, 68), 'for': (False, 68), 'end': (False, 68), 'local': (False, 68), 'return': (False, 68), ';': (False, 68), '(': (False, 68), 'repeat': (False, 68)}, {'NAME': (True, 839)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 837), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '::': (False, 24), 'break': (False, 24), '{': (False, 24), 'if': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'do': (False, 24), 'while': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), 'STRING': (False, 24), ':': (False, 24), 'for': (False, 24), 'end': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), ';': (False, 24), '(': (False, 24), 'repeat': (False, 24)}, {'.': (False, 21), '::': (False, 21), 'break': (False, 21), '{': (False, 21), 'if': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'do': (False, 21), 'while': (False, 21), 'NAME': (False, 21), 'repeat': (False, 21), 'STRING': (False, 21), ':': (False, 21), 'for': (False, 21), 'end': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), ';': (False, 21), '(': (False, 21), 'goto': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 938), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 25), '::': (False, 25), 'break': (False, 25), '{': (False, 25), 'if': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'repeat': (False, 25), 'do': (False, 25), 'while': (False, 25), 'NAME': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), 'end': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), ';': (False, 25), '(': (False, 25), 'goto': (False, 25)}, {'::': (False, 69), 'break': (False, 69), 'if': (False, 69), 'EMBEDSTAT': (False, 69), 'function': (False, 69), 'do': (False, 69), 'while': (False, 69), 'NAME': (False, 69), 'repeat': (False, 69), 'for': (False, 69), 'local': (False, 69), 'return': (False, 69), '}': (False, 69), ';': (False, 69), '(': (False, 69), 'goto': (False, 69)}, {'in': (True, 950)}, {'in': (False, 29), 'namelist__1': (True, 323), ',': (True, 324), '=': (True, 947)}, {'::': (False, 105), 'break': (False, 105), 'if': (False, 105), 'EMBEDSTAT': (False, 105), 'function': (False, 105), 'do': (False, 105), 'while': (False, 105), 'NAME': (False, 105), 'repeat': (False, 105), 'end': (False, 105), 'for': (False, 105), '=': (True, 974), 'local': (False, 105), 'return': (False, 105), ';': (False, 105), '(': (False, 105), 'goto': (False, 105), 'stat__4': (True, 975)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 970), ';': (False, 29), 'NAME': (False, 29), '=': (False, 29), 'repeat': (False, 29), 'for': (False, 29), 'end': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 971), '(': (False, 29), 'goto': (False, 29)}, {'NAME': (True, 997)}, {'until': (True, 505)}, {'..': (True, 91), '+': (True, 93), '==': (False, 48), '>': (False, 48), '<': (False, 48), '^': (True, 101), '~=': (False, 48), '*': (True, 104), '-': (True, 92), 'and': (False, 48), 'or': (False, 48), '/': (True, 98), ')': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 106), '<=': (False, 48)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 101), '+': (False, 50), '*': (True, 104), '-': (False, 50), '<': (False, 50), 'or': (False, 50), '/': (True, 98), 'and': (False, 50), ')': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 106), '<=': (False, 50)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 101), '~=': (False, 49), '*': (True, 104), '-': (False, 49), '<': (False, 49), 'or': (False, 49), '/': (True, 98), 'and': (False, 49), ')': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 106), '<=': (False, 49)}, {'..': (True, 91), '-': (True, 92), '+': (True, 93), '==': (True, 95), ')': (False, 93), 'or': (True, 96), '<': (True, 102), '/': (True, 98), '>': (True, 99), 'explist__1': (True, 777), 'and': (True, 97), '^': (True, 101), '>=': (True, 105), ',': (True, 94), '*': (True, 104), '~=': (True, 103), '%': (True, 106), '<=': (True, 107)}, {'..': (True, 91), '+': (True, 93), '==': (False, 47), '>': (False, 47), '^': (True, 101), '~=': (False, 47), '*': (True, 104), '-': (True, 92), '<': (False, 47), 'or': (False, 47), '/': (True, 98), 'and': (False, 47), ')': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 106), '<=': (False, 47)}, {'..': (True, 91), '-': (True, 92), '+': (True, 93), ',': (False, 40), '==': (True, 95), ')': (False, 40), '/': (True, 98), '<': (True, 102), '>': (True, 99), 'and': (True, 97), '^': (True, 101), '~=': (True, 103), '*': (True, 104), 'or': (False, 40), '>=': (True, 105), '%': (True, 106), '<=': (True, 107)}, {'..': (True, 91), '-': (True, 92), '+': (True, 93), ',': (False, 41), '==': (True, 95), ')': (False, 41), '/': (True, 98), '<': (True, 102), '>': (True, 99), 'and': (False, 41), '^': (True, 101), '~=': (True, 103), '*': (True, 104), 'or': (False, 41), '>=': (True, 105), '%': (True, 106), '<=': (True, 107)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '<': (False, 52), '^': (True, 101), '+': (False, 52), '*': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), '/': (False, 52), ')': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 560), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '/': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), 'do': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '>': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '/': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), 'do': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '>': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'.': (True, 562), '..': (False, 38), '~=': (False, 38), '==': (False, 38), 'tableconstructor': (True, 566), '/': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'do': (False, 38), 'args': (True, 567), 'STRING': (True, 563), '-': (False, 38), '<': (False, 38), ':': (True, 564), 'or': (False, 38), '{': (True, 568), '>': (False, 38), '[': (True, 569), 'and': (False, 38), ',': (False, 38), '(': (True, 565), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), 'do': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), '/': (False, 39), '<': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 570), '...': (True, 290), 'STRING': (True, 289)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '>': (False, 11), '^': (False, 11), '~=': (False, 11), '*': (False, 11), 'do': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '/': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 593), '(': (True, 594)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), 'do': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'do': (True, 595)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 596), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), 'do': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), 'do': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 597), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'do': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), ',': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), 'do': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'do': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 598), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'explist__1': (True, 608), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 603), '*': (True, 612), 'do': (False, 93), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), 'do': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), 'do': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'..': (True, 91), '+': (True, 93), '==': (False, 43), '>': (False, 43), '^': (True, 101), '~=': (False, 43), '*': (True, 104), '-': (True, 92), '<': (False, 43), 'or': (False, 43), '/': (True, 98), 'and': (False, 43), ')': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 106), '<=': (False, 43)}, {'in': (False, 29), 'namelist__1': (True, 939), ',': (True, 324)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 101), '~=': (False, 54), '*': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), '/': (False, 54), 'and': (False, 54), ')': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1120), 'true': (True, 487), 'STRING': (True, 486)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '/': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), '==': (True, 1129), 'or': (True, 1130), '<': (True, 1135), '/': (True, 1132), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '>=': (True, 1138), ',': (True, 1128), '*': (True, 1137), '~=': (True, 1136), '%': (True, 1139), '<=': (True, 1140)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), '/': (False, 39), 'and': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), 'and': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), '<': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'..': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '~=': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1146), '(': (True, 1147)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), '/': (False, 35), '<': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1158), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1163), 'true': (True, 487), 'STRING': (True, 486)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), '==': (False, 84), '{': (False, 84), '/': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '>': (False, 84), '[': (False, 84), '<': (False, 84), ',': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'..': (False, 32), '+': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '~=': (False, 32), '*': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 1170), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1173), 'true': (True, 487), 'STRING': (True, 486)}, {'.': (True, 1174), '..': (False, 38), '~=': (False, 38), '==': (False, 38), 'tableconstructor': (True, 1178), '/': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 1179), 'STRING': (True, 1175), '-': (False, 38), '<': (False, 38), ':': (True, 1176), 'or': (False, 38), '{': (True, 1180), '>': (False, 38), '[': (True, 1181), 'and': (False, 38), ',': (False, 38), '(': (True, 1177), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '/': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (True, 91), '+': (True, 93), '==': (False, 42), '>': (False, 42), '^': (True, 101), '~=': (False, 42), '*': (True, 104), '-': (True, 92), ')': (False, 42), 'or': (False, 42), '/': (True, 98), 'and': (False, 42), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 106), '<=': (False, 42)}, {'..': (True, 91), '+': (True, 93), '==': (False, 46), '>': (False, 46), '<': (False, 46), '^': (True, 101), '~=': (False, 46), '*': (True, 104), '-': (True, 92), 'and': (False, 46), 'or': (False, 46), '/': (True, 98), ')': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 106), '<=': (False, 46)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '<': (False, 51), '^': (True, 101), '~=': (False, 51), '*': (False, 51), '-': (False, 51), ')': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 91), '+': (True, 93), '==': (False, 45), '>': (False, 45), '^': (True, 101), '~=': (False, 45), '*': (True, 104), '-': (True, 92), 'and': (False, 45), ')': (False, 45), 'or': (False, 45), '/': (True, 98), '<': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 106), '<=': (False, 45)}, {')': (True, 1004)}, {')': (False, 27), ',': (True, 1005), 'parlist__1': (True, 1006)}, {')': (False, 7)}, {')': (False, 96)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 101), '~=': (False, 53), '*': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), '/': (False, 53), 'and': (False, 53), ')': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (True, 91), '+': (True, 93), '==': (False, 44), '>': (False, 44), '<': (False, 44), '^': (True, 101), '~=': (False, 44), '*': (True, 104), '-': (True, 92), 'and': (False, 44), 'or': (False, 44), '/': (True, 98), ')': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 106), '<=': (False, 44)}, {'..': (False, 57), '~=': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 385), '+': (False, 57), '*': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), 'then': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 1260), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 1280), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 401), ')': (True, 772), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), ',': (False, 62), 'if': (False, 62), '^': (False, 62), 'while': (False, 62), '/': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'repeat': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '*': (False, 62), 'do': (False, 62), '}': (False, 62), 'goto': (False, 62), 'for': (False, 62), '>': (False, 62), ';': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 547), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {';': (False, 106), '}': (False, 106)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), '==': (True, 234), 'or': (True, 235), '<': (True, 240), '/': (True, 237), '>': (True, 238), 'explist__1': (True, 1510), 'and': (True, 236), '^': (True, 239), '>=': (True, 243), ',': (True, 1509), '*': (True, 242), '~=': (True, 241), '%': (True, 244), ';': (False, 93), '}': (False, 93), '<=': (True, 245)}, {'retstat__2': (True, 512), ';': (True, 513), '}': (False, 89)}, {'}': (False, 108)}, {'}': (False, 88)}, {'}': (True, 872)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '/': (False, 56), '^': (True, 533), 'while': (False, 56), 'NAME': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), ',': (False, 56), '(': (False, 56), 'if': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), '*': (False, 56), 'do': (False, 56), '}': (False, 56), 'goto': (False, 56), 'for': (False, 56), '>': (False, 56), ';': (False, 56), '<=': (False, 56)}, {'::': (False, 91), 'break': (False, 91), 'if': (False, 91), 'EMBEDSTAT': (False, 91), 'function': (False, 91), 'do': (False, 91), 'while': (False, 91), ';': (False, 91), '}': (False, 91), 'goto': (False, 91), 'for': (False, 91), 'local': (False, 91), 'return': (False, 91), 'NAME': (False, 91), '(': (False, 91), 'repeat': (False, 91)}, {'until': (False, 87)}, {';': (False, 107), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), 'prefixexp': (True, 1012), 'function': (True, 1009), '#': (True, 1010), 'functioncall': (True, 1011), 'explist': (True, 1018), 'true': (True, 1013), 'STRING': (True, 1014), '-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1020), 'var': (True, 1019), 'retstat__1': (True, 1026), '{': (True, 1021), 'nil': (True, 1022), 'NAME': (True, 1023), '(': (True, 1024), 'not': (True, 1025), 'until': (False, 107), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'until': (False, 0)}, {'::': (True, 1031)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 533), 'while': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'local': (False, 55), 'return': (False, 55), '<': (False, 55), ',': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), '*': (False, 55), 'do': (False, 55), ';': (False, 55), '}': (False, 55), 'goto': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'NAME': (False, 55), '<=': (False, 55)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (True, 1547), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 785), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 786), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 787), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 788), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 789), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 790), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 791), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 792), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 793), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'::': (False, 90), 'break': (False, 90), 'if': (False, 90), 'EMBEDSTAT': (False, 90), 'function': (False, 90), 'do': (False, 90), 'while': (False, 90), ';': (False, 90), '}': (False, 90), 'goto': (False, 90), 'for': (False, 90), 'local': (False, 90), 'return': (False, 90), 'NAME': (False, 90), '(': (False, 90), 'repeat': (False, 90)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 794), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 795), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 797), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 799), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 801), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 802), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'exp': (True, 803), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'prefixexp': (True, 810), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), 'exp': (True, 825), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'explist': (True, 816), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'funcbody': (True, 834), '(': (True, 835)}, {'::': (False, 69), 'break': (False, 69), 'if': (False, 69), 'EMBEDSTAT': (False, 69), 'function': (False, 69), 'do': (False, 69), 'while': (False, 69), 'NAME': (False, 69), 'repeat': (False, 69), 'for': (False, 69), 'end': (False, 69), 'local': (False, 69), 'return': (False, 69), ';': (False, 69), '(': (False, 69), 'goto': (False, 69)}, {'end': (True, 1042)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '<': (True, 1053), '>': (True, 1052), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'do': (True, 1221), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '<=': (True, 1060)}, {'until': (False, 2), 'return': (False, 2)}, {'::': (False, 68), 'break': (False, 68), 'if': (False, 68), 'EMBEDSTAT': (False, 68), 'function': (False, 68), 'do': (False, 68), 'while': (False, 68), 'NAME': (False, 68), 'goto': (False, 68), 'for': (False, 68), 'until': (False, 68), 'local': (False, 68), 'return': (False, 68), ';': (False, 68), '(': (False, 68), 'repeat': (False, 68)}, {')': (True, 937)}, {'NAME': (True, 942)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 940), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '::': (False, 24), 'break': (False, 24), '{': (False, 24), 'if': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'do': (False, 24), 'while': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), 'STRING': (False, 24), ':': (False, 24), 'for': (False, 24), 'until': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), ';': (False, 24), '(': (False, 24), 'repeat': (False, 24)}, {'.': (False, 21), '::': (False, 21), 'break': (False, 21), '{': (False, 21), 'if': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'do': (False, 21), 'while': (False, 21), 'NAME': (False, 21), 'repeat': (False, 21), 'STRING': (False, 21), ':': (False, 21), 'for': (False, 21), 'until': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), ';': (False, 21), '(': (False, 21), 'goto': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 948), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 25), '::': (False, 25), 'break': (False, 25), '{': (False, 25), 'if': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'repeat': (False, 25), 'do': (False, 25), 'while': (False, 25), 'NAME': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), 'until': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), ';': (False, 25), '(': (False, 25), 'goto': (False, 25)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 993), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'in': (True, 999)}, {'in': (False, 29), 'namelist__1': (True, 323), ',': (True, 324), '=': (True, 998)}, {'::': (False, 105), 'break': (False, 105), 'if': (False, 105), 'EMBEDSTAT': (False, 105), 'function': (False, 105), 'do': (False, 105), 'while': (False, 105), 'NAME': (False, 105), 'goto': (False, 105), 'for': (False, 105), 'until': (False, 105), '=': (True, 1035), 'local': (False, 105), 'return': (False, 105), ';': (False, 105), '(': (False, 105), 'repeat': (False, 105), 'stat__4': (True, 1036)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 1037), ';': (False, 29), 'NAME': (False, 29), 'goto': (False, 29), 'for': (False, 29), 'until': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 1038), '(': (False, 29), 'repeat': (False, 29)}, {'NAME': (True, 1039)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 609), '~=': (False, 57), '*': (False, 57), 'do': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'until': (True, 1041)}, {'NAME': (True, 780)}, {'.': (False, 25), '..': (False, 25), '~=': (False, 25), '==': (False, 25), '{': (False, 25), '>': (False, 25), '^': (False, 25), '+': (False, 25), '*': (False, 25), 'do': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '/': (False, 25), '[': (False, 25), '<': (False, 25), ',': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 781)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 782), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'do': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '>': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'do': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '/': (False, 21), '[': (False, 21), 'and': (False, 21), ',': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 783), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 784), 'true': (True, 178), 'STRING': (True, 177)}, {'-': (True, 401), ')': (True, 921), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), ';': (False, 39), '/': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), 'end': (False, 39), '<': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), ';': (False, 35), '-': (False, 35), '<': (False, 35), 'end': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 1433), '(': (True, 1434)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 1435), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), ',': (False, 12), '==': (False, 12), '{': (False, 12), '/': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), 'end': (False, 12), '>': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'.': (True, 1440), '..': (False, 38), '~=': (False, 38), '==': (False, 38), '{': (True, 1444), '>': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 1445), ';': (False, 38), '/': (False, 38), 'STRING': (True, 1441), '-': (False, 38), '<': (False, 38), ':': (True, 1442), 'or': (False, 38), 'tableconstructor': (True, 1446), 'end': (False, 38), '[': (True, 1447), 'and': (False, 38), ',': (False, 38), '(': (True, 1443), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '>': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), ';': (False, 32), '/': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), 'end': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '>': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), ';': (False, 34), '/': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'end': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 1454), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), ';': (False, 31), '/': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), 'end': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), ';': (False, 37), '/': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), 'end': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {';': (False, 106), 'end': (False, 106)}, {'..': (False, 11), '.': (False, 11), '~=': (False, 11), ',': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '+': (False, 11), '*': (False, 11), 'end': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), '[': (False, 11), 'and': (False, 11), ';': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'..': (True, 1470), '-': (True, 1471), '+': (True, 1472), 'end': (False, 93), '==': (True, 1474), 'or': (True, 1475), '<': (True, 1480), '>': (True, 1477), 'explist__1': (True, 1478), 'and': (True, 1476), '^': (True, 1479), '>=': (True, 1483), ',': (True, 1473), '*': (True, 1482), '~=': (True, 1481), '%': (True, 1484), ';': (False, 93), '/': (True, 1485), '<=': (True, 1486)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1490), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), ';': (False, 30), '/': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), 'end': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '/': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'end': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '>': (False, 84), '[': (False, 84), '<': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 1493), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 1495), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'retstat__2': (True, 1496), ';': (True, 1497), 'end': (False, 89)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '>': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), ';': (False, 36), '/': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'end': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), ';': (False, 33), '/': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'end': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), 'do': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1546), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1564), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'}': (True, 1032)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 609), '~=': (False, 56), '*': (False, 56), 'do': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 609), '~=': (False, 55), '*': (False, 55), 'do': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'::': (False, 91), 'break': (False, 91), 'if': (False, 91), 'EMBEDSTAT': (False, 91), 'function': (False, 91), 'do': (False, 91), 'while': (False, 91), ';': (False, 91), 'goto': (False, 91), 'for': (False, 91), 'end': (False, 91), 'local': (False, 91), 'return': (False, 91), 'NAME': (False, 91), '(': (False, 91), 'repeat': (False, 91)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 828), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 806), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 829), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 833), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 838), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 840), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 934), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 936), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'do': (False, 90)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 941), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 943), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 944), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 946), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 949), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 951), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 969), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 972), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 50), '+': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 370), '~=': (False, 50), ']': (False, 50), '*': (True, 373), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 367), '<': (False, 50), '>=': (False, 50), '%': (True, 375), '<=': (False, 50)}, {'..': (True, 376), '+': (True, 364), '==': (False, 42), '>': (False, 42), '^': (True, 370), '~=': (False, 42), ']': (False, 42), '*': (True, 373), '-': (True, 362), 'and': (False, 42), 'or': (False, 42), '/': (True, 367), '<': (False, 42), '>=': (False, 42), '%': (True, 375), '<=': (False, 42)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 370), '~=': (False, 49), ']': (False, 49), '*': (True, 373), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), '/': (True, 367), '<': (False, 49), '>=': (False, 49), '%': (True, 375), '<=': (False, 49)}, {'..': (True, 376), '+': (True, 364), '==': (False, 47), '>': (False, 47), '^': (True, 370), '~=': (False, 47), ']': (False, 47), '*': (True, 373), '-': (True, 362), 'and': (False, 47), 'or': (False, 47), '/': (True, 367), '<': (False, 47), '>=': (False, 47), '%': (True, 375), '<=': (False, 47)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (False, 40), '*': (True, 373), 'or': (False, 40), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 370), '+': (False, 52), ']': (False, 52), '*': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'..': (True, 376), '+': (True, 364), '==': (False, 43), '>': (False, 43), '^': (True, 370), '~=': (False, 43), ']': (False, 43), '*': (True, 373), '-': (True, 362), 'and': (False, 43), 'or': (False, 43), '/': (True, 367), '<': (False, 43), '>=': (False, 43), '%': (True, 375), '<=': (False, 43)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), '/': (True, 367), '>': (True, 368), 'and': (False, 41), '^': (True, 370), '~=': (True, 371), ']': (False, 41), '*': (True, 373), 'or': (False, 41), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'}': (True, 636)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), 'then': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 720), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 50), '+': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 385), '~=': (False, 50), '*': (True, 395), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 389), '<': (False, 50), 'then': (False, 50), '>=': (False, 50), '%': (True, 397), '<=': (False, 50)}, {'..': (False, 56), '~=': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 385), '+': (False, 56), '*': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), 'then': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 385), '~=': (False, 54), '*': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), 'then': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (False, 49), '~=': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 385), '+': (False, 49), '*': (True, 395), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), '/': (True, 389), '<': (False, 49), 'then': (False, 49), '>=': (False, 49), '%': (True, 397), '<=': (False, 49)}, {'..': (True, 398), '+': (True, 386), '==': (False, 47), '>': (False, 47), '^': (True, 385), '~=': (False, 47), '*': (True, 395), '-': (True, 384), 'and': (False, 47), 'or': (False, 47), '/': (True, 389), '<': (False, 47), 'then': (False, 47), '>=': (False, 47), '%': (True, 397), '<=': (False, 47)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (False, 40), '~=': (True, 394), '*': (True, 395), 'or': (False, 40), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 385), '+': (False, 52), '*': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), 'then': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'prefixexp': (True, 1332), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), 'exp': (True, 1347), '{': (True, 1339), 'function': (True, 1336), '#': (True, 1342), 'nil': (True, 1341), 'STRING': (True, 1349), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'explist': (True, 1338), 'NAME': (True, 1343), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), 'then': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (True, 398), '+': (True, 386), '==': (False, 43), '>': (False, 43), '^': (True, 385), '~=': (False, 43), '*': (True, 395), '-': (True, 384), 'and': (False, 43), 'or': (False, 43), '/': (True, 389), '<': (False, 43), 'then': (False, 43), '>=': (False, 43), '%': (True, 397), '<=': (False, 43)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (True, 1642), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'-': (True, 401), ')': (True, 701), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), '/': (True, 389), '>': (True, 390), 'and': (False, 41), '^': (True, 385), 'then': (False, 41), '~=': (True, 394), '*': (True, 395), 'or': (False, 41), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'..': (False, 55), '~=': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 385), '+': (False, 55), '*': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), 'then': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'..': (True, 398), '+': (True, 386), '==': (False, 42), '>': (False, 42), '^': (True, 385), '~=': (False, 42), '*': (True, 395), '-': (True, 384), 'and': (False, 42), 'or': (False, 42), '/': (True, 389), '<': (False, 42), 'then': (False, 42), '>=': (False, 42), '%': (True, 397), '<=': (False, 42)}, {'block__2': (True, 830), 'else': (False, 1), 'end': (False, 1), 'elseif': (False, 1), 'return': (True, 831), 'retstat': (True, 832)}, {'NAME': (True, 836)}, {'::': (False, 67), 'break': (False, 67), 'if': (False, 67), 'elseif': (False, 67), 'EMBEDSTAT': (False, 67), 'function': (False, 67), 'do': (False, 67), 'while': (False, 67), 'NAME': (False, 67), 'repeat': (False, 67), 'for': (False, 67), 'end': (False, 67), 'local': (False, 67), 'return': (False, 67), ';': (False, 67), '(': (False, 67), 'goto': (False, 67), 'else': (False, 67)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 841), 'true': (True, 126), 'STRING': (True, 125)}, {'=': (True, 843)}, {'::': (False, 78), 'break': (False, 78), 'if': (False, 78), 'local': (False, 78), 'EMBEDSTAT': (False, 78), 'function': (False, 78), 'do': (False, 78), 'while': (False, 78), 'NAME': (False, 78), 'goto': (False, 78), 'for': (False, 78), 'end': (False, 78), 'elseif': (False, 78), 'return': (False, 78), ';': (False, 78), '(': (False, 78), 'repeat': (False, 78), 'else': (False, 78)}, {'NAME': (True, 184), 'funcname': (True, 845)}, {'.': (False, 12), '::': (False, 65), 'break': (False, 65), '{': (False, 12), 'if': (False, 65), 'elseif': (False, 65), 'EMBEDSTAT': (False, 65), 'function': (False, 65), 'do': (False, 65), 'while': (False, 65), ';': (False, 65), 'goto': (False, 65), 'repeat': (False, 65), ':': (False, 12), 'for': (False, 65), 'end': (False, 65), 'local': (False, 65), 'return': (False, 65), '[': (False, 12), 'NAME': (False, 65), '(': (False, 12), 'STRING': (False, 12), 'else': (False, 65)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 851), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 852), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 856), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'repeat': (True, 661), 'stat': (True, 653), 'var': (True, 18), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'goto': (True, 654), 'else': (False, 3)}, {'NAME': (True, 858)}, {'.': (True, 27), 'STRING': (True, 865), ':': (True, 860), '(': (True, 861), 'tableconstructor': (True, 862), 'args': (True, 863), '{': (True, 864), '[': (True, 33)}, {'stat__1': (True, 868), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {'namelist': (True, 870), 'NAME': (True, 871)}, {'::': (False, 66), 'break': (False, 66), 'if': (False, 66), 'local': (False, 66), 'EMBEDSTAT': (False, 66), 'function': (False, 66), 'do': (False, 66), 'while': (False, 66), ';': (False, 66), 'goto': (False, 66), 'for': (False, 66), 'end': (False, 66), 'elseif': (False, 66), 'return': (False, 66), 'NAME': (False, 66), '(': (False, 66), 'repeat': (False, 66), 'else': (False, 66)}, {'namelist': (True, 874), 'NAME': (True, 875), 'function': (True, 876)}, {'::': (False, 63), 'break': (False, 63), 'if': (False, 63), 'local': (False, 63), 'EMBEDSTAT': (False, 63), 'function': (False, 63), 'do': (False, 63), 'while': (False, 63), 'NAME': (False, 63), 'repeat': (False, 63), 'for': (False, 63), 'end': (False, 63), 'elseif': (False, 63), 'return': (False, 63), ';': (False, 63), '(': (False, 63), 'goto': (False, 63), 'else': (False, 63)}, {'block__1': (True, 299), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'goto': (True, 310), 'stat': (True, 309), 'var': (True, 18), 'block': (True, 879), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'repeat': (True, 317)}, {'funcbody': (True, 922), '(': (True, 923)}, {'NAME': (True, 1452)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), '>': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '/': (False, 25), '[': (False, 25), '<': (False, 25), 'then': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1463)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1466), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '..': (False, 24), '~=': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '+': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), 'then': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '>': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '/': (False, 21), '[': (False, 21), 'and': (False, 21), 'then': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1491), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 1494), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (True, 398), '+': (True, 386), '==': (False, 46), '>': (False, 46), '^': (True, 385), '~=': (False, 46), '*': (True, 395), '-': (True, 384), '<': (False, 46), 'or': (False, 46), '/': (True, 389), 'and': (False, 46), 'then': (False, 46), '>=': (False, 46), '%': (True, 397), '<=': (False, 46)}, {'=': (True, 1563)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 385), '~=': (False, 51), '*': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), 'then': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 398), '+': (True, 386), '==': (False, 45), '>': (False, 45), '^': (True, 385), '~=': (False, 45), '*': (True, 395), '-': (True, 384), '<': (False, 45), 'or': (False, 45), '/': (True, 389), 'and': (False, 45), 'then': (False, 45), '>=': (False, 45), '%': (True, 397), '<=': (False, 45)}, {'?>': (False, 2), 'return': (False, 2)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 385), '~=': (False, 53), '*': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), 'then': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (True, 398), '+': (True, 386), '==': (False, 48), '>': (False, 48), '^': (True, 385), '~=': (False, 48), '*': (True, 395), '-': (True, 384), '<': (False, 48), 'or': (False, 48), '/': (True, 389), 'and': (False, 48), 'then': (False, 48), '>=': (False, 48), '%': (True, 397), '<=': (False, 48)}, {'block__2': (True, 1421), 'EOF': (False, 1), 'return': (True, 1422), 'retstat': (True, 1423)}, {'NAME': (True, 1424)}, {'::': (False, 67), 'break': (False, 67), 'if': (False, 67), 'EMBEDSTAT': (False, 67), 'function': (False, 67), 'EOF': (False, 67), 'do': (False, 67), 'while': (False, 67), 'NAME': (False, 67), 'repeat': (False, 67), 'for': (False, 67), 'local': (False, 67), 'return': (False, 67), ';': (False, 67), '(': (False, 67), 'goto': (False, 67)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 1428), 'true': (True, 126), 'STRING': (True, 125)}, {'=': (True, 1431)}, {'::': (False, 78), 'break': (False, 78), 'if': (False, 78), 'EMBEDSTAT': (False, 78), 'function': (False, 78), 'EOF': (False, 78), 'do': (False, 78), 'while': (False, 78), 'NAME': (False, 78), 'goto': (False, 78), 'for': (False, 78), 'local': (False, 78), 'return': (False, 78), ';': (False, 78), '(': (False, 78), 'repeat': (False, 78)}, {'NAME': (True, 184), 'funcname': (True, 1436)}, {'.': (False, 12), '::': (False, 65), 'break': (False, 65), '{': (False, 12), 'if': (False, 65), 'EMBEDSTAT': (False, 65), 'function': (False, 65), 'EOF': (False, 65), 'do': (False, 65), 'while': (False, 65), 'NAME': (False, 65), 'repeat': (False, 65), 'STRING': (False, 12), ':': (False, 12), 'for': (False, 65), 'local': (False, 65), 'return': (False, 65), '[': (False, 12), ';': (False, 65), '(': (False, 12), 'goto': (False, 65)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1448), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1450), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 1451), '::': (True, 679), 'break': (True, 680), 'if': (True, 681), 'varlist': (True, 682), 'EMBEDSTAT': (True, 683), 'function': (True, 684), 'EOF': (False, 3), 'functioncall': (True, 685), 'do': (True, 686), 'while': (True, 687), 'prefixexp': (True, 690), 'NAME': (True, 15), 'repeat': (True, 697), 'stat': (True, 688), 'var': (True, 18), 'for': (True, 692), 'label': (True, 693), 'local': (True, 694), 'return': (False, 3), ';': (True, 696), '(': (True, 25), 'goto': (True, 689)}, {'NAME': (True, 1455)}, {'.': (True, 27), 'STRING': (True, 1462), ':': (True, 1457), '(': (True, 1458), 'tableconstructor': (True, 1459), 'args': (True, 1460), '{': (True, 1461), '[': (True, 33)}, {'EOF': (False, 95)}, {'namelist': (True, 1467), 'NAME': (True, 1468)}, {'::': (False, 66), 'break': (False, 66), 'if': (False, 66), 'EMBEDSTAT': (False, 66), 'function': (False, 66), 'EOF': (False, 66), 'do': (False, 66), 'while': (False, 66), ';': (False, 66), 'repeat': (False, 66), 'for': (False, 66), 'local': (False, 66), 'return': (False, 66), 'NAME': (False, 66), '(': (False, 66), 'goto': (False, 66)}, {'namelist': (True, 1487), 'NAME': (True, 1488), 'function': (True, 1489)}, {'EOF': (False, None)}, {'::': (False, 63), 'break': (False, 63), 'if': (False, 63), 'EMBEDSTAT': (False, 63), 'function': (False, 63), 'EOF': (False, 63), 'do': (False, 63), 'while': (False, 63), 'NAME': (False, 63), 'goto': (False, 63), 'for': (False, 63), 'local': (False, 63), 'return': (False, 63), ';': (False, 63), '(': (False, 63), 'repeat': (False, 63)}, {'block__1': (True, 299), '::': (True, 300), 'break': (True, 301), 'if': (True, 302), 'varlist': (True, 303), 'EMBEDSTAT': (True, 304), 'function': (True, 305), 'functioncall': (True, 306), 'do': (True, 307), 'while': (True, 308), 'prefixexp': (True, 311), 'NAME': (True, 15), 'goto': (True, 310), 'stat': (True, 309), 'var': (True, 18), 'block': (True, 1492), 'for': (True, 313), 'until': (False, 3), 'label': (True, 314), 'local': (True, 315), 'return': (False, 3), ';': (True, 316), '(': (True, 25), 'repeat': (True, 317)}, {'end': (True, 1255)}, {'..': (True, 398), '+': (True, 386), '==': (False, 44), '>': (False, 44), '^': (True, 385), '~=': (False, 44), '*': (True, 395), '-': (True, 384), 'and': (False, 44), 'or': (False, 44), '/': (True, 389), '<': (False, 44), 'then': (False, 44), '>=': (False, 44), '%': (True, 397), '<=': (False, 44)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '<': (True, 1053), '>': (True, 1052), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'do': (True, 1293), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '<=': (True, 1060)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), 'then': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (True, 415), '+': (True, 403), '==': (False, 42), '>': (False, 42), '^': (True, 409), '~=': (False, 42), '*': (True, 412), '-': (True, 401), ')': (False, 42), 'or': (False, 42), '/': (True, 407), 'and': (False, 42), '<': (False, 42), '>=': (False, 42), '%': (True, 414), '<=': (False, 42)}, {'..': (False, 50), '+': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 409), '~=': (False, 50), '*': (True, 412), '-': (False, 50), '<': (False, 50), 'or': (False, 50), '/': (True, 407), 'and': (False, 50), ')': (False, 50), '>=': (False, 50), '%': (True, 414), '<=': (False, 50)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 409), '~=': (False, 49), '*': (True, 412), '-': (False, 49), '<': (False, 49), 'or': (False, 49), '/': (True, 407), 'and': (False, 49), ')': (False, 49), '>=': (False, 49), '%': (True, 414), '<=': (False, 49)}, {'..': (True, 415), '+': (True, 403), '==': (False, 47), '>': (False, 47), '^': (True, 409), '~=': (False, 47), '*': (True, 412), '-': (True, 401), '<': (False, 47), 'or': (False, 47), '/': (True, 407), 'and': (False, 47), ')': (False, 47), '>=': (False, 47), '%': (True, 414), '<=': (False, 47)}, {'-': (True, 401), '<': (True, 402), '+': (True, 403), '==': (True, 404), ')': (False, 40), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '^': (True, 409), '~=': (True, 411), '*': (True, 412), 'or': (False, 40), '>=': (True, 413), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'-': (True, 401), '<': (True, 402), '+': (True, 403), '==': (True, 404), ')': (False, 41), '/': (True, 407), '>': (True, 408), 'and': (False, 41), '^': (True, 409), '~=': (True, 411), '*': (True, 412), 'or': (False, 41), '>=': (True, 413), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '<': (False, 52), '^': (True, 409), '+': (False, 52), '*': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), '/': (False, 52), ')': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'..': (True, 415), '+': (True, 403), '==': (False, 43), '>': (False, 43), '^': (True, 409), '~=': (False, 43), '*': (True, 412), '-': (True, 401), '<': (False, 43), 'or': (False, 43), '/': (True, 407), 'and': (False, 43), ')': (False, 43), '>=': (False, 43), '%': (True, 414), '<=': (False, 43)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 409), '~=': (False, 54), '*': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), '/': (False, 54), 'and': (False, 54), ')': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (True, 415), '+': (True, 403), '==': (False, 46), '>': (False, 46), '<': (False, 46), '^': (True, 409), '~=': (False, 46), '*': (True, 412), '-': (True, 401), 'and': (False, 46), 'or': (False, 46), '/': (True, 407), ')': (False, 46), '>=': (False, 46), '%': (True, 414), '<=': (False, 46)}, {'..': (False, 57), '~=': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 409), '+': (False, 57), '*': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), '/': (False, 57), 'and': (False, 57), ')': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '<': (False, 51), '^': (True, 409), '~=': (False, 51), '*': (False, 51), '-': (False, 51), ')': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 415), '+': (True, 403), '==': (False, 45), '>': (False, 45), '^': (True, 409), '~=': (False, 45), '*': (True, 412), '-': (True, 401), 'and': (False, 45), ')': (False, 45), 'or': (False, 45), '/': (True, 407), '<': (False, 45), '>=': (False, 45), '%': (True, 414), '<=': (False, 45)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 409), '~=': (False, 53), '*': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), '/': (False, 53), 'and': (False, 53), ')': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), ',': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), '}': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (True, 415), '+': (True, 403), '==': (False, 48), '>': (False, 48), '<': (False, 48), '^': (True, 409), '~=': (False, 48), '*': (True, 412), '-': (True, 401), 'and': (False, 48), 'or': (False, 48), '/': (True, 407), ')': (False, 48), '>=': (False, 48), '%': (True, 414), '<=': (False, 48)}, {'..': (True, 415), '+': (True, 403), '==': (False, 44), '>': (False, 44), '^': (True, 409), '~=': (False, 44), '*': (True, 412), '-': (True, 401), ')': (False, 44), 'or': (False, 44), '/': (True, 407), 'and': (False, 44), '<': (False, 44), '>=': (False, 44), '%': (True, 414), '<=': (False, 44)}, {'-': (True, 401), ')': (True, 1503), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {')': (True, 766)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), '/': (False, 62), 'and': (False, 62), ')': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 767), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'in': (True, 771)}, {'in': (False, 29), 'namelist__1': (True, 323), ',': (True, 324), '=': (True, 769)}, {'}': (True, 1323)}, {'-': (True, 401), '^': (True, 409), '+': (True, 403), '==': (True, 404), ')': (False, None), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'::': (False, 105), 'break': (False, 105), '(': (False, 105), 'if': (False, 105), 'EMBEDSTAT': (False, 105), 'function': (False, 105), 'do': (False, 105), 'while': (False, 105), 'NAME': (False, 105), 'goto': (False, 105), 'for': (False, 105), '=': (True, 1550), 'local': (False, 105), 'return': (False, 105), ';': (False, 105), '?>': (False, 105), 'repeat': (False, 105), 'stat__4': (True, 1551)}, {'::': (False, 29), 'break': (False, 29), '(': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 1548), ';': (False, 29), 'NAME': (False, 29), 'goto': (False, 29), 'for': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 1549), '?>': (False, 29), 'repeat': (False, 29)}, {'NAME': (True, 1552)}, {'..': (False, 56), '~=': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 409), '+': (False, 56), '*': (False, 56), '-': (False, 56), 'and': (False, 56), ')': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'..': (False, 55), '~=': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 409), '+': (False, 55), '*': (False, 55), '-': (False, 55), '<': (False, 55), 'or': (False, 55), '>': (False, 55), 'and': (False, 55), ')': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'NAME': (True, 846)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '<': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), ')': (False, 25), ':': (False, 25), 'or': (False, 25), '>': (False, 25), '[': (False, 25), 'and': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 847)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 853), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '..': (False, 24), '~=': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '+': (False, 24), '*': (False, 24), 'and': (False, 24), 'STRING': (False, 24), '-': (False, 24), ')': (False, 24), ':': (False, 24), 'or': (False, 24), '>': (False, 24), '[': (False, 24), '<': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '>': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), 'and': (False, 21), ':': (False, 21), ')': (False, 21), 'or': (False, 21), '/': (False, 21), '[': (False, 21), '<': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 859), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 866), 'true': (True, 178), 'STRING': (True, 177)}, {'until': (True, 1649)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), ';': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), '/': (False, 39), '<': (False, 39), ',': (False, 39), '?>': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), ';': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ',': (False, 35), '?>': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 1044), '(': (True, 1045)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1061), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), ',': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '(': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '?>': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'.': (True, 1064), '..': (False, 38), '~=': (False, 38), '?>': (False, 38), '==': (False, 38), '{': (True, 1068), '/': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 1069), ';': (False, 38), 'STRING': (True, 1065), '-': (False, 38), '<': (False, 38), ':': (True, 1066), 'or': (False, 38), 'tableconstructor': (True, 1070), '>': (False, 38), '[': (True, 1071), 'and': (False, 38), ',': (False, 38), '(': (True, 1067), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), ';': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), ',': (False, 32), '?>': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), ';': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), ',': (False, 34), '?>': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1072), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), ';': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), ',': (False, 31), '?>': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '/': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), ';': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '>': (False, 37), '<': (False, 37), ',': (False, 37), '?>': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {';': (False, 106), '?>': (False, 106)}, {'..': (False, 11), '.': (False, 11), '~=': (False, 11), ',': (False, 11), '==': (False, 11), '{': (False, 11), '>': (False, 11), '^': (False, 11), '+': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '/': (False, 11), '[': (False, 11), 'and': (False, 11), ';': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '?>': (False, 11), '<=': (False, 11)}, {'..': (True, 1073), '-': (True, 1074), '+': (True, 1075), '?>': (False, 93), '==': (True, 1077), 'or': (True, 1078), '<': (True, 1083), '>': (True, 1080), 'explist__1': (True, 1081), 'and': (True, 1079), '^': (True, 1082), '>=': (True, 1086), ',': (True, 1076), '*': (True, 1085), '~=': (True, 1084), '%': (True, 1087), ';': (False, 93), '/': (True, 1088), '<=': (True, 1089)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1091), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), ';': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), ',': (False, 30), '?>': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '(': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), ';': (False, 84), '?>': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 1094), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1096), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'retstat__2': (True, 1118), ';': (True, 1119), '?>': (False, 89)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), ';': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '?>': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '/': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), ';': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '>': (False, 33), '<': (False, 33), ',': (False, 33), '?>': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'..': (False, 57), '~=': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 370), '+': (False, 57), ']': (False, 57), '*': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'-': (True, 401), ')': (True, 1186), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 370), '~=': (False, 54), ']': (False, 54), '*': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1427), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {')': (True, 1432)}, {'..': (True, 376), '+': (True, 364), '==': (False, 46), '>': (False, 46), '^': (True, 370), '~=': (False, 46), ']': (False, 46), '*': (True, 373), '-': (True, 362), '<': (False, 46), 'or': (False, 46), '/': (True, 367), 'and': (False, 46), '>=': (False, 46), '%': (True, 375), '<=': (False, 46)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1645), 'true': (True, 487), 'STRING': (True, 486)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 370), '~=': (False, 51), ']': (False, 51), '*': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'prefixexp': (True, 452), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), 'exp': (True, 467), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'explist': (True, 1648), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '/': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), ';': (False, 13), '}': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'..': (True, 376), '+': (True, 364), '==': (False, 45), '>': (False, 45), '^': (True, 370), '~=': (False, 45), ']': (False, 45), '*': (True, 373), '-': (True, 362), '<': (False, 45), 'or': (False, 45), '/': (True, 367), 'and': (False, 45), '>=': (False, 45), '%': (True, 375), '<=': (False, 45)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 370), '~=': (False, 53), ']': (False, 53), '*': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (True, 376), '+': (True, 364), '==': (False, 48), '>': (False, 48), '^': (True, 370), '~=': (False, 48), ']': (False, 48), '*': (True, 373), '-': (True, 362), '<': (False, 48), 'or': (False, 48), '/': (True, 367), 'and': (False, 48), '>=': (False, 48), '%': (True, 375), '<=': (False, 48)}, {'..': (True, 376), '+': (True, 364), '==': (False, 44), '>': (False, 44), '^': (True, 370), '~=': (False, 44), ']': (False, 44), '*': (True, 373), '-': (True, 362), 'and': (False, 44), 'or': (False, 44), '/': (True, 367), '<': (False, 44), '>=': (False, 44), '%': (True, 375), '<=': (False, 44)}, {')': (False, 92)}, {'::': (False, 75), 'break': (False, 75), 'if': (False, 75), 'EMBEDSTAT': (False, 75), 'function': (False, 75), 'do': (False, 75), 'while': (False, 75), 'NAME': (False, 75), 'goto': (False, 75), 'for': (False, 75), 'end': (False, 75), 'local': (False, 75), 'return': (False, 75), ';': (False, 75), '(': (False, 75), 'repeat': (False, 75)}, {')': (False, 97), 'funcbody__1': (True, 844), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'do': (False, 86), 'STRING': (False, 86), '-': (False, 86), 'and': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), '[': (False, 86), '<': (False, 86), ',': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'args': (True, 877), '{': (True, 568), 'tableconstructor': (True, 566), '(': (True, 565), 'STRING': (True, 563)}, {')': (True, 1677)}, {'}': (True, 1620)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 1656), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (True, 523), '::': (False, 48), '~=': (False, 48), 'break': (False, 48), ',': (False, 48), '>': (False, 48), '^': (True, 533), 'while': (False, 48), '-': (True, 524), '<': (False, 48), 'or': (False, 48), 'local': (False, 48), 'return': (False, 48), 'and': (False, 48), 'NAME': (False, 48), '(': (False, 48), 'if': (False, 48), '>=': (False, 48), '%': (True, 538), 'repeat': (False, 48), '+': (True, 525), '==': (False, 48), 'EMBEDSTAT': (False, 48), 'function': (False, 48), '*': (True, 536), 'do': (False, 48), '}': (False, 48), 'goto': (False, 48), 'for': (False, 48), '/': (True, 530), ';': (False, 48), '<=': (False, 48)}, {'..': (False, 50), '::': (False, 50), '~=': (False, 50), 'break': (False, 50), '>': (False, 50), '^': (True, 533), 'while': (False, 50), 'NAME': (False, 50), '-': (False, 50), '<': (False, 50), 'or': (False, 50), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ',': (False, 50), '(': (False, 50), 'if': (False, 50), '>=': (False, 50), '%': (True, 538), 'repeat': (False, 50), '+': (False, 50), '==': (False, 50), 'EMBEDSTAT': (False, 50), 'function': (False, 50), '*': (True, 536), 'do': (False, 50), '}': (False, 50), 'goto': (False, 50), 'for': (False, 50), '/': (True, 530), ';': (False, 50), '<=': (False, 50)}, {'..': (False, 49), '::': (False, 49), '~=': (False, 49), 'break': (False, 49), 'if': (False, 49), '^': (True, 533), 'while': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), 'local': (False, 49), 'return': (False, 49), '<': (False, 49), ',': (False, 49), '(': (False, 49), '>=': (False, 49), '%': (True, 538), 'repeat': (False, 49), '+': (False, 49), '==': (False, 49), 'EMBEDSTAT': (False, 49), 'function': (False, 49), '*': (True, 536), 'do': (False, 49), ';': (False, 49), '}': (False, 49), 'goto': (False, 49), 'for': (False, 49), '/': (True, 530), '>': (False, 49), 'NAME': (False, 49), '<=': (False, 49)}, {'..': (True, 523), '::': (False, 93), '~=': (True, 535), 'break': (False, 93), '>': (True, 531), '^': (True, 533), 'while': (False, 93), '-': (True, 524), 'and': (True, 529), 'or': (True, 528), 'explist__1': (True, 1425), 'local': (False, 93), 'return': (False, 93), '<': (True, 534), ',': (True, 526), '(': (False, 93), 'if': (False, 93), '>=': (True, 537), '%': (True, 538), 'goto': (False, 93), '+': (True, 525), '==': (True, 527), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 536), 'do': (False, 93), ';': (False, 93), '}': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '/': (True, 530), 'NAME': (False, 93), '<=': (True, 539)}, {'..': (True, 523), '::': (False, 47), '~=': (False, 47), 'break': (False, 47), ',': (False, 47), 'if': (False, 47), '^': (True, 533), 'while': (False, 47), '-': (True, 524), 'and': (False, 47), 'or': (False, 47), 'local': (False, 47), 'return': (False, 47), '<': (False, 47), 'NAME': (False, 47), '(': (False, 47), '>=': (False, 47), '%': (True, 538), 'goto': (False, 47), '+': (True, 525), '==': (False, 47), 'EMBEDSTAT': (False, 47), 'function': (False, 47), '*': (True, 536), 'do': (False, 47), '}': (False, 47), 'repeat': (False, 47), 'for': (False, 47), '/': (True, 530), '>': (False, 47), ';': (False, 47), '<=': (False, 47)}, {'..': (True, 523), '::': (False, 40), '~=': (True, 535), 'break': (False, 40), ',': (False, 40), '>': (True, 531), '^': (True, 533), 'while': (False, 40), '-': (True, 524), 'and': (True, 529), 'or': (False, 40), 'local': (False, 40), 'return': (False, 40), '<': (True, 534), 'NAME': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 537), '%': (True, 538), 'goto': (False, 40), '+': (True, 525), '==': (True, 527), 'EMBEDSTAT': (False, 40), 'function': (False, 40), '*': (True, 536), 'do': (False, 40), '}': (False, 40), 'repeat': (False, 40), 'for': (False, 40), '/': (True, 530), ';': (False, 40), '<=': (True, 539)}, {'..': (True, 523), '::': (False, 41), '~=': (True, 535), 'break': (False, 41), ',': (False, 41), '>': (True, 531), '^': (True, 533), 'while': (False, 41), '-': (True, 524), 'and': (False, 41), 'or': (False, 41), 'local': (False, 41), 'return': (False, 41), '<': (True, 534), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 537), '%': (True, 538), 'goto': (False, 41), '+': (True, 525), '==': (True, 527), 'EMBEDSTAT': (False, 41), 'function': (False, 41), '*': (True, 536), 'do': (False, 41), '}': (False, 41), 'repeat': (False, 41), 'for': (False, 41), '/': (True, 530), ';': (False, 41), '<=': (True, 539)}, {'..': (False, 52), '::': (False, 52), '~=': (False, 52), 'break': (False, 52), ',': (False, 52), 'if': (False, 52), '^': (True, 533), 'while': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), 'local': (False, 52), 'return': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '+': (False, 52), '==': (False, 52), 'EMBEDSTAT': (False, 52), 'function': (False, 52), '*': (False, 52), 'do': (False, 52), '}': (False, 52), 'goto': (False, 52), 'for': (False, 52), '/': (False, 52), '>': (False, 52), ';': (False, 52), '<=': (False, 52)}, {'..': (True, 523), '::': (False, 43), '~=': (False, 43), 'break': (False, 43), '>': (False, 43), '^': (True, 533), 'while': (False, 43), 'NAME': (False, 43), '-': (True, 524), '<': (False, 43), 'or': (False, 43), 'local': (False, 43), 'return': (False, 43), 'and': (False, 43), ',': (False, 43), '(': (False, 43), 'if': (False, 43), '>=': (False, 43), '%': (True, 538), 'goto': (False, 43), '+': (True, 525), '==': (False, 43), 'EMBEDSTAT': (False, 43), 'function': (False, 43), '*': (True, 536), 'do': (False, 43), '}': (False, 43), 'repeat': (False, 43), 'for': (False, 43), '/': (True, 530), ';': (False, 43), '<=': (False, 43)}, {'..': (False, 54), '::': (False, 54), '~=': (False, 54), 'break': (False, 54), ',': (False, 54), 'if': (False, 54), '^': (True, 533), 'while': (False, 54), '/': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), 'local': (False, 54), 'return': (False, 54), 'and': (False, 54), 'NAME': (False, 54), '(': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '+': (False, 54), '==': (False, 54), 'EMBEDSTAT': (False, 54), 'function': (False, 54), '*': (False, 54), 'do': (False, 54), '}': (False, 54), 'repeat': (False, 54), 'for': (False, 54), '>': (False, 54), ';': (False, 54), '<=': (False, 54)}, {'..': (True, 523), '::': (False, 42), '~=': (False, 42), 'break': (False, 42), ',': (False, 42), 'if': (False, 42), '^': (True, 533), 'while': (False, 42), '-': (True, 524), '<': (False, 42), 'or': (False, 42), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), '(': (False, 42), '>=': (False, 42), '%': (True, 538), 'repeat': (False, 42), '+': (True, 525), '==': (False, 42), 'EMBEDSTAT': (False, 42), 'function': (False, 42), '*': (True, 536), 'do': (False, 42), '}': (False, 42), 'goto': (False, 42), 'for': (False, 42), '/': (True, 530), '>': (False, 42), ';': (False, 42), '<=': (False, 42)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'do': (False, 86), 'STRING': (False, 86), '-': (False, 86), 'and': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), '[': (False, 86), '<': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'..': (True, 523), '::': (False, 46), '~=': (False, 46), 'break': (False, 46), ',': (False, 46), '>': (False, 46), '^': (True, 533), 'while': (False, 46), '-': (True, 524), '<': (False, 46), 'or': (False, 46), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), 'NAME': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 538), 'goto': (False, 46), '+': (True, 525), '==': (False, 46), 'EMBEDSTAT': (False, 46), 'function': (False, 46), '*': (True, 536), 'do': (False, 46), '}': (False, 46), 'repeat': (False, 46), 'for': (False, 46), '/': (True, 530), ';': (False, 46), '<=': (False, 46)}, {'args': (True, 1699), '{': (True, 425), 'tableconstructor': (True, 423), '(': (True, 422), 'STRING': (True, 420)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), ',': (False, 51), 'if': (False, 51), '^': (True, 533), 'while': (False, 51), '/': (False, 51), '-': (False, 51), 'and': (False, 51), 'or': (False, 51), 'local': (False, 51), 'return': (False, 51), '<': (False, 51), 'NAME': (False, 51), '(': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '+': (False, 51), '==': (False, 51), 'EMBEDSTAT': (False, 51), 'function': (False, 51), '*': (False, 51), 'do': (False, 51), '}': (False, 51), 'goto': (False, 51), 'for': (False, 51), '>': (False, 51), ';': (False, 51), '<=': (False, 51)}, {')': (True, 933)}, {'..': (True, 523), '::': (False, 45), '~=': (False, 45), 'break': (False, 45), ',': (False, 45), 'if': (False, 45), '^': (True, 533), 'while': (False, 45), '-': (True, 524), '<': (False, 45), 'or': (False, 45), 'local': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), '>=': (False, 45), '%': (True, 538), 'goto': (False, 45), '+': (True, 525), '==': (False, 45), 'EMBEDSTAT': (False, 45), 'function': (False, 45), '*': (True, 536), 'do': (False, 45), '}': (False, 45), 'repeat': (False, 45), 'for': (False, 45), '/': (True, 530), '>': (False, 45), ';': (False, 45), '<=': (False, 45)}, {'..': (False, 53), '::': (False, 53), '~=': (False, 53), 'break': (False, 53), 'if': (False, 53), '^': (True, 533), 'while': (False, 53), 'NAME': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), ',': (False, 53), '(': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '+': (False, 53), '==': (False, 53), 'EMBEDSTAT': (False, 53), 'function': (False, 53), '*': (False, 53), 'do': (False, 53), '}': (False, 53), 'repeat': (False, 53), 'for': (False, 53), '/': (False, 53), '>': (False, 53), ';': (False, 53), '<=': (False, 53)}, {'..': (True, 523), '::': (False, 44), '~=': (False, 44), 'break': (False, 44), ',': (False, 44), 'if': (False, 44), '^': (True, 533), 'while': (False, 44), '-': (True, 524), 'and': (False, 44), 'or': (False, 44), 'local': (False, 44), 'return': (False, 44), '<': (False, 44), 'NAME': (False, 44), '(': (False, 44), '>=': (False, 44), '%': (True, 538), 'repeat': (False, 44), '+': (True, 525), '==': (False, 44), 'EMBEDSTAT': (False, 44), 'function': (False, 44), '*': (True, 536), 'do': (False, 44), '}': (False, 44), 'goto': (False, 44), 'for': (False, 44), '/': (True, 530), '>': (False, 44), ';': (False, 44), '<=': (False, 44)}, {'}': (True, 1029)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 842), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 609), '+': (False, 50), '*': (True, 612), 'do': (False, 50), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 615), '<': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 614), '<=': (False, 50)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1144), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '/': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'until': (False, 31), 'local': (False, 31), 'return': (False, 31), '<': (False, 31), ',': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '*': (False, 31), 'do': (False, 31), ';': (False, 31), 'repeat': (False, 31), 'for': (False, 31), '>': (False, 31), 'NAME': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), ',': (False, 37), 'if': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'until': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '*': (False, 37), 'do': (False, 37), 'repeat': (False, 37), 'for': (False, 37), '/': (False, 37), '>': (False, 37), ';': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), ',': (False, 38), 'tableconstructor': (True, 1156), 'if': (False, 38), '^': (False, 38), 'args': (True, 1155), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'until': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1157), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1153), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1150), '+': (False, 38), '==': (False, 38), '{': (True, 1154), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1151), ':': (True, 1152), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), ',': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '/': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), 'until': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), '*': (False, 39), 'do': (False, 39), 'goto': (False, 39), 'for': (False, 39), '>': (False, 39), ';': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1162), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'until': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1166), '(': (True, 1167)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), ',': (False, 35), '/': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'until': (False, 35), 'local': (False, 35), 'return': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), '*': (False, 35), 'do': (False, 35), 'repeat': (False, 35), 'for': (False, 35), '>': (False, 35), ';': (False, 35), '<=': (False, 35)}, {'::': (False, 64), 'break': (False, 64), 'if': (False, 64), 'EMBEDSTAT': (False, 64), 'function': (False, 64), 'do': (False, 64), 'while': (False, 64), 'NAME': (False, 64), 'goto': (False, 64), 'for': (False, 64), 'until': (False, 64), 'local': (False, 64), 'return': (False, 64), ';': (False, 64), '(': (False, 64), 'repeat': (False, 64)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1172), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), '^': (False, 33), 'while': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'until': (False, 33), 'local': (False, 33), 'return': (False, 33), '<': (False, 33), ',': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'goto': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '*': (False, 33), 'do': (False, 33), ';': (False, 33), 'repeat': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), 'NAME': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), ',': (False, 30), '/': (False, 30), '^': (False, 30), 'while': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), 'until': (False, 30), 'local': (False, 30), 'return': (False, 30), '<': (False, 30), 'NAME': (False, 30), '(': (False, 30), 'if': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), '*': (False, 30), 'do': (False, 30), 'goto': (False, 30), 'for': (False, 30), '>': (False, 30), ';': (False, 30), '<=': (False, 30)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1182), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), ',': (False, 84), '/': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'until': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), ';': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'until': (False, 36), 'local': (False, 36), 'return': (False, 36), 'and': (False, 36), ',': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '*': (False, 36), 'do': (False, 36), 'NAME': (False, 36), 'repeat': (False, 36), 'for': (False, 36), '/': (False, 36), '>': (False, 36), ';': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'until': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), ';': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1185), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'..': (True, 1187), '::': (False, 93), '~=': (True, 1197), 'break': (False, 93), '/': (True, 1202), '^': (True, 1195), 'while': (False, 93), '-': (True, 1188), 'and': (True, 1193), 'or': (True, 1199), 'until': (False, 93), 'explist__1': (True, 1192), 'local': (False, 93), 'return': (False, 93), '<': (True, 1196), ',': (True, 1190), '(': (False, 93), 'if': (False, 93), '>=': (True, 1200), '%': (True, 1201), 'goto': (False, 93), '+': (True, 1189), '==': (True, 1191), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 1198), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '>': (True, 1194), 'NAME': (False, 93), '<=': (True, 1203)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), ',': (False, 32), 'if': (False, 32), '^': (False, 32), 'while': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), 'until': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '*': (False, 32), 'do': (False, 32), 'goto': (False, 32), 'for': (False, 32), '/': (False, 32), '>': (False, 32), ';': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), ',': (False, 34), '>': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'until': (False, 34), 'local': (False, 34), 'return': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'if': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '*': (False, 34), 'do': (False, 34), 'goto': (False, 34), 'for': (False, 34), '/': (False, 34), ';': (False, 34), '<=': (False, 34)}, {'..': (True, 600), '+': (True, 602), '==': (False, 48), '>': (False, 48), '^': (True, 609), '~=': (False, 48), '*': (True, 612), 'do': (False, 48), '-': (True, 601), '<': (False, 48), 'or': (False, 48), '/': (True, 615), 'and': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 614), '<=': (False, 48)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 609), '~=': (False, 49), '*': (True, 612), 'do': (False, 49), '-': (False, 49), '<': (False, 49), 'or': (False, 49), '/': (True, 615), 'and': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 614), '<=': (False, 49)}, {'end': (False, 87), 'elseif': (False, 87), 'else': (False, 87)}, {';': (False, 107), '{': (True, 1587), 'EMBEDEXPR': (True, 1588), 'explist': (True, 1592), 'function': (True, 1589), '#': (True, 1590), 'functioncall': (True, 1591), 'prefixexp': (True, 1598), 'true': (True, 1593), 'STRING': (True, 1594), '-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 1600), 'var': (True, 1599), 'retstat__1': (True, 1606), 'tableconstructor': (True, 1601), 'end': (False, 107), 'elseif': (False, 107), 'nil': (True, 1602), 'NAME': (True, 1603), 'else': (False, 107), '(': (True, 1604), 'not': (True, 1605), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'end': (False, 0), 'elseif': (False, 0), 'else': (False, 0)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'explist__1': (True, 926), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 603), '*': (True, 612), 'do': (False, 93), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'::': (False, 75), 'break': (False, 75), 'if': (False, 75), 'EMBEDSTAT': (False, 75), 'function': (False, 75), 'do': (False, 75), 'while': (False, 75), 'NAME': (False, 75), 'goto': (False, 75), 'for': (False, 75), 'until': (False, 75), 'local': (False, 75), 'return': (False, 75), ';': (False, 75), '(': (False, 75), 'repeat': (False, 75)}, {')': (False, 97), 'funcbody__1': (True, 931), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'::': (True, 932)}, {')': (True, 1369)}, {'..': (True, 600), '+': (True, 602), '==': (False, 47), '>': (False, 47), '^': (True, 609), '~=': (False, 47), '*': (True, 612), 'do': (False, 47), '-': (True, 601), 'and': (False, 47), 'or': (False, 47), '/': (True, 615), '<': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 614), '<=': (False, 47)}, {'args': (True, 1464), '{': (True, 432), 'tableconstructor': (True, 430), '(': (True, 429), 'STRING': (True, 433)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), ',': (False, 40), '==': (True, 604), '/': (True, 615), '<': (True, 610), '>': (True, 607), 'do': (False, 40), 'and': (True, 606), '^': (True, 609), '~=': (True, 611), '*': (True, 612), 'or': (False, 40), '>=': (True, 613), '%': (True, 614), '<=': (True, 616)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (True, 1040), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'do': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'prefixexp': (True, 1226), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), 'exp': (True, 1241), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'explist': (True, 1231), 'true': (True, 1238), 'STRING': (True, 1237)}, {')': (True, 1244)}, {'funcbody': (True, 1245), '(': (True, 1246)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '>': (False, 86), '<': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), ')': (False, 86), ':': (False, 86), 'or': (False, 86), '/': (False, 86), '[': (False, 86), 'and': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'args': (True, 1247), '{': (True, 738), 'tableconstructor': (True, 736), '(': (True, 735), 'STRING': (True, 733)}, {'.': (False, 11), ':': (False, 11), '{': (False, 11), '=': (False, 16), 'varlist__1': (True, 1248), '[': (False, 11), ',': (True, 66), '(': (False, 11), 'STRING': (False, 11)}, {'.': (True, 27), 'STRING': (True, 1254), ':': (True, 1249), '(': (True, 1250), 'tableconstructor': (True, 1251), 'args': (True, 1252), '{': (True, 1253), '[': (True, 33)}, {'.': (False, 12), ':': (False, 12), '(': (False, 12), '{': (False, 12), 'STRING': (False, 12), '[': (False, 12)}, {'end': (True, 1561)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '<': (True, 1053), '>': (True, 1052), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'do': (True, 1804), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '<=': (True, 1060)}, {')': (True, 1043)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), ']': (False, 62), '*': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1063), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'end': (False, 2), 'elseif': (False, 2), 'else': (False, 2), 'return': (False, 2)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), '-': (False, 9), 'and': (False, 9), ')': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'::': (False, 68), 'break': (False, 68), 'if': (False, 68), 'elseif': (False, 68), 'EMBEDSTAT': (False, 68), 'function': (False, 68), 'do': (False, 68), 'while': (False, 68), 'NAME': (False, 68), 'repeat': (False, 68), 'for': (False, 68), 'end': (False, 68), 'local': (False, 68), 'return': (False, 68), ';': (False, 68), '(': (False, 68), 'goto': (False, 68), 'else': (False, 68)}, {'}': (True, 1262)}, {'NAME': (True, 1794)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1795), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '::': (False, 24), 'break': (False, 24), '{': (False, 24), 'if': (False, 24), 'local': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), 'do': (False, 24), 'while': (False, 24), ';': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), 'end': (False, 24), 'elseif': (False, 24), 'return': (False, 24), '[': (False, 24), 'NAME': (False, 24), '(': (False, 24), 'STRING': (False, 24), 'else': (False, 24)}, {'.': (False, 21), '::': (False, 21), 'break': (False, 21), '{': (False, 21), 'if': (False, 21), 'elseif': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), 'do': (False, 21), 'while': (False, 21), ';': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), 'end': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'NAME': (False, 21), '(': (False, 21), 'STRING': (False, 21), 'else': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1798), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 25), '::': (False, 25), 'break': (False, 25), '{': (False, 25), 'if': (False, 25), 'local': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'do': (False, 25), 'while': (False, 25), 'NAME': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), 'end': (False, 25), 'elseif': (False, 25), 'return': (False, 25), '[': (False, 25), ';': (False, 25), '(': (False, 25), 'repeat': (False, 25), 'else': (False, 25)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 1159), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'}': (True, 1553)}, {'end': (False, 99), 'stat__2': (True, 1554), 'else': (True, 1555)}, {'-': (True, 112), 'false': (True, 113), 'functiondef': (True, 114), 'prefixexp': (True, 129), '(': (True, 127), 'var': (True, 118), 'function': (True, 122), 'EMBEDEXPR': (True, 120), 'tableconstructor': (True, 116), 'NUMBER': (True, 131), 'nil': (True, 119), '#': (True, 123), 'NAME': (True, 124), '...': (True, 130), 'functioncall': (True, 117), '{': (True, 121), 'not': (True, 128), 'exp': (True, 1556), 'true': (True, 126), 'STRING': (True, 125)}, {'in': (True, 1558)}, {'in': (False, 29), 'namelist__1': (True, 323), ',': (True, 324), '=': (True, 1559)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'goto': (False, 9), '+': (False, 9), '==': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), '}': (False, 9), 'repeat': (False, 9), 'for': (False, 9), '/': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'..': (False, 56), '~=': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 370), '+': (False, 56), ']': (False, 56), '*': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'::': (False, 105), 'break': (False, 105), 'if': (False, 105), 'elseif': (False, 105), 'EMBEDSTAT': (False, 105), 'function': (False, 105), 'do': (False, 105), 'while': (False, 105), 'NAME': (False, 105), 'repeat': (False, 105), 'end': (False, 105), 'for': (False, 105), '=': (True, 915), 'local': (False, 105), 'return': (False, 105), ';': (False, 105), '(': (False, 105), 'goto': (False, 105), 'else': (False, 105), 'stat__4': (True, 916)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 881), ';': (False, 29), 'NAME': (False, 29), '=': (False, 29), 'repeat': (False, 29), 'for': (False, 29), 'end': (False, 29), 'elseif': (False, 29), 'return': (False, 29), ',': (True, 882), '(': (False, 29), 'goto': (False, 29), 'else': (False, 29)}, {'NAME': (True, 919)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '/': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'do': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ',': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'::': (False, 91), 'break': (False, 91), '(': (False, 91), 'if': (False, 91), 'EMBEDSTAT': (False, 91), 'function': (False, 91), 'do': (False, 91), 'while': (False, 91), ';': (False, 91), 'goto': (False, 91), 'for': (False, 91), 'local': (False, 91), 'return': (False, 91), 'NAME': (False, 91), '?>': (False, 91), 'repeat': (False, 91)}, {'until': (True, 1673)}, {'-': (True, 401), ')': (True, 1644), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'::': (False, 10), 'break': (False, 10), 'if': (False, 10), 'local': (False, 10), 'EMBEDSTAT': (False, 10), 'function': (False, 10), 'do': (False, 10), 'while': (False, 10), ';': (False, 10), '=': (False, 10), 'repeat': (False, 10), 'for': (False, 10), 'end': (False, 10), 'elseif': (False, 10), 'return': (False, 10), 'NAME': (False, 10), '(': (False, 10), 'goto': (False, 10), 'else': (False, 10)}, {'NAME': (True, 1647)}, {'..': (False, 55), '~=': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 370), '+': (False, 55), ']': (False, 55), '*': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1802), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '/': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'local': (False, 31), 'return': (False, 31), '<': (False, 31), ',': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '*': (False, 31), 'do': (False, 31), ';': (False, 31), 'repeat': (False, 31), 'end': (False, 31), 'for': (False, 31), '>': (False, 31), 'NAME': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), ',': (False, 37), '/': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), 'if': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '*': (False, 37), 'do': (False, 37), 'repeat': (False, 37), 'end': (False, 37), 'for': (False, 37), '>': (False, 37), ';': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), ',': (False, 38), 'tableconstructor': (True, 1813), 'if': (False, 38), '^': (False, 38), 'end': (False, 38), 'args': (True, 1812), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1814), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1810), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1807), '+': (False, 38), '==': (False, 38), '{': (True, 1811), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1808), ':': (True, 1809), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), ',': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), '*': (False, 39), 'do': (False, 39), 'goto': (False, 39), 'end': (False, 39), 'for': (False, 39), '/': (False, 39), '>': (False, 39), ';': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1819), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'end': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1823), '(': (True, 1824)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), ',': (False, 35), 'end': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'local': (False, 35), 'return': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), '*': (False, 35), 'do': (False, 35), 'repeat': (False, 35), 'for': (False, 35), '/': (False, 35), '>': (False, 35), ';': (False, 35), '<=': (False, 35)}, {'::': (False, 64), 'break': (False, 64), 'if': (False, 64), 'EMBEDSTAT': (False, 64), 'function': (False, 64), 'do': (False, 64), 'while': (False, 64), 'NAME': (False, 64), 'goto': (False, 64), 'for': (False, 64), 'end': (False, 64), 'local': (False, 64), 'return': (False, 64), ';': (False, 64), '(': (False, 64), 'repeat': (False, 64)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1827), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), '^': (False, 33), 'while': (False, 33), '/': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'local': (False, 33), 'return': (False, 33), '<': (False, 33), ',': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'repeat': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '*': (False, 33), 'do': (False, 33), ';': (False, 33), 'goto': (False, 33), 'for': (False, 33), 'end': (False, 33), '>': (False, 33), 'NAME': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), ',': (False, 30), 'if': (False, 30), '^': (False, 30), 'while': (False, 30), '/': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), 'local': (False, 30), 'return': (False, 30), '<': (False, 30), 'NAME': (False, 30), '(': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), '*': (False, 30), 'do': (False, 30), 'goto': (False, 30), 'end': (False, 30), 'for': (False, 30), '>': (False, 30), ';': (False, 30), '<=': (False, 30)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 935), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), ',': (False, 84), '/': (False, 84), '^': (False, 84), 'end': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), ';': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), '/': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'local': (False, 36), 'return': (False, 36), 'and': (False, 36), ',': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '*': (False, 36), 'do': (False, 36), 'NAME': (False, 36), 'repeat': (False, 36), 'for': (False, 36), 'end': (False, 36), '>': (False, 36), ';': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'end': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), ';': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 945), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'..': (True, 952), '::': (False, 93), '~=': (True, 962), 'break': (False, 93), '/': (True, 967), '^': (True, 960), 'while': (False, 93), '-': (True, 953), 'and': (True, 958), 'or': (True, 964), 'explist__1': (True, 959), 'local': (False, 93), 'return': (False, 93), '<': (True, 961), ',': (True, 955), '(': (False, 93), 'if': (False, 93), '>=': (True, 965), '%': (True, 966), 'goto': (False, 93), '+': (True, 954), '==': (True, 956), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 963), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'end': (False, 93), 'for': (False, 93), '>': (True, 957), 'NAME': (False, 93), '<=': (True, 968)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), ',': (False, 32), 'if': (False, 32), '^': (False, 32), 'while': (False, 32), '/': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '*': (False, 32), 'do': (False, 32), 'goto': (False, 32), 'end': (False, 32), 'for': (False, 32), '>': (False, 32), ';': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), ',': (False, 34), '/': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'local': (False, 34), 'return': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'if': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '*': (False, 34), 'do': (False, 34), 'goto': (False, 34), 'end': (False, 34), 'for': (False, 34), '>': (False, 34), ';': (False, 34), '<=': (False, 34)}, {'NAME': (True, 1652)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '^': (False, 25), '~=': (False, 25), ']': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '>': (False, 25), '[': (False, 25), '<': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1654)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1655), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '..': (False, 24), '~=': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '+': (False, 24), ']': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '>': (False, 21), '^': (False, 21), '~=': (False, 21), ']': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '/': (False, 21), '[': (False, 21), 'and': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1669), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 1670), 'true': (True, 178), 'STRING': (True, 177)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), ',': (False, 86), '==': (False, 86), '{': (False, 86), '>': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), '}': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '/': (False, 86), '[': (False, 86), 'and': (False, 86), ';': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'args': (True, 1456), '{': (True, 160), 'tableconstructor': (True, 162), '(': (True, 159), 'STRING': (True, 157)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'explist': (True, 1465), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), 'exp': (True, 1241), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'::': (False, 77), 'break': (False, 77), 'if': (False, 77), 'local': (False, 77), 'EMBEDSTAT': (False, 77), 'function': (False, 77), 'do': (False, 77), 'while': (False, 77), 'NAME': (False, 77), 'goto': (False, 77), 'for': (False, 77), 'end': (False, 77), 'elseif': (False, 77), 'return': (False, 77), ';': (False, 77), '(': (False, 77), 'repeat': (False, 77), 'else': (False, 77)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'do': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {')': (True, 1828)}, {'funcbody': (True, 1831), '(': (True, 1246)}, {'}': (True, 1222)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'do': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'::': (False, 75), 'break': (False, 75), '?>': (False, 75), 'if': (False, 75), 'EMBEDSTAT': (False, 75), 'function': (False, 75), 'do': (False, 75), 'while': (False, 75), 'NAME': (False, 75), 'goto': (False, 75), 'for': (False, 75), 'local': (False, 75), 'return': (False, 75), ';': (False, 75), '(': (False, 75), 'repeat': (False, 75)}, {')': (False, 97), 'funcbody__1': (True, 1863), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 1896), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1429), 'true': (True, 221), 'STRING': (True, 220)}, {'do': (False, 92)}, {'NAME': (True, 1449)}, {'funcname__2': (True, 1437), ':': (True, 1438), '(': (False, 5)}, {'::': (False, 75), 'break': (False, 75), 'if': (False, 75), 'EMBEDSTAT': (False, 75), 'function': (False, 75), 'do': (False, 75), 'while': (False, 75), ';': (False, 75), '}': (False, 75), 'goto': (False, 75), 'for': (False, 75), 'local': (False, 75), 'return': (False, 75), 'NAME': (False, 75), '(': (False, 75), 'repeat': (False, 75)}, {')': (False, 97), 'funcbody__1': (True, 1453), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {')': (True, 1469)}, {'::': (False, 91), 'break': (False, 91), 'if': (False, 91), 'local': (False, 91), 'EMBEDSTAT': (False, 91), 'function': (False, 91), 'do': (False, 91), 'while': (False, 91), ';': (False, 91), 'goto': (False, 91), 'for': (False, 91), 'end': (False, 91), 'elseif': (False, 91), 'return': (False, 91), 'NAME': (False, 91), '(': (False, 91), 'repeat': (False, 91), 'else': (False, 91)}, {'.': (False, 23), '..': (False, 23), '~=': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '+': (False, 23), '*': (False, 23), 'do': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), ',': (False, 41), '==': (True, 604), '/': (True, 615), '<': (True, 610), '>': (True, 607), 'do': (False, 41), 'and': (False, 41), '^': (True, 609), '~=': (True, 611), '*': (True, 612), 'or': (False, 41), '>=': (True, 613), '%': (True, 614), '<=': (True, 616)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '/': (False, 56), '^': (True, 960), 'while': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), ',': (False, 56), '(': (False, 56), 'if': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), '*': (False, 56), 'do': (False, 56), 'NAME': (False, 56), 'goto': (False, 56), 'end': (False, 56), 'for': (False, 56), '>': (False, 56), ';': (False, 56), '<=': (False, 56)}, {'..': (True, 600), '+': (True, 602), '==': (False, 43), '>': (False, 43), '^': (True, 609), '~=': (False, 43), '*': (True, 612), 'do': (False, 43), '-': (True, 601), 'and': (False, 43), 'or': (False, 43), '/': (True, 615), '<': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 614), '<=': (False, 43)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1936), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'}': (True, 1650)}, {'in': (False, 28)}, {')': (True, 973)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 609), '~=': (False, 54), '*': (False, 54), 'do': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'args': (True, 1651), '{': (True, 552), 'tableconstructor': (True, 550), '(': (True, 549), 'STRING': (True, 553)}, {'..': (True, 600), '+': (True, 602), '==': (False, 42), '>': (False, 42), '^': (True, 609), '~=': (False, 42), '*': (True, 612), 'do': (False, 42), '-': (True, 601), 'and': (False, 42), 'or': (False, 42), '/': (True, 615), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 614), '<=': (False, 42)}, {'..': (True, 600), '+': (True, 602), '==': (False, 46), '>': (False, 46), '^': (True, 609), '~=': (False, 46), '*': (True, 612), 'do': (False, 46), '-': (True, 601), '<': (False, 46), 'or': (False, 46), '/': (True, 615), 'and': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 614), '<=': (False, 46)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 960), 'while': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'local': (False, 55), 'return': (False, 55), '<': (False, 55), ',': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), '*': (False, 55), 'do': (False, 55), ';': (False, 55), 'goto': (False, 55), 'end': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'NAME': (False, 55), '<=': (False, 55)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 609), '~=': (False, 51), '*': (False, 51), 'do': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1836), 'true': (True, 487), 'STRING': (True, 486)}, {'}': (True, 996)}, {'..': (True, 600), '+': (True, 602), '==': (False, 45), '>': (False, 45), '^': (True, 609), '~=': (False, 45), '*': (True, 612), 'do': (False, 45), '-': (True, 601), '<': (False, 45), 'or': (False, 45), '/': (True, 615), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 614), '<=': (False, 45)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'prefixexp': (True, 452), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), 'exp': (True, 467), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'explist': (True, 1003), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 609), '~=': (False, 53), '*': (False, 53), 'do': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1803), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1801), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1806), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1815), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1817), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1820), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1821), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'::': (False, 90), 'break': (False, 90), 'if': (False, 90), 'EMBEDSTAT': (False, 90), 'function': (False, 90), 'do': (False, 90), 'while': (False, 90), ';': (False, 90), 'goto': (False, 90), 'for': (False, 90), 'end': (False, 90), 'local': (False, 90), 'return': (False, 90), 'NAME': (False, 90), '(': (False, 90), 'repeat': (False, 90)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1825), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1826), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1829), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1832), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1368), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1370), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1371), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1372), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'exp': (True, 1373), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 609), '+': (False, 52), '*': (False, 52), 'do': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'::': (False, 10), 'break': (False, 10), 'if': (False, 10), 'EMBEDSTAT': (False, 10), 'function': (False, 10), 'do': (False, 10), 'while': (False, 10), ';': (False, 10), '=': (False, 10), 'repeat': (False, 10), 'for': (False, 10), 'end': (False, 10), 'local': (False, 10), 'return': (False, 10), 'NAME': (False, 10), '(': (False, 10), 'goto': (False, 10)}, {'NAME': (True, 1386)}, {'..': (True, 600), '+': (True, 602), '==': (False, 44), '>': (False, 44), '^': (True, 609), '~=': (False, 44), '*': (True, 612), 'do': (False, 44), '-': (True, 601), '<': (False, 44), 'or': (False, 44), '/': (True, 615), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 614), '<=': (False, 44)}, {'.': (False, 23), '::': (False, 23), 'break': (False, 23), '{': (False, 23), 'if': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'repeat': (False, 23), 'do': (False, 23), 'while': (False, 23), 'NAME': (False, 23), 'STRING': (False, 23), ':': (False, 23), 'for': (False, 23), 'until': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), ';': (False, 23), '(': (False, 23), 'goto': (False, 23)}, {'-': (True, 884), 'false': (True, 885), 'functiondef': (True, 886), 'explist': (True, 1643), 'functioncall': (True, 900), 'var': (True, 890), 'tableconstructor': (True, 888), 'EMBEDEXPR': (True, 892), 'exp': (True, 902), '{': (True, 894), 'function': (True, 891), '#': (True, 897), 'nil': (True, 896), 'STRING': (True, 904), 'true': (True, 903), '(': (True, 889), 'not': (True, 901), 'prefixexp': (True, 887), 'NAME': (True, 898), '...': (True, 899), 'NUMBER': (True, 895)}, {'::': (False, 77), 'break': (False, 77), 'if': (False, 77), 'EMBEDSTAT': (False, 77), 'function': (False, 77), 'do': (False, 77), 'while': (False, 77), 'NAME': (False, 77), 'goto': (False, 77), 'for': (False, 77), 'end': (False, 77), 'local': (False, 77), 'return': (False, 77), ';': (False, 77), '(': (False, 77), 'repeat': (False, 77)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 1283), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'..': (False, 31), '::': (False, 31), '+': (False, 31), 'break': (False, 31), '==': (False, 31), 'if': (False, 31), '^': (False, 31), 'function': (False, 31), '~=': (False, 31), '*': (False, 31), 'do': (False, 31), 'while': (False, 31), 'and': (False, 31), ';': (False, 31), '/': (False, 31), 'repeat': (False, 31), '-': (False, 31), 'EMBEDSTAT': (False, 31), 'or': (False, 31), '>': (False, 31), 'local': (False, 31), 'return': (False, 31), '}': (False, 31), '<': (False, 31), 'NAME': (False, 31), '(': (False, 31), 'for': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), '==': (False, 37), 'if': (False, 37), '^': (False, 37), 'local': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '+': (False, 37), '*': (False, 37), 'do': (False, 37), 'while': (False, 37), '}': (False, 37), 'repeat': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), '/': (False, 37), '>': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), ';': (False, 37), '(': (False, 37), 'for': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), 'tableconstructor': (True, 1291), 'if': (False, 38), '^': (False, 38), 'args': (True, 1290), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1292), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1288), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1285), '+': (False, 38), '==': (False, 38), '{': (True, 1289), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), '}': (False, 38), 'goto': (False, 38), 'STRING': (True, 1286), ':': (True, 1287), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '+': (False, 39), 'break': (False, 39), '==': (False, 39), 'if': (False, 39), '<': (False, 39), '^': (False, 39), 'function': (False, 39), '~=': (False, 39), '*': (False, 39), 'do': (False, 39), 'while': (False, 39), '}': (False, 39), 'goto': (False, 39), '-': (False, 39), 'EMBEDSTAT': (False, 39), 'or': (False, 39), '/': (False, 39), '>': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), ';': (False, 39), '(': (False, 39), 'for': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1302), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), 'NAME': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), '}': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1305), '(': (True, 1306)}, {'..': (False, 35), '::': (False, 35), '+': (False, 35), 'break': (False, 35), '==': (False, 35), 'if': (False, 35), '^': (False, 35), 'function': (False, 35), '~=': (False, 35), '*': (False, 35), 'do': (False, 35), 'while': (False, 35), 'and': (False, 35), '}': (False, 35), 'repeat': (False, 35), '-': (False, 35), 'EMBEDSTAT': (False, 35), 'for': (False, 35), '/': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), 'NAME': (False, 35), ';': (False, 35), '(': (False, 35), 'or': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1321), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '+': (False, 33), 'break': (False, 33), '==': (False, 33), 'if': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '~=': (False, 33), '*': (False, 33), 'do': (False, 33), 'while': (False, 33), '}': (False, 33), 'repeat': (False, 33), '-': (False, 33), '^': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), 'local': (False, 33), 'return': (False, 33), 'and': (False, 33), '<': (False, 33), 'NAME': (False, 33), ';': (False, 33), '(': (False, 33), 'or': (False, 33), '>=': (False, 33), '%': (False, 33), 'goto': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), '==': (False, 30), 'if': (False, 30), '<': (False, 30), '^': (False, 30), 'function': (False, 30), '+': (False, 30), '*': (False, 30), 'do': (False, 30), 'while': (False, 30), ';': (False, 30), '}': (False, 30), 'repeat': (False, 30), '-': (False, 30), 'EMBEDSTAT': (False, 30), 'or': (False, 30), '>': (False, 30), 'local': (False, 30), 'return': (False, 30), 'and': (False, 30), 'NAME': (False, 30), '/': (False, 30), '(': (False, 30), 'for': (False, 30), '>=': (False, 30), '%': (False, 30), 'goto': (False, 30), '<=': (False, 30)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 1325), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), 'if': (False, 84), '^': (False, 84), 'while': (False, 84), '/': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), '}': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), ';': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), '==': (False, 36), 'if': (False, 36), '^': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '+': (False, 36), '*': (False, 36), 'do': (False, 36), 'while': (False, 36), ';': (False, 36), '}': (False, 36), 'goto': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '/': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), 'NAME': (False, 36), '(': (False, 36), 'for': (False, 36), '>=': (False, 36), '%': (False, 36), 'repeat': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), 'and': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), '<': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), '}': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 1506), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'..': (True, 1512), '::': (False, 71), '+': (True, 1514), 'break': (False, 71), '==': (True, 1515), '>': (True, 1519), '^': (True, 1520), 'function': (False, 71), '~=': (True, 1522), 'EMBEDSTAT': (False, 71), '*': (True, 1523), 'do': (False, 71), 'while': (False, 71), ';': (False, 71), 'if': (False, 71), '}': (False, 71), 'goto': (False, 71), '-': (True, 1513), 'and': (True, 1517), 'or': (True, 1516), '/': (True, 1518), 'local': (False, 71), 'return': (False, 71), '<': (True, 1521), 'NAME': (False, 71), '(': (False, 71), 'for': (False, 71), '>=': (True, 1524), '%': (True, 1525), 'repeat': (False, 71), '<=': (True, 1526)}, {'..': (False, 32), '::': (False, 32), '+': (False, 32), 'break': (False, 32), '==': (False, 32), 'if': (False, 32), '^': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '~=': (False, 32), '*': (False, 32), 'do': (False, 32), 'while': (False, 32), ';': (False, 32), '/': (False, 32), 'repeat': (False, 32), '-': (False, 32), '<': (False, 32), 'for': (False, 32), '>': (False, 32), 'local': (False, 32), 'return': (False, 32), '}': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), 'or': (False, 32), '>=': (False, 32), '%': (False, 32), 'goto': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '+': (False, 34), 'break': (False, 34), '==': (False, 34), 'if': (False, 34), '^': (False, 34), 'function': (False, 34), '~=': (False, 34), '*': (False, 34), 'do': (False, 34), 'while': (False, 34), 'and': (False, 34), ';': (False, 34), '}': (False, 34), 'repeat': (False, 34), '-': (False, 34), 'EMBEDSTAT': (False, 34), 'or': (False, 34), '/': (False, 34), 'local': (False, 34), 'return': (False, 34), '>': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'for': (False, 34), '>=': (False, 34), '%': (False, 34), 'goto': (False, 34), '<=': (False, 34)}, {'.': (False, 9), '::': (False, 9), 'break': (False, 9), '{': (False, 9), 'if': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'repeat': (False, 9), 'do': (False, 9), 'while': (False, 9), 'NAME': (False, 9), 'STRING': (False, 9), ':': (False, 9), 'for': (False, 9), 'until': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), ';': (False, 9), '(': (False, 9), 'goto': (False, 9)}, {'funcbody': (True, 1560), '(': (True, 779)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1571), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'prefixexp': (True, 452), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), 'exp': (True, 467), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'explist': (True, 1585), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '/': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), ';': (False, 62), '}': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '>': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1800), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 239), '~=': (False, 56), '*': (False, 56), ';': (False, 56), '}': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'do': (True, 1034)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1030), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'NAME': (True, 498), 'parlist': (True, 1033), '...': (True, 499)}, {')': (False, 8)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), ';': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), 'until': (False, 39), '/': (False, 39), '<': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), ';': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), 'until': (False, 35), '/': (False, 35), 'and': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 1581), '(': (True, 1582)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1586), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), ',': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), 'until': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'.': (True, 1609), '..': (False, 38), '~=': (False, 38), '==': (False, 38), '{': (True, 1613), '/': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 1614), ';': (False, 38), 'STRING': (True, 1610), '-': (False, 38), '<': (False, 38), ':': (True, 1611), 'or': (False, 38), 'until': (False, 38), 'tableconstructor': (True, 1615), '>': (False, 38), '[': (True, 1616), 'and': (False, 38), ',': (False, 38), '(': (True, 1612), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), ';': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), 'until': (False, 32), '>': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '+': (False, 34), '*': (False, 34), ';': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'until': (False, 34), '>': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1619), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), ';': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), 'until': (False, 31), '/': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '/': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), ';': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), 'until': (False, 37), '>': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {'until': (False, 106), ';': (False, 106)}, {'..': (False, 11), '.': (False, 11), '~=': (False, 11), ',': (False, 11), '==': (False, 11), '{': (False, 11), '>': (False, 11), '^': (False, 11), '+': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), 'until': (False, 11), '/': (False, 11), '[': (False, 11), 'and': (False, 11), ';': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'..': (True, 1624), '-': (True, 1625), '+': (True, 1626), '==': (True, 1628), 'or': (True, 1629), 'until': (False, 93), '<': (True, 1635), '/': (True, 1631), '>': (True, 1632), 'explist__1': (True, 1633), 'and': (True, 1634), '^': (True, 1630), '>=': (True, 1638), ',': (True, 1627), '*': (True, 1637), '~=': (True, 1636), '%': (True, 1639), ';': (False, 93), '<=': (True, 1640)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1834), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), '*': (False, 30), ';': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), 'until': (False, 30), '/': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), '<': (False, 84), ':': (False, 84), 'or': (False, 84), 'until': (False, 84), '/': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 1839), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1840), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'retstat__2': (True, 1841), 'until': (False, 89), ';': (True, 1842)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), ';': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'until': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '/': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), ';': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'until': (False, 33), '>': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'.': (False, 9), '..': (False, 9), '~=': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '+': (False, 9), '*': (False, 9), 'do': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'end': (True, 1207)}, {'::': (False, 91), 'break': (False, 91), 'if': (False, 91), 'EMBEDSTAT': (False, 91), 'function': (False, 91), 'do': (False, 91), 'while': (False, 91), ';': (False, 91), 'goto': (False, 91), 'for': (False, 91), 'until': (False, 91), 'local': (False, 91), 'return': (False, 91), 'NAME': (False, 91), '(': (False, 91), 'repeat': (False, 91)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {')': (False, 26)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1805), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'explist': (True, 1818), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), 'exp': (True, 825), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'::': (False, 77), 'break': (False, 77), 'if': (False, 77), 'EMBEDSTAT': (False, 77), 'function': (False, 77), 'do': (False, 77), 'while': (False, 77), 'NAME': (False, 77), 'repeat': (False, 77), 'for': (False, 77), 'until': (False, 77), 'local': (False, 77), 'return': (False, 77), ';': (False, 77), '(': (False, 77), 'goto': (False, 77)}, {'::': (False, 10), 'break': (False, 10), 'if': (False, 10), 'EMBEDSTAT': (False, 10), 'function': (False, 10), 'do': (False, 10), 'while': (False, 10), ';': (False, 10), 'repeat': (False, 10), 'for': (False, 10), 'until': (False, 10), '=': (False, 10), 'local': (False, 10), 'return': (False, 10), 'NAME': (False, 10), '(': (False, 10), 'goto': (False, 10)}, {'NAME': (True, 1822)}, {'funcbody': (True, 1830), '(': (True, 835)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 1092), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1114), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'::': (False, 69), 'break': (False, 69), 'if': (False, 69), 'EMBEDSTAT': (False, 69), 'function': (False, 69), 'do': (False, 69), 'while': (False, 69), 'NAME': (False, 69), 'repeat': (False, 69), 'for': (False, 69), 'until': (False, 69), 'local': (False, 69), 'return': (False, 69), ';': (False, 69), '(': (False, 69), 'goto': (False, 69)}, {'.': (False, 23), '..': (False, 23), '~=': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '<': (False, 23), '^': (False, 23), '+': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), 'and': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), ')': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), ';': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), ',': (False, 62), '?>': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1121), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1375), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1378), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1382), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1387), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1390), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1395), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1398), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1403), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1407), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1412), 'true': (True, 221), 'STRING': (True, 220)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1416), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1419), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1420), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1426), 'true': (True, 221), 'STRING': (True, 220)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 1430), 'true': (True, 221), 'STRING': (True, 220)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 1082), '~=': (False, 56), '*': (False, 56), ';': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '?>': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'.': (False, 22), '::': (False, 22), 'break': (False, 22), '(': (False, 22), '{': (False, 22), 'if': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'do': (False, 22), 'while': (False, 22), 'NAME': (False, 22), 'repeat': (False, 22), 'STRING': (False, 22), ':': (False, 22), 'for': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), ';': (False, 22), '?>': (False, 22), 'goto': (False, 22)}, {')': (True, 2013)}, {'NAME': (True, 2016)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), ',': (False, 25), '==': (False, 25), '{': (False, 25), '>': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '/': (False, 25), '[': (False, 25), '<': (False, 25), ';': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '?>': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2018)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2020), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2022), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), ',': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '(': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '>': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '?>': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), ',': (False, 24), '==': (False, 24), '{': (False, 24), '>': (False, 24), '(': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '/': (False, 24), '[': (False, 24), 'and': (False, 24), ';': (False, 24), '?>': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 2029), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 1082), '~=': (False, 57), '*': (False, 57), ';': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), ',': (False, 57), '?>': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1376), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1374), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1380), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1383), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1385), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1388), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1391), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1393), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {';': (False, 90), '?>': (False, 90)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1399), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1401), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1404), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1406), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1409), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1413), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1415), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'-': (True, 749), 'false': (True, 750), 'functiondef': (True, 751), 'exp': (True, 1418), 'functioncall': (True, 745), 'var': (True, 753), 'tableconstructor': (True, 741), 'EMBEDEXPR': (True, 742), '{': (True, 755), 'function': (True, 743), '#': (True, 744), 'nil': (True, 756), 'STRING': (True, 748), 'true': (True, 747), '(': (True, 758), 'not': (True, 759), 'prefixexp': (True, 746), 'NAME': (True, 757), '...': (True, 761), 'NUMBER': (True, 762)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), ',': (False, 86), '/': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), 'NAME': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), '}': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), '>': (False, 86), ';': (False, 86), '<=': (False, 86)}, {'}': (True, 1576)}, {'stat__1': (True, 1758), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {'args': (True, 1796), '{': (True, 358), 'tableconstructor': (True, 360), '(': (True, 357), 'STRING': (True, 355)}, {'-': (True, 401), ')': (True, 1875), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {')': (True, 2044)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 1082), '~=': (False, 55), '*': (False, 55), ';': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '?>': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1284), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'..': (False, 31), '::': (False, 31), '+': (False, 31), 'break': (False, 31), '==': (False, 31), 'if': (False, 31), '^': (False, 31), 'function': (False, 31), '~=': (False, 31), '*': (False, 31), 'do': (False, 31), 'while': (False, 31), '/': (False, 31), 'repeat': (False, 31), '-': (False, 31), 'EMBEDSTAT': (False, 31), 'or': (False, 31), 'until': (False, 31), '>': (False, 31), 'local': (False, 31), 'return': (False, 31), 'and': (False, 31), '<': (False, 31), 'NAME': (False, 31), ';': (False, 31), '(': (False, 31), 'for': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), '==': (False, 37), 'if': (False, 37), '^': (False, 37), 'local': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '+': (False, 37), '*': (False, 37), 'do': (False, 37), 'while': (False, 37), 'NAME': (False, 37), 'repeat': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'until': (False, 37), '/': (False, 37), '>': (False, 37), 'return': (False, 37), 'and': (False, 37), ';': (False, 37), '(': (False, 37), 'for': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), 'tableconstructor': (True, 1300), 'if': (False, 38), '^': (False, 38), 'args': (True, 1299), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'until': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1301), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1297), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1294), '+': (False, 38), '==': (False, 38), '{': (True, 1298), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1295), ':': (True, 1296), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '+': (False, 39), 'break': (False, 39), '==': (False, 39), 'if': (False, 39), '<': (False, 39), '^': (False, 39), 'function': (False, 39), '~=': (False, 39), '*': (False, 39), 'do': (False, 39), 'while': (False, 39), '/': (False, 39), 'goto': (False, 39), '-': (False, 39), 'EMBEDSTAT': (False, 39), 'or': (False, 39), 'until': (False, 39), '>': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), ';': (False, 39), '(': (False, 39), 'for': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1304), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'until': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), 'NAME': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1307), '(': (True, 1308)}, {'..': (False, 35), '::': (False, 35), '+': (False, 35), 'break': (False, 35), '==': (False, 35), 'if': (False, 35), '^': (False, 35), 'function': (False, 35), '~=': (False, 35), '*': (False, 35), 'do': (False, 35), 'while': (False, 35), 'and': (False, 35), 'NAME': (False, 35), 'repeat': (False, 35), '-': (False, 35), 'EMBEDSTAT': (False, 35), 'for': (False, 35), 'until': (False, 35), '/': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), ';': (False, 35), '(': (False, 35), 'or': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1318), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '+': (False, 33), 'break': (False, 33), '==': (False, 33), 'if': (False, 33), 'local': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '~=': (False, 33), '*': (False, 33), 'do': (False, 33), 'while': (False, 33), ';': (False, 33), 'repeat': (False, 33), '-': (False, 33), '^': (False, 33), 'for': (False, 33), 'until': (False, 33), '/': (False, 33), '>': (False, 33), 'return': (False, 33), 'and': (False, 33), '<': (False, 33), 'NAME': (False, 33), '(': (False, 33), 'or': (False, 33), '>=': (False, 33), '%': (False, 33), 'goto': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), '==': (False, 30), 'if': (False, 30), '<': (False, 30), '^': (False, 30), 'function': (False, 30), '+': (False, 30), '*': (False, 30), 'do': (False, 30), 'while': (False, 30), ';': (False, 30), '/': (False, 30), 'repeat': (False, 30), '-': (False, 30), 'EMBEDSTAT': (False, 30), 'or': (False, 30), 'until': (False, 30), '>': (False, 30), 'local': (False, 30), 'return': (False, 30), 'and': (False, 30), 'NAME': (False, 30), '(': (False, 30), 'for': (False, 30), '>=': (False, 30), '%': (False, 30), 'goto': (False, 30), '<=': (False, 30)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1324), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), 'if': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'until': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '/': (False, 84), '>': (False, 84), 'NAME': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), '==': (False, 36), 'if': (False, 36), '^': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '+': (False, 36), '*': (False, 36), 'do': (False, 36), 'while': (False, 36), ';': (False, 36), 'goto': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'until': (False, 36), '/': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), 'NAME': (False, 36), '(': (False, 36), 'for': (False, 36), '>=': (False, 36), '%': (False, 36), 'repeat': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'until': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1328), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'..': (True, 1351), '::': (False, 71), '+': (True, 1353), 'break': (False, 71), '==': (True, 1354), '>': (True, 1357), '^': (True, 1358), 'function': (False, 71), '~=': (True, 1360), 'EMBEDSTAT': (False, 71), '*': (True, 1361), 'do': (False, 71), 'while': (False, 71), ';': (False, 71), 'if': (False, 71), 'goto': (False, 71), '-': (True, 1352), 'and': (True, 1356), 'or': (True, 1362), 'until': (False, 71), '/': (True, 1355), 'local': (False, 71), 'return': (False, 71), '<': (True, 1359), 'NAME': (False, 71), '(': (False, 71), 'for': (False, 71), '>=': (True, 1363), '%': (True, 1364), 'repeat': (False, 71), '<=': (True, 1365)}, {'..': (False, 32), '::': (False, 32), '+': (False, 32), 'break': (False, 32), '==': (False, 32), 'if': (False, 32), '^': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '~=': (False, 32), '*': (False, 32), 'do': (False, 32), 'while': (False, 32), ';': (False, 32), '/': (False, 32), 'repeat': (False, 32), '-': (False, 32), '<': (False, 32), 'for': (False, 32), 'until': (False, 32), '>': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), 'or': (False, 32), '>=': (False, 32), '%': (False, 32), 'goto': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '+': (False, 34), 'break': (False, 34), '==': (False, 34), 'if': (False, 34), 'local': (False, 34), '^': (False, 34), 'function': (False, 34), '~=': (False, 34), '*': (False, 34), 'do': (False, 34), 'while': (False, 34), ';': (False, 34), 'goto': (False, 34), '-': (False, 34), 'EMBEDSTAT': (False, 34), 'or': (False, 34), 'until': (False, 34), '/': (False, 34), '>': (False, 34), 'return': (False, 34), 'and': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'for': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '<=': (False, 34)}, {'}': (True, 1816)}, {'?>': (False, 108)}, {'?>': (False, 88)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 1134), '~=': (False, 57), '*': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {')': (True, 1545)}, {'..': (True, 231), '+': (True, 233), '==': (False, 48), '>': (False, 48), '^': (True, 239), '~=': (False, 48), '*': (True, 242), ';': (False, 48), '}': (False, 48), '-': (True, 232), 'and': (False, 48), 'or': (False, 48), '/': (True, 237), '<': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 244), '<=': (False, 48)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 1934), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 239), '+': (False, 50), '*': (True, 242), ';': (False, 50), '}': (False, 50), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 237), '<': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 244), '<=': (False, 50)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1377), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1379), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1381), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 1384), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1389), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1392), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1394), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1396), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1397), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1400), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1402), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1405), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1408), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1410), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1414), 'true': (True, 487), 'STRING': (True, 486)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1417), 'true': (True, 487), 'STRING': (True, 486)}, {'..': (False, 49), '~=': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 239), '+': (False, 49), '*': (True, 242), ';': (False, 49), '}': (False, 49), '-': (False, 49), '<': (False, 49), 'or': (False, 49), '/': (True, 237), 'and': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 244), '<=': (False, 49)}, {'..': (True, 231), '+': (True, 233), '==': (False, 47), '>': (False, 47), '^': (True, 239), '~=': (False, 47), '*': (True, 242), ';': (False, 47), '}': (False, 47), '-': (True, 232), 'and': (False, 47), 'or': (False, 47), '/': (True, 237), '<': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 244), '<=': (False, 47)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), ',': (False, 40), '==': (True, 234), '/': (True, 237), '<': (True, 240), '>': (True, 238), 'and': (True, 236), '^': (True, 239), '~=': (True, 241), '*': (True, 242), 'or': (False, 40), '>=': (True, 243), '%': (True, 244), ';': (False, 40), '}': (False, 40), '<=': (True, 245)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), ',': (False, 57), 'if': (False, 57), '^': (True, 1195), 'while': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'until': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), '*': (False, 57), 'do': (False, 57), 'repeat': (False, 57), 'for': (False, 57), '/': (False, 57), '>': (False, 57), ';': (False, 57), '<=': (False, 57)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), ',': (False, 41), '==': (True, 234), '/': (True, 237), '<': (True, 240), '>': (True, 238), 'and': (False, 41), '^': (True, 239), '~=': (True, 241), '*': (True, 242), 'or': (False, 41), '>=': (True, 243), '%': (True, 244), ';': (False, 41), '}': (False, 41), '<=': (True, 245)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1439), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 239), '+': (False, 52), '*': (False, 52), ';': (False, 52), '}': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'..': (True, 231), '+': (True, 233), '==': (False, 43), '>': (False, 43), '^': (True, 239), '~=': (False, 43), '*': (True, 242), ';': (False, 43), '}': (False, 43), '-': (True, 232), 'and': (False, 43), 'or': (False, 43), '/': (True, 237), '<': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 244), '<=': (False, 43)}, {'NAME': (True, 1256)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), ',': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'until': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1257)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1258), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1259), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), ',': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'until': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), 'NAME': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), ';': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '/': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'until': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '>': (False, 24), ';': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 1261), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'}': (True, 1722)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '<': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), 'and': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), ')': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 239), '~=': (False, 54), '*': (False, 54), ';': (False, 54), '}': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (True, 231), '+': (True, 233), '==': (False, 42), '>': (False, 42), '^': (True, 239), '~=': (False, 42), '*': (True, 242), ';': (False, 42), '}': (False, 42), '-': (True, 232), 'and': (False, 42), 'or': (False, 42), '/': (True, 237), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 244), '<=': (False, 42)}, {'-': (True, 401), ')': (True, 1855), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 1134), '~=': (False, 56), '*': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'..': (True, 231), '+': (True, 233), '==': (False, 46), '>': (False, 46), '^': (True, 239), '~=': (False, 46), '*': (True, 242), ';': (False, 46), '}': (False, 46), '-': (True, 232), '<': (False, 46), 'or': (False, 46), '/': (True, 237), 'and': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 244), '<=': (False, 46)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 239), '~=': (False, 51), '*': (False, 51), ';': (False, 51), '}': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), ',': (False, 62), 'if': (False, 62), '^': (False, 62), 'while': (False, 62), '/': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'until': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'repeat': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '*': (False, 62), 'do': (False, 62), 'goto': (False, 62), 'for': (False, 62), '>': (False, 62), ';': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1853), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (True, 231), '+': (True, 233), '==': (False, 45), '>': (False, 45), '^': (True, 239), '~=': (False, 45), '*': (True, 242), ';': (False, 45), '}': (False, 45), '-': (True, 232), '<': (False, 45), 'or': (False, 45), '/': (True, 237), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 244), '<=': (False, 45)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 239), '~=': (False, 53), '*': (False, 53), ';': (False, 53), '}': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'-': (True, 401), ')': (True, 1411), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (True, 231), '+': (True, 233), '==': (False, 44), '>': (False, 44), '^': (True, 239), '~=': (False, 44), '*': (True, 242), ';': (False, 44), '}': (False, 44), '-': (True, 232), '<': (False, 44), 'or': (False, 44), '/': (True, 237), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 244), '<=': (False, 44)}, {'}': (True, 1212)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 1134), '~=': (False, 55), '*': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'NAME': (True, 1219)}, {'.': (False, 25), '..': (False, 25), '~=': (False, 25), '==': (False, 25), '{': (False, 25), '>': (False, 25), '^': (False, 25), '+': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '/': (False, 25), '[': (False, 25), '<': (False, 25), ',': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1220)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1719), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '..': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), '>': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '/': (False, 21), '[': (False, 21), 'and': (False, 21), ',': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1720), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 1721), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), ',': (False, 56), 'if': (False, 56), '^': (True, 1195), 'while': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'until': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), 'NAME': (False, 56), '(': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), '*': (False, 56), 'do': (False, 56), 'goto': (False, 56), 'for': (False, 56), '/': (False, 56), '>': (False, 56), ';': (False, 56), '<=': (False, 56)}, {'..': (False, 57), '~=': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 925), '+': (False, 57), '*': (False, 57), 'do': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'}': (False, 19)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 1195), 'while': (False, 55), '-': (False, 55), '<': (False, 55), 'or': (False, 55), 'until': (False, 55), 'local': (False, 55), 'return': (False, 55), 'and': (False, 55), ',': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), '*': (False, 55), 'do': (False, 55), ';': (False, 55), 'goto': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'NAME': (False, 55), '<=': (False, 55)}, {'.': (False, 13), ':': (False, 13), '(': (False, 13), '{': (False, 13), '[': (False, 13), 'STRING': (False, 13)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1566), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1565), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1567), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1568), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1569), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'::': (False, 90), 'break': (False, 90), 'if': (False, 90), 'EMBEDSTAT': (False, 90), 'function': (False, 90), 'do': (False, 90), 'while': (False, 90), ';': (False, 90), 'goto': (False, 90), 'for': (False, 90), 'until': (False, 90), 'local': (False, 90), 'return': (False, 90), 'NAME': (False, 90), '(': (False, 90), 'repeat': (False, 90)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1570), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1572), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1573), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1574), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1575), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1577), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1578), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1579), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1580), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1583), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'-': (True, 807), 'false': (True, 808), 'functiondef': (True, 809), 'exp': (True, 1584), 'functioncall': (True, 823), 'var': (True, 813), 'tableconstructor': (True, 811), 'EMBEDEXPR': (True, 815), '{': (True, 817), 'function': (True, 814), '#': (True, 820), 'nil': (True, 819), 'STRING': (True, 827), 'true': (True, 826), '(': (True, 812), 'not': (True, 824), 'prefixexp': (True, 810), 'NAME': (True, 821), '...': (True, 822), 'NUMBER': (True, 818)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1617), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {')': (True, 1309)}, {'args': (True, 1320), '{': (True, 255), 'tableconstructor': (True, 253), '(': (True, 252), 'STRING': (True, 256)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), '-': (False, 6), ')': (False, 6), 'or': (False, 6), '/': (False, 6), 'and': (False, 6), '<': (False, 6), ',': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {'}': (True, 1951)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), 'do': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2006), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'}': (True, 2067)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'until': (False, 9), 'local': (False, 9), 'return': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'goto': (False, 9), '+': (False, 9), '==': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'repeat': (False, 9), 'for': (False, 9), '/': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'-': (True, 326), 'false': (True, 327), 'functiondef': (True, 328), 'explist': (True, 2075), 'functioncall': (True, 342), 'var': (True, 332), 'tableconstructor': (True, 330), 'EMBEDEXPR': (True, 334), 'exp': (True, 344), '{': (True, 336), 'function': (True, 333), '#': (True, 339), 'nil': (True, 338), 'STRING': (True, 346), 'true': (True, 345), '(': (True, 331), 'not': (True, 343), 'prefixexp': (True, 329), 'NAME': (True, 340), '...': (True, 341), 'NUMBER': (True, 337)}, {'::': (False, 77), 'break': (False, 77), 'if': (False, 77), 'EMBEDSTAT': (False, 77), 'function': (False, 77), 'do': (False, 77), 'while': (False, 77), '}': (False, 77), 'goto': (False, 77), 'for': (False, 77), 'NAME': (False, 77), 'local': (False, 77), 'return': (False, 77), ';': (False, 77), '(': (False, 77), 'repeat': (False, 77)}, {'::': (False, 10), 'break': (False, 10), 'if': (False, 10), 'EMBEDSTAT': (False, 10), 'function': (False, 10), 'do': (False, 10), 'while': (False, 10), ';': (False, 10), '}': (False, 10), 'goto': (False, 10), 'for': (False, 10), '=': (False, 10), 'local': (False, 10), 'return': (False, 10), 'NAME': (False, 10), '(': (False, 10), 'repeat': (False, 10)}, {'NAME': (True, 2080)}, {'..': (False, 56), '~=': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 925), '+': (False, 56), '*': (False, 56), 'do': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'funcbody': (True, 1666), '(': (True, 930)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), '[': (False, 86), 'and': (False, 86), ',': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'args': (True, 1674), '{': (True, 1180), 'tableconstructor': (True, 1178), '(': (True, 1177), 'STRING': (True, 1175)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1676), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), ',': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), '}': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 1303), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'local': (False, 31), 'return': (False, 31), '>': (False, 31), '<': (False, 31), ',': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '*': (False, 31), 'do': (False, 31), ';': (False, 31), 'repeat': (False, 31), 'end': (False, 31), 'for': (False, 31), '/': (False, 31), 'elseif': (False, 31), 'NAME': (False, 31), 'else': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), ',': (False, 37), '/': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), 'if': (False, 37), '>=': (False, 37), '%': (False, 37), 'repeat': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '*': (False, 37), 'do': (False, 37), 'goto': (False, 37), 'end': (False, 37), 'for': (False, 37), '>': (False, 37), 'elseif': (False, 37), ';': (False, 37), 'else': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), ',': (False, 38), 'tableconstructor': (True, 1314), 'if': (False, 38), 'elseif': (False, 38), '^': (False, 38), 'args': (True, 1315), 'while': (False, 38), '/': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1317), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1313), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1310), '+': (False, 38), '==': (False, 38), '{': (True, 1316), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1311), ':': (True, 1312), 'for': (False, 38), 'end': (False, 38), '>': (False, 38), ';': (False, 38), 'else': (False, 38), '<=': (False, 38)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1319), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'end': (False, 11), 'while': (False, 11), '/': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), ';': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '>': (False, 11), 'elseif': (False, 11), 'NAME': (False, 11), 'else': (False, 11), '<=': (False, 11)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1322), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), ',': (False, 35), 'end': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'repeat': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), '*': (False, 35), 'do': (False, 35), 'goto': (False, 35), 'for': (False, 35), '/': (False, 35), 'elseif': (False, 35), ';': (False, 35), 'else': (False, 35), '<=': (False, 35)}, {'::': (False, 64), 'break': (False, 64), 'if': (False, 64), 'elseif': (False, 64), 'EMBEDSTAT': (False, 64), 'function': (False, 64), 'do': (False, 64), 'while': (False, 64), ';': (False, 64), 'repeat': (False, 64), 'for': (False, 64), 'end': (False, 64), 'local': (False, 64), 'return': (False, 64), 'NAME': (False, 64), '(': (False, 64), 'goto': (False, 64), 'else': (False, 64)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), ',': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '/': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), 'local': (False, 39), 'return': (False, 39), '<': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), '*': (False, 39), 'do': (False, 39), 'goto': (False, 39), 'end': (False, 39), 'for': (False, 39), '>': (False, 39), 'elseif': (False, 39), ';': (False, 39), 'else': (False, 39), '<=': (False, 39)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), ',': (False, 30), 'if': (False, 30), '^': (False, 30), 'while': (False, 30), '/': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), 'local': (False, 30), 'return': (False, 30), '<': (False, 30), 'NAME': (False, 30), '(': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), '*': (False, 30), 'do': (False, 30), 'goto': (False, 30), 'end': (False, 30), 'for': (False, 30), '>': (False, 30), 'elseif': (False, 30), ';': (False, 30), 'else': (False, 30), '<=': (False, 30)}, {'funcbody': (True, 1326), '(': (True, 1327)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 1350), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), ',': (False, 84), '/': (False, 84), '^': (False, 84), 'end': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), 'elseif': (False, 84), ';': (False, 84), 'else': (False, 84), '<=': (False, 84)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), ',': (False, 34), '/': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), '<': (False, 34), 'or': (False, 34), 'local': (False, 34), 'return': (False, 34), 'and': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'if': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '*': (False, 34), 'do': (False, 34), 'goto': (False, 34), 'end': (False, 34), 'for': (False, 34), '>': (False, 34), 'elseif': (False, 34), ';': (False, 34), 'else': (False, 34), '<=': (False, 34)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), ',': (False, 32), 'if': (False, 32), '^': (False, 32), 'while': (False, 32), '/': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '*': (False, 32), 'do': (False, 32), 'goto': (False, 32), 'end': (False, 32), 'for': (False, 32), '>': (False, 32), 'elseif': (False, 32), ';': (False, 32), 'else': (False, 32), '<=': (False, 32)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), ',': (False, 12), 'if': (False, 12), '^': (False, 12), 'end': (False, 12), 'while': (False, 12), '[': (False, 12), '-': (False, 12), 'and': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '>': (False, 12), '<': (False, 12), 'NAME': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), 'elseif': (False, 12), ';': (False, 12), 'else': (False, 12), '<=': (False, 12)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 1508), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'..': (True, 1527), '::': (False, 93), '~=': (True, 1529), 'break': (False, 93), '/': (True, 1541), '^': (True, 1367), 'while': (False, 93), '-': (True, 1535), 'and': (True, 1528), 'or': (True, 1538), 'explist__1': (True, 1534), 'local': (False, 93), 'return': (False, 93), '<': (True, 1533), ',': (True, 1530), '(': (False, 93), 'if': (False, 93), '>=': (True, 1539), '%': (True, 1540), 'repeat': (False, 93), '+': (True, 1536), '==': (True, 1531), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 1537), 'do': (False, 93), 'NAME': (False, 93), 'goto': (False, 93), 'end': (False, 93), 'for': (False, 93), '>': (True, 1532), 'elseif': (False, 93), ';': (False, 93), 'else': (False, 93), '<=': (True, 1542)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), '/': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '*': (False, 36), 'do': (False, 36), 'NAME': (False, 36), 'repeat': (False, 36), 'for': (False, 36), 'end': (False, 36), 'elseif': (False, 36), ';': (False, 36), 'else': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), 'elseif': (False, 33), '^': (False, 33), 'while': (False, 33), '/': (False, 33), '-': (False, 33), '<': (False, 33), 'or': (False, 33), 'local': (False, 33), 'return': (False, 33), 'and': (False, 33), ',': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'repeat': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '*': (False, 33), 'do': (False, 33), ';': (False, 33), 'goto': (False, 33), 'for': (False, 33), 'end': (False, 33), '>': (False, 33), 'NAME': (False, 33), 'else': (False, 33), '<=': (False, 33)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1544), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'::': (False, 75), 'break': (False, 75), 'if': (False, 75), 'elseif': (False, 75), 'EMBEDSTAT': (False, 75), 'function': (False, 75), 'do': (False, 75), 'while': (False, 75), 'NAME': (False, 75), 'goto': (False, 75), 'for': (False, 75), 'end': (False, 75), 'local': (False, 75), 'return': (False, 75), ';': (False, 75), '(': (False, 75), 'repeat': (False, 75), 'else': (False, 75)}, {')': (False, 97), 'funcbody__1': (True, 2069), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '>': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'and': (False, 22), 'STRING': (False, 22), '-': (False, 22), ')': (False, 22), ':': (False, 22), 'or': (False, 22), '/': (False, 22), '[': (False, 22), '<': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'=': (False, 15)}, {'NAME': (True, 1748)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'STRING': (True, 76), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'args__1': (True, 1746), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), ':': (False, 24), '(': (False, 24), '{': (False, 24), '[': (False, 24), 'STRING': (False, 24)}, {'.': (False, 21), ':': (False, 21), '(': (False, 21), '{': (False, 21), 'STRING': (False, 21), '[': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1753), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 25), ':': (False, 25), '(': (False, 25), '{': (False, 25), '[': (False, 25), 'STRING': (False, 25)}, {'::': (False, 69), 'break': (False, 69), '?>': (False, 69), 'if': (False, 69), 'EMBEDSTAT': (False, 69), 'function': (False, 69), 'do': (False, 69), 'while': (False, 69), 'NAME': (False, 69), 'repeat': (False, 69), 'for': (False, 69), 'local': (False, 69), 'return': (False, 69), ';': (False, 69), '(': (False, 69), 'goto': (False, 69)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), ',': (False, 86), '>': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'until': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), 'NAME': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), '/': (False, 86), ';': (False, 86), '<=': (False, 86)}, {'args': (True, 1963), '{': (True, 1154), 'tableconstructor': (True, 1156), '(': (True, 1153), 'STRING': (True, 1151)}, {')': (True, 1775)}, {'}': (True, 1945)}, {'stat__1': (True, 2141), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2045), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'.': (False, 9), '..': (False, 9), '~=': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '<': (False, 9), '^': (False, 9), '+': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), ')': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 1653), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'..': (False, 31), '::': (False, 31), '+': (False, 31), 'break': (False, 31), '==': (False, 31), 'if': (False, 31), 'local': (False, 31), '^': (False, 31), 'function': (False, 31), '~=': (False, 31), '*': (False, 31), 'do': (False, 31), 'while': (False, 31), '/': (False, 31), 'repeat': (False, 31), '-': (False, 31), 'EMBEDSTAT': (False, 31), 'or': (False, 31), 'end': (False, 31), '>': (False, 31), 'return': (False, 31), 'and': (False, 31), '<': (False, 31), 'NAME': (False, 31), ';': (False, 31), '(': (False, 31), 'for': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), '==': (False, 37), 'if': (False, 37), '^': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '+': (False, 37), '*': (False, 37), 'do': (False, 37), 'while': (False, 37), 'NAME': (False, 37), 'repeat': (False, 37), '-': (False, 37), '<': (False, 37), 'end': (False, 37), 'or': (False, 37), '/': (False, 37), '>': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), ';': (False, 37), '(': (False, 37), 'for': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), 'tableconstructor': (True, 1664), 'if': (False, 38), '^': (False, 38), 'end': (False, 38), 'args': (True, 1663), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1665), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1661), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1658), '+': (False, 38), '==': (False, 38), '{': (True, 1662), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1659), ':': (True, 1660), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '+': (False, 39), 'break': (False, 39), '==': (False, 39), 'if': (False, 39), '<': (False, 39), '^': (False, 39), 'function': (False, 39), '~=': (False, 39), '*': (False, 39), 'do': (False, 39), 'while': (False, 39), '/': (False, 39), 'goto': (False, 39), '-': (False, 39), 'EMBEDSTAT': (False, 39), 'end': (False, 39), 'or': (False, 39), '>': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), ';': (False, 39), '(': (False, 39), 'for': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1667), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'end': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), 'NAME': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1671), '(': (True, 1672)}, {'..': (False, 35), '::': (False, 35), '+': (False, 35), 'break': (False, 35), '==': (False, 35), 'if': (False, 35), '^': (False, 35), 'function': (False, 35), '~=': (False, 35), '*': (False, 35), 'do': (False, 35), 'while': (False, 35), 'and': (False, 35), '/': (False, 35), 'repeat': (False, 35), '-': (False, 35), 'EMBEDSTAT': (False, 35), 'for': (False, 35), 'end': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), 'NAME': (False, 35), ';': (False, 35), '(': (False, 35), 'or': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1675), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '+': (False, 33), 'break': (False, 33), '==': (False, 33), 'if': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '~=': (False, 33), '*': (False, 33), 'do': (False, 33), 'while': (False, 33), 'and': (False, 33), ';': (False, 33), 'repeat': (False, 33), '-': (False, 33), '^': (False, 33), 'end': (False, 33), 'for': (False, 33), '/': (False, 33), 'local': (False, 33), 'return': (False, 33), '>': (False, 33), '<': (False, 33), 'NAME': (False, 33), '(': (False, 33), 'or': (False, 33), '>=': (False, 33), '%': (False, 33), 'goto': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), '==': (False, 30), 'if': (False, 30), '<': (False, 30), '^': (False, 30), 'function': (False, 30), '+': (False, 30), '*': (False, 30), 'do': (False, 30), 'while': (False, 30), ';': (False, 30), '/': (False, 30), 'repeat': (False, 30), '-': (False, 30), 'EMBEDSTAT': (False, 30), 'end': (False, 30), 'or': (False, 30), '>': (False, 30), 'local': (False, 30), 'return': (False, 30), 'and': (False, 30), 'NAME': (False, 30), '(': (False, 30), 'for': (False, 30), '>=': (False, 30), '%': (False, 30), 'goto': (False, 30), '<=': (False, 30)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 1698), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), '/': (False, 84), '^': (False, 84), 'end': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), 'NAME': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), '==': (False, 36), 'if': (False, 36), '^': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '+': (False, 36), '*': (False, 36), 'do': (False, 36), 'while': (False, 36), ';': (False, 36), 'goto': (False, 36), '-': (False, 36), '<': (False, 36), 'end': (False, 36), 'or': (False, 36), '/': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), 'NAME': (False, 36), '(': (False, 36), 'for': (False, 36), '>=': (False, 36), '%': (False, 36), 'repeat': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'end': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 1701), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'..': (True, 1703), '::': (False, 71), '+': (True, 1705), 'break': (False, 71), '==': (True, 1706), '>': (True, 1709), '^': (True, 1710), 'function': (False, 71), '~=': (True, 1712), 'EMBEDSTAT': (False, 71), '*': (True, 1713), 'do': (False, 71), 'while': (False, 71), ';': (False, 71), 'if': (False, 71), 'goto': (False, 71), '-': (True, 1704), 'and': (True, 1708), 'end': (False, 71), 'or': (True, 1714), '/': (True, 1707), 'local': (False, 71), 'return': (False, 71), '<': (True, 1711), 'NAME': (False, 71), '(': (False, 71), 'for': (False, 71), '>=': (True, 1715), '%': (True, 1716), 'repeat': (False, 71), '<=': (True, 1717)}, {'..': (False, 32), '::': (False, 32), '+': (False, 32), 'break': (False, 32), '==': (False, 32), 'if': (False, 32), '^': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '~=': (False, 32), '*': (False, 32), 'do': (False, 32), 'while': (False, 32), 'NAME': (False, 32), 'repeat': (False, 32), '-': (False, 32), '<': (False, 32), 'end': (False, 32), 'for': (False, 32), '/': (False, 32), '>': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), ';': (False, 32), '(': (False, 32), 'or': (False, 32), '>=': (False, 32), '%': (False, 32), 'goto': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '+': (False, 34), 'break': (False, 34), '==': (False, 34), 'if': (False, 34), 'local': (False, 34), '^': (False, 34), 'function': (False, 34), '~=': (False, 34), '*': (False, 34), 'do': (False, 34), 'while': (False, 34), ';': (False, 34), '/': (False, 34), 'goto': (False, 34), '-': (False, 34), 'EMBEDSTAT': (False, 34), 'or': (False, 34), 'end': (False, 34), '>': (False, 34), 'return': (False, 34), 'and': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'for': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '<=': (False, 34)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), '==': (False, 57), 'if': (False, 57), '<': (False, 57), '^': (True, 1520), 'function': (False, 57), '+': (False, 57), '*': (False, 57), 'do': (False, 57), 'while': (False, 57), '}': (False, 57), 'repeat': (False, 57), '-': (False, 57), 'EMBEDSTAT': (False, 57), 'for': (False, 57), '/': (False, 57), '>': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), ';': (False, 57), '(': (False, 57), 'or': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '<=': (False, 57)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), '==': (False, 57), 'if': (False, 57), '<': (False, 57), '^': (True, 1358), 'function': (False, 57), '+': (False, 57), '*': (False, 57), 'do': (False, 57), 'while': (False, 57), '/': (False, 57), 'repeat': (False, 57), '-': (False, 57), 'EMBEDSTAT': (False, 57), 'for': (False, 57), 'until': (False, 57), '>': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), ';': (False, 57), '(': (False, 57), 'or': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '<=': (False, 57)}, {'NAME': (True, 1498)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), '}': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1499)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1500), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1501), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), 'NAME': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), '}': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), ';': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), 'NAME': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), '}': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), ';': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 1502), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1543), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'NAME': (True, 1618)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'until': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 1621)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1622), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1623), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'until': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), 'NAME': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'until': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), 'NAME': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), ';': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 1641), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'-': (True, 401), ')': (True, 2037), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), 'if': (False, 57), '^': (True, 1367), 'while': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'local': (False, 57), 'return': (False, 57), '>': (False, 57), 'and': (False, 57), ',': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), '*': (False, 57), 'do': (False, 57), 'NAME': (False, 57), 'repeat': (False, 57), 'end': (False, 57), 'for': (False, 57), '/': (False, 57), 'elseif': (False, 57), ';': (False, 57), 'else': (False, 57), '<=': (False, 57)}, {'-': (True, 401), ')': (True, 2142), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 62), '::': (False, 62), '+': (False, 62), 'break': (False, 62), '==': (False, 62), 'if': (False, 62), '^': (False, 62), 'function': (False, 62), '~=': (False, 62), '*': (False, 62), 'do': (False, 62), 'while': (False, 62), '}': (False, 62), 'repeat': (False, 62), '-': (False, 62), 'EMBEDSTAT': (False, 62), 'or': (False, 62), '/': (False, 62), '>': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), '<': (False, 62), 'NAME': (False, 62), ';': (False, 62), '(': (False, 62), 'for': (False, 62), '>=': (False, 62), '%': (False, 62), 'goto': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2144), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 62), '::': (False, 62), '+': (False, 62), 'break': (False, 62), '==': (False, 62), 'if': (False, 62), '^': (False, 62), 'function': (False, 62), '~=': (False, 62), '*': (False, 62), 'do': (False, 62), 'while': (False, 62), ';': (False, 62), '/': (False, 62), 'repeat': (False, 62), '-': (False, 62), 'EMBEDSTAT': (False, 62), 'or': (False, 62), 'until': (False, 62), '>': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), '<': (False, 62), 'NAME': (False, 62), '(': (False, 62), 'for': (False, 62), '>=': (False, 62), '%': (False, 62), 'goto': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2146), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'.': (False, 23), '::': (False, 23), 'break': (False, 23), '{': (False, 23), 'if': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'repeat': (False, 23), 'do': (False, 23), 'while': (False, 23), '}': (False, 23), 'STRING': (False, 23), ':': (False, 23), 'for': (False, 23), 'NAME': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), ';': (False, 23), '(': (False, 23), 'goto': (False, 23)}, {'NAME': (True, 2150)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), ',': (False, 25), 'if': (False, 25), '^': (False, 25), 'end': (False, 25), 'while': (False, 25), '[': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '>': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), 'elseif': (False, 25), ';': (False, 25), 'else': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2151)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2152), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), 'elseif': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), '*': (False, 24), 'do': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), 'repeat': (False, 24), 'end': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), ':': (False, 24), ';': (False, 24), 'else': (False, 24), '<=': (False, 24)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), ',': (False, 21), 'if': (False, 21), '^': (False, 21), 'end': (False, 21), 'while': (False, 21), '[': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '>': (False, 21), 'and': (False, 21), 'NAME': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), 'repeat': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), 'elseif': (False, 21), ';': (False, 21), 'else': (False, 21), '<=': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2155), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2157), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'}': (True, 2041)}, {'-': (True, 401), ')': (True, 1876), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'.': (False, 22), '::': (False, 22), 'break': (False, 22), '{': (False, 22), 'if': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'do': (False, 22), 'while': (False, 22), ';': (False, 22), '}': (False, 22), 'repeat': (False, 22), 'STRING': (False, 22), ':': (False, 22), 'for': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), 'NAME': (False, 22), '(': (False, 22), 'goto': (False, 22)}, {'}': (True, 2095)}, {'}': (True, 1759)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), '-': (False, 9), 'and': (False, 9), ')': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '==': (False, 56), 'if': (False, 56), '^': (True, 1358), 'function': (False, 56), '+': (False, 56), '*': (False, 56), 'do': (False, 56), 'while': (False, 56), 'and': (False, 56), ';': (False, 56), 'repeat': (False, 56), '-': (False, 56), 'EMBEDSTAT': (False, 56), 'or': (False, 56), 'until': (False, 56), '/': (False, 56), 'local': (False, 56), 'return': (False, 56), '>': (False, 56), '<': (False, 56), 'NAME': (False, 56), '(': (False, 56), 'for': (False, 56), '>=': (False, 56), '%': (False, 56), 'goto': (False, 56), '<=': (False, 56)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '==': (False, 56), 'if': (False, 56), '^': (True, 1520), 'function': (False, 56), '+': (False, 56), '*': (False, 56), 'do': (False, 56), 'while': (False, 56), 'and': (False, 56), ';': (False, 56), '}': (False, 56), 'goto': (False, 56), '-': (False, 56), 'EMBEDSTAT': (False, 56), 'or': (False, 56), '/': (False, 56), 'local': (False, 56), 'return': (False, 56), '>': (False, 56), '<': (False, 56), 'NAME': (False, 56), '(': (False, 56), 'for': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '<=': (False, 56)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), ',': (False, 62), 'if': (False, 62), 'elseif': (False, 62), '^': (False, 62), 'while': (False, 62), '/': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'goto': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '*': (False, 62), 'do': (False, 62), 'repeat': (False, 62), 'for': (False, 62), 'end': (False, 62), '>': (False, 62), ';': (False, 62), 'else': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2043), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), '==': (False, 55), 'if': (False, 55), '<': (False, 55), 'local': (False, 55), '^': (True, 1358), 'function': (False, 55), '+': (False, 55), '*': (False, 55), 'do': (False, 55), 'while': (False, 55), ';': (False, 55), 'goto': (False, 55), '-': (False, 55), 'EMBEDSTAT': (False, 55), 'for': (False, 55), 'until': (False, 55), '/': (False, 55), '>': (False, 55), 'return': (False, 55), 'and': (False, 55), 'NAME': (False, 55), '(': (False, 55), 'or': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '<=': (False, 55)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 1837), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '/': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'local': (False, 31), 'return': (False, 31), '<': (False, 31), ',': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '*': (False, 31), 'do': (False, 31), ';': (False, 31), 'repeat': (False, 31), 'for': (False, 31), '>': (False, 31), 'NAME': (False, 31), '?>': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), ',': (False, 37), 'if': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '*': (False, 37), 'do': (False, 37), 'repeat': (False, 37), 'for': (False, 37), '/': (False, 37), '>': (False, 37), ';': (False, 37), '?>': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), ',': (False, 38), 'tableconstructor': (True, 1850), 'if': (False, 38), '^': (False, 38), 'args': (True, 1849), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1851), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1847), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1844), '+': (False, 38), '==': (False, 38), '{': (True, 1848), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1845), ':': (True, 1846), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '?>': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), ',': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '/': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), '*': (False, 39), 'do': (False, 39), 'goto': (False, 39), 'for': (False, 39), '>': (False, 39), ';': (False, 39), '?>': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1856), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '?>': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1860), '(': (True, 1861)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), ',': (False, 35), '/': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'local': (False, 35), 'return': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), '*': (False, 35), 'do': (False, 35), 'repeat': (False, 35), 'for': (False, 35), '>': (False, 35), ';': (False, 35), '?>': (False, 35), '<=': (False, 35)}, {'::': (False, 64), 'break': (False, 64), '?>': (False, 64), 'if': (False, 64), 'EMBEDSTAT': (False, 64), 'function': (False, 64), 'do': (False, 64), 'while': (False, 64), 'NAME': (False, 64), 'goto': (False, 64), 'for': (False, 64), 'local': (False, 64), 'return': (False, 64), ';': (False, 64), '(': (False, 64), 'repeat': (False, 64)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1866), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), '^': (False, 33), 'while': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'local': (False, 33), 'return': (False, 33), '<': (False, 33), ',': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'repeat': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '*': (False, 33), 'do': (False, 33), ';': (False, 33), 'goto': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), 'NAME': (False, 33), '?>': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), ',': (False, 30), 'if': (False, 30), '^': (False, 30), 'while': (False, 30), '/': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), 'local': (False, 30), 'return': (False, 30), 'and': (False, 30), 'NAME': (False, 30), '(': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), '*': (False, 30), 'do': (False, 30), 'goto': (False, 30), 'for': (False, 30), '>': (False, 30), ';': (False, 30), '?>': (False, 30), '<=': (False, 30)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 1870), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), ',': (False, 84), '/': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), ';': (False, 84), '?>': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'local': (False, 36), 'return': (False, 36), 'and': (False, 36), ',': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '*': (False, 36), 'do': (False, 36), 'NAME': (False, 36), 'repeat': (False, 36), 'for': (False, 36), '/': (False, 36), '>': (False, 36), ';': (False, 36), '?>': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), ';': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '?>': (False, 12), '<=': (False, 12)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 1877), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'..': (True, 1879), '::': (False, 93), '~=': (True, 1889), 'break': (False, 93), '/': (True, 1894), '^': (True, 1887), 'while': (False, 93), '-': (True, 1880), 'and': (True, 1885), 'or': (True, 1891), 'explist__1': (True, 1886), 'local': (False, 93), 'return': (False, 93), '<': (True, 1888), ',': (True, 1882), '(': (False, 93), 'if': (False, 93), '>=': (True, 1892), '%': (True, 1893), 'goto': (False, 93), '+': (True, 1881), '==': (True, 1883), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 1890), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '>': (True, 1884), 'NAME': (False, 93), '?>': (False, 93), '<=': (True, 1895)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), ',': (False, 32), 'if': (False, 32), '^': (False, 32), 'while': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '*': (False, 32), 'do': (False, 32), 'goto': (False, 32), 'for': (False, 32), '/': (False, 32), '>': (False, 32), ';': (False, 32), '?>': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), ',': (False, 34), '>': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'local': (False, 34), 'return': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'if': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '*': (False, 34), 'do': (False, 34), 'goto': (False, 34), 'for': (False, 34), '/': (False, 34), ';': (False, 34), '?>': (False, 34), '<=': (False, 34)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '/': (False, 56), '^': (True, 1367), 'while': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), ',': (False, 56), '(': (False, 56), 'if': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), '*': (False, 56), 'do': (False, 56), 'NAME': (False, 56), 'goto': (False, 56), 'end': (False, 56), 'for': (False, 56), '>': (False, 56), 'elseif': (False, 56), ';': (False, 56), 'else': (False, 56), '<=': (False, 56)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2176), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2177), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2178), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2179), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2181), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2183), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2188), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2190), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2193), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 2202), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1366), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1504), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1505), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1507), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'-': (True, 1097), 'false': (True, 1098), 'functiondef': (True, 1099), 'exp': (True, 1511), 'functioncall': (True, 1112), 'var': (True, 1103), 'tableconstructor': (True, 1101), 'EMBEDEXPR': (True, 1105), '{': (True, 1106), 'function': (True, 1104), '#': (True, 1109), 'nil': (True, 1108), 'STRING': (True, 1116), 'true': (True, 1115), '(': (True, 1102), 'not': (True, 1113), 'prefixexp': (True, 1100), 'NAME': (True, 1110), '...': (True, 1111), 'NUMBER': (True, 1107)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), '==': (False, 51), '/': (False, 51), '<': (False, 51), '^': (True, 1358), 'function': (False, 51), '+': (False, 51), '*': (False, 51), 'do': (False, 51), 'while': (False, 51), ';': (False, 51), 'if': (False, 51), 'goto': (False, 51), '-': (False, 51), 'EMBEDSTAT': (False, 51), 'or': (False, 51), 'until': (False, 51), '>': (False, 51), 'local': (False, 51), 'return': (False, 51), 'and': (False, 51), 'NAME': (False, 51), '(': (False, 51), 'for': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '<=': (False, 51)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2140), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'..': (True, 952), '::': (False, 40), '~=': (True, 962), 'break': (False, 40), ',': (False, 40), '>': (True, 957), '^': (True, 960), 'while': (False, 40), '-': (True, 953), 'and': (True, 958), 'or': (False, 40), 'local': (False, 40), 'return': (False, 40), '<': (True, 961), 'NAME': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 965), '%': (True, 966), 'goto': (False, 40), '+': (True, 954), '==': (True, 956), 'EMBEDSTAT': (False, 40), 'function': (False, 40), '*': (True, 963), 'do': (False, 40), 'repeat': (False, 40), 'end': (False, 40), 'for': (False, 40), '/': (True, 967), ';': (False, 40), '<=': (True, 968)}, {'.': (False, 23), '::': (False, 23), 'break': (False, 23), '{': (False, 23), 'if': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'repeat': (False, 23), 'do': (False, 23), 'while': (False, 23), 'NAME': (False, 23), 'STRING': (False, 23), ':': (False, 23), 'for': (False, 23), 'end': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), ';': (False, 23), '(': (False, 23), 'goto': (False, 23)}, {'..': (True, 952), '::': (False, 45), '~=': (False, 45), 'break': (False, 45), ',': (False, 45), 'if': (False, 45), '^': (True, 960), 'while': (False, 45), '-': (True, 953), '<': (False, 45), 'or': (False, 45), 'local': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), '>=': (False, 45), '%': (True, 966), 'goto': (False, 45), '+': (True, 954), '==': (False, 45), 'EMBEDSTAT': (False, 45), 'function': (False, 45), '*': (True, 963), 'do': (False, 45), 'repeat': (False, 45), 'end': (False, 45), 'for': (False, 45), '/': (True, 967), '>': (False, 45), ';': (False, 45), '<=': (False, 45)}, {'..': (False, 53), '::': (False, 53), '~=': (False, 53), 'break': (False, 53), 'if': (False, 53), '^': (True, 960), 'while': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), ',': (False, 53), '(': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '+': (False, 53), '==': (False, 53), 'EMBEDSTAT': (False, 53), 'function': (False, 53), '*': (False, 53), 'do': (False, 53), 'NAME': (False, 53), 'repeat': (False, 53), 'end': (False, 53), 'for': (False, 53), '/': (False, 53), '>': (False, 53), ';': (False, 53), '<=': (False, 53)}, {'..': (False, 52), '::': (False, 52), '~=': (False, 52), 'break': (False, 52), ',': (False, 52), 'if': (False, 52), '^': (True, 960), 'while': (False, 52), '/': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), 'local': (False, 52), 'return': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), '>=': (False, 52), '%': (False, 52), 'goto': (False, 52), '+': (False, 52), '==': (False, 52), 'EMBEDSTAT': (False, 52), 'function': (False, 52), '*': (False, 52), 'do': (False, 52), 'repeat': (False, 52), 'for': (False, 52), 'end': (False, 52), '>': (False, 52), ';': (False, 52), '<=': (False, 52)}, {'..': (True, 952), '::': (False, 44), '~=': (False, 44), 'break': (False, 44), ',': (False, 44), 'if': (False, 44), '^': (True, 960), 'while': (False, 44), '-': (True, 953), 'and': (False, 44), 'or': (False, 44), 'local': (False, 44), 'return': (False, 44), '<': (False, 44), 'NAME': (False, 44), '(': (False, 44), '>=': (False, 44), '%': (True, 966), 'repeat': (False, 44), '+': (True, 954), '==': (False, 44), 'EMBEDSTAT': (False, 44), 'function': (False, 44), '*': (True, 963), 'do': (False, 44), 'goto': (False, 44), 'end': (False, 44), 'for': (False, 44), '/': (True, 967), '>': (False, 44), ';': (False, 44), '<=': (False, 44)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 1082), '+': (False, 50), '*': (True, 1085), ';': (False, 50), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 1088), '<': (False, 50), ',': (False, 50), '?>': (False, 50), '>=': (False, 50), '%': (True, 1087), '<=': (False, 50)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 48), '>': (False, 48), '^': (True, 925), '~=': (False, 48), '*': (True, 1055), 'do': (False, 48), '-': (True, 1047), '<': (False, 48), 'or': (False, 48), '/': (True, 1059), 'and': (False, 48), '>=': (False, 48), '%': (True, 1058), '<=': (False, 48)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 48), '>': (False, 48), '^': (True, 1082), '~=': (False, 48), '*': (True, 1085), ';': (False, 48), '-': (True, 1074), '<': (False, 48), 'or': (False, 48), '/': (True, 1088), 'and': (False, 48), ',': (False, 48), '?>': (False, 48), '>=': (False, 48), '%': (True, 1087), '<=': (False, 48)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 48), '>': (False, 48), '^': (True, 1134), '~=': (False, 48), '*': (True, 1137), '-': (True, 1126), '<': (False, 48), 'or': (False, 48), '/': (True, 1132), 'and': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 1139), '<=': (False, 48)}, {'..': (False, 50), '+': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 925), '~=': (False, 50), '*': (True, 1055), 'do': (False, 50), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 1059), '<': (False, 50), '>=': (False, 50), '%': (True, 1058), '<=': (False, 50)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 1134), '+': (False, 50), '*': (True, 1137), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 1132), '<': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 1139), '<=': (False, 50)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 1082), '~=': (False, 49), '*': (True, 1085), ';': (False, 49), '-': (False, 49), '<': (False, 49), 'or': (False, 49), '/': (True, 1088), 'and': (False, 49), ',': (False, 49), '?>': (False, 49), '>=': (False, 49), '%': (True, 1087), '<=': (False, 49)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 1134), '~=': (False, 49), '*': (True, 1137), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), '/': (True, 1132), '<': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 1139), '<=': (False, 49)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 925), '~=': (False, 49), '*': (True, 1055), 'do': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), '/': (True, 1059), '<': (False, 49), '>=': (False, 49), '%': (True, 1058), '<=': (False, 49)}, {'..': (True, 1073), '-': (True, 1074), '+': (True, 1075), '?>': (False, 93), '==': (True, 1077), 'or': (True, 1078), '<': (True, 1083), '>': (True, 1080), 'explist__1': (True, 1874), 'and': (True, 1079), '^': (True, 1082), '>=': (True, 1086), ',': (True, 1076), '*': (True, 1085), '~=': (True, 1084), '%': (True, 1087), ';': (False, 93), '/': (True, 1088), '<=': (True, 1089)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 2063), 'stat__3': (True, 2064), '*': (True, 612), 'do': (False, 103), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 47), '>': (False, 47), '^': (True, 1082), '~=': (False, 47), '*': (True, 1085), ';': (False, 47), '-': (True, 1074), 'and': (False, 47), 'or': (False, 47), '/': (True, 1088), '<': (False, 47), ',': (False, 47), '?>': (False, 47), '>=': (False, 47), '%': (True, 1087), '<=': (False, 47)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 2242), ';': (False, 29), 'NAME': (False, 29), '=': (False, 29), 'goto': (False, 29), 'for': (False, 29), 'end': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 971), '(': (False, 29), 'repeat': (False, 29)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 47), '>': (False, 47), '^': (True, 925), '~=': (False, 47), '*': (True, 1055), 'do': (False, 47), '-': (True, 1047), 'and': (False, 47), 'or': (False, 47), '/': (True, 1059), '<': (False, 47), '>=': (False, 47), '%': (True, 1058), '<=': (False, 47)}, {'..': (True, 1073), '-': (True, 1074), ',': (False, 40), '+': (True, 1075), '?>': (False, 40), '==': (True, 1077), '/': (True, 1088), '<': (True, 1083), '>': (True, 1080), 'and': (True, 1079), '^': (True, 1082), '~=': (True, 1084), '*': (True, 1085), 'or': (False, 40), '>=': (True, 1086), '%': (True, 1087), ';': (False, 40), '<=': (True, 1089)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 47), '>': (False, 47), '^': (True, 1134), '~=': (False, 47), '*': (True, 1137), '-': (True, 1126), 'and': (False, 47), 'or': (False, 47), '/': (True, 1132), '<': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 1139), '<=': (False, 47)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), '/': (True, 1059), '<': (True, 1053), '>': (True, 1052), 'do': (False, 40), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'or': (False, 40), '>=': (True, 1057), '%': (True, 1058), '<=': (True, 1060)}, {'..': (True, 1073), '-': (True, 1074), '+': (True, 1075), ',': (False, 41), '==': (True, 1077), '/': (True, 1088), '<': (True, 1083), '>': (True, 1080), 'and': (False, 41), '^': (True, 1082), '~=': (True, 1084), '*': (True, 1085), 'or': (False, 41), '>=': (True, 1086), '%': (True, 1087), ';': (False, 41), '?>': (False, 41), '<=': (True, 1089)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), ',': (False, 40), '==': (True, 1129), '/': (True, 1132), '<': (True, 1135), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '~=': (True, 1136), '*': (True, 1137), 'or': (False, 40), '>=': (True, 1138), '%': (True, 1139), '<=': (True, 1140)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 43), '>': (False, 43), '^': (True, 1082), '~=': (False, 43), '*': (True, 1085), ';': (False, 43), '-': (True, 1074), 'and': (False, 43), 'or': (False, 43), '/': (True, 1088), '<': (False, 43), ',': (False, 43), '?>': (False, 43), '>=': (False, 43), '%': (True, 1087), '<=': (False, 43)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), ',': (False, 41), '==': (True, 1129), '/': (True, 1132), '<': (True, 1135), '>': (True, 1133), 'and': (False, 41), '^': (True, 1134), '~=': (True, 1136), '*': (True, 1137), 'or': (False, 41), '>=': (True, 1138), '%': (True, 1139), '<=': (True, 1140)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), '/': (True, 1059), '<': (True, 1053), '>': (True, 1052), 'do': (False, 41), 'and': (False, 41), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'or': (False, 41), '>=': (True, 1057), '%': (True, 1058), '<=': (True, 1060)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 1134), '+': (False, 52), '*': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 43), '>': (False, 43), '^': (True, 1134), '~=': (False, 43), '*': (True, 1137), '-': (True, 1126), 'and': (False, 43), 'or': (False, 43), '/': (True, 1132), '<': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 1139), '<=': (False, 43)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 43), '>': (False, 43), '^': (True, 925), '~=': (False, 43), '*': (True, 1055), 'do': (False, 43), '-': (True, 1047), 'and': (False, 43), 'or': (False, 43), '/': (True, 1059), '<': (False, 43), '>=': (False, 43), '%': (True, 1058), '<=': (False, 43)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 1082), '~=': (False, 54), '*': (False, 54), ';': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), ',': (False, 54), '?>': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 1134), '~=': (False, 54), '*': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 42), '>': (False, 42), '^': (True, 1082), '~=': (False, 42), '*': (True, 1085), ';': (False, 42), '-': (True, 1074), 'and': (False, 42), 'or': (False, 42), '/': (True, 1088), '<': (False, 42), ',': (False, 42), '?>': (False, 42), '>=': (False, 42), '%': (True, 1087), '<=': (False, 42)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 42), '>': (False, 42), '^': (True, 1134), '~=': (False, 42), '*': (True, 1137), '-': (True, 1126), 'and': (False, 42), 'or': (False, 42), '/': (True, 1132), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 1139), '<=': (False, 42)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 42), '>': (False, 42), '^': (True, 925), '~=': (False, 42), '*': (True, 1055), 'do': (False, 42), '-': (True, 1047), 'and': (False, 42), 'or': (False, 42), '/': (True, 1059), '<': (False, 42), '>=': (False, 42), '%': (True, 1058), '<=': (False, 42)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 46), '>': (False, 46), '^': (True, 1082), '~=': (False, 46), '*': (True, 1085), ';': (False, 46), '-': (True, 1074), '<': (False, 46), 'or': (False, 46), '/': (True, 1088), 'and': (False, 46), ',': (False, 46), '?>': (False, 46), '>=': (False, 46), '%': (True, 1087), '<=': (False, 46)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 46), '>': (False, 46), '^': (True, 1134), '~=': (False, 46), '*': (True, 1137), '-': (True, 1126), '<': (False, 46), 'or': (False, 46), '/': (True, 1132), 'and': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 1139), '<=': (False, 46)}, {'..': (False, 51), '~=': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 1082), '+': (False, 51), '*': (False, 51), ';': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '?>': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 46), '>': (False, 46), '^': (True, 925), '~=': (False, 46), '*': (True, 1055), 'do': (False, 46), '-': (True, 1047), '<': (False, 46), 'or': (False, 46), '/': (True, 1059), 'and': (False, 46), '>=': (False, 46), '%': (True, 1058), '<=': (False, 46)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 1134), '~=': (False, 51), '*': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 45), '>': (False, 45), '^': (True, 1082), '~=': (False, 45), '*': (True, 1085), ';': (False, 45), '-': (True, 1074), '<': (False, 45), 'or': (False, 45), '/': (True, 1088), 'and': (False, 45), ',': (False, 45), '?>': (False, 45), '>=': (False, 45), '%': (True, 1087), '<=': (False, 45)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 45), '>': (False, 45), '^': (True, 1134), '~=': (False, 45), '*': (True, 1137), '-': (True, 1126), '<': (False, 45), 'or': (False, 45), '/': (True, 1132), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 1139), '<=': (False, 45)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 925), '~=': (False, 51), '*': (False, 51), 'do': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 1082), '~=': (False, 53), '*': (False, 53), ';': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), ',': (False, 53), '?>': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 1134), '~=': (False, 53), '*': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 1082), '+': (False, 52), '*': (False, 52), ';': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), ',': (False, 52), '?>': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'end': (True, 1646)}, {'..': (True, 1125), '+': (True, 1127), '==': (False, 44), '>': (False, 44), '^': (True, 1134), '~=': (False, 44), '*': (True, 1137), '-': (True, 1126), '<': (False, 44), 'or': (False, 44), '/': (True, 1132), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 1139), '<=': (False, 44)}, {'..': (True, 1073), '+': (True, 1075), '==': (False, 44), '>': (False, 44), '^': (True, 1082), '~=': (False, 44), '*': (True, 1085), ';': (False, 44), '-': (True, 1074), '<': (False, 44), 'or': (False, 44), '/': (True, 1088), 'and': (False, 44), ',': (False, 44), '?>': (False, 44), '>=': (False, 44), '%': (True, 1087), '<=': (False, 44)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 45), '>': (False, 45), '^': (True, 925), '~=': (False, 45), '*': (True, 1055), 'do': (False, 45), '-': (True, 1047), '<': (False, 45), 'or': (False, 45), '/': (True, 1059), 'and': (False, 45), '>=': (False, 45), '%': (True, 1058), '<=': (False, 45)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 925), '~=': (False, 53), '*': (False, 53), 'do': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'EOF': (False, 87)}, {';': (False, 107), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), 'prefixexp': (True, 1910), 'function': (True, 1907), '#': (True, 1908), 'EOF': (False, 107), 'functioncall': (True, 1909), 'explist': (True, 1916), 'true': (True, 1911), 'STRING': (True, 1912), '-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 1918), 'var': (True, 1917), 'retstat__1': (True, 1924), '{': (True, 1919), 'nil': (True, 1920), 'NAME': (True, 1921), '(': (True, 1922), 'not': (True, 1923), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'EOF': (False, 0)}, {'::': (True, 1932)}, {'::': (False, 92), 'break': (False, 92), 'if': (False, 92), 'EMBEDSTAT': (False, 92), 'function': (False, 92), 'do': (False, 92), 'while': (False, 92), ';': (False, 92), '}': (False, 92), 'goto': (False, 92), 'for': (False, 92), 'local': (False, 92), 'return': (False, 92), 'NAME': (False, 92), '(': (False, 92), 'repeat': (False, 92)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 925), '+': (False, 52), '*': (False, 52), 'do': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), '/': (False, 52), 'and': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'end': (True, 1750)}, {'-': (True, 384), '<': (True, 392), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '^': (True, 385), 'then': (True, 2105), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 925), '~=': (False, 54), '*': (False, 54), 'do': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), '/': (False, 54), '<': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (True, 1046), '+': (True, 1048), '==': (False, 44), '>': (False, 44), '^': (True, 925), '~=': (False, 44), '*': (True, 1055), 'do': (False, 44), '-': (True, 1047), 'and': (False, 44), 'or': (False, 44), '/': (True, 1059), '<': (False, 44), '>=': (False, 44), '%': (True, 1058), '<=': (False, 44)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'prefixexp': (True, 1728), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), 'exp': (True, 1743), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'explist': (True, 1734), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 1747), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), ';': (False, 62), '/': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), 'end': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1749), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '/': (False, 56), '^': (True, 1479), '~=': (False, 56), '*': (False, 56), ';': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), 'end': (False, 56), '>': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'funcbody': (True, 2206), '(': (True, 2207)}, {'(': (False, 94)}, {'NAME': (True, 2208)}, {')': (True, 2212)}, {'NAME': (True, 2214)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), ',': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), 'end': (False, 25), '>': (False, 25), '[': (False, 25), '<': (False, 25), ';': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2216)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2219), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2221), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), ',': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'end': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '>': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), ',': (False, 24), '==': (False, 24), '{': (False, 24), '/': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), 'end': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), ';': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 2227), 'true': (True, 178), 'STRING': (True, 177)}, {'end': (True, 1833)}, {'.': (True, 927), 'funcname__1': (True, 2027), '(': (False, 18), ':': (False, 18)}, {'..': (True, 1046), '-': (True, 1047), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '<': (True, 1053), '>': (True, 1052), 'and': (True, 1051), '^': (True, 925), '~=': (True, 1054), '*': (True, 1055), 'do': (True, 2049), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '<=': (True, 1060)}, {'EOF': (False, 2), 'return': (False, 2)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), '[': (False, 86), 'and': (False, 86), 'then': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {')': (True, 2213)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 1479), '~=': (False, 57), '*': (False, 57), ';': (False, 57), '/': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), 'end': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'::': (False, 68), 'break': (False, 68), 'if': (False, 68), 'EMBEDSTAT': (False, 68), 'function': (False, 68), 'EOF': (False, 68), 'do': (False, 68), 'while': (False, 68), 'NAME': (False, 68), 'repeat': (False, 68), 'for': (False, 68), 'local': (False, 68), 'return': (False, 68), ';': (False, 68), '(': (False, 68), 'goto': (False, 68)}, {'..': (False, 22), '.': (False, 22), '+': (False, 22), ',': (False, 22), '==': (False, 22), '{': (False, 22), '/': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), '}': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ';': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'NAME': (True, 1754)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 1751), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'.': (False, 24), '::': (False, 24), 'break': (False, 24), '{': (False, 24), 'if': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'EOF': (False, 24), 'do': (False, 24), 'while': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), 'repeat': (False, 24), ':': (False, 24), 'for': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), ';': (False, 24), '(': (False, 24), 'STRING': (False, 24)}, {'.': (False, 21), '::': (False, 21), 'break': (False, 21), '{': (False, 21), 'if': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'EOF': (False, 21), 'do': (False, 21), 'while': (False, 21), 'NAME': (False, 21), 'repeat': (False, 21), 'STRING': (False, 21), ':': (False, 21), 'for': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), ';': (False, 21), '(': (False, 21), 'goto': (False, 21)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1755), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 25), '::': (False, 25), 'break': (False, 25), '{': (False, 25), 'if': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'EOF': (False, 25), 'do': (False, 25), 'while': (False, 25), 'NAME': (False, 25), 'goto': (False, 25), 'repeat': (False, 25), ':': (False, 25), 'for': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), ';': (False, 25), '(': (False, 25), 'STRING': (False, 25)}, {'args': (True, 1756), '{': (True, 669), 'tableconstructor': (True, 667), '(': (True, 666), 'STRING': (True, 664)}, {'.': (False, 22), '::': (False, 22), 'break': (False, 22), '{': (False, 22), 'if': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'do': (False, 22), 'while': (False, 22), 'NAME': (False, 22), 'repeat': (False, 22), 'STRING': (False, 22), ':': (False, 22), 'for': (False, 22), 'end': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), ';': (False, 22), '(': (False, 22), 'goto': (False, 22)}, {'::': (False, 104), 'break': (False, 104), 'if': (False, 104), 'elseif': (False, 104), 'EMBEDSTAT': (False, 104), 'function': (False, 104), 'do': (False, 104), 'while': (False, 104), ';': (False, 104), 'goto': (False, 104), 'for': (False, 104), 'end': (False, 104), 'local': (False, 104), 'return': (False, 104), 'NAME': (False, 104), '(': (False, 104), 'repeat': (False, 104), 'else': (False, 104)}, {')': (True, 2082)}, {'in': (True, 2102)}, {'in': (False, 29), 'namelist__1': (True, 323), ',': (True, 324), '=': (True, 2103)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2104), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2107), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2106), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2108), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2109), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2110), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2111), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2112), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2113), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {';': (False, 90), 'end': (False, 90)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2114), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2115), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2116), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2117), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2118), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2119), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2120), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'-': (True, 579), 'false': (True, 580), 'functiondef': (True, 581), 'exp': (True, 2121), 'functioncall': (True, 575), 'var': (True, 583), 'tableconstructor': (True, 571), 'EMBEDEXPR': (True, 572), '{': (True, 585), 'function': (True, 573), '#': (True, 574), 'nil': (True, 586), 'STRING': (True, 578), 'true': (True, 577), '(': (True, 588), 'not': (True, 589), 'prefixexp': (True, 576), 'NAME': (True, 587), '...': (True, 591), 'NUMBER': (True, 592)}, {'::': (False, 105), 'break': (False, 105), 'if': (False, 105), 'EMBEDSTAT': (False, 105), 'function': (False, 105), 'EOF': (False, 105), 'do': (False, 105), 'while': (False, 105), 'NAME': (False, 105), 'repeat': (False, 105), 'for': (False, 105), '=': (True, 2124), 'local': (False, 105), 'return': (False, 105), ';': (False, 105), '(': (False, 105), 'goto': (False, 105), 'stat__4': (True, 2125)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'EOF': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 2122), ';': (False, 29), 'NAME': (False, 29), 'repeat': (False, 29), 'for': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 2123), '(': (False, 29), 'goto': (False, 29)}, {'NAME': (True, 2126)}, {'}': (True, 2068)}, {'}': (True, 1668)}, {'until': (True, 1862)}, {'-': (True, 401), ')': (True, 1700), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2007), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 1479), '~=': (False, 55), '*': (False, 55), ';': (False, 55), '-': (False, 55), 'and': (False, 55), 'end': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'end': (False, 108)}, {'end': (False, 88)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), '/': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), ';': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), '}': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), '>': (False, 86), 'NAME': (False, 86), '<=': (False, 86)}, {'args': (True, 1562), '{': (True, 1289), 'tableconstructor': (True, 1291), '(': (True, 1288), 'STRING': (True, 1286)}, {')': (True, 1898)}, {'}': (True, 2241)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2251), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'and': (False, 13), 'STRING': (False, 13), '-': (False, 13), ')': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (True, 1351), '::': (False, 40), '+': (True, 1353), 'break': (False, 40), '==': (True, 1354), '>': (True, 1357), '^': (True, 1358), 'function': (False, 40), '~=': (True, 1360), 'EMBEDSTAT': (False, 40), '*': (True, 1361), 'do': (False, 40), 'or': (False, 40), 'while': (False, 40), 'NAME': (False, 40), 'goto': (False, 40), '-': (True, 1352), 'and': (True, 1356), 'for': (False, 40), 'until': (False, 40), '/': (True, 1355), 'local': (False, 40), 'return': (False, 40), '<': (True, 1359), ';': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 1363), '%': (True, 1364), 'repeat': (False, 40), '<=': (True, 1365)}, {'..': (True, 1351), '::': (False, 45), '+': (True, 1353), 'break': (False, 45), '==': (False, 45), 'if': (False, 45), '<': (False, 45), 'local': (False, 45), '^': (True, 1358), 'function': (False, 45), '~=': (False, 45), '*': (True, 1361), 'do': (False, 45), 'while': (False, 45), ';': (False, 45), 'repeat': (False, 45), '-': (True, 1352), 'EMBEDSTAT': (False, 45), 'or': (False, 45), 'until': (False, 45), '/': (True, 1355), '>': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), 'for': (False, 45), '>=': (False, 45), '%': (True, 1364), 'goto': (False, 45), '<=': (False, 45)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), '==': (False, 55), 'if': (False, 55), '<': (False, 55), 'local': (False, 55), '^': (True, 1520), 'function': (False, 55), '+': (False, 55), '*': (False, 55), 'do': (False, 55), 'while': (False, 55), ';': (False, 55), '}': (False, 55), 'goto': (False, 55), '-': (False, 55), 'EMBEDSTAT': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'return': (False, 55), 'and': (False, 55), 'NAME': (False, 55), '(': (False, 55), 'or': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '<=': (False, 55)}, {'..': (False, 53), '::': (False, 53), '+': (False, 53), 'break': (False, 53), '==': (False, 53), 'if': (False, 53), '<': (False, 53), '^': (True, 1358), 'function': (False, 53), '~=': (False, 53), '*': (False, 53), 'do': (False, 53), 'while': (False, 53), '/': (False, 53), 'repeat': (False, 53), '-': (False, 53), 'EMBEDSTAT': (False, 53), 'for': (False, 53), 'until': (False, 53), '>': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), 'NAME': (False, 53), ';': (False, 53), '(': (False, 53), 'or': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '<=': (False, 53)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 1367), 'while': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'local': (False, 55), 'return': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), '*': (False, 55), 'do': (False, 55), ';': (False, 55), 'goto': (False, 55), 'end': (False, 55), 'for': (False, 55), '/': (False, 55), 'elseif': (False, 55), 'NAME': (False, 55), 'else': (False, 55), '<=': (False, 55)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 1946), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {';': (False, 90), '}': (False, 90)}, {'..': (True, 1351), '::': (False, 44), '+': (True, 1353), 'break': (False, 44), '==': (False, 44), 'if': (False, 44), 'local': (False, 44), '^': (True, 1358), 'function': (False, 44), '~=': (False, 44), '*': (True, 1361), 'do': (False, 44), 'while': (False, 44), 'NAME': (False, 44), 'goto': (False, 44), '-': (True, 1352), 'EMBEDSTAT': (False, 44), 'or': (False, 44), 'until': (False, 44), '/': (True, 1355), '>': (False, 44), 'return': (False, 44), 'and': (False, 44), '<': (False, 44), ';': (False, 44), '(': (False, 44), 'for': (False, 44), '>=': (False, 44), '%': (True, 1364), 'repeat': (False, 44), '<=': (False, 44)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2008), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2009), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2010), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2011), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2012), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2014), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2015), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2017), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2019), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2021), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2024), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2026), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2028), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2030), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 976), 'false': (True, 977), 'functiondef': (True, 978), 'exp': (True, 2031), 'functioncall': (True, 991), 'var': (True, 982), 'tableconstructor': (True, 980), 'EMBEDEXPR': (True, 984), '{': (True, 985), 'function': (True, 983), '#': (True, 988), 'nil': (True, 987), 'STRING': (True, 995), 'true': (True, 994), '(': (True, 981), 'not': (True, 992), 'prefixexp': (True, 979), 'NAME': (True, 989), '...': (True, 990), 'NUMBER': (True, 986)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2034), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2033), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2035), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2036), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'function': (True, 1234), '#': (True, 1235), 'nil': (True, 1233), 'STRING': (True, 1237), 'true': (True, 1238), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'NAME': (True, 1236), '...': (True, 1242), 'NUMBER': (True, 1243)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2038), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2039), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2040), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'::': (False, 90), 'break': (False, 90), 'if': (False, 90), 'elseif': (False, 90), 'EMBEDSTAT': (False, 90), 'function': (False, 90), 'do': (False, 90), 'while': (False, 90), 'NAME': (False, 90), 'goto': (False, 90), 'for': (False, 90), 'end': (False, 90), 'local': (False, 90), 'return': (False, 90), ';': (False, 90), '(': (False, 90), 'repeat': (False, 90), 'else': (False, 90)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2127), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2130), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2131), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2132), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2133), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2134), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2135), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'-': (True, 1223), 'false': (True, 1224), 'functiondef': (True, 1225), 'exp': (True, 2137), 'functioncall': (True, 1239), 'var': (True, 1228), 'tableconstructor': (True, 1232), 'EMBEDEXPR': (True, 1230), '{': (True, 1229), 'NUMBER': (True, 1243), 'nil': (True, 1233), '#': (True, 1235), 'NAME': (True, 1236), 'function': (True, 1234), '...': (True, 1242), '(': (True, 1227), 'not': (True, 1240), 'prefixexp': (True, 1226), 'true': (True, 1238), 'STRING': (True, 1237)}, {'end': (True, 1557)}, {'end': (True, 2352)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2023), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {')': (True, 2032)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 2145), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'::': (False, 10), 'break': (False, 10), '(': (False, 10), 'if': (False, 10), 'EMBEDSTAT': (False, 10), 'function': (False, 10), 'do': (False, 10), 'while': (False, 10), ';': (False, 10), 'repeat': (False, 10), 'for': (False, 10), '=': (False, 10), 'local': (False, 10), 'return': (False, 10), 'NAME': (False, 10), '?>': (False, 10), 'goto': (False, 10)}, {'NAME': (True, 2147)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'explist': (True, 2149), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), 'exp': (True, 1347), '{': (True, 1339), 'function': (True, 1336), '#': (True, 1342), 'nil': (True, 1341), 'STRING': (True, 1349), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'NAME': (True, 1343), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'::': (False, 77), 'break': (False, 77), '(': (False, 77), 'if': (False, 77), 'EMBEDSTAT': (False, 77), 'function': (False, 77), 'do': (False, 77), 'while': (False, 77), 'NAME': (False, 77), 'repeat': (False, 77), 'for': (False, 77), 'local': (False, 77), 'return': (False, 77), ';': (False, 77), '?>': (False, 77), 'goto': (False, 77)}, {'funcbody': (True, 2153), '(': (True, 923)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), ']': (False, 9), '*': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'end': (True, 2161)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2160), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 384), '^': (True, 385), '+': (True, 386), '==': (True, 387), 'or': (True, 388), '/': (True, 389), '>': (True, 390), 'and': (True, 391), '<': (True, 392), 'then': (True, 1772), '~=': (True, 394), '*': (True, 395), '>=': (True, 396), '%': (True, 397), '..': (True, 398), '<=': (True, 399)}, {'::': (False, 70), 'break': (False, 70), '(': (False, 70), 'if': (False, 70), 'EMBEDSTAT': (False, 70), 'function': (False, 70), 'do': (False, 70), 'while': (False, 70), 'NAME': (False, 70), 'goto': (False, 70), 'for': (False, 70), 'local': (False, 70), 'return': (False, 70), ';': (False, 70), '?>': (False, 70), 'repeat': (False, 70)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'prefixexp': (True, 452), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), 'exp': (True, 467), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'explist': (True, 1797), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 1799), 'true': (True, 487), 'STRING': (True, 486)}, {'::': (False, 76), 'break': (False, 76), 'if': (False, 76), 'EMBEDSTAT': (False, 76), 'function': (False, 76), 'do': (False, 76), 'while': (False, 76), ';': (False, 76), 'goto': (False, 76), 'for': (False, 76), 'end': (False, 76), 'local': (False, 76), 'return': (False, 76), 'NAME': (False, 76), '(': (False, 76), 'repeat': (False, 76)}, {'::': (False, 69), 'break': (False, 69), 'if': (False, 69), 'local': (False, 69), 'EMBEDSTAT': (False, 69), 'function': (False, 69), 'do': (False, 69), 'while': (False, 69), 'NAME': (False, 69), 'repeat': (False, 69), 'for': (False, 69), 'end': (False, 69), 'elseif': (False, 69), 'return': (False, 69), ';': (False, 69), '(': (False, 69), 'goto': (False, 69), 'else': (False, 69)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), 'if': (False, 22), '^': (False, 22), 'while': (False, 22), '/': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), '}': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'exp': (True, 2247), 'functioncall': (True, 136), 'var': (True, 145), 'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), '{': (True, 146), 'function': (True, 134), '#': (True, 135), 'nil': (True, 148), 'STRING': (True, 139), 'true': (True, 138), '(': (True, 150), 'not': (True, 152), 'prefixexp': (True, 137), 'NAME': (True, 186), '...': (True, 153), 'NUMBER': (True, 154)}, {'end': (True, 2159)}, {'..': (False, 50), '::': (False, 50), '~=': (False, 50), 'break': (False, 50), 'if': (False, 50), '^': (True, 1195), 'while': (False, 50), '-': (False, 50), '<': (False, 50), 'or': (False, 50), 'until': (False, 50), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ',': (False, 50), '(': (False, 50), '>=': (False, 50), '%': (True, 1201), 'goto': (False, 50), '+': (False, 50), '==': (False, 50), 'EMBEDSTAT': (False, 50), 'function': (False, 50), '*': (True, 1198), 'do': (False, 50), 'NAME': (False, 50), 'repeat': (False, 50), 'for': (False, 50), '/': (True, 1202), '>': (False, 50), ';': (False, 50), '<=': (False, 50)}, {'..': (True, 1187), '::': (False, 48), '~=': (False, 48), 'break': (False, 48), ',': (False, 48), 'if': (False, 48), '^': (True, 1195), 'while': (False, 48), '-': (True, 1188), '<': (False, 48), 'or': (False, 48), 'until': (False, 48), 'local': (False, 48), 'return': (False, 48), 'and': (False, 48), 'NAME': (False, 48), '(': (False, 48), '>=': (False, 48), '%': (True, 1201), 'repeat': (False, 48), '+': (True, 1189), '==': (False, 48), 'EMBEDSTAT': (False, 48), 'function': (False, 48), '*': (True, 1198), 'do': (False, 48), 'goto': (False, 48), 'for': (False, 48), '/': (True, 1202), '>': (False, 48), ';': (False, 48), '<=': (False, 48)}, {'..': (False, 49), '::': (False, 49), '~=': (False, 49), 'break': (False, 49), 'if': (False, 49), '^': (True, 1195), 'while': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), 'until': (False, 49), 'local': (False, 49), 'return': (False, 49), '<': (False, 49), ',': (False, 49), '(': (False, 49), '>=': (False, 49), '%': (True, 1201), 'goto': (False, 49), '+': (False, 49), '==': (False, 49), 'EMBEDSTAT': (False, 49), 'function': (False, 49), '*': (True, 1198), 'do': (False, 49), ';': (False, 49), 'repeat': (False, 49), 'for': (False, 49), '/': (True, 1202), '>': (False, 49), 'NAME': (False, 49), '<=': (False, 49)}, {'..': (True, 1187), '::': (False, 93), '~=': (True, 1197), 'break': (False, 93), '/': (True, 1202), '^': (True, 1195), 'while': (False, 93), '-': (True, 1188), 'and': (True, 1193), 'or': (True, 1199), 'until': (False, 93), 'explist__1': (True, 2228), 'local': (False, 93), 'return': (False, 93), '<': (True, 1196), ',': (True, 1190), '(': (False, 93), 'if': (False, 93), '>=': (True, 1200), '%': (True, 1201), 'goto': (False, 93), '+': (True, 1189), '==': (True, 1191), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 1198), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '>': (True, 1194), 'NAME': (False, 93), '<=': (True, 1203)}, {'..': (True, 1187), '::': (False, 47), '~=': (False, 47), 'break': (False, 47), ',': (False, 47), 'if': (False, 47), '^': (True, 1195), 'while': (False, 47), '-': (True, 1188), 'and': (False, 47), 'or': (False, 47), 'until': (False, 47), 'local': (False, 47), 'return': (False, 47), '<': (False, 47), 'NAME': (False, 47), '(': (False, 47), '>=': (False, 47), '%': (True, 1201), 'goto': (False, 47), '+': (True, 1189), '==': (False, 47), 'EMBEDSTAT': (False, 47), 'function': (False, 47), '*': (True, 1198), 'do': (False, 47), 'repeat': (False, 47), 'for': (False, 47), '/': (True, 1202), '>': (False, 47), ';': (False, 47), '<=': (False, 47)}, {'..': (True, 1187), '::': (False, 41), '~=': (True, 1197), 'break': (False, 41), ',': (False, 41), '>': (True, 1194), '^': (True, 1195), 'while': (False, 41), '-': (True, 1188), 'and': (False, 41), 'or': (False, 41), 'until': (False, 41), 'local': (False, 41), 'return': (False, 41), '<': (True, 1196), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1200), '%': (True, 1201), 'goto': (False, 41), '+': (True, 1189), '==': (True, 1191), 'EMBEDSTAT': (False, 41), 'function': (False, 41), '*': (True, 1198), 'do': (False, 41), 'repeat': (False, 41), 'for': (False, 41), '/': (True, 1202), ';': (False, 41), '<=': (True, 1203)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), '==': (True, 1129), 'or': (True, 1130), '<': (True, 1135), '/': (True, 1132), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '>=': (True, 1138), ',': (True, 2128), '*': (True, 1137), '~=': (True, 1136), '%': (True, 1139), '<=': (True, 1140)}, {'..': (True, 1187), '::': (False, 43), '~=': (False, 43), 'break': (False, 43), '>': (False, 43), '^': (True, 1195), 'while': (False, 43), '-': (True, 1188), '<': (False, 43), 'or': (False, 43), 'until': (False, 43), 'local': (False, 43), 'return': (False, 43), 'and': (False, 43), ',': (False, 43), '(': (False, 43), 'if': (False, 43), '>=': (False, 43), '%': (True, 1201), 'goto': (False, 43), '+': (True, 1189), '==': (False, 43), 'EMBEDSTAT': (False, 43), 'function': (False, 43), '*': (True, 1198), 'do': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), 'for': (False, 43), '/': (True, 1202), ';': (False, 43), '<=': (False, 43)}, {'..': (False, 54), '::': (False, 54), '~=': (False, 54), 'break': (False, 54), ',': (False, 54), 'if': (False, 54), '^': (True, 1195), 'while': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), 'until': (False, 54), 'local': (False, 54), 'return': (False, 54), 'and': (False, 54), 'NAME': (False, 54), '(': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '+': (False, 54), '==': (False, 54), 'EMBEDSTAT': (False, 54), 'function': (False, 54), '*': (False, 54), 'do': (False, 54), 'repeat': (False, 54), 'for': (False, 54), '/': (False, 54), '>': (False, 54), ';': (False, 54), '<=': (False, 54)}, {'..': (True, 1187), '::': (False, 42), '~=': (False, 42), 'break': (False, 42), ',': (False, 42), 'if': (False, 42), '^': (True, 1195), 'while': (False, 42), '-': (True, 1188), '<': (False, 42), 'or': (False, 42), 'until': (False, 42), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), '(': (False, 42), '>=': (False, 42), '%': (True, 1201), 'repeat': (False, 42), '+': (True, 1189), '==': (False, 42), 'EMBEDSTAT': (False, 42), 'function': (False, 42), '*': (True, 1198), 'do': (False, 42), 'goto': (False, 42), 'for': (False, 42), '/': (True, 1202), '>': (False, 42), ';': (False, 42), '<=': (False, 42)}, {'..': (True, 1187), '::': (False, 46), '~=': (False, 46), 'break': (False, 46), ',': (False, 46), '>': (False, 46), '^': (True, 1195), 'while': (False, 46), '-': (True, 1188), '<': (False, 46), 'or': (False, 46), 'until': (False, 46), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), 'NAME': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 1201), 'goto': (False, 46), '+': (True, 1189), '==': (False, 46), 'EMBEDSTAT': (False, 46), 'function': (False, 46), '*': (True, 1198), 'do': (False, 46), 'repeat': (False, 46), 'for': (False, 46), '/': (True, 1202), ';': (False, 46), '<=': (False, 46)}, {'..': (False, 9), '~=': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '+': (False, 9), '*': (False, 9), ';': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '?>': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), ',': (False, 51), 'if': (False, 51), '^': (True, 1195), 'while': (False, 51), '/': (False, 51), '-': (False, 51), 'and': (False, 51), 'or': (False, 51), 'until': (False, 51), 'local': (False, 51), 'return': (False, 51), '<': (False, 51), 'NAME': (False, 51), '(': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '+': (False, 51), '==': (False, 51), 'EMBEDSTAT': (False, 51), 'function': (False, 51), '*': (False, 51), 'do': (False, 51), 'goto': (False, 51), 'for': (False, 51), '>': (False, 51), ';': (False, 51), '<=': (False, 51)}, {'..': (True, 1187), '::': (False, 40), '~=': (True, 1197), 'break': (False, 40), ',': (False, 40), '>': (True, 1194), '^': (True, 1195), 'while': (False, 40), '-': (True, 1188), 'and': (True, 1193), 'or': (False, 40), 'until': (False, 40), 'local': (False, 40), 'return': (False, 40), '<': (True, 1196), 'NAME': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 1200), '%': (True, 1201), 'goto': (False, 40), '+': (True, 1189), '==': (True, 1191), 'EMBEDSTAT': (False, 40), 'function': (False, 40), '*': (True, 1198), 'do': (False, 40), 'repeat': (False, 40), 'for': (False, 40), '/': (True, 1202), ';': (False, 40), '<=': (True, 1203)}, {'..': (True, 1187), '::': (False, 45), '~=': (False, 45), 'break': (False, 45), ',': (False, 45), 'if': (False, 45), '^': (True, 1195), 'while': (False, 45), '-': (True, 1188), '<': (False, 45), 'or': (False, 45), 'until': (False, 45), 'local': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), '>=': (False, 45), '%': (True, 1201), 'goto': (False, 45), '+': (True, 1189), '==': (False, 45), 'EMBEDSTAT': (False, 45), 'function': (False, 45), '*': (True, 1198), 'do': (False, 45), 'repeat': (False, 45), 'for': (False, 45), '/': (True, 1202), '>': (False, 45), ';': (False, 45), '<=': (False, 45)}, {'..': (False, 53), '::': (False, 53), '~=': (False, 53), 'break': (False, 53), 'if': (False, 53), '^': (True, 1195), 'while': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), 'until': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), ',': (False, 53), '(': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '+': (False, 53), '==': (False, 53), 'EMBEDSTAT': (False, 53), 'function': (False, 53), '*': (False, 53), 'do': (False, 53), 'NAME': (False, 53), 'repeat': (False, 53), 'for': (False, 53), '/': (False, 53), '>': (False, 53), ';': (False, 53), '<=': (False, 53)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), ';': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), 'until': (False, 62), '/': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2046), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 52), '::': (False, 52), '~=': (False, 52), 'break': (False, 52), ',': (False, 52), 'if': (False, 52), '^': (True, 1195), 'while': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), 'until': (False, 52), 'local': (False, 52), 'return': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '+': (False, 52), '==': (False, 52), 'EMBEDSTAT': (False, 52), 'function': (False, 52), '*': (False, 52), 'do': (False, 52), 'goto': (False, 52), 'for': (False, 52), '/': (False, 52), '>': (False, 52), ';': (False, 52), '<=': (False, 52)}, {'..': (True, 1187), '::': (False, 44), '~=': (False, 44), 'break': (False, 44), ',': (False, 44), 'if': (False, 44), '^': (True, 1195), 'while': (False, 44), '-': (True, 1188), 'and': (False, 44), 'or': (False, 44), 'until': (False, 44), 'local': (False, 44), 'return': (False, 44), '<': (False, 44), 'NAME': (False, 44), '(': (False, 44), '>=': (False, 44), '%': (True, 1201), 'repeat': (False, 44), '+': (True, 1189), '==': (False, 44), 'EMBEDSTAT': (False, 44), 'function': (False, 44), '*': (True, 1198), 'do': (False, 44), 'goto': (False, 44), 'for': (False, 44), '/': (True, 1202), '>': (False, 44), ';': (False, 44), '<=': (False, 44)}, {'do': (True, 2091)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 1630), '~=': (False, 56), '*': (False, 56), ';': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), 'until': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1947), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '/': (False, 35), '^': (False, 35), '~=': (False, 35), '*': (False, 35), ';': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), 'end': (False, 35), 'elseif': (False, 35), '>': (False, 35), 'and': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), 'else': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 1948), '(': (True, 1949)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 1950), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), ',': (False, 12), '==': (False, 12), '{': (False, 12), '/': (False, 12), 'elseif': (False, 12), '^': (False, 12), '+': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), 'end': (False, 12), '>': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'else': (False, 12), '<=': (False, 12)}, {';': (False, 106), 'end': (False, 106), 'elseif': (False, 106), 'else': (False, 106)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '>': (False, 32), '^': (False, 32), '+': (False, 32), '*': (False, 32), ';': (False, 32), '/': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), 'end': (False, 32), 'elseif': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), 'else': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '+': (False, 34), '==': (False, 34), 'end': (False, 34), '^': (False, 34), '~=': (False, 34), '*': (False, 34), ';': (False, 34), '/': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), 'elseif': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), 'else': (False, 34), '<=': (False, 34)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 1953), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), '*': (False, 31), ';': (False, 31), '/': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), 'end': (False, 31), 'elseif': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), 'else': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '>': (False, 37), '^': (False, 37), '~=': (False, 37), '*': (False, 37), ';': (False, 37), '/': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), 'end': (False, 37), 'elseif': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), 'else': (False, 37), '<=': (False, 37)}, {'.': (True, 1955), '..': (False, 38), '~=': (False, 38), '==': (False, 38), '{': (True, 1959), '>': (False, 38), '^': (False, 38), '+': (False, 38), '*': (False, 38), 'args': (True, 1960), ';': (False, 38), '/': (False, 38), 'STRING': (True, 1956), '-': (False, 38), '<': (False, 38), ':': (True, 1957), 'or': (False, 38), 'tableconstructor': (True, 1961), 'end': (False, 38), 'elseif': (False, 38), '[': (True, 1962), 'and': (False, 38), ',': (False, 38), '(': (True, 1958), '>=': (False, 38), '%': (False, 38), 'else': (False, 38), '<=': (False, 38)}, {'..': (False, 11), '.': (False, 11), '~=': (False, 11), ',': (False, 11), '==': (False, 11), '{': (False, 11), '/': (False, 11), '^': (False, 11), '+': (False, 11), '*': (False, 11), 'end': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '>': (False, 11), 'elseif': (False, 11), '[': (False, 11), 'and': (False, 11), ';': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'else': (False, 11), '<=': (False, 11)}, {'..': (True, 1964), '-': (True, 1965), '+': (True, 1966), 'end': (False, 93), '==': (True, 1968), 'or': (True, 1969), '<': (True, 1974), '>': (True, 1971), 'elseif': (False, 93), 'explist__1': (True, 1972), 'and': (True, 1970), '^': (True, 1973), '>=': (True, 1977), ',': (True, 1967), '*': (True, 1976), '~=': (True, 1975), '%': (True, 1978), ';': (False, 93), '/': (True, 1979), 'else': (False, 93), '<=': (True, 1980)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), '*': (False, 39), ';': (False, 39), '/': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), 'end': (False, 39), 'elseif': (False, 39), '<': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), 'else': (False, 39), '<=': (False, 39)}, {'..': (False, 30), '~=': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '+': (False, 30), '*': (False, 30), ';': (False, 30), '/': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), 'end': (False, 30), 'elseif': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), 'else': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '/': (False, 84), '^': (False, 84), '+': (False, 84), '*': (False, 84), 'end': (False, 84), 'STRING': (False, 84), '-': (False, 84), '<': (False, 84), ':': (False, 84), 'or': (False, 84), '>': (False, 84), 'elseif': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), 'else': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'function': (True, 283), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'exp': (True, 2002), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2003), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'retstat__2': (True, 2004), ';': (True, 2005), 'end': (False, 89), 'elseif': (False, 89), 'else': (False, 89)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '>': (False, 36), '^': (False, 36), '~=': (False, 36), '*': (False, 36), ';': (False, 36), '/': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'end': (False, 36), 'elseif': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), 'else': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '>': (False, 33), '^': (False, 33), '~=': (False, 33), '*': (False, 33), ';': (False, 33), '/': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'end': (False, 33), 'elseif': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), 'else': (False, 33), '<=': (False, 33)}, {'NAME': (True, 2252)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), ',': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), 'until': (False, 25), '>': (False, 25), '[': (False, 25), '<': (False, 25), ';': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2254)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2255), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2256), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), ',': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), 'until': (False, 21), '>': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), ',': (False, 24), '==': (False, 24), '{': (False, 24), '>': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), 'until': (False, 24), '/': (False, 24), '[': (False, 24), 'and': (False, 24), ';': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 2258), 'true': (True, 178), 'STRING': (True, 177)}, {'end': (True, 2350)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), '>': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'until': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), ';': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), '/': (False, 86), 'NAME': (False, 86), '<=': (False, 86)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 1630), '~=': (False, 57), '*': (False, 57), ';': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), 'until': (False, 57), '/': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ',': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'args': (True, 2048), '{': (True, 1298), 'tableconstructor': (True, 1300), '(': (True, 1297), 'STRING': (True, 1295)}, {')': (True, 1702)}, {'}': (True, 1718)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1843), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1835), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1852), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1854), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1857), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1858), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1859), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1864), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1865), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'until': (False, 90), ';': (False, 90)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1867), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1868), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1869), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1871), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1872), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1873), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 1015), 'false': (True, 1016), 'functiondef': (True, 1017), 'exp': (True, 1878), 'functioncall': (True, 1011), 'var': (True, 1019), 'tableconstructor': (True, 1007), 'EMBEDEXPR': (True, 1008), '{': (True, 1021), 'function': (True, 1009), '#': (True, 1010), 'nil': (True, 1022), 'STRING': (True, 1014), 'true': (True, 1013), '(': (True, 1024), 'not': (True, 1025), 'prefixexp': (True, 1012), 'NAME': (True, 1023), '...': (True, 1027), 'NUMBER': (True, 1028)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 1897), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 2345), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'::': (False, 104), 'break': (False, 104), 'if': (False, 104), 'EMBEDSTAT': (False, 104), 'function': (False, 104), 'do': (False, 104), 'while': (False, 104), ';': (False, 104), 'goto': (False, 104), 'for': (False, 104), 'end': (False, 104), 'local': (False, 104), 'return': (False, 104), 'NAME': (False, 104), '(': (False, 104), 'repeat': (False, 104)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), ']': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), '==': (True, 1129), 'or': (True, 1130), '<': (True, 1135), '/': (True, 1132), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '>=': (True, 1138), ',': (True, 1723), '*': (True, 1137), '~=': (True, 1136), '%': (True, 1139), '<=': (True, 1140)}, {'::': (False, 70), 'break': (False, 70), 'if': (False, 70), 'EMBEDSTAT': (False, 70), 'function': (False, 70), 'do': (False, 70), 'while': (False, 70), 'NAME': (False, 70), 'goto': (False, 70), 'for': (False, 70), 'end': (False, 70), 'local': (False, 70), 'return': (False, 70), ';': (False, 70), '(': (False, 70), 'repeat': (False, 70)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 1752), ';': (False, 29), 'NAME': (False, 29), '=': (False, 29), 'goto': (False, 29), 'for': (False, 29), 'end': (False, 29), 'elseif': (False, 29), 'return': (False, 29), ',': (True, 882), '(': (False, 29), 'repeat': (False, 29), 'else': (False, 29)}, {'do': (True, 1657)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 1695), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'.': (False, 9), '::': (False, 9), 'break': (False, 9), '{': (False, 9), 'if': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'repeat': (False, 9), 'do': (False, 9), 'while': (False, 9), 'NAME': (False, 9), 'STRING': (False, 9), ':': (False, 9), 'for': (False, 9), 'end': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), ';': (False, 9), '(': (False, 9), 'goto': (False, 9)}, {'.': (False, 22), '::': (False, 22), 'break': (False, 22), '{': (False, 22), 'if': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'do': (False, 22), 'while': (False, 22), 'NAME': (False, 22), 'repeat': (False, 22), 'STRING': (False, 22), ':': (False, 22), 'for': (False, 22), 'until': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), ';': (False, 22), '(': (False, 22), 'goto': (False, 22)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), ']': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), 'and': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), '[': (False, 86), '<': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), '==': (False, 57), 'if': (False, 57), '<': (False, 57), '^': (True, 1710), 'function': (False, 57), '+': (False, 57), '*': (False, 57), 'do': (False, 57), 'while': (False, 57), 'NAME': (False, 57), 'repeat': (False, 57), '-': (False, 57), 'EMBEDSTAT': (False, 57), 'end': (False, 57), 'for': (False, 57), '/': (False, 57), 'local': (False, 57), 'return': (False, 57), '>': (False, 57), 'and': (False, 57), ';': (False, 57), '(': (False, 57), 'or': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '<=': (False, 57)}, {'args': (True, 2059), '{': (True, 911), 'tableconstructor': (True, 909), '(': (True, 908), 'STRING': (True, 906)}, {')': (True, 1724)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'do': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2222), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'NAME': (True, 2224)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), 'if': (False, 25), '^': (False, 25), 'end': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2226)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2229), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2231), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'end': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), 'NAME': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), 'NAME': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'goto': (False, 24), 'end': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), ':': (False, 24), ';': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2235), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'::': (False, 76), 'break': (False, 76), 'if': (False, 76), 'EMBEDSTAT': (False, 76), 'function': (False, 76), 'do': (False, 76), 'while': (False, 76), 'NAME': (False, 76), 'repeat': (False, 76), 'for': (False, 76), 'local': (False, 76), 'return': (False, 76), '}': (False, 76), ';': (False, 76), '(': (False, 76), 'goto': (False, 76)}, {'-': (True, 401), ')': (True, 2373), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'.': (False, 9), '..': (False, 9), '~=': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '+': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), 'then': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'}': (True, 2050)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2315), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 62), '::': (False, 62), '+': (False, 62), 'break': (False, 62), '==': (False, 62), 'if': (False, 62), '^': (False, 62), 'function': (False, 62), '~=': (False, 62), '*': (False, 62), 'do': (False, 62), 'while': (False, 62), 'and': (False, 62), ';': (False, 62), 'repeat': (False, 62), '-': (False, 62), 'EMBEDSTAT': (False, 62), 'end': (False, 62), 'or': (False, 62), '/': (False, 62), 'local': (False, 62), 'return': (False, 62), '>': (False, 62), '<': (False, 62), 'NAME': (False, 62), '(': (False, 62), 'for': (False, 62), '>=': (False, 62), '%': (False, 62), 'goto': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2321), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2340), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '>': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '/': (False, 22), '[': (False, 22), '<': (False, 22), ',': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'}': (True, 1838)}, {'end': (True, 2148)}, {'.': (False, 23), '..': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), 'do': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), ',': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2162), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'nil': (True, 1689), '#': (True, 1690), 'NAME': (True, 1691), 'function': (True, 1685), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'STRING': (True, 1697), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'..': (False, 31), '::': (False, 31), '+': (False, 31), 'break': (False, 31), '?>': (False, 31), '==': (False, 31), 'if': (False, 31), '^': (False, 31), 'function': (False, 31), '~=': (False, 31), '*': (False, 31), 'do': (False, 31), 'while': (False, 31), '/': (False, 31), 'repeat': (False, 31), '-': (False, 31), 'EMBEDSTAT': (False, 31), 'or': (False, 31), '>': (False, 31), 'local': (False, 31), 'return': (False, 31), 'and': (False, 31), '<': (False, 31), 'NAME': (False, 31), ';': (False, 31), '(': (False, 31), 'for': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), '(': (False, 37), '==': (False, 37), 'if': (False, 37), '^': (False, 37), 'local': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '+': (False, 37), '*': (False, 37), 'do': (False, 37), 'while': (False, 37), 'NAME': (False, 37), 'repeat': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), '/': (False, 37), '>': (False, 37), 'return': (False, 37), 'and': (False, 37), ';': (False, 37), '?>': (False, 37), 'for': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), 'tableconstructor': (True, 2170), 'if': (False, 38), '^': (False, 38), 'args': (True, 2169), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 2171), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 2167), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 2164), '+': (False, 38), '==': (False, 38), '{': (True, 2168), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 2165), ':': (True, 2166), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '?>': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '+': (False, 39), 'break': (False, 39), '?>': (False, 39), '==': (False, 39), 'if': (False, 39), '<': (False, 39), '^': (False, 39), 'function': (False, 39), '~=': (False, 39), '*': (False, 39), 'do': (False, 39), 'while': (False, 39), '/': (False, 39), 'goto': (False, 39), '-': (False, 39), 'EMBEDSTAT': (False, 39), 'or': (False, 39), '>': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), ';': (False, 39), '(': (False, 39), 'for': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 2173), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), 'NAME': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '?>': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 2174), '(': (True, 2175)}, {'..': (False, 35), '::': (False, 35), '+': (False, 35), 'break': (False, 35), '?>': (False, 35), '==': (False, 35), 'if': (False, 35), '^': (False, 35), 'function': (False, 35), '~=': (False, 35), '*': (False, 35), 'do': (False, 35), 'while': (False, 35), 'and': (False, 35), 'NAME': (False, 35), 'repeat': (False, 35), '-': (False, 35), 'EMBEDSTAT': (False, 35), 'for': (False, 35), '/': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), ';': (False, 35), '(': (False, 35), 'or': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2180), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '+': (False, 33), 'break': (False, 33), '?>': (False, 33), '==': (False, 33), 'if': (False, 33), 'local': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '~=': (False, 33), '*': (False, 33), 'do': (False, 33), 'while': (False, 33), ';': (False, 33), 'repeat': (False, 33), '-': (False, 33), '^': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), 'return': (False, 33), 'and': (False, 33), '<': (False, 33), 'NAME': (False, 33), '(': (False, 33), 'or': (False, 33), '>=': (False, 33), '%': (False, 33), 'goto': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), '(': (False, 30), '==': (False, 30), 'if': (False, 30), '<': (False, 30), '^': (False, 30), 'function': (False, 30), '+': (False, 30), '*': (False, 30), 'do': (False, 30), 'while': (False, 30), ';': (False, 30), '/': (False, 30), 'repeat': (False, 30), '-': (False, 30), 'EMBEDSTAT': (False, 30), 'or': (False, 30), '>': (False, 30), 'local': (False, 30), 'return': (False, 30), 'and': (False, 30), 'NAME': (False, 30), '?>': (False, 30), 'for': (False, 30), '>=': (False, 30), '%': (False, 30), 'goto': (False, 30), '<=': (False, 30)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2191), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'nil': (True, 1689), '#': (True, 1690), 'NAME': (True, 1691), 'function': (True, 1685), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'STRING': (True, 1697), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), 'if': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '/': (False, 84), '>': (False, 84), 'NAME': (False, 84), '?>': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), '?>': (False, 36), '==': (False, 36), 'if': (False, 36), '^': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '+': (False, 36), '*': (False, 36), 'do': (False, 36), 'while': (False, 36), ';': (False, 36), 'goto': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '/': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), 'NAME': (False, 36), '(': (False, 36), 'for': (False, 36), '>=': (False, 36), '%': (False, 36), 'repeat': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '?>': (False, 12), '<=': (False, 12)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2261), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'..': (True, 2263), '::': (False, 71), '+': (True, 2265), 'break': (False, 71), '?>': (False, 71), '==': (True, 2266), '>': (True, 2269), '^': (True, 2260), 'function': (False, 71), '~=': (True, 2271), 'EMBEDSTAT': (False, 71), '*': (True, 2272), 'do': (False, 71), 'while': (False, 71), ';': (False, 71), 'if': (False, 71), 'goto': (False, 71), '-': (True, 2264), 'and': (True, 2268), 'or': (True, 2273), '/': (True, 2267), 'local': (False, 71), 'return': (False, 71), '<': (True, 2270), 'NAME': (False, 71), '(': (False, 71), 'for': (False, 71), '>=': (True, 2274), '%': (True, 2275), 'repeat': (False, 71), '<=': (True, 2276)}, {'..': (False, 32), '::': (False, 32), '+': (False, 32), 'break': (False, 32), '?>': (False, 32), '==': (False, 32), 'if': (False, 32), '^': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '~=': (False, 32), '*': (False, 32), 'do': (False, 32), 'while': (False, 32), ';': (False, 32), '/': (False, 32), 'repeat': (False, 32), '-': (False, 32), '<': (False, 32), 'for': (False, 32), '>': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), 'or': (False, 32), '>=': (False, 32), '%': (False, 32), 'goto': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '+': (False, 34), 'break': (False, 34), '?>': (False, 34), '==': (False, 34), 'if': (False, 34), 'local': (False, 34), '^': (False, 34), 'function': (False, 34), '~=': (False, 34), '*': (False, 34), 'do': (False, 34), 'while': (False, 34), ';': (False, 34), 'goto': (False, 34), '-': (False, 34), 'EMBEDSTAT': (False, 34), 'or': (False, 34), '/': (False, 34), '>': (False, 34), 'return': (False, 34), 'and': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'for': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '<=': (False, 34)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '==': (False, 56), 'if': (False, 56), '^': (True, 1710), 'function': (False, 56), '+': (False, 56), '*': (False, 56), 'do': (False, 56), 'while': (False, 56), 'and': (False, 56), ';': (False, 56), '/': (False, 56), 'repeat': (False, 56), '-': (False, 56), 'EMBEDSTAT': (False, 56), 'or': (False, 56), 'end': (False, 56), 'local': (False, 56), 'return': (False, 56), '>': (False, 56), '<': (False, 56), 'NAME': (False, 56), '(': (False, 56), 'for': (False, 56), '>=': (False, 56), '%': (False, 56), 'goto': (False, 56), '<=': (False, 56)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '>': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'do': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '/': (False, 22), '[': (False, 22), '<': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), ',': (False, 13), '==': (False, 13), '{': (False, 13), '/': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), 'end': (False, 13), '>': (False, 13), '[': (False, 13), '<': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), '==': (False, 55), 'if': (False, 55), '<': (False, 55), 'local': (False, 55), '^': (True, 1710), 'function': (False, 55), '+': (False, 55), '*': (False, 55), 'do': (False, 55), 'while': (False, 55), ';': (False, 55), 'goto': (False, 55), '-': (False, 55), 'EMBEDSTAT': (False, 55), 'end': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'return': (False, 55), 'and': (False, 55), 'NAME': (False, 55), '(': (False, 55), 'or': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '<=': (False, 55)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'until': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), '/': (False, 23), '>': (False, 23), 'NAME': (False, 23), '<=': (False, 23)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2380), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2379), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2381), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2383), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2384), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2385), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2386), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2387), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2388), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2389), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2390), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2391), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2392), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2393), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'-': (True, 1263), 'false': (True, 1264), 'functiondef': (True, 1265), 'exp': (True, 2395), 'functioncall': (True, 1278), 'var': (True, 1269), 'tableconstructor': (True, 1267), 'EMBEDEXPR': (True, 1271), '{': (True, 1272), 'function': (True, 1270), '#': (True, 1275), 'nil': (True, 1274), 'STRING': (True, 1282), 'true': (True, 1281), '(': (True, 1268), 'not': (True, 1279), 'prefixexp': (True, 1266), 'NAME': (True, 1276), '...': (True, 1277), 'NUMBER': (True, 1273)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'until': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), '>': (False, 9), 'NAME': (False, 9), '<=': (False, 9)}, {')': (True, 2322)}, {'}': (True, 2246)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2310), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 2313), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'.': (False, 23), '..': (False, 23), '~=': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '+': (False, 23), ']': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1757), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'local': (False, 31), 'return': (False, 31), '<': (False, 31), ',': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), 'EOF': (False, 31), '*': (False, 31), 'do': (False, 31), ';': (False, 31), 'repeat': (False, 31), 'for': (False, 31), '/': (False, 31), '>': (False, 31), 'NAME': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), ',': (False, 37), 'if': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), 'EOF': (False, 37), '*': (False, 37), 'do': (False, 37), 'repeat': (False, 37), 'for': (False, 37), '/': (False, 37), '>': (False, 37), ';': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), ',': (False, 38), 'tableconstructor': (True, 1766), 'if': (False, 38), '^': (False, 38), 'args': (True, 1765), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 1767), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 1763), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 1760), '+': (False, 38), '==': (False, 38), '{': (True, 1764), 'EMBEDSTAT': (False, 38), 'function': (False, 38), 'EOF': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 1761), ':': (True, 1762), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), ',': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '/': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), 'EOF': (False, 39), '*': (False, 39), 'do': (False, 39), 'goto': (False, 39), 'for': (False, 39), '>': (False, 39), ';': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 1768), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), ',': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), 'EOF': (False, 11), '*': (False, 11), 'do': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 1770), '(': (True, 1771)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), ',': (False, 35), '/': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'local': (False, 35), 'return': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), 'EOF': (False, 35), '*': (False, 35), 'do': (False, 35), 'repeat': (False, 35), 'for': (False, 35), '>': (False, 35), ';': (False, 35), '<=': (False, 35)}, {'::': (False, 64), 'break': (False, 64), 'if': (False, 64), 'EMBEDSTAT': (False, 64), 'function': (False, 64), 'EOF': (False, 64), 'do': (False, 64), 'while': (False, 64), 'NAME': (False, 64), 'goto': (False, 64), 'for': (False, 64), 'local': (False, 64), 'return': (False, 64), ';': (False, 64), '(': (False, 64), 'repeat': (False, 64)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 1773), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), '^': (False, 33), 'while': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'local': (False, 33), 'return': (False, 33), '<': (False, 33), ',': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'repeat': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), 'EOF': (False, 33), '*': (False, 33), 'do': (False, 33), ';': (False, 33), 'goto': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), 'NAME': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), ',': (False, 30), 'if': (False, 30), '^': (False, 30), 'while': (False, 30), '/': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), 'local': (False, 30), 'return': (False, 30), '<': (False, 30), 'NAME': (False, 30), '(': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), 'EOF': (False, 30), '*': (False, 30), 'do': (False, 30), 'goto': (False, 30), 'for': (False, 30), '>': (False, 30), ';': (False, 30), '<=': (False, 30)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1774), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), ',': (False, 84), '/': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), 'NAME': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), 'EOF': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), ';': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'local': (False, 36), 'return': (False, 36), 'and': (False, 36), ',': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), 'EOF': (False, 36), '*': (False, 36), 'do': (False, 36), 'NAME': (False, 36), 'repeat': (False, 36), 'for': (False, 36), '/': (False, 36), '>': (False, 36), ';': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ',': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), 'EOF': (False, 12), '*': (False, 12), 'do': (False, 12), ';': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1776), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'..': (True, 1777), '::': (False, 93), '~=': (True, 1787), 'break': (False, 93), '/': (True, 1792), '^': (True, 1785), 'while': (False, 93), '-': (True, 1778), 'and': (True, 1783), 'or': (True, 1789), 'explist__1': (True, 1784), 'local': (False, 93), 'return': (False, 93), '<': (True, 1786), ',': (True, 1780), '(': (False, 93), 'if': (False, 93), '>=': (True, 1790), '%': (True, 1791), 'goto': (False, 93), '+': (True, 1779), '==': (True, 1781), 'EMBEDSTAT': (False, 93), 'function': (False, 93), 'EOF': (False, 93), '*': (True, 1788), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '>': (True, 1782), 'NAME': (False, 93), '<=': (True, 1793)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), ',': (False, 32), 'if': (False, 32), '^': (False, 32), 'while': (False, 32), '-': (False, 32), '<': (False, 32), 'or': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), 'EOF': (False, 32), '*': (False, 32), 'do': (False, 32), 'goto': (False, 32), 'for': (False, 32), '/': (False, 32), '>': (False, 32), ';': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), ',': (False, 34), '>': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'local': (False, 34), 'return': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'if': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), 'EOF': (False, 34), '*': (False, 34), 'do': (False, 34), 'goto': (False, 34), 'for': (False, 34), '/': (False, 34), ';': (False, 34), '<=': (False, 34)}, {')': (True, 1942)}, {'end': (True, 2414)}, {'args': (True, 2416), '{': (True, 1253), 'tableconstructor': (True, 1251), '(': (True, 1250), 'STRING': (True, 1254)}, {')': (True, 2417)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), '-': (False, 6), 'and': (False, 6), 'or': (False, 6), '/': (False, 6), '<': (False, 6), 'then': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {')': (True, 1769)}, {'::': (False, 28), 'break': (False, 28), 'if': (False, 28), 'local': (False, 28), 'EMBEDSTAT': (False, 28), 'function': (False, 28), 'do': (False, 28), 'while': (False, 28), 'NAME': (False, 28), '=': (False, 28), 'goto': (False, 28), 'for': (False, 28), 'end': (False, 28), 'elseif': (False, 28), 'return': (False, 28), ';': (False, 28), '(': (False, 28), 'repeat': (False, 28), 'else': (False, 28)}, {'}': (True, 1899)}, {'args': (True, 1927), '{': (True, 1461), 'tableconstructor': (True, 1459), '(': (True, 1458), 'STRING': (True, 1462)}, {'}': (True, 1952)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '>': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '/': (False, 22), '[': (False, 22), '<': (False, 22), 'then': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), ',': (False, 57), 'if': (False, 57), '^': (True, 1785), 'while': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), 'EOF': (False, 57), '*': (False, 57), 'do': (False, 57), 'repeat': (False, 57), 'for': (False, 57), '/': (False, 57), '>': (False, 57), ';': (False, 57), '<=': (False, 57)}, {'end': (False, 99), 'stat__2': (True, 2209), 'else': (True, 1555)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '>': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'goto': (False, 9), '+': (False, 9), '==': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'repeat': (False, 9), 'for': (False, 9), 'end': (False, 9), 'elseif': (False, 9), ';': (False, 9), 'else': (False, 9), '<=': (False, 9)}, {'NAME': (True, 2215)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), ',': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'EOF': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2218)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2220), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2223), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), ',': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), 'NAME': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), 'EOF': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), ';': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '/': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), 'EOF': (False, 24), '*': (False, 24), 'do': (False, 24), ';': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '>': (False, 24), 'NAME': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2230), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'-': (True, 401), ')': (True, 2394), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'.': (False, 23), '::': (False, 23), 'break': (False, 23), '{': (False, 23), 'if': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'EOF': (False, 23), 'do': (False, 23), 'while': (False, 23), 'NAME': (False, 23), 'repeat': (False, 23), 'STRING': (False, 23), ':': (False, 23), 'for': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), ';': (False, 23), '(': (False, 23), 'goto': (False, 23)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), ',': (False, 62), 'if': (False, 62), '^': (False, 62), 'while': (False, 62), '/': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'repeat': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), 'EOF': (False, 62), '*': (False, 62), 'do': (False, 62), 'goto': (False, 62), 'for': (False, 62), '>': (False, 62), ';': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2399), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 2468), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'}': (True, 2136)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), ',': (False, 56), 'if': (False, 56), '^': (True, 1785), 'while': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), 'NAME': (False, 56), '(': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), 'EOF': (False, 56), '*': (False, 56), 'do': (False, 56), 'goto': (False, 56), 'for': (False, 56), '/': (False, 56), '>': (False, 56), ';': (False, 56), '<=': (False, 56)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), ',': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'until': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), 'NAME': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), '/': (False, 23), '>': (False, 23), ';': (False, 23), '<=': (False, 23)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 1785), 'while': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'local': (False, 55), 'return': (False, 55), '<': (False, 55), ',': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), 'EOF': (False, 55), '*': (False, 55), 'do': (False, 55), ';': (False, 55), 'goto': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'NAME': (False, 55), '<=': (False, 55)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1901), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1902), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1903), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1904), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1928), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1929), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1930), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'::': (False, 90), 'break': (False, 90), 'if': (False, 90), 'EMBEDSTAT': (False, 90), 'function': (False, 90), 'EOF': (False, 90), 'do': (False, 90), 'while': (False, 90), ';': (False, 90), 'goto': (False, 90), 'for': (False, 90), 'local': (False, 90), 'return': (False, 90), 'NAME': (False, 90), '(': (False, 90), 'repeat': (False, 90)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1931), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1933), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1935), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1937), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1938), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1939), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1940), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1941), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'exp': (True, 1943), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'args': (True, 1944), '{': (True, 864), 'tableconstructor': (True, 862), '(': (True, 861), 'STRING': (True, 865)}, {')': (True, 2467)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), ',': (False, 22), 'if': (False, 22), '^': (False, 22), 'while': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), '}': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '/': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'do': (True, 2143)}, {'}': (True, 2469)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), '==': (True, 1129), 'or': (True, 1130), '<': (True, 1135), '/': (True, 1132), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '>=': (True, 1138), ',': (True, 2138), '*': (True, 1137), '~=': (True, 1136), '%': (True, 1139), '<=': (True, 1140)}, {')': (True, 2154)}, {'..': (False, 50), '::': (False, 50), '~=': (False, 50), 'break': (False, 50), '>': (False, 50), '^': (True, 960), 'while': (False, 50), '-': (False, 50), '<': (False, 50), 'or': (False, 50), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ',': (False, 50), '(': (False, 50), 'if': (False, 50), '>=': (False, 50), '%': (True, 966), 'repeat': (False, 50), '+': (False, 50), '==': (False, 50), 'EMBEDSTAT': (False, 50), 'function': (False, 50), '*': (True, 963), 'do': (False, 50), 'NAME': (False, 50), 'goto': (False, 50), 'end': (False, 50), 'for': (False, 50), '/': (True, 967), ';': (False, 50), '<=': (False, 50)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), ',': (False, 57), 'if': (False, 57), '^': (True, 960), 'while': (False, 57), '/': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), '*': (False, 57), 'do': (False, 57), 'repeat': (False, 57), 'for': (False, 57), 'end': (False, 57), '>': (False, 57), ';': (False, 57), '<=': (False, 57)}, {'..': (True, 952), '::': (False, 48), '~=': (False, 48), 'break': (False, 48), ',': (False, 48), '>': (False, 48), '^': (True, 960), 'while': (False, 48), '-': (True, 953), '<': (False, 48), 'or': (False, 48), 'local': (False, 48), 'return': (False, 48), 'and': (False, 48), 'NAME': (False, 48), '(': (False, 48), 'if': (False, 48), '>=': (False, 48), '%': (True, 966), 'repeat': (False, 48), '+': (True, 954), '==': (False, 48), 'EMBEDSTAT': (False, 48), 'function': (False, 48), '*': (True, 963), 'do': (False, 48), 'goto': (False, 48), 'end': (False, 48), 'for': (False, 48), '/': (True, 967), ';': (False, 48), '<=': (False, 48)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2129), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'end': (True, 2163)}, {'..': (False, 49), '::': (False, 49), '~=': (False, 49), 'break': (False, 49), 'end': (False, 49), '^': (True, 960), 'while': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), 'local': (False, 49), 'return': (False, 49), '<': (False, 49), ',': (False, 49), '(': (False, 49), 'if': (False, 49), '>=': (False, 49), '%': (True, 966), 'repeat': (False, 49), '+': (False, 49), '==': (False, 49), 'EMBEDSTAT': (False, 49), 'function': (False, 49), '*': (True, 963), 'do': (False, 49), ';': (False, 49), 'goto': (False, 49), 'for': (False, 49), '/': (True, 967), '>': (False, 49), 'NAME': (False, 49), '<=': (False, 49)}, {'NAME': (True, 2182)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), ',': (False, 25), 'if': (False, 25), '^': (False, 25), 'end': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2186)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2189), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2192), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), ',': (False, 21), 'if': (False, 21), '^': (False, 21), 'end': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), 'NAME': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), ';': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '/': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), 'end': (False, 24), 'for': (False, 24), '>': (False, 24), ':': (False, 24), ';': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2203), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'..': (True, 952), '::': (False, 93), '~=': (True, 962), 'break': (False, 93), '/': (True, 967), '^': (True, 960), 'while': (False, 93), '-': (True, 953), 'and': (True, 958), 'or': (True, 964), 'explist__1': (True, 2210), 'local': (False, 93), 'return': (False, 93), '<': (True, 961), ',': (True, 955), '(': (False, 93), 'if': (False, 93), '>=': (True, 965), '%': (True, 966), 'goto': (False, 93), '+': (True, 954), '==': (True, 956), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 963), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'end': (False, 93), 'for': (False, 93), '>': (True, 957), 'NAME': (False, 93), '<=': (True, 968)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), '<': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), '}': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'..': (True, 952), '::': (False, 47), '~=': (False, 47), 'break': (False, 47), ',': (False, 47), '>': (False, 47), '^': (True, 960), 'while': (False, 47), '-': (True, 953), 'and': (False, 47), 'or': (False, 47), 'local': (False, 47), 'return': (False, 47), '<': (False, 47), 'NAME': (False, 47), '(': (False, 47), 'if': (False, 47), '>=': (False, 47), '%': (True, 966), 'goto': (False, 47), '+': (True, 954), '==': (False, 47), 'EMBEDSTAT': (False, 47), 'function': (False, 47), '*': (True, 963), 'do': (False, 47), 'repeat': (False, 47), 'end': (False, 47), 'for': (False, 47), '/': (True, 967), ';': (False, 47), '<=': (False, 47)}, {'::': (False, 104), 'break': (False, 104), 'if': (False, 104), 'EMBEDSTAT': (False, 104), 'function': (False, 104), 'do': (False, 104), 'while': (False, 104), ';': (False, 104), 'goto': (False, 104), 'for': (False, 104), 'until': (False, 104), 'local': (False, 104), 'return': (False, 104), 'NAME': (False, 104), '(': (False, 104), 'repeat': (False, 104)}, {'-': (True, 401), ')': (True, 2172), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (True, 952), '::': (False, 43), '~=': (False, 43), 'break': (False, 43), 'end': (False, 43), '^': (True, 960), 'while': (False, 43), '-': (True, 953), '<': (False, 43), 'or': (False, 43), 'local': (False, 43), 'return': (False, 43), 'and': (False, 43), ',': (False, 43), '(': (False, 43), 'if': (False, 43), '>=': (False, 43), '%': (True, 966), 'goto': (False, 43), '+': (True, 954), '==': (False, 43), 'EMBEDSTAT': (False, 43), 'function': (False, 43), '*': (True, 963), 'do': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), 'for': (False, 43), '/': (True, 967), '>': (False, 43), ';': (False, 43), '<=': (False, 43)}, {'..': (True, 952), '::': (False, 41), '~=': (True, 962), 'break': (False, 41), ',': (False, 41), '>': (True, 957), '^': (True, 960), 'while': (False, 41), '-': (True, 953), 'and': (False, 41), 'or': (False, 41), 'local': (False, 41), 'return': (False, 41), '<': (True, 961), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 965), '%': (True, 966), 'goto': (False, 41), '+': (True, 954), '==': (True, 956), 'EMBEDSTAT': (False, 41), 'function': (False, 41), '*': (True, 963), 'do': (False, 41), 'repeat': (False, 41), 'end': (False, 41), 'for': (False, 41), '/': (True, 967), ';': (False, 41), '<=': (True, 968)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 2236), ';': (False, 29), 'NAME': (False, 29), 'repeat': (False, 29), 'for': (False, 29), 'until': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 1038), '(': (False, 29), 'goto': (False, 29)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), ',': (False, 62), 'if': (False, 62), '^': (False, 62), 'while': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'repeat': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '*': (False, 62), 'do': (False, 62), 'goto': (False, 62), 'end': (False, 62), 'for': (False, 62), '/': (False, 62), '>': (False, 62), ';': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2238), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 54), '::': (False, 54), '~=': (False, 54), 'break': (False, 54), ',': (False, 54), 'if': (False, 54), '^': (True, 960), 'while': (False, 54), '/': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), 'local': (False, 54), 'return': (False, 54), 'and': (False, 54), 'NAME': (False, 54), '(': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '+': (False, 54), '==': (False, 54), 'EMBEDSTAT': (False, 54), 'function': (False, 54), '*': (False, 54), 'do': (False, 54), 'repeat': (False, 54), 'for': (False, 54), 'end': (False, 54), '>': (False, 54), ';': (False, 54), '<=': (False, 54)}, {'..': (True, 952), '::': (False, 42), '~=': (False, 42), 'break': (False, 42), ',': (False, 42), 'if': (False, 42), '^': (True, 960), 'while': (False, 42), '-': (True, 953), '<': (False, 42), 'or': (False, 42), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), '(': (False, 42), '>=': (False, 42), '%': (True, 966), 'repeat': (False, 42), '+': (True, 954), '==': (False, 42), 'EMBEDSTAT': (False, 42), 'function': (False, 42), '*': (True, 963), 'do': (False, 42), 'goto': (False, 42), 'end': (False, 42), 'for': (False, 42), '/': (True, 967), '>': (False, 42), ';': (False, 42), '<=': (False, 42)}, {'}': (True, 2217)}, {'..': (False, 23), '.': (False, 23), '+': (False, 23), ',': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), '}': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'..': (True, 952), '::': (False, 46), '~=': (False, 46), 'break': (False, 46), ',': (False, 46), 'end': (False, 46), '^': (True, 960), 'while': (False, 46), '-': (True, 953), '<': (False, 46), 'or': (False, 46), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), 'NAME': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 966), 'goto': (False, 46), '+': (True, 954), '==': (False, 46), 'EMBEDSTAT': (False, 46), 'function': (False, 46), '*': (True, 963), 'do': (False, 46), 'repeat': (False, 46), 'for': (False, 46), '/': (True, 967), '>': (False, 46), ';': (False, 46), '<=': (False, 46)}, {'::': (False, 76), 'break': (False, 76), 'if': (False, 76), 'EMBEDSTAT': (False, 76), 'function': (False, 76), 'do': (False, 76), 'while': (False, 76), ';': (False, 76), 'goto': (False, 76), 'for': (False, 76), 'until': (False, 76), 'local': (False, 76), 'return': (False, 76), 'NAME': (False, 76), '(': (False, 76), 'repeat': (False, 76)}, {'::': (False, 76), 'break': (False, 76), 'if': (False, 76), 'local': (False, 76), 'EMBEDSTAT': (False, 76), 'function': (False, 76), 'do': (False, 76), 'while': (False, 76), ';': (False, 76), 'repeat': (False, 76), 'for': (False, 76), 'end': (False, 76), 'elseif': (False, 76), 'return': (False, 76), 'NAME': (False, 76), '(': (False, 76), 'goto': (False, 76), 'else': (False, 76)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), ',': (False, 51), 'if': (False, 51), '^': (True, 960), 'while': (False, 51), '/': (False, 51), '-': (False, 51), 'and': (False, 51), 'or': (False, 51), 'local': (False, 51), 'return': (False, 51), '<': (False, 51), 'NAME': (False, 51), '(': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '+': (False, 51), '==': (False, 51), 'EMBEDSTAT': (False, 51), 'function': (False, 51), '*': (False, 51), 'do': (False, 51), 'goto': (False, 51), 'end': (False, 51), 'for': (False, 51), '>': (False, 51), ';': (False, 51), '<=': (False, 51)}, {'::': (False, 69), 'break': (False, 69), 'if': (False, 69), 'EMBEDSTAT': (False, 69), 'function': (False, 69), 'EOF': (False, 69), 'do': (False, 69), 'while': (False, 69), 'NAME': (False, 69), 'repeat': (False, 69), 'for': (False, 69), 'local': (False, 69), 'return': (False, 69), ';': (False, 69), '(': (False, 69), 'goto': (False, 69)}, {'}': (True, 2139)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 1630), '+': (False, 50), '*': (True, 1637), ';': (False, 50), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), 'until': (False, 50), '/': (True, 1631), '<': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 1639), '<=': (False, 50)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), '==': (True, 1129), 'or': (True, 1130), '<': (True, 1135), '/': (True, 1132), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '>=': (True, 1138), ',': (True, 1900), '*': (True, 1137), '~=': (True, 1136), '%': (True, 1139), '<=': (True, 1140)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), ',': (False, 57), 'if': (False, 57), '^': (True, 1887), 'while': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), '*': (False, 57), 'do': (False, 57), 'repeat': (False, 57), 'for': (False, 57), '/': (False, 57), '>': (False, 57), ';': (False, 57), '?>': (False, 57), '<=': (False, 57)}, {'..': (False, 9), '::': (False, 9), '+': (False, 9), 'break': (False, 9), '==': (False, 9), 'if': (False, 9), '<': (False, 9), '^': (False, 9), 'function': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), 'while': (False, 9), ';': (False, 9), '/': (False, 9), 'goto': (False, 9), '-': (False, 9), 'EMBEDSTAT': (False, 9), 'or': (False, 9), 'end': (False, 9), 'local': (False, 9), 'return': (False, 9), '>': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), 'for': (False, 9), '>=': (False, 9), '%': (False, 9), 'repeat': (False, 9), '<=': (False, 9)}, {'-': (True, 401), ')': (True, 2053), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 1630), '~=': (False, 55), '*': (False, 55), ';': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'until': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {'until': (False, 108)}, {'until': (False, 88)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 48), '>': (False, 48), '^': (True, 1630), '~=': (False, 48), '*': (True, 1637), ';': (False, 48), '-': (True, 1625), '<': (False, 48), 'or': (False, 48), 'until': (False, 48), '/': (True, 1631), 'and': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 1639), '<=': (False, 48)}, {'NAME': (True, 2051)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), ',': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '?>': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2052)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2054), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2057), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), ',': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), 'NAME': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), ';': (False, 21), '?>': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '/': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), ',': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'NAME': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '>': (False, 24), ';': (False, 24), '?>': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2065), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'..': (False, 49), '~=': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 1630), '+': (False, 49), '*': (True, 1637), ';': (False, 49), '-': (False, 49), '<': (False, 49), 'or': (False, 49), 'until': (False, 49), '/': (True, 1631), 'and': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 1639), '<=': (False, 49)}, {')': (True, 2250)}, {'..': (True, 1624), '-': (True, 1625), '+': (True, 1626), '==': (True, 1628), 'or': (True, 1629), 'until': (False, 93), '<': (True, 1635), '/': (True, 1631), '>': (True, 1632), 'explist__1': (True, 2448), 'and': (True, 1634), '^': (True, 1630), '>=': (True, 1638), ',': (True, 1627), '*': (True, 1637), '~=': (True, 1636), '%': (True, 1639), ';': (False, 93), '<=': (True, 1640)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'until': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), ';': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '/': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'-': (True, 401), ')': (True, 2305), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 47), '>': (False, 47), '^': (True, 1630), '~=': (False, 47), '*': (True, 1637), ';': (False, 47), '-': (True, 1625), 'and': (False, 47), 'or': (False, 47), 'until': (False, 47), '/': (True, 1631), '<': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 1639), '<=': (False, 47)}, {'..': (True, 1624), '-': (True, 1625), '+': (True, 1626), ',': (False, 40), '==': (True, 1628), '/': (True, 1631), 'until': (False, 40), '<': (True, 1635), '>': (True, 1632), 'and': (True, 1634), '^': (True, 1630), '~=': (True, 1636), '*': (True, 1637), 'or': (False, 40), '>=': (True, 1638), '%': (True, 1639), ';': (False, 40), '<=': (True, 1640)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 1630), '~=': (False, 54), '*': (False, 54), ';': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), 'until': (False, 54), '/': (False, 54), '<': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), ',': (False, 62), 'if': (False, 62), '^': (False, 62), 'while': (False, 62), '/': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'repeat': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '*': (False, 62), 'do': (False, 62), 'goto': (False, 62), 'for': (False, 62), '>': (False, 62), ';': (False, 62), '?>': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 1954), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 1998), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {')': (True, 2001)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 1630), '+': (False, 52), '*': (False, 52), ';': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), 'until': (False, 52), '/': (False, 52), 'and': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 43), '>': (False, 43), '^': (True, 1630), '~=': (False, 43), '*': (True, 1637), ';': (False, 43), '-': (True, 1625), 'and': (False, 43), 'or': (False, 43), 'until': (False, 43), '/': (True, 1631), '<': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 1639), '<=': (False, 43)}, {'}': (True, 2225)}, {'..': (True, 1624), '-': (True, 1625), '+': (True, 1626), ',': (False, 41), '==': (True, 1628), '/': (True, 1631), 'until': (False, 41), '<': (True, 1635), '>': (True, 1632), 'and': (False, 41), '^': (True, 1630), '~=': (True, 1636), '*': (True, 1637), 'or': (False, 41), '>=': (True, 1638), '%': (True, 1639), ';': (False, 41), '<=': (True, 1640)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 42), '>': (False, 42), '^': (True, 1630), '~=': (False, 42), '*': (True, 1637), ';': (False, 42), '-': (True, 1625), 'and': (False, 42), 'or': (False, 42), 'until': (False, 42), '/': (True, 1631), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 1639), '<=': (False, 42)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 46), '>': (False, 46), '^': (True, 1630), '~=': (False, 46), '*': (True, 1637), ';': (False, 46), '-': (True, 1625), 'and': (False, 46), 'or': (False, 46), 'until': (False, 46), '/': (True, 1631), '<': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 1639), '<=': (False, 46)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), ',': (False, 56), 'if': (False, 56), '^': (True, 1887), 'while': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), 'NAME': (False, 56), '(': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), '*': (False, 56), 'do': (False, 56), 'goto': (False, 56), 'for': (False, 56), '/': (False, 56), '>': (False, 56), ';': (False, 56), '?>': (False, 56), '<=': (False, 56)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 1630), '~=': (False, 51), '*': (False, 51), ';': (False, 51), '-': (False, 51), '<': (False, 51), 'or': (False, 51), 'until': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 45), '>': (False, 45), '^': (True, 1630), '~=': (False, 45), '*': (True, 1637), ';': (False, 45), '-': (True, 1625), '<': (False, 45), 'or': (False, 45), 'until': (False, 45), '/': (True, 1631), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 1639), '<=': (False, 45)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 1630), '~=': (False, 53), '*': (False, 53), ';': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), 'until': (False, 53), '/': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {';': (False, 92), '?>': (False, 92)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), ',': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '(': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), ';': (False, 13), '?>': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), 'elseif': (False, 13), '^': (False, 13), 'while': (False, 13), '/': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), ';': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), 'end': (False, 13), '>': (False, 13), 'NAME': (False, 13), 'else': (False, 13), '<=': (False, 13)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 1887), 'while': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'local': (False, 55), 'return': (False, 55), '<': (False, 55), ',': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), '*': (False, 55), 'do': (False, 55), ';': (False, 55), 'goto': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'NAME': (False, 55), '?>': (False, 55), '<=': (False, 55)}, {'..': (True, 1624), '+': (True, 1626), '==': (False, 44), '>': (False, 44), '^': (True, 1630), '~=': (False, 44), '*': (True, 1637), ';': (False, 44), '-': (True, 1625), '<': (False, 44), 'or': (False, 44), 'until': (False, 44), '/': (True, 1631), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 1639), '<=': (False, 44)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2055), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2047), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2056), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2058), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'function': (True, 1336), '#': (True, 1342), 'nil': (True, 1341), 'STRING': (True, 1349), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'NAME': (True, 1343), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2060), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2062), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2066), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'::': (False, 90), 'break': (False, 90), '?>': (False, 90), 'if': (False, 90), 'EMBEDSTAT': (False, 90), 'function': (False, 90), 'do': (False, 90), 'while': (False, 90), ';': (False, 90), 'goto': (False, 90), 'for': (False, 90), 'local': (False, 90), 'return': (False, 90), 'NAME': (False, 90), '(': (False, 90), 'repeat': (False, 90)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2070), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2071), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2072), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2076), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2078), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2081), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2084), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2086), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'-': (True, 1329), 'false': (True, 1330), 'functiondef': (True, 1331), 'exp': (True, 2088), 'functioncall': (True, 1345), 'var': (True, 1335), 'tableconstructor': (True, 1333), 'EMBEDEXPR': (True, 1337), '{': (True, 1339), 'nil': (True, 1341), '#': (True, 1342), 'NAME': (True, 1343), 'function': (True, 1336), 'true': (True, 1348), '(': (True, 1334), 'not': (True, 1346), 'prefixexp': (True, 1332), 'STRING': (True, 1349), '...': (True, 1344), 'NUMBER': (True, 1340)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), ',': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), '}': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), ';': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'until': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), 'NAME': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '/': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), '}': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), '>': (False, 23), 'NAME': (False, 23), '<=': (False, 23)}, {'.': (False, 9), ':': (False, 9), '(': (False, 9), '{': (False, 9), '[': (False, 9), 'STRING': (False, 9)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 2300), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (True, 1777), '::': (False, 48), '~=': (False, 48), 'break': (False, 48), ',': (False, 48), 'if': (False, 48), '^': (True, 1785), 'while': (False, 48), '-': (True, 1778), '<': (False, 48), 'or': (False, 48), 'local': (False, 48), 'return': (False, 48), 'and': (False, 48), 'NAME': (False, 48), '(': (False, 48), '>=': (False, 48), '%': (True, 1791), 'repeat': (False, 48), '+': (True, 1779), '==': (False, 48), 'EMBEDSTAT': (False, 48), 'function': (False, 48), 'EOF': (False, 48), '*': (True, 1788), 'do': (False, 48), 'goto': (False, 48), 'for': (False, 48), '/': (True, 1792), '>': (False, 48), ';': (False, 48), '<=': (False, 48)}, {'..': (False, 50), '::': (False, 50), '~=': (False, 50), 'break': (False, 50), 'if': (False, 50), '^': (True, 1785), 'while': (False, 50), '-': (False, 50), '<': (False, 50), 'or': (False, 50), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ',': (False, 50), '(': (False, 50), '>=': (False, 50), '%': (True, 1791), 'goto': (False, 50), '+': (False, 50), '==': (False, 50), 'EMBEDSTAT': (False, 50), 'function': (False, 50), 'EOF': (False, 50), '*': (True, 1788), 'do': (False, 50), 'NAME': (False, 50), 'repeat': (False, 50), 'for': (False, 50), '/': (True, 1792), '>': (False, 50), ';': (False, 50), '<=': (False, 50)}, {'..': (False, 49), '::': (False, 49), '~=': (False, 49), 'break': (False, 49), 'if': (False, 49), '^': (True, 1785), 'while': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), 'local': (False, 49), 'return': (False, 49), '<': (False, 49), ',': (False, 49), '(': (False, 49), '>=': (False, 49), '%': (True, 1791), 'goto': (False, 49), '+': (False, 49), '==': (False, 49), 'EMBEDSTAT': (False, 49), 'function': (False, 49), 'EOF': (False, 49), '*': (True, 1788), 'do': (False, 49), ';': (False, 49), 'repeat': (False, 49), 'for': (False, 49), '/': (True, 1792), '>': (False, 49), 'NAME': (False, 49), '<=': (False, 49)}, {'..': (True, 1777), '::': (False, 93), '~=': (True, 1787), 'break': (False, 93), '/': (True, 1792), '^': (True, 1785), 'while': (False, 93), '-': (True, 1778), 'and': (True, 1783), 'or': (True, 1789), 'explist__1': (True, 2423), 'local': (False, 93), 'return': (False, 93), '<': (True, 1786), ',': (True, 1780), '(': (False, 93), 'if': (False, 93), '>=': (True, 1790), '%': (True, 1791), 'goto': (False, 93), '+': (True, 1779), '==': (True, 1781), 'EMBEDSTAT': (False, 93), 'function': (False, 93), 'EOF': (False, 93), '*': (True, 1788), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '>': (True, 1782), 'NAME': (False, 93), '<=': (True, 1793)}, {'..': (False, 39), '+': (False, 39), '==': (False, 39), '>': (False, 39), '^': (False, 39), '~=': (False, 39), 'EOF': (False, 39), '*': (False, 39), ';': (False, 39), '-': (False, 39), 'and': (False, 39), 'or': (False, 39), '/': (False, 39), '<': (False, 39), ',': (False, 39), '>=': (False, 39), '%': (False, 39), '<=': (False, 39)}, {'..': (False, 35), '+': (False, 35), '==': (False, 35), '>': (False, 35), '^': (False, 35), '~=': (False, 35), 'EOF': (False, 35), '*': (False, 35), ';': (False, 35), '-': (False, 35), '<': (False, 35), 'or': (False, 35), '/': (False, 35), 'and': (False, 35), ',': (False, 35), '>=': (False, 35), '%': (False, 35), '<=': (False, 35)}, {'funcbody': (True, 2184), '(': (True, 2185)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2187), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'.': (False, 12), '..': (False, 12), '~=': (False, 12), ',': (False, 12), '==': (False, 12), '{': (False, 12), '>': (False, 12), '^': (False, 12), '+': (False, 12), 'EOF': (False, 12), '*': (False, 12), 'STRING': (False, 12), '-': (False, 12), '<': (False, 12), ':': (False, 12), 'or': (False, 12), '/': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), '<=': (False, 12)}, {'.': (True, 2194), '..': (False, 38), '~=': (False, 38), '==': (False, 38), '{': (True, 2198), '/': (False, 38), '^': (False, 38), '+': (False, 38), 'EOF': (False, 38), '*': (False, 38), 'args': (True, 2199), ';': (False, 38), 'STRING': (True, 2195), '-': (False, 38), '<': (False, 38), ':': (True, 2196), 'or': (False, 38), 'tableconstructor': (True, 2200), '>': (False, 38), '[': (True, 2201), 'and': (False, 38), ',': (False, 38), '(': (True, 2197), '>=': (False, 38), '%': (False, 38), '<=': (False, 38)}, {'..': (False, 32), '~=': (False, 32), '==': (False, 32), '/': (False, 32), '^': (False, 32), '+': (False, 32), 'EOF': (False, 32), '*': (False, 32), ';': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), '>': (False, 32), '<': (False, 32), ',': (False, 32), '>=': (False, 32), '%': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '~=': (False, 34), '==': (False, 34), '/': (False, 34), '^': (False, 34), '+': (False, 34), 'EOF': (False, 34), '*': (False, 34), ';': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), '>': (False, 34), '<': (False, 34), ',': (False, 34), '>=': (False, 34), '%': (False, 34), '<=': (False, 34)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2204), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'..': (False, 31), '~=': (False, 31), '==': (False, 31), '>': (False, 31), '^': (False, 31), '+': (False, 31), 'EOF': (False, 31), '*': (False, 31), ';': (False, 31), '-': (False, 31), '<': (False, 31), 'or': (False, 31), '/': (False, 31), 'and': (False, 31), ',': (False, 31), '>=': (False, 31), '%': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '+': (False, 37), '==': (False, 37), '/': (False, 37), '^': (False, 37), '~=': (False, 37), 'EOF': (False, 37), '*': (False, 37), ';': (False, 37), '-': (False, 37), 'and': (False, 37), 'or': (False, 37), '>': (False, 37), '<': (False, 37), ',': (False, 37), '>=': (False, 37), '%': (False, 37), '<=': (False, 37)}, {';': (False, 106), 'EOF': (False, 106)}, {'..': (False, 11), '.': (False, 11), '~=': (False, 11), ',': (False, 11), '==': (False, 11), '{': (False, 11), '>': (False, 11), '^': (False, 11), '+': (False, 11), 'EOF': (False, 11), '*': (False, 11), 'STRING': (False, 11), '-': (False, 11), '<': (False, 11), ':': (False, 11), 'or': (False, 11), '/': (False, 11), '[': (False, 11), 'and': (False, 11), ';': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), '<=': (False, 11)}, {'..': (True, 2277), '-': (True, 2278), '+': (True, 2279), '==': (True, 2281), 'or': (True, 2282), '<': (True, 2288), '/': (True, 2284), '>': (True, 2285), 'explist__1': (True, 2286), 'and': (True, 2283), '^': (True, 2287), '>=': (True, 2291), ',': (True, 2280), 'EOF': (False, 93), '*': (True, 2290), '~=': (True, 2289), '%': (True, 2292), ';': (False, 93), '<=': (True, 2293)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2296), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 30), '+': (False, 30), '==': (False, 30), '>': (False, 30), '^': (False, 30), '~=': (False, 30), 'EOF': (False, 30), '*': (False, 30), ';': (False, 30), '-': (False, 30), '<': (False, 30), 'or': (False, 30), '/': (False, 30), 'and': (False, 30), ',': (False, 30), '>=': (False, 30), '%': (False, 30), '<=': (False, 30)}, {'..': (False, 84), '.': (False, 84), '~=': (False, 84), ',': (False, 84), '==': (False, 84), '{': (False, 84), '>': (False, 84), '^': (False, 84), '+': (False, 84), 'EOF': (False, 84), '*': (False, 84), 'STRING': (False, 84), '-': (False, 84), 'and': (False, 84), ':': (False, 84), 'or': (False, 84), '/': (False, 84), '[': (False, 84), '<': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), '<=': (False, 84)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'prefixexp': (True, 293), 'functioncall': (True, 291), 'var': (True, 282), 'function': (True, 283), 'EMBEDEXPR': (True, 284), 'tableconstructor': (True, 280), 'NUMBER': (True, 295), 'nil': (True, 286), '#': (True, 287), 'NAME': (True, 288), 'true': (True, 294), '(': (True, 281), '{': (True, 285), 'not': (True, 292), 'exp': (True, 2301), '...': (True, 290), 'STRING': (True, 289)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2302), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'retstat__2': (True, 2306), ';': (True, 2307), 'EOF': (False, 89)}, {'..': (False, 36), '+': (False, 36), '==': (False, 36), '/': (False, 36), '^': (False, 36), '~=': (False, 36), 'EOF': (False, 36), '*': (False, 36), ';': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '>': (False, 36), 'and': (False, 36), ',': (False, 36), '>=': (False, 36), '%': (False, 36), '<=': (False, 36)}, {'..': (False, 33), '+': (False, 33), '==': (False, 33), '/': (False, 33), '^': (False, 33), '~=': (False, 33), 'EOF': (False, 33), '*': (False, 33), ';': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), '>': (False, 33), '<': (False, 33), ',': (False, 33), '>=': (False, 33), '%': (False, 33), '<=': (False, 33)}, {'.': (False, 22), '::': (False, 22), 'break': (False, 22), '{': (False, 22), 'if': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'EOF': (False, 22), 'do': (False, 22), 'while': (False, 22), 'NAME': (False, 22), 'repeat': (False, 22), 'STRING': (False, 22), ':': (False, 22), 'for': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), ';': (False, 22), '(': (False, 22), 'goto': (False, 22)}, {'..': (True, 1777), '::': (False, 47), '~=': (False, 47), 'break': (False, 47), ',': (False, 47), 'if': (False, 47), '^': (True, 1785), 'while': (False, 47), '-': (True, 1778), 'and': (False, 47), 'or': (False, 47), 'local': (False, 47), 'return': (False, 47), '<': (False, 47), 'NAME': (False, 47), '(': (False, 47), '>=': (False, 47), '%': (True, 1791), 'goto': (False, 47), '+': (True, 1779), '==': (False, 47), 'EMBEDSTAT': (False, 47), 'function': (False, 47), 'EOF': (False, 47), '*': (True, 1788), 'do': (False, 47), 'repeat': (False, 47), 'for': (False, 47), '/': (True, 1792), '>': (False, 47), ';': (False, 47), '<=': (False, 47)}, {'..': (True, 1777), '::': (False, 43), '~=': (False, 43), 'break': (False, 43), '>': (False, 43), '^': (True, 1785), 'while': (False, 43), '-': (True, 1778), '<': (False, 43), 'or': (False, 43), 'local': (False, 43), 'return': (False, 43), 'and': (False, 43), ',': (False, 43), '(': (False, 43), 'if': (False, 43), '>=': (False, 43), '%': (True, 1791), 'goto': (False, 43), '+': (True, 1779), '==': (False, 43), 'EMBEDSTAT': (False, 43), 'function': (False, 43), 'EOF': (False, 43), '*': (True, 1788), 'do': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), 'for': (False, 43), '/': (True, 1792), ';': (False, 43), '<=': (False, 43)}, {'..': (True, 1777), '::': (False, 41), '~=': (True, 1787), 'break': (False, 41), ',': (False, 41), '>': (True, 1782), '^': (True, 1785), 'while': (False, 41), '-': (True, 1778), 'and': (False, 41), 'or': (False, 41), 'local': (False, 41), 'return': (False, 41), '<': (True, 1786), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1790), '%': (True, 1791), 'goto': (False, 41), '+': (True, 1779), '==': (True, 1781), 'EMBEDSTAT': (False, 41), 'function': (False, 41), 'EOF': (False, 41), '*': (True, 1788), 'do': (False, 41), 'repeat': (False, 41), 'for': (False, 41), '/': (True, 1792), ';': (False, 41), '<=': (True, 1793)}, {'..': (False, 54), '::': (False, 54), '~=': (False, 54), 'break': (False, 54), ',': (False, 54), 'if': (False, 54), '^': (True, 1785), 'while': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), 'local': (False, 54), 'return': (False, 54), 'and': (False, 54), 'NAME': (False, 54), '(': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '+': (False, 54), '==': (False, 54), 'EMBEDSTAT': (False, 54), 'function': (False, 54), 'EOF': (False, 54), '*': (False, 54), 'do': (False, 54), 'repeat': (False, 54), 'for': (False, 54), '/': (False, 54), '>': (False, 54), ';': (False, 54), '<=': (False, 54)}, {'::': (False, 91), 'break': (False, 91), 'if': (False, 91), 'EMBEDSTAT': (False, 91), 'function': (False, 91), 'EOF': (False, 91), 'do': (False, 91), 'while': (False, 91), ';': (False, 91), 'goto': (False, 91), 'for': (False, 91), 'local': (False, 91), 'return': (False, 91), 'NAME': (False, 91), '(': (False, 91), 'repeat': (False, 91)}, {'..': (True, 1777), '::': (False, 42), '~=': (False, 42), 'break': (False, 42), ',': (False, 42), 'if': (False, 42), '^': (True, 1785), 'while': (False, 42), '-': (True, 1778), '<': (False, 42), 'or': (False, 42), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), '(': (False, 42), '>=': (False, 42), '%': (True, 1791), 'repeat': (False, 42), '+': (True, 1779), '==': (False, 42), 'EMBEDSTAT': (False, 42), 'function': (False, 42), 'EOF': (False, 42), '*': (True, 1788), 'do': (False, 42), 'goto': (False, 42), 'for': (False, 42), '/': (True, 1792), '>': (False, 42), ';': (False, 42), '<=': (False, 42)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'while': (False, 85), 'NAME': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), '}': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {'..': (True, 1777), '::': (False, 46), '~=': (False, 46), 'break': (False, 46), ',': (False, 46), '>': (False, 46), '^': (True, 1785), 'while': (False, 46), '-': (True, 1778), '<': (False, 46), 'or': (False, 46), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), 'NAME': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 1791), 'goto': (False, 46), '+': (True, 1779), '==': (False, 46), 'EMBEDSTAT': (False, 46), 'function': (False, 46), 'EOF': (False, 46), '*': (True, 1788), 'do': (False, 46), 'repeat': (False, 46), 'for': (False, 46), '/': (True, 1792), ';': (False, 46), '<=': (False, 46)}, {'end': (True, 2314)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), ',': (False, 51), 'if': (False, 51), '^': (True, 1785), 'while': (False, 51), '/': (False, 51), '-': (False, 51), 'and': (False, 51), 'or': (False, 51), 'local': (False, 51), 'return': (False, 51), '<': (False, 51), 'NAME': (False, 51), '(': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '+': (False, 51), '==': (False, 51), 'EMBEDSTAT': (False, 51), 'function': (False, 51), 'EOF': (False, 51), '*': (False, 51), 'do': (False, 51), 'goto': (False, 51), 'for': (False, 51), '>': (False, 51), ';': (False, 51), '<=': (False, 51)}, {'..': (True, 1777), '::': (False, 40), '~=': (True, 1787), 'break': (False, 40), ',': (False, 40), '>': (True, 1782), '^': (True, 1785), 'while': (False, 40), '-': (True, 1778), 'and': (True, 1783), 'or': (False, 40), 'local': (False, 40), 'return': (False, 40), '<': (True, 1786), 'NAME': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 1790), '%': (True, 1791), 'goto': (False, 40), '+': (True, 1779), '==': (True, 1781), 'EMBEDSTAT': (False, 40), 'function': (False, 40), 'EOF': (False, 40), '*': (True, 1788), 'do': (False, 40), 'repeat': (False, 40), 'for': (False, 40), '/': (True, 1792), ';': (False, 40), '<=': (True, 1793)}, {'..': (True, 1777), '::': (False, 45), '~=': (False, 45), 'break': (False, 45), ',': (False, 45), 'if': (False, 45), '^': (True, 1785), 'while': (False, 45), '-': (True, 1778), '<': (False, 45), 'or': (False, 45), 'local': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), '>=': (False, 45), '%': (True, 1791), 'goto': (False, 45), '+': (True, 1779), '==': (False, 45), 'EMBEDSTAT': (False, 45), 'function': (False, 45), 'EOF': (False, 45), '*': (True, 1788), 'do': (False, 45), 'repeat': (False, 45), 'for': (False, 45), '/': (True, 1792), '>': (False, 45), ';': (False, 45), '<=': (False, 45)}, {'..': (False, 53), '::': (False, 53), '~=': (False, 53), 'break': (False, 53), 'if': (False, 53), '^': (True, 1785), 'while': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), ',': (False, 53), '(': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '+': (False, 53), '==': (False, 53), 'EMBEDSTAT': (False, 53), 'function': (False, 53), 'EOF': (False, 53), '*': (False, 53), 'do': (False, 53), 'NAME': (False, 53), 'repeat': (False, 53), 'for': (False, 53), '/': (False, 53), '>': (False, 53), ';': (False, 53), '<=': (False, 53)}, {'..': (False, 52), '::': (False, 52), '~=': (False, 52), 'break': (False, 52), ',': (False, 52), 'if': (False, 52), '^': (True, 1785), 'while': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), 'local': (False, 52), 'return': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), '>=': (False, 52), '%': (False, 52), 'goto': (False, 52), '+': (False, 52), '==': (False, 52), 'EMBEDSTAT': (False, 52), 'function': (False, 52), 'EOF': (False, 52), '*': (False, 52), 'do': (False, 52), 'repeat': (False, 52), 'for': (False, 52), '/': (False, 52), '>': (False, 52), ';': (False, 52), '<=': (False, 52)}, {'.': (False, 23), ':': (False, 23), '(': (False, 23), '{': (False, 23), '[': (False, 23), 'STRING': (False, 23)}, {'..': (True, 1777), '::': (False, 44), '~=': (False, 44), 'break': (False, 44), ',': (False, 44), 'if': (False, 44), '^': (True, 1785), 'while': (False, 44), '-': (True, 1778), 'and': (False, 44), 'or': (False, 44), 'local': (False, 44), 'return': (False, 44), '<': (False, 44), 'NAME': (False, 44), '(': (False, 44), '>=': (False, 44), '%': (True, 1791), 'repeat': (False, 44), '+': (True, 1779), '==': (False, 44), 'EMBEDSTAT': (False, 44), 'function': (False, 44), 'EOF': (False, 44), '*': (True, 1788), 'do': (False, 44), 'goto': (False, 44), 'for': (False, 44), '/': (True, 1792), '>': (False, 44), ';': (False, 44), '<=': (False, 44)}, {'.': (False, 22), '::': (False, 22), 'break': (False, 22), '{': (False, 22), 'if': (False, 22), 'elseif': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'do': (False, 22), 'while': (False, 22), ';': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), 'end': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), 'NAME': (False, 22), '(': (False, 22), 'STRING': (False, 22), 'else': (False, 22)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'until': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), '==': (True, 234), 'or': (True, 235), '<': (True, 240), '/': (True, 237), '>': (True, 238), 'explist__1': (True, 2346), 'and': (True, 236), '^': (True, 239), '>=': (True, 243), ',': (True, 1509), '*': (True, 242), '~=': (True, 241), '%': (True, 244), ';': (False, 93), '}': (False, 93), '<=': (True, 245)}, {'}': (True, 2090)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), '*': (False, 62), ';': (False, 62), '/': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), 'end': (False, 62), 'elseif': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), 'else': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2098), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '/': (False, 56), 'elseif': (False, 56), '^': (True, 1973), '~=': (False, 56), '*': (False, 56), ';': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), 'end': (False, 56), '>': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), 'else': (False, 56), '<=': (False, 56)}, {'.': (False, 9), '::': (False, 9), 'break': (False, 9), '{': (False, 9), 'if': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'repeat': (False, 9), 'do': (False, 9), 'while': (False, 9), '}': (False, 9), 'STRING': (False, 9), ':': (False, 9), 'for': (False, 9), 'NAME': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), ';': (False, 9), '(': (False, 9), 'goto': (False, 9)}, {'.': (False, 9), '::': (False, 9), 'break': (False, 9), '{': (False, 9), 'if': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'repeat': (False, 9), 'EOF': (False, 9), 'do': (False, 9), 'while': (False, 9), 'NAME': (False, 9), 'STRING': (False, 9), ':': (False, 9), 'for': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), ';': (False, 9), '(': (False, 9), 'goto': (False, 9)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 1973), '~=': (False, 57), '*': (False, 57), ';': (False, 57), '/': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), 'end': (False, 57), 'elseif': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), 'else': (False, 57), '<=': (False, 57)}, {')': (True, 2374)}, {'NAME': (True, 2375)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), ',': (False, 25), '==': (False, 25), '{': (False, 25), '/': (False, 25), '^': (False, 25), '~=': (False, 25), '*': (False, 25), 'end': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '>': (False, 25), 'elseif': (False, 25), '[': (False, 25), '<': (False, 25), ';': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'else': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2376)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2377), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2378), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '.': (False, 21), '+': (False, 21), ',': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), '*': (False, 21), 'end': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '>': (False, 21), 'elseif': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'else': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), ',': (False, 24), '==': (False, 24), '{': (False, 24), 'end': (False, 24), 'elseif': (False, 24), '^': (False, 24), '~=': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '/': (False, 24), '>': (False, 24), '[': (False, 24), 'and': (False, 24), ';': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'else': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 2382), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), ',': (False, 22), 'if': (False, 22), '^': (False, 22), 'while': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'until': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '/': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2073), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2074), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2077), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2079), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2083), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2085), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2087), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2089), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {';': (False, 90), 'end': (False, 90), 'elseif': (False, 90), 'else': (False, 90)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2092), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2093), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2094), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2096), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2097), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2099), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2100), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1595), 'false': (True, 1596), 'functiondef': (True, 1597), 'exp': (True, 2101), 'functioncall': (True, 1591), 'var': (True, 1599), 'tableconstructor': (True, 1601), 'EMBEDEXPR': (True, 1588), '{': (True, 1587), 'function': (True, 1589), '#': (True, 1590), 'nil': (True, 1602), 'STRING': (True, 1594), 'true': (True, 1593), '(': (True, 1604), 'not': (True, 1605), 'prefixexp': (True, 1598), 'NAME': (True, 1603), '...': (True, 1607), 'NUMBER': (True, 1608)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2348), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'..': (False, 31), '::': (False, 31), '+': (False, 31), 'break': (False, 31), '==': (False, 31), 'if': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '~=': (False, 31), 'EOF': (False, 31), '*': (False, 31), 'do': (False, 31), 'while': (False, 31), '/': (False, 31), 'repeat': (False, 31), '-': (False, 31), '^': (False, 31), 'or': (False, 31), '>': (False, 31), 'local': (False, 31), 'return': (False, 31), 'and': (False, 31), '<': (False, 31), 'NAME': (False, 31), ';': (False, 31), '(': (False, 31), 'for': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), '==': (False, 37), 'if': (False, 37), '^': (False, 37), 'local': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '+': (False, 37), 'EOF': (False, 37), '*': (False, 37), 'do': (False, 37), 'while': (False, 37), 'NAME': (False, 37), 'repeat': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), '/': (False, 37), '>': (False, 37), 'return': (False, 37), 'and': (False, 37), ';': (False, 37), '(': (False, 37), 'for': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), 'tableconstructor': (True, 2359), 'if': (False, 38), '^': (False, 38), 'args': (True, 2358), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 2360), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 2356), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 2353), '+': (False, 38), '==': (False, 38), '{': (True, 2357), 'EMBEDSTAT': (False, 38), 'function': (False, 38), 'EOF': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 2354), ':': (True, 2355), 'for': (False, 38), '/': (False, 38), '>': (False, 38), ';': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '+': (False, 39), 'break': (False, 39), '==': (False, 39), 'if': (False, 39), '<': (False, 39), '^': (False, 39), 'function': (False, 39), '~=': (False, 39), 'EOF': (False, 39), '*': (False, 39), 'do': (False, 39), 'while': (False, 39), '/': (False, 39), 'goto': (False, 39), '-': (False, 39), 'EMBEDSTAT': (False, 39), 'or': (False, 39), '>': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), ';': (False, 39), '(': (False, 39), 'for': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 2363), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'while': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), 'NAME': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), 'EOF': (False, 11), '*': (False, 11), 'do': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '/': (False, 11), '>': (False, 11), ';': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 2365), '(': (True, 2366)}, {'..': (False, 35), '::': (False, 35), '+': (False, 35), 'break': (False, 35), '==': (False, 35), 'if': (False, 35), '^': (False, 35), 'function': (False, 35), '~=': (False, 35), 'EOF': (False, 35), '*': (False, 35), 'do': (False, 35), 'while': (False, 35), 'and': (False, 35), 'NAME': (False, 35), 'repeat': (False, 35), '-': (False, 35), 'EMBEDSTAT': (False, 35), 'for': (False, 35), '/': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), ';': (False, 35), '(': (False, 35), 'or': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2367), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '+': (False, 33), 'break': (False, 33), '==': (False, 33), 'if': (False, 33), 'local': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '~=': (False, 33), 'EOF': (False, 33), '*': (False, 33), 'do': (False, 33), 'while': (False, 33), ';': (False, 33), 'repeat': (False, 33), '-': (False, 33), '^': (False, 33), 'for': (False, 33), '/': (False, 33), '>': (False, 33), 'return': (False, 33), 'and': (False, 33), '<': (False, 33), 'NAME': (False, 33), '(': (False, 33), 'or': (False, 33), '>=': (False, 33), '%': (False, 33), 'goto': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), '==': (False, 30), 'if': (False, 30), '<': (False, 30), '^': (False, 30), 'function': (False, 30), '+': (False, 30), 'EOF': (False, 30), '*': (False, 30), 'do': (False, 30), 'while': (False, 30), ';': (False, 30), '/': (False, 30), 'repeat': (False, 30), '-': (False, 30), 'EMBEDSTAT': (False, 30), 'or': (False, 30), '>': (False, 30), 'local': (False, 30), 'return': (False, 30), 'and': (False, 30), 'NAME': (False, 30), '(': (False, 30), 'for': (False, 30), '>=': (False, 30), '%': (False, 30), 'goto': (False, 30), '<=': (False, 30)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2420), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), 'if': (False, 84), '^': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), 'EOF': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '/': (False, 84), '>': (False, 84), 'NAME': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), '==': (False, 36), 'if': (False, 36), '^': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '+': (False, 36), 'EOF': (False, 36), '*': (False, 36), 'do': (False, 36), 'while': (False, 36), ';': (False, 36), 'goto': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), '/': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), 'NAME': (False, 36), '(': (False, 36), 'for': (False, 36), '>=': (False, 36), '%': (False, 36), 'repeat': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'while': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '[': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), 'EOF': (False, 12), '*': (False, 12), 'do': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), '>': (False, 12), 'NAME': (False, 12), '<=': (False, 12)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2422), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'..': (True, 2425), '::': (False, 71), '+': (True, 2427), 'break': (False, 71), '==': (True, 2428), '>': (True, 2431), '^': (True, 2432), 'function': (False, 71), '~=': (True, 2434), 'EMBEDSTAT': (False, 71), '*': (True, 2435), 'do': (False, 71), 'while': (False, 71), ';': (False, 71), 'if': (False, 71), 'goto': (False, 71), '-': (True, 2426), 'and': (True, 2430), 'or': (True, 2436), '/': (True, 2429), 'local': (False, 71), 'return': (False, 71), '<': (True, 2433), 'NAME': (False, 71), '(': (False, 71), 'for': (False, 71), '>=': (True, 2437), 'EOF': (False, 71), '%': (True, 2438), 'repeat': (False, 71), '<=': (True, 2439)}, {'..': (False, 32), '::': (False, 32), '+': (False, 32), 'break': (False, 32), '==': (False, 32), 'if': (False, 32), '^': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '~=': (False, 32), 'EOF': (False, 32), '*': (False, 32), 'do': (False, 32), 'while': (False, 32), ';': (False, 32), '/': (False, 32), 'repeat': (False, 32), '-': (False, 32), '<': (False, 32), 'for': (False, 32), '>': (False, 32), 'local': (False, 32), 'return': (False, 32), 'and': (False, 32), 'NAME': (False, 32), '(': (False, 32), 'or': (False, 32), '>=': (False, 32), '%': (False, 32), 'goto': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '+': (False, 34), 'break': (False, 34), '==': (False, 34), 'if': (False, 34), 'local': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '~=': (False, 34), 'EOF': (False, 34), '*': (False, 34), 'do': (False, 34), 'while': (False, 34), ';': (False, 34), 'goto': (False, 34), '-': (False, 34), '^': (False, 34), 'or': (False, 34), '/': (False, 34), '>': (False, 34), 'return': (False, 34), 'and': (False, 34), '<': (False, 34), 'NAME': (False, 34), '(': (False, 34), 'for': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '<=': (False, 34)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2449), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 401), ')': (True, 2494), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), 'end': (False, 55), '^': (True, 1973), '~=': (False, 55), '*': (False, 55), ';': (False, 55), '/': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), 'elseif': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), 'else': (False, 55), '<=': (False, 55)}, {'end': (False, 108), 'elseif': (False, 108), 'else': (False, 108)}, {'end': (False, 88), 'elseif': (False, 88), 'else': (False, 88)}, {')': (True, 2491)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), 'then': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'..': (True, 1512), '::': (False, 48), '+': (True, 1514), 'break': (False, 48), '==': (False, 48), 'if': (False, 48), 'local': (False, 48), '^': (True, 1520), 'function': (False, 48), '~=': (False, 48), '*': (True, 1523), 'do': (False, 48), 'while': (False, 48), '}': (False, 48), 'goto': (False, 48), '-': (True, 1513), 'EMBEDSTAT': (False, 48), 'for': (False, 48), '/': (True, 1518), '>': (False, 48), 'return': (False, 48), 'and': (False, 48), '<': (False, 48), 'NAME': (False, 48), ';': (False, 48), '(': (False, 48), 'or': (False, 48), '>=': (False, 48), '%': (True, 1525), 'repeat': (False, 48), '<=': (False, 48)}, {'..': (False, 50), '::': (False, 50), '+': (False, 50), 'break': (False, 50), '==': (False, 50), '>': (False, 50), '<': (False, 50), '^': (True, 1520), 'function': (False, 50), '~=': (False, 50), '*': (True, 1523), 'do': (False, 50), 'while': (False, 50), '}': (False, 50), 'repeat': (False, 50), '-': (False, 50), 'EMBEDSTAT': (False, 50), 'for': (False, 50), 'or': (False, 50), '/': (True, 1518), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), 'NAME': (False, 50), ';': (False, 50), '(': (False, 50), 'if': (False, 50), '>=': (False, 50), '%': (True, 1525), 'goto': (False, 50), '<=': (False, 50)}, {'..': (False, 49), '::': (False, 49), '+': (False, 49), 'break': (False, 49), '==': (False, 49), 'if': (False, 49), '<': (False, 49), '^': (True, 1520), 'function': (False, 49), '~=': (False, 49), '*': (True, 1523), 'do': (False, 49), 'while': (False, 49), '}': (False, 49), 'repeat': (False, 49), '-': (False, 49), 'EMBEDSTAT': (False, 49), 'for': (False, 49), '/': (True, 1518), 'local': (False, 49), 'return': (False, 49), '>': (False, 49), 'and': (False, 49), 'NAME': (False, 49), ';': (False, 49), '(': (False, 49), 'or': (False, 49), '>=': (False, 49), '%': (True, 1525), 'goto': (False, 49), '<=': (False, 49)}, {'..': (True, 1512), '::': (False, 47), '+': (True, 1514), 'break': (False, 47), '==': (False, 47), 'if': (False, 47), '<': (False, 47), 'local': (False, 47), '^': (True, 1520), 'function': (False, 47), '~=': (False, 47), '*': (True, 1523), 'do': (False, 47), 'while': (False, 47), ';': (False, 47), '}': (False, 47), 'goto': (False, 47), '-': (True, 1513), 'EMBEDSTAT': (False, 47), 'for': (False, 47), '/': (True, 1518), '>': (False, 47), 'return': (False, 47), 'and': (False, 47), 'NAME': (False, 47), '(': (False, 47), 'or': (False, 47), '>=': (False, 47), '%': (True, 1525), 'repeat': (False, 47), '<=': (False, 47)}, {'..': (True, 1512), '::': (False, 40), '+': (True, 1514), 'break': (False, 40), '==': (True, 1515), '>': (True, 1519), '^': (True, 1520), 'function': (False, 40), '~=': (True, 1522), 'EMBEDSTAT': (False, 40), '*': (True, 1523), 'do': (False, 40), 'while': (False, 40), '}': (False, 40), 'goto': (False, 40), '-': (True, 1513), 'and': (True, 1517), 'for': (False, 40), 'or': (False, 40), '/': (True, 1518), 'local': (False, 40), 'return': (False, 40), '<': (True, 1521), 'NAME': (False, 40), ';': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 1524), '%': (True, 1525), 'repeat': (False, 40), '<=': (True, 1526)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2025), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (True, 1512), '::': (False, 41), '+': (True, 1514), 'break': (False, 41), '==': (True, 1515), '>': (True, 1519), '^': (True, 1520), 'function': (False, 41), '~=': (True, 1522), '*': (True, 1523), 'do': (False, 41), 'while': (False, 41), ';': (False, 41), '}': (False, 41), 'repeat': (False, 41), '-': (True, 1513), 'EMBEDSTAT': (False, 41), 'for': (False, 41), 'or': (False, 41), '/': (True, 1518), 'local': (False, 41), 'return': (False, 41), 'and': (False, 41), '<': (True, 1521), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1524), '%': (True, 1525), 'goto': (False, 41), '<=': (True, 1526)}, {'..': (False, 52), '::': (False, 52), '+': (False, 52), 'break': (False, 52), '==': (False, 52), 'if': (False, 52), '^': (True, 1520), 'function': (False, 52), '~=': (False, 52), '*': (False, 52), 'do': (False, 52), 'while': (False, 52), 'and': (False, 52), ';': (False, 52), '/': (False, 52), 'goto': (False, 52), '-': (False, 52), 'EMBEDSTAT': (False, 52), 'for': (False, 52), '>': (False, 52), 'local': (False, 52), 'return': (False, 52), '}': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), 'or': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '<=': (False, 52)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), ',': (False, 86), '==': (False, 86), '{': (False, 86), '>': (False, 86), '(': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '/': (False, 86), '[': (False, 86), 'and': (False, 86), ';': (False, 86), '?>': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'..': (True, 1512), '::': (False, 43), '+': (True, 1514), 'break': (False, 43), '==': (False, 43), 'if': (False, 43), '<': (False, 43), 'local': (False, 43), '^': (True, 1520), 'function': (False, 43), '~=': (False, 43), '*': (True, 1523), 'do': (False, 43), 'while': (False, 43), '}': (False, 43), 'repeat': (False, 43), '-': (True, 1513), 'EMBEDSTAT': (False, 43), 'for': (False, 43), '/': (True, 1518), '>': (False, 43), 'return': (False, 43), 'and': (False, 43), 'NAME': (False, 43), ';': (False, 43), '(': (False, 43), 'or': (False, 43), '>=': (False, 43), '%': (True, 1525), 'goto': (False, 43), '<=': (False, 43)}, {'args': (True, 2364), '{': (True, 1068), 'tableconstructor': (True, 1070), '(': (True, 1067), 'STRING': (True, 1065)}, {'..': (False, 54), '::': (False, 54), '+': (False, 54), 'break': (False, 54), '==': (False, 54), 'if': (False, 54), '<': (False, 54), 'local': (False, 54), '^': (True, 1520), 'function': (False, 54), '~=': (False, 54), '*': (False, 54), 'do': (False, 54), 'while': (False, 54), '}': (False, 54), 'repeat': (False, 54), '-': (False, 54), 'EMBEDSTAT': (False, 54), 'or': (False, 54), '/': (False, 54), '>': (False, 54), 'return': (False, 54), 'and': (False, 54), 'NAME': (False, 54), ';': (False, 54), '(': (False, 54), 'for': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '<=': (False, 54)}, {')': (True, 2504)}, {'..': (True, 1512), '::': (False, 42), '+': (True, 1514), 'break': (False, 42), '==': (False, 42), 'if': (False, 42), '<': (False, 42), 'local': (False, 42), '^': (True, 1520), 'function': (False, 42), '~=': (False, 42), '*': (True, 1523), 'do': (False, 42), 'while': (False, 42), '}': (False, 42), 'goto': (False, 42), '-': (True, 1513), 'EMBEDSTAT': (False, 42), 'for': (False, 42), '/': (True, 1518), '>': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), ';': (False, 42), '(': (False, 42), 'or': (False, 42), '>=': (False, 42), '%': (True, 1525), 'repeat': (False, 42), '<=': (False, 42)}, {'}': (True, 2297)}, {'end': (True, 2312)}, {'..': (True, 1512), '::': (False, 46), '+': (True, 1514), 'break': (False, 46), '==': (False, 46), '>': (False, 46), '<': (False, 46), '^': (True, 1520), 'function': (False, 46), '~=': (False, 46), '*': (True, 1523), 'do': (False, 46), 'while': (False, 46), '}': (False, 46), 'repeat': (False, 46), '-': (True, 1513), 'EMBEDSTAT': (False, 46), 'for': (False, 46), 'or': (False, 46), '/': (True, 1518), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), 'NAME': (False, 46), ';': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 1525), 'goto': (False, 46), '<=': (False, 46)}, {'end': (True, 2205)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), '==': (False, 51), '/': (False, 51), '<': (False, 51), '^': (True, 1520), 'function': (False, 51), '+': (False, 51), '*': (False, 51), 'do': (False, 51), 'while': (False, 51), ';': (False, 51), 'if': (False, 51), '}': (False, 51), 'goto': (False, 51), '-': (False, 51), 'EMBEDSTAT': (False, 51), 'or': (False, 51), '>': (False, 51), 'local': (False, 51), 'return': (False, 51), 'and': (False, 51), 'NAME': (False, 51), '(': (False, 51), 'for': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '<=': (False, 51)}, {':': (False, 17), '(': (False, 17)}, {'..': (True, 1512), '::': (False, 45), '+': (True, 1514), 'break': (False, 45), '==': (False, 45), 'if': (False, 45), '<': (False, 45), 'local': (False, 45), '^': (True, 1520), 'function': (False, 45), '~=': (False, 45), '*': (True, 1523), 'do': (False, 45), 'while': (False, 45), ';': (False, 45), '}': (False, 45), 'repeat': (False, 45), '-': (True, 1513), 'EMBEDSTAT': (False, 45), 'or': (False, 45), '/': (True, 1518), '>': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), 'for': (False, 45), '>=': (False, 45), '%': (True, 1525), 'goto': (False, 45), '<=': (False, 45)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2042), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 53), '::': (False, 53), '+': (False, 53), 'break': (False, 53), '==': (False, 53), 'if': (False, 53), '<': (False, 53), '^': (True, 1520), 'function': (False, 53), '~=': (False, 53), '*': (False, 53), 'do': (False, 53), 'while': (False, 53), '}': (False, 53), 'repeat': (False, 53), '-': (False, 53), 'EMBEDSTAT': (False, 53), 'for': (False, 53), '/': (False, 53), '>': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), 'NAME': (False, 53), ';': (False, 53), '(': (False, 53), 'or': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '<=': (False, 53)}, {'..': (True, 1512), '::': (False, 44), '+': (True, 1514), 'break': (False, 44), '==': (False, 44), 'if': (False, 44), 'local': (False, 44), '^': (True, 1520), 'function': (False, 44), '~=': (False, 44), '*': (True, 1523), 'do': (False, 44), 'while': (False, 44), '}': (False, 44), 'goto': (False, 44), '-': (True, 1513), 'EMBEDSTAT': (False, 44), 'or': (False, 44), '/': (True, 1518), '>': (False, 44), 'return': (False, 44), 'and': (False, 44), '<': (False, 44), 'NAME': (False, 44), ';': (False, 44), '(': (False, 44), 'for': (False, 44), '>=': (False, 44), '%': (True, 1525), 'repeat': (False, 44), '<=': (False, 44)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2369), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (True, 1527), '::': (False, 41), '~=': (True, 1529), 'break': (False, 41), ',': (False, 41), '>': (True, 1532), '^': (True, 1367), 'while': (False, 41), '-': (True, 1535), 'and': (False, 41), 'or': (False, 41), 'local': (False, 41), 'return': (False, 41), '<': (True, 1533), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1539), '%': (True, 1540), 'goto': (False, 41), '+': (True, 1536), '==': (True, 1531), 'EMBEDSTAT': (False, 41), 'function': (False, 41), '*': (True, 1537), 'do': (False, 41), 'repeat': (False, 41), 'end': (False, 41), 'for': (False, 41), '/': (True, 1541), 'elseif': (False, 41), ';': (False, 41), 'else': (False, 41), '<=': (True, 1542)}, {'..': (True, 1527), '::': (False, 48), '~=': (False, 48), 'break': (False, 48), ',': (False, 48), '>': (False, 48), '^': (True, 1367), 'while': (False, 48), '-': (True, 1535), '<': (False, 48), 'or': (False, 48), 'local': (False, 48), 'return': (False, 48), 'and': (False, 48), 'NAME': (False, 48), '(': (False, 48), 'if': (False, 48), '>=': (False, 48), '%': (True, 1540), 'repeat': (False, 48), '+': (True, 1536), '==': (False, 48), 'EMBEDSTAT': (False, 48), 'function': (False, 48), '*': (True, 1537), 'do': (False, 48), 'goto': (False, 48), 'end': (False, 48), 'for': (False, 48), '/': (True, 1541), 'elseif': (False, 48), ';': (False, 48), 'else': (False, 48), '<=': (False, 48)}, {'..': (True, 1527), '::': (False, 46), '~=': (False, 46), 'break': (False, 46), ',': (False, 46), 'end': (False, 46), '^': (True, 1367), 'while': (False, 46), '-': (True, 1535), '<': (False, 46), 'or': (False, 46), 'local': (False, 46), 'return': (False, 46), '>': (False, 46), 'and': (False, 46), 'NAME': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 1540), 'goto': (False, 46), '+': (True, 1536), '==': (False, 46), 'EMBEDSTAT': (False, 46), 'function': (False, 46), '*': (True, 1537), 'do': (False, 46), 'repeat': (False, 46), 'for': (False, 46), '/': (True, 1541), 'elseif': (False, 46), ';': (False, 46), 'else': (False, 46), '<=': (False, 46)}, {'..': (True, 1527), '::': (False, 93), '~=': (True, 1529), 'break': (False, 93), '/': (True, 1541), '^': (True, 1367), 'while': (False, 93), '-': (True, 1535), 'and': (True, 1528), 'or': (True, 1538), 'explist__1': (True, 2477), 'local': (False, 93), 'return': (False, 93), '<': (True, 1533), ',': (True, 1530), '(': (False, 93), 'if': (False, 93), '>=': (True, 1539), '%': (True, 1540), 'repeat': (False, 93), '+': (True, 1536), '==': (True, 1531), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 1537), 'do': (False, 93), 'NAME': (False, 93), 'goto': (False, 93), 'end': (False, 93), 'for': (False, 93), '>': (True, 1532), 'elseif': (False, 93), ';': (False, 93), 'else': (False, 93), '<=': (True, 1542)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '/': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), '}': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'..': (True, 1527), '::': (False, 47), '~=': (False, 47), 'break': (False, 47), ',': (False, 47), '>': (False, 47), '^': (True, 1367), 'while': (False, 47), '-': (True, 1535), 'and': (False, 47), 'or': (False, 47), 'local': (False, 47), 'return': (False, 47), '<': (False, 47), 'NAME': (False, 47), '(': (False, 47), 'if': (False, 47), '>=': (False, 47), '%': (True, 1540), 'goto': (False, 47), '+': (True, 1536), '==': (False, 47), 'EMBEDSTAT': (False, 47), 'function': (False, 47), '*': (True, 1537), 'do': (False, 47), 'repeat': (False, 47), 'end': (False, 47), 'for': (False, 47), '/': (True, 1541), 'elseif': (False, 47), ';': (False, 47), 'else': (False, 47), '<=': (False, 47)}, {'..': (True, 1527), '::': (False, 43), '~=': (False, 43), 'break': (False, 43), 'end': (False, 43), '^': (True, 1367), 'while': (False, 43), '-': (True, 1535), '<': (False, 43), 'or': (False, 43), 'local': (False, 43), 'return': (False, 43), '>': (False, 43), 'and': (False, 43), ',': (False, 43), '(': (False, 43), 'if': (False, 43), '>=': (False, 43), '%': (True, 1540), 'repeat': (False, 43), '+': (True, 1536), '==': (False, 43), 'EMBEDSTAT': (False, 43), 'function': (False, 43), '*': (True, 1537), 'do': (False, 43), 'NAME': (False, 43), 'goto': (False, 43), 'for': (False, 43), '/': (True, 1541), 'elseif': (False, 43), ';': (False, 43), 'else': (False, 43), '<=': (False, 43)}, {'..': (True, 1527), '::': (False, 42), '~=': (False, 42), 'break': (False, 42), ',': (False, 42), 'if': (False, 42), 'elseif': (False, 42), '^': (True, 1367), 'while': (False, 42), '-': (True, 1535), '<': (False, 42), 'or': (False, 42), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), '(': (False, 42), '>=': (False, 42), '%': (True, 1540), 'repeat': (False, 42), '+': (True, 1536), '==': (False, 42), 'EMBEDSTAT': (False, 42), 'function': (False, 42), '*': (True, 1537), 'do': (False, 42), 'goto': (False, 42), 'end': (False, 42), 'for': (False, 42), '/': (True, 1541), '>': (False, 42), ';': (False, 42), 'else': (False, 42), '<=': (False, 42)}, {'..': (False, 9), '::': (False, 9), '+': (False, 9), 'break': (False, 9), '==': (False, 9), 'if': (False, 9), '<': (False, 9), '^': (False, 9), 'function': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), 'while': (False, 9), ';': (False, 9), 'goto': (False, 9), '-': (False, 9), 'EMBEDSTAT': (False, 9), 'or': (False, 9), 'until': (False, 9), '/': (False, 9), 'local': (False, 9), 'return': (False, 9), '>': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), 'for': (False, 9), '>=': (False, 9), '%': (False, 9), 'repeat': (False, 9), '<=': (False, 9)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), ',': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '(': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), ';': (False, 85), '?>': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {')': (True, 2234)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), ',': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '/': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), 'NAME': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), '}': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), '>': (False, 23), ';': (False, 23), '<=': (False, 23)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'until': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), 'NAME': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {')': (True, 2249)}, {'..': (False, 50), '::': (False, 50), '~=': (False, 50), 'break': (False, 50), 'if': (False, 50), '^': (True, 1887), 'while': (False, 50), '-': (False, 50), '<': (False, 50), 'or': (False, 50), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ',': (False, 50), '(': (False, 50), '>=': (False, 50), '%': (True, 1893), 'goto': (False, 50), '+': (False, 50), '==': (False, 50), 'EMBEDSTAT': (False, 50), 'function': (False, 50), '*': (True, 1890), 'do': (False, 50), 'NAME': (False, 50), 'repeat': (False, 50), 'for': (False, 50), '/': (True, 1894), '>': (False, 50), ';': (False, 50), '?>': (False, 50), '<=': (False, 50)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), 'if': (False, 22), '^': (False, 22), 'while': (False, 22), '/': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'until': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2408), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'.': (False, 9), '..': (False, 9), '~=': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '+': (False, 9), ']': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), ',': (False, 86), '>': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), 'NAME': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), '/': (False, 86), ';': (False, 86), '?>': (False, 86), '<=': (False, 86)}, {'args': (True, 2418), '{': (True, 1848), 'tableconstructor': (True, 1850), '(': (True, 1847), 'STRING': (True, 1845)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), ',': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), '<': (False, 13), ':': (False, 13), 'or': (False, 13), 'until': (False, 13), '/': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {')': (True, 2061)}, {'..': (True, 1879), '::': (False, 48), '~=': (False, 48), 'break': (False, 48), ',': (False, 48), 'if': (False, 48), '^': (True, 1887), 'while': (False, 48), '-': (True, 1880), '<': (False, 48), 'or': (False, 48), 'local': (False, 48), 'return': (False, 48), 'and': (False, 48), 'NAME': (False, 48), '(': (False, 48), '>=': (False, 48), '%': (True, 1893), 'repeat': (False, 48), '+': (True, 1881), '==': (False, 48), 'EMBEDSTAT': (False, 48), 'function': (False, 48), '*': (True, 1890), 'do': (False, 48), 'goto': (False, 48), 'for': (False, 48), '/': (True, 1894), '>': (False, 48), ';': (False, 48), '?>': (False, 48), '<=': (False, 48)}, {'..': (False, 49), '::': (False, 49), '~=': (False, 49), 'break': (False, 49), 'if': (False, 49), '^': (True, 1887), 'while': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), 'local': (False, 49), 'return': (False, 49), '<': (False, 49), ',': (False, 49), '(': (False, 49), '>=': (False, 49), '%': (True, 1893), 'repeat': (False, 49), '+': (False, 49), '==': (False, 49), 'EMBEDSTAT': (False, 49), 'function': (False, 49), '*': (True, 1890), 'do': (False, 49), ';': (False, 49), 'goto': (False, 49), 'for': (False, 49), '/': (True, 1894), '>': (False, 49), 'NAME': (False, 49), '?>': (False, 49), '<=': (False, 49)}, {'}': (True, 2396)}, {'..': (True, 1879), '::': (False, 93), '~=': (True, 1889), 'break': (False, 93), '/': (True, 1894), '^': (True, 1887), 'while': (False, 93), '-': (True, 1880), 'and': (True, 1885), 'or': (True, 1891), 'explist__1': (True, 2492), 'local': (False, 93), 'return': (False, 93), '<': (True, 1888), ',': (True, 1882), '(': (False, 93), 'if': (False, 93), '>=': (True, 1892), '%': (True, 1893), 'goto': (False, 93), '+': (True, 1881), '==': (True, 1883), 'EMBEDSTAT': (False, 93), 'function': (False, 93), '*': (True, 1890), 'do': (False, 93), ';': (False, 93), 'repeat': (False, 93), 'for': (False, 93), '>': (True, 1884), 'NAME': (False, 93), '?>': (False, 93), '<=': (True, 1895)}, {'.': (False, 22), '..': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), '>': (False, 22), '^': (False, 22), '~=': (False, 22), ']': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '/': (False, 22), '[': (False, 22), '<': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'..': (True, 1879), '::': (False, 47), '~=': (False, 47), 'break': (False, 47), ',': (False, 47), 'if': (False, 47), '^': (True, 1887), 'while': (False, 47), '-': (True, 1880), 'and': (False, 47), 'or': (False, 47), 'local': (False, 47), 'return': (False, 47), '<': (False, 47), 'NAME': (False, 47), '(': (False, 47), '>=': (False, 47), '%': (True, 1893), 'goto': (False, 47), '+': (True, 1881), '==': (False, 47), 'EMBEDSTAT': (False, 47), 'function': (False, 47), '*': (True, 1890), 'do': (False, 47), 'repeat': (False, 47), 'for': (False, 47), '/': (True, 1894), '>': (False, 47), ';': (False, 47), '?>': (False, 47), '<=': (False, 47)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), ',': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), 'NAME': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), '/': (False, 23), '>': (False, 23), ';': (False, 23), '?>': (False, 23), '<=': (False, 23)}, {'..': (True, 1879), '::': (False, 43), '~=': (False, 43), 'break': (False, 43), '>': (False, 43), '^': (True, 1887), 'while': (False, 43), '-': (True, 1880), '<': (False, 43), 'or': (False, 43), 'local': (False, 43), 'return': (False, 43), 'and': (False, 43), ',': (False, 43), '(': (False, 43), 'if': (False, 43), '>=': (False, 43), '%': (True, 1893), 'goto': (False, 43), '+': (True, 1881), '==': (False, 43), 'EMBEDSTAT': (False, 43), 'function': (False, 43), '*': (True, 1890), 'do': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), 'for': (False, 43), '/': (True, 1894), ';': (False, 43), '?>': (False, 43), '<=': (False, 43)}, {'-': (True, 207), 'false': (True, 208), 'functiondef': (True, 209), 'prefixexp': (True, 224), '(': (True, 222), 'var': (True, 213), 'function': (True, 214), 'EMBEDEXPR': (True, 215), 'tableconstructor': (True, 211), 'NUMBER': (True, 226), 'nil': (True, 217), '#': (True, 218), 'NAME': (True, 219), '...': (True, 225), 'functioncall': (True, 212), '{': (True, 216), 'not': (True, 223), 'exp': (True, 2239), 'true': (True, 221), 'STRING': (True, 220)}, {'do': (True, 2240)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2424), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (True, 1879), '::': (False, 41), '~=': (True, 1889), 'break': (False, 41), ',': (False, 41), '>': (True, 1884), '^': (True, 1887), 'while': (False, 41), '-': (True, 1880), 'and': (False, 41), 'or': (False, 41), 'local': (False, 41), 'return': (False, 41), '<': (True, 1888), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1892), '%': (True, 1893), 'goto': (False, 41), '+': (True, 1881), '==': (True, 1883), 'EMBEDSTAT': (False, 41), 'function': (False, 41), '*': (True, 1890), 'do': (False, 41), 'repeat': (False, 41), 'for': (False, 41), '/': (True, 1894), ';': (False, 41), '?>': (False, 41), '<=': (True, 1895)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), ';': (False, 9), '-': (False, 9), 'and': (False, 9), 'end': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {')': (True, 2484)}, {'..': (False, 54), '::': (False, 54), '~=': (False, 54), 'break': (False, 54), ',': (False, 54), 'if': (False, 54), '^': (True, 1887), 'while': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), 'local': (False, 54), 'return': (False, 54), '<': (False, 54), 'NAME': (False, 54), '(': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '+': (False, 54), '==': (False, 54), 'EMBEDSTAT': (False, 54), 'function': (False, 54), '*': (False, 54), 'do': (False, 54), 'repeat': (False, 54), 'for': (False, 54), '/': (False, 54), '>': (False, 54), ';': (False, 54), '?>': (False, 54), '<=': (False, 54)}, {'..': (True, 1879), '::': (False, 42), '~=': (False, 42), 'break': (False, 42), ',': (False, 42), 'if': (False, 42), '^': (True, 1887), 'while': (False, 42), '-': (True, 1880), '<': (False, 42), 'or': (False, 42), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), 'NAME': (False, 42), '(': (False, 42), '>=': (False, 42), '%': (True, 1893), 'repeat': (False, 42), '+': (True, 1881), '==': (False, 42), 'EMBEDSTAT': (False, 42), 'function': (False, 42), '*': (True, 1890), 'do': (False, 42), 'goto': (False, 42), 'for': (False, 42), '/': (True, 1894), '>': (False, 42), ';': (False, 42), '?>': (False, 42), '<=': (False, 42)}, {'..': (True, 1879), '::': (False, 46), '~=': (False, 46), 'break': (False, 46), ',': (False, 46), '>': (False, 46), '^': (True, 1887), 'while': (False, 46), '-': (True, 1880), '<': (False, 46), 'or': (False, 46), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), 'NAME': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 1893), 'goto': (False, 46), '+': (True, 1881), '==': (False, 46), 'EMBEDSTAT': (False, 46), 'function': (False, 46), '*': (True, 1890), 'do': (False, 46), 'repeat': (False, 46), 'for': (False, 46), '/': (True, 1894), ';': (False, 46), '?>': (False, 46), '<=': (False, 46)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 48), '>': (False, 48), '^': (True, 1973), '~=': (False, 48), '*': (True, 1976), ';': (False, 48), '-': (True, 1965), '<': (False, 48), 'end': (False, 48), 'or': (False, 48), '/': (True, 1979), 'elseif': (False, 48), 'and': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 1978), 'else': (False, 48), '<=': (False, 48)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), '>': (False, 50), '^': (True, 1973), '+': (False, 50), '*': (True, 1976), ';': (False, 50), '-': (False, 50), 'and': (False, 50), 'end': (False, 50), 'or': (False, 50), '/': (True, 1979), 'elseif': (False, 50), '<': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 1978), 'else': (False, 50), '<=': (False, 50)}, {'::': (False, 104), 'break': (False, 104), 'if': (False, 104), 'EMBEDSTAT': (False, 104), 'function': (False, 104), 'do': (False, 104), 'while': (False, 104), ';': (False, 104), '}': (False, 104), 'goto': (False, 104), 'for': (False, 104), 'local': (False, 104), 'return': (False, 104), 'NAME': (False, 104), '(': (False, 104), 'repeat': (False, 104)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), ',': (False, 51), 'if': (False, 51), '^': (True, 1887), 'while': (False, 51), '/': (False, 51), '-': (False, 51), 'and': (False, 51), 'or': (False, 51), 'local': (False, 51), 'return': (False, 51), '<': (False, 51), 'NAME': (False, 51), '(': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '+': (False, 51), '==': (False, 51), 'EMBEDSTAT': (False, 51), 'function': (False, 51), '*': (False, 51), 'do': (False, 51), 'goto': (False, 51), 'for': (False, 51), '>': (False, 51), ';': (False, 51), '?>': (False, 51), '<=': (False, 51)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), '>': (False, 49), '^': (True, 1973), '~=': (False, 49), '*': (True, 1976), ';': (False, 49), '-': (False, 49), '<': (False, 49), 'end': (False, 49), 'or': (False, 49), '/': (True, 1979), 'elseif': (False, 49), 'and': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 1978), 'else': (False, 49), '<=': (False, 49)}, {'..': (True, 1879), '::': (False, 40), '~=': (True, 1889), 'break': (False, 40), ',': (False, 40), '>': (True, 1884), '^': (True, 1887), 'while': (False, 40), '-': (True, 1880), 'and': (True, 1885), 'or': (False, 40), 'local': (False, 40), 'return': (False, 40), '<': (True, 1888), 'NAME': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 1892), '%': (True, 1893), 'goto': (False, 40), '+': (True, 1881), '==': (True, 1883), 'EMBEDSTAT': (False, 40), 'function': (False, 40), '*': (True, 1890), 'do': (False, 40), 'repeat': (False, 40), 'for': (False, 40), '/': (True, 1894), ';': (False, 40), '?>': (False, 40), '<=': (True, 1895)}, {'..': (True, 1964), '-': (True, 1965), '+': (True, 1966), 'end': (False, 93), '==': (True, 1968), 'or': (True, 1969), '<': (True, 1974), '>': (True, 1971), 'elseif': (False, 93), 'explist__1': (True, 2510), 'and': (True, 1970), '^': (True, 1973), '>=': (True, 1977), ',': (True, 1967), '*': (True, 1976), '~=': (True, 1975), '%': (True, 1978), ';': (False, 93), '/': (True, 1979), 'else': (False, 93), '<=': (True, 1980)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 2512), ';': (False, 29), 'NAME': (False, 29), 'goto': (False, 29), 'for': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), '}': (False, 29), ',': (True, 1216), '(': (False, 29), 'repeat': (False, 29)}, {'..': (True, 1879), '::': (False, 45), '~=': (False, 45), 'break': (False, 45), ',': (False, 45), 'if': (False, 45), '^': (True, 1887), 'while': (False, 45), '-': (True, 1880), '<': (False, 45), 'or': (False, 45), 'local': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), '>=': (False, 45), '%': (True, 1893), 'goto': (False, 45), '+': (True, 1881), '==': (False, 45), 'EMBEDSTAT': (False, 45), 'function': (False, 45), '*': (True, 1890), 'do': (False, 45), 'repeat': (False, 45), 'for': (False, 45), '/': (True, 1894), '>': (False, 45), ';': (False, 45), '?>': (False, 45), '<=': (False, 45)}, {'.': (False, 23), '..': (False, 23), '~=': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '+': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), 'then': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 47), 'end': (False, 47), 'elseif': (False, 47), '^': (True, 1973), '~=': (False, 47), '*': (True, 1976), ';': (False, 47), '-': (True, 1965), 'and': (False, 47), 'or': (False, 47), '/': (True, 1979), '>': (False, 47), '<': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 1978), 'else': (False, 47), '<=': (False, 47)}, {'..': (False, 53), '::': (False, 53), '~=': (False, 53), 'break': (False, 53), 'if': (False, 53), '^': (True, 1887), 'while': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), ',': (False, 53), '(': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '+': (False, 53), '==': (False, 53), 'EMBEDSTAT': (False, 53), 'function': (False, 53), '*': (False, 53), 'do': (False, 53), 'NAME': (False, 53), 'repeat': (False, 53), 'for': (False, 53), '/': (False, 53), '>': (False, 53), ';': (False, 53), '?>': (False, 53), '<=': (False, 53)}, {'..': (True, 1964), '-': (True, 1965), ',': (False, 40), '+': (True, 1966), 'end': (False, 40), '==': (True, 1968), '/': (True, 1979), '<': (True, 1974), '>': (True, 1971), 'elseif': (False, 40), 'and': (True, 1970), '^': (True, 1973), '~=': (True, 1975), '*': (True, 1976), 'or': (False, 40), '>=': (True, 1977), '%': (True, 1978), ';': (False, 40), 'else': (False, 40), '<=': (True, 1980)}, {'..': (False, 52), '::': (False, 52), '~=': (False, 52), 'break': (False, 52), ',': (False, 52), 'if': (False, 52), '^': (True, 1887), 'while': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), 'local': (False, 52), 'return': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '+': (False, 52), '==': (False, 52), 'EMBEDSTAT': (False, 52), 'function': (False, 52), '*': (False, 52), 'do': (False, 52), 'goto': (False, 52), 'for': (False, 52), '/': (False, 52), '>': (False, 52), ';': (False, 52), '?>': (False, 52), '<=': (False, 52)}, {'..': (True, 1964), '-': (True, 1965), '+': (True, 1966), ',': (False, 41), '==': (True, 1968), '/': (True, 1979), '<': (True, 1974), '>': (True, 1971), 'elseif': (False, 41), 'and': (False, 41), '^': (True, 1973), '~=': (True, 1975), '*': (True, 1976), 'end': (False, 41), '>=': (True, 1977), 'or': (False, 41), '%': (True, 1978), ';': (False, 41), 'else': (False, 41), '<=': (True, 1980)}, {'..': (True, 1879), '::': (False, 44), '~=': (False, 44), 'break': (False, 44), ',': (False, 44), 'if': (False, 44), '^': (True, 1887), 'while': (False, 44), '-': (True, 1880), 'and': (False, 44), 'or': (False, 44), 'local': (False, 44), 'return': (False, 44), '<': (False, 44), 'NAME': (False, 44), '(': (False, 44), '>=': (False, 44), '%': (True, 1893), 'repeat': (False, 44), '+': (True, 1881), '==': (False, 44), 'EMBEDSTAT': (False, 44), 'function': (False, 44), '*': (True, 1890), 'do': (False, 44), 'goto': (False, 44), 'for': (False, 44), '/': (True, 1894), '>': (False, 44), ';': (False, 44), '?>': (False, 44), '<=': (False, 44)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 43), 'end': (False, 43), 'elseif': (False, 43), '^': (True, 1973), '~=': (False, 43), '*': (True, 1976), ';': (False, 43), '-': (True, 1965), 'and': (False, 43), 'or': (False, 43), '/': (True, 1979), '>': (False, 43), '<': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 1978), 'else': (False, 43), '<=': (False, 43)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), 'end': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), ';': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '/': (False, 9), 'elseif': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), 'else': (False, 9), '<=': (False, 9)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2156), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 1973), '~=': (False, 54), '*': (False, 54), ';': (False, 54), '/': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), 'end': (False, 54), 'elseif': (False, 54), 'and': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), 'else': (False, 54), '<=': (False, 54)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 42), 'end': (False, 42), 'elseif': (False, 42), '^': (True, 1973), '~=': (False, 42), '*': (True, 1976), ';': (False, 42), '-': (True, 1965), 'and': (False, 42), 'or': (False, 42), '/': (True, 1979), '>': (False, 42), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 1978), 'else': (False, 42), '<=': (False, 42)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 46), 'end': (False, 46), '^': (True, 1973), '~=': (False, 46), '*': (True, 1976), ';': (False, 46), '-': (True, 1965), '<': (False, 46), 'or': (False, 46), '/': (True, 1979), 'elseif': (False, 46), '>': (False, 46), 'and': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 1978), 'else': (False, 46), '<=': (False, 46)}, {'..': (False, 9), '::': (False, 9), '+': (False, 9), 'break': (False, 9), '==': (False, 9), 'if': (False, 9), '<': (False, 9), '^': (False, 9), 'function': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), 'while': (False, 9), ';': (False, 9), '}': (False, 9), 'goto': (False, 9), '-': (False, 9), 'EMBEDSTAT': (False, 9), 'or': (False, 9), '/': (False, 9), 'local': (False, 9), 'return': (False, 9), '>': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), 'for': (False, 9), '>=': (False, 9), '%': (False, 9), 'repeat': (False, 9), '<=': (False, 9)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 1973), '~=': (False, 51), '*': (False, 51), ';': (False, 51), '-': (False, 51), '<': (False, 51), 'end': (False, 51), 'or': (False, 51), '/': (False, 51), 'elseif': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), 'else': (False, 51), '<=': (False, 51)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 45), '>': (False, 45), '^': (True, 1973), '~=': (False, 45), '*': (True, 1976), ';': (False, 45), '-': (True, 1965), '<': (False, 45), 'end': (False, 45), 'or': (False, 45), '/': (True, 1979), 'elseif': (False, 45), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 1978), 'else': (False, 45), '<=': (False, 45)}, {')': (True, 2344)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 1973), '~=': (False, 53), '*': (False, 53), ';': (False, 53), '/': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), 'end': (False, 53), 'elseif': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), 'else': (False, 53), '<=': (False, 53)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 1973), '+': (False, 52), '*': (False, 52), ';': (False, 52), '/': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), 'end': (False, 52), 'elseif': (False, 52), 'and': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), 'else': (False, 52), '<=': (False, 52)}, {'..': (True, 1964), '+': (True, 1966), '==': (False, 44), '>': (False, 44), '^': (True, 1973), '~=': (False, 44), '*': (True, 1976), ';': (False, 44), '-': (True, 1965), '<': (False, 44), 'end': (False, 44), 'or': (False, 44), '/': (True, 1979), 'elseif': (False, 44), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 1978), 'else': (False, 44), '<=': (False, 44)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'prefixexp': (True, 452), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), 'exp': (True, 467), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'explist': (True, 2311), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'-': (True, 473), 'false': (True, 474), 'functiondef': (True, 475), 'prefixexp': (True, 490), '(': (True, 488), 'var': (True, 479), 'function': (True, 480), 'EMBEDEXPR': (True, 481), 'tableconstructor': (True, 477), 'NUMBER': (True, 492), 'nil': (True, 483), '#': (True, 484), 'NAME': (True, 485), '...': (True, 491), 'functioncall': (True, 478), '{': (True, 482), 'not': (True, 489), 'exp': (True, 2320), 'true': (True, 487), 'STRING': (True, 486)}, {'end': (True, 2445)}, {'block__1': (True, 643), '::': (True, 644), 'break': (True, 645), 'if': (True, 646), 'varlist': (True, 647), 'elseif': (False, 3), 'EMBEDSTAT': (True, 648), 'function': (True, 649), 'functioncall': (True, 650), 'do': (True, 651), 'while': (True, 652), 'prefixexp': (True, 655), 'NAME': (True, 15), 'goto': (True, 654), 'stat': (True, 653), 'var': (True, 18), 'block': (True, 2446), 'for': (True, 657), 'label': (True, 658), 'end': (False, 3), 'local': (True, 659), 'return': (False, 3), ';': (True, 660), '(': (True, 25), 'repeat': (True, 661), 'else': (False, 3)}, {'..': (False, 50), '~=': (False, 50), '==': (False, 50), 'end': (False, 50), '^': (True, 1479), '+': (False, 50), '*': (True, 1482), ';': (False, 50), '-': (False, 50), 'and': (False, 50), 'or': (False, 50), '/': (True, 1485), '>': (False, 50), '<': (False, 50), ',': (False, 50), '>=': (False, 50), '%': (True, 1484), '<=': (False, 50)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 48), '>': (False, 48), '^': (True, 1479), '~=': (False, 48), '*': (True, 1482), ';': (False, 48), '-': (True, 1471), '<': (False, 48), 'end': (False, 48), 'or': (False, 48), '/': (True, 1485), 'and': (False, 48), ',': (False, 48), '>=': (False, 48), '%': (True, 1484), '<=': (False, 48)}, {'..': (False, 49), '+': (False, 49), '==': (False, 49), 'end': (False, 49), '^': (True, 1479), '~=': (False, 49), '*': (True, 1482), ';': (False, 49), '-': (False, 49), '<': (False, 49), 'or': (False, 49), '/': (True, 1485), '>': (False, 49), 'and': (False, 49), ',': (False, 49), '>=': (False, 49), '%': (True, 1484), '<=': (False, 49)}, {'..': (True, 1470), '-': (True, 1471), '+': (True, 1472), 'end': (False, 93), '==': (True, 1474), 'or': (True, 1475), '<': (True, 1480), '>': (True, 1477), 'explist__1': (True, 2343), 'and': (True, 1476), '^': (True, 1479), '>=': (True, 1483), ',': (True, 1473), '*': (True, 1482), '~=': (True, 1481), '%': (True, 1484), ';': (False, 93), '/': (True, 1485), '<=': (True, 1486)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 47), 'end': (False, 47), '^': (True, 1479), '~=': (False, 47), '*': (True, 1482), ';': (False, 47), '-': (True, 1471), 'and': (False, 47), 'or': (False, 47), '/': (True, 1485), '>': (False, 47), '<': (False, 47), ',': (False, 47), '>=': (False, 47), '%': (True, 1484), '<=': (False, 47)}, {'..': (True, 1470), '-': (True, 1471), ',': (False, 40), '+': (True, 1472), 'end': (False, 40), '==': (True, 1474), '/': (True, 1485), '<': (True, 1480), '>': (True, 1477), 'and': (True, 1476), '^': (True, 1479), '~=': (True, 1481), '*': (True, 1482), 'or': (False, 40), '>=': (True, 1483), '%': (True, 1484), ';': (False, 40), '<=': (True, 1486)}, {'..': (True, 1470), '-': (True, 1471), '+': (True, 1472), ',': (False, 41), '==': (True, 1474), '/': (True, 1485), '<': (True, 1480), '>': (True, 1477), 'and': (False, 41), '^': (True, 1479), '~=': (True, 1481), '*': (True, 1482), 'end': (False, 41), '>=': (True, 1483), 'or': (False, 41), '%': (True, 1484), ';': (False, 41), '<=': (True, 1486)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 43), 'end': (False, 43), '^': (True, 1479), '~=': (False, 43), '*': (True, 1482), ';': (False, 43), '-': (True, 1471), 'and': (False, 43), 'or': (False, 43), '/': (True, 1485), '>': (False, 43), '<': (False, 43), ',': (False, 43), '>=': (False, 43), '%': (True, 1484), '<=': (False, 43)}, {'..': (False, 54), '+': (False, 54), '==': (False, 54), '>': (False, 54), '^': (True, 1479), '~=': (False, 54), '*': (False, 54), ';': (False, 54), '/': (False, 54), '-': (False, 54), 'and': (False, 54), 'or': (False, 54), 'end': (False, 54), '<': (False, 54), ',': (False, 54), '>=': (False, 54), '%': (False, 54), '<=': (False, 54)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 42), 'end': (False, 42), '^': (True, 1479), '~=': (False, 42), '*': (True, 1482), ';': (False, 42), '-': (True, 1471), 'and': (False, 42), 'or': (False, 42), '/': (True, 1485), '>': (False, 42), '<': (False, 42), ',': (False, 42), '>=': (False, 42), '%': (True, 1484), '<=': (False, 42)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 46), 'end': (False, 46), '^': (True, 1479), '~=': (False, 46), '*': (True, 1482), ';': (False, 46), '-': (True, 1471), '<': (False, 46), 'or': (False, 46), '/': (True, 1485), '>': (False, 46), 'and': (False, 46), ',': (False, 46), '>=': (False, 46), '%': (True, 1484), '<=': (False, 46)}, {'..': (False, 51), '+': (False, 51), '==': (False, 51), '>': (False, 51), '^': (True, 1479), '~=': (False, 51), '*': (False, 51), ';': (False, 51), '-': (False, 51), '<': (False, 51), 'end': (False, 51), 'or': (False, 51), '/': (False, 51), 'and': (False, 51), ',': (False, 51), '>=': (False, 51), '%': (False, 51), '<=': (False, 51)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 45), '>': (False, 45), '^': (True, 1479), '~=': (False, 45), '*': (True, 1482), ';': (False, 45), '-': (True, 1471), '<': (False, 45), 'end': (False, 45), 'or': (False, 45), '/': (True, 1485), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 1484), '<=': (False, 45)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 1479), '~=': (False, 53), '*': (False, 53), ';': (False, 53), '/': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), 'end': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'..': (False, 52), '~=': (False, 52), '==': (False, 52), '>': (False, 52), '^': (True, 1479), '+': (False, 52), '*': (False, 52), ';': (False, 52), '/': (False, 52), '-': (False, 52), '<': (False, 52), 'or': (False, 52), 'end': (False, 52), 'and': (False, 52), ',': (False, 52), '>=': (False, 52), '%': (False, 52), '<=': (False, 52)}, {'..': (True, 1470), '+': (True, 1472), '==': (False, 44), '>': (False, 44), '^': (True, 1479), '~=': (False, 44), '*': (True, 1482), ';': (False, 44), '-': (True, 1471), '<': (False, 44), 'end': (False, 44), 'or': (False, 44), '/': (True, 1485), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 1484), '<=': (False, 44)}, {'::': (False, 10), 'break': (False, 10), 'if': (False, 10), 'EMBEDSTAT': (False, 10), 'function': (False, 10), 'EOF': (False, 10), 'do': (False, 10), 'while': (False, 10), ';': (False, 10), 'repeat': (False, 10), 'for': (False, 10), '=': (False, 10), 'local': (False, 10), 'return': (False, 10), 'NAME': (False, 10), '(': (False, 10), 'goto': (False, 10)}, {'NAME': (True, 2253)}, {'-': (True, 1725), 'false': (True, 1726), 'functiondef': (True, 1727), 'explist': (True, 2232), 'functioncall': (True, 1741), 'var': (True, 1731), 'tableconstructor': (True, 1729), 'EMBEDEXPR': (True, 1733), 'exp': (True, 1743), '{': (True, 1735), 'function': (True, 1732), '#': (True, 1738), 'nil': (True, 1737), 'STRING': (True, 1745), 'true': (True, 1744), '(': (True, 1730), 'not': (True, 1742), 'prefixexp': (True, 1728), 'NAME': (True, 1739), '...': (True, 1740), 'NUMBER': (True, 1736)}, {'::': (False, 77), 'break': (False, 77), 'if': (False, 77), 'EMBEDSTAT': (False, 77), 'function': (False, 77), 'EOF': (False, 77), 'do': (False, 77), 'while': (False, 77), 'NAME': (False, 77), 'goto': (False, 77), 'for': (False, 77), 'local': (False, 77), 'return': (False, 77), ';': (False, 77), '(': (False, 77), 'repeat': (False, 77)}, {'funcbody': (True, 2237), '(': (True, 2207)}, {'..': (False, 50), '::': (False, 50), '~=': (False, 50), 'break': (False, 50), '>': (False, 50), '^': (True, 1367), 'while': (False, 50), '-': (False, 50), '<': (False, 50), 'or': (False, 50), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ',': (False, 50), '(': (False, 50), 'if': (False, 50), '>=': (False, 50), '%': (True, 1540), 'repeat': (False, 50), '+': (False, 50), '==': (False, 50), 'EMBEDSTAT': (False, 50), 'function': (False, 50), '*': (True, 1537), 'do': (False, 50), 'NAME': (False, 50), 'goto': (False, 50), 'end': (False, 50), 'for': (False, 50), '/': (True, 1541), 'elseif': (False, 50), ';': (False, 50), 'else': (False, 50), '<=': (False, 50)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 2243), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'end': (True, 2244)}, {'..': (False, 49), '::': (False, 49), '~=': (False, 49), 'break': (False, 49), 'end': (False, 49), '^': (True, 1367), 'while': (False, 49), '-': (False, 49), 'and': (False, 49), 'or': (False, 49), 'local': (False, 49), 'return': (False, 49), '>': (False, 49), '<': (False, 49), ',': (False, 49), '(': (False, 49), 'if': (False, 49), '>=': (False, 49), '%': (True, 1540), 'goto': (False, 49), '+': (False, 49), '==': (False, 49), 'EMBEDSTAT': (False, 49), 'function': (False, 49), '*': (True, 1537), 'do': (False, 49), ';': (False, 49), 'repeat': (False, 49), 'for': (False, 49), '/': (True, 1541), 'elseif': (False, 49), 'NAME': (False, 49), 'else': (False, 49), '<=': (False, 49)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), ',': (False, 51), 'if': (False, 51), '^': (True, 1367), 'while': (False, 51), '/': (False, 51), '-': (False, 51), 'and': (False, 51), 'or': (False, 51), 'local': (False, 51), 'return': (False, 51), '<': (False, 51), 'NAME': (False, 51), '(': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '+': (False, 51), '==': (False, 51), 'EMBEDSTAT': (False, 51), 'function': (False, 51), '*': (False, 51), 'do': (False, 51), 'goto': (False, 51), 'end': (False, 51), 'for': (False, 51), '>': (False, 51), 'elseif': (False, 51), ';': (False, 51), 'else': (False, 51), '<=': (False, 51)}, {'..': (True, 1527), '::': (False, 40), '~=': (True, 1529), 'break': (False, 40), ',': (False, 40), '>': (True, 1532), '^': (True, 1367), 'while': (False, 40), '-': (True, 1535), 'and': (True, 1528), 'or': (False, 40), 'local': (False, 40), 'return': (False, 40), '<': (True, 1533), 'NAME': (False, 40), '(': (False, 40), 'if': (False, 40), '>=': (True, 1539), '%': (True, 1540), 'goto': (False, 40), '+': (True, 1536), '==': (True, 1531), 'EMBEDSTAT': (False, 40), 'function': (False, 40), '*': (True, 1537), 'do': (False, 40), 'repeat': (False, 40), 'end': (False, 40), 'for': (False, 40), '/': (True, 1541), 'elseif': (False, 40), ';': (False, 40), 'else': (False, 40), '<=': (True, 1542)}, {'..': (True, 1527), '::': (False, 45), '~=': (False, 45), 'break': (False, 45), ',': (False, 45), 'if': (False, 45), '^': (True, 1367), 'while': (False, 45), '-': (True, 1535), '<': (False, 45), 'or': (False, 45), 'local': (False, 45), 'return': (False, 45), '>': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), '>=': (False, 45), '%': (True, 1540), 'goto': (False, 45), '+': (True, 1536), '==': (False, 45), 'EMBEDSTAT': (False, 45), 'function': (False, 45), '*': (True, 1537), 'do': (False, 45), 'repeat': (False, 45), 'end': (False, 45), 'for': (False, 45), '/': (True, 1541), 'elseif': (False, 45), ';': (False, 45), 'else': (False, 45), '<=': (False, 45)}, {'..': (False, 53), '::': (False, 53), '~=': (False, 53), 'break': (False, 53), 'if': (False, 53), '^': (True, 1367), 'while': (False, 53), '-': (False, 53), '<': (False, 53), 'or': (False, 53), 'local': (False, 53), 'return': (False, 53), '>': (False, 53), 'and': (False, 53), ',': (False, 53), '(': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '+': (False, 53), '==': (False, 53), 'EMBEDSTAT': (False, 53), 'function': (False, 53), '*': (False, 53), 'do': (False, 53), 'NAME': (False, 53), 'repeat': (False, 53), 'end': (False, 53), 'for': (False, 53), '/': (False, 53), 'elseif': (False, 53), ';': (False, 53), 'else': (False, 53), '<=': (False, 53)}, {'..': (False, 52), '::': (False, 52), '~=': (False, 52), 'break': (False, 52), ',': (False, 52), 'if': (False, 52), '^': (True, 1367), 'while': (False, 52), '/': (False, 52), '-': (False, 52), 'and': (False, 52), 'or': (False, 52), 'local': (False, 52), 'return': (False, 52), '>': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '+': (False, 52), '==': (False, 52), 'EMBEDSTAT': (False, 52), 'function': (False, 52), '*': (False, 52), 'do': (False, 52), 'goto': (False, 52), 'for': (False, 52), 'end': (False, 52), 'elseif': (False, 52), ';': (False, 52), 'else': (False, 52), '<=': (False, 52)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'goto': (False, 9), '+': (False, 9), '==': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'EOF': (False, 9), '*': (False, 9), 'do': (False, 9), 'repeat': (False, 9), 'for': (False, 9), '/': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'..': (True, 1527), '::': (False, 44), '~=': (False, 44), 'break': (False, 44), ',': (False, 44), 'if': (False, 44), 'elseif': (False, 44), '^': (True, 1367), 'while': (False, 44), '-': (True, 1535), 'and': (False, 44), 'or': (False, 44), 'local': (False, 44), 'return': (False, 44), '<': (False, 44), 'NAME': (False, 44), '(': (False, 44), '>=': (False, 44), '%': (True, 1540), 'repeat': (False, 44), '+': (True, 1536), '==': (False, 44), 'EMBEDSTAT': (False, 44), 'function': (False, 44), '*': (True, 1537), 'do': (False, 44), 'goto': (False, 44), 'end': (False, 44), 'for': (False, 44), '/': (True, 1541), '>': (False, 44), ';': (False, 44), 'else': (False, 44), '<=': (False, 44)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 2470), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), ';': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), 'until': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 54), '::': (False, 54), '~=': (False, 54), 'break': (False, 54), ',': (False, 54), 'if': (False, 54), '^': (True, 1367), 'while': (False, 54), '/': (False, 54), '-': (False, 54), '<': (False, 54), 'or': (False, 54), 'local': (False, 54), 'return': (False, 54), '>': (False, 54), 'and': (False, 54), 'NAME': (False, 54), '(': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '+': (False, 54), '==': (False, 54), 'EMBEDSTAT': (False, 54), 'function': (False, 54), '*': (False, 54), 'do': (False, 54), 'repeat': (False, 54), 'for': (False, 54), 'end': (False, 54), 'elseif': (False, 54), ';': (False, 54), 'else': (False, 54), '<=': (False, 54)}, {'end': (False, 99), 'stat__2': (True, 2257), 'else': (True, 1555)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'until': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '/': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2419), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {')': (True, 2421)}, {'stat__1': (True, 2508), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {')': (True, 2513)}, {'::': (False, 29), 'break': (False, 29), '(': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 2319), ';': (False, 29), 'NAME': (False, 29), 'repeat': (False, 29), 'for': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 1549), '?>': (False, 29), 'goto': (False, 29)}, {'::': (False, 70), 'break': (False, 70), 'if': (False, 70), 'EMBEDSTAT': (False, 70), 'function': (False, 70), 'do': (False, 70), 'while': (False, 70), 'NAME': (False, 70), 'goto': (False, 70), 'for': (False, 70), 'until': (False, 70), 'local': (False, 70), 'return': (False, 70), ';': (False, 70), '(': (False, 70), 'repeat': (False, 70)}, {'::': (False, 104), 'break': (False, 104), '(': (False, 104), 'if': (False, 104), 'EMBEDSTAT': (False, 104), 'function': (False, 104), 'do': (False, 104), 'while': (False, 104), ';': (False, 104), 'goto': (False, 104), 'for': (False, 104), 'local': (False, 104), 'return': (False, 104), 'NAME': (False, 104), '?>': (False, 104), 'repeat': (False, 104)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), ',': (False, 86), '>': (False, 86), '/': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), ';': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'goto': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), 'repeat': (False, 86), 'STRING': (False, 86), ':': (False, 86), 'for': (False, 86), 'end': (False, 86), 'elseif': (False, 86), 'NAME': (False, 86), 'else': (False, 86), '<=': (False, 86)}, {'args': (True, 2211), '{': (True, 1316), 'tableconstructor': (True, 1314), '(': (True, 1313), 'STRING': (True, 1311)}, {')': (True, 2490)}, {'::': (False, 76), 'break': (False, 76), '(': (False, 76), 'if': (False, 76), 'EMBEDSTAT': (False, 76), 'function': (False, 76), 'do': (False, 76), 'while': (False, 76), ';': (False, 76), 'goto': (False, 76), 'for': (False, 76), 'local': (False, 76), 'return': (False, 76), 'NAME': (False, 76), '?>': (False, 76), 'repeat': (False, 76)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2517), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'}': (True, 2515)}, {'end': (True, 2535)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2158), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), '>': (False, 85), 'if': (False, 85), '^': (False, 85), 'end': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'repeat': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), ';': (False, 85), 'goto': (False, 85), 'STRING': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), 'elseif': (False, 85), 'NAME': (False, 85), 'else': (False, 85), '<=': (False, 85)}, {'::': (False, 74), 'break': (False, 74), 'if': (False, 74), 'EMBEDSTAT': (False, 74), 'function': (False, 74), 'do': (False, 74), 'while': (False, 74), '}': (False, 74), 'goto': (False, 74), 'for': (False, 74), 'NAME': (False, 74), 'local': (False, 74), 'return': (False, 74), ';': (False, 74), '(': (False, 74), 'repeat': (False, 74)}, {'end': (False, 98)}, {'::': (False, 72), 'break': (False, 72), 'if': (False, 72), 'EMBEDSTAT': (False, 72), 'function': (False, 72), 'do': (False, 72), 'while': (False, 72), ';': (False, 72), 'goto': (False, 72), 'for': (False, 72), 'end': (False, 72), 'local': (False, 72), 'return': (False, 72), 'NAME': (False, 72), '(': (False, 72), 'repeat': (False, 72)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), '(': (False, 57), '==': (False, 57), 'if': (False, 57), '<': (False, 57), '^': (True, 2260), 'function': (False, 57), '+': (False, 57), '*': (False, 57), 'do': (False, 57), 'while': (False, 57), '/': (False, 57), 'repeat': (False, 57), '-': (False, 57), 'EMBEDSTAT': (False, 57), 'for': (False, 57), '>': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), ';': (False, 57), '?>': (False, 57), 'or': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '<=': (False, 57)}, {'::': (False, 74), 'break': (False, 74), 'if': (False, 74), 'EMBEDSTAT': (False, 74), 'function': (False, 74), 'do': (False, 74), 'while': (False, 74), 'NAME': (False, 74), 'goto': (False, 74), 'for': (False, 74), 'end': (False, 74), 'local': (False, 74), 'return': (False, 74), ';': (False, 74), '(': (False, 74), 'repeat': (False, 74)}, {'NAME': (True, 2548)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '?>': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2551)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2553), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2555), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), 'NAME': (False, 21), '?>': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), 'NAME': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), ';': (False, 24), '?>': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2561), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '/': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), ';': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), 'end': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'-': (True, 401), ')': (True, 2259), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 62), '::': (False, 62), '+': (False, 62), 'break': (False, 62), '?>': (False, 62), '==': (False, 62), 'if': (False, 62), '^': (False, 62), 'function': (False, 62), '~=': (False, 62), '*': (False, 62), 'do': (False, 62), 'while': (False, 62), ';': (False, 62), '/': (False, 62), 'repeat': (False, 62), '-': (False, 62), 'EMBEDSTAT': (False, 62), 'or': (False, 62), '>': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), '<': (False, 62), 'NAME': (False, 62), '(': (False, 62), 'for': (False, 62), '>=': (False, 62), '%': (False, 62), 'goto': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2440), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'..': (True, 1351), '::': (False, 48), '+': (True, 1353), 'break': (False, 48), '==': (False, 48), 'if': (False, 48), '<': (False, 48), 'local': (False, 48), '^': (True, 1358), 'function': (False, 48), '~=': (False, 48), '*': (True, 1361), 'do': (False, 48), 'while': (False, 48), 'NAME': (False, 48), 'goto': (False, 48), '-': (True, 1352), 'EMBEDSTAT': (False, 48), 'for': (False, 48), 'until': (False, 48), '/': (True, 1355), '>': (False, 48), 'return': (False, 48), 'and': (False, 48), ';': (False, 48), '(': (False, 48), 'or': (False, 48), '>=': (False, 48), '%': (True, 1364), 'repeat': (False, 48), '<=': (False, 48)}, {'..': (False, 50), '::': (False, 50), '+': (False, 50), 'break': (False, 50), '==': (False, 50), '>': (False, 50), '<': (False, 50), '^': (True, 1358), 'function': (False, 50), '~=': (False, 50), '*': (True, 1361), 'do': (False, 50), 'while': (False, 50), 'if': (False, 50), 'NAME': (False, 50), 'repeat': (False, 50), '-': (False, 50), 'EMBEDSTAT': (False, 50), 'or': (False, 50), 'until': (False, 50), '/': (True, 1355), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ';': (False, 50), '(': (False, 50), 'for': (False, 50), '>=': (False, 50), '%': (True, 1364), 'goto': (False, 50), '<=': (False, 50)}, {'..': (False, 49), '::': (False, 49), '+': (False, 49), 'break': (False, 49), '==': (False, 49), 'if': (False, 49), '<': (False, 49), '^': (True, 1358), 'function': (False, 49), '~=': (False, 49), '*': (True, 1361), 'do': (False, 49), 'while': (False, 49), 'NAME': (False, 49), 'repeat': (False, 49), '-': (False, 49), 'EMBEDSTAT': (False, 49), 'for': (False, 49), 'until': (False, 49), '/': (True, 1355), 'local': (False, 49), 'return': (False, 49), '>': (False, 49), 'and': (False, 49), ';': (False, 49), '(': (False, 49), 'or': (False, 49), '>=': (False, 49), '%': (True, 1364), 'goto': (False, 49), '<=': (False, 49)}, {'..': (True, 1351), '::': (False, 47), '+': (True, 1353), 'break': (False, 47), '==': (False, 47), 'if': (False, 47), '<': (False, 47), 'local': (False, 47), '^': (True, 1358), 'function': (False, 47), '~=': (False, 47), '*': (True, 1361), 'do': (False, 47), 'while': (False, 47), ';': (False, 47), 'goto': (False, 47), '-': (True, 1352), 'EMBEDSTAT': (False, 47), 'for': (False, 47), 'until': (False, 47), '/': (True, 1355), '>': (False, 47), 'return': (False, 47), 'and': (False, 47), 'NAME': (False, 47), '(': (False, 47), 'or': (False, 47), '>=': (False, 47), '%': (True, 1364), 'repeat': (False, 47), '<=': (False, 47)}, {'}': (True, 2495)}, {'..': (False, 52), '::': (False, 52), '+': (False, 52), 'break': (False, 52), '==': (False, 52), 'if': (False, 52), '^': (True, 1358), 'function': (False, 52), '~=': (False, 52), '*': (False, 52), 'do': (False, 52), 'while': (False, 52), 'and': (False, 52), ';': (False, 52), 'goto': (False, 52), '-': (False, 52), 'EMBEDSTAT': (False, 52), 'for': (False, 52), 'until': (False, 52), '/': (False, 52), 'local': (False, 52), 'return': (False, 52), '>': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), 'or': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '<=': (False, 52)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), ',': (False, 86), '/': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), 'NAME': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), 'end': (False, 86), '>': (False, 86), ';': (False, 86), '<=': (False, 86)}, {'..': (True, 1351), '::': (False, 41), '+': (True, 1353), 'break': (False, 41), '==': (True, 1354), '>': (True, 1357), '^': (True, 1358), 'function': (False, 41), '~=': (True, 1360), '*': (True, 1361), 'do': (False, 41), 'or': (False, 41), 'while': (False, 41), ';': (False, 41), 'repeat': (False, 41), '-': (True, 1352), 'EMBEDSTAT': (False, 41), 'for': (False, 41), 'until': (False, 41), '/': (True, 1355), 'local': (False, 41), 'return': (False, 41), 'and': (False, 41), '<': (True, 1359), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1363), '%': (True, 1364), 'goto': (False, 41), '<=': (True, 1365)}, {'..': (False, 62), '+': (False, 62), '==': (False, 62), '>': (False, 62), '^': (False, 62), '~=': (False, 62), 'EOF': (False, 62), '*': (False, 62), ';': (False, 62), '-': (False, 62), 'and': (False, 62), 'or': (False, 62), '/': (False, 62), '<': (False, 62), ',': (False, 62), '>=': (False, 62), '%': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2303), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'args': (True, 2309), '{': (True, 1811), 'tableconstructor': (True, 1813), '(': (True, 1810), 'STRING': (True, 1808)}, {'..': (False, 56), '+': (False, 56), '==': (False, 56), '>': (False, 56), '^': (True, 2287), '~=': (False, 56), 'EOF': (False, 56), '*': (False, 56), ';': (False, 56), '-': (False, 56), 'and': (False, 56), 'or': (False, 56), '/': (False, 56), '<': (False, 56), ',': (False, 56), '>=': (False, 56), '%': (False, 56), '<=': (False, 56)}, {'..': (True, 1351), '::': (False, 43), '+': (True, 1353), 'break': (False, 43), '==': (False, 43), 'if': (False, 43), '<': (False, 43), 'local': (False, 43), '^': (True, 1358), 'function': (False, 43), '~=': (False, 43), '*': (True, 1361), 'do': (False, 43), 'while': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), '-': (True, 1352), 'EMBEDSTAT': (False, 43), 'for': (False, 43), 'until': (False, 43), '/': (True, 1355), '>': (False, 43), 'return': (False, 43), 'and': (False, 43), ';': (False, 43), '(': (False, 43), 'or': (False, 43), '>=': (False, 43), '%': (True, 1364), 'goto': (False, 43), '<=': (False, 43)}, {')': (True, 2542)}, {'..': (False, 54), '::': (False, 54), '+': (False, 54), 'break': (False, 54), '==': (False, 54), '/': (False, 54), '<': (False, 54), '^': (True, 1358), 'function': (False, 54), '~=': (False, 54), '*': (False, 54), 'do': (False, 54), 'while': (False, 54), 'if': (False, 54), 'NAME': (False, 54), 'repeat': (False, 54), '-': (False, 54), 'EMBEDSTAT': (False, 54), 'or': (False, 54), 'until': (False, 54), '>': (False, 54), 'local': (False, 54), 'return': (False, 54), 'and': (False, 54), ';': (False, 54), '(': (False, 54), 'for': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '<=': (False, 54)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '?>': (False, 56), '==': (False, 56), 'if': (False, 56), '^': (True, 2260), 'function': (False, 56), '+': (False, 56), '*': (False, 56), 'do': (False, 56), 'while': (False, 56), 'and': (False, 56), ';': (False, 56), 'repeat': (False, 56), '-': (False, 56), 'EMBEDSTAT': (False, 56), 'or': (False, 56), '/': (False, 56), 'local': (False, 56), 'return': (False, 56), '>': (False, 56), '<': (False, 56), 'NAME': (False, 56), '(': (False, 56), 'for': (False, 56), '>=': (False, 56), '%': (False, 56), 'goto': (False, 56), '<=': (False, 56)}, {'}': (True, 2316)}, {'..': (True, 1351), '::': (False, 42), '+': (True, 1353), 'break': (False, 42), '==': (False, 42), 'if': (False, 42), '<': (False, 42), 'local': (False, 42), '^': (True, 1358), 'function': (False, 42), '~=': (False, 42), '*': (True, 1361), 'do': (False, 42), 'while': (False, 42), 'NAME': (False, 42), 'goto': (False, 42), '-': (True, 1352), 'EMBEDSTAT': (False, 42), 'for': (False, 42), 'until': (False, 42), '/': (True, 1355), '>': (False, 42), 'return': (False, 42), 'and': (False, 42), ';': (False, 42), '(': (False, 42), 'or': (False, 42), '>=': (False, 42), '%': (True, 1364), 'repeat': (False, 42), '<=': (False, 42)}, {'NAME': (True, 2262)}, {'.': (False, 25), '..': (False, 25), '+': (False, 25), ',': (False, 25), '==': (False, 25), '{': (False, 25), '>': (False, 25), '^': (False, 25), '~=': (False, 25), 'EOF': (False, 25), '*': (False, 25), 'STRING': (False, 25), '-': (False, 25), 'and': (False, 25), ':': (False, 25), 'or': (False, 25), '/': (False, 25), '[': (False, 25), '<': (False, 25), ';': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2294)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2298), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2299), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'.': (False, 21), '..': (False, 21), '+': (False, 21), ',': (False, 21), '==': (False, 21), '{': (False, 21), '/': (False, 21), '^': (False, 21), '~=': (False, 21), 'EOF': (False, 21), '*': (False, 21), 'STRING': (False, 21), '-': (False, 21), '<': (False, 21), ':': (False, 21), 'or': (False, 21), '>': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '.': (False, 24), '+': (False, 24), ',': (False, 24), '==': (False, 24), '{': (False, 24), '>': (False, 24), '^': (False, 24), '~=': (False, 24), 'EOF': (False, 24), '*': (False, 24), 'STRING': (False, 24), '-': (False, 24), '<': (False, 24), ':': (False, 24), 'or': (False, 24), '/': (False, 24), '[': (False, 24), 'and': (False, 24), ';': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), '(': (True, 179), 'var': (True, 170), 'function': (True, 171), 'EMBEDEXPR': (True, 172), 'tableconstructor': (True, 168), 'NUMBER': (True, 183), 'nil': (True, 174), '#': (True, 175), 'NAME': (True, 176), '...': (True, 182), 'functioncall': (True, 169), '{': (True, 173), 'not': (True, 180), 'exp': (True, 2304), 'true': (True, 178), 'STRING': (True, 177)}, {'..': (True, 1351), '::': (False, 46), '+': (True, 1353), 'break': (False, 46), '==': (False, 46), '>': (False, 46), '<': (False, 46), '^': (True, 1358), 'function': (False, 46), '~=': (False, 46), '*': (True, 1361), 'do': (False, 46), 'or': (False, 46), 'while': (False, 46), 'NAME': (False, 46), 'repeat': (False, 46), '-': (True, 1352), 'EMBEDSTAT': (False, 46), 'for': (False, 46), 'until': (False, 46), '/': (True, 1355), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), ';': (False, 46), '(': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 1364), 'goto': (False, 46), '<=': (False, 46)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2474), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 57), '+': (False, 57), '==': (False, 57), '>': (False, 57), '^': (True, 2287), '~=': (False, 57), 'EOF': (False, 57), '*': (False, 57), ';': (False, 57), '-': (False, 57), 'and': (False, 57), 'or': (False, 57), '/': (False, 57), '<': (False, 57), ',': (False, 57), '>=': (False, 57), '%': (False, 57), '<=': (False, 57)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), ']': (False, 6), '*': (False, 6), '-': (False, 6), 'and': (False, 6), 'or': (False, 6), '/': (False, 6), '<': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {'::': (False, 75), 'break': (False, 75), 'if': (False, 75), 'EMBEDSTAT': (False, 75), 'function': (False, 75), 'EOF': (False, 75), 'do': (False, 75), 'while': (False, 75), 'NAME': (False, 75), 'goto': (False, 75), 'for': (False, 75), 'local': (False, 75), 'return': (False, 75), ';': (False, 75), '(': (False, 75), 'repeat': (False, 75)}, {')': (False, 97), 'funcbody__1': (True, 2245), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'(': (False, 4)}, {'end': (True, 2248)}, {'::': (False, 92), 'break': (False, 92), 'if': (False, 92), 'EMBEDSTAT': (False, 92), 'function': (False, 92), 'do': (False, 92), 'while': (False, 92), ';': (False, 92), 'goto': (False, 92), 'for': (False, 92), 'end': (False, 92), 'local': (False, 92), 'return': (False, 92), 'NAME': (False, 92), '(': (False, 92), 'repeat': (False, 92)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), ',': (False, 22), 'if': (False, 22), '^': (False, 22), 'end': (False, 22), 'while': (False, 22), '/': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '>': (False, 22), 'elseif': (False, 22), ';': (False, 22), 'else': (False, 22), '<=': (False, 22)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2471), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2472), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), ',': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'end': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), '[': (False, 86), 'and': (False, 86), ';': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), ',': (False, 86), '>': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), 'NAME': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), 'EOF': (False, 86), '*': (False, 86), 'do': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), '/': (False, 86), ';': (False, 86), '<=': (False, 86)}, {'args': (True, 2476), '{': (True, 1444), 'tableconstructor': (True, 1446), '(': (True, 1443), 'STRING': (True, 1441)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'goto': (False, 9), '+': (False, 9), '==': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'repeat': (False, 9), 'for': (False, 9), 'end': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'args': (True, 2478), '{': (True, 1764), 'tableconstructor': (True, 1766), '(': (True, 1763), 'STRING': (True, 1761)}, {')': (True, 2233)}, {')': (True, 2443)}, {'}': (True, 2546)}, {'end': (True, 2308)}, {'}': (True, 2516)}, {'..': (False, 86), '::': (False, 86), '~=': (False, 86), 'break': (False, 86), '/': (False, 86), '^': (False, 86), 'while': (False, 86), '-': (False, 86), 'and': (False, 86), 'or': (False, 86), 'local': (False, 86), 'return': (False, 86), '[': (False, 86), '<': (False, 86), ';': (False, 86), '(': (False, 86), 'if': (False, 86), '>=': (False, 86), '%': (False, 86), 'STRING': (False, 86), '.': (False, 86), '+': (False, 86), '==': (False, 86), '{': (False, 86), 'EMBEDSTAT': (False, 86), 'function': (False, 86), '*': (False, 86), 'do': (False, 86), 'goto': (False, 86), 'repeat': (False, 86), ':': (False, 86), 'for': (False, 86), 'end': (False, 86), '>': (False, 86), 'NAME': (False, 86), '<=': (False, 86)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'goto': (False, 9), '+': (False, 9), '==': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'repeat': (False, 9), 'for': (False, 9), '/': (False, 9), '>': (False, 9), ';': (False, 9), '?>': (False, 9), '<=': (False, 9)}, {'args': (True, 2518), '{': (True, 1662), 'tableconstructor': (True, 1664), '(': (True, 1661), 'STRING': (True, 1659)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2511), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'::': (False, 92), 'break': (False, 92), 'if': (False, 92), 'EMBEDSTAT': (False, 92), 'function': (False, 92), 'do': (False, 92), 'while': (False, 92), ';': (False, 92), 'goto': (False, 92), 'for': (False, 92), 'until': (False, 92), 'local': (False, 92), 'return': (False, 92), 'NAME': (False, 92), '(': (False, 92), 'repeat': (False, 92)}, {')': (True, 2362)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2349), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'}': (True, 2347)}, {'::': (False, 104), 'break': (False, 104), 'if': (False, 104), 'EMBEDSTAT': (False, 104), 'function': (False, 104), 'EOF': (False, 104), 'do': (False, 104), 'while': (False, 104), ';': (False, 104), 'goto': (False, 104), 'for': (False, 104), 'local': (False, 104), 'return': (False, 104), 'NAME': (False, 104), '(': (False, 104), 'repeat': (False, 104)}, {'.': (False, 23), '..': (False, 23), '+': (False, 23), ',': (False, 23), '==': (False, 23), '{': (False, 23), 'end': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), '/': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '>': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2473), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2539), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'::': (False, 28), 'break': (False, 28), 'if': (False, 28), 'EMBEDSTAT': (False, 28), 'function': (False, 28), 'do': (False, 28), 'while': (False, 28), 'NAME': (False, 28), 'repeat': (False, 28), 'for': (False, 28), 'until': (False, 28), '=': (False, 28), 'local': (False, 28), 'return': (False, 28), ';': (False, 28), '(': (False, 28), 'goto': (False, 28)}, {'::': (False, 76), 'break': (False, 76), 'if': (False, 76), 'EMBEDSTAT': (False, 76), 'function': (False, 76), 'EOF': (False, 76), 'do': (False, 76), 'while': (False, 76), ';': (False, 76), 'goto': (False, 76), 'for': (False, 76), 'local': (False, 76), 'return': (False, 76), 'NAME': (False, 76), '(': (False, 76), 'repeat': (False, 76)}, {')': (True, 2371)}, {'-': (True, 1047), '^': (True, 925), '+': (True, 1048), '==': (True, 1049), 'or': (True, 1050), '>': (True, 1052), 'and': (True, 1051), '<': (True, 1053), '~=': (True, 1054), '*': (True, 1055), 'do': (False, 102), '>=': (True, 1057), '%': (True, 1058), '/': (True, 1059), '..': (True, 1046), '<=': (True, 1060)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2487), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), '}': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), '>': (False, 9), 'NAME': (False, 9), '<=': (False, 9)}, {'::': (False, 28), 'break': (False, 28), 'if': (False, 28), 'EMBEDSTAT': (False, 28), 'function': (False, 28), 'do': (False, 28), 'while': (False, 28), 'NAME': (False, 28), '=': (False, 28), 'goto': (False, 28), 'for': (False, 28), 'end': (False, 28), 'local': (False, 28), 'return': (False, 28), ';': (False, 28), '(': (False, 28), 'repeat': (False, 28)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 2063), 'stat__3': (True, 2545), '*': (True, 612), 'do': (False, 103), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'::': (False, 70), 'break': (False, 70), 'if': (False, 70), 'elseif': (False, 70), 'EMBEDSTAT': (False, 70), 'function': (False, 70), 'do': (False, 70), 'while': (False, 70), 'NAME': (False, 70), 'goto': (False, 70), 'for': (False, 70), 'end': (False, 70), 'local': (False, 70), 'return': (False, 70), ';': (False, 70), '(': (False, 70), 'repeat': (False, 70), 'else': (False, 70)}, {')': (True, 2541)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ',': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (True, 231), '-': (True, 232), '+': (True, 233), ',': (False, 81), '==': (True, 234), 'or': (True, 235), '<': (True, 240), '/': (True, 237), '>': (True, 238), 'and': (True, 236), '^': (True, 239), '~=': (True, 241), '*': (True, 242), '>=': (True, 243), '%': (True, 244), ';': (False, 81), '}': (False, 81), '<=': (True, 245)}, {'::': (False, 72), 'break': (False, 72), 'if': (False, 72), 'elseif': (False, 72), 'EMBEDSTAT': (False, 72), 'function': (False, 72), 'do': (False, 72), 'while': (False, 72), ';': (False, 72), 'goto': (False, 72), 'for': (False, 72), 'end': (False, 72), 'local': (False, 72), 'return': (False, 72), 'NAME': (False, 72), '(': (False, 72), 'repeat': (False, 72), 'else': (False, 72)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2499), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2500), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), 'NAME': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), '}': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), ',': (False, 86), '==': (False, 86), '{': (False, 86), '>': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), 'until': (False, 86), '/': (False, 86), '[': (False, 86), 'and': (False, 86), ';': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'::': (False, 29), 'break': (False, 29), 'if': (False, 29), 'EMBEDSTAT': (False, 29), 'function': (False, 29), 'EOF': (False, 29), 'do': (False, 29), 'while': (False, 29), 'namelist__1': (True, 2503), ';': (False, 29), 'NAME': (False, 29), 'goto': (False, 29), 'for': (False, 29), '=': (False, 29), 'local': (False, 29), 'return': (False, 29), ',': (True, 2123), '(': (False, 29), 'repeat': (False, 29)}, {'args': (True, 2505), '{': (True, 1613), 'tableconstructor': (True, 1615), '(': (True, 1612), 'STRING': (True, 1610)}, {')': (True, 2482)}, {'}': (True, 2543)}, {'end': (True, 2544)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2557), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '/': (False, 13), '>': (False, 13), 'NAME': (False, 13), '?>': (False, 13), '<=': (False, 13)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2501), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), '(': (False, 55), '==': (False, 55), 'if': (False, 55), '<': (False, 55), 'local': (False, 55), '^': (True, 2260), 'function': (False, 55), '+': (False, 55), '*': (False, 55), 'do': (False, 55), 'while': (False, 55), ';': (False, 55), 'goto': (False, 55), '-': (False, 55), 'EMBEDSTAT': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'return': (False, 55), 'and': (False, 55), 'NAME': (False, 55), '?>': (False, 55), 'or': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '<=': (False, 55)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), ',': (False, 86), '==': (False, 86), '{': (False, 86), '>': (False, 86), '^': (False, 86), '+': (False, 86), 'EOF': (False, 86), '*': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '/': (False, 86), '[': (False, 86), 'and': (False, 86), ';': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), '<=': (False, 86)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2522), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2521), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2523), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2524), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2525), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'nil': (True, 1689), '#': (True, 1690), 'NAME': (True, 1691), 'function': (True, 1685), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'STRING': (True, 1697), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2526), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2527), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2528), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'nil': (True, 1689), '#': (True, 1690), 'NAME': (True, 1691), 'function': (True, 1685), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'STRING': (True, 1697), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2529), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2532), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2533), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2534), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2536), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1678), 'false': (True, 1679), 'functiondef': (True, 1680), 'exp': (True, 2537), 'functioncall': (True, 1693), 'var': (True, 1684), 'tableconstructor': (True, 1682), 'EMBEDEXPR': (True, 1686), '{': (True, 1687), 'function': (True, 1685), '#': (True, 1690), 'nil': (True, 1689), 'STRING': (True, 1697), 'true': (True, 1696), '(': (True, 1683), 'not': (True, 1694), 'prefixexp': (True, 1681), 'NAME': (True, 1691), '...': (True, 1692), 'NUMBER': (True, 1688)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2603), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2604), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2606), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2607), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2608), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2609), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2610), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2612), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2613), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {';': (False, 90), 'EOF': (False, 90)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2614), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2615), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2616), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2617), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2295), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2480), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'-': (True, 1913), 'false': (True, 1914), 'functiondef': (True, 1915), 'exp': (True, 2485), 'functioncall': (True, 1909), 'var': (True, 1917), 'tableconstructor': (True, 1905), 'EMBEDEXPR': (True, 1906), '{': (True, 1919), 'function': (True, 1907), '#': (True, 1908), 'nil': (True, 1920), 'STRING': (True, 1912), 'true': (True, 1911), '(': (True, 1922), 'not': (True, 1923), 'prefixexp': (True, 1910), 'NAME': (True, 1921), '...': (True, 1925), 'NUMBER': (True, 1926)}, {'args': (True, 2318), '{': (True, 2198), 'tableconstructor': (True, 2200), '(': (True, 2197), 'STRING': (True, 2195)}, {'..': (True, 2277), '+': (True, 2279), '==': (False, 45), '>': (False, 45), '^': (True, 2287), '~=': (False, 45), 'EOF': (False, 45), '*': (True, 2290), ';': (False, 45), '-': (True, 2278), '<': (False, 45), 'or': (False, 45), '/': (True, 2284), 'and': (False, 45), ',': (False, 45), '>=': (False, 45), '%': (True, 2292), '<=': (False, 45)}, {'}': (True, 2530)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), ',': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '(': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '?>': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {')': (True, 2447)}, {'}': (True, 2397)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 2063), 'stat__3': (True, 2540), '*': (True, 612), 'do': (False, 103), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'-': (True, 401), ')': (True, 2368), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 55), '+': (False, 55), '==': (False, 55), '/': (False, 55), '^': (True, 2287), '~=': (False, 55), 'EOF': (False, 55), '*': (False, 55), ';': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), '>': (False, 55), '<': (False, 55), ',': (False, 55), '>=': (False, 55), '%': (False, 55), '<=': (False, 55)}, {')': (True, 2502)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2483), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), ';': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '/': (False, 13), '>': (False, 13), 'NAME': (False, 13), '?>': (False, 13), '<=': (False, 13)}, {'EOF': (False, 108)}, {'EOF': (False, 88)}, {'::': (False, 74), 'break': (False, 74), '?>': (False, 74), 'if': (False, 74), 'EMBEDSTAT': (False, 74), 'function': (False, 74), 'do': (False, 74), 'while': (False, 74), 'NAME': (False, 74), 'goto': (False, 74), 'for': (False, 74), 'local': (False, 74), 'return': (False, 74), ';': (False, 74), '(': (False, 74), 'repeat': (False, 74)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), ',': (False, 22), 'if': (False, 22), '^': (False, 22), 'end': (False, 22), 'while': (False, 22), '/': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'do': (True, 2317)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), ';': (False, 6), '-': (False, 6), 'and': (False, 6), 'or': (False, 6), '/': (False, 6), '<': (False, 6), ',': (False, 6), '?>': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 2063), 'stat__3': (True, 2361), '*': (True, 612), 'do': (False, 103), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'..': (False, 6), '::': (False, 6), '~=': (False, 6), 'break': (False, 6), ',': (False, 6), 'if': (False, 6), '^': (False, 6), 'while': (False, 6), '-': (False, 6), '<': (False, 6), 'or': (False, 6), 'local': (False, 6), 'return': (False, 6), 'and': (False, 6), 'NAME': (False, 6), '(': (False, 6), '>=': (False, 6), '%': (False, 6), 'repeat': (False, 6), '+': (False, 6), '==': (False, 6), 'EMBEDSTAT': (False, 6), 'function': (False, 6), '*': (False, 6), 'do': (False, 6), '}': (False, 6), 'goto': (False, 6), 'for': (False, 6), '/': (False, 6), '>': (False, 6), ';': (False, 6), '<=': (False, 6)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), ']': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), 'end': (False, 9), 'for': (False, 9), '>': (False, 9), ':': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2479), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 22), '.': (False, 22), '+': (False, 22), ',': (False, 22), '==': (False, 22), '{': (False, 22), '/': (False, 22), '^': (False, 22), '~=': (False, 22), 'EOF': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ';': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'::': (False, 28), 'break': (False, 28), '(': (False, 28), 'if': (False, 28), 'EMBEDSTAT': (False, 28), 'function': (False, 28), 'do': (False, 28), 'while': (False, 28), 'NAME': (False, 28), 'repeat': (False, 28), 'for': (False, 28), '=': (False, 28), 'local': (False, 28), 'return': (False, 28), ';': (False, 28), '?>': (False, 28), 'goto': (False, 28)}, {'..': (True, 1125), '-': (True, 1126), '+': (True, 1127), '==': (True, 1129), 'or': (True, 1130), '<': (True, 1135), '/': (True, 1132), '>': (True, 1133), 'and': (True, 1131), '^': (True, 1134), '>=': (True, 1138), ',': (True, 2531), '*': (True, 1137), '~=': (True, 1136), '%': (True, 1139), '<=': (True, 1140)}, {')': (True, 2601)}, {'.': (False, 23), '..': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), ',': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2398), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'..': (False, 31), '::': (False, 31), '~=': (False, 31), 'break': (False, 31), 'if': (False, 31), '^': (False, 31), 'while': (False, 31), '/': (False, 31), '-': (False, 31), 'and': (False, 31), 'or': (False, 31), 'local': (False, 31), 'return': (False, 31), '<': (False, 31), ';': (False, 31), '(': (False, 31), '>=': (False, 31), '%': (False, 31), 'goto': (False, 31), '+': (False, 31), '==': (False, 31), 'EMBEDSTAT': (False, 31), 'function': (False, 31), '*': (False, 31), 'do': (False, 31), 'repeat': (False, 31), 'end': (False, 31), 'for': (False, 31), '>': (False, 31), 'elseif': (False, 31), 'NAME': (False, 31), 'else': (False, 31), '<=': (False, 31)}, {'..': (False, 37), '::': (False, 37), '~=': (False, 37), 'break': (False, 37), '/': (False, 37), '^': (False, 37), 'while': (False, 37), '-': (False, 37), '<': (False, 37), 'or': (False, 37), 'local': (False, 37), 'return': (False, 37), 'and': (False, 37), 'NAME': (False, 37), '(': (False, 37), 'if': (False, 37), '>=': (False, 37), '%': (False, 37), 'goto': (False, 37), '+': (False, 37), '==': (False, 37), 'EMBEDSTAT': (False, 37), 'function': (False, 37), '*': (False, 37), 'do': (False, 37), 'repeat': (False, 37), 'end': (False, 37), 'for': (False, 37), '>': (False, 37), 'elseif': (False, 37), ';': (False, 37), 'else': (False, 37), '<=': (False, 37)}, {'..': (False, 38), '::': (False, 38), '~=': (False, 38), 'break': (False, 38), 'tableconstructor': (True, 2406), '>': (False, 38), 'if': (False, 38), '^': (False, 38), 'end': (False, 38), 'args': (True, 2405), 'while': (False, 38), '-': (False, 38), '<': (False, 38), 'or': (False, 38), 'local': (False, 38), 'return': (False, 38), '[': (True, 2407), 'and': (False, 38), 'NAME': (False, 38), '(': (True, 2403), '>=': (False, 38), '%': (False, 38), 'repeat': (False, 38), '.': (True, 2400), '+': (False, 38), '==': (False, 38), '{': (True, 2404), 'EMBEDSTAT': (False, 38), 'function': (False, 38), '*': (False, 38), 'do': (False, 38), 'goto': (False, 38), 'STRING': (True, 2401), ':': (True, 2402), 'for': (False, 38), '/': (False, 38), 'elseif': (False, 38), ';': (False, 38), 'else': (False, 38), '<=': (False, 38)}, {'..': (False, 39), '::': (False, 39), '~=': (False, 39), 'break': (False, 39), 'if': (False, 39), '^': (False, 39), 'while': (False, 39), '/': (False, 39), '-': (False, 39), '<': (False, 39), 'or': (False, 39), 'local': (False, 39), 'return': (False, 39), 'and': (False, 39), 'NAME': (False, 39), '(': (False, 39), '>=': (False, 39), '%': (False, 39), 'repeat': (False, 39), '+': (False, 39), '==': (False, 39), 'EMBEDSTAT': (False, 39), 'function': (False, 39), '*': (False, 39), 'do': (False, 39), 'goto': (False, 39), 'end': (False, 39), 'for': (False, 39), '>': (False, 39), 'elseif': (False, 39), ';': (False, 39), 'else': (False, 39), '<=': (False, 39)}, {'-': (True, 276), 'false': (True, 277), 'functiondef': (True, 278), 'exp': (True, 2410), 'functioncall': (True, 291), 'var': (True, 282), 'tableconstructor': (True, 280), 'EMBEDEXPR': (True, 284), '{': (True, 285), 'function': (True, 283), '#': (True, 287), 'nil': (True, 286), 'STRING': (True, 289), 'true': (True, 294), '(': (True, 281), 'not': (True, 292), 'prefixexp': (True, 293), 'NAME': (True, 288), '...': (True, 290), 'NUMBER': (True, 295)}, {'..': (False, 11), '::': (False, 11), '~=': (False, 11), 'break': (False, 11), 'if': (False, 11), '^': (False, 11), 'end': (False, 11), 'while': (False, 11), '/': (False, 11), '-': (False, 11), '<': (False, 11), 'or': (False, 11), 'local': (False, 11), 'return': (False, 11), '[': (False, 11), 'and': (False, 11), 'NAME': (False, 11), '(': (False, 11), '>=': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '+': (False, 11), '==': (False, 11), '{': (False, 11), 'EMBEDSTAT': (False, 11), 'function': (False, 11), 'repeat': (False, 11), '*': (False, 11), 'do': (False, 11), 'goto': (False, 11), ':': (False, 11), 'for': (False, 11), '>': (False, 11), 'elseif': (False, 11), ';': (False, 11), 'else': (False, 11), '<=': (False, 11)}, {'funcbody': (True, 2411), '(': (True, 2412)}, {'..': (False, 35), '::': (False, 35), '~=': (False, 35), 'break': (False, 35), 'end': (False, 35), '^': (False, 35), 'while': (False, 35), '-': (False, 35), 'and': (False, 35), 'or': (False, 35), 'local': (False, 35), 'return': (False, 35), '>': (False, 35), '<': (False, 35), 'NAME': (False, 35), '(': (False, 35), 'if': (False, 35), '>=': (False, 35), '%': (False, 35), 'goto': (False, 35), '+': (False, 35), '==': (False, 35), 'EMBEDSTAT': (False, 35), 'function': (False, 35), '*': (False, 35), 'do': (False, 35), 'repeat': (False, 35), 'for': (False, 35), '/': (False, 35), 'elseif': (False, 35), ';': (False, 35), 'else': (False, 35), '<=': (False, 35)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2413), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 33), '::': (False, 33), '~=': (False, 33), 'break': (False, 33), 'if': (False, 33), 'elseif': (False, 33), '^': (False, 33), 'while': (False, 33), '/': (False, 33), '-': (False, 33), 'and': (False, 33), 'or': (False, 33), 'local': (False, 33), 'return': (False, 33), '<': (False, 33), ';': (False, 33), '(': (False, 33), '>=': (False, 33), '%': (False, 33), 'repeat': (False, 33), '+': (False, 33), '==': (False, 33), 'EMBEDSTAT': (False, 33), 'function': (False, 33), '*': (False, 33), 'do': (False, 33), 'goto': (False, 33), 'for': (False, 33), 'end': (False, 33), '>': (False, 33), 'NAME': (False, 33), 'else': (False, 33), '<=': (False, 33)}, {'..': (False, 30), '::': (False, 30), '~=': (False, 30), 'break': (False, 30), 'if': (False, 30), '^': (False, 30), 'while': (False, 30), '/': (False, 30), '-': (False, 30), 'and': (False, 30), 'or': (False, 30), 'local': (False, 30), 'return': (False, 30), '<': (False, 30), ';': (False, 30), '(': (False, 30), '>=': (False, 30), '%': (False, 30), 'repeat': (False, 30), '+': (False, 30), '==': (False, 30), 'EMBEDSTAT': (False, 30), 'function': (False, 30), '*': (False, 30), 'do': (False, 30), 'goto': (False, 30), 'end': (False, 30), 'for': (False, 30), '>': (False, 30), 'elseif': (False, 30), 'NAME': (False, 30), 'else': (False, 30), '<=': (False, 30)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2415), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'..': (False, 84), '::': (False, 84), '~=': (False, 84), 'break': (False, 84), '/': (False, 84), '^': (False, 84), 'end': (False, 84), 'while': (False, 84), '-': (False, 84), '<': (False, 84), 'or': (False, 84), 'local': (False, 84), 'return': (False, 84), '[': (False, 84), 'and': (False, 84), ';': (False, 84), '(': (False, 84), 'if': (False, 84), '>=': (False, 84), '%': (False, 84), 'goto': (False, 84), '.': (False, 84), '+': (False, 84), '==': (False, 84), '{': (False, 84), 'EMBEDSTAT': (False, 84), 'function': (False, 84), '*': (False, 84), 'do': (False, 84), 'repeat': (False, 84), 'STRING': (False, 84), ':': (False, 84), 'for': (False, 84), '>': (False, 84), 'elseif': (False, 84), 'NAME': (False, 84), 'else': (False, 84), '<=': (False, 84)}, {'..': (False, 36), '::': (False, 36), '~=': (False, 36), 'break': (False, 36), 'if': (False, 36), '^': (False, 36), 'while': (False, 36), '/': (False, 36), '-': (False, 36), '<': (False, 36), 'or': (False, 36), 'local': (False, 36), 'return': (False, 36), '>': (False, 36), 'and': (False, 36), 'NAME': (False, 36), '(': (False, 36), '>=': (False, 36), '%': (False, 36), 'goto': (False, 36), '+': (False, 36), '==': (False, 36), 'EMBEDSTAT': (False, 36), 'function': (False, 36), '*': (False, 36), 'do': (False, 36), 'repeat': (False, 36), 'for': (False, 36), 'end': (False, 36), 'elseif': (False, 36), ';': (False, 36), 'else': (False, 36), '<=': (False, 36)}, {'..': (False, 12), '::': (False, 12), '~=': (False, 12), 'break': (False, 12), 'if': (False, 12), '^': (False, 12), 'end': (False, 12), 'while': (False, 12), '[': (False, 12), '-': (False, 12), '<': (False, 12), 'or': (False, 12), 'local': (False, 12), 'return': (False, 12), '>': (False, 12), 'and': (False, 12), ';': (False, 12), '(': (False, 12), '>=': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '+': (False, 12), '==': (False, 12), '{': (False, 12), 'EMBEDSTAT': (False, 12), 'function': (False, 12), '*': (False, 12), 'do': (False, 12), 'goto': (False, 12), 'repeat': (False, 12), ':': (False, 12), 'for': (False, 12), '/': (False, 12), 'elseif': (False, 12), 'NAME': (False, 12), 'else': (False, 12), '<=': (False, 12)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2451), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'..': (True, 2452), '::': (False, 71), '~=': (True, 2454), 'break': (False, 71), '/': (True, 2465), '^': (True, 2460), 'while': (False, 71), '-': (True, 2455), 'and': (True, 2453), 'or': (True, 2457), 'local': (False, 71), 'return': (False, 71), '<': (True, 2458), ';': (False, 71), '(': (False, 71), 'if': (False, 71), '>=': (True, 2463), '%': (True, 2464), 'repeat': (False, 71), '+': (True, 2461), '==': (True, 2456), 'EMBEDSTAT': (False, 71), 'function': (False, 71), '*': (True, 2462), 'do': (False, 71), 'goto': (False, 71), 'end': (False, 71), 'for': (False, 71), '>': (True, 2459), 'elseif': (False, 71), 'NAME': (False, 71), 'else': (False, 71), '<=': (True, 2466)}, {'..': (False, 32), '::': (False, 32), '~=': (False, 32), 'break': (False, 32), '/': (False, 32), '^': (False, 32), 'while': (False, 32), '-': (False, 32), 'and': (False, 32), 'or': (False, 32), 'local': (False, 32), 'return': (False, 32), '<': (False, 32), ';': (False, 32), '(': (False, 32), 'if': (False, 32), '>=': (False, 32), '%': (False, 32), 'repeat': (False, 32), '+': (False, 32), '==': (False, 32), 'EMBEDSTAT': (False, 32), 'function': (False, 32), '*': (False, 32), 'do': (False, 32), 'goto': (False, 32), 'end': (False, 32), 'for': (False, 32), '>': (False, 32), 'elseif': (False, 32), 'NAME': (False, 32), 'else': (False, 32), '<=': (False, 32)}, {'..': (False, 34), '::': (False, 34), '~=': (False, 34), 'break': (False, 34), 'if': (False, 34), '^': (False, 34), 'while': (False, 34), '-': (False, 34), 'and': (False, 34), 'or': (False, 34), 'local': (False, 34), 'return': (False, 34), '>': (False, 34), '<': (False, 34), ';': (False, 34), '(': (False, 34), '>=': (False, 34), '%': (False, 34), 'repeat': (False, 34), '+': (False, 34), '==': (False, 34), 'EMBEDSTAT': (False, 34), 'function': (False, 34), '*': (False, 34), 'do': (False, 34), 'goto': (False, 34), 'end': (False, 34), 'for': (False, 34), '/': (False, 34), 'elseif': (False, 34), 'NAME': (False, 34), 'else': (False, 34), '<=': (False, 34)}, {';': (False, 92), 'end': (False, 92)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2351), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'stat__1': (True, 2489), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {';': (False, 92), '}': (False, 92)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), 'end': (False, 9), 'for': (False, 9), '>': (False, 9), ':': (False, 9), 'NAME': (False, 9), '<=': (False, 9)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), '==': (False, 57), 'if': (False, 57), '<': (False, 57), '^': (True, 2432), 'function': (False, 57), '+': (False, 57), 'EOF': (False, 57), '*': (False, 57), 'do': (False, 57), 'while': (False, 57), '/': (False, 57), 'repeat': (False, 57), '-': (False, 57), 'EMBEDSTAT': (False, 57), 'for': (False, 57), '>': (False, 57), 'local': (False, 57), 'return': (False, 57), 'and': (False, 57), 'NAME': (False, 57), ';': (False, 57), '(': (False, 57), 'or': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '<=': (False, 57)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), 'EOF': (False, 85), '*': (False, 85), 'do': (False, 85), 'NAME': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {'::': (False, 70), 'break': (False, 70), 'if': (False, 70), 'EMBEDSTAT': (False, 70), 'function': (False, 70), 'do': (False, 70), 'while': (False, 70), '}': (False, 70), 'goto': (False, 70), 'for': (False, 70), 'NAME': (False, 70), 'local': (False, 70), 'return': (False, 70), ';': (False, 70), '(': (False, 70), 'repeat': (False, 70)}, {'end': (True, 2444)}, {'::': (False, 6), 'break': (False, 6), 'if': (False, 6), 'EMBEDSTAT': (False, 6), 'function': (False, 6), 'do': (False, 6), 'while': (False, 6), 'NAME': (False, 6), 'repeat': (False, 6), 'for': (False, 6), 'end': (False, 6), 'local': (False, 6), 'return': (False, 6), ';': (False, 6), '(': (False, 6), 'goto': (False, 6)}, {'NAME': (True, 2592)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), 'if': (False, 25), '^': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), 'EOF': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), '>': (False, 25), ';': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2593)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2594), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2596), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'while': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '[': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), 'repeat': (False, 21), 'EOF': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), '>': (False, 21), 'NAME': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), ';': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), 'EOF': (False, 24), '*': (False, 24), 'do': (False, 24), 'goto': (False, 24), ':': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), 'NAME': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2597), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'do': (True, 2598)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '/': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), 'end': (False, 23), '>': (False, 23), 'NAME': (False, 23), '<=': (False, 23)}, {'-': (True, 401), ')': (True, 2564), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 22), '.': (False, 22), '+': (False, 22), ',': (False, 22), '==': (False, 22), '{': (False, 22), '/': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ';': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '?>': (False, 22), '<=': (False, 22)}, {'..': (False, 62), '::': (False, 62), '+': (False, 62), 'break': (False, 62), '==': (False, 62), 'if': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '~=': (False, 62), 'EOF': (False, 62), '*': (False, 62), 'do': (False, 62), 'while': (False, 62), ';': (False, 62), '/': (False, 62), 'repeat': (False, 62), '-': (False, 62), '^': (False, 62), 'or': (False, 62), '>': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), '<': (False, 62), 'NAME': (False, 62), '(': (False, 62), 'for': (False, 62), '>=': (False, 62), '%': (False, 62), 'goto': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2620), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'}': (True, 2497)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), ',': (False, 13), '==': (False, 13), '{': (False, 13), '>': (False, 13), '^': (False, 13), '~=': (False, 13), 'EOF': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), 'and': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '[': (False, 13), '<': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), '<=': (False, 13)}, {'end': (True, 2370)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), 'do': (False, 6), '-': (False, 6), 'and': (False, 6), 'or': (False, 6), '/': (False, 6), '<': (False, 6), ',': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2372), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'end': (True, 2559)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '/': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), 'end': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2498), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'.': (False, 86), '..': (False, 86), '~=': (False, 86), ',': (False, 86), '==': (False, 86), '{': (False, 86), '/': (False, 86), '^': (False, 86), '+': (False, 86), '*': (False, 86), 'end': (False, 86), 'STRING': (False, 86), '-': (False, 86), '<': (False, 86), ':': (False, 86), 'or': (False, 86), '>': (False, 86), 'elseif': (False, 86), '[': (False, 86), 'and': (False, 86), ';': (False, 86), '(': (False, 86), '>=': (False, 86), '%': (False, 86), 'else': (False, 86), '<=': (False, 86)}, {'args': (True, 2622), '{': (True, 1959), 'tableconstructor': (True, 1961), '(': (True, 1958), 'STRING': (True, 1956)}, {')': (True, 2506)}, {'}': (True, 2509)}, {'..': (False, 50), '::': (False, 50), '+': (False, 50), 'break': (False, 50), '==': (False, 50), 'end': (False, 50), '<': (False, 50), '^': (True, 1710), 'function': (False, 50), '~=': (False, 50), '*': (True, 1713), 'do': (False, 50), 'while': (False, 50), 'if': (False, 50), 'NAME': (False, 50), 'repeat': (False, 50), '-': (False, 50), 'EMBEDSTAT': (False, 50), 'or': (False, 50), '/': (True, 1707), 'local': (False, 50), 'return': (False, 50), '>': (False, 50), 'and': (False, 50), ';': (False, 50), '(': (False, 50), 'for': (False, 50), '>=': (False, 50), '%': (True, 1716), 'goto': (False, 50), '<=': (False, 50)}, {'..': (True, 1703), '::': (False, 48), '+': (True, 1705), 'break': (False, 48), '==': (False, 48), 'end': (False, 48), 'local': (False, 48), '^': (True, 1710), 'function': (False, 48), '~=': (False, 48), '*': (True, 1713), 'do': (False, 48), 'while': (False, 48), 'if': (False, 48), 'NAME': (False, 48), 'goto': (False, 48), '-': (True, 1704), 'EMBEDSTAT': (False, 48), 'for': (False, 48), '/': (True, 1707), '>': (False, 48), 'return': (False, 48), 'and': (False, 48), '<': (False, 48), ';': (False, 48), '(': (False, 48), 'or': (False, 48), '>=': (False, 48), '%': (True, 1716), 'repeat': (False, 48), '<=': (False, 48)}, {'..': (False, 49), '::': (False, 49), '+': (False, 49), 'break': (False, 49), '==': (False, 49), 'end': (False, 49), '<': (False, 49), '^': (True, 1710), 'function': (False, 49), '~=': (False, 49), '*': (True, 1713), 'do': (False, 49), 'while': (False, 49), 'if': (False, 49), 'NAME': (False, 49), 'repeat': (False, 49), '-': (False, 49), 'EMBEDSTAT': (False, 49), 'for': (False, 49), '/': (True, 1707), 'local': (False, 49), 'return': (False, 49), '>': (False, 49), 'and': (False, 49), ';': (False, 49), '(': (False, 49), 'or': (False, 49), '>=': (False, 49), '%': (True, 1716), 'goto': (False, 49), '<=': (False, 49)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2442), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'..': (True, 1703), '::': (False, 47), '+': (True, 1705), 'break': (False, 47), '==': (False, 47), 'end': (False, 47), '<': (False, 47), 'local': (False, 47), '^': (True, 1710), 'function': (False, 47), '~=': (False, 47), '*': (True, 1713), 'do': (False, 47), 'while': (False, 47), ';': (False, 47), 'if': (False, 47), 'goto': (False, 47), '-': (True, 1704), 'EMBEDSTAT': (False, 47), 'for': (False, 47), '/': (True, 1707), '>': (False, 47), 'return': (False, 47), 'and': (False, 47), 'NAME': (False, 47), '(': (False, 47), 'or': (False, 47), '>=': (False, 47), '%': (True, 1716), 'repeat': (False, 47), '<=': (False, 47)}, {'..': (False, 52), '::': (False, 52), '+': (False, 52), 'break': (False, 52), '==': (False, 52), 'end': (False, 52), '^': (True, 1710), 'function': (False, 52), '~=': (False, 52), '*': (False, 52), 'do': (False, 52), 'while': (False, 52), 'and': (False, 52), ';': (False, 52), 'if': (False, 52), 'goto': (False, 52), '-': (False, 52), 'EMBEDSTAT': (False, 52), 'or': (False, 52), '/': (False, 52), 'local': (False, 52), 'return': (False, 52), '>': (False, 52), '<': (False, 52), 'NAME': (False, 52), '(': (False, 52), 'for': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '<=': (False, 52)}, {'..': (True, 1703), '::': (False, 41), '+': (True, 1705), 'break': (False, 41), '==': (True, 1706), '>': (True, 1709), '^': (True, 1710), 'function': (False, 41), '~=': (True, 1712), '*': (True, 1713), 'do': (False, 41), 'while': (False, 41), ';': (False, 41), 'repeat': (False, 41), '-': (True, 1704), 'EMBEDSTAT': (False, 41), 'end': (False, 41), 'for': (False, 41), 'or': (False, 41), '/': (True, 1707), 'local': (False, 41), 'return': (False, 41), 'and': (False, 41), '<': (True, 1711), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 1715), '%': (True, 1716), 'goto': (False, 41), '<=': (True, 1717)}, {'..': (True, 1703), '::': (False, 43), '+': (True, 1705), 'break': (False, 43), '==': (False, 43), 'if': (False, 43), '<': (False, 43), 'local': (False, 43), '^': (True, 1710), 'function': (False, 43), '~=': (False, 43), '*': (True, 1713), 'do': (False, 43), 'while': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), '-': (True, 1704), 'EMBEDSTAT': (False, 43), 'end': (False, 43), 'for': (False, 43), '/': (True, 1707), '>': (False, 43), 'return': (False, 43), 'and': (False, 43), ';': (False, 43), '(': (False, 43), 'or': (False, 43), '>=': (False, 43), '%': (True, 1716), 'goto': (False, 43), '<=': (False, 43)}, {'..': (False, 54), '::': (False, 54), '+': (False, 54), 'break': (False, 54), '==': (False, 54), '/': (False, 54), '<': (False, 54), '^': (True, 1710), 'function': (False, 54), '~=': (False, 54), '*': (False, 54), 'do': (False, 54), 'while': (False, 54), 'if': (False, 54), 'NAME': (False, 54), 'repeat': (False, 54), '-': (False, 54), 'EMBEDSTAT': (False, 54), 'end': (False, 54), 'or': (False, 54), '>': (False, 54), 'local': (False, 54), 'return': (False, 54), 'and': (False, 54), ';': (False, 54), '(': (False, 54), 'for': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '<=': (False, 54)}, {'..': (True, 1703), '::': (False, 42), '+': (True, 1705), 'break': (False, 42), '==': (False, 42), '>': (False, 42), '<': (False, 42), '^': (True, 1710), 'function': (False, 42), '~=': (False, 42), '*': (True, 1713), 'do': (False, 42), 'while': (False, 42), 'NAME': (False, 42), 'goto': (False, 42), '-': (True, 1704), 'EMBEDSTAT': (False, 42), 'end': (False, 42), 'for': (False, 42), 'or': (False, 42), '/': (True, 1707), 'local': (False, 42), 'return': (False, 42), 'and': (False, 42), ';': (False, 42), '(': (False, 42), 'if': (False, 42), '>=': (False, 42), '%': (True, 1716), 'repeat': (False, 42), '<=': (False, 42)}, {'..': (True, 1703), '::': (False, 46), '+': (True, 1705), 'break': (False, 46), '==': (False, 46), 'if': (False, 46), '<': (False, 46), '^': (True, 1710), 'function': (False, 46), '~=': (False, 46), '*': (True, 1713), 'do': (False, 46), 'while': (False, 46), 'NAME': (False, 46), 'repeat': (False, 46), '-': (True, 1704), 'EMBEDSTAT': (False, 46), 'end': (False, 46), 'for': (False, 46), '/': (True, 1707), 'local': (False, 46), 'return': (False, 46), '>': (False, 46), 'and': (False, 46), ';': (False, 46), '(': (False, 46), 'or': (False, 46), '>=': (False, 46), '%': (True, 1716), 'goto': (False, 46), '<=': (False, 46)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), '==': (False, 51), 'end': (False, 51), '<': (False, 51), '^': (True, 1710), 'function': (False, 51), '+': (False, 51), '*': (False, 51), 'do': (False, 51), 'while': (False, 51), ';': (False, 51), 'if': (False, 51), '/': (False, 51), 'goto': (False, 51), '-': (False, 51), 'EMBEDSTAT': (False, 51), 'or': (False, 51), '>': (False, 51), 'local': (False, 51), 'return': (False, 51), 'and': (False, 51), 'NAME': (False, 51), '(': (False, 51), 'for': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '<=': (False, 51)}, {'..': (True, 1703), '::': (False, 40), '+': (True, 1705), 'break': (False, 40), '==': (True, 1706), '>': (True, 1709), '^': (True, 1710), 'function': (False, 40), '~=': (True, 1712), 'EMBEDSTAT': (False, 40), '*': (True, 1713), 'do': (False, 40), 'while': (False, 40), 'if': (False, 40), 'NAME': (False, 40), 'goto': (False, 40), '-': (True, 1704), 'and': (True, 1708), 'end': (False, 40), 'for': (False, 40), '/': (True, 1707), 'local': (False, 40), 'return': (False, 40), '<': (True, 1711), ';': (False, 40), '(': (False, 40), 'or': (False, 40), '>=': (True, 1715), '%': (True, 1716), 'repeat': (False, 40), '<=': (True, 1717)}, {'..': (True, 1703), '::': (False, 45), '+': (True, 1705), 'break': (False, 45), '==': (False, 45), '>': (False, 45), '<': (False, 45), '^': (True, 1710), 'function': (False, 45), '~=': (False, 45), '*': (True, 1713), 'do': (False, 45), 'while': (False, 45), ';': (False, 45), 'repeat': (False, 45), '-': (True, 1704), 'EMBEDSTAT': (False, 45), 'end': (False, 45), 'or': (False, 45), '/': (True, 1707), 'local': (False, 45), 'return': (False, 45), 'and': (False, 45), 'for': (False, 45), 'NAME': (False, 45), '(': (False, 45), 'if': (False, 45), '>=': (False, 45), '%': (True, 1716), 'goto': (False, 45), '<=': (False, 45)}, {'..': (False, 53), '::': (False, 53), '+': (False, 53), 'break': (False, 53), '==': (False, 53), 'if': (False, 53), '<': (False, 53), '^': (True, 1710), 'function': (False, 53), '~=': (False, 53), '*': (False, 53), 'do': (False, 53), 'while': (False, 53), 'NAME': (False, 53), 'repeat': (False, 53), '-': (False, 53), 'EMBEDSTAT': (False, 53), 'end': (False, 53), 'for': (False, 53), '/': (False, 53), 'local': (False, 53), 'return': (False, 53), '>': (False, 53), 'and': (False, 53), ';': (False, 53), '(': (False, 53), 'or': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '<=': (False, 53)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), '^': (False, 13), 'while': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ',': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), 'EOF': (False, 13), '*': (False, 13), 'do': (False, 13), ';': (False, 13), 'goto': (False, 13), 'repeat': (False, 13), ':': (False, 13), 'for': (False, 13), '/': (False, 13), '>': (False, 13), 'NAME': (False, 13), '<=': (False, 13)}, {'..': (True, 1703), '::': (False, 44), '+': (True, 1705), 'break': (False, 44), '==': (False, 44), 'if': (False, 44), 'local': (False, 44), '^': (True, 1710), 'function': (False, 44), '~=': (False, 44), '*': (True, 1713), 'do': (False, 44), 'while': (False, 44), 'NAME': (False, 44), 'goto': (False, 44), '-': (True, 1704), 'EMBEDSTAT': (False, 44), 'end': (False, 44), 'or': (False, 44), '/': (True, 1707), '>': (False, 44), 'return': (False, 44), 'and': (False, 44), '<': (False, 44), ';': (False, 44), '(': (False, 44), 'for': (False, 44), '>=': (False, 44), '%': (True, 1716), 'repeat': (False, 44), '<=': (False, 44)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), '<': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), '>': (False, 9), ';': (False, 9), '?>': (False, 9), '<=': (False, 9)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), ',': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '~=': (False, 9), 'EOF': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 57), '::': (False, 57), '~=': (False, 57), 'break': (False, 57), 'if': (False, 57), '^': (True, 2460), 'while': (False, 57), '-': (False, 57), '<': (False, 57), 'or': (False, 57), 'local': (False, 57), 'return': (False, 57), '>': (False, 57), 'and': (False, 57), 'NAME': (False, 57), '(': (False, 57), '>=': (False, 57), '%': (False, 57), 'goto': (False, 57), '+': (False, 57), '==': (False, 57), 'EMBEDSTAT': (False, 57), 'function': (False, 57), '*': (False, 57), 'do': (False, 57), 'repeat': (False, 57), 'end': (False, 57), 'for': (False, 57), '/': (False, 57), 'elseif': (False, 57), ';': (False, 57), 'else': (False, 57), '<=': (False, 57)}, {')': (True, 2631)}, {'NAME': (True, 2633)}, {'..': (False, 25), '::': (False, 25), '~=': (False, 25), 'break': (False, 25), '>': (False, 25), 'if': (False, 25), '^': (False, 25), 'end': (False, 25), 'while': (False, 25), '-': (False, 25), '<': (False, 25), 'or': (False, 25), 'local': (False, 25), 'return': (False, 25), '[': (False, 25), 'and': (False, 25), 'NAME': (False, 25), '(': (False, 25), '>=': (False, 25), '%': (False, 25), 'repeat': (False, 25), '.': (False, 25), '+': (False, 25), '==': (False, 25), '{': (False, 25), 'EMBEDSTAT': (False, 25), 'function': (False, 25), '*': (False, 25), 'do': (False, 25), 'goto': (False, 25), 'STRING': (False, 25), ':': (False, 25), 'for': (False, 25), '/': (False, 25), 'elseif': (False, 25), ';': (False, 25), 'else': (False, 25), '<=': (False, 25)}, {'NAME': (True, 2634)}, {'tableconstructor': (True, 69), 'EMBEDEXPR': (True, 70), 'prefixexp': (True, 74), 'function': (True, 71), '#': (True, 72), 'functioncall': (True, 73), 'exp': (True, 80), 'true': (True, 75), 'args__1': (True, 2635), '-': (True, 77), 'false': (True, 78), 'functiondef': (True, 79), 'explist': (True, 82), 'var': (True, 81), '{': (True, 83), ')': (False, 59), 'nil': (True, 84), 'NAME': (True, 85), '(': (True, 86), 'not': (True, 87), 'STRING': (True, 76), '...': (True, 89), 'NUMBER': (True, 90)}, {'tableconstructor': (True, 132), 'EMBEDEXPR': (True, 133), 'function': (True, 134), '#': (True, 135), 'functioncall': (True, 136), 'exp': (True, 143), '}': (False, 101), 'true': (True, 138), 'STRING': (True, 139), '-': (True, 140), 'false': (True, 141), 'functiondef': (True, 142), 'prefixexp': (True, 137), 'field': (True, 144), 'var': (True, 145), '{': (True, 146), '[': (True, 147), 'nil': (True, 148), 'NAME': (True, 149), '(': (True, 150), 'tableconstructor__1': (True, 2637), 'not': (True, 152), '...': (True, 153), 'NUMBER': (True, 154)}, {'..': (False, 21), '::': (False, 21), '~=': (False, 21), 'break': (False, 21), 'if': (False, 21), '^': (False, 21), 'end': (False, 21), 'while': (False, 21), '[': (False, 21), '-': (False, 21), '<': (False, 21), 'or': (False, 21), 'local': (False, 21), 'return': (False, 21), '>': (False, 21), 'and': (False, 21), ';': (False, 21), '(': (False, 21), '>=': (False, 21), '%': (False, 21), 'STRING': (False, 21), '.': (False, 21), '+': (False, 21), '==': (False, 21), '{': (False, 21), 'EMBEDSTAT': (False, 21), 'function': (False, 21), '*': (False, 21), 'do': (False, 21), 'goto': (False, 21), 'repeat': (False, 21), ':': (False, 21), 'for': (False, 21), '/': (False, 21), 'elseif': (False, 21), 'NAME': (False, 21), 'else': (False, 21), '<=': (False, 21)}, {'..': (False, 24), '::': (False, 24), '~=': (False, 24), 'break': (False, 24), 'if': (False, 24), 'elseif': (False, 24), '^': (False, 24), 'while': (False, 24), '-': (False, 24), 'and': (False, 24), 'or': (False, 24), 'local': (False, 24), 'return': (False, 24), '[': (False, 24), '<': (False, 24), 'NAME': (False, 24), '(': (False, 24), '>=': (False, 24), '%': (False, 24), 'STRING': (False, 24), '.': (False, 24), '+': (False, 24), '==': (False, 24), '{': (False, 24), 'EMBEDSTAT': (False, 24), 'function': (False, 24), 'repeat': (False, 24), '*': (False, 24), 'do': (False, 24), 'goto': (False, 24), 'end': (False, 24), 'for': (False, 24), '/': (False, 24), '>': (False, 24), ':': (False, 24), ';': (False, 24), 'else': (False, 24), '<=': (False, 24)}, {'-': (True, 164), 'false': (True, 165), 'functiondef': (True, 166), 'prefixexp': (True, 181), 'functioncall': (True, 169), 'var': (True, 170), 'tableconstructor': (True, 168), 'EMBEDEXPR': (True, 172), '{': (True, 173), 'function': (True, 171), '#': (True, 175), 'nil': (True, 174), 'STRING': (True, 177), '...': (True, 182), '(': (True, 179), 'not': (True, 180), 'exp': (True, 2409), 'NAME': (True, 176), 'true': (True, 178), 'NUMBER': (True, 183)}, {'end': (True, 2507)}, {'-': (True, 362), '<': (True, 363), '+': (True, 364), '==': (True, 365), 'or': (True, 366), '/': (True, 367), '>': (True, 368), 'and': (True, 369), '^': (True, 370), '~=': (True, 371), ']': (True, 2538), '*': (True, 373), '>=': (True, 374), '%': (True, 375), '..': (True, 376), '<=': (True, 377)}, {'-': (True, 401), ')': (True, 2547), '+': (True, 403), '==': (True, 404), 'or': (True, 405), '/': (True, 407), '>': (True, 408), 'and': (True, 406), '<': (True, 402), '~=': (True, 411), '*': (True, 412), '>=': (True, 413), '^': (True, 409), '%': (True, 414), '..': (True, 415), '<=': (True, 416)}, {'..': (False, 62), '::': (False, 62), '~=': (False, 62), 'break': (False, 62), 'if': (False, 62), '^': (False, 62), 'while': (False, 62), '/': (False, 62), '-': (False, 62), '<': (False, 62), 'or': (False, 62), 'local': (False, 62), 'return': (False, 62), 'and': (False, 62), 'NAME': (False, 62), '(': (False, 62), '>=': (False, 62), '%': (False, 62), 'repeat': (False, 62), '+': (False, 62), '==': (False, 62), 'EMBEDSTAT': (False, 62), 'function': (False, 62), '*': (False, 62), 'do': (False, 62), 'goto': (False, 62), 'end': (False, 62), 'for': (False, 62), '>': (False, 62), 'elseif': (False, 62), ';': (False, 62), 'else': (False, 62), '<=': (False, 62)}, {')': (False, 97), 'funcbody__1': (True, 2549), 'NAME': (True, 498), 'parlist': (True, 500), '...': (True, 499)}, {'}': (True, 2565)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), '-': (False, 6), ')': (False, 6), 'or': (False, 6), '/': (False, 6), 'and': (False, 6), '<': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '/': (False, 56), '^': (True, 2460), 'while': (False, 56), '-': (False, 56), '<': (False, 56), 'or': (False, 56), 'local': (False, 56), 'return': (False, 56), 'and': (False, 56), 'NAME': (False, 56), '(': (False, 56), 'if': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '+': (False, 56), '==': (False, 56), 'EMBEDSTAT': (False, 56), 'function': (False, 56), '*': (False, 56), 'do': (False, 56), 'goto': (False, 56), 'end': (False, 56), 'for': (False, 56), '>': (False, 56), 'elseif': (False, 56), ';': (False, 56), 'else': (False, 56), '<=': (False, 56)}, {'.': (False, 22), ':': (False, 22), '(': (False, 22), '{': (False, 22), '[': (False, 22), 'STRING': (False, 22)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2441), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), ',': (False, 22), 'if': (False, 22), '^': (False, 22), 'while': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '/': (False, 22), '>': (False, 22), ';': (False, 22), '?>': (False, 22), '<=': (False, 22)}, {'end': (True, 2618)}, {'..': (False, 56), '::': (False, 56), '~=': (False, 56), 'break': (False, 56), '==': (False, 56), 'if': (False, 56), '^': (True, 2432), 'function': (False, 56), '+': (False, 56), 'EOF': (False, 56), '*': (False, 56), 'do': (False, 56), 'while': (False, 56), 'and': (False, 56), ';': (False, 56), 'goto': (False, 56), '-': (False, 56), 'EMBEDSTAT': (False, 56), 'or': (False, 56), '/': (False, 56), 'local': (False, 56), 'return': (False, 56), '>': (False, 56), '<': (False, 56), 'NAME': (False, 56), '(': (False, 56), 'for': (False, 56), '>=': (False, 56), '%': (False, 56), 'repeat': (False, 56), '<=': (False, 56)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2450), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), '==': (False, 55), 'if': (False, 55), '<': (False, 55), 'local': (False, 55), '^': (True, 2432), 'function': (False, 55), '+': (False, 55), 'EOF': (False, 55), '*': (False, 55), 'do': (False, 55), 'while': (False, 55), ';': (False, 55), 'goto': (False, 55), '-': (False, 55), 'EMBEDSTAT': (False, 55), 'for': (False, 55), '/': (False, 55), '>': (False, 55), 'return': (False, 55), 'and': (False, 55), 'NAME': (False, 55), '(': (False, 55), 'or': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '<=': (False, 55)}, {'::': (False, 92), 'break': (False, 92), 'if': (False, 92), 'EMBEDSTAT': (False, 92), 'function': (False, 92), 'EOF': (False, 92), 'do': (False, 92), 'while': (False, 92), ';': (False, 92), 'goto': (False, 92), 'for': (False, 92), 'local': (False, 92), 'return': (False, 92), 'NAME': (False, 92), '(': (False, 92), 'repeat': (False, 92)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), 'NAME': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '?>': (False, 85), '<=': (False, 85)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2569), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2567), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2571), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2573), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2576), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2578), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2580), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2581), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2582), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2583), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2584), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2585), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2586), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2587), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {'-': (True, 1981), 'false': (True, 1982), 'functiondef': (True, 1983), 'exp': (True, 2588), 'functioncall': (True, 1996), 'var': (True, 1987), 'tableconstructor': (True, 1985), 'EMBEDEXPR': (True, 1989), '{': (True, 1990), 'function': (True, 1988), '#': (True, 1993), 'nil': (True, 1992), 'STRING': (True, 2000), 'true': (True, 1999), '(': (True, 1986), 'not': (True, 1997), 'prefixexp': (True, 1984), 'NAME': (True, 1994), '...': (True, 1995), 'NUMBER': (True, 1991)}, {')': (True, 2481)}, {'end': (True, 2589)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), ',': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '/': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), 'end': (False, 85), 'elseif': (False, 85), '[': (False, 85), 'and': (False, 85), ';': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'else': (False, 85), '<=': (False, 85)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), ',': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), 'NAME': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'EOF': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), '/': (False, 23), '>': (False, 23), ';': (False, 23), '<=': (False, 23)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), 'end': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), ';': (False, 6), '/': (False, 6), '-': (False, 6), 'and': (False, 6), 'or': (False, 6), '>': (False, 6), 'elseif': (False, 6), '<': (False, 6), ',': (False, 6), '>=': (False, 6), '%': (False, 6), 'else': (False, 6), '<=': (False, 6)}, {'::': (False, 6), 'break': (False, 6), 'if': (False, 6), 'EMBEDSTAT': (False, 6), 'function': (False, 6), 'do': (False, 6), 'while': (False, 6), 'NAME': (False, 6), 'goto': (False, 6), 'for': (False, 6), 'until': (False, 6), 'local': (False, 6), 'return': (False, 6), ';': (False, 6), '(': (False, 6), 'repeat': (False, 6)}, {'stat__1': (True, 2486), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {'..': (False, 23), '.': (False, 23), '+': (False, 23), ',': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '~=': (False, 23), 'EOF': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'until': (False, 92), ';': (False, 92)}, {'end': (True, 2595)}, {'end': (True, 2519)}, {'..': (False, 55), '::': (False, 55), '~=': (False, 55), 'break': (False, 55), 'if': (False, 55), '^': (True, 2460), 'while': (False, 55), '-': (False, 55), 'and': (False, 55), 'or': (False, 55), 'local': (False, 55), 'return': (False, 55), '>': (False, 55), '<': (False, 55), ';': (False, 55), '(': (False, 55), '>=': (False, 55), '%': (False, 55), 'repeat': (False, 55), '+': (False, 55), '==': (False, 55), 'EMBEDSTAT': (False, 55), 'function': (False, 55), '*': (False, 55), 'do': (False, 55), 'goto': (False, 55), 'end': (False, 55), 'for': (False, 55), '/': (False, 55), 'elseif': (False, 55), 'NAME': (False, 55), 'else': (False, 55), '<=': (False, 55)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2550), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2552), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2554), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2556), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2558), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2560), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2562), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2563), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2566), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2568), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2570), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2572), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2574), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2577), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'-': (True, 2323), 'false': (True, 2324), 'functiondef': (True, 2325), 'exp': (True, 2579), 'functioncall': (True, 2338), 'var': (True, 2329), 'tableconstructor': (True, 2327), 'EMBEDEXPR': (True, 2331), '{': (True, 2332), 'function': (True, 2330), '#': (True, 2335), 'nil': (True, 2334), 'STRING': (True, 2342), 'true': (True, 2341), '(': (True, 2328), 'not': (True, 2339), 'prefixexp': (True, 2326), 'NAME': (True, 2336), '...': (True, 2337), 'NUMBER': (True, 2333)}, {'.': (False, 23), '::': (False, 23), 'break': (False, 23), '{': (False, 23), 'if': (False, 23), 'elseif': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), 'do': (False, 23), 'while': (False, 23), ';': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), 'end': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'NAME': (False, 23), '(': (False, 23), 'STRING': (False, 23), 'else': (False, 23)}, {'stat__1': (True, 2600), 'end': (False, 61), 'elseif': (True, 869), 'else': (False, 61)}, {'.': (False, 9), '::': (False, 9), 'break': (False, 9), '{': (False, 9), 'if': (False, 9), 'elseif': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'do': (False, 9), 'while': (False, 9), ';': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), 'end': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'NAME': (False, 9), '(': (False, 9), 'STRING': (False, 9), 'else': (False, 9)}, {'..': (True, 600), '-': (True, 601), '+': (True, 602), '==': (True, 604), 'or': (True, 605), '<': (True, 610), '>': (True, 607), 'and': (True, 606), '^': (True, 609), '>=': (True, 613), ',': (True, 2063), 'stat__3': (True, 2488), '*': (True, 612), 'do': (False, 103), '~=': (True, 611), '%': (True, 614), '/': (True, 615), '<=': (True, 616)}, {'end': (True, 2642)}, {'end': (True, 2475)}, {'end': (True, 2514)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'end': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ',': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), 'NAME': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {'::': (False, 6), 'break': (False, 6), 'if': (False, 6), 'EMBEDSTAT': (False, 6), 'function': (False, 6), 'do': (False, 6), 'while': (False, 6), '}': (False, 6), 'goto': (False, 6), 'for': (False, 6), 'NAME': (False, 6), 'local': (False, 6), 'return': (False, 6), ';': (False, 6), '(': (False, 6), 'repeat': (False, 6)}, {'..': (False, 22), '.': (False, 22), '+': (False, 22), ',': (False, 22), '==': (False, 22), '{': (False, 22), 'end': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), '/': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ';': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'::': (False, 92), 'break': (False, 92), 'if': (False, 92), 'local': (False, 92), 'EMBEDSTAT': (False, 92), 'function': (False, 92), 'do': (False, 92), 'while': (False, 92), ';': (False, 92), 'repeat': (False, 92), 'for': (False, 92), 'end': (False, 92), 'elseif': (False, 92), 'return': (False, 92), 'NAME': (False, 92), '(': (False, 92), 'goto': (False, 92), 'else': (False, 92)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), ',': (False, 22), 'if': (False, 22), '^': (False, 22), 'while': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), 'EOF': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '/': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'end': (True, 2643)}, {'..': (False, 53), '+': (False, 53), '==': (False, 53), '>': (False, 53), '^': (True, 2287), '~=': (False, 53), 'EOF': (False, 53), '*': (False, 53), ';': (False, 53), '-': (False, 53), 'and': (False, 53), 'or': (False, 53), '/': (False, 53), '<': (False, 53), ',': (False, 53), '>=': (False, 53), '%': (False, 53), '<=': (False, 53)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2493), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 23), '.': (False, 23), '+': (False, 23), ',': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), 'until': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '<=': (False, 23)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), ',': (False, 85), '==': (False, 85), '{': (False, 85), '>': (False, 85), '^': (False, 85), '~=': (False, 85), 'EOF': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), '/': (False, 85), '[': (False, 85), 'and': (False, 85), ';': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2496), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (True, 2277), '+': (True, 2279), '==': (False, 44), '>': (False, 44), '^': (True, 2287), '~=': (False, 44), 'EOF': (False, 44), '*': (True, 2290), ';': (False, 44), '-': (True, 2278), '<': (False, 44), 'or': (False, 44), '/': (True, 2284), 'and': (False, 44), ',': (False, 44), '>=': (False, 44), '%': (True, 2292), '<=': (False, 44)}, {'end': (False, 99), 'stat__2': (True, 2646), 'else': (True, 1555)}, {'end': (True, 2621)}, {'do': (True, 2590)}, {'end': (False, 99), 'stat__2': (True, 2591), 'else': (True, 1555)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), ',': (False, 23), 'if': (False, 23), 'elseif': (False, 23), '^': (False, 23), 'while': (False, 23), '/': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), 'NAME': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), 'end': (False, 23), '>': (False, 23), ';': (False, 23), 'else': (False, 23), '<=': (False, 23)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2611), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'::': (False, 92), 'break': (False, 92), '(': (False, 92), 'if': (False, 92), 'EMBEDSTAT': (False, 92), 'function': (False, 92), 'do': (False, 92), 'while': (False, 92), ';': (False, 92), 'goto': (False, 92), 'for': (False, 92), 'local': (False, 92), 'return': (False, 92), 'NAME': (False, 92), '?>': (False, 92), 'repeat': (False, 92)}, {'end': (True, 2645)}, {'..': (False, 13), '.': (False, 13), '+': (False, 13), ',': (False, 13), '==': (False, 13), '{': (False, 13), 'end': (False, 13), 'elseif': (False, 13), '^': (False, 13), '~=': (False, 13), '*': (False, 13), 'STRING': (False, 13), '-': (False, 13), '<': (False, 13), ':': (False, 13), 'or': (False, 13), '/': (False, 13), '>': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'else': (False, 13), '<=': (False, 13)}, {'..': (False, 9), '::': (False, 9), '+': (False, 9), 'break': (False, 9), '?>': (False, 9), '==': (False, 9), 'if': (False, 9), '<': (False, 9), '^': (False, 9), 'function': (False, 9), '~=': (False, 9), '*': (False, 9), 'do': (False, 9), 'while': (False, 9), ';': (False, 9), 'goto': (False, 9), '-': (False, 9), 'EMBEDSTAT': (False, 9), 'or': (False, 9), '/': (False, 9), 'local': (False, 9), 'return': (False, 9), '>': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), 'for': (False, 9), '>=': (False, 9), '%': (False, 9), 'repeat': (False, 9), '<=': (False, 9)}, {'end': (True, 2605)}, {'..': (False, 9), '::': (False, 9), '+': (False, 9), 'break': (False, 9), '==': (False, 9), 'if': (False, 9), '<': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '~=': (False, 9), 'EOF': (False, 9), '*': (False, 9), 'do': (False, 9), 'while': (False, 9), ';': (False, 9), 'goto': (False, 9), '-': (False, 9), '^': (False, 9), 'or': (False, 9), '/': (False, 9), 'local': (False, 9), 'return': (False, 9), '>': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), 'for': (False, 9), '>=': (False, 9), '%': (False, 9), 'repeat': (False, 9), '<=': (False, 9)}, {'end': (True, 2575)}, {'end': (True, 2520)}, {'end': (True, 2639)}, {'..': (False, 54), '::': (False, 54), '+': (False, 54), 'break': (False, 54), '(': (False, 54), '==': (False, 54), 'if': (False, 54), '<': (False, 54), 'local': (False, 54), '^': (True, 2260), 'function': (False, 54), '~=': (False, 54), '*': (False, 54), 'do': (False, 54), 'while': (False, 54), 'NAME': (False, 54), 'repeat': (False, 54), '-': (False, 54), 'EMBEDSTAT': (False, 54), 'or': (False, 54), '/': (False, 54), '>': (False, 54), 'return': (False, 54), 'and': (False, 54), ';': (False, 54), '?>': (False, 54), 'for': (False, 54), '>=': (False, 54), '%': (False, 54), 'goto': (False, 54), '<=': (False, 54)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2636), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'::': (False, 28), 'break': (False, 28), 'if': (False, 28), 'EMBEDSTAT': (False, 28), 'function': (False, 28), 'EOF': (False, 28), 'do': (False, 28), 'while': (False, 28), 'NAME': (False, 28), 'goto': (False, 28), 'for': (False, 28), '=': (False, 28), 'local': (False, 28), 'return': (False, 28), ';': (False, 28), '(': (False, 28), 'repeat': (False, 28)}, {'..': (False, 23), '.': (False, 23), '+': (False, 23), ',': (False, 23), '==': (False, 23), '{': (False, 23), '>': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), '/': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), '?>': (False, 23), '<=': (False, 23)}, {'..': (False, 22), '.': (False, 22), '+': (False, 22), ',': (False, 22), '==': (False, 22), '{': (False, 22), '/': (False, 22), '^': (False, 22), '~=': (False, 22), '*': (False, 22), 'STRING': (False, 22), '-': (False, 22), 'and': (False, 22), ':': (False, 22), 'or': (False, 22), 'until': (False, 22), '>': (False, 22), '[': (False, 22), '<': (False, 22), ';': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), '<=': (False, 22)}, {'..': (False, 23), '.': (False, 23), '+': (False, 23), ',': (False, 23), '==': (False, 23), '{': (False, 23), '/': (False, 23), 'elseif': (False, 23), '^': (False, 23), '~=': (False, 23), '*': (False, 23), 'STRING': (False, 23), '-': (False, 23), '<': (False, 23), ':': (False, 23), 'or': (False, 23), 'end': (False, 23), '>': (False, 23), '[': (False, 23), 'and': (False, 23), ';': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'else': (False, 23), '<=': (False, 23)}, {'::': (False, 70), 'break': (False, 70), 'if': (False, 70), 'EMBEDSTAT': (False, 70), 'function': (False, 70), 'EOF': (False, 70), 'do': (False, 70), 'while': (False, 70), 'NAME': (False, 70), 'goto': (False, 70), 'for': (False, 70), 'local': (False, 70), 'return': (False, 70), ';': (False, 70), '(': (False, 70), 'repeat': (False, 70)}, {'end': (False, 99), 'stat__2': (True, 2599), 'else': (True, 1555)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), ',': (False, 9), '==': (False, 9), '{': (False, 9), 'end': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), '/': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '>': (False, 9), 'elseif': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'else': (False, 9), '<=': (False, 9)}, {';': (False, 92), 'end': (False, 92), 'elseif': (False, 92), 'else': (False, 92)}, {'.': (False, 85), '..': (False, 85), '+': (False, 85), ',': (False, 85), '==': (False, 85), '{': (False, 85), '/': (False, 85), '^': (False, 85), '~=': (False, 85), '*': (False, 85), 'STRING': (False, 85), '-': (False, 85), '<': (False, 85), ':': (False, 85), 'or': (False, 85), 'end': (False, 85), '>': (False, 85), '[': (False, 85), 'and': (False, 85), ';': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), '<=': (False, 85)}, {'::': (False, 28), 'break': (False, 28), 'if': (False, 28), 'EMBEDSTAT': (False, 28), 'function': (False, 28), 'do': (False, 28), 'while': (False, 28), 'NAME': (False, 28), 'goto': (False, 28), 'for': (False, 28), '=': (False, 28), 'local': (False, 28), 'return': (False, 28), '}': (False, 28), ';': (False, 28), '(': (False, 28), 'repeat': (False, 28)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2602), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 6), '::': (False, 6), '~=': (False, 6), 'break': (False, 6), ',': (False, 6), 'if': (False, 6), '^': (False, 6), 'while': (False, 6), '-': (False, 6), '<': (False, 6), 'or': (False, 6), 'local': (False, 6), 'return': (False, 6), '>': (False, 6), 'and': (False, 6), 'NAME': (False, 6), '(': (False, 6), '>=': (False, 6), '%': (False, 6), 'repeat': (False, 6), '+': (False, 6), '==': (False, 6), 'EMBEDSTAT': (False, 6), 'function': (False, 6), '*': (False, 6), 'do': (False, 6), 'goto': (False, 6), 'end': (False, 6), 'for': (False, 6), '/': (False, 6), 'elseif': (False, 6), ';': (False, 6), 'else': (False, 6), '<=': (False, 6)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), '<': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), 'and': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), 'end': (False, 9), 'for': (False, 9), '>': (False, 9), 'elseif': (False, 9), ':': (False, 9), ';': (False, 9), 'else': (False, 9), '<=': (False, 9)}, {'..': (False, 9), '::': (False, 9), '~=': (False, 9), 'break': (False, 9), ',': (False, 9), 'if': (False, 9), '^': (False, 9), 'while': (False, 9), '/': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), 'local': (False, 9), 'return': (False, 9), '[': (False, 9), '<': (False, 9), 'NAME': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), 'STRING': (False, 9), '.': (False, 9), '+': (False, 9), '==': (False, 9), '{': (False, 9), 'EMBEDSTAT': (False, 9), 'function': (False, 9), 'EOF': (False, 9), '*': (False, 9), 'do': (False, 9), 'goto': (False, 9), 'repeat': (False, 9), ':': (False, 9), 'for': (False, 9), '>': (False, 9), ';': (False, 9), '<=': (False, 9)}, {'end': (True, 2625)}, {'..': (False, 22), '::': (False, 22), '~=': (False, 22), 'break': (False, 22), 'if': (False, 22), '^': (False, 22), 'end': (False, 22), 'while': (False, 22), '/': (False, 22), '-': (False, 22), 'and': (False, 22), 'or': (False, 22), 'local': (False, 22), 'return': (False, 22), '[': (False, 22), '<': (False, 22), 'NAME': (False, 22), '(': (False, 22), '>=': (False, 22), '%': (False, 22), 'STRING': (False, 22), '.': (False, 22), '+': (False, 22), '==': (False, 22), '{': (False, 22), 'EMBEDSTAT': (False, 22), 'function': (False, 22), '*': (False, 22), 'do': (False, 22), 'goto': (False, 22), 'repeat': (False, 22), ':': (False, 22), 'for': (False, 22), '>': (False, 22), ';': (False, 22), '<=': (False, 22)}, {'..': (False, 6), '::': (False, 6), '+': (False, 6), 'break': (False, 6), '==': (False, 6), 'if': (False, 6), '<': (False, 6), '^': (False, 6), 'function': (False, 6), '~=': (False, 6), '*': (False, 6), 'do': (False, 6), 'while': (False, 6), ';': (False, 6), '/': (False, 6), 'repeat': (False, 6), '-': (False, 6), 'EMBEDSTAT': (False, 6), 'for': (False, 6), '>': (False, 6), 'local': (False, 6), 'return': (False, 6), '}': (False, 6), 'and': (False, 6), 'NAME': (False, 6), '(': (False, 6), 'or': (False, 6), '>=': (False, 6), '%': (False, 6), 'goto': (False, 6), '<=': (False, 6)}, {'..': (False, 6), '+': (False, 6), '==': (False, 6), '>': (False, 6), '^': (False, 6), '~=': (False, 6), '*': (False, 6), ';': (False, 6), '-': (False, 6), 'and': (False, 6), 'or': (False, 6), 'until': (False, 6), '/': (False, 6), '<': (False, 6), ',': (False, 6), '>=': (False, 6), '%': (False, 6), '<=': (False, 6)}, {'..': (False, 50), '::': (False, 50), '+': (False, 50), 'break': (False, 50), '?>': (False, 50), '==': (False, 50), '>': (False, 50), '<': (False, 50), '^': (True, 2260), 'function': (False, 50), '~=': (False, 50), '*': (True, 2272), 'do': (False, 50), 'while': (False, 50), 'if': (False, 50), 'NAME': (False, 50), 'repeat': (False, 50), '-': (False, 50), 'EMBEDSTAT': (False, 50), 'or': (False, 50), '/': (True, 2267), 'local': (False, 50), 'return': (False, 50), 'and': (False, 50), ';': (False, 50), '(': (False, 50), 'for': (False, 50), '>=': (False, 50), '%': (True, 2275), 'goto': (False, 50), '<=': (False, 50)}, {'..': (True, 2263), '::': (False, 48), '+': (True, 2265), 'break': (False, 48), '?>': (False, 48), '==': (False, 48), 'if': (False, 48), '<': (False, 48), 'local': (False, 48), '^': (True, 2260), 'function': (False, 48), '~=': (False, 48), '*': (True, 2272), 'do': (False, 48), 'while': (False, 48), 'NAME': (False, 48), 'goto': (False, 48), '-': (True, 2264), 'EMBEDSTAT': (False, 48), 'for': (False, 48), '/': (True, 2267), '>': (False, 48), 'return': (False, 48), 'and': (False, 48), ';': (False, 48), '(': (False, 48), 'or': (False, 48), '>=': (False, 48), '%': (True, 2275), 'repeat': (False, 48), '<=': (False, 48)}, {'..': (False, 49), '::': (False, 49), '+': (False, 49), 'break': (False, 49), '?>': (False, 49), '==': (False, 49), 'if': (False, 49), '<': (False, 49), '^': (True, 2260), 'function': (False, 49), '~=': (False, 49), '*': (True, 2272), 'do': (False, 49), 'while': (False, 49), 'NAME': (False, 49), 'repeat': (False, 49), '-': (False, 49), 'EMBEDSTAT': (False, 49), 'for': (False, 49), '/': (True, 2267), 'local': (False, 49), 'return': (False, 49), '>': (False, 49), 'and': (False, 49), ';': (False, 49), '(': (False, 49), 'or': (False, 49), '>=': (False, 49), '%': (True, 2275), 'goto': (False, 49), '<=': (False, 49)}, {'..': (True, 2263), '::': (False, 47), '+': (True, 2265), 'break': (False, 47), '?>': (False, 47), '==': (False, 47), 'if': (False, 47), '<': (False, 47), 'local': (False, 47), '^': (True, 2260), 'function': (False, 47), '~=': (False, 47), '*': (True, 2272), 'do': (False, 47), 'while': (False, 47), ';': (False, 47), 'goto': (False, 47), '-': (True, 2264), 'EMBEDSTAT': (False, 47), 'for': (False, 47), '/': (True, 2267), '>': (False, 47), 'return': (False, 47), 'and': (False, 47), 'NAME': (False, 47), '(': (False, 47), 'or': (False, 47), '>=': (False, 47), '%': (True, 2275), 'repeat': (False, 47), '<=': (False, 47)}, {'..': (False, 52), '::': (False, 52), '+': (False, 52), 'break': (False, 52), '(': (False, 52), '==': (False, 52), 'if': (False, 52), '^': (True, 2260), 'function': (False, 52), '~=': (False, 52), '*': (False, 52), 'do': (False, 52), 'while': (False, 52), 'and': (False, 52), ';': (False, 52), 'goto': (False, 52), '-': (False, 52), 'EMBEDSTAT': (False, 52), 'for': (False, 52), '/': (False, 52), 'local': (False, 52), 'return': (False, 52), '>': (False, 52), '<': (False, 52), 'NAME': (False, 52), '?>': (False, 52), 'or': (False, 52), '>=': (False, 52), '%': (False, 52), 'repeat': (False, 52), '<=': (False, 52)}, {'..': (True, 2263), '::': (False, 41), '+': (True, 2265), 'break': (False, 41), '?>': (False, 41), '==': (True, 2266), '>': (True, 2269), '^': (True, 2260), 'function': (False, 41), '~=': (True, 2271), '*': (True, 2272), 'do': (False, 41), 'while': (False, 41), ';': (False, 41), 'repeat': (False, 41), '-': (True, 2264), 'EMBEDSTAT': (False, 41), 'for': (False, 41), 'or': (False, 41), '/': (True, 2267), 'local': (False, 41), 'return': (False, 41), 'and': (False, 41), '<': (True, 2270), 'NAME': (False, 41), '(': (False, 41), 'if': (False, 41), '>=': (True, 2274), '%': (True, 2275), 'goto': (False, 41), '<=': (True, 2276)}, {'..': (True, 2263), '::': (False, 43), '+': (True, 2265), 'break': (False, 43), '(': (False, 43), '==': (False, 43), 'if': (False, 43), '<': (False, 43), 'local': (False, 43), '^': (True, 2260), 'function': (False, 43), '~=': (False, 43), '*': (True, 2272), 'do': (False, 43), 'while': (False, 43), 'NAME': (False, 43), 'repeat': (False, 43), '-': (True, 2264), 'EMBEDSTAT': (False, 43), 'for': (False, 43), '/': (True, 2267), '>': (False, 43), 'return': (False, 43), 'and': (False, 43), ';': (False, 43), '?>': (False, 43), 'or': (False, 43), '>=': (False, 43), '%': (True, 2275), 'goto': (False, 43), '<=': (False, 43)}, {'..': (True, 2263), '::': (False, 42), '+': (True, 2265), 'break': (False, 42), '(': (False, 42), '==': (False, 42), 'if': (False, 42), '<': (False, 42), 'local': (False, 42), '^': (True, 2260), 'function': (False, 42), '~=': (False, 42), '*': (True, 2272), 'do': (False, 42), 'while': (False, 42), 'NAME': (False, 42), 'goto': (False, 42), '-': (True, 2264), 'EMBEDSTAT': (False, 42), 'for': (False, 42), '/': (True, 2267), '>': (False, 42), 'return': (False, 42), 'and': (False, 42), ';': (False, 42), '?>': (False, 42), 'or': (False, 42), '>=': (False, 42), '%': (True, 2275), 'repeat': (False, 42), '<=': (False, 42)}, {'..': (True, 2263), '::': (False, 46), '+': (True, 2265), 'break': (False, 46), '(': (False, 46), '==': (False, 46), '>': (False, 46), '<': (False, 46), '^': (True, 2260), 'function': (False, 46), '~=': (False, 46), '*': (True, 2272), 'do': (False, 46), 'while': (False, 46), 'NAME': (False, 46), 'repeat': (False, 46), '-': (True, 2264), 'EMBEDSTAT': (False, 46), 'for': (False, 46), 'or': (False, 46), '/': (True, 2267), 'local': (False, 46), 'return': (False, 46), 'and': (False, 46), ';': (False, 46), '?>': (False, 46), 'if': (False, 46), '>=': (False, 46), '%': (True, 2275), 'goto': (False, 46), '<=': (False, 46)}, {'..': (False, 9), '+': (False, 9), '==': (False, 9), '/': (False, 9), '^': (False, 9), '~=': (False, 9), 'EOF': (False, 9), '*': (False, 9), ';': (False, 9), '-': (False, 9), 'and': (False, 9), 'or': (False, 9), '>': (False, 9), '<': (False, 9), ',': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'-': (True, 449), 'false': (True, 460), 'functiondef': (True, 451), 'exp': (True, 2656), 'functioncall': (True, 465), 'var': (True, 455), 'tableconstructor': (True, 453), 'EMBEDEXPR': (True, 457), '{': (True, 459), 'function': (True, 456), '#': (True, 462), 'nil': (True, 461), 'STRING': (True, 469), '...': (True, 468), '(': (True, 454), 'not': (True, 466), 'prefixexp': (True, 452), 'NAME': (True, 463), 'true': (True, 464), 'NUMBER': (True, 450)}, {'..': (False, 51), '::': (False, 51), '~=': (False, 51), 'break': (False, 51), '?>': (False, 51), '==': (False, 51), '/': (False, 51), '<': (False, 51), '^': (True, 2260), 'function': (False, 51), '+': (False, 51), '*': (False, 51), 'do': (False, 51), 'while': (False, 51), ';': (False, 51), 'if': (False, 51), 'goto': (False, 51), '-': (False, 51), 'EMBEDSTAT': (False, 51), 'or': (False, 51), '>': (False, 51), 'local': (False, 51), 'return': (False, 51), 'and': (False, 51), 'NAME': (False, 51), '(': (False, 51), 'for': (False, 51), '>=': (False, 51), '%': (False, 51), 'repeat': (False, 51), '<=': (False, 51)}, {'..': (True, 2263), '::': (False, 40), '+': (True, 2265), 'break': (False, 40), '(': (False, 40), '==': (True, 2266), '>': (True, 2269), '^': (True, 2260), 'function': (False, 40), '~=': (True, 2271), 'EMBEDSTAT': (False, 40), '*': (True, 2272), 'do': (False, 40), 'while': (False, 40), 'NAME': (False, 40), 'goto': (False, 40), '-': (True, 2264), 'and': (True, 2268), 'for': (False, 40), 'or': (False, 40), '/': (True, 2267), 'local': (False, 40), 'return': (False, 40), '<': (True, 2270), ';': (False, 40), '?>': (False, 40), 'if': (False, 40), '>=': (True, 2274), '%': (True, 2275), 'repeat': (False, 40), '<=': (True, 2276)}, {'..': (True, 2263), '::': (False, 45), '+': (True, 2265), 'break': (False, 45), '?>': (False, 45), '==': (False, 45), 'if': (False, 45), '<': (False, 45), 'local': (False, 45), '^': (True, 2260), 'function': (False, 45), '~=': (False, 45), '*': (True, 2272), 'do': (False, 45), 'while': (False, 45), ';': (False, 45), 'repeat': (False, 45), '-': (True, 2264), 'EMBEDSTAT': (False, 45), 'or': (False, 45), '/': (True, 2267), '>': (False, 45), 'return': (False, 45), 'and': (False, 45), 'NAME': (False, 45), '(': (False, 45), 'for': (False, 45), '>=': (False, 45), '%': (True, 2275), 'goto': (False, 45), '<=': (False, 45)}, {'::': (False, 74), 'break': (False, 74), 'if': (False, 74), 'EMBEDSTAT': (False, 74), 'function': (False, 74), 'do': (False, 74), 'while': (False, 74), 'NAME': (False, 74), 'goto': (False, 74), 'for': (False, 74), 'until': (False, 74), 'local': (False, 74), 'return': (False, 74), ';': (False, 74), '(': (False, 74), 'repeat': (False, 74)}, {'..': (False, 53), '::': (False, 53), '+': (False, 53), 'break': (False, 53), '(': (False, 53), '==': (False, 53), 'if': (False, 53), '<': (False, 53), '^': (True, 2260), 'function': (False, 53), '~=': (False, 53), '*': (False, 53), 'do': (False, 53), 'while': (False, 53), '/': (False, 53), 'repeat': (False, 53), '-': (False, 53), 'EMBEDSTAT': (False, 53), 'for': (False, 53), '>': (False, 53), 'local': (False, 53), 'return': (False, 53), 'and': (False, 53), 'NAME': (False, 53), ';': (False, 53), '?>': (False, 53), 'or': (False, 53), '>=': (False, 53), '%': (False, 53), 'goto': (False, 53), '<=': (False, 53)}, {'..': (True, 2263), '::': (False, 44), '+': (True, 2265), 'break': (False, 44), '(': (False, 44), '==': (False, 44), 'if': (False, 44), 'local': (False, 44), '^': (True, 2260), 'function': (False, 44), '~=': (False, 44), '*': (True, 2272), 'do': (False, 44), 'while': (False, 44), 'NAME': (False, 44), 'goto': (False, 44), '-': (True, 2264), 'EMBEDSTAT': (False, 44), 'or': (False, 44), '/': (True, 2267), '>': (False, 44), 'return': (False, 44), 'and': (False, 44), '<': (False, 44), ';': (False, 44), '?>': (False, 44), 'for': (False, 44), '>=': (False, 44), '%': (True, 2275), 'repeat': (False, 44), '<=': (False, 44)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), '>': (False, 85), 'if': (False, 85), '^': (False, 85), 'end': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), ';': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'repeat': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), 'goto': (False, 85), 'STRING': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), 'elseif': (False, 85), 'NAME': (False, 85), 'else': (False, 85), '<=': (False, 85)}, {'..': (False, 85), '::': (False, 85), '~=': (False, 85), 'break': (False, 85), 'if': (False, 85), '^': (False, 85), 'end': (False, 85), 'while': (False, 85), '-': (False, 85), '<': (False, 85), 'or': (False, 85), 'local': (False, 85), 'return': (False, 85), '[': (False, 85), 'and': (False, 85), 'NAME': (False, 85), '(': (False, 85), '>=': (False, 85), '%': (False, 85), 'STRING': (False, 85), '.': (False, 85), '+': (False, 85), '==': (False, 85), '{': (False, 85), 'EMBEDSTAT': (False, 85), 'function': (False, 85), '*': (False, 85), 'do': (False, 85), 'goto': (False, 85), 'repeat': (False, 85), ':': (False, 85), 'for': (False, 85), '/': (False, 85), '>': (False, 85), ';': (False, 85), '<=': (False, 85)}, {'do': (True, 2627)}, {'block__1': (True, 188), '::': (True, 189), 'break': (True, 190), 'if': (True, 191), 'varlist': (True, 192), 'EMBEDSTAT': (True, 193), 'function': (True, 194), 'functioncall': (True, 195), 'do': (True, 196), 'while': (True, 197), 'prefixexp': (True, 200), 'NAME': (True, 15), 'goto': (True, 199), 'stat': (True, 198), 'var': (True, 18), 'block': (True, 2628), 'for': (True, 202), 'label': (True, 203), 'end': (False, 3), 'local': (True, 204), 'return': (False, 3), ';': (True, 205), '(': (True, 25), 'repeat': (True, 206)}, {'..': (False, 23), '::': (False, 23), '~=': (False, 23), 'break': (False, 23), ',': (False, 23), 'if': (False, 23), '^': (False, 23), 'while': (False, 23), '/': (False, 23), '-': (False, 23), '<': (False, 23), 'or': (False, 23), 'local': (False, 23), 'return': (False, 23), '[': (False, 23), 'and': (False, 23), 'NAME': (False, 23), '(': (False, 23), '>=': (False, 23), '%': (False, 23), 'STRING': (False, 23), '.': (False, 23), '+': (False, 23), '==': (False, 23), '{': (False, 23), 'EMBEDSTAT': (False, 23), 'function': (False, 23), '*': (False, 23), 'do': (False, 23), 'goto': (False, 23), 'repeat': (False, 23), ':': (False, 23), 'for': (False, 23), 'end': (False, 23), '>': (False, 23), ';': (False, 23), '<=': (False, 23)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), ',': (False, 9), '==': (False, 9), '{': (False, 9), '>': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), 'until': (False, 9), '/': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'::': (False, 72), 'break': (False, 72), 'if': (False, 72), 'EMBEDSTAT': (False, 72), 'function': (False, 72), 'do': (False, 72), 'while': (False, 72), ';': (False, 72), '}': (False, 72), 'goto': (False, 72), 'for': (False, 72), 'local': (False, 72), 'return': (False, 72), 'NAME': (False, 72), '(': (False, 72), 'repeat': (False, 72)}, {'do': (True, 2630)}, {'.': (False, 9), '..': (False, 9), '+': (False, 9), ',': (False, 9), '==': (False, 9), '{': (False, 9), 'end': (False, 9), '^': (False, 9), '~=': (False, 9), '*': (False, 9), 'STRING': (False, 9), '-': (False, 9), '<': (False, 9), ':': (False, 9), 'or': (False, 9), '/': (False, 9), '>': (False, 9), '[': (False, 9), 'and': (False, 9), ';': (False, 9), '(': (False, 9), '>=': (False, 9), '%': (False, 9), '<=': (False, 9)}, {'..': (False, 13), '::': (False, 13), '~=': (False, 13), 'break': (False, 13), 'if': (False, 13), 'elseif': (False, 13), '^': (False, 13), 'while': (False, 13), '/': (False, 13), '-': (False, 13), '<': (False, 13), 'or': (False, 13), 'local': (False, 13), 'return': (False, 13), '[': (False, 13), 'and': (False, 13), ';': (False, 13), '(': (False, 13), '>=': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '+': (False, 13), '==': (False, 13), '{': (False, 13), 'EMBEDSTAT': (False, 13), 'function': (False, 13), '*': (False, 13), 'do': (False, 13), 'goto': (Fal