
from context import flatten
from toylua.lex import tokenizer
from toylua.ast import *


def values(tokens):
    return [t.value for t in tokens]

def assignment_or_functioncall(exps, assignment):
    # Assignments and function calls use the same grammar rule, to keep it LL.
    # Based on exprstat() and assignment() in lparser.c.
    if not assignment:
        if not isinstance(exps[0], FunctionCall):
            raise ParseError(exps[0].location, 'Expected assignment or function call')
        return exps[0]
    else:
        for e in exps:
            if not isinstance(e, (Name, Dot, Brackets)):
                raise ParseError(e.location, 'Invalid lvalue')
        return Assignment(exps[0].location, exps, assignment)

def process_suffixedexp(base, suffixes):
    for suffix_fn in suffixes:
        base = suffix_fn(base)
    return base

def left_associative(symbols):
    symbols = iter(symbols)
    left = next(symbols)
    while True:
        try:
            op = next(symbols)
            right = next(symbols)
            left = BinOp(op.location, left, op.type, right)
        except StopIteration:
            return left

def check_key(e, errloc):
    if not isinstance(e, Name):
        raise ParseError(errloc, "Unexpected '='")
    return String(e.location, e.name)


from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [close_with or 'EOF', start_nt or 'chunk']
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        stack_top = stack[-1]

        if isinstance(stack_top, int):
            rule, action = RULES[stack_top]
            stack.pop()
            n = len(rule)
            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(action(ctx, *args))

        elif stack_top not in TABLE:
            if token.type != stack_top:
                raise ParseError(token.location, "Expected " + stack_top)
            stack.pop()
            if not stack: break
            results.append(token)
            token = next(tok_iter)

        else:
            row = TABLE[stack_top]
            if token.type not in row:
                raise ParseError(token.location, "Unexpected {}, expected {}".format(
                    repr(token.type), ', '.join(sorted(repr(k) for k in row))))
            rule_num = row[token.type]
            rule, action = RULES[rule_num]
            stack.pop()
            stack.append(rule_num)
            stack.extend(reversed(rule))

    return results[0]

RULES = [(('parlist',), 
(lambda ctx, v1: [('a', v1)])
), ((), 
(lambda ctx: [])
), (('[', 'exp', ']', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('k', v2), (None, v3), (None, v4), ('v', v5)], user=lambda _ctx, _all, v, _loc, k: (
Field(_loc, k, v)
), normal_vars=['k', 'v'], list_vars=[]))
), (('exp', 'field__1'), 
(combine_action(root=lambda ctx, v1, v2: [('a', v1), v2], user=lambda _ctx, a, b, _all, _loc: (
Field(a.location, check_key(a, _loc), b) if b else Field(a.location, None, a)
), normal_vars=['a', 'b'], list_vars=[]))
), ((',', 'suffixedexp', 'stat__2'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('p', v2), v3])
), ((), 
(lambda ctx: [])
), (('exp6__2', 'exp7', 'exp6__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('+',), 
(lambda ctx, v1: [(None, v1)])
), (('-',), 
(lambda ctx, v1: [(None, v1)])
), (('exp5__2', 'exp6', 'exp5__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('::', 'NAME', '::'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), (None, v3)], user=lambda _ctx, n, _all, _loc: (
Label(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('*',), 
(lambda ctx, v1: [(None, v1)])
), (('/',), 
(lambda ctx, v1: [(None, v1)])
), (('%',), 
(lambda ctx, v1: [(None, v1)])
), (('=', 'explist'), 
(lambda ctx, v1, v2: [(None, v1), ('es', v2)])
), ((), 
(lambda ctx: [])
), (('.', 'NAME', 'funcname__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ((), 
(lambda ctx: [])
), (('<',), 
(lambda ctx, v1: [(None, v1)])
), (('>',), 
(lambda ctx, v1: [(None, v1)])
), (('<=',), 
(lambda ctx, v1: [(None, v1)])
), (('>=',), 
(lambda ctx, v1: [(None, v1)])
), (('~=',), 
(lambda ctx, v1: [(None, v1)])
), (('==',), 
(lambda ctx, v1: [(None, v1)])
), (('not',), 
(lambda ctx, v1: [('op', v1)])
), (('#',), 
(lambda ctx, v1: [('op', v1)])
), (('-',), 
(lambda ctx, v1: [('op', v1)])
), (('=', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('stat', 'block__1'), 
(lambda ctx, v1, v2: [('ss', v1), v2])
), ((), 
(lambda ctx: [])
), ((',', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('e3', v2)])
), ((), 
(lambda ctx: [])
), (('block__1', 'block__2'), 
(combine_action(root=lambda ctx, v1, v2: [v1, v2], user=lambda ss, _ctx, _all, _loc: (
Block(flatten(ss))
), normal_vars=[], list_vars=['ss']))
), (('exp6', 'exp5__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _ctx, _all, _loc: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('explist',), 
(lambda ctx, v1: [('e', v1)])
), ((), 
(lambda ctx: [])
), ((':', 'NAME'), 
(lambda ctx, v1, v2: [(None, v1), ('c', v2)])
), ((), 
(lambda ctx: [])
), (('{', 'tableconstructor__1', '}'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda f, _ctx, _all, _loc: (
TableConstructor(_loc, flatten(f))
), normal_vars=['f'], list_vars=[]))
), (('simpleexp', 'exp8__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda _ctx, r, _all, op, _loc, l: (
BinOp(op.location, l, op.type, r) if r else l
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), (('function', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('b', v2)], user=lambda _ctx, b, _all, _loc: (
Function(_loc, None, b[0], b[1])
), normal_vars=['b'], list_vars=[]))
), ((';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
None
), normal_vars=[], list_vars=[]))
), (('suffixedexp', 'stat__1'), 
(combine_action(root=lambda ctx, v1, v2: [('p', v1), v2], user=lambda p, _ctx, a, _all, _loc: (
assignment_or_functioncall(p, a)
), normal_vars=['a'], list_vars=['p']))
), (('label',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _ctx, s, _all, _loc: (
s
), normal_vars=['s'], list_vars=[]))
), (('break',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
Break(_loc)
), normal_vars=[], list_vars=[]))
), (('goto', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('n', v2)], user=lambda _ctx, n, _all, _loc: (
Goto(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('b', v2), (None, v3)], user=lambda _ctx, b, _all, _loc: (
BlockStatement(_loc, b)
), normal_vars=['b'], list_vars=[]))
), (('while', 'exp', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), (None, v5)], user=lambda _ctx, e, b, _all, _loc: (
While(_loc, e, b)
), normal_vars=['b', 'e'], list_vars=[]))
), (('repeat', 'block', 'until', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), ('b', v2), (None, v3), ('e', v4)], user=lambda _ctx, b, e, _all, _loc: (
Repeat(_loc, b, e)
), normal_vars=['b', 'e'], list_vars=[]))
), (('if', 'exp', 'then', 'block', 'stat__3', 'stat__4', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5, v6, (None, v7)], user=lambda _ctx, e, b, _all, _loc: (
If(_loc, e, b)
), normal_vars=[], list_vars=['b', 'e']))
), (('for', 'NAME', 'stat_for'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('s', v3)], user=lambda _ctx, n, s, _all, _loc: (
s(_loc, n)
), normal_vars=['n', 's'], list_vars=[]))
), (('function', 'funcname', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda _ctx, b, n, _all, _loc: (
Function(_loc, n, b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), (('local', 'stat_local'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('s', v2)], user=lambda _ctx, s, _all, _loc: (
s(_loc)
), normal_vars=['s'], list_vars=[]))
), (('EMBEDSTAT',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
EmbedStatement(e.location, e.value)
), normal_vars=['e'], list_vars=[]))
), (('nil',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
LuaNil(_loc)
), normal_vars=[], list_vars=[]))
), (('false',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
LuaFalse(_loc)
), normal_vars=[], list_vars=[]))
), (('true',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
LuaTrue(_loc)
), normal_vars=[], list_vars=[]))
), (('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _ctx, n, _all, _loc: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _ctx, s, _all, _loc: (
String(_loc, s.value)
), normal_vars=['s'], list_vars=[]))
), (('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
EmbedExpression(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), (('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), (('functiondef',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda f, _ctx, _all, _loc: (
f
), normal_vars=['f'], list_vars=[]))
), (('suffixedexp',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), (('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda t, _ctx, _all, _loc: (
t
), normal_vars=['t'], list_vars=[]))
), (('primaryexp', 'suffixedexp__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda _ctx, e, s, _all, _loc: (
process_suffixedexp(e, s)
), normal_vars=['e'], list_vars=['s']))
), ((',',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
None
), normal_vars=[], list_vars=[]))
), ((';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
None
), normal_vars=[], list_vars=[]))
), (('fieldsep', 'fieldlist__2'), 
(lambda ctx, v1, v2: [(None, v1), v2])
), ((), 
(lambda ctx: [])
), (('NAME', 'funcname__1', 'funcname__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), v2, v3], user=lambda _ctx, n, _all, _loc, c: (
FuncName(values(n), c.value if c else None)
), normal_vars=['c'], list_vars=['n']))
), (('or', 'exp2', 'exp__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('exp5', 'exp4__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda _ctx, r, _all, op, _loc, l: (
BinOp(op.location, l, op.type, r) if r else l
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), (('elseif', 'exp', 'then', 'block', 'stat__3'), 
(lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5])
), ((), 
(lambda ctx: [])
), (('fieldlist',), 
(lambda ctx, v1: [('l', v1)])
), ((), 
(lambda ctx: [])
), (('exp2', 'exp__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _ctx, _all, _loc: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('function', 'NAME', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda _ctx, b, n, _all, _loc: (
lambda loc: LocalFunction(loc, FuncName([n.value], None), b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), (('NAME', 'stat_local__1', 'stat_local__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('ns', v1), v2, v3], user=lambda _ctx, es, ns, _all, _loc: (
lambda loc: Local(loc, values(ns), es)
), normal_vars=['es'], list_vars=['ns']))
), (('exp3', 'exp2__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _ctx, _all, _loc: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), (('(', 'funcbody__1', ')', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), v2, (None, v3), ('b', v4), (None, v5)], user=lambda _ctx, a, b, _all, _loc: (
(flatten(a), b)
), normal_vars=['a', 'b'], list_vars=[]))
), (('exp7', 'exp6__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _ctx, _all, _loc: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), ((',', 'exp', 'explist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), v3])
), ((), 
(lambda ctx: [])
), ((';',), 
(lambda ctx, v1: [(None, v1)])
), ((), 
(lambda ctx: [])
), (('..', 'exp4'), 
(lambda ctx, v1, v2: [('op', v1), ('r', v2)])
), ((), 
(lambda ctx: [])
), (('^', 'exp7'), 
(lambda ctx, v1, v2: [('op', v1), ('r', v2)])
), ((), 
(lambda ctx: [])
), (('exp', 'explist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=[], list_vars=['e']))
), (('stat__2', '=', 'explist'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), ('a', v3)])
), ((), 
(lambda ctx: [])
), (('suffixedexp_suffix', 'suffixedexp__1'), 
(lambda ctx, v1, v2: [('s', v1), v2])
), ((), 
(lambda ctx: [])
), ((',', 'NAME', 'stat_for__2'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ((), 
(lambda ctx: [])
), (('exp7__1', 'exp7'), 
(combine_action(root=lambda ctx, v1, v2: [v1, ('e', v2)], user=lambda _ctx, e, _all, _loc, op: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), (('exp8',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), (('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _all, _loc: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), (('NAME', 'parlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('n', v1), v2], user=lambda p, _ctx, n, _all, _loc: (
[n.value, p or []]
), normal_vars=['n', 'p'], list_vars=[]))
), (('explist',), 
(lambda ctx, v1: [('e', v1)])
), ((), 
(lambda ctx: [])
), (('retstat',), 
(lambda ctx, v1: [('ss', v1)])
), ((), 
(lambda ctx: [])
), (('return', 'retstat__1', 'retstat__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, v3], user=lambda _ctx, e, _all, _loc: (
Return(_loc, e)
), normal_vars=['e'], list_vars=[]))
), ((',', 'parlist'), 
(lambda ctx, v1, v2: [(None, v1), ('p', v2)])
), ((), 
(lambda ctx: [])
), (('exp3__2', 'exp4', 'exp3__1'), 
(lambda ctx, v1, v2, v3: [v1, (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('block',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda _ctx, a, _all, _loc: (
a
), normal_vars=['a'], list_vars=[]))
), (('exp4', 'exp3__1'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), v2], user=lambda _ctx, _all, _loc: (
left_associative(_all)
), normal_vars=[], list_vars=[]))
), ((',', 'NAME', 'stat_local__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3])
), ((), 
(lambda ctx: [])
), (('field', 'fieldlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('f', v1), v2], user=lambda f, _ctx, _all, _loc, l: (
[f, l]
), normal_vars=['f', 'l'], list_vars=[]))
), (('=', 'exp', ',', 'exp', 'stat_for__1', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7, v8: [(None, v1), ('e1', v2), (None, v3), ('e2', v4), v5, (None, v6), ('b', v7), (None, v8)], user=lambda _ctx, b, _all, e2, e3, e1, _loc: (
lambda loc, n: NumericFor(loc, n, e1, e2, e3, b)
), normal_vars=['b', 'e1', 'e2', 'e3'], list_vars=[]))
), (('stat_for__2', 'in', 'explist', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6: [v1, (None, v2), ('e', v3), (None, v4), ('b', v5), (None, v6)], user=lambda _ctx, b, _all, e, n, _loc: (
lambda loc, n1: GenericFor(loc, values([n1]+n), e, b)
), normal_vars=['b', 'e'], list_vars=['n']))
), (('else', 'block'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('fieldlist',), 
(lambda ctx, v1: [('f', v1)])
), ((), 
(lambda ctx: [])
), (('NAME',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _ctx, n, _all, _loc: (
Name(n.location, n.value)
), normal_vars=['n'], list_vars=[]))
), (('(', 'exp', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _ctx, e, _all, _loc: (
e
), normal_vars=['e'], list_vars=[]))
), (('and', 'exp3', 'exp2__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), (None, v2), v3])
), ((), 
(lambda ctx: [])
), (('.', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [('d', v1), ('n', v2)], user=lambda _ctx, n, _all, _loc, d: (
lambda left: Dot(d.location, left, n.value)
), normal_vars=['d', 'n'], list_vars=[]))
), (('[', 'exp', ']'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('d', v1), ('e', v2), (None, v3)], user=lambda _ctx, e, _all, _loc, d: (
lambda left: Brackets(d.location, left, e)
), normal_vars=['d', 'e'], list_vars=[]))
), ((':', 'NAME', 'args'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('d', v1), ('n', v2), ('a', v3)], user=lambda _ctx, a, _all, n, _loc, d: (
lambda left: FunctionCall(d.location, left, n.value, a[1])
), normal_vars=['a', 'd', 'n'], list_vars=[]))
), (('args',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda _ctx, a, _all, _loc: (
lambda left: FunctionCall(a[0], left, None, a[1])
), normal_vars=['a'], list_vars=[]))
), (('(', 'args__1', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda _ctx, e, _all, _loc: (
(_loc, e or [])
), normal_vars=['e'], list_vars=[]))
), (('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda t, _ctx, _all, _loc: (
(t.location, [t])
), normal_vars=['t'], list_vars=[]))
), (('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _ctx, s, _all, _loc: (
(s.location, [s.value])
), normal_vars=['s'], list_vars=[]))
)]
TABLE = {'field': {'EMBEDEXPR': 3, '(': 3, 'NUMBER': 3, '-': 3, '{': 3, 'false': 3, 'function': 3, 'STRING': 3, '[': 2, '#': 3, 'true': 3, 'not': 3, 'NAME': 3, 'nil': 3, '...': 3}, 'stat__2': {'=': 5, ',': 4}, 'exp6__1': {'until': 7, ';': 7, '>=': 7, '<=': 7, 'EMBEDSTAT': 7, '(': 7, '<': 7, 'goto': 7, '*': 6, 'for': 7, '%': 6, 'while': 7, 'return': 7, 'repeat': 7, '>': 7, 'else': 7, 'NAME': 7, 'local': 7, '+': 7, ':)': 7, 'then': 7, 'end': 7, '-': 7, '/': 6, 'if': 7, '::': 7, 'do': 7, 'function': 7, '~=': 7, '==': 7, 'elseif': 7, ',': 7, 'break': 7, 'and': 7, '}': 7, ')': 7, 'or': 7, '..': 7, '=': 7, ']': 7}, 'exp5__2': {'+': 8, '-': 9}, 'exp3__1': {'until': 113, 'for': 113, '>=': 112, '<=': 112, 'EMBEDSTAT': 113, '(': 113, '<': 112, ';': 113, ']': 113, 'while': 113, 'return': 113, 'or': 113, 'else': 113, ',': 113, 'NAME': 113, 'local': 113, '>': 112, ':)': 113, 'then': 113, 'end': 113, 'do': 113, '::': 113, 'goto': 113, 'function': 113, '~=': 112, '==': 112, 'elseif': 113, 'if': 113, 'break': 113, 'and': 113, '}': 113, ')': 113, '=': 113, 'repeat': 113}, 'label': {'::': 12}, 'exp6__2': {'*': 13, '%': 15, '/': 14}, 'stat_local__2': {'until': 17, 'for': 17, 'local': 17, 'EMBEDSTAT': 17, '(': 17, 'break': 17, 'goto': 17, ';': 17, 'elseif': 17, 'do': 17, 'end': 17, 'while': 17, 'function': 17, 'repeat': 17, 'return': 17, '=': 16, '::': 17, 'else': 17, 'NAME': 17, 'if': 17}, 'funcname__1': {'(': 19, '.': 18, ':': 19}, 'exp3__2': {'>': 21, '==': 25, '>=': 23, '<=': 22, '<': 20, '~=': 24}, 'exp7__1': {'not': 26, '#': 27, '-': 28}, 'field__1': {',': 30, ';': 30, '=': 29, '}': 30}, 'block__1': {'until': 32, '(': 31, 'elseif': 32, 'for': 31, 'if': 31, 'EMBEDSTAT': 31, 'do': 31, 'break': 31, ';': 31, '::': 31, 'goto': 31, 'function': 31, 'while': 31, 'end': 32, 'return': 32, 'repeat': 31, 'else': 32, 'NAME': 31, 'local': 31}, 'stat_for__1': {',': 33, 'do': 34}, 'exp3': {'EMBEDEXPR': 115, '(': 115, 'NUMBER': 115, '-': 115, '{': 115, 'false': 115, 'function': 115, 'STRING': 115, '#': 115, 'true': 115, 'not': 115, 'NAME': 115, 'nil': 115, '...': 115}, 'exp5': {'EMBEDEXPR': 36, '(': 36, 'NUMBER': 36, '-': 36, '{': 36, 'false': 36, 'function': 36, 'STRING': 36, '#': 36, 'true': 36, 'not': 36, 'NAME': 36, 'nil': 36, '...': 36}, 'args__1': {'EMBEDEXPR': 37, '(': 37, 'NUMBER': 37, '-': 37, '{': 37, 'false': 37, 'function': 37, 'STRING': 37, ')': 38, '#': 37, 'true': 37, 'not': 37, 'NAME': 37, 'nil': 37, '...': 37}, 'stat_for': {',': 120, '=': 119, 'in': 120}, 'funcname__2': {'(': 40, ':': 39}, 'tableconstructor': {'{': 41}, 'exp8': {'EMBEDEXPR': 42, '(': 42, 'NUMBER': 42, '...': 42, '{': 42, 'false': 42, 'true': 42, 'NAME': 42, 'function': 42, 'nil': 42, 'STRING': 42}, 'functiondef': {'function': 43}, 'stat': {'(': 45, 'for': 53, '::': 46, 'EMBEDSTAT': 56, 'do': 49, 'break': 47, ';': 44, 'goto': 48, 'function': 54, 'while': 50, 'repeat': 51, 'NAME': 45, 'local': 55, 'if': 52}, 'simpleexp': {'EMBEDEXPR': 62, 'true': 59, 'NUMBER': 60, '...': 63, '{': 66, '(': 65, 'false': 58, 'NAME': 65, 'function': 64, 'nil': 57, 'STRING': 61}, 'suffixedexp': {'(': 67, 'NAME': 67}, 'fieldsep': {';': 69, ',': 68}, 'fieldlist__1': {';': 70, ',': 70, '}': 71}, 'funcname': {'NAME': 72}, 'exp__1': {'until': 74, ';': 74, 'local': 74, 'EMBEDSTAT': 74, '(': 74, 'break': 74, 'for': 74, ']': 74, 'while': 74, 'return': 74, 'or': 73, 'else': 74, 'NAME': 74, 'if': 74, ':)': 74, 'then': 74, 'end': 74, 'do': 74, '::': 74, 'goto': 74, 'function': 74, 'elseif': 74, ',': 74, '}': 74, ')': 74, '=': 74, 'repeat': 74}, 'exp4': {'EMBEDEXPR': 75, '(': 75, 'NUMBER': 75, '-': 75, '{': 75, 'false': 75, 'function': 75, 'STRING': 75, '#': 75, 'true': 75, 'not': 75, 'NAME': 75, 'nil': 75, '...': 75}, 'stat__3': {'else': 77, 'elseif': 76, 'end': 77}, 'fieldlist__2': {'EMBEDEXPR': 78, '(': 78, 'NUMBER': 78, '-': 78, '{': 78, 'false': 78, 'function': 78, 'STRING': 78, '[': 78, '#': 78, '}': 79, 'true': 78, 'not': 78, 'NAME': 78, 'nil': 78, '...': 78}, 'parlist__1': {')': 111, ',': 110}, 'stat_local': {'NAME': 82, 'function': 81}, 'exp2': {'EMBEDEXPR': 83, '(': 83, 'NUMBER': 83, '-': 83, '{': 83, 'false': 83, 'function': 83, 'STRING': 83, '#': 83, 'true': 83, 'not': 83, 'NAME': 83, 'nil': 83, '...': 83}, 'funcbody': {'(': 84}, 'exp6': {'EMBEDEXPR': 85, '(': 85, 'NUMBER': 85, '-': 85, '{': 85, 'false': 85, 'function': 85, 'STRING': 85, '#': 85, 'true': 85, 'not': 85, 'NAME': 85, 'nil': 85, '...': 85}, 'retstat__1': {'EMBEDEXPR': 105, '(': 105, 'elseif': 106, 'NUMBER': 105, '-': 105, '{': 105, 'until': 106, 'false': 105, ';': 106, 'function': 105, 'STRING': 105, 'end': 106, 'else': 106, '#': 105, 'true': 105, 'not': 105, 'NAME': 105, 'nil': 105, '...': 105}, 'retstat__2': {'else': 89, 'until': 89, 'elseif': 89, ';': 88, 'end': 89}, 'exp4__1': {'until': 91, ';': 91, '>=': 91, '<=': 91, 'EMBEDSTAT': 91, '(': 91, '<': 91, 'for': 91, 'while': 91, 'return': 91, 'repeat': 91, 'or': 91, 'else': 91, 'NAME': 91, 'local': 91, '>': 91, ':)': 91, 'then': 91, 'end': 91, 'do': 91, 'if': 91, '::': 91, 'goto': 91, 'function': 91, '~=': 91, '==': 91, 'elseif': 91, ',': 91, 'break': 91, 'and': 91, '}': 91, ')': 91, '..': 90, '=': 91, ']': 91}, 'exp8__1': {'until': 93, ';': 93, '>=': 93, '<=': 93, 'EMBEDSTAT': 93, '^': 92, '<': 93, 'goto': 93, '*': 93, 'for': 93, '%': 93, 'while': 93, 'return': 93, 'repeat': 93, '>': 93, 'else': 93, 'NAME': 93, 'local': 93, '+': 93, ':)': 93, 'then': 93, 'end': 93, '-': 93, '/': 93, 'if': 93, '::': 93, 'do': 93, 'function': 93, '~=': 93, '==': 93, 'elseif': 93, ',': 93, 'break': 93, 'and': 93, '}': 93, ')': 93, 'or': 93, '..': 93, '=': 93, '(': 93, ']': 93}, 'explist': {'EMBEDEXPR': 94, '(': 94, 'NUMBER': 94, '-': 94, '{': 94, 'false': 94, 'function': 94, 'STRING': 94, '#': 94, 'true': 94, 'not': 94, 'NAME': 94, 'nil': 94, '...': 94}, 'stat__1': {'until': 96, 'for': 96, 'local': 96, 'EMBEDSTAT': 96, '(': 96, 'break': 96, 'goto': 96, ';': 96, 'elseif': 96, 'do': 96, 'end': 96, 'while': 96, 'function': 96, 'repeat': 96, 'return': 96, '=': 95, '::': 96, 'else': 96, ',': 95, 'NAME': 96, 'if': 96}, 'suffixedexp__1': {'until': 98, '>=': 98, '<=': 98, '{': 97, '<': 98, '*': 98, 'for': 98, 'while': 98, 'local': 98, '>': 98, ':)': 98, 'end': 98, '/': 98, '::': 98, 'function': 98, '~=': 98, '==': 98, ',': 98, 'and': 98, '}': 98, ')': 98, '=': 98, ']': 98, '+': 98, 'elseif': 98, '..': 98, 'EMBEDSTAT': 98, '^': 98, 'break': 98, ';': 98, '%': 98, 'return': 98, '[': 97, 'or': 98, 'else': 98, 'NAME': 98, '-': 98, '(': 97, 'if': 98, 'do': 98, '.': 97, 'goto': 98, 'STRING': 97, ':': 97, 'then': 98, 'repeat': 98}, 'stat_for__2': {',': 99, 'in': 100}, 'exp7': {'EMBEDEXPR': 102, '(': 102, 'NUMBER': 102, '...': 102, '{': 102, 'false': 102, 'function': 102, 'STRING': 102, '#': 101, 'true': 102, 'not': 101, 'NAME': 102, 'nil': 102, '-': 101}, 'parlist': {'NAME': 104, '...': 103}, 'explist__1': {'until': 87, 'for': 87, 'local': 87, 'EMBEDSTAT': 87, '(': 87, 'break': 87, 'goto': 87, ';': 87, 'elseif': 87, 'do': 87, 'end': 87, 'while': 87, 'function': 87, ')': 87, 'return': 87, ',': 86, '::': 87, 'else': 87, 'NAME': 87, 'repeat': 87, 'if': 87}, 'block__2': {'else': 108, 'until': 108, 'return': 107, 'elseif': 108, 'end': 108}, 'exp2__1': {'until': 128, ';': 128, 'local': 128, 'EMBEDSTAT': 128, '(': 128, 'break': 128, 'for': 128, ']': 128, 'while': 128, 'return': 128, 'or': 128, 'else': 128, 'NAME': 128, 'if': 128, ':)': 128, 'then': 128, 'end': 128, 'do': 128, '::': 128, 'goto': 128, 'function': 128, 'elseif': 128, ',': 128, 'and': 127, '}': 128, ')': 128, '=': 128, 'repeat': 128}, 'retstat': {'return': 109}, 'exp5__1': {'until': 11, ';': 11, '>=': 11, '<=': 11, 'EMBEDSTAT': 11, '(': 11, '<': 11, 'for': 11, 'while': 11, 'return': 11, 'repeat': 11, '>': 11, 'else': 11, 'NAME': 11, 'end': 11, '+': 10, ':)': 11, 'then': 11, '-': 10, 'do': 11, 'if': 11, '::': 11, 'goto': 11, 'function': 11, '~=': 11, '==': 11, 'elseif': 11, ',': 11, 'break': 11, 'and': 11, '}': 11, ')': 11, 'or': 11, '..': 11, '=': 11, 'local': 11, ']': 11}, 'chunk': {'(': 114, '::': 114, 'local': 114, 'EMBEDSTAT': 114, 'do': 114, 'break': 114, ';': 114, 'for': 114, 'goto': 114, 'function': 114, 'while': 114, 'return': 114, 'repeat': 114, 'NAME': 114, 'if': 114}, 'block': {'(': 35, 'return': 35, ';': 35, 'if': 35, 'EMBEDSTAT': 35, 'until': 35, 'break': 35, '::': 35, 'goto': 35, 'function': 35, 'while': 35, 'repeat': 35, 'elseif': 35, 'do': 35, 'for': 35, 'else': 35, 'NAME': 35, 'local': 35, 'end': 35}, 'stat_local__1': {'=': 117, 'until': 117, 'for': 117, 'local': 117, 'EMBEDSTAT': 117, '(': 117, 'break': 117, 'goto': 117, ';': 117, 'elseif': 117, 'do': 117, 'end': 117, 'while': 117, 'function': 117, 'repeat': 117, 'return': 117, ',': 116, '::': 117, 'else': 117, 'NAME': 117, 'if': 117}, 'fieldlist': {'EMBEDEXPR': 118, '(': 118, 'NUMBER': 118, '-': 118, '{': 118, 'false': 118, 'function': 118, 'STRING': 118, '[': 118, '#': 118, 'true': 118, 'not': 118, 'NAME': 118, 'nil': 118, '...': 118}, 'exp': {'EMBEDEXPR': 80, '(': 80, 'NUMBER': 80, '-': 80, '{': 80, 'false': 80, 'function': 80, 'STRING': 80, '#': 80, 'true': 80, 'not': 80, 'NAME': 80, 'nil': 80, '...': 80}, 'stat__4': {'else': 121, 'end': 122}, 'tableconstructor__1': {'EMBEDEXPR': 123, '(': 123, 'NUMBER': 123, '-': 123, '{': 123, 'false': 123, 'function': 123, 'STRING': 123, '[': 123, '#': 123, '}': 124, 'true': 123, 'not': 123, 'NAME': 123, 'nil': 123, '...': 123}, 'primaryexp': {'(': 126, 'NAME': 125}, 'funcbody__1': {')': 1, 'NAME': 0, '...': 0}, 'suffixedexp_suffix': {'(': 132, '[': 130, '{': 132, '.': 129, 'STRING': 132, ':': 131}, 'args': {'(': 133, '{': 134, 'STRING': 135}}
