from toycalc.lex import tokenizer
from toycalc.ast import *

from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [INITIAL[(start_nt or 'expr', close_with or 'EOF')]]
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        action = TABLE[stack[-1]].get(token.type)

        if action is None:
            nonterminals = { nt for nt, right, action in RULES }
            choices = { repr(k) for k in TABLE[stack[-1]] if k not in nonterminals }
            raise ParseError(token.location, "Unexpected {}, expected {}".format(
                repr(token.type), ', '.join(sorted(choices))))

        is_shift, action_value = action

        if is_shift:
            results.append(token)
            stack.append(action_value)
            token = next(tok_iter)
        else:
            if action_value is None: break
            left, right, rule_action = RULES[action_value]
            n = len(right)

            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(rule_action(ctx, *args))

            del stack[len(stack) - n:]
            new_is_shift, new_state = TABLE[stack[-1]][left]
            assert new_is_shift
            stack.append(new_state)

    return results[0]

INITIAL = {('expr', '@@@'): 0}
RULES = [('expr', ('expr', '+', 'expr'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), (None, v2), ('r', v3)], user=lambda _loc, _all, r, l, _ctx: (
Add(_loc, l, r)
), normal_vars=['l', 'r'], list_vars=[]))
), ('expr', ('expr', '-', 'expr'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), (None, v2), ('r', v3)], user=lambda _loc, _all, r, l, _ctx: (
Sub(_loc, l, r)
), normal_vars=['l', 'r'], list_vars=[]))
), ('expr', ('expr', '*', 'expr'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), (None, v2), ('r', v3)], user=lambda _loc, _all, r, l, _ctx: (
Mul(_loc, l, r)
), normal_vars=['l', 'r'], list_vars=[]))
), ('expr', ('expr', '/', 'expr'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), (None, v2), ('r', v3)], user=lambda _loc, _all, r, l, _ctx: (
Div(_loc, l, r)
), normal_vars=['l', 'r'], list_vars=[]))
), ('expr', ('expr', '^', 'expr'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), (None, v2), ('r', v3)], user=lambda _loc, _all, r, l, _ctx: (
Pow(_loc, l, r)
), normal_vars=['l', 'r'], list_vars=[]))
), ('expr', ('-', 'expr'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('e', v2)], user=lambda _loc, _all, e, _ctx: (
UnaryMin(_loc, e)
), normal_vars=['e'], list_vars=[]))
), ('expr', ('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _loc, _all, _ctx, n: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('expr', ('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda _loc, _all, e, _ctx: (
Embedded(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), ('expr', ('(', 'expr', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda _loc, _all, e, _ctx: (
e
), normal_vars=['e'], list_vars=[]))
)]
TABLE = [{'expr': (True, 1), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'*': (True, 7), '/': (True, 8), '+': (True, 10), '^': (True, 6), '@@@': (False, None), '-': (True, 9)}, {'expr': (True, 17), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'*': (False, 6), '/': (False, 6), '+': (False, 6), '^': (False, 6), '@@@': (False, 6), '-': (False, 6)}, {'expr': (True, 12), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'*': (False, 7), '/': (False, 7), '+': (False, 7), '^': (False, 7), '@@@': (False, 7), '-': (False, 7)}, {'expr': (True, 15), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'expr': (True, 16), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'expr': (True, 11), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'expr': (True, 13), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'expr': (True, 14), '-': (True, 4), 'NUMBER': (True, 3), '(': (True, 2), 'EMBEDEXPR': (True, 5)}, {'*': (False, 3), '/': (False, 3), '+': (False, 3), '^': (True, 6), '@@@': (False, 3), '-': (False, 3)}, {'*': (False, 5), '/': (False, 5), '+': (False, 5), '^': (True, 6), '@@@': (False, 5), '-': (False, 5)}, {'*': (True, 7), '/': (True, 8), '+': (False, 1), '^': (True, 6), '@@@': (False, 1), '-': (False, 1)}, {'*': (True, 7), '/': (True, 8), '+': (False, 0), '^': (True, 6), '@@@': (False, 0), '-': (False, 0)}, {'*': (False, 4), '/': (False, 4), '+': (False, 4), '^': (True, 6), '@@@': (False, 4), '-': (False, 4)}, {'*': (False, 2), '/': (False, 2), '+': (False, 2), '^': (True, 6), '@@@': (False, 2), '-': (False, 2)}, {'*': (True, 24), '/': (True, 25), '+': (True, 26), '^': (True, 23), '-': (True, 27), ')': (True, 28)}, {'expr': (True, 32), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'*': (False, 6), '/': (False, 6), '+': (False, 6), '^': (False, 6), '-': (False, 6), ')': (False, 6)}, {'expr': (True, 22), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'*': (False, 7), '/': (False, 7), '+': (False, 7), '^': (False, 7), '-': (False, 7), ')': (False, 7)}, {'*': (False, 5), '/': (False, 5), '+': (False, 5), '^': (True, 23), '-': (False, 5), ')': (False, 5)}, {'expr': (True, 35), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'expr': (True, 29), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'expr': (True, 30), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'expr': (True, 31), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'expr': (True, 34), '-': (True, 20), 'NUMBER': (True, 19), '(': (True, 18), 'EMBEDEXPR': (True, 21)}, {'*': (False, 8), '/': (False, 8), '+': (False, 8), '^': (False, 8), '@@@': (False, 8), '-': (False, 8)}, {'*': (False, 2), '/': (False, 2), '+': (False, 2), '^': (True, 23), '-': (False, 2), ')': (False, 2)}, {'*': (False, 3), '/': (False, 3), '+': (False, 3), '^': (True, 23), '-': (False, 3), ')': (False, 3)}, {'*': (True, 24), '/': (True, 25), '+': (False, 0), '^': (True, 23), '-': (False, 0), ')': (False, 0)}, {'*': (True, 24), '/': (True, 25), '+': (True, 26), '^': (True, 23), '-': (True, 27), ')': (True, 33)}, {'*': (False, 8), '/': (False, 8), '+': (False, 8), '^': (False, 8), '-': (False, 8), ')': (False, 8)}, {'*': (True, 24), '/': (True, 25), '+': (False, 1), '^': (True, 23), '-': (False, 1), ')': (False, 1)}, {'*': (False, 4), '/': (False, 4), '+': (False, 4), '^': (True, 23), '-': (False, 4), ')': (False, 4)}]
