from toycalc.lex import tokenizer
from toycalc.ast import *

handlers = {
    "+": Add,
    "-": Sub,
    "*": Mul,
    "/": Div,
}

def left_associative(l, ops, rs):
    for op, r in zip(ops, rs):
        handler = handlers[op.type]
        l = handler(op.location, l, r)
    return l

from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [close_with or 'EOF', start_nt or 'expr']
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        stack_top = stack[-1]

        if isinstance(stack_top, int):
            rule, action = RULES[stack_top]
            stack.pop()
            n = len(rule)
            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(action(ctx, *args))

        elif stack_top not in TABLE:
            if token.type != stack_top:
                raise ParseError(token.location, "Expected " + stack_top)
            stack.pop()
            if not stack: break
            results.append(token)
            token = next(tok_iter)

        else:
            row = TABLE[stack_top]
            if token.type not in row:
                raise ParseError(token.location, "Unexpected {}, expected {}".format(
                    repr(token.type), ', '.join(sorted(repr(k) for k in row))))
            rule_num = row[token.type]
            rule, action = RULES[rule_num]
            stack.pop()
            stack.append(rule_num)
            stack.extend(reversed(rule))

    return results[0]

RULES = [(('+',), 
(lambda ctx, v1: [('ops', v1)])
), (('-',), 
(lambda ctx, v1: [('ops', v1)])
), (('value', 'power__1'), 
(combine_action(root=lambda ctx, v1, v2: [('a', v1), v2], user=lambda a, _loc, b, _ctx, _all: (
a if b is None else Pow(_loc, a, b)
), normal_vars=['a', 'b'], list_vars=[]))
), (('*',), 
(lambda ctx, v1: [('ops', v1)])
), (('/',), 
(lambda ctx, v1: [('ops', v1)])
), (('product', 'sum__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda ops, _all, l, _loc, _ctx, rs: (
left_associative(l, ops, rs)
), normal_vars=['l'], list_vars=['ops', 'rs']))
), (('product__2', 'factor', 'product__1'), 
(lambda ctx, v1, v2, v3: [v1, ('rs', v2), v3])
), ((), 
(lambda ctx: [])
), (('sum',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda e, _loc, _ctx, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _all, _loc, _ctx, n: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), (('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda e, _loc, _ctx, _all: (
Embedded(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), (('(', 'sum', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda e, _loc, _ctx, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('-', 'factor'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('e', v2)], user=lambda e, _loc, _ctx, _all: (
UnaryMin(_loc, e)
), normal_vars=['e'], list_vars=[]))
), (('power',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda e, _loc, _ctx, _all: (
e
), normal_vars=['e'], list_vars=[]))
), (('^', 'factor'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ((), 
(lambda ctx: [])
), (('sum__2', 'product', 'sum__1'), 
(lambda ctx, v1, v2, v3: [v1, ('rs', v2), v3])
), ((), 
(lambda ctx: [])
), (('factor', 'product__1'), 
(combine_action(root=lambda ctx, v1, v2: [('l', v1), v2], user=lambda ops, _all, l, _loc, _ctx, rs: (
left_associative(l, ops, rs)
), normal_vars=['l'], list_vars=['ops', 'rs']))
)]
TABLE = {'sum__2': {'+': 0, '-': 1}, 'expr': {'NUMBER': 8, 'EMBEDEXPR': 8, '-': 8, '(': 8}, 'product__2': {'/': 4, '*': 3}, 'product__1': {'*': 6, ')': 7, '-': 7, '/': 6, '+': 7, 'EOF': 7}, 'value': {'EMBEDEXPR': 10, 'NUMBER': 9, '(': 11}, 'power': {'EMBEDEXPR': 2, 'NUMBER': 2, '(': 2}, 'sum': {'-': 5, 'EMBEDEXPR': 5, 'NUMBER': 5, '(': 5}, 'factor': {'NUMBER': 13, 'EMBEDEXPR': 13, '-': 12, '(': 13}, 'sum__1': {'+': 16, ')': 17, '-': 16, 'EOF': 17}, 'power__1': {'^': 14, '*': 15, ')': 15, '-': 15, '/': 15, '+': 15, 'EOF': 15}, 'product': {'NUMBER': 18, 'EMBEDEXPR': 18, '-': 18, '(': 18}}
