
from context import flatten
from toylua.lex import tokenizer
from toylua.ast import *


def values(tokens):
    return [t.value for t in tokens]


from context import combine_action

from context import ParseError

def parse(ctx, start_nt=None, close_with=None):
    stack = [INITIAL[(start_nt or 'chunk', close_with or 'EOF')]]
    results = []
    tok_iter = tokenizer(ctx, close_with)
    token = next(tok_iter)

    while True:
        action = TABLE[stack[-1]].get(token.type)

        if action is None:
            nonterminals = { nt for nt, right, action in RULES }
            choices = { repr(k) for k in TABLE[stack[-1]] if k not in nonterminals }
            raise ParseError(token.location, "Unexpected {}, expected {}".format(
                repr(token.type), ', '.join(sorted(choices))))

        is_shift, action_value = action

        if is_shift:
            results.append(token)
            stack.append(action_value)
            token = next(tok_iter)
        else:
            if action_value is None: break
            left, right, rule_action = RULES[action_value]
            n = len(right)

            args = results[len(results) - n:]
            del results[len(results) - n:]
            results.append(rule_action(ctx, *args))

            del stack[len(stack) - n:]
            new_is_shift, new_state = TABLE[stack[-1]][left]
            assert new_is_shift
            stack.append(new_state)

    return results[0]

INITIAL = {('chunk', 'EOF'): 0}
RULES = [('retstat__2', (';',), 
(lambda ctx, v1: [(None, v1)])
), ('retstat__2', (), 
(lambda ctx: [])
), ('varlist', ('var', 'varlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('v', v1), v2], user=lambda _ctx, v, _loc, _all: (
v
), normal_vars=[], list_vars=['v']))
), ('namelist', ('NAME', 'namelist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('ns', v1), v2], user=lambda _ctx, ns, _loc, _all: (
values(ns)
), normal_vars=[], list_vars=['ns']))
), ('tableconstructor', ('{', 'tableconstructor__1', '}'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda f, _ctx, _loc, _all: (
TableConstructor(_loc, flatten(f))
), normal_vars=[], list_vars=['f']))
), ('funcbody__1', ('parlist',), 
(lambda ctx, v1: [('a', v1)])
), ('funcbody__1', (), 
(lambda ctx: [])
), ('stat__4', ('=', 'explist'), 
(lambda ctx, v1, v2: [(None, v1), ('es', v2)])
), ('stat__4', (), 
(lambda ctx: [])
), ('stat__3', (',', 'exp'), 
(lambda ctx, v1, v2: [(None, v1), ('e3', v2)])
), ('stat__3', (), 
(lambda ctx: [])
), ('args', ('(', 'args__1', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, (None, v3)], user=lambda e, _ctx, _loc, _all: (
(_loc, e or [])
), normal_vars=['e'], list_vars=[]))
), ('args', ('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda _ctx, t, _loc, _all: (
(t.location, [t])
), normal_vars=['t'], list_vars=[]))
), ('args', ('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _ctx, s, _loc, _all: (
(s.location, [s.value])
), normal_vars=['s'], list_vars=[]))
), ('stat__1', ('elseif', 'exp', 'then', 'block', 'stat__1'), 
(lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5])
), ('stat__1', (), 
(lambda ctx: [])
), ('retstat__1', ('explist',), 
(lambda ctx, v1: [('e', v1)])
), ('retstat__1', (), 
(lambda ctx: [])
), ('prefixexp', ('var',), 
(combine_action(root=lambda ctx, v1: [('v', v1)], user=lambda _ctx, v, _loc, _all: (
v
), normal_vars=['v'], list_vars=[]))
), ('prefixexp', ('functioncall',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda f, _ctx, _loc, _all: (
f
), normal_vars=['f'], list_vars=[]))
), ('prefixexp', ('(', 'exp', ')'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), (None, v3)], user=lambda e, _ctx, _loc, _all: (
e
), normal_vars=['e'], list_vars=[]))
), ('funcname__2', (':', 'NAME'), 
(lambda ctx, v1, v2: [(None, v1), ('c', v2)])
), ('funcname__2', (), 
(lambda ctx: [])
), ('parlist', ('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), ('parlist', ('NAME', 'parlist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('n', v1), v2], user=lambda p, n, _ctx, _loc, _all: (
[n.value, p or []]
), normal_vars=['n', 'p'], list_vars=[]))
), ('namelist__1', (',', 'NAME', 'namelist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3])
), ('namelist__1', (), 
(lambda ctx: [])
), ('label', ('::', 'NAME', '::'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), (None, v3)], user=lambda _ctx, n, _loc, _all: (
Label(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('explist__1', (',', 'exp', 'explist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('e', v2), v3])
), ('explist__1', (), 
(lambda ctx: [])
), ('args__1', ('explist',), 
(lambda ctx, v1: [('e', v1)])
), ('args__1', (), 
(lambda ctx: [])
), ('parlist__1', (',', 'parlist'), 
(lambda ctx, v1, v2: [(None, v1), ('p', v2)])
), ('parlist__1', (), 
(lambda ctx: [])
), ('stat__2', ('else', 'block'), 
(lambda ctx, v1, v2: [(None, v1), ('b', v2)])
), ('stat__2', (), 
(lambda ctx: [])
), ('funcname', ('NAME', 'funcname__1', 'funcname__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), v2, v3], user=lambda _ctx, n, c, _loc, _all: (
FuncName(values(n), c.value if c else None)
), normal_vars=['c'], list_vars=['n']))
), ('var', ('NAME',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _ctx, n, _loc, _all: (
Name(n.location, n.value)
), normal_vars=['n'], list_vars=[]))
), ('var', ('prefixexp', '[', 'exp', ']'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [('p', v1), ('d', v2), ('e', v3), (None, v4)], user=lambda _all, p, e, d, _ctx, _loc: (
Brackets(d.location, p, e)
), normal_vars=['d', 'e', 'p'], list_vars=[]))
), ('var', ('prefixexp', '.', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('p', v1), (None, v2), ('n', v3)], user=lambda p, n, _ctx, _loc, _all: (
Dot(p.location, p, n.value)
), normal_vars=['n', 'p'], list_vars=[]))
), ('stat', (';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
None
), normal_vars=[], list_vars=[]))
), ('stat', ('varlist', '=', 'explist'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('v', v1), (None, v2), ('e', v3)], user=lambda e, v, _ctx, _loc, _all: (
Assignment(v[0].location, v, e)
), normal_vars=['e', 'v'], list_vars=[]))
), ('stat', ('functioncall',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda f, _ctx, _loc, _all: (
f
), normal_vars=['f'], list_vars=[]))
), ('stat', ('label',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _ctx, s, _loc, _all: (
s
), normal_vars=['s'], list_vars=[]))
), ('stat', ('break',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
Break(_loc)
), normal_vars=[], list_vars=[]))
), ('stat', ('goto', 'NAME'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('n', v2)], user=lambda _ctx, n, _loc, _all: (
Goto(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('stat', ('do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('b', v2), (None, v3)], user=lambda b, _ctx, _loc, _all: (
BlockStatement(_loc, b)
), normal_vars=['b'], list_vars=[]))
), ('stat', ('while', 'exp', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('e', v2), (None, v3), ('b', v4), (None, v5)], user=lambda b, e, _ctx, _loc, _all: (
While(_loc, e, b)
), normal_vars=['b', 'e'], list_vars=[]))
), ('stat', ('repeat', 'block', 'until', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), ('b', v2), (None, v3), ('e', v4)], user=lambda b, e, _ctx, _loc, _all: (
Repeat(_loc, b, e)
), normal_vars=['b', 'e'], list_vars=[]))
), ('stat', ('if', 'exp', 'then', 'block', 'stat__1', 'stat__2', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('e', v2), (None, v3), ('b', v4), v5, v6, (None, v7)], user=lambda b, e, _ctx, _loc, _all: (
If(_loc, e, b)
), normal_vars=[], list_vars=['b', 'e']))
), ('stat', ('for', 'NAME', '=', 'exp', ',', 'exp', 'stat__3', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10: [(None, v1), ('n', v2), (None, v3), ('e1', v4), (None, v5), ('e2', v6), v7, (None, v8), ('b', v9), (None, v10)], user=lambda e3, e2, _all, b, _loc, _ctx, n, e1: (
NumericFor(_loc, n, e1, e2, e3, b)
), normal_vars=['b', 'e1', 'e2', 'e3', 'n'], list_vars=[]))
), ('stat', ('for', 'namelist', 'in', 'explist', 'do', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5, v6, v7: [(None, v1), ('ns', v2), (None, v3), ('e', v4), (None, v5), ('b', v6), (None, v7)], user=lambda ns, _all, b, e, _ctx, _loc: (
GenericFor(_loc, ns, e, b)
), normal_vars=['b', 'e', 'ns'], list_vars=[]))
), ('stat', ('function', 'funcname', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), ('b', v3)], user=lambda b, _ctx, n, _loc, _all: (
Function(_loc, n, b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), ('stat', ('local', 'function', 'NAME', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [(None, v1), (None, v2), ('n', v3), ('b', v4)], user=lambda b, _ctx, n, _loc, _all: (
LocalFunction(_loc, FuncName([n.value], None), b[0], b[1])
), normal_vars=['b', 'n'], list_vars=[]))
), ('stat', ('local', 'namelist', 'stat__4'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), ('ns', v2), v3], user=lambda _ctx, ns, _loc, _all, es: (
Local(_loc, ns, es)
), normal_vars=['es', 'ns'], list_vars=[]))
), ('stat', ('EMBEDSTAT',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda e, _ctx, _loc, _all: (
EmbedStatement(e.location, e.value)
), normal_vars=['e'], list_vars=[]))
), ('block', ('block__1', 'block__2'), 
(combine_action(root=lambda ctx, v1, v2: [v1, v2], user=lambda ss, _ctx, _loc, _all: (
Block(flatten(ss))
), normal_vars=[], list_vars=['ss']))
), ('field', ('[', 'exp', ']', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), ('k', v2), (None, v3), (None, v4), ('v', v5)], user=lambda _ctx, v, _loc, _all, k: (
Field(_loc, k, v)
), normal_vars=['k', 'v'], list_vars=[]))
), ('field', ('NAME', '=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('n', v1), (None, v2), ('v', v3)], user=lambda _ctx, n, v, _loc, _all: (
Field(_loc, String(_loc, n.value), v)
), normal_vars=['n', 'v'], list_vars=[]))
), ('field', ('exp',), 
(combine_action(root=lambda ctx, v1: [('v', v1)], user=lambda _ctx, v, _loc, _all: (
Field(v.location, None, v)
), normal_vars=['v'], list_vars=[]))
), ('functiondef', ('function', 'funcbody'), 
(combine_action(root=lambda ctx, v1, v2: [(None, v1), ('b', v2)], user=lambda b, _ctx, _loc, _all: (
Function(_loc, None, b[0], b[1])
), normal_vars=['b'], list_vars=[]))
), ('funcbody', ('(', 'funcbody__1', ')', 'block', 'end'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4, v5: [(None, v1), v2, (None, v3), ('b', v4), (None, v5)], user=lambda b, _ctx, _loc, _all, a: (
(flatten(a), b)
), normal_vars=['a', 'b'], list_vars=[]))
), ('block__1', ('stat', 'block__1'), 
(lambda ctx, v1, v2: [('ss', v1), v2])
), ('block__1', (), 
(lambda ctx: [])
), ('tableconstructor__2', ('fieldsep', 'tableconstructor__1'), 
(lambda ctx, v1, v2: [(None, v1), v2])
), ('tableconstructor__2', (), 
(lambda ctx: [])
), ('fieldsep', (',',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
None
), normal_vars=[], list_vars=[]))
), ('fieldsep', (';',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
None
), normal_vars=[], list_vars=[]))
), ('chunk', ('block',), 
(combine_action(root=lambda ctx, v1: [('a', v1)], user=lambda _ctx, _loc, _all, a: (
a
), normal_vars=['a'], list_vars=[]))
), ('tableconstructor__1', ('field', 'tableconstructor__2'), 
(lambda ctx, v1, v2: [('f', v1), v2])
), ('tableconstructor__1', (), 
(lambda ctx: [])
), ('explist', ('exp', 'explist__1'), 
(combine_action(root=lambda ctx, v1, v2: [('e', v1), v2], user=lambda e, _ctx, _loc, _all: (
e
), normal_vars=[], list_vars=['e']))
), ('varlist__1', (',', 'var', 'varlist__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('v', v2), v3])
), ('varlist__1', (), 
(lambda ctx: [])
), ('retstat', ('return', 'retstat__1', 'retstat__2'), 
(combine_action(root=lambda ctx, v1, v2, v3: [(None, v1), v2, v3], user=lambda e, _ctx, _loc, _all: (
Return(_loc, e)
), normal_vars=['e'], list_vars=[]))
), ('exp', ('nil',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
LuaNil(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('false',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
LuaFalse(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('true',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
LuaTrue(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('NUMBER',), 
(combine_action(root=lambda ctx, v1: [('n', v1)], user=lambda _ctx, n, _loc, _all: (
Number(_loc, n.value)
), normal_vars=['n'], list_vars=[]))
), ('exp', ('STRING',), 
(combine_action(root=lambda ctx, v1: [('s', v1)], user=lambda _ctx, s, _loc, _all: (
String(_loc, s.value)
), normal_vars=['s'], list_vars=[]))
), ('exp', ('EMBEDEXPR',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda e, _ctx, _loc, _all: (
EmbedExpression(_loc, e.value)
), normal_vars=['e'], list_vars=[]))
), ('exp', ('...',), 
(combine_action(root=lambda ctx, v1: [(None, v1)], user=lambda _ctx, _loc, _all: (
LuaEllipsis(_loc)
), normal_vars=[], list_vars=[]))
), ('exp', ('functiondef',), 
(combine_action(root=lambda ctx, v1: [('f', v1)], user=lambda f, _ctx, _loc, _all: (
f
), normal_vars=['f'], list_vars=[]))
), ('exp', ('prefixexp',), 
(combine_action(root=lambda ctx, v1: [('e', v1)], user=lambda e, _ctx, _loc, _all: (
e
), normal_vars=['e'], list_vars=[]))
), ('exp', ('tableconstructor',), 
(combine_action(root=lambda ctx, v1: [('t', v1)], user=lambda _ctx, t, _loc, _all: (
t
), normal_vars=['t'], list_vars=[]))
), ('exp', ('exp', 'or', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', 'and', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '<', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '>', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '<=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '>=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '~=', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '==', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '..', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '+', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '-', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '*', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '/', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '%', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('exp', '^', 'exp'), 
(combine_action(root=lambda ctx, v1, v2, v3: [('l', v1), ('op', v2), ('r', v3)], user=lambda l, op, _all, _ctx, _loc, r: (
BinOp(op.location, l, op.type, r)
), normal_vars=['l', 'op', 'r'], list_vars=[]))
), ('exp', ('not', 'exp'), 
(combine_action(root=lambda ctx, v1, v2: [('op', v1), ('e', v2)], user=lambda e, _ctx, op, _loc, _all: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), ('exp', ('#', 'exp'), 
(combine_action(root=lambda ctx, v1, v2: [('op', v1), ('e', v2)], user=lambda e, _ctx, op, _loc, _all: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), ('exp', ('-', 'exp'), 
(combine_action(root=lambda ctx, v1, v2: [('op', v1), ('e', v2)], user=lambda e, _ctx, op, _loc, _all: (
UnaryOp(op.location, op.type, e)
), normal_vars=['e', 'op'], list_vars=[]))
), ('block__2', ('retstat',), 
(lambda ctx, v1: [('ss', v1)])
), ('block__2', (), 
(lambda ctx: [])
), ('funcname__1', ('.', 'NAME', 'funcname__1'), 
(lambda ctx, v1, v2, v3: [(None, v1), ('n', v2), v3])
), ('funcname__1', (), 
(lambda ctx: [])
), ('functioncall', ('prefixexp', 'args'), 
(combine_action(root=lambda ctx, v1, v2: [('p', v1), ('a', v2)], user=lambda p, _ctx, _loc, _all, a: (
FunctionCall(a[0], p, None, a[1])
), normal_vars=['a', 'p'], list_vars=[]))
), ('functioncall', ('prefixexp', ':', 'NAME', 'args'), 
(combine_action(root=lambda ctx, v1, v2, v3, v4: [('p', v1), ('d', v2), ('n', v3), ('a', v4)], user=lambda _all, p, n, d, _ctx, _loc, a: (
FunctionCall(d.location, p, n.value, a[1])
), normal_vars=['a', 'd', 'n', 'p'], list_vars=[]))
)]
TABLE = [{'::': (True, 1), 'varlist': (True, 2), 'return': (False, 63), 'function': (True, 4), 'if': (True, 5), 'NAME': (True, 6), 'prefixexp': (True, 7), 'for': (True, 8), 'goto': (True, 9), 'local': (True, 22), 'label': (True, 10), 'EOF': (False, 63), 'while': (True, 11), 'EMBEDSTAT': (True, 12), 'var': (True, 13), '(': (True, 14), 'stat': (True, 15), 'block': (True, 16), 'do': (True, 17), 'break': (True, 18), 'chunk': (True, 19), ';': (True, 20), 'block__1': (True, 21), 'repeat': (True, 3), 'functioncall': (True, 23)}, {'NAME': (True, 552)}, {'=': (True, 553)}, {'::': (True, 24), 'varlist': (True, 25), 'repeat': (True, 26), 'function': (True, 27), 'if': (True, 28), 'NAME': (True, 6), 'prefixexp': (True, 29), 'return': (False, 63), 'for': (True, 30), 'goto': (True, 31), 'label': (True, 32), 'while': (True, 33), 'EMBEDSTAT': (True, 34), 'var': (True, 13), '(': (True, 14), 'stat': (True, 35), 'block': (True, 36), 'do': (True, 37), 'break': (True, 38), 'until': (False, 63), ';': (True, 39), 'block__1': (True, 40), 'local': (True, 41), 'functioncall': (True, 42)}, {'NAME': (True, 44), 'funcname': (True, 45)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 65), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'(': (False, 37), '[': (False, 37), ':': (False, 37), ',': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '=': (False, 37)}, {'(': (True, 576), 'STRING': (True, 577), 'tableconstructor': (True, 578), '.': (True, 156), '{': (True, 579), 'args': (True, 580), '[': (True, 158), ':': (True, 581)}, {'namelist': (True, 603), 'NAME': (True, 604)}, {'NAME': (True, 608)}, {'::': (False, 43), 'return': (False, 43), 'function': (False, 43), 'if': (False, 43), 'repeat': (False, 43), 'NAME': (False, 43), 'for': (False, 43), 'goto': (False, 43), 'while': (False, 43), 'EOF': (False, 43), '(': (False, 43), 'EMBEDSTAT': (False, 43), 'do': (False, 43), 'break': (False, 43), ';': (False, 43), 'local': (False, 43)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 609), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'::': (False, 55), 'NAME': (False, 55), 'function': (False, 55), 'if': (False, 55), 'return': (False, 55), 'for': (False, 55), 'goto': (False, 55), 'local': (False, 55), 'while': (False, 55), 'EMBEDSTAT': (False, 55), '(': (False, 55), 'EOF': (False, 55), 'do': (False, 55), 'break': (False, 55), ';': (False, 55), 'repeat': (False, 55)}, {'[': (False, 18), '{': (False, 18), '(': (False, 18), ':': (False, 18), ',': (True, 611), 'STRING': (False, 18), '.': (False, 18), 'varlist__1': (True, 612), '=': (False, 73)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 621), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'::': (True, 1), 'varlist': (True, 2), 'return': (False, 63), 'function': (True, 4), 'if': (True, 5), 'NAME': (True, 6), 'prefixexp': (True, 7), 'for': (True, 8), 'goto': (True, 9), 'local': (True, 22), 'label': (True, 10), 'while': (True, 11), 'EOF': (False, 63), 'var': (True, 13), '(': (True, 14), 'stat': (True, 15), 'EMBEDSTAT': (True, 12), 'do': (True, 17), 'break': (True, 18), ';': (True, 20), 'block__1': (True, 622), 'repeat': (True, 3), 'functioncall': (True, 23)}, {'EOF': (False, 68)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 625), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (False, 44), 'NAME': (False, 44), 'goto': (False, 44), 'if': (False, 44), 'return': (False, 44), 'for': (False, 44), 'function': (False, 44), 'local': (False, 44), 'while': (False, 44), 'EOF': (False, 44), '(': (False, 44), 'EMBEDSTAT': (False, 44), 'do': (False, 44), 'break': (False, 44), ';': (False, 44), 'repeat': (False, 44)}, {'EOF': (False, None)}, {'if': (False, 40), 'NAME': (False, 40), 'function': (False, 40), '::': (False, 40), 'repeat': (False, 40), 'return': (False, 40), 'for': (False, 40), 'goto': (False, 40), 'while': (False, 40), 'EMBEDSTAT': (False, 40), '(': (False, 40), 'EOF': (False, 40), 'do': (False, 40), 'break': (False, 40), ';': (False, 40), 'local': (False, 40)}, {'retstat': (True, 635), 'block__2': (True, 636), 'return': (True, 637), 'EOF': (False, 104)}, {'namelist': (True, 638), 'NAME': (True, 639), 'function': (True, 640)}, {'if': (False, 42), '[': (False, 19), 'return': (False, 42), 'function': (False, 42), '::': (False, 42), 'NAME': (False, 42), 'for': (False, 42), 'goto': (False, 42), 'local': (False, 42), 'while': (False, 42), 'EOF': (False, 42), '(': (False, 19), 'EMBEDSTAT': (False, 42), 'do': (False, 42), 'break': (False, 42), ':': (False, 19), ';': (False, 42), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), 'repeat': (False, 42)}, {'NAME': (True, 423)}, {'=': (True, 424)}, {'::': (True, 24), 'varlist': (True, 25), 'repeat': (True, 26), 'function': (True, 27), 'if': (True, 28), 'NAME': (True, 6), 'prefixexp': (True, 29), 'return': (False, 63), 'for': (True, 30), 'goto': (True, 31), 'label': (True, 32), 'while': (True, 33), 'EMBEDSTAT': (True, 34), 'var': (True, 13), '(': (True, 14), 'stat': (True, 35), 'block': (True, 425), 'do': (True, 37), 'break': (True, 38), 'until': (False, 63), ';': (True, 39), 'block__1': (True, 40), 'local': (True, 41), 'functioncall': (True, 42)}, {'NAME': (True, 44), 'funcname': (True, 426)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 427), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'(': (True, 428), 'STRING': (True, 429), 'tableconstructor': (True, 430), '.': (True, 156), '{': (True, 431), 'args': (True, 432), '[': (True, 158), ':': (True, 433)}, {'namelist': (True, 48), 'NAME': (True, 49)}, {'NAME': (True, 43)}, {'::': (False, 43), 'return': (False, 43), 'function': (False, 43), 'if': (False, 43), 'repeat': (False, 43), 'NAME': (False, 43), 'for': (False, 43), 'goto': (False, 43), 'until': (False, 43), '(': (False, 43), 'EMBEDSTAT': (False, 43), 'do': (False, 43), 'break': (False, 43), 'while': (False, 43), ';': (False, 43), 'local': (False, 43)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 85), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'::': (False, 55), 'NAME': (False, 55), 'function': (False, 55), 'if': (False, 55), 'repeat': (False, 55), 'return': (False, 55), 'for': (False, 55), 'goto': (False, 55), 'while': (False, 55), '(': (False, 55), 'EMBEDSTAT': (False, 55), 'do': (False, 55), 'break': (False, 55), 'until': (False, 55), ';': (False, 55), 'local': (False, 55)}, {'::': (True, 24), 'varlist': (True, 25), 'return': (False, 63), 'function': (True, 27), 'if': (True, 28), 'NAME': (True, 6), 'prefixexp': (True, 29), 'for': (True, 30), 'goto': (True, 31), 'local': (True, 41), 'label': (True, 32), 'while': (True, 33), 'var': (True, 13), '(': (True, 14), 'stat': (True, 35), 'EMBEDSTAT': (True, 34), 'do': (True, 37), 'break': (True, 38), 'until': (False, 63), ';': (True, 39), 'block__1': (True, 90), 'repeat': (True, 26), 'functioncall': (True, 42)}, {'until': (True, 91)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 104), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (False, 44), 'NAME': (False, 44), 'goto': (False, 44), 'if': (False, 44), 'repeat': (False, 44), 'return': (False, 44), 'for': (False, 44), 'function': (False, 44), 'until': (False, 44), '(': (False, 44), 'EMBEDSTAT': (False, 44), 'do': (False, 44), 'break': (False, 44), 'while': (False, 44), ';': (False, 44), 'local': (False, 44)}, {'if': (False, 40), 'return': (False, 40), 'function': (False, 40), '::': (False, 40), 'repeat': (False, 40), 'NAME': (False, 40), 'for': (False, 40), 'goto': (False, 40), 'while': (False, 40), '(': (False, 40), 'EMBEDSTAT': (False, 40), 'do': (False, 40), 'break': (False, 40), 'until': (False, 40), ';': (False, 40), 'local': (False, 40)}, {'retstat': (True, 111), 'block__2': (True, 112), 'return': (True, 113), 'until': (False, 104)}, {'namelist': (True, 114), 'NAME': (True, 115), 'function': (True, 116)}, {'if': (False, 42), '[': (False, 19), 'return': (False, 42), 'function': (False, 42), '::': (False, 42), 'NAME': (False, 42), 'for': (False, 42), 'goto': (False, 42), 'local': (False, 42), 'while': (False, 42), '(': (False, 19), 'EMBEDSTAT': (False, 42), 'do': (False, 42), 'break': (False, 42), ':': (False, 19), 'until': (False, 42), ';': (False, 42), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), 'repeat': (False, 42)}, {'::': (False, 45), 'NAME': (False, 45), 'function': (False, 45), 'if': (False, 45), 'repeat': (False, 45), 'return': (False, 45), 'for': (False, 45), 'goto': (False, 45), 'while': (False, 45), '(': (False, 45), 'EMBEDSTAT': (False, 45), 'do': (False, 45), 'break': (False, 45), 'until': (False, 45), ';': (False, 45), 'local': (False, 45)}, {'(': (False, 106), ':': (False, 106), 'funcname__1': (True, 46), '.': (True, 47)}, {'funcbody': (True, 162), '(': (True, 163)}, {'(': (False, 22), 'funcname__2': (True, 208), ':': (True, 209)}, {'NAME': (True, 212)}, {'in': (True, 508)}, {',': (True, 509), '=': (True, 510), 'in': (False, 26), 'namelist__1': (True, 511)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), 'then': (False, 18), '<=': (False, 18), '<': (False, 18), '(': (False, 18), '^': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 554), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), 'then': (False, 84), '<=': (False, 84), '<': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), '>=': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'funcbody': (True, 605), '(': (True, 606)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), 'then': (False, 82), '<=': (False, 82), '<': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), 'then': (False, 80), '<=': (False, 80), '<': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '>=': (False, 37), '+': (False, 37), 'then': (False, 37), '<=': (False, 37), '<': (False, 37), '(': (False, 37), '^': (False, 37), '..': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '%': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '~=': (False, 37)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 610), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'[': (True, 614), 'tableconstructor': (True, 616), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 619), '+': (False, 83), 'then': (False, 83), '<=': (False, 83), '<': (False, 83), '(': (True, 613), '^': (False, 83), '..': (False, 83), ':': (True, 620), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 615), '==': (False, 83), '.': (True, 617), '{': (True, 618), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 81), 'and': (False, 81), '>=': (False, 81), '+': (False, 81), 'then': (False, 81), '<=': (False, 81), '<': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), '%': (False, 81), '==': (False, 81), '..': (False, 81), '-': (False, 81), '/': (False, 81), '~=': (False, 81)}, {'or': (False, 77), 'and': (False, 77), '>=': (False, 77), '+': (False, 77), 'then': (False, 77), '<=': (False, 77), '<': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), '%': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {'or': (False, 79), 'and': (False, 79), '>=': (False, 79), '+': (False, 79), 'then': (False, 79), '<=': (False, 79), '<': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), '%': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 626), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 629), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 631), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'*': (True, 450), '/': (True, 457), 'and': (True, 446), '^': (True, 445), '%': (True, 447), '+': (True, 448), '>': (True, 459), '<=': (True, 444), '>=': (True, 451), '<': (True, 452), '~=': (True, 453), '-': (True, 454), '==': (True, 456), 'then': (True, 633), '..': (True, 458), 'or': (True, 455)}, {'or': (False, 78), 'and': (False, 78), '>=': (False, 78), '+': (False, 78), 'then': (False, 78), '<=': (False, 78), '<': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), '%': (False, 78), '==': (False, 78), '..': (False, 78), '-': (False, 78), '/': (False, 78), '~=': (False, 78)}, {'or': (False, 75), 'and': (False, 75), '>=': (False, 75), '+': (False, 75), 'then': (False, 75), '<=': (False, 75), '<': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), '%': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), 'then': (False, 76), '<=': (False, 76), '<': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), 'then': (False, 19), '<=': (False, 19), '<': (False, 19), '(': (False, 19), '^': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), '<=': (False, 18), '~=': (False, 18), '<': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 198), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), '^': (False, 84), 'do': (False, 84), '>': (False, 84), '*': (False, 84), '>=': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'funcbody': (True, 204), '(': (True, 205)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '>=': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '%': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 217), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'[': (True, 220), 'tableconstructor': (True, 222), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 225), '+': (False, 83), '<=': (False, 83), '<': (False, 83), '..': (False, 83), '(': (True, 219), '^': (False, 83), 'do': (False, 83), ':': (True, 226), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 221), '==': (False, 83), '.': (True, 223), '{': (True, 224), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 81), 'and': (False, 81), '>=': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), '*': (False, 81), '%': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 77), 'and': (False, 77), '>=': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), '*': (False, 77), '%': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {'or': (False, 79), 'and': (False, 79), '>=': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), '*': (False, 79), '%': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 243), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 256), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 257), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'*': (True, 265), 'and': (True, 260), '^': (True, 259), '%': (True, 261), 'do': (True, 262), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '<': (True, 267), '~=': (True, 272), '-': (True, 269), '==': (True, 270), '/': (True, 271), '..': (True, 268), 'or': (True, 273)}, {'or': (False, 78), 'and': (False, 78), '>=': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), '*': (False, 78), '%': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'or': (False, 75), 'and': (False, 75), '>=': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), '*': (False, 75), '%': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), '^': (False, 76), 'do': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), '<=': (False, 19), '~=': (False, 19), '<': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '..': (False, 19)}, {'return': (False, 62), 'until': (False, 62)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 133), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'NAME': (True, 138)}, {'=': (True, 147)}, {'::': (True, 24), 'varlist': (True, 25), 'repeat': (True, 26), 'function': (True, 27), 'if': (True, 28), 'NAME': (True, 6), 'prefixexp': (True, 29), 'return': (False, 63), 'for': (True, 30), 'goto': (True, 31), 'label': (True, 32), 'while': (True, 33), 'EMBEDSTAT': (True, 34), 'var': (True, 13), '(': (True, 14), 'stat': (True, 35), 'block': (True, 148), 'do': (True, 37), 'break': (True, 38), 'until': (False, 63), ';': (True, 39), 'block__1': (True, 40), 'local': (True, 41), 'functioncall': (True, 42)}, {'NAME': (True, 44), 'funcname': (True, 149)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 150), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'(': (True, 153), 'STRING': (True, 154), 'tableconstructor': (True, 155), '.': (True, 156), '{': (True, 157), 'args': (True, 159), '[': (True, 158), ':': (True, 160)}, {'namelist': (True, 164), 'NAME': (True, 165)}, {'NAME': (True, 167)}, {'::': (False, 43), 'return': (False, 43), 'function': (False, 43), 'if': (False, 43), 'repeat': (False, 43), 'NAME': (False, 43), 'for': (False, 43), 'goto': (False, 43), 'while': (False, 43), '(': (False, 43), 'EMBEDSTAT': (False, 43), ';': (False, 43), 'do': (False, 43), 'break': (False, 43), 'end': (False, 43), 'local': (False, 43)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 203), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'::': (False, 55), 'NAME': (False, 55), 'function': (False, 55), 'if': (False, 55), 'repeat': (False, 55), 'return': (False, 55), 'for': (False, 55), 'goto': (False, 55), 'while': (False, 55), '(': (False, 55), 'EMBEDSTAT': (False, 55), 'end': (False, 55), 'do': (False, 55), 'break': (False, 55), ';': (False, 55), 'local': (False, 55)}, {'::': (True, 92), 'varlist': (True, 93), 'return': (False, 63), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'for': (True, 98), 'goto': (True, 99), 'local': (True, 109), 'label': (True, 100), 'while': (True, 101), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'EMBEDSTAT': (True, 102), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 213), 'repeat': (True, 94), 'functioncall': (True, 110)}, {'end': (True, 215)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 218), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (False, 44), 'NAME': (False, 44), 'function': (False, 44), 'if': (False, 44), 'repeat': (False, 44), 'return': (False, 44), 'for': (False, 44), 'goto': (False, 44), 'while': (False, 44), '(': (False, 44), 'EMBEDSTAT': (False, 44), 'end': (False, 44), 'do': (False, 44), 'break': (False, 44), ';': (False, 44), 'local': (False, 44)}, {'if': (False, 40), 'return': (False, 40), 'function': (False, 40), '::': (False, 40), 'repeat': (False, 40), 'NAME': (False, 40), 'for': (False, 40), 'goto': (False, 40), 'while': (False, 40), '(': (False, 40), 'EMBEDSTAT': (False, 40), 'end': (False, 40), 'do': (False, 40), 'break': (False, 40), ';': (False, 40), 'local': (False, 40)}, {'retstat': (True, 227), 'block__2': (True, 228), 'return': (True, 229), 'end': (False, 104)}, {'namelist': (True, 230), 'NAME': (True, 231), 'function': (True, 232)}, {'if': (False, 42), '[': (False, 19), 'return': (False, 42), 'function': (False, 42), '::': (False, 42), 'NAME': (False, 42), 'for': (False, 42), 'goto': (False, 42), 'local': (False, 42), 'while': (False, 42), '(': (False, 19), 'EMBEDSTAT': (False, 42), 'end': (False, 42), 'do': (False, 42), 'break': (False, 42), ':': (False, 19), ';': (False, 42), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), 'repeat': (False, 42)}, {'until': (False, 103)}, {'until': (False, 56)}, {'tableconstructor': (True, 276), 'NAME': (True, 277), 'retstat__1': (True, 278), 'prefixexp': (True, 279), 'true': (True, 280), 'function': (True, 281), 'not': (True, 282), 'until': (False, 17), 'false': (True, 283), 'var': (True, 284), '(': (True, 285), 'functiondef': (True, 286), 'EMBEDEXPR': (True, 287), 'NUMBER': (True, 288), '#': (True, 289), '...': (True, 290), ';': (False, 17), 'STRING': (True, 291), 'explist': (True, 292), '{': (True, 293), '-': (True, 294), 'exp': (True, 295), 'nil': (True, 296), 'functioncall': (True, 297)}, {'::': (False, 8), 'return': (False, 8), 'function': (False, 8), 'stat__4': (True, 207), 'if': (False, 8), 'repeat': (False, 8), 'NAME': (False, 8), 'for': (False, 8), 'goto': (False, 8), '=': (True, 206), 'until': (False, 8), '(': (False, 8), 'EMBEDSTAT': (False, 8), 'do': (False, 8), 'break': (False, 8), 'while': (False, 8), ';': (False, 8), 'local': (False, 8)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 210), 'namelist__1': (True, 211), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), '(': (False, 26), 'EMBEDSTAT': (False, 26), 'do': (False, 26), 'break': (False, 26), 'until': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {'NAME': (True, 214)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'goto': (False, 18), 'break': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), 'function': (False, 18), 'while': (False, 18), '(': (False, 18), 'EOF': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 318), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), 'break': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), 'goto': (False, 37), 'while': (False, 37), '(': (False, 37), 'EOF': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), ';': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'::': (False, 84), 'return': (False, 84), 'function': (False, 84), 'and': (False, 84), 'if': (False, 84), '%': (False, 84), 'repeat': (False, 84), 'NAME': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), 'for': (False, 84), 'goto': (False, 84), '>=': (False, 84), 'while': (False, 84), 'or': (False, 84), '(': (False, 84), 'EOF': (False, 84), '^': (False, 84), 'do': (False, 84), 'break': (False, 84), 'EMBEDSTAT': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '..': (False, 84), '-': (False, 84), '/': (False, 84), 'local': (False, 84), '~=': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 349), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'::': (False, 82), 'return': (False, 82), 'or': (False, 82), 'and': (False, 82), 'if': (False, 82), '%': (False, 82), 'NAME': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'for': (False, 82), 'goto': (False, 82), 'local': (False, 82), 'while': (False, 82), 'EOF': (False, 82), '(': (False, 82), 'EMBEDSTAT': (False, 82), '^': (False, 82), ';': (False, 82), 'do': (False, 82), 'break': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), 'function': (False, 82), '/': (False, 82), 'repeat': (False, 82), '~=': (False, 82)}, {'::': (False, 80), 'NAME': (False, 80), 'or': (False, 80), 'and': (False, 80), 'if': (False, 80), '%': (False, 80), 'repeat': (False, 80), 'return': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'for': (False, 80), 'goto': (False, 80), 'while': (False, 80), 'EMBEDSTAT': (False, 80), '(': (False, 80), 'EOF': (False, 80), '^': (False, 80), ';': (False, 80), 'do': (False, 80), 'break': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), 'function': (False, 80), '/': (False, 80), 'local': (False, 80), '..': (False, 80)}, {'::': (False, 78), 'return': (False, 78), 'or': (False, 78), 'and': (False, 78), 'if': (False, 78), '%': (False, 78), 'NAME': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'for': (False, 78), 'function': (False, 78), 'local': (False, 78), 'while': (False, 78), 'EMBEDSTAT': (False, 78), '(': (False, 78), 'EOF': (False, 78), '^': (False, 78), ';': (False, 78), 'goto': (False, 78), 'do': (False, 78), 'break': (False, 78), '>': (False, 78), '*': (False, 78), '>=': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '..': (False, 78)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 137), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'if': (False, 83), '[': (True, 140), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), 'goto': (False, 83), 'break': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 141), '.': (True, 143), '{': (True, 144), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 142), 'and': (False, 83), 'args': (True, 145), '+': (False, 83), '<=': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '(': (True, 139), 'EOF': (False, 83), '^': (False, 83), 'do': (False, 83), ':': (True, 146), '>': (False, 83), ';': (False, 83), '==': (False, 83), '..': (False, 83), '~=': (False, 83)}, {'::': (False, 81), 'return': (False, 81), 'goto': (False, 81), 'and': (False, 81), 'if': (False, 81), '%': (False, 81), 'NAME': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), 'for': (False, 81), 'function': (False, 81), 'local': (False, 81), 'while': (False, 81), 'or': (False, 81), '(': (False, 81), 'EOF': (False, 81), '^': (False, 81), ';': (False, 81), 'do': (False, 81), 'break': (False, 81), 'EMBEDSTAT': (False, 81), '>': (False, 81), '*': (False, 81), '>=': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), 'repeat': (False, 81), '..': (False, 81)}, {'::': (False, 77), 'NAME': (False, 77), 'goto': (False, 77), 'and': (False, 77), 'if': (False, 77), '%': (False, 77), 'repeat': (False, 77), 'return': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'for': (False, 77), 'function': (False, 77), 'while': (False, 77), 'EOF': (False, 77), '(': (False, 77), 'EMBEDSTAT': (False, 77), '^': (False, 77), ';': (False, 77), 'do': (False, 77), 'break': (False, 77), '>': (False, 77), '*': (False, 77), '>=': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), 'or': (False, 77), '/': (False, 77), 'local': (False, 77), '..': (False, 77)}, {'::': (False, 79), 'NAME': (False, 79), 'goto': (False, 79), 'and': (False, 79), 'if': (False, 79), '%': (False, 79), 'return': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'for': (False, 79), 'function': (False, 79), 'local': (False, 79), 'while': (False, 79), 'EOF': (False, 79), '(': (False, 79), 'EMBEDSTAT': (False, 79), '^': (False, 79), ';': (False, 79), 'do': (False, 79), 'break': (False, 79), '>': (False, 79), '*': (False, 79), '>=': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), 'or': (False, 79), '/': (False, 79), 'repeat': (False, 79), '~=': (False, 79)}, {'funcbody': (True, 151), '(': (True, 152)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 161), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 166), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'if': (False, 48), 'NAME': (False, 48), 'or': (True, 169), 'and': (True, 170), '::': (False, 48), '%': (True, 175), 'return': (False, 48), '+': (True, 172), '<=': (True, 168), '<': (True, 180), 'for': (False, 48), 'goto': (False, 48), 'local': (False, 48), 'while': (False, 48), 'EMBEDSTAT': (False, 48), '(': (False, 48), 'EOF': (False, 48), '^': (True, 179), ';': (False, 48), 'do': (False, 48), 'break': (False, 48), '>': (True, 173), '*': (True, 174), '>=': (True, 171), '==': (True, 176), '..': (True, 177), '-': (True, 178), 'function': (False, 48), '/': (True, 181), 'repeat': (False, 48), '~=': (True, 182)}, {'::': (False, 75), 'return': (False, 75), 'goto': (False, 75), 'and': (False, 75), 'if': (False, 75), '%': (False, 75), 'NAME': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), 'for': (False, 75), 'function': (False, 75), 'local': (False, 75), '>=': (False, 75), 'while': (False, 75), 'or': (False, 75), '(': (False, 75), 'EOF': (False, 75), '^': (False, 75), 'do': (False, 75), 'break': (False, 75), 'EMBEDSTAT': (False, 75), '>': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), 'repeat': (False, 75), '~=': (False, 75)}, {'::': (False, 76), 'return': (False, 76), 'or': (False, 76), 'and': (False, 76), 'if': (False, 76), '%': (False, 76), 'NAME': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), 'for': (False, 76), 'function': (False, 76), 'local': (False, 76), 'while': (False, 76), 'EOF': (False, 76), '(': (False, 76), 'EMBEDSTAT': (False, 76), '^': (False, 76), ';': (False, 76), 'goto': (False, 76), 'do': (False, 76), 'break': (False, 76), '>': (False, 76), '*': (False, 76), '>=': (False, 76), '==': (False, 76), '..': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'break': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), '<=': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '(': (False, 19), 'EOF': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'if': (False, 101), 'NAME': (False, 101), 'or': (False, 101), 'and': (False, 101), '::': (False, 101), '>=': (False, 101), 'repeat': (False, 101), 'return': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'for': (False, 101), 'function': (False, 101), 'while': (False, 101), 'EOF': (False, 101), '(': (False, 101), 'EMBEDSTAT': (False, 101), '^': (True, 179), 'goto': (False, 101), 'do': (False, 101), 'break': (False, 101), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '~=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '..': (False, 101), '%': (False, 101)}, {'::': (True, 700)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 702), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 701), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'NAME': (False, 13), 'for': (False, 13), 'local': (False, 13), 'EMBEDSTAT': (False, 13), 'break': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'repeat': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'while': (False, 13), '(': (False, 13), 'EOF': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '~=': (False, 13), 'function': (False, 13), '..': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'break': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), '<=': (False, 12), '<': (False, 12), 'goto': (False, 12), 'while': (False, 12), '(': (False, 12), 'EOF': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 705)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 707), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '>=': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'goto': (False, 107), 'break': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), '(': (False, 107), 'EOF': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 708)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), 'explist': (True, 724), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 728), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'until': (True, 216)}, {'funcbody': (True, 921), '(': (True, 922)}, {'*': (True, 450), 'and': (True, 446), '^': (True, 445), '%': (True, 447), '+': (True, 448), 'then': (True, 449), '<=': (True, 444), '>=': (True, 451), '>': (True, 459), '<': (True, 452), '..': (True, 458), '-': (True, 454), '==': (True, 456), '/': (True, 457), '~=': (True, 453), 'or': (True, 455)}, {'if': (False, 60), 'return': (False, 60), 'or': (False, 60), 'and': (False, 60), '::': (False, 60), '%': (False, 60), 'NAME': (False, 60), '+': (False, 60), '<=': (False, 60), '-': (False, 60), '<': (False, 60), 'for': (False, 60), 'goto': (False, 60), 'while': (False, 60), 'EOF': (False, 60), '(': (False, 60), 'EMBEDSTAT': (False, 60), '^': (False, 60), ';': (False, 60), 'local': (False, 60), 'break': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '..': (False, 60), 'do': (False, 60), 'function': (False, 60), '/': (False, 60), 'repeat': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 488)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 491), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'if': (False, 13), '[': (False, 13), 'NAME': (False, 13), 'function': (False, 13), '::': (False, 13), 'repeat': (False, 13), 'return': (False, 13), 'for': (False, 13), 'goto': (False, 13), 'while': (False, 13), '(': (False, 13), 'EMBEDSTAT': (False, 13), 'end': (False, 13), 'do': (False, 13), 'break': (False, 13), ':': (False, 13), ';': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), 'local': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'NAME': (False, 12), 'function': (False, 12), '::': (False, 12), 'return': (False, 12), 'for': (False, 12), 'goto': (False, 12), 'local': (False, 12), 'while': (False, 12), '(': (False, 12), 'EMBEDSTAT': (False, 12), ';': (False, 12), 'do': (False, 12), 'break': (False, 12), ':': (False, 12), 'end': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), 'repeat': (False, 12)}, {'NAME': (True, 517)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 522), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 525), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'if': (False, 107), '[': (False, 107), 'NAME': (False, 107), 'function': (False, 107), '::': (False, 107), 'return': (False, 107), 'for': (False, 107), 'goto': (False, 107), 'local': (False, 107), 'while': (False, 107), '(': (False, 107), 'EMBEDSTAT': (False, 107), ';': (False, 107), 'do': (False, 107), 'break': (False, 107), ':': (False, 107), 'end': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), 'repeat': (False, 107)}, {'NAME': (True, 530)}, {'if': (False, 102), 'NAME': (False, 102), 'or': (False, 102), 'and': (False, 102), '::': (False, 102), '>=': (False, 102), 'repeat': (False, 102), 'return': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'for': (False, 102), 'function': (False, 102), 'while': (False, 102), 'EOF': (False, 102), '(': (False, 102), 'EMBEDSTAT': (False, 102), '^': (True, 179), ';': (False, 102), 'goto': (False, 102), 'do': (False, 102), 'break': (False, 102), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), 'local': (False, 102), '~=': (False, 102)}, {'if': (False, 52), 'return': (False, 52), 'goto': (False, 52), '::': (False, 52), 'repeat': (False, 52), 'NAME': (False, 52), 'for': (False, 52), 'function': (False, 52), 'while': (False, 52), 'EMBEDSTAT': (False, 52), '(': (False, 52), 'EOF': (False, 52), 'do': (False, 52), 'break': (False, 52), ';': (False, 52), 'local': (False, 52)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 623)}, {'in': (True, 628)}, {',': (True, 509), '=': (True, 627), 'in': (False, 26), 'namelist__1': (True, 511)}, {'if': (False, 100), 'return': (False, 100), 'goto': (False, 100), 'and': (False, 100), '::': (False, 100), '>=': (False, 100), 'NAME': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'for': (False, 100), 'function': (False, 100), 'local': (False, 100), 'while': (False, 100), 'EOF': (False, 100), '(': (False, 100), 'EMBEDSTAT': (False, 100), '^': (True, 179), 'do': (False, 100), 'break': (False, 100), '>': (False, 100), '*': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), 'or': (False, 100), '/': (False, 100), 'repeat': (False, 100), '..': (False, 100), '%': (False, 100)}, {'if': (False, 45), 'NAME': (False, 45), 'function': (False, 45), '::': (False, 45), 'repeat': (False, 45), 'return': (False, 45), 'for': (False, 45), 'goto': (False, 45), 'while': (False, 45), '(': (False, 45), 'EMBEDSTAT': (False, 45), 'end': (False, 45), 'do': (False, 45), 'break': (False, 45), ';': (False, 45), 'local': (False, 45)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 329), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 328), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 330), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 353), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 354), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 357), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 358), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 359), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 364), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 366), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 367), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 369), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 374), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 375), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'var': (True, 117), '(': (True, 118), 'NAME': (True, 119), 'tableconstructor': (True, 120), 'function': (True, 130), 'NUMBER': (True, 124), 'EMBEDEXPR': (True, 123), 'functiondef': (True, 122), '#': (True, 125), 'prefixexp': (True, 126), '...': (True, 127), 'true': (True, 128), 'STRING': (True, 129), '{': (True, 121), '-': (True, 131), 'not': (True, 132), 'exp': (True, 376), 'nil': (True, 134), 'false': (True, 135), 'functioncall': (True, 136)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), ')': (False, 18), '(': (False, 18), '^': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '..': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18), '.': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1061), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), ')': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), '>=': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'funcbody': (True, 1063), '(': (True, 1064)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), ')': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '~=': (False, 82), '-': (False, 82), '/': (False, 82), '..': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), ')': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '>=': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), ')': (False, 37), '(': (False, 37), '^': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '%': (False, 37), 'STRING': (False, 37), '==': (False, 37), '..': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '~=': (False, 37), '.': (False, 37)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 435), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'[': (True, 437), 'tableconstructor': (True, 439), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 442), '+': (False, 83), '<=': (False, 83), '<': (False, 83), ')': (False, 83), '(': (True, 436), '^': (False, 83), '..': (False, 83), ':': (True, 443), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 438), '==': (False, 83), '.': (True, 440), '{': (True, 441), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 81), 'and': (False, 81), '>=': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), ')': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), '%': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 77), 'and': (False, 77), '>=': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), ')': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), '%': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {'or': (False, 79), 'and': (False, 79), '>=': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), ')': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), '%': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 460), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 461), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 462), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 463), 'or': (True, 346)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), ')': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), '>=': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'or': (False, 75), 'and': (False, 75), '>=': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), ')': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), '%': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), ')': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), '<=': (False, 19), '<': (False, 19), ')': (False, 19), '(': (False, 19), '^': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '..': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19), '.': (False, 19)}, {'*': (True, 265), 'and': (True, 260), '^': (True, 259), '%': (True, 261), 'do': (True, 464), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '<': (True, 267), '~=': (True, 272), '-': (True, 269), '==': (True, 270), '/': (True, 271), '..': (True, 268), 'or': (True, 273)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), '<=': (False, 60), '<': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 465)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), 'explist': (True, 479), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 483), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'::': (False, 54), 'NAME': (False, 54), 'function': (False, 54), 'if': (False, 54), 'return': (False, 54), 'for': (False, 54), 'goto': (False, 54), 'local': (False, 54), 'while': (False, 54), '(': (False, 54), 'EMBEDSTAT': (False, 54), 'do': (False, 54), 'break': (False, 54), 'until': (False, 54), ';': (False, 54), 'repeat': (False, 54)}, {'(': (False, 36)}, {'NAME': (True, 487)}, {'NAME': (True, 490)}, {'::': (False, 3), 'NAME': (False, 3), 'function': (False, 3), 'if': (False, 3), 'return': (False, 3), 'for': (False, 3), 'goto': (False, 3), 'local': (False, 3), '=': (False, 3), 'until': (False, 3), '(': (False, 3), 'EMBEDSTAT': (False, 3), 'do': (False, 3), 'break': (False, 3), 'while': (False, 3), ';': (False, 3), 'repeat': (False, 3)}, {'(': (False, 106), ':': (False, 106), 'funcname__1': (True, 515), '.': (True, 47)}, {'end': (False, 62), 'return': (False, 62)}, {'funcbody': (True, 678), '(': (True, 679)}, {'::': (False, 46), 'NAME': (False, 46), 'function': (False, 46), 'if': (False, 46), 'repeat': (False, 46), 'return': (False, 46), 'for': (False, 46), 'goto': (False, 46), 'while': (False, 46), '(': (False, 46), 'EMBEDSTAT': (False, 46), 'do': (False, 46), 'break': (False, 46), 'until': (False, 46), ';': (False, 46), 'local': (False, 46)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 696), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), '^': (True, 259), 'do': (False, 101), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'end': (True, 703)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 706), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 704), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), '<=': (False, 13), '~=': (False, 13), '<': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '..': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), '<=': (False, 12), '~=': (False, 12), '<': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '..': (False, 12)}, {'NAME': (True, 709)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 710), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '>=': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), '..': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 732)}, {'end': (False, 103)}, {'end': (False, 56)}, {'tableconstructor': (True, 747), 'NAME': (True, 748), 'retstat__1': (True, 749), 'prefixexp': (True, 750), 'true': (True, 751), 'function': (True, 752), 'not': (True, 753), 'false': (True, 754), 'var': (True, 755), '(': (True, 756), ';': (False, 17), 'functiondef': (True, 757), 'EMBEDEXPR': (True, 758), 'NUMBER': (True, 759), '#': (True, 760), '...': (True, 761), 'end': (False, 17), 'STRING': (True, 762), 'explist': (True, 763), '{': (True, 764), '-': (True, 765), 'exp': (True, 766), 'nil': (True, 767), 'functioncall': (True, 768)}, {'::': (False, 8), 'return': (False, 8), 'function': (False, 8), 'stat__4': (True, 774), 'if': (False, 8), 'repeat': (False, 8), 'NAME': (False, 8), 'for': (False, 8), 'goto': (False, 8), '=': (True, 773), 'while': (False, 8), '(': (False, 8), 'EMBEDSTAT': (False, 8), 'end': (False, 8), 'do': (False, 8), 'break': (False, 8), ';': (False, 8), 'local': (False, 8)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 770), 'namelist__1': (True, 771), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), '(': (False, 26), 'EMBEDSTAT': (False, 26), 'end': (False, 26), 'do': (False, 26), 'break': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {'NAME': (True, 775)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 313), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), '>=': (False, 84), '<=': (False, 84), '^': (False, 84), '}': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '}': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), '=': (True, 319), ',': (False, 37), '(': (False, 37), '^': (False, 37), ';': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {'[': (True, 321), 'tableconstructor': (True, 323), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 326), '+': (False, 83), '}': (False, 83), ',': (False, 83), '<': (False, 83), '%': (False, 83), '<=': (False, 83), '(': (True, 320), '^': (False, 83), '..': (False, 83), ':': (True, 327), '>': (False, 83), '*': (False, 83), ';': (False, 83), 'STRING': (True, 322), '==': (False, 83), '.': (True, 324), '{': (True, 325), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), '>=': (False, 77), '<=': (False, 77), '^': (False, 77), '}': (False, 77), '>': (False, 77), '*': (False, 77), ';': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '/': (False, 77), '..': (False, 77)}, {'funcbody': (True, 351), '(': (True, 352)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 356), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), '%': (False, 76), ',': (False, 76), '^': (False, 76), '}': (False, 76), '>': (False, 76), '*': (False, 76), ';': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '%': (False, 18), '+': (False, 18), '}': (False, 18), ',': (False, 18), '<': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), ';': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '>=': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 365), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'}': (True, 368)}, {',': (True, 370), ';': (True, 371), 'fieldsep': (True, 372), '}': (False, 65), 'tableconstructor__2': (True, 373)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), '>=': (False, 78), ',': (False, 78), '^': (False, 78), '}': (False, 78), '>': (False, 78), '*': (False, 78), ';': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), '>=': (False, 80), ',': (False, 80), '^': (False, 80), '}': (False, 80), '>': (False, 80), '*': (False, 80), ';': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), '>=': (False, 82), '<=': (False, 82), '^': (False, 82), '}': (False, 82), '>': (False, 82), '*': (False, 82), ';': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 377), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), '>=': (False, 81), ',': (False, 81), '^': (False, 81), '}': (False, 81), '>': (False, 81), '*': (False, 81), ';': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), '>=': (False, 79), '<=': (False, 79), '^': (False, 79), '}': (False, 79), '>': (False, 79), '*': (False, 79), ';': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 381), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 492), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'*': (True, 499), ';': (False, 59), '^': (True, 495), 'and': (True, 494), ',': (False, 59), '%': (True, 496), '+': (True, 497), '}': (False, 59), '>': (True, 498), '<=': (True, 493), '>=': (True, 500), '<': (True, 501), '..': (True, 506), '-': (True, 503), '==': (True, 504), '/': (True, 505), '~=': (True, 502), 'or': (True, 507)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), '>=': (False, 75), '<=': (False, 75), '^': (False, 75), '}': (False, 75), '>': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), '~=': (False, 75)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), '}': (False, 19), ',': (False, 19), '<': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), ';': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), '^': (True, 259), 'do': (False, 102), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), '^': (True, 259), 'do': (False, 100), '>': (False, 100), '*': (False, 100), '%': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 274), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 489), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 275), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 513), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 516), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 519), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 524), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 527), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 529), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 532), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 534), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 543), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 544), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 545), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 546), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 548), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 261), '+': (True, 263), '<=': (False, 89), '<': (False, 89), '^': (True, 259), 'do': (False, 89), '>': (False, 89), '*': (True, 265), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'*': (True, 265), 'or': (False, 86), '^': (True, 259), '%': (True, 261), 'do': (False, 86), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '<': (True, 267), '~=': (True, 272), '-': (True, 269), '==': (True, 270), '/': (True, 271), 'and': (False, 86), '..': (True, 268)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), '>=': (False, 84), 'until': (False, 84), '<=': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), 'until': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), ';': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {';': (True, 733), 'until': (False, 1), 'retstat__2': (True, 734)}, {'[': (True, 736), 'tableconstructor': (True, 738), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 741), '+': (False, 83), ',': (False, 83), '<': (False, 83), '%': (False, 83), 'until': (False, 83), '<=': (False, 83), '(': (True, 735), '^': (False, 83), '..': (False, 83), ':': (True, 742), '>': (False, 83), '*': (False, 83), ';': (False, 83), 'STRING': (True, 737), '==': (False, 83), '.': (True, 739), '{': (True, 740), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), '>=': (False, 77), 'until': (False, 77), '<=': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), ';': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '/': (False, 77), '..': (False, 77)}, {'funcbody': (True, 744), '(': (True, 745)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 746), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), '%': (False, 76), 'until': (False, 76), ',': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), ';': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '%': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), 'until': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), ';': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '>=': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 772), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), '>=': (False, 82), 'until': (False, 82), '<=': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), ';': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), '>=': (False, 80), 'until': (False, 80), ',': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), ';': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), '>=': (False, 78), 'until': (False, 78), ',': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), ';': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 785), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), '>=': (False, 81), 'until': (False, 81), ',': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), ';': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), '>=': (False, 79), 'until': (False, 79), '<=': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), ';': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {';': (False, 16), 'until': (False, 16)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 786), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 791), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {',': (True, 796), '*': (True, 800), '^': (True, 795), 'and': (True, 794), ';': (False, 29), '%': (True, 797), '+': (True, 798), '>': (True, 799), '<=': (True, 793), '>=': (True, 801), '~=': (True, 808), '<': (True, 802), 'explist__1': (True, 806), '-': (True, 804), '==': (True, 805), '/': (True, 807), 'until': (False, 29), '..': (True, 803), 'or': (True, 809)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), '>=': (False, 75), 'until': (False, 75), '<=': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), '~=': (False, 75)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), 'until': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), ';': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), ']': (False, 18), '(': (False, 18), '^': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 514), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), ']': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), '>=': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'funcbody': (True, 520), '(': (True, 521)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), ']': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), ']': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '>=': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), ']': (False, 37), '(': (False, 37), '^': (False, 37), '..': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '%': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '~=': (False, 37)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 533), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (True, 536), 'tableconstructor': (True, 538), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 541), '+': (False, 83), '<=': (False, 83), '<': (False, 83), ']': (False, 83), '(': (True, 535), '^': (False, 83), '..': (False, 83), ':': (True, 542), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 537), '==': (False, 83), '.': (True, 539), '{': (True, 540), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 81), 'and': (False, 81), '>=': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), ']': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), '%': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 77), 'and': (False, 77), '>=': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), ']': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), '%': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {'or': (False, 79), 'and': (False, 79), '>=': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), ']': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), '%': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 547), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 549), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 550), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'*': (True, 411), '<': (True, 413), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '~=': (True, 414), '-': (True, 415), ']': (True, 551), '/': (True, 417), '..': (True, 418), 'or': (True, 419)}, {'or': (False, 78), 'and': (False, 78), '>=': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), ']': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), '%': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'or': (False, 75), 'and': (False, 75), '>=': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), ']': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), '%': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), ']': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), '<=': (False, 19), '<': (False, 19), ']': (False, 19), '(': (False, 19), '^': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 340), 'or': (True, 346)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 378), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 386), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 380), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ':': (False, 13), ',': (False, 13), '<': (False, 13), '<=': (False, 13), '(': (False, 13), '^': (False, 13), ';': (False, 13), '..': (False, 13), '}': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), '}': (False, 12), '<=': (False, 12), '<': (False, 12), ',': (False, 12), '(': (False, 12), '^': (False, 12), ';': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 420)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 421), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '}': (False, 107), '<=': (False, 107), '<': (False, 107), '>=': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), '..': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), ';': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 422)}, {'if': (False, 85), 'return': (False, 85), 'goto': (False, 85), 'and': (True, 170), '::': (False, 85), '%': (True, 175), 'repeat': (False, 85), 'NAME': (False, 85), '+': (True, 172), '<=': (True, 168), '<': (True, 180), 'for': (False, 85), 'function': (False, 85), 'while': (False, 85), 'or': (False, 85), '(': (False, 85), 'EOF': (False, 85), '^': (True, 179), ';': (False, 85), 'do': (False, 85), 'break': (False, 85), 'EMBEDSTAT': (False, 85), '>': (True, 173), '*': (True, 174), '>=': (True, 171), '==': (True, 176), '..': (True, 177), '-': (True, 178), '/': (True, 181), 'local': (False, 85), '~=': (True, 182)}, {'::': (False, 89), 'return': (False, 89), 'or': (False, 89), 'and': (False, 89), 'if': (False, 89), '%': (True, 175), 'NAME': (False, 89), '+': (True, 172), '<=': (False, 89), '<': (False, 89), 'for': (False, 89), 'goto': (False, 89), 'local': (False, 89), 'while': (False, 89), 'EMBEDSTAT': (False, 89), '(': (False, 89), 'EOF': (False, 89), '^': (True, 179), ';': (False, 89), 'do': (False, 89), 'break': (False, 89), '>': (False, 89), '*': (True, 174), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 178), 'function': (False, 89), '/': (True, 181), 'repeat': (False, 89), '..': (True, 177)}, {'::': (False, 86), 'NAME': (False, 86), 'or': (False, 86), 'and': (False, 86), 'if': (False, 86), '%': (True, 175), 'repeat': (False, 86), 'return': (False, 86), '+': (True, 172), '<=': (True, 168), '<': (True, 180), 'for': (False, 86), 'goto': (False, 86), 'while': (False, 86), 'EOF': (False, 86), '(': (False, 86), 'EMBEDSTAT': (False, 86), '^': (True, 179), ';': (False, 86), 'do': (False, 86), 'break': (False, 86), '>': (True, 173), '*': (True, 174), '>=': (True, 171), '==': (True, 176), '..': (True, 177), '-': (True, 178), 'function': (False, 86), '/': (True, 181), 'local': (False, 86), '~=': (True, 182)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 810), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 813), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 831), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 832), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 835), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 838), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 840), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 842), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 844), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'break': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), '<=': (False, 20), '<': (False, 20), 'function': (False, 20), 'while': (False, 20), '(': (False, 20), 'EOF': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 379), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 347), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 348), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 925), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 927), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 929), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 334), '+': (True, 335), '<=': (False, 92), '<': (False, 92), ')': (False, 92), '^': (True, 332), '>': (False, 92), '*': (True, 337), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 334), '+': (True, 335), '<=': (False, 90), '<': (False, 90), ')': (False, 90), '^': (True, 332), '>': (False, 90), '*': (True, 337), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'}': (True, 350)}, {'::': (False, 4), 'NAME': (False, 4), 'or': (False, 4), 'and': (False, 4), 'if': (False, 4), '>=': (False, 4), 'repeat': (False, 4), 'return': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'for': (False, 4), 'goto': (False, 4), 'while': (False, 4), 'EMBEDSTAT': (False, 4), '(': (False, 4), 'EOF': (False, 4), '^': (False, 4), 'do': (False, 4), 'break': (False, 4), '>': (False, 4), '*': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '-': (False, 4), 'function': (False, 4), '/': (False, 4), 'local': (False, 4), '~=': (False, 4), '%': (False, 4)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), '>=': (False, 60), '<=': (False, 60), '^': (False, 60), '}': (False, 60), '>': (False, 60), '*': (False, 60), ';': (False, 60), '==': (False, 60), '..': (False, 60), '-': (False, 60), '/': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 363)}, {'::': (False, 90), 'return': (False, 90), 'or': (False, 90), 'and': (False, 90), 'if': (False, 90), '%': (True, 175), 'NAME': (False, 90), '+': (True, 172), '<=': (False, 90), '<': (False, 90), 'for': (False, 90), 'goto': (False, 90), 'local': (False, 90), '>=': (False, 90), 'while': (False, 90), 'EMBEDSTAT': (False, 90), '(': (False, 90), 'EOF': (False, 90), '^': (True, 179), 'do': (False, 90), 'break': (False, 90), '>': (False, 90), '*': (True, 174), ';': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 178), 'function': (False, 90), '/': (True, 181), 'repeat': (False, 90), '..': (True, 177)}, {'if': (False, 94), 'return': (False, 94), 'goto': (False, 94), 'and': (False, 94), '::': (False, 94), '%': (True, 175), 'repeat': (False, 94), 'NAME': (False, 94), '+': (False, 94), '<=': (False, 94), '<': (False, 94), 'for': (False, 94), 'function': (False, 94), 'while': (False, 94), 'EMBEDSTAT': (False, 94), '(': (False, 94), 'EOF': (False, 94), '^': (True, 179), ';': (False, 94), 'do': (False, 94), 'break': (False, 94), '>': (False, 94), '*': (True, 174), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), 'or': (False, 94), '/': (True, 181), 'local': (False, 94), '~=': (False, 94)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '}': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), ';': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), '%': (False, 100), '<=': (False, 100), '^': (True, 495), '}': (False, 100), '>': (False, 100), '*': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'if': (False, 88), 'return': (False, 88), 'or': (False, 88), 'and': (False, 88), '::': (False, 88), '%': (True, 175), 'repeat': (False, 88), 'NAME': (False, 88), '+': (True, 172), '<=': (False, 88), '<': (False, 88), 'for': (False, 88), 'goto': (False, 88), 'while': (False, 88), 'EMBEDSTAT': (False, 88), '(': (False, 88), 'EOF': (False, 88), '^': (True, 179), ';': (False, 88), 'do': (False, 88), 'break': (False, 88), '>': (False, 88), '*': (True, 174), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 178), 'function': (False, 88), '/': (True, 181), 'local': (False, 88), '..': (True, 177)}, {'::': (False, 96), 'return': (False, 96), 'goto': (False, 96), 'and': (False, 96), 'if': (False, 96), '>=': (False, 96), 'NAME': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), 'for': (False, 96), 'function': (False, 96), 'local': (False, 96), 'while': (False, 96), 'or': (False, 96), '(': (False, 96), 'EOF': (False, 96), '^': (True, 179), ';': (False, 96), 'do': (False, 96), 'break': (False, 96), 'EMBEDSTAT': (False, 96), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '..': (False, 96)}, {'if': (False, 98), 'NAME': (False, 98), 'or': (False, 98), 'and': (False, 98), '::': (False, 98), '>=': (False, 98), 'return': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), 'for': (False, 98), 'function': (False, 98), 'local': (False, 98), 'while': (False, 98), 'EOF': (False, 98), '(': (False, 98), 'EMBEDSTAT': (False, 98), '^': (True, 179), 'goto': (False, 98), 'do': (False, 98), 'break': (False, 98), '>': (False, 98), '*': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '..': (False, 98), '%': (False, 98)}, {')': (False, 23)}, {',': (True, 787), 'parlist__1': (True, 788), ')': (False, 33)}, {')': (False, 5)}, {')': (True, 811)}, {'::': (False, 92), 'NAME': (False, 92), 'or': (False, 92), 'and': (False, 92), 'if': (False, 92), '%': (True, 175), 'repeat': (False, 92), 'return': (False, 92), '+': (True, 172), '<=': (False, 92), '<': (False, 92), 'for': (False, 92), 'goto': (False, 92), 'while': (False, 92), 'EOF': (False, 92), '(': (False, 92), 'EMBEDSTAT': (False, 92), '^': (True, 179), ';': (False, 92), 'do': (False, 92), 'break': (False, 92), '>': (False, 92), '*': (True, 174), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 178), 'function': (False, 92), '/': (True, 181), 'local': (False, 92), '..': (True, 177)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 674), 'or': (True, 346)}, {'if': (False, 93), 'NAME': (False, 93), 'goto': (False, 93), 'and': (False, 93), '::': (False, 93), '%': (True, 175), 'return': (False, 93), '+': (True, 172), '<=': (False, 93), '<': (False, 93), 'for': (False, 93), 'function': (False, 93), 'local': (False, 93), 'while': (False, 93), 'EOF': (False, 93), '(': (False, 93), 'EMBEDSTAT': (False, 93), '^': (True, 179), ';': (False, 93), 'do': (False, 93), 'break': (False, 93), '>': (False, 93), '*': (True, 174), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 178), 'or': (False, 93), '/': (True, 181), 'repeat': (False, 93), '..': (True, 177)}, {'::': (False, 95), 'NAME': (False, 95), 'or': (False, 95), 'and': (False, 95), 'if': (False, 95), '%': (True, 175), 'repeat': (False, 95), 'return': (False, 95), '+': (False, 95), '<=': (False, 95), '<': (False, 95), 'for': (False, 95), 'function': (False, 95), 'while': (False, 95), 'EMBEDSTAT': (False, 95), '(': (False, 95), 'EOF': (False, 95), '^': (True, 179), ';': (False, 95), 'goto': (False, 95), 'do': (False, 95), 'break': (False, 95), '>': (False, 95), '*': (True, 174), '>=': (False, 95), '==': (False, 95), '~=': (False, 95), '-': (False, 95), '/': (True, 181), 'local': (False, 95), '..': (False, 95)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'::': (False, 99), 'NAME': (False, 99), 'or': (False, 99), 'and': (False, 99), 'if': (False, 99), '>=': (False, 99), 'return': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), 'for': (False, 99), 'goto': (False, 99), 'local': (False, 99), 'while': (False, 99), 'EMBEDSTAT': (False, 99), '(': (False, 99), 'EOF': (False, 99), '^': (True, 179), 'do': (False, 99), 'break': (False, 99), '>': (False, 99), '*': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), 'function': (False, 99), '/': (False, 99), 'repeat': (False, 99), '~=': (False, 99), '%': (False, 99)}, {'[': (False, 66), 'NAME': (False, 66), 'true': (False, 66), 'function': (False, 66), 'not': (False, 66), 'false': (False, 66), '(': (False, 66), 'NUMBER': (False, 66), 'EMBEDEXPR': (False, 66), '#': (False, 66), '}': (False, 66), '...': (False, 66), 'STRING': (False, 66), '{': (False, 66), '-': (False, 66), 'nil': (False, 66)}, {'[': (False, 67), 'NAME': (False, 67), 'true': (False, 67), 'function': (False, 67), 'not': (False, 67), 'false': (False, 67), '(': (False, 67), 'NUMBER': (False, 67), 'EMBEDEXPR': (False, 67), '#': (False, 67), '}': (False, 67), '...': (False, 67), 'STRING': (False, 67), '{': (False, 67), '-': (False, 67), 'nil': (False, 67)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 634), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'}': (False, 69)}, {'if': (False, 87), 'NAME': (False, 87), 'or': (False, 87), 'and': (False, 87), '::': (False, 87), '%': (True, 175), 'repeat': (False, 87), 'return': (False, 87), '+': (True, 172), '<=': (False, 87), '<': (False, 87), 'for': (False, 87), 'goto': (False, 87), 'while': (False, 87), 'EMBEDSTAT': (False, 87), '(': (False, 87), 'EOF': (False, 87), '^': (True, 179), ';': (False, 87), 'do': (False, 87), 'break': (False, 87), '>': (False, 87), '*': (True, 174), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 178), 'function': (False, 87), '/': (True, 181), 'local': (False, 87), '..': (True, 177)}, {'::': (False, 97), 'NAME': (False, 97), 'function': (False, 97), 'and': (False, 97), 'if': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'for': (False, 97), 'goto': (False, 97), 'while': (False, 97), 'or': (False, 97), '(': (False, 97), 'EOF': (False, 97), '^': (True, 179), 'do': (False, 97), 'break': (False, 97), 'EMBEDSTAT': (False, 97), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '~=': (False, 97), '%': (False, 97)}, {'if': (False, 91), 'return': (False, 91), 'goto': (False, 91), 'and': (False, 91), '::': (False, 91), '%': (True, 175), 'NAME': (False, 91), '+': (True, 172), '<=': (False, 91), '<': (False, 91), 'for': (False, 91), 'function': (False, 91), 'local': (False, 91), 'while': (False, 91), 'EOF': (False, 91), '(': (False, 91), 'EMBEDSTAT': (False, 91), '^': (True, 179), ';': (False, 91), 'do': (False, 91), 'break': (False, 91), '>': (False, 91), '*': (True, 174), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 178), 'or': (False, 91), '/': (True, 181), 'repeat': (False, 91), '..': (True, 177)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), '>=': (False, 101), ',': (False, 101), '^': (True, 495), '}': (False, 101), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'*': (True, 499), ';': (False, 58), '^': (True, 495), 'and': (True, 494), ',': (False, 58), '%': (True, 496), '+': (True, 497), '}': (False, 58), '>': (True, 498), '<=': (True, 493), '>=': (True, 500), '<': (True, 501), '..': (True, 506), '-': (True, 503), '==': (True, 504), '/': (True, 505), '~=': (True, 502), 'or': (True, 507)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 334), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ')': (False, 95), '^': (True, 332), '>': (False, 95), '*': (True, 337), '>=': (False, 95), '==': (False, 95), '~=': (False, 95), '-': (False, 95), '/': (True, 344), '..': (False, 95)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 409), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'}': (True, 434)}, {'or': (False, 84), 'and': (False, 84), '>=': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), ')': (False, 84), '<=': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), '%': (False, 84), '==': (False, 84), '..': (False, 84), '-': (False, 84), '/': (False, 84), '~=': (False, 84)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), ')': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {'[': (True, 868), 'tableconstructor': (True, 870), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 873), '+': (False, 83), ',': (False, 83), '<': (False, 83), ')': (False, 83), '<=': (False, 83), '(': (True, 867), '^': (False, 83), '..': (False, 83), ':': (True, 874), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 869), '==': (False, 83), '.': (True, 871), '{': (True, 872), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), ')': (False, 77), '<=': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), '>=': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {')': (True, 876)}, {'funcbody': (True, 878), '(': (True, 879)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 897), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), ')': (False, 76), ',': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), ')': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '..': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18), '.': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 899), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), ')': (False, 82), '<=': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '~=': (False, 82), '-': (False, 82), '/': (False, 82), '..': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), ')': (False, 80), ',': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '..': (False, 80), '-': (False, 80), '/': (False, 80), '~=': (False, 80)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), ')': (False, 78), ',': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), '>=': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 901), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), ')': (False, 81), ',': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), '>=': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), ')': (False, 79), '<=': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), '>=': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {')': (False, 30)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 902), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 903), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {',': (True, 907), '*': (True, 911), '^': (True, 906), 'and': (True, 905), '%': (True, 908), '+': (True, 909), '>': (True, 910), '<=': (True, 904), '>=': (True, 912), '~=': (True, 919), '<': (True, 913), 'explist__1': (True, 917), '-': (True, 915), '==': (True, 916), '/': (True, 918), ')': (False, 29), '..': (True, 914), 'or': (True, 920)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), ')': (False, 75), '<=': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), '>=': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), ')': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '..': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19), '.': (False, 19)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1066), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1065), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1067), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1069), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1072), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), ':': (False, 38), '<=': (False, 38), '<': (False, 38), ',': (False, 38), '(': (False, 38), '^': (False, 38), ';': (False, 38), '}': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '~=': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '..': (False, 38), '.': (False, 38)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1074), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1076), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1078), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1079), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1081), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1082), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1083), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1084), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1085), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1086), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '}': (False, 39), '<=': (False, 39), '~=': (False, 39), '<': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), ';': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39)}, {'}': (True, 652)}, {'(': (True, 320), 'args': (True, 675), 'tableconstructor': (True, 323), 'STRING': (True, 322), '{': (True, 325)}, {'::': (True, 676)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), 'explist': (True, 677), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 483), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'until': (True, 924)}, {'funcbody': (True, 964), '(': (True, 679)}, {'*': (True, 450), '/': (True, 457), 'and': (True, 446), '^': (True, 445), '%': (True, 447), '+': (True, 448), '>': (True, 459), '<=': (True, 444), '>=': (True, 451), '<': (True, 452), '~=': (True, 453), '-': (True, 454), '==': (True, 456), 'then': (True, 923), '..': (True, 458), 'or': (True, 455)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 624), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'if': (False, 13), '[': (False, 13), 'NAME': (False, 13), 'function': (False, 13), '::': (False, 13), 'repeat': (False, 13), 'return': (False, 13), 'for': (False, 13), 'goto': (False, 13), 'while': (False, 13), '(': (False, 13), 'EMBEDSTAT': (False, 13), 'do': (False, 13), 'break': (False, 13), ':': (False, 13), 'until': (False, 13), ';': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), 'local': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'NAME': (False, 12), 'function': (False, 12), '::': (False, 12), 'return': (False, 12), 'for': (False, 12), 'goto': (False, 12), 'local': (False, 12), 'while': (False, 12), '(': (False, 12), 'EMBEDSTAT': (False, 12), 'do': (False, 12), 'break': (False, 12), ':': (False, 12), 'until': (False, 12), ';': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), 'repeat': (False, 12)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 630), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'NAME': (False, 107), 'function': (False, 107), '::': (False, 107), 'return': (False, 107), 'for': (False, 107), 'goto': (False, 107), 'local': (False, 107), 'while': (False, 107), '(': (False, 107), 'EMBEDSTAT': (False, 107), 'do': (False, 107), 'break': (False, 107), ':': (False, 107), 'until': (False, 107), ';': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), 'repeat': (False, 107)}, {'NAME': (True, 632)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '>=': (False, 4), '<=': (False, 4), '^': (False, 4), '}': (False, 4), '>': (False, 4), '*': (False, 4), ';': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), ')': (False, 101), '^': (True, 332), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1028), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1027), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), ')': (False, 13), '(': (False, 13), '^': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), '<=': (False, 12), '<': (False, 12), ')': (False, 12), '(': (False, 12), '^': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '..': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12), '.': (False, 12)}, {'NAME': (True, 1031)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1033), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '>=': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), ')': (False, 107), '(': (False, 107), '^': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '==': (False, 107), '..': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107), '.': (False, 107)}, {'NAME': (True, 1036)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1040), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1038), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1041), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1043), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1044), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'::': (True, 655), 'varlist': (True, 656), 'repeat': (True, 657), 'function': (True, 658), 'if': (True, 659), 'NAME': (True, 6), 'prefixexp': (True, 660), 'elseif': (False, 63), 'else': (False, 63), 'for': (True, 661), 'goto': (True, 662), 'label': (True, 663), 'while': (True, 664), 'return': (False, 63), 'EMBEDSTAT': (True, 665), 'var': (True, 13), '(': (True, 14), 'stat': (True, 666), 'block': (True, 1046), 'end': (False, 63), 'do': (True, 668), 'break': (True, 669), ';': (True, 670), 'block__1': (True, 671), 'local': (True, 672), 'functioncall': (True, 673)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1047), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1048), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1049), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1051), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1052), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1053), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1054), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1056), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1058), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1059), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'}': (True, 512)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), ')': (False, 102), '^': (True, 332), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), ')': (False, 100), '^': (True, 332), '>': (False, 100), '*': (False, 100), '%': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), '<=': (False, 20), '~=': (False, 20), '<': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '..': (False, 20)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1029), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {')': (True, 1032)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'goto': (False, 18), 'break': (False, 18), 'while': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), 'function': (False, 18), 'until': (False, 18), ',': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1089), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), 'break': (False, 37), 'while': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), ',': (False, 37), '<': (False, 37), 'goto': (False, 37), 'until': (False, 37), '<=': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), ';': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'if': (False, 84), 'or': (False, 84), '%': (False, 84), 'NAME': (False, 84), 'for': (False, 84), 'EMBEDSTAT': (False, 84), 'break': (False, 84), 'until': (False, 84), '*': (False, 84), '>=': (False, 84), '-': (False, 84), '/': (False, 84), 'repeat': (False, 84), '::': (False, 84), 'return': (False, 84), 'and': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), 'goto': (False, 84), 'while': (False, 84), '<=': (False, 84), '(': (False, 84), '^': (False, 84), 'local': (False, 84), '>': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), 'do': (False, 84), 'function': (False, 84), '..': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1090), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 82), 'or': (False, 82), '%': (False, 82), 'repeat': (False, 82), 'return': (False, 82), 'for': (False, 82), 'EMBEDSTAT': (False, 82), 'break': (False, 82), 'while': (False, 82), '*': (False, 82), '>=': (False, 82), '-': (False, 82), '/': (False, 82), 'local': (False, 82), '::': (False, 82), 'NAME': (False, 82), 'and': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'goto': (False, 82), 'until': (False, 82), ',': (False, 82), '(': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), ';': (False, 82), '==': (False, 82), '..': (False, 82), 'function': (False, 82), '~=': (False, 82)}, {'if': (False, 80), 'goto': (False, 80), '>=': (False, 80), 'NAME': (False, 80), 'for': (False, 80), 'local': (False, 80), 'or': (False, 80), 'EMBEDSTAT': (False, 80), 'break': (False, 80), 'until': (False, 80), '*': (False, 80), '%': (False, 80), '-': (False, 80), '/': (False, 80), 'repeat': (False, 80), '::': (False, 80), 'return': (False, 80), 'and': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'function': (False, 80), 'while': (False, 80), ',': (False, 80), '(': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), ';': (False, 80), '==': (False, 80), '..': (False, 80), '~=': (False, 80)}, {'if': (False, 78), 'or': (False, 78), '%': (False, 78), 'NAME': (False, 78), 'for': (False, 78), 'local': (False, 78), 'EMBEDSTAT': (False, 78), 'goto': (False, 78), 'break': (False, 78), 'while': (False, 78), '*': (False, 78), '>=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '::': (False, 78), 'return': (False, 78), 'and': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'function': (False, 78), 'until': (False, 78), ',': (False, 78), '(': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), ';': (False, 78), '==': (False, 78), '..': (False, 78), '~=': (False, 78)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1092), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'if': (False, 83), '[': (True, 1095), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), 'goto': (False, 83), 'break': (False, 83), 'until': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1096), '.': (True, 1098), '{': (True, 1099), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 1097), 'and': (False, 83), 'args': (True, 1100), '+': (False, 83), ',': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '<=': (False, 83), '(': (True, 1094), '^': (False, 83), 'do': (False, 83), ':': (True, 1101), '>': (False, 83), ';': (False, 83), '==': (False, 83), '~=': (False, 83), '..': (False, 83)}, {'if': (False, 81), 'or': (False, 81), '%': (False, 81), 'repeat': (False, 81), 'NAME': (False, 81), 'for': (False, 81), 'EMBEDSTAT': (False, 81), 'break': (False, 81), 'while': (False, 81), '*': (False, 81), '>=': (False, 81), '-': (False, 81), '/': (False, 81), 'local': (False, 81), '::': (False, 81), 'return': (False, 81), 'and': (False, 81), '+': (False, 81), ',': (False, 81), '<': (False, 81), 'goto': (False, 81), 'until': (False, 81), '<=': (False, 81), '(': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), ';': (False, 81), '==': (False, 81), '~=': (False, 81), 'function': (False, 81), '..': (False, 81)}, {'if': (False, 77), 'goto': (False, 77), '%': (False, 77), 'return': (False, 77), 'for': (False, 77), 'local': (False, 77), 'or': (False, 77), 'EMBEDSTAT': (False, 77), 'break': (False, 77), 'while': (False, 77), '*': (False, 77), '>=': (False, 77), '-': (False, 77), '/': (False, 77), 'repeat': (False, 77), '::': (False, 77), 'NAME': (False, 77), 'and': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'function': (False, 77), 'until': (False, 77), ',': (False, 77), '(': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), ';': (False, 77), '==': (False, 77), '~=': (False, 77), '..': (False, 77)}, {'if': (False, 79), 'function': (False, 79), '>=': (False, 79), 'NAME': (False, 79), 'for': (False, 79), 'local': (False, 79), 'or': (False, 79), 'EMBEDSTAT': (False, 79), 'break': (False, 79), 'while': (False, 79), '*': (False, 79), '%': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '::': (False, 79), 'return': (False, 79), 'and': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'goto': (False, 79), 'until': (False, 79), ',': (False, 79), '(': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), ';': (False, 79), '==': (False, 79), '~=': (False, 79), '..': (False, 79)}, {'if': (False, 7), 'NAME': (False, 7), 'goto': (False, 7), '::': (False, 7), 'return': (False, 7), 'for': (False, 7), 'function': (False, 7), 'local': (False, 7), 'until': (False, 7), '(': (False, 7), 'EMBEDSTAT': (False, 7), 'do': (False, 7), 'break': (False, 7), 'while': (False, 7), ';': (False, 7), 'repeat': (False, 7)}, {'funcbody': (True, 1106), '(': (True, 1107)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1118), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1121), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'if': (False, 29), 'or': (True, 1126), '%': (True, 1134), 'return': (False, 29), 'for': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'break': (False, 29), 'until': (False, 29), '*': (True, 1133), '>=': (True, 1129), '-': (True, 1137), '/': (True, 1139), 'repeat': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 1127), '+': (True, 1130), ',': (True, 1128), '<': (True, 1131), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 1125), '(': (False, 29), '^': (True, 1136), 'do': (False, 29), '>': (True, 1132), ';': (False, 29), '==': (True, 1135), '~=': (True, 1140), 'explist__1': (True, 1138), 'function': (False, 29), '..': (True, 1141)}, {'if': (False, 75), 'or': (False, 75), '%': (False, 75), 'repeat': (False, 75), 'return': (False, 75), 'for': (False, 75), 'EMBEDSTAT': (False, 75), 'break': (False, 75), 'until': (False, 75), '*': (False, 75), '>=': (False, 75), '-': (False, 75), '/': (False, 75), 'local': (False, 75), '::': (False, 75), 'NAME': (False, 75), 'and': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), 'goto': (False, 75), 'while': (False, 75), '<=': (False, 75), '(': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), ';': (False, 75), '==': (False, 75), '~=': (False, 75), 'function': (False, 75), '..': (False, 75)}, {'if': (False, 76), 'or': (False, 76), '%': (False, 76), 'return': (False, 76), 'for': (False, 76), 'EMBEDSTAT': (False, 76), 'break': (False, 76), 'until': (False, 76), '*': (False, 76), '>=': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '::': (False, 76), 'NAME': (False, 76), 'and': (False, 76), '+': (False, 76), ',': (False, 76), '<': (False, 76), 'goto': (False, 76), 'while': (False, 76), '<=': (False, 76), '(': (False, 76), '^': (False, 76), 'local': (False, 76), '>': (False, 76), ';': (False, 76), '==': (False, 76), '..': (False, 76), 'do': (False, 76), 'function': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'break': (False, 19), 'until': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'(': (False, 21)}, {')': (True, 973)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), '^': (True, 259), 'do': (False, 99), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 210), 'namelist__1': (True, 582), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), '(': (False, 26), 'EMBEDSTAT': (False, 26), 'do': (False, 26), 'break': (False, 26), 'until': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {')': (True, 833)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), '%': (False, 102), '<=': (False, 102), '^': (True, 495), '}': (False, 102), '>': (False, 102), '*': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1103), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1104), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1108), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1117), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1120), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1122), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1123), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1142), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1144), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1146), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 518), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 523), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 526), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 528), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 531), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), 'explist': (True, 567), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 571), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'NAME': (True, 607)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 598), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'in': (False, 3)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), ')': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), '^': (True, 259), 'do': (False, 98), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 642), 'or': (True, 346)}, {'(': (False, 105), ':': (False, 105)}, {'end': (True, 643)}, {'(': (False, 39), '[': (False, 39), ':': (False, 39), ',': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '=': (False, 39)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 496), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ',': (False, 95), '^': (True, 495), ';': (False, 95), '}': (False, 95), '>': (False, 95), '*': (True, 499), '>=': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 505), '~=': (False, 95)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 261), '+': (False, 94), '<=': (False, 94), '<': (False, 94), '^': (True, 259), 'do': (False, 94), '>': (False, 94), '*': (True, 265), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 271), '~=': (False, 94)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), '<=': (False, 60), '<': (False, 60), ']': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1050)}, {'}': (True, 1180)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 496), '+': (True, 497), ',': (False, 92), '<': (False, 92), '>=': (False, 92), '<=': (False, 92), '^': (True, 495), '}': (False, 92), '>': (False, 92), '*': (True, 499), ';': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 261), '+': (True, 263), '<=': (False, 88), '<': (False, 88), '^': (True, 259), 'do': (False, 88), '>': (False, 88), '*': (True, 265), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'*': (True, 411), '^': (True, 405), 'and': (True, 406), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), '==': (True, 416), '/': (True, 417), ']': (True, 1157), '~=': (True, 414), 'or': (True, 419)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), '>=': (False, 97), ',': (False, 97), '^': (True, 495), '}': (False, 97), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), '^': (True, 259), 'do': (False, 96), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 496), '+': (True, 497), ',': (False, 93), '<': (False, 93), '>=': (False, 93), '<=': (False, 93), '^': (True, 495), '}': (False, 93), '>': (False, 93), '*': (True, 499), ';': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 261), '+': (True, 263), '<=': (False, 90), '<': (False, 90), '^': (True, 259), 'do': (False, 90), '>': (False, 90), '*': (True, 265), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'(': (True, 153), 'args': (True, 1002), 'tableconstructor': (True, 155), 'STRING': (True, 154), '{': (True, 157)}, {'*': (True, 499), '^': (True, 495), 'and': (True, 494), ';': (False, 85), '%': (True, 496), '+': (True, 497), '}': (False, 85), '>': (True, 498), '<=': (True, 493), '>=': (True, 500), ',': (False, 85), '<': (True, 501), '~=': (True, 502), '-': (True, 503), '==': (True, 504), '/': (True, 505), '..': (True, 506), 'or': (False, 85)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 261), '+': (True, 263), '<=': (False, 87), '<': (False, 87), '^': (True, 259), 'do': (False, 87), '>': (False, 87), '*': (True, 265), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), ']': (False, 101), '^': (True, 405), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 261), '+': (True, 263), '<=': (False, 93), '<': (False, 93), '^': (True, 259), 'do': (False, 93), '>': (False, 93), '*': (True, 265), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1250), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1251), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), '<=': (False, 13), '~=': (False, 13), '<': (False, 13), ']': (False, 13), '(': (False, 13), '^': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '..': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), '<=': (False, 12), '<': (False, 12), ']': (False, 12), '(': (False, 12), '^': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1252)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1254), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '>=': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), ']': (False, 107), '(': (False, 107), '^': (False, 107), '..': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 1256)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 261), '+': (False, 95), '<=': (False, 95), '<': (False, 95), '^': (True, 259), 'do': (False, 95), '>': (False, 95), '*': (True, 265), '>=': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 271), '~=': (False, 95)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 261), '+': (True, 263), '<=': (False, 92), '<': (False, 92), '^': (True, 259), 'do': (False, 92), '>': (False, 92), '*': (True, 265), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), '^': (True, 259), 'do': (False, 97), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 261), '+': (True, 263), '<=': (False, 91), '<': (False, 91), '^': (True, 259), 'do': (False, 91), '>': (False, 91), '*': (True, 265), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 269), '/': (True, 271), '..': (True, 268)}, {'}': (True, 898)}, {'*': (True, 265), 'and': (True, 260), '^': (True, 259), '%': (True, 261), 'do': (False, 85), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '<': (True, 267), '..': (True, 268), '-': (True, 269), '==': (True, 270), '/': (True, 271), '~=': (True, 272), 'or': (False, 85)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), ']': (False, 102), '^': (True, 405), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'or': (False, 100), 'and': (False, 100), '%': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), ']': (False, 100), '^': (True, 405), '>': (False, 100), '*': (False, 100), '>=': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'=': (True, 1224)}, {'::': (True, 1257)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), 'explist': (True, 1258), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1023), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1035), 'or': (True, 346)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), ',': (False, 18), '~=': (False, 18), '<': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1102), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), '<=': (False, 84), '^': (False, 84), 'do': (False, 84), '>': (False, 84), '*': (False, 84), '>=': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), '<=': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), ',': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), '*': (False, 78), '>=': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), ',': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1105), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'[': (True, 1110), 'tableconstructor': (True, 1112), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 1115), '+': (False, 83), ',': (False, 83), '<': (False, 83), '..': (False, 83), '<=': (False, 83), '(': (True, 1109), '^': (False, 83), 'do': (False, 83), ':': (True, 1116), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1111), '==': (False, 83), '.': (True, 1113), '{': (True, 1114), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), ',': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), '*': (False, 81), '>=': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), '<=': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), '*': (False, 77), '>=': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), '<=': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), '*': (False, 79), '>=': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'do': (True, 1124)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1143), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1145), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1147), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {',': (True, 1187), '*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), '%': (True, 1188), 'do': (False, 29), '+': (True, 1189), '==': (True, 1197), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '~=': (True, 1199), '-': (True, 1195), 'explist__1': (True, 1190), '/': (True, 1198), '..': (True, 1194), 'or': (True, 1196)}, {'funcbody': (True, 1201), '(': (True, 1202)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), '<=': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), '*': (False, 75), '>=': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), ',': (False, 76), '^': (False, 76), 'do': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), ',': (False, 19), '~=': (False, 19), '<': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '..': (False, 19)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1207), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'if': (False, 13), '[': (False, 13), 'NAME': (False, 13), 'function': (False, 13), '::': (False, 13), 'repeat': (False, 13), 'return': (False, 13), 'for': (False, 13), 'goto': (False, 13), 'while': (False, 13), 'EMBEDSTAT': (False, 13), '(': (False, 13), 'EOF': (False, 13), 'do': (False, 13), 'break': (False, 13), ':': (False, 13), ';': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), 'local': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'NAME': (False, 12), 'function': (False, 12), '::': (False, 12), 'return': (False, 12), 'for': (False, 12), 'goto': (False, 12), 'local': (False, 12), 'while': (False, 12), 'EMBEDSTAT': (False, 12), '(': (False, 12), 'EOF': (False, 12), 'do': (False, 12), 'break': (False, 12), ':': (False, 12), ';': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), 'repeat': (False, 12)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1208), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'NAME': (False, 107), 'function': (False, 107), '::': (False, 107), 'return': (False, 107), 'for': (False, 107), 'goto': (False, 107), 'local': (False, 107), 'while': (False, 107), 'EOF': (False, 107), '(': (False, 107), 'EMBEDSTAT': (False, 107), 'do': (False, 107), 'break': (False, 107), ':': (False, 107), ';': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), 'repeat': (False, 107)}, {'NAME': (True, 1209)}, {'if': (False, 25), 'NAME': (False, 25), 'function': (False, 25), '::': (False, 25), 'repeat': (False, 25), 'return': (False, 25), 'for': (False, 25), 'goto': (False, 25), '=': (False, 25), 'until': (False, 25), '(': (False, 25), 'EMBEDSTAT': (False, 25), 'do': (False, 25), 'break': (False, 25), 'while': (False, 25), ';': (False, 25), 'local': (False, 25)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '>=': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 954), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), '<=': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), '>=': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'funcbody': (True, 957), '(': (True, 958)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), '<=': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), ',': (False, 80), '<': (False, 80), '<=': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '>=': (False, 37), '+': (False, 37), ',': (False, 37), '<': (False, 37), '<=': (False, 37), '(': (False, 37), '^': (False, 37), '..': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '%': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '~=': (False, 37)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 963), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'[': (True, 966), 'tableconstructor': (True, 968), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 971), '+': (False, 83), ',': (False, 83), '<': (False, 83), '<=': (False, 83), '(': (True, 965), '^': (False, 83), '..': (False, 83), ':': (True, 972), '>': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 967), '==': (False, 83), '.': (True, 969), '{': (True, 970), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), ',': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), '>=': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), '<=': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), '>=': (False, 77), '==': (False, 77), '..': (False, 77), '-': (False, 77), '/': (False, 77), '~=': (False, 77)}, {'or': (False, 79), 'and': (False, 79), '>=': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), '<=': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), '%': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 974), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 975), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 978), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {',': (True, 982), '*': (True, 986), '^': (True, 981), 'and': (True, 980), '%': (True, 983), '+': (True, 984), '>': (True, 985), '<=': (True, 979), '>=': (True, 987), '<': (True, 988), '..': (True, 993), '-': (True, 990), '==': (True, 991), '/': (True, 992), '~=': (True, 989), 'or': (True, 994)}, {'or': (False, 78), 'and': (False, 78), '>=': (False, 78), '+': (False, 78), ',': (False, 78), '<': (False, 78), '<=': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), '%': (False, 78), '==': (False, 78), '..': (False, 78), '-': (False, 78), '/': (False, 78), '~=': (False, 78)}, {'or': (False, 75), 'and': (False, 75), '>=': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), '<=': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), '%': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), '~=': (False, 75)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), ',': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), '%': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'in': (True, 1042)}, {',': (True, 509), '=': (True, 1045), 'in': (False, 26), 'namelist__1': (True, 511)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), 'then': (False, 60), '<=': (False, 60), '<': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1210)}, {',': (True, 509), 'in': (False, 26), 'namelist__1': (True, 1211)}, {'if': (False, 45), 'return': (False, 45), 'goto': (False, 45), '::': (False, 45), 'repeat': (False, 45), 'NAME': (False, 45), 'for': (False, 45), 'function': (False, 45), 'while': (False, 45), 'EOF': (False, 45), '(': (False, 45), 'EMBEDSTAT': (False, 45), 'do': (False, 45), 'break': (False, 45), ';': (False, 45), 'local': (False, 45)}, {'*': (True, 265), 'and': (True, 260), '^': (True, 259), '%': (True, 261), 'do': (True, 1239), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '<': (True, 267), '~=': (True, 272), '-': (True, 269), '==': (True, 270), '/': (True, 271), '..': (True, 268), 'or': (True, 273)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), 'then': (False, 101), '<=': (False, 101), '<': (False, 101), '^': (True, 445), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'prefixexp': (True, 646), 'var': (True, 645), '(': (True, 14), 'NAME': (True, 6), 'functioncall': (True, 644)}, {'=': (False, 2)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 648), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 647), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), 'then': (False, 13), '<=': (False, 13), '~=': (False, 13), '<': (False, 13), '(': (False, 13), '^': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '..': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), 'then': (False, 12), '<=': (False, 12), '<': (False, 12), '(': (False, 12), '^': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 649)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 650), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '>=': (False, 107), '+': (False, 107), 'then': (False, 107), '<=': (False, 107), '<': (False, 107), '(': (False, 107), '^': (False, 107), '..': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 651)}, {'*': (True, 337), '^': (True, 332), 'and': (True, 333), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '==': (True, 342), ')': (True, 1205), '-': (True, 341), '<': (True, 339), '/': (True, 344), '~=': (True, 338), 'or': (True, 346)}, {'return': (False, 62), 'EOF': (False, 62)}, {')': (True, 1263)}, {')': (True, 641)}, {'end': (True, 1206)}, {'}': (True, 1034)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1037), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), 'explist': (True, 1039), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 571), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), 'then': (False, 102), '<=': (False, 102), '<': (False, 102), '^': (True, 445), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'}': (True, 1093)}, {'or': (False, 100), 'and': (False, 100), '%': (False, 100), '+': (False, 100), 'then': (False, 100), '<=': (False, 100), '<': (False, 100), '^': (True, 445), '>': (False, 100), '*': (False, 100), '>=': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'(': (True, 428), 'args': (True, 653), 'tableconstructor': (True, 430), 'STRING': (True, 429), '{': (True, 431)}, {'::': (True, 655), 'varlist': (True, 656), 'repeat': (True, 657), 'function': (True, 658), 'if': (True, 659), 'NAME': (True, 6), 'prefixexp': (True, 660), 'elseif': (False, 63), 'else': (False, 63), 'for': (True, 661), 'goto': (True, 662), 'label': (True, 663), 'while': (True, 664), 'return': (False, 63), 'EMBEDSTAT': (True, 665), 'var': (True, 13), '(': (True, 14), 'stat': (True, 666), 'block': (True, 667), 'end': (False, 63), 'do': (True, 668), 'break': (True, 669), ';': (True, 670), 'block__1': (True, 671), 'local': (True, 672), 'functioncall': (True, 673)}, {'}': (False, 64)}, {'EOF': (False, 103)}, {'EOF': (False, 56)}, {'tableconstructor': (True, 931), 'NAME': (True, 932), 'retstat__1': (True, 933), 'prefixexp': (True, 934), 'true': (True, 935), 'function': (True, 936), 'not': (True, 937), 'false': (True, 938), 'var': (True, 939), '(': (True, 940), 'EOF': (False, 17), 'functiondef': (True, 941), 'EMBEDEXPR': (True, 942), 'NUMBER': (True, 943), '#': (True, 944), '...': (True, 945), ';': (False, 17), 'STRING': (True, 946), 'explist': (True, 947), '{': (True, 948), '-': (True, 949), 'exp': (True, 950), 'nil': (True, 951), 'functioncall': (True, 952)}, {'::': (False, 8), 'return': (False, 8), 'function': (False, 8), 'stat__4': (True, 960), 'if': (False, 8), 'repeat': (False, 8), 'NAME': (False, 8), 'for': (False, 8), 'goto': (False, 8), '=': (True, 959), 'while': (False, 8), 'EMBEDSTAT': (False, 8), '(': (False, 8), 'EOF': (False, 8), 'do': (False, 8), 'break': (False, 8), ';': (False, 8), 'local': (False, 8)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 955), 'namelist__1': (True, 956), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), 'EMBEDSTAT': (False, 26), '(': (False, 26), 'EOF': (False, 26), 'do': (False, 26), 'break': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {'NAME': (True, 962)}, {'if': (False, 11), '[': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), '::': (False, 11), 'repeat': (False, 11), 'return': (False, 11), 'for': (False, 11), 'function': (False, 11), 'until': (False, 11), '(': (False, 11), 'EMBEDSTAT': (False, 11), 'do': (False, 11), 'break': (False, 11), ':': (False, 11), 'while': (False, 11), ';': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), 'local': (False, 11)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), '<=': (False, 20), '~=': (False, 20), '<': (False, 20), ']': (False, 20), '(': (False, 20), '^': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '..': (False, 20)}, {'::': (False, 47), 'NAME': (False, 47), 'goto': (False, 47), 'if': (False, 47), 'repeat': (False, 47), 'return': (False, 47), 'for': (False, 47), 'function': (False, 47), 'until': (False, 47), '(': (False, 47), 'EMBEDSTAT': (False, 47), 'do': (False, 47), 'break': (False, 47), 'while': (False, 47), ';': (False, 47), 'local': (False, 47)}, {'(': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '[': (False, 19), ':': (False, 19)}, {'[': (False, 18), '{': (False, 18), '(': (False, 18), ':': (False, 18), ',': (True, 611), 'STRING': (False, 18), '.': (False, 18), 'varlist__1': (True, 976), '=': (False, 73)}, {'(': (True, 995), 'STRING': (True, 996), 'tableconstructor': (True, 997), '.': (True, 156), '{': (True, 998), 'args': (True, 999), '[': (True, 158), ':': (True, 1000)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1237), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {')': (True, 1265)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), 'then': (False, 39), '<=': (False, 39), '~=': (False, 39), '<': (False, 39), '(': (False, 39), '^': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39)}, {'}': (True, 654)}, {'(': (True, 613), 'args': (True, 1091), 'tableconstructor': (True, 616), 'STRING': (True, 615), '{': (True, 618)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ':': (False, 4), ',': (False, 4), '<': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), ';': (False, 4), '}': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'if': (False, 108), '[': (False, 108), 'NAME': (False, 108), 'function': (False, 108), '::': (False, 108), 'return': (False, 108), 'for': (False, 108), 'goto': (False, 108), 'local': (False, 108), 'while': (False, 108), '(': (False, 108), 'EMBEDSTAT': (False, 108), 'do': (False, 108), 'break': (False, 108), ':': (False, 108), 'until': (False, 108), ';': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), 'repeat': (False, 108)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), 'then': (False, 4), '<=': (False, 4), '<': (False, 4), '(': (False, 4), '^': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'NAME': (True, 1214)}, {'=': (True, 1217)}, {'::': (True, 24), 'varlist': (True, 25), 'repeat': (True, 26), 'function': (True, 27), 'if': (True, 28), 'NAME': (True, 6), 'prefixexp': (True, 29), 'return': (False, 63), 'for': (True, 30), 'goto': (True, 31), 'label': (True, 32), 'while': (True, 33), 'EMBEDSTAT': (True, 34), 'var': (True, 13), '(': (True, 14), 'stat': (True, 35), 'block': (True, 1218), 'do': (True, 37), 'break': (True, 38), 'until': (False, 63), ';': (True, 39), 'block__1': (True, 40), 'local': (True, 41), 'functioncall': (True, 42)}, {'NAME': (True, 44), 'funcname': (True, 1221)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1223), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'(': (True, 1226), 'STRING': (True, 1227), 'tableconstructor': (True, 1228), '.': (True, 156), '{': (True, 1229), 'args': (True, 1230), '[': (True, 158), ':': (True, 1231)}, {'namelist': (True, 1233), 'NAME': (True, 1234)}, {'NAME': (True, 1236)}, {'::': (False, 43), 'return': (False, 43), 'function': (False, 43), 'if': (False, 43), 'repeat': (False, 43), 'NAME': (False, 43), 'elseif': (False, 43), 'else': (False, 43), 'for': (False, 43), 'goto': (False, 43), 'while': (False, 43), '(': (False, 43), 'EMBEDSTAT': (False, 43), ';': (False, 43), 'do': (False, 43), 'break': (False, 43), 'end': (False, 43), 'local': (False, 43)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 1238), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'::': (False, 55), 'NAME': (False, 55), 'function': (False, 55), 'if': (False, 55), 'return': (False, 55), 'elseif': (False, 55), 'else': (False, 55), 'for': (False, 55), 'goto': (False, 55), 'local': (False, 55), 'while': (False, 55), '(': (False, 55), 'EMBEDSTAT': (False, 55), 'end': (False, 55), 'do': (False, 55), 'break': (False, 55), ';': (False, 55), 'repeat': (False, 55)}, {'::': (True, 655), 'varlist': (True, 656), 'return': (False, 63), 'function': (True, 658), 'if': (True, 659), 'NAME': (True, 6), 'prefixexp': (True, 660), 'elseif': (False, 63), 'else': (False, 63), 'for': (True, 661), 'goto': (True, 662), 'local': (True, 672), 'label': (True, 663), 'while': (True, 664), 'var': (True, 13), '(': (True, 14), 'stat': (True, 666), 'EMBEDSTAT': (True, 665), 'end': (False, 63), 'do': (True, 668), 'break': (True, 669), ';': (True, 670), 'block__1': (True, 1240), 'repeat': (True, 657), 'functioncall': (True, 673)}, {'elseif': (True, 1241), 'end': (False, 15), 'else': (False, 15), 'stat__1': (True, 1242)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1243), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (False, 44), 'NAME': (False, 44), 'function': (False, 44), 'if': (False, 44), 'repeat': (False, 44), 'return': (False, 44), 'elseif': (False, 44), 'else': (False, 44), 'for': (False, 44), 'goto': (False, 44), 'while': (False, 44), '(': (False, 44), 'EMBEDSTAT': (False, 44), 'end': (False, 44), 'do': (False, 44), 'break': (False, 44), ';': (False, 44), 'local': (False, 44)}, {'if': (False, 40), 'NAME': (False, 40), 'function': (False, 40), '::': (False, 40), 'repeat': (False, 40), 'return': (False, 40), 'elseif': (False, 40), 'else': (False, 40), 'for': (False, 40), 'goto': (False, 40), 'while': (False, 40), '(': (False, 40), 'EMBEDSTAT': (False, 40), ';': (False, 40), 'do': (False, 40), 'break': (False, 40), 'end': (False, 40), 'local': (False, 40)}, {'elseif': (False, 104), 'end': (False, 104), 'return': (True, 1246), 'else': (False, 104), 'retstat': (True, 1244), 'block__2': (True, 1245)}, {'namelist': (True, 1247), 'NAME': (True, 1248), 'function': (True, 1249)}, {'if': (False, 42), '[': (False, 19), 'NAME': (False, 42), 'goto': (False, 42), '::': (False, 42), 'return': (False, 42), 'elseif': (False, 42), 'else': (False, 42), 'for': (False, 42), 'function': (False, 42), 'local': (False, 42), 'while': (False, 42), '(': (False, 19), 'EMBEDSTAT': (False, 42), ';': (False, 42), 'do': (False, 42), 'break': (False, 42), ':': (False, 19), 'end': (False, 42), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), 'repeat': (False, 42)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ':': (False, 20), ',': (False, 20), '<': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), ';': (False, 20), '..': (False, 20), '}': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '~=': (False, 20)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), '}': (False, 108), ',': (False, 108), '~=': (False, 108), '<': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), ';': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108)}, {'::': (False, 27), 'return': (False, 27), 'goto': (False, 27), 'if': (False, 27), 'repeat': (False, 27), 'NAME': (False, 27), 'for': (False, 27), 'function': (False, 27), 'while': (False, 27), '(': (False, 27), 'EMBEDSTAT': (False, 27), 'do': (False, 27), 'break': (False, 27), 'until': (False, 27), ';': (False, 27), 'local': (False, 27)}, {'if': (False, 41), 'return': (False, 41), 'function': (False, 41), '::': (False, 41), 'NAME': (False, 41), 'for': (False, 41), 'goto': (False, 41), 'local': (False, 41), 'while': (False, 41), '(': (False, 41), 'EMBEDSTAT': (False, 41), 'do': (False, 41), 'break': (False, 41), 'until': (False, 41), ';': (False, 41), 'repeat': (False, 41)}, {'::': (False, 53), 'NAME': (False, 53), 'function': (False, 53), 'if': (False, 53), 'return': (False, 53), 'for': (False, 53), 'goto': (False, 53), 'local': (False, 53), 'while': (False, 53), '(': (False, 53), 'EMBEDSTAT': (False, 53), 'do': (False, 53), 'break': (False, 53), 'until': (False, 53), ';': (False, 53), 'repeat': (False, 53)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 851)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'end': (False, 18), 'goto': (False, 18), 'break': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), 'function': (False, 18), 'while': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1282), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), ';': (False, 37), 'break': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), 'goto': (False, 37), 'while': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), 'end': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'::': (False, 84), 'return': (False, 84), 'goto': (False, 84), 'and': (False, 84), 'if': (False, 84), '%': (False, 84), 'repeat': (False, 84), 'NAME': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), 'for': (False, 84), 'function': (False, 84), '>=': (False, 84), 'while': (False, 84), 'or': (False, 84), '(': (False, 84), 'EMBEDSTAT': (False, 84), '^': (False, 84), 'end': (False, 84), 'do': (False, 84), 'break': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '..': (False, 84), '-': (False, 84), '/': (False, 84), 'local': (False, 84), '~=': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1284), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'::': (False, 82), 'return': (False, 82), 'or': (False, 82), 'and': (False, 82), 'if': (False, 82), '%': (False, 82), 'NAME': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'for': (False, 82), 'goto': (False, 82), 'local': (False, 82), 'while': (False, 82), '(': (False, 82), ';': (False, 82), 'EMBEDSTAT': (False, 82), '^': (False, 82), 'end': (False, 82), 'do': (False, 82), 'break': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), 'function': (False, 82), '/': (False, 82), 'repeat': (False, 82), '~=': (False, 82)}, {'::': (False, 80), 'NAME': (False, 80), 'or': (False, 80), 'and': (False, 80), 'if': (False, 80), '%': (False, 80), 'repeat': (False, 80), 'return': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'for': (False, 80), 'goto': (False, 80), 'while': (False, 80), '(': (False, 80), ';': (False, 80), 'EMBEDSTAT': (False, 80), '^': (False, 80), 'end': (False, 80), 'do': (False, 80), 'break': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), 'function': (False, 80), '/': (False, 80), 'local': (False, 80), '..': (False, 80)}, {'::': (False, 78), 'return': (False, 78), 'or': (False, 78), 'and': (False, 78), 'if': (False, 78), '%': (False, 78), 'NAME': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'for': (False, 78), 'function': (False, 78), 'local': (False, 78), 'while': (False, 78), '(': (False, 78), ';': (False, 78), 'EMBEDSTAT': (False, 78), '^': (False, 78), 'end': (False, 78), 'goto': (False, 78), 'do': (False, 78), 'break': (False, 78), '>': (False, 78), '*': (False, 78), '>=': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '..': (False, 78)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1288), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'if': (False, 83), '[': (True, 1290), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), ';': (False, 83), 'goto': (False, 83), 'break': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1291), '.': (True, 1293), '{': (True, 1294), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 1292), 'and': (False, 83), 'args': (True, 1295), '+': (False, 83), '<=': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '(': (True, 1289), '^': (False, 83), 'do': (False, 83), ':': (True, 1296), '>': (False, 83), 'end': (False, 83), '==': (False, 83), '~=': (False, 83), '..': (False, 83)}, {'::': (False, 81), 'return': (False, 81), 'function': (False, 81), 'and': (False, 81), 'if': (False, 81), '%': (False, 81), 'NAME': (False, 81), '+': (False, 81), '<=': (False, 81), 'end': (False, 81), '<': (False, 81), 'for': (False, 81), 'goto': (False, 81), 'local': (False, 81), 'while': (False, 81), 'or': (False, 81), '(': (False, 81), 'EMBEDSTAT': (False, 81), '^': (False, 81), ';': (False, 81), 'do': (False, 81), 'break': (False, 81), '>': (False, 81), '*': (False, 81), '>=': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), 'repeat': (False, 81), '..': (False, 81)}, {'::': (False, 77), 'NAME': (False, 77), 'goto': (False, 77), 'and': (False, 77), 'if': (False, 77), '%': (False, 77), 'repeat': (False, 77), 'return': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'for': (False, 77), 'function': (False, 77), 'while': (False, 77), 'or': (False, 77), '(': (False, 77), ';': (False, 77), 'EMBEDSTAT': (False, 77), '^': (False, 77), 'end': (False, 77), 'do': (False, 77), 'break': (False, 77), '>': (False, 77), '*': (False, 77), '>=': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '/': (False, 77), 'local': (False, 77), '..': (False, 77)}, {'::': (False, 79), 'NAME': (False, 79), 'goto': (False, 79), 'and': (False, 79), 'if': (False, 79), '%': (False, 79), 'return': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'for': (False, 79), 'function': (False, 79), 'local': (False, 79), 'while': (False, 79), 'or': (False, 79), '(': (False, 79), ';': (False, 79), 'EMBEDSTAT': (False, 79), '^': (False, 79), 'end': (False, 79), 'do': (False, 79), 'break': (False, 79), '>': (False, 79), '*': (False, 79), '>=': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '~=': (False, 79)}, {'funcbody': (True, 1297), '(': (True, 1298)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1299), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1300), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'if': (False, 48), 'NAME': (False, 48), 'or': (True, 1302), 'and': (True, 1303), '::': (False, 48), '%': (True, 1308), 'return': (False, 48), '+': (True, 1305), '<=': (True, 1301), 'end': (False, 48), '<': (True, 1313), 'for': (False, 48), 'goto': (False, 48), 'local': (False, 48), 'while': (False, 48), '(': (False, 48), 'EMBEDSTAT': (False, 48), '^': (True, 1312), ';': (False, 48), 'do': (False, 48), 'break': (False, 48), '>': (True, 1306), '*': (True, 1307), '>=': (True, 1304), '==': (True, 1309), '~=': (True, 1310), '-': (True, 1311), 'function': (False, 48), '/': (True, 1314), 'repeat': (False, 48), '..': (True, 1315)}, {'::': (False, 75), 'return': (False, 75), 'goto': (False, 75), 'and': (False, 75), 'if': (False, 75), '%': (False, 75), 'NAME': (False, 75), '+': (False, 75), '<=': (False, 75), 'end': (False, 75), '<': (False, 75), 'for': (False, 75), 'function': (False, 75), 'local': (False, 75), 'while': (False, 75), 'or': (False, 75), '(': (False, 75), 'EMBEDSTAT': (False, 75), '^': (False, 75), ';': (False, 75), 'do': (False, 75), 'break': (False, 75), '>': (False, 75), '*': (False, 75), '>=': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), 'repeat': (False, 75), '~=': (False, 75)}, {'::': (False, 76), 'return': (False, 76), 'or': (False, 76), 'and': (False, 76), 'if': (False, 76), '%': (False, 76), 'NAME': (False, 76), '+': (False, 76), '<=': (False, 76), 'end': (False, 76), '<': (False, 76), 'for': (False, 76), 'function': (False, 76), 'local': (False, 76), 'while': (False, 76), '(': (False, 76), 'EMBEDSTAT': (False, 76), '^': (False, 76), ';': (False, 76), 'goto': (False, 76), 'do': (False, 76), 'break': (False, 76), '>': (False, 76), '*': (False, 76), '>=': (False, 76), '==': (False, 76), '..': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'end': (False, 19), 'break': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), '<=': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'::': (False, 27), 'return': (False, 27), 'goto': (False, 27), 'if': (False, 27), 'repeat': (False, 27), 'NAME': (False, 27), 'for': (False, 27), 'function': (False, 27), 'while': (False, 27), '(': (False, 27), 'EMBEDSTAT': (False, 27), 'end': (False, 27), 'do': (False, 27), 'break': (False, 27), ';': (False, 27), 'local': (False, 27)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1154), '~=': (True, 414), 'or': (True, 419)}, {')': (True, 926)}, {'::': (False, 46), 'NAME': (False, 46), 'function': (False, 46), 'if': (False, 46), 'return': (False, 46), 'for': (False, 46), 'goto': (False, 46), 'local': (False, 46), 'while': (False, 46), '(': (False, 46), 'EMBEDSTAT': (False, 46), ';': (False, 46), 'do': (False, 46), 'break': (False, 46), 'end': (False, 46), 'repeat': (False, 46)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1270), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'if': (False, 39), '[': (False, 39), 'goto': (False, 39), '%': (False, 39), 'return': (False, 39), 'for': (False, 39), 'local': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'break': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'repeat': (False, 39), '::': (False, 39), 'NAME': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'function': (False, 39), 'while': (False, 39), '(': (False, 39), 'EOF': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '..': (False, 39), '~=': (False, 39)}, {')': (True, 953)}, {'}': (True, 1212)}, {'(': (True, 139), 'args': (True, 1219), 'tableconstructor': (True, 142), 'STRING': (True, 141), '{': (True, 144)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'}': (True, 1429)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'end': (False, 18), 'goto': (False, 18), 'break': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), 'function': (False, 18), 'while': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 743), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), ';': (False, 37), 'break': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), 'goto': (False, 37), 'while': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), 'end': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'if': (False, 84), 'or': (False, 84), '%': (False, 84), 'NAME': (False, 84), 'for': (False, 84), 'EMBEDSTAT': (False, 84), 'end': (False, 84), 'break': (False, 84), '*': (False, 84), '>=': (False, 84), '-': (False, 84), '/': (False, 84), 'repeat': (False, 84), '::': (False, 84), 'return': (False, 84), 'and': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), 'goto': (False, 84), 'while': (False, 84), '<=': (False, 84), '(': (False, 84), '^': (False, 84), 'local': (False, 84), '>': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), 'do': (False, 84), 'function': (False, 84), '..': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 769), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 82), 'or': (False, 82), '%': (False, 82), 'repeat': (False, 82), 'return': (False, 82), 'for': (False, 82), 'EMBEDSTAT': (False, 82), ';': (False, 82), 'break': (False, 82), '*': (False, 82), '>=': (False, 82), '-': (False, 82), '/': (False, 82), 'local': (False, 82), '::': (False, 82), 'NAME': (False, 82), 'and': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'goto': (False, 82), 'while': (False, 82), ',': (False, 82), '(': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), 'end': (False, 82), '==': (False, 82), '~=': (False, 82), 'function': (False, 82), '..': (False, 82)}, {'if': (False, 80), 'goto': (False, 80), '>=': (False, 80), 'NAME': (False, 80), 'for': (False, 80), 'local': (False, 80), 'or': (False, 80), 'EMBEDSTAT': (False, 80), 'end': (False, 80), 'break': (False, 80), '*': (False, 80), '%': (False, 80), '-': (False, 80), '/': (False, 80), 'repeat': (False, 80), '::': (False, 80), 'return': (False, 80), 'and': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'function': (False, 80), 'while': (False, 80), ',': (False, 80), '(': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), ';': (False, 80), '==': (False, 80), '..': (False, 80), '~=': (False, 80)}, {'if': (False, 78), 'or': (False, 78), '%': (False, 78), 'NAME': (False, 78), 'for': (False, 78), 'local': (False, 78), 'EMBEDSTAT': (False, 78), ';': (False, 78), 'goto': (False, 78), 'break': (False, 78), '*': (False, 78), '>=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '::': (False, 78), 'return': (False, 78), 'and': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'function': (False, 78), 'while': (False, 78), ',': (False, 78), '(': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), 'end': (False, 78), '==': (False, 78), '..': (False, 78), '~=': (False, 78)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 776), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'if': (False, 83), '[': (True, 778), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), ';': (False, 83), 'goto': (False, 83), 'break': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 779), '.': (True, 781), '{': (True, 782), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 780), 'and': (False, 83), 'args': (True, 783), '+': (False, 83), ',': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '<=': (False, 83), '(': (True, 777), '^': (False, 83), 'do': (False, 83), ':': (True, 784), '>': (False, 83), 'end': (False, 83), '==': (False, 83), '~=': (False, 83), '..': (False, 83)}, {'if': (False, 81), 'or': (False, 81), '%': (False, 81), 'repeat': (False, 81), 'NAME': (False, 81), 'for': (False, 81), 'EMBEDSTAT': (False, 81), ';': (False, 81), 'break': (False, 81), '*': (False, 81), '>=': (False, 81), '-': (False, 81), '/': (False, 81), 'local': (False, 81), '::': (False, 81), 'return': (False, 81), 'and': (False, 81), '+': (False, 81), ',': (False, 81), '<': (False, 81), 'goto': (False, 81), 'while': (False, 81), '<=': (False, 81), '(': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), 'end': (False, 81), '==': (False, 81), '~=': (False, 81), 'function': (False, 81), '..': (False, 81)}, {'if': (False, 77), 'goto': (False, 77), '%': (False, 77), 'return': (False, 77), 'for': (False, 77), 'local': (False, 77), 'or': (False, 77), 'EMBEDSTAT': (False, 77), ';': (False, 77), 'break': (False, 77), '*': (False, 77), '>=': (False, 77), '-': (False, 77), '/': (False, 77), 'repeat': (False, 77), '::': (False, 77), 'NAME': (False, 77), 'and': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'function': (False, 77), 'while': (False, 77), ',': (False, 77), '(': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), 'end': (False, 77), '==': (False, 77), '~=': (False, 77), '..': (False, 77)}, {'if': (False, 79), 'function': (False, 79), '>=': (False, 79), 'NAME': (False, 79), 'for': (False, 79), 'local': (False, 79), 'or': (False, 79), 'EMBEDSTAT': (False, 79), ';': (False, 79), 'break': (False, 79), '*': (False, 79), '%': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '::': (False, 79), 'return': (False, 79), 'and': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'goto': (False, 79), 'while': (False, 79), ',': (False, 79), '(': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), 'end': (False, 79), '==': (False, 79), '~=': (False, 79), '..': (False, 79)}, {'if': (False, 41), 'return': (False, 41), 'function': (False, 41), '::': (False, 41), 'NAME': (False, 41), 'for': (False, 41), 'goto': (False, 41), 'local': (False, 41), 'while': (False, 41), '(': (False, 41), 'EMBEDSTAT': (False, 41), ';': (False, 41), 'do': (False, 41), 'break': (False, 41), 'end': (False, 41), 'repeat': (False, 41)}, {'funcbody': (True, 789), '(': (True, 790)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 792), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 812), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'if': (False, 29), 'or': (True, 815), '%': (True, 823), 'return': (False, 29), 'for': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'end': (False, 29), 'break': (False, 29), '*': (True, 822), '>=': (True, 818), '-': (True, 827), '/': (True, 829), 'repeat': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 816), '+': (True, 819), ',': (True, 817), '<': (True, 820), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 814), '(': (False, 29), '^': (True, 826), 'do': (False, 29), '>': (True, 821), ';': (False, 29), '==': (True, 825), '~=': (True, 824), 'explist__1': (True, 828), 'function': (False, 29), '..': (True, 830)}, {'if': (False, 75), 'or': (False, 75), '%': (False, 75), 'repeat': (False, 75), 'return': (False, 75), 'for': (False, 75), 'EMBEDSTAT': (False, 75), 'end': (False, 75), 'break': (False, 75), '*': (False, 75), '>=': (False, 75), '-': (False, 75), '/': (False, 75), 'local': (False, 75), '::': (False, 75), 'NAME': (False, 75), 'and': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), 'goto': (False, 75), 'while': (False, 75), '<=': (False, 75), '(': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), ';': (False, 75), '==': (False, 75), '~=': (False, 75), 'function': (False, 75), '..': (False, 75)}, {'if': (False, 76), 'or': (False, 76), '%': (False, 76), 'return': (False, 76), 'for': (False, 76), 'EMBEDSTAT': (False, 76), 'end': (False, 76), 'break': (False, 76), '*': (False, 76), '>=': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '::': (False, 76), 'NAME': (False, 76), 'and': (False, 76), '+': (False, 76), ',': (False, 76), '<': (False, 76), 'goto': (False, 76), 'while': (False, 76), '<=': (False, 76), '(': (False, 76), '^': (False, 76), 'local': (False, 76), '>': (False, 76), ';': (False, 76), '==': (False, 76), '..': (False, 76), 'do': (False, 76), 'function': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'end': (False, 19), 'break': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'(': (True, 219), 'args': (True, 1088), 'tableconstructor': (True, 222), 'STRING': (True, 221), '{': (True, 224)}, {'until': (False, 0)}, {'until': (False, 74)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1360), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1361), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ',': (False, 13), '<': (False, 13), 'until': (False, 13), '<=': (False, 13), '(': (False, 13), '^': (False, 13), ';': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), 'until': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), ';': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1374)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1376), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), '>=': (False, 107), 'until': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), '..': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), ';': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 1385)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 850), 'or': (True, 346)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), '>=': (False, 60), 'until': (False, 60), '<=': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), ';': (False, 60), '==': (False, 60), '..': (False, 60), '-': (False, 60), '/': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 900)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), '%': (False, 100), 'until': (False, 100), '<=': (False, 100), '^': (True, 795), '>': (False, 100), '*': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), '>=': (False, 84), '<=': (False, 84), '^': (False, 84), 'end': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), '/': (False, 84), '..': (False, 84)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), 'end': (False, 37), '<': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), ';': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {'retstat__2': (True, 852), 'end': (False, 1), ';': (True, 853)}, {'[': (True, 855), 'tableconstructor': (True, 857), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 860), '+': (False, 83), ',': (False, 83), '<': (False, 83), '%': (False, 83), '<=': (False, 83), '(': (True, 854), '^': (False, 83), 'end': (False, 83), '..': (False, 83), ':': (True, 861), '>': (False, 83), '*': (False, 83), ';': (False, 83), 'STRING': (True, 856), '==': (False, 83), '.': (True, 858), '{': (True, 859), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), '>=': (False, 77), '<=': (False, 77), '^': (False, 77), ';': (False, 77), '>': (False, 77), '*': (False, 77), 'end': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '/': (False, 77), '..': (False, 77)}, {'funcbody': (True, 862), '(': (True, 863)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 864), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), '%': (False, 76), ',': (False, 76), '^': (False, 76), ';': (False, 76), '>': (False, 76), '*': (False, 76), 'end': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '%': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), '<=': (False, 18), '(': (False, 18), ';': (False, 18), '^': (False, 18), 'end': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '>=': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 865), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), '>=': (False, 82), '<=': (False, 82), '^': (False, 82), ';': (False, 82), '>': (False, 82), '*': (False, 82), 'end': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), '>=': (False, 80), ',': (False, 80), '^': (False, 80), ';': (False, 80), '>': (False, 80), '*': (False, 80), 'end': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), '>=': (False, 78), ',': (False, 78), '^': (False, 78), 'end': (False, 78), '>': (False, 78), '*': (False, 78), ';': (False, 78), '==': (False, 78), '..': (False, 78), '-': (False, 78), '/': (False, 78), '~=': (False, 78)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 866), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), '>=': (False, 81), ',': (False, 81), '^': (False, 81), ';': (False, 81), '>': (False, 81), '*': (False, 81), 'end': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), '>=': (False, 79), '<=': (False, 79), '^': (False, 79), 'end': (False, 79), '>': (False, 79), '*': (False, 79), ';': (False, 79), '==': (False, 79), '~=': (False, 79), '-': (False, 79), '/': (False, 79), '..': (False, 79)}, {'end': (False, 16), ';': (False, 16)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 875), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 877), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {',': (True, 883), '*': (True, 888), 'or': (True, 881), 'and': (True, 882), ';': (False, 29), '%': (True, 884), '..': (True, 896), '+': (True, 885), '>': (True, 887), '<=': (True, 880), '>=': (True, 894), 'end': (False, 29), '<': (True, 886), '^': (True, 891), '-': (True, 892), '==': (True, 890), 'explist__1': (True, 893), '/': (True, 895), '~=': (True, 889)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), '>=': (False, 75), '<=': (False, 75), '^': (False, 75), 'end': (False, 75), '>': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), '~=': (False, 75)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), ',': (False, 19), 'end': (False, 19), '<': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), ';': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'}': (True, 1203)}, {'NAME': (True, 1225)}, {'::': (False, 3), 'NAME': (False, 3), 'function': (False, 3), 'if': (False, 3), 'return': (False, 3), 'for': (False, 3), 'goto': (False, 3), 'local': (False, 3), '=': (False, 3), 'while': (False, 3), '(': (False, 3), 'EMBEDSTAT': (False, 3), 'end': (False, 3), 'do': (False, 3), 'break': (False, 3), ';': (False, 3), 'repeat': (False, 3)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 961), 'or': (True, 346)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), 'explist': (True, 1005), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 728), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'::': (False, 54), 'return': (False, 54), 'function': (False, 54), 'if': (False, 54), 'repeat': (False, 54), 'NAME': (False, 54), 'for': (False, 54), 'goto': (False, 54), 'while': (False, 54), '(': (False, 54), 'EMBEDSTAT': (False, 54), 'end': (False, 54), 'do': (False, 54), 'break': (False, 54), ';': (False, 54), 'local': (False, 54)}, {'funcbody': (True, 1030), '(': (True, 922)}, {'if': (False, 101), 'goto': (False, 101), '%': (False, 101), 'repeat': (False, 101), 'NAME': (False, 101), 'for': (False, 101), 'or': (False, 101), 'EMBEDSTAT': (False, 101), ';': (False, 101), 'break': (False, 101), '*': (False, 101), '>=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '::': (False, 101), 'return': (False, 101), 'and': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'function': (False, 101), 'while': (False, 101), ',': (False, 101), '(': (False, 101), '^': (True, 826), 'do': (False, 101), '>': (False, 101), 'end': (False, 101), '==': (False, 101), '~=': (False, 101), '..': (False, 101)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1068), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1070), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'repeat': (False, 13), 'NAME': (False, 13), 'for': (False, 13), 'EMBEDSTAT': (False, 13), 'end': (False, 13), 'break': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'local': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'while': (False, 13), ',': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '..': (False, 13), 'function': (False, 13), '~=': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'end': (False, 12), 'break': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), 'goto': (False, 12), 'while': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1075)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1077), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '%': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'end': (False, 107), 'goto': (False, 107), 'break': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 1080)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), '>=': (False, 101), 'until': (False, 101), ',': (False, 101), '^': (True, 795), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'}': (True, 1158)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 1160)}, {')': (False, 24)}, {'if': (False, 60), 'goto': (False, 60), '%': (False, 60), 'repeat': (False, 60), 'return': (False, 60), 'for': (False, 60), 'or': (False, 60), 'EMBEDSTAT': (False, 60), ';': (False, 60), 'break': (False, 60), '*': (False, 60), '>=': (False, 60), '-': (False, 60), '/': (False, 60), 'local': (False, 60), '::': (False, 60), 'NAME': (False, 60), 'and': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), 'function': (False, 60), 'while': (False, 60), '<=': (False, 60), '(': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), 'end': (False, 60), '==': (False, 60), '~=': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1165)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), '%': (False, 102), 'until': (False, 102), '<=': (False, 102), '^': (True, 795), '>': (False, 102), '*': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'if': (False, 102), 'goto': (False, 102), '>=': (False, 102), 'NAME': (False, 102), 'for': (False, 102), 'local': (False, 102), 'or': (False, 102), 'EMBEDSTAT': (False, 102), 'end': (False, 102), 'break': (False, 102), '*': (False, 102), '%': (False, 102), '-': (False, 102), '/': (False, 102), 'repeat': (False, 102), '::': (False, 102), 'return': (False, 102), 'and': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'function': (False, 102), 'while': (False, 102), ',': (False, 102), '(': (False, 102), '^': (True, 826), 'do': (False, 102), '>': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '~=': (False, 102)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1424), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1425), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1427), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1428), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1430), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1431), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1433), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1434), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1435), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1437), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1440), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1442), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1444), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {';': (False, 71), 'until': (False, 71)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1447), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1449), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'var': (True, 284), '(': (True, 285), 'tableconstructor': (True, 276), 'function': (True, 281), 'NUMBER': (True, 288), 'EMBEDEXPR': (True, 287), 'NAME': (True, 277), '#': (True, 289), 'prefixexp': (True, 279), '...': (True, 290), 'true': (True, 280), 'STRING': (True, 291), '{': (True, 293), '-': (True, 294), 'not': (True, 282), 'exp': (True, 1453), 'functioncall': (True, 297), 'nil': (True, 296), 'false': (True, 283), 'functiondef': (True, 286)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 334), '+': (True, 335), '<=': (False, 89), '<': (False, 89), ')': (False, 89), '^': (True, 332), '>': (False, 89), '*': (True, 337), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 977), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'if': (False, 100), 'goto': (False, 100), '>=': (False, 100), 'repeat': (False, 100), 'return': (False, 100), 'for': (False, 100), 'or': (False, 100), 'EMBEDSTAT': (False, 100), 'end': (False, 100), 'break': (False, 100), '*': (False, 100), '%': (False, 100), '-': (False, 100), '/': (False, 100), 'local': (False, 100), '::': (False, 100), 'NAME': (False, 100), 'and': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'function': (False, 100), 'while': (False, 100), ',': (False, 100), '(': (False, 100), '^': (True, 826), 'do': (False, 100), '>': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '..': (False, 100)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), ')': (False, 99), '^': (True, 332), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 1524), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 1526), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 1527), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 834), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 836), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 837), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 839), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 841), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 843), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 845), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 846), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 847), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 848), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 849), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'::': (False, 71), 'NAME': (False, 71), 'function': (False, 71), 'if': (False, 71), 'repeat': (False, 71), 'return': (False, 71), 'for': (False, 71), 'goto': (False, 71), 'while': (False, 71), '(': (False, 71), 'EMBEDSTAT': (False, 71), ';': (False, 71), 'do': (False, 71), 'break': (False, 71), 'end': (False, 71), 'local': (False, 71)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 928), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {'var': (True, 711), '(': (True, 712), 'NAME': (True, 713), 'tableconstructor': (True, 714), 'function': (True, 725), 'NUMBER': (True, 718), 'EMBEDEXPR': (True, 717), 'functiondef': (True, 716), '#': (True, 719), 'prefixexp': (True, 720), '...': (True, 721), 'true': (True, 722), 'STRING': (True, 723), '{': (True, 715), '-': (True, 726), 'not': (True, 727), 'exp': (True, 930), 'nil': (True, 729), 'false': (True, 730), 'functioncall': (True, 731)}, {')': (False, 86), '*': (True, 337), 'or': (False, 86), '^': (True, 332), '%': (True, 334), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), 'and': (False, 86), '..': (True, 345)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), ')': (False, 98), '^': (True, 332), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'if': (False, 11), '[': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), '::': (False, 11), 'repeat': (False, 11), 'return': (False, 11), 'for': (False, 11), 'function': (False, 11), 'while': (False, 11), '(': (False, 11), 'EMBEDSTAT': (False, 11), 'end': (False, 11), 'do': (False, 11), 'break': (False, 11), ':': (False, 11), ';': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), 'local': (False, 11)}, {'if': (False, 29), 'or': (True, 815), '%': (True, 823), 'return': (False, 29), 'for': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'end': (False, 29), 'break': (False, 29), '*': (True, 822), '>=': (True, 818), '-': (True, 827), '/': (True, 829), 'repeat': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 816), '+': (True, 819), ',': (True, 817), '<': (True, 820), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 814), '(': (False, 29), '^': (True, 826), 'do': (False, 29), '>': (True, 821), ';': (False, 29), '==': (True, 825), '~=': (True, 824), 'explist__1': (True, 1215), 'function': (False, 29), '..': (True, 830)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 334), '+': (False, 94), '<=': (False, 94), '<': (False, 94), ')': (False, 94), '^': (True, 332), '>': (False, 94), '*': (True, 337), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 344), '~=': (False, 94)}, {'if': (False, 90), 'or': (False, 90), '%': (True, 823), 'return': (False, 90), 'for': (False, 90), 'local': (False, 90), 'EMBEDSTAT': (False, 90), ';': (False, 90), 'break': (False, 90), '*': (True, 822), '>=': (False, 90), '-': (True, 827), '/': (True, 829), 'repeat': (False, 90), '::': (False, 90), 'NAME': (False, 90), 'and': (False, 90), '+': (True, 819), ',': (False, 90), '<': (False, 90), 'goto': (False, 90), 'while': (False, 90), '<=': (False, 90), '(': (False, 90), '^': (True, 826), 'do': (False, 90), '>': (False, 90), 'end': (False, 90), '==': (False, 90), '~=': (False, 90), 'function': (False, 90), '..': (True, 830)}, {'if': (False, 94), 'or': (False, 94), '%': (True, 823), 'repeat': (False, 94), 'return': (False, 94), 'for': (False, 94), 'EMBEDSTAT': (False, 94), 'end': (False, 94), 'break': (False, 94), '*': (True, 822), '>=': (False, 94), '-': (False, 94), '/': (True, 829), 'local': (False, 94), '::': (False, 94), 'NAME': (False, 94), 'and': (False, 94), '+': (False, 94), ',': (False, 94), '<': (False, 94), 'goto': (False, 94), 'while': (False, 94), '<=': (False, 94), '(': (False, 94), '^': (True, 826), 'do': (False, 94), '>': (False, 94), ';': (False, 94), '==': (False, 94), '~=': (False, 94), 'function': (False, 94), '..': (False, 94)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 334), '+': (True, 335), '<=': (False, 88), '<': (False, 88), ')': (False, 88), '^': (True, 332), '>': (False, 88), '*': (True, 337), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'if': (False, 87), 'goto': (False, 87), '%': (True, 823), 'repeat': (False, 87), 'NAME': (False, 87), 'for': (False, 87), 'or': (False, 87), 'EMBEDSTAT': (False, 87), ';': (False, 87), 'break': (False, 87), '*': (True, 822), '>=': (False, 87), '-': (True, 827), '/': (True, 829), 'local': (False, 87), '::': (False, 87), 'return': (False, 87), 'and': (False, 87), '+': (True, 819), ',': (False, 87), '<': (False, 87), 'function': (False, 87), 'while': (False, 87), '<=': (False, 87), '(': (False, 87), '^': (True, 826), 'do': (False, 87), '>': (False, 87), 'end': (False, 87), '==': (False, 87), '~=': (False, 87), '..': (True, 830)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), ')': (False, 96), '^': (True, 332), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'if': (False, 88), 'or': (False, 88), '%': (True, 823), 'repeat': (False, 88), 'return': (False, 88), 'for': (False, 88), 'EMBEDSTAT': (False, 88), 'end': (False, 88), 'goto': (False, 88), 'break': (False, 88), '*': (True, 822), '>=': (False, 88), '-': (True, 827), '/': (True, 829), 'local': (False, 88), '::': (False, 88), 'NAME': (False, 88), 'and': (False, 88), '+': (True, 819), '<=': (False, 88), '<': (False, 88), 'function': (False, 88), 'while': (False, 88), ',': (False, 88), '(': (False, 88), '^': (True, 826), 'do': (False, 88), '>': (False, 88), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '..': (True, 830)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 334), '+': (True, 335), '<=': (False, 91), '<': (False, 91), ')': (False, 91), '^': (True, 332), '>': (False, 91), '*': (True, 337), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'if': (False, 96), 'goto': (False, 96), '>=': (False, 96), 'return': (False, 96), 'for': (False, 96), 'local': (False, 96), 'or': (False, 96), 'EMBEDSTAT': (False, 96), ';': (False, 96), 'break': (False, 96), '*': (False, 96), '%': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '::': (False, 96), 'NAME': (False, 96), 'and': (False, 96), '+': (False, 96), ',': (False, 96), '<': (False, 96), 'function': (False, 96), 'while': (False, 96), '<=': (False, 96), '(': (False, 96), '^': (True, 826), 'do': (False, 96), '>': (False, 96), 'end': (False, 96), '==': (False, 96), '..': (False, 96), '~=': (False, 96)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 334), '+': (True, 335), '<=': (False, 87), '<': (False, 87), ')': (False, 87), '^': (True, 332), '>': (False, 87), '*': (True, 337), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'if': (False, 98), 'goto': (False, 98), '>=': (False, 98), 'return': (False, 98), 'for': (False, 98), 'local': (False, 98), 'or': (False, 98), 'EMBEDSTAT': (False, 98), ';': (False, 98), 'break': (False, 98), '*': (False, 98), '%': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '::': (False, 98), 'NAME': (False, 98), 'and': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), 'function': (False, 98), 'while': (False, 98), '<=': (False, 98), '(': (False, 98), '^': (True, 826), 'do': (False, 98), '>': (False, 98), 'end': (False, 98), '==': (False, 98), '~=': (False, 98), '..': (False, 98)}, {'if': (False, 91), 'function': (False, 91), '%': (True, 823), 'return': (False, 91), 'for': (False, 91), 'local': (False, 91), 'or': (False, 91), 'EMBEDSTAT': (False, 91), ';': (False, 91), 'break': (False, 91), '*': (True, 822), '>=': (False, 91), '-': (True, 827), '/': (True, 829), 'repeat': (False, 91), '::': (False, 91), 'NAME': (False, 91), 'and': (False, 91), '+': (True, 819), ',': (False, 91), '<': (False, 91), 'goto': (False, 91), 'while': (False, 91), '<=': (False, 91), '(': (False, 91), '^': (True, 826), 'do': (False, 91), '>': (False, 91), 'end': (False, 91), '==': (False, 91), '~=': (False, 91), '..': (True, 830)}, {'if': (False, 92), 'or': (False, 92), '%': (True, 823), 'repeat': (False, 92), 'return': (False, 92), 'for': (False, 92), 'EMBEDSTAT': (False, 92), 'end': (False, 92), 'break': (False, 92), '*': (True, 822), '>=': (False, 92), '-': (True, 827), '/': (True, 829), 'local': (False, 92), '::': (False, 92), 'NAME': (False, 92), 'and': (False, 92), '+': (True, 819), ',': (False, 92), '<': (False, 92), 'goto': (False, 92), 'while': (False, 92), '<=': (False, 92), '(': (False, 92), '^': (True, 826), 'do': (False, 92), '>': (False, 92), ';': (False, 92), '==': (False, 92), '~=': (False, 92), 'function': (False, 92), '..': (True, 830)}, {'if': (False, 99), 'or': (False, 99), '>=': (False, 99), 'repeat': (False, 99), 'NAME': (False, 99), 'for': (False, 99), 'EMBEDSTAT': (False, 99), ';': (False, 99), 'break': (False, 99), '*': (False, 99), '%': (False, 99), '-': (False, 99), '/': (False, 99), 'local': (False, 99), '::': (False, 99), 'return': (False, 99), 'and': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), 'goto': (False, 99), 'while': (False, 99), ',': (False, 99), '(': (False, 99), '^': (True, 826), 'do': (False, 99), '>': (False, 99), 'end': (False, 99), '==': (False, 99), '..': (False, 99), 'function': (False, 99), '~=': (False, 99)}, {'if': (False, 95), 'or': (False, 95), '%': (True, 823), 'repeat': (False, 95), 'return': (False, 95), 'for': (False, 95), 'EMBEDSTAT': (False, 95), ';': (False, 95), 'goto': (False, 95), 'break': (False, 95), '*': (True, 822), '>=': (False, 95), '-': (False, 95), '/': (True, 829), 'local': (False, 95), '::': (False, 95), 'NAME': (False, 95), 'and': (False, 95), '+': (False, 95), ',': (False, 95), '<': (False, 95), 'function': (False, 95), 'while': (False, 95), '<=': (False, 95), '(': (False, 95), '^': (True, 826), 'do': (False, 95), '>': (False, 95), 'end': (False, 95), '==': (False, 95), '~=': (False, 95), '..': (False, 95)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'end': (False, 20), 'break': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), 'function': (False, 20), 'while': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {')': (True, 1055)}, {'end': (False, 74)}, {'end': (False, 0)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1062), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1060), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ',': (False, 13), 'end': (False, 13), '<': (False, 13), '<=': (False, 13), '(': (False, 13), '^': (False, 13), ';': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), '<=': (False, 12), '(': (False, 12), ';': (False, 12), '^': (False, 12), 'end': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1148)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1149), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), '>=': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), 'end': (False, 107), '..': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), ';': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 1151)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), '>=': (False, 60), '<=': (False, 60), '^': (False, 60), 'end': (False, 60), '>': (False, 60), '*': (False, 60), ';': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1152)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), '%': (False, 100), '<=': (False, 100), '^': (True, 891), ';': (False, 100), '>': (False, 100), '*': (False, 100), 'end': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1150), 'or': (True, 346)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), '>=': (False, 101), ',': (False, 101), '^': (True, 891), 'end': (False, 101), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1317), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1318), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ',': (False, 13), '<': (False, 13), ')': (False, 13), '<=': (False, 13), '(': (False, 13), '^': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), ')': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '..': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12), '.': (False, 12)}, {'NAME': (True, 1340)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1343), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), ')': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '==': (False, 107), '..': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107), '.': (False, 107)}, {'NAME': (True, 1346)}, {'}': (True, 1533)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), '}': (False, 11), ',': (False, 11), '<': (False, 11), '>=': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), ';': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), '%': (False, 102), '<=': (False, 102), '^': (True, 891), 'end': (False, 102), '>': (False, 102), '*': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), ')': (False, 60), '<=': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1269)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1271), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1272), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1273), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1274), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1275), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1276), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1277), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1278), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1279), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1280), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1281), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1383), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1387), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'end': (False, 71), ';': (False, 71)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1390), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1392), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'var': (True, 755), '(': (True, 756), 'tableconstructor': (True, 747), 'function': (True, 752), 'NUMBER': (True, 759), 'EMBEDEXPR': (True, 758), 'NAME': (True, 748), '#': (True, 760), 'prefixexp': (True, 750), '...': (True, 761), 'true': (True, 751), 'STRING': (True, 762), '{': (True, 764), '-': (True, 765), 'not': (True, 753), 'exp': (True, 1393), 'functioncall': (True, 768), 'nil': (True, 767), 'false': (True, 754), 'functiondef': (True, 757)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), ')': (False, 100), '<=': (False, 100), '^': (True, 906), '>': (False, 100), '*': (False, 100), '%': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), ']': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1432), 'or': (True, 346)}, {')': (True, 1473)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), ')': (False, 101), ',': (False, 101), '^': (True, 906), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'}': (True, 1285)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), ')': (False, 102), '<=': (False, 102), '^': (True, 906), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1438), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1439), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1441), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1443), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1445), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1446), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1448), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1452), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1462), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1463), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1466), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1468), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1469), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {')': (False, 71)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1472), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1474), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'var': (True, 390), '(': (True, 391), 'tableconstructor': (True, 382), 'function': (True, 387), 'NUMBER': (True, 394), 'EMBEDEXPR': (True, 393), 'NAME': (True, 383), '#': (True, 395), 'prefixexp': (True, 384), '...': (True, 396), 'true': (True, 385), 'STRING': (True, 397), '{': (True, 399), '-': (True, 400), 'not': (True, 388), 'exp': (True, 1475), 'functioncall': (True, 403), 'nil': (True, 402), 'false': (True, 389), 'functiondef': (True, 392)}, {'if': (False, 52), 'return': (False, 52), 'function': (False, 52), '::': (False, 52), 'repeat': (False, 52), 'NAME': (False, 52), 'for': (False, 52), 'goto': (False, 52), 'while': (False, 52), '(': (False, 52), 'EMBEDSTAT': (False, 52), 'end': (False, 52), 'do': (False, 52), 'break': (False, 52), ';': (False, 52), 'local': (False, 52)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1479)}, {'::': (True, 655), 'varlist': (True, 656), 'repeat': (True, 657), 'function': (True, 658), 'if': (True, 659), 'NAME': (True, 6), 'prefixexp': (True, 660), 'elseif': (False, 63), 'else': (False, 63), 'for': (True, 661), 'goto': (True, 662), 'label': (True, 663), 'while': (True, 664), 'return': (False, 63), 'EMBEDSTAT': (True, 665), 'var': (True, 13), '(': (True, 14), 'stat': (True, 666), 'block': (True, 1500), 'end': (False, 63), 'do': (True, 668), 'break': (True, 669), ';': (True, 670), 'block__1': (True, 671), 'local': (True, 672), 'functioncall': (True, 673)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1520), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), ')': (False, 97), '^': (True, 332), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'NAME': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), 'break': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'return': (False, 11), 'and': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '(': (False, 11), 'EOF': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), ';': (False, 11), '==': (False, 11), '~=': (False, 11), '..': (False, 11)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 334), '+': (True, 335), '<=': (False, 93), '<': (False, 93), ')': (False, 93), '^': (True, 332), '>': (False, 93), '*': (True, 337), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 341), '/': (True, 344), '..': (True, 345)}, {'if': (False, 97), 'function': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), 'for': (False, 97), 'or': (False, 97), 'EMBEDSTAT': (False, 97), ';': (False, 97), 'break': (False, 97), '*': (False, 97), '%': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '::': (False, 97), 'NAME': (False, 97), 'and': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'goto': (False, 97), 'while': (False, 97), ',': (False, 97), '(': (False, 97), '^': (True, 826), 'do': (False, 97), '>': (False, 97), 'end': (False, 97), '==': (False, 97), '~=': (False, 97), '..': (False, 97)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '..': (True, 345), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (False, 85), '~=': (True, 338), 'or': (False, 85)}, {'if': (False, 93), 'or': (False, 93), '%': (True, 823), 'repeat': (False, 93), 'NAME': (False, 93), 'for': (False, 93), 'EMBEDSTAT': (False, 93), ';': (False, 93), 'goto': (False, 93), 'break': (False, 93), '*': (True, 822), '>=': (False, 93), '-': (True, 827), '/': (True, 829), 'local': (False, 93), '::': (False, 93), 'return': (False, 93), 'and': (False, 93), '+': (True, 819), ',': (False, 93), '<': (False, 93), 'function': (False, 93), 'while': (False, 93), '<=': (False, 93), '(': (False, 93), '^': (True, 826), 'do': (False, 93), '>': (False, 93), 'end': (False, 93), '==': (False, 93), '~=': (False, 93), '..': (True, 830)}, {'or': (False, 84), 'and': (False, 84), '>=': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), '%': (False, 84), '<=': (False, 84), 'EOF': (False, 84), '^': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '..': (False, 84), '-': (False, 84), '/': (False, 84), '~=': (False, 84)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), '<': (False, 37), ',': (False, 37), '(': (False, 37), 'EOF': (False, 37), '^': (False, 37), ';': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), '..': (False, 37)}, {';': (True, 1450), 'EOF': (False, 1), 'retstat__2': (True, 1451)}, {'[': (True, 1455), 'tableconstructor': (True, 1457), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 1460), '+': (False, 83), ',': (False, 83), '<': (False, 83), '%': (False, 83), '<=': (False, 83), '(': (True, 1454), 'EOF': (False, 83), '^': (False, 83), '..': (False, 83), ':': (True, 1461), '>': (False, 83), '*': (False, 83), ';': (False, 83), 'STRING': (True, 1456), '==': (False, 83), '.': (True, 1458), '{': (True, 1459), '-': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), '>=': (False, 77), '<=': (False, 77), 'EOF': (False, 77), '^': (False, 77), '>': (False, 77), '*': (False, 77), ';': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '/': (False, 77), '..': (False, 77)}, {'funcbody': (True, 1464), '(': (True, 1465)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1467), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), '%': (False, 76), ',': (False, 76), 'EOF': (False, 76), '^': (False, 76), '>': (False, 76), '*': (False, 76), ';': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '%': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), '<=': (False, 18), '(': (False, 18), 'EOF': (False, 18), '^': (False, 18), ';': (False, 18), '..': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '>=': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), '~=': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1470), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), '<': (False, 82), '>=': (False, 82), '<=': (False, 82), 'EOF': (False, 82), '^': (False, 82), '>': (False, 82), '*': (False, 82), ';': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), '>=': (False, 80), ',': (False, 80), 'EOF': (False, 80), '^': (False, 80), '>': (False, 80), '*': (False, 80), ';': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '/': (False, 80), '..': (False, 80)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), '>=': (False, 78), ',': (False, 78), 'EOF': (False, 78), '^': (False, 78), '>': (False, 78), '*': (False, 78), ';': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), '..': (False, 78)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1477), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), '>=': (False, 81), ',': (False, 81), 'EOF': (False, 81), '^': (False, 81), '>': (False, 81), '*': (False, 81), ';': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), ',': (False, 79), '<': (False, 79), '>=': (False, 79), '<=': (False, 79), 'EOF': (False, 79), '^': (False, 79), '>': (False, 79), '*': (False, 79), ';': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), '~=': (False, 79)}, {';': (False, 16), 'EOF': (False, 16)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1478), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1480), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {',': (True, 1486), '*': (True, 1490), '^': (True, 1485), 'and': (True, 1484), ';': (False, 29), '%': (True, 1487), '+': (True, 1488), '>': (True, 1489), '<=': (True, 1483), '>=': (True, 1491), '~=': (True, 1498), 'EOF': (False, 29), '<': (True, 1492), 'explist__1': (True, 1496), '-': (True, 1494), '==': (True, 1495), '/': (True, 1497), '..': (True, 1493), 'or': (True, 1499)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), '>=': (False, 75), '<=': (False, 75), 'EOF': (False, 75), '^': (False, 75), '>': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '~=': (False, 75), '-': (False, 75), '/': (False, 75), '..': (False, 75)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), '<=': (False, 19), '(': (False, 19), 'EOF': (False, 19), '^': (False, 19), ';': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1001), 'or': (True, 346)}, {'NAME': (True, 1003)}, {'::': (False, 3), 'NAME': (False, 3), 'function': (False, 3), 'if': (False, 3), 'return': (False, 3), 'for': (False, 3), 'goto': (False, 3), 'local': (False, 3), '=': (False, 3), 'while': (False, 3), 'EMBEDSTAT': (False, 3), '(': (False, 3), 'EOF': (False, 3), 'do': (False, 3), 'break': (False, 3), ';': (False, 3), 'repeat': (False, 3)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), '<=': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1004)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), 'explist': (True, 1019), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1023), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'::': (False, 54), 'NAME': (False, 54), 'function': (False, 54), 'if': (False, 54), 'return': (False, 54), 'for': (False, 54), 'goto': (False, 54), 'local': (False, 54), 'while': (False, 54), 'EMBEDSTAT': (False, 54), '(': (False, 54), 'EOF': (False, 54), 'do': (False, 54), 'break': (False, 54), ';': (False, 54), 'repeat': (False, 54)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), 'until': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), ';': (False, 20), '..': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '~=': (False, 20)}, {'funcbody': (True, 1057), '(': (True, 163)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), ',': (False, 101), '^': (True, 981), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'if': (False, 52), 'return': (False, 52), 'goto': (False, 52), '::': (False, 52), 'repeat': (False, 52), 'NAME': (False, 52), 'for': (False, 52), 'function': (False, 52), 'until': (False, 52), '(': (False, 52), 'EMBEDSTAT': (False, 52), 'do': (False, 52), 'break': (False, 52), 'while': (False, 52), ';': (False, 52), 'local': (False, 52)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1482), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1481), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ',': (False, 13), '<': (False, 13), '<=': (False, 13), '(': (False, 13), '^': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1502)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1503), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), '..': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 1525)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1529), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'}': (True, 1266)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), '<=': (False, 102), '^': (True, 981), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'=': (False, 72)}, {'end': (True, 1119)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), '<=': (False, 100), '^': (True, 981), '>': (False, 100), '*': (False, 100), '%': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1161), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1159), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1162), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1163), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1164), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1166), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1168), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1169), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1170), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1171), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1172), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1173), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1174), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1175), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1176), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1177), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1179), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'(': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '[': (False, 13), ':': (False, 13)}, {'(': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '[': (False, 12), ':': (False, 12)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1181), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '(': (False, 107), ':': (False, 107)}, {'NAME': (True, 1182)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), '~=': (False, 20), '<': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '..': (False, 20)}, {'if': (False, 108), '[': (False, 108), 'return': (False, 108), 'function': (False, 108), '::': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'goto': (False, 108), 'local': (False, 108), 'while': (False, 108), '(': (False, 108), 'EMBEDSTAT': (False, 108), ';': (False, 108), 'do': (False, 108), 'break': (False, 108), ':': (False, 108), 'end': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), 'repeat': (False, 108)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 955), 'namelist__1': (True, 1184), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), 'EMBEDSTAT': (False, 26), '(': (False, 26), 'EOF': (False, 26), 'do': (False, 26), 'break': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {')': (True, 1268)}, {'if': (False, 7), 'NAME': (False, 7), 'function': (False, 7), '::': (False, 7), 'return': (False, 7), 'for': (False, 7), 'goto': (False, 7), 'local': (False, 7), 'while': (False, 7), '(': (False, 7), 'EMBEDSTAT': (False, 7), 'end': (False, 7), 'do': (False, 7), 'break': (False, 7), ';': (False, 7), 'repeat': (False, 7)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'goto': (False, 18), 'break': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), 'function': (False, 18), 'while': (False, 18), ',': (False, 18), '(': (False, 18), 'EOF': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1352), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), 'break': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), ',': (False, 37), '<': (False, 37), 'goto': (False, 37), 'while': (False, 37), '<=': (False, 37), '(': (False, 37), 'EOF': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), ';': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'if': (False, 84), 'or': (False, 84), '%': (False, 84), 'NAME': (False, 84), 'for': (False, 84), 'EMBEDSTAT': (False, 84), 'break': (False, 84), '*': (False, 84), '>=': (False, 84), '-': (False, 84), '/': (False, 84), 'repeat': (False, 84), '::': (False, 84), 'return': (False, 84), 'and': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), 'goto': (False, 84), 'while': (False, 84), '<=': (False, 84), '(': (False, 84), 'EOF': (False, 84), '^': (False, 84), 'local': (False, 84), '>': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), 'do': (False, 84), 'function': (False, 84), '..': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1357), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 82), 'or': (False, 82), '%': (False, 82), 'repeat': (False, 82), 'return': (False, 82), 'for': (False, 82), 'EMBEDSTAT': (False, 82), 'break': (False, 82), '*': (False, 82), '>=': (False, 82), '-': (False, 82), '/': (False, 82), 'local': (False, 82), '::': (False, 82), 'NAME': (False, 82), 'and': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'goto': (False, 82), 'while': (False, 82), ',': (False, 82), '(': (False, 82), 'EOF': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), ';': (False, 82), '==': (False, 82), '..': (False, 82), 'function': (False, 82), '~=': (False, 82)}, {'if': (False, 80), 'goto': (False, 80), '>=': (False, 80), 'NAME': (False, 80), 'for': (False, 80), 'local': (False, 80), 'or': (False, 80), 'EMBEDSTAT': (False, 80), 'break': (False, 80), '*': (False, 80), '%': (False, 80), '-': (False, 80), '/': (False, 80), 'repeat': (False, 80), '::': (False, 80), 'return': (False, 80), 'and': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'function': (False, 80), 'while': (False, 80), ',': (False, 80), '(': (False, 80), 'EOF': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), ';': (False, 80), '==': (False, 80), '..': (False, 80), '~=': (False, 80)}, {'if': (False, 78), 'or': (False, 78), '%': (False, 78), 'NAME': (False, 78), 'for': (False, 78), 'local': (False, 78), 'EMBEDSTAT': (False, 78), 'goto': (False, 78), 'break': (False, 78), '*': (False, 78), '>=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '::': (False, 78), 'return': (False, 78), 'and': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'function': (False, 78), 'while': (False, 78), ',': (False, 78), '(': (False, 78), 'EOF': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), ';': (False, 78), '==': (False, 78), '..': (False, 78), '~=': (False, 78)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1363), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'if': (False, 83), '[': (True, 1366), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), 'goto': (False, 83), 'break': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1367), '.': (True, 1369), '{': (True, 1370), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 1368), 'and': (False, 83), 'args': (True, 1371), '+': (False, 83), ',': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '<=': (False, 83), '(': (True, 1365), 'EOF': (False, 83), '^': (False, 83), 'do': (False, 83), ':': (True, 1372), '>': (False, 83), ';': (False, 83), '==': (False, 83), '..': (False, 83), '~=': (False, 83)}, {'if': (False, 81), 'or': (False, 81), '%': (False, 81), 'repeat': (False, 81), 'NAME': (False, 81), 'for': (False, 81), 'EMBEDSTAT': (False, 81), 'break': (False, 81), '*': (False, 81), '>=': (False, 81), '-': (False, 81), '/': (False, 81), 'local': (False, 81), '::': (False, 81), 'return': (False, 81), 'and': (False, 81), '+': (False, 81), ',': (False, 81), '<': (False, 81), 'goto': (False, 81), 'while': (False, 81), '<=': (False, 81), '(': (False, 81), 'EOF': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), ';': (False, 81), '==': (False, 81), '~=': (False, 81), 'function': (False, 81), '..': (False, 81)}, {'if': (False, 77), 'goto': (False, 77), '%': (False, 77), 'return': (False, 77), 'for': (False, 77), 'local': (False, 77), 'or': (False, 77), 'EMBEDSTAT': (False, 77), 'break': (False, 77), '*': (False, 77), '>=': (False, 77), '-': (False, 77), '/': (False, 77), 'repeat': (False, 77), '::': (False, 77), 'NAME': (False, 77), 'and': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'function': (False, 77), 'while': (False, 77), ',': (False, 77), '(': (False, 77), 'EOF': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), ';': (False, 77), '==': (False, 77), '~=': (False, 77), '..': (False, 77)}, {'if': (False, 79), 'goto': (False, 79), '>=': (False, 79), 'NAME': (False, 79), 'for': (False, 79), 'local': (False, 79), 'or': (False, 79), 'EMBEDSTAT': (False, 79), 'break': (False, 79), '*': (False, 79), '%': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '::': (False, 79), 'return': (False, 79), 'and': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'function': (False, 79), 'while': (False, 79), ',': (False, 79), '(': (False, 79), 'EOF': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), ';': (False, 79), '==': (False, 79), '~=': (False, 79), '..': (False, 79)}, {'if': (False, 7), 'NAME': (False, 7), 'function': (False, 7), '::': (False, 7), 'return': (False, 7), 'for': (False, 7), 'goto': (False, 7), 'local': (False, 7), 'while': (False, 7), 'EMBEDSTAT': (False, 7), '(': (False, 7), 'EOF': (False, 7), 'do': (False, 7), 'break': (False, 7), ';': (False, 7), 'repeat': (False, 7)}, {'funcbody': (True, 1378), '(': (True, 1379)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1380), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1534), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'if': (False, 29), 'or': (True, 1536), '%': (True, 1544), 'return': (False, 29), 'for': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'break': (False, 29), '*': (True, 1543), '>=': (True, 1539), '-': (True, 1547), '/': (True, 1549), 'repeat': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 1537), '+': (True, 1540), ',': (True, 1538), '<': (True, 1541), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 1535), '(': (False, 29), 'EOF': (False, 29), '^': (True, 1546), 'do': (False, 29), '>': (True, 1542), ';': (False, 29), '==': (True, 1545), '~=': (True, 1550), 'explist__1': (True, 1548), 'function': (False, 29), '..': (True, 1551)}, {'if': (False, 75), 'goto': (False, 75), '%': (False, 75), 'repeat': (False, 75), 'return': (False, 75), 'for': (False, 75), 'or': (False, 75), 'EMBEDSTAT': (False, 75), 'break': (False, 75), '*': (False, 75), '>=': (False, 75), '-': (False, 75), '/': (False, 75), 'local': (False, 75), '::': (False, 75), 'NAME': (False, 75), 'and': (False, 75), '+': (False, 75), ',': (False, 75), '<': (False, 75), 'function': (False, 75), 'while': (False, 75), '<=': (False, 75), '(': (False, 75), 'EOF': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), ';': (False, 75), '==': (False, 75), '~=': (False, 75), '..': (False, 75)}, {'if': (False, 76), 'goto': (False, 76), '%': (False, 76), 'repeat': (False, 76), 'return': (False, 76), 'for': (False, 76), 'or': (False, 76), 'EMBEDSTAT': (False, 76), 'break': (False, 76), '*': (False, 76), '>=': (False, 76), '-': (False, 76), '/': (False, 76), 'local': (False, 76), '::': (False, 76), 'NAME': (False, 76), 'and': (False, 76), '+': (False, 76), ',': (False, 76), '<': (False, 76), 'function': (False, 76), 'while': (False, 76), '<=': (False, 76), '(': (False, 76), 'EOF': (False, 76), '^': (False, 76), 'do': (False, 76), '>': (False, 76), ';': (False, 76), '==': (False, 76), '..': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'break': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '<=': (False, 19), '(': (False, 19), 'EOF': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1501), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {')': (True, 1531)}, {'end': (True, 1532)}, {'::': (False, 53), 'NAME': (False, 53), 'goto': (False, 53), 'if': (False, 53), 'return': (False, 53), 'for': (False, 53), 'function': (False, 53), 'local': (False, 53), 'while': (False, 53), '(': (False, 53), 'EMBEDSTAT': (False, 53), ';': (False, 53), 'do': (False, 53), 'break': (False, 53), 'end': (False, 53), 'repeat': (False, 53)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), ')': (False, 39), '(': (False, 39), '^': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1073), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'}': (True, 1561)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), 'then': (False, 4), '<=': (False, 4), '<': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), 'then': (False, 20), '<=': (False, 20), '~=': (False, 20), '<': (False, 20), '(': (False, 20), '^': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '..': (False, 20)}, {'(': (True, 436), 'args': (True, 1071), 'tableconstructor': (True, 439), 'STRING': (True, 438), '{': (True, 441)}, {',': (True, 1264), '^': (True, 981), 'and': (True, 980), '%': (True, 983), '+': (True, 984), '>': (True, 985), '*': (True, 986), '>=': (True, 987), '<': (True, 988), '..': (True, 993), '-': (True, 990), '<=': (True, 979), '==': (True, 991), '/': (True, 992), '~=': (True, 989), 'or': (True, 994)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), 'then': (False, 99), '<=': (False, 99), '<': (False, 99), '^': (True, 445), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'do': (True, 1375)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 447), '+': (True, 448), 'then': (False, 89), '<=': (False, 89), '<': (False, 89), '^': (True, 445), '>': (False, 89), '*': (True, 450), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {'*': (True, 450), 'or': (False, 86), '^': (True, 445), '%': (True, 447), '+': (True, 448), 'then': (False, 86), '>': (True, 459), '<=': (True, 444), '>=': (True, 451), '<': (True, 452), '~=': (True, 453), '-': (True, 454), '==': (True, 456), '/': (True, 457), 'and': (False, 86), '..': (True, 458)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), 'explist': (True, 1167), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 571), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), 'then': (False, 98), '<=': (False, 98), '<': (False, 98), '^': (True, 445), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 447), '+': (False, 94), 'then': (False, 94), '<=': (False, 94), '<': (False, 94), '^': (True, 445), '>': (False, 94), '*': (True, 450), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 457), '~=': (False, 94)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1235), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'elseif': (True, 1241), 'end': (False, 15), 'else': (False, 15), 'stat__1': (True, 1255)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), 'then': (False, 96), '<=': (False, 96), '<': (False, 96), '^': (True, 445), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 447), '+': (True, 448), 'then': (False, 90), '<=': (False, 90), '<': (False, 90), '^': (True, 445), '>': (False, 90), '*': (True, 450), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 447), '+': (True, 448), 'then': (False, 87), '<=': (False, 87), '<': (False, 87), '^': (True, 445), '>': (False, 87), '*': (True, 450), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {')': (True, 1560)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 447), '+': (True, 448), 'then': (False, 91), '<=': (False, 91), '<': (False, 91), '^': (True, 445), '>': (False, 91), '*': (True, 450), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 447), '+': (False, 95), 'then': (False, 95), '<=': (False, 95), '<': (False, 95), '^': (True, 445), '>': (False, 95), '*': (True, 450), '>=': (False, 95), '==': (False, 95), '~=': (False, 95), '-': (False, 95), '/': (True, 457), '..': (False, 95)}, {'*': (True, 450), 'and': (True, 446), '^': (True, 445), '%': (True, 447), '+': (True, 448), 'then': (False, 85), '>': (True, 459), '<=': (True, 444), '>=': (True, 451), '<': (True, 452), '..': (True, 458), '-': (True, 454), '==': (True, 456), '/': (True, 457), '~=': (True, 453), 'or': (False, 85)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 447), '+': (True, 448), 'then': (False, 92), '<=': (False, 92), '<': (False, 92), '^': (True, 445), '>': (False, 92), '*': (True, 450), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1155), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), 'then': (False, 97), '<=': (False, 97), '<': (False, 97), '^': (True, 445), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'::': (False, 53), 'NAME': (False, 53), 'function': (False, 53), 'if': (False, 53), 'return': (False, 53), 'for': (False, 53), 'goto': (False, 53), 'local': (False, 53), 'while': (False, 53), 'EMBEDSTAT': (False, 53), '(': (False, 53), 'EOF': (False, 53), 'do': (False, 53), 'break': (False, 53), ';': (False, 53), 'repeat': (False, 53)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 447), '+': (True, 448), 'then': (False, 93), '<=': (False, 93), '<': (False, 93), '^': (True, 445), '>': (False, 93), '*': (True, 450), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 447), '+': (True, 448), 'then': (False, 88), '<=': (False, 88), '<': (False, 88), '^': (True, 445), '>': (False, 88), '*': (True, 450), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 454), '/': (True, 457), '..': (True, 458)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1267), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1287), 'or': (True, 346)}, {')': (True, 1567)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), '<=': (False, 60), '<': (False, 60), ')': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1568)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), ']': (False, 99), '^': (True, 405), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 407), '+': (True, 408), '<=': (False, 89), '<': (False, 89), ']': (False, 89), '^': (True, 405), '>': (False, 89), '*': (True, 411), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'*': (True, 411), 'or': (False, 86), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), '==': (True, 416), '/': (True, 417), 'and': (False, 86), ']': (False, 86), '~=': (True, 414)}, {')': (True, 1087)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), ']': (False, 98), '^': (True, 405), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1283), '~=': (True, 414), 'or': (True, 419)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), '<=': (False, 108), '<': (False, 108), ')': (False, 108), '(': (False, 108), '^': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '~=': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108), '.': (False, 108)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 407), '+': (False, 94), '<=': (False, 94), '<': (False, 94), ']': (False, 94), '^': (True, 405), '>': (False, 94), '*': (True, 411), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 417), '~=': (False, 94)}, {'end': (True, 1476)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 407), '+': (True, 408), '<=': (False, 88), '<': (False, 88), ']': (False, 88), '^': (True, 405), '>': (False, 88), '*': (True, 411), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'if': (False, 39), '[': (False, 39), 'function': (False, 39), '%': (False, 39), 'return': (False, 39), 'for': (False, 39), 'local': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'end': (False, 39), 'break': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'repeat': (False, 39), '::': (False, 39), 'NAME': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'goto': (False, 39), 'while': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '~=': (False, 39), '..': (False, 39)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), ']': (False, 96), '^': (True, 405), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'}': (True, 1341)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 407), '+': (True, 408), '<=': (False, 90), '<': (False, 90), ']': (False, 90), '^': (True, 405), '>': (False, 90), '*': (True, 411), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 407), '+': (True, 408), '<=': (False, 87), '<': (False, 87), ']': (False, 87), '^': (True, 405), '>': (False, 87), '*': (True, 411), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'(': (True, 777), 'args': (True, 1156), 'tableconstructor': (True, 780), 'STRING': (True, 779), '{': (True, 782)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 407), '+': (True, 408), '<=': (False, 91), '<': (False, 91), ']': (False, 91), '^': (True, 405), '>': (False, 91), '*': (True, 411), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 407), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ']': (False, 95), '^': (True, 405), '>': (False, 95), '*': (True, 411), '>=': (False, 95), '==': (False, 95), '~=': (False, 95), '-': (False, 95), '/': (True, 417), '..': (False, 95)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 407), '+': (True, 408), '<=': (False, 92), '<': (False, 92), ']': (False, 92), '^': (True, 405), '>': (False, 92), '*': (True, 411), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), ']': (False, 97), '^': (True, 405), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 407), '+': (True, 408), '<=': (False, 93), '<': (False, 93), ']': (False, 93), '^': (True, 405), '>': (False, 93), '*': (True, 411), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 415), '/': (True, 417), '..': (True, 418)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '~=': (True, 414), '-': (True, 415), '==': (True, 416), '/': (True, 417), ']': (False, 85), '..': (True, 418), 'or': (False, 85)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'NAME': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), ';': (False, 11), 'break': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'return': (False, 11), 'and': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), 'end': (False, 11), '==': (False, 11), '..': (False, 11), '~=': (False, 11)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), '<=': (False, 108), '<': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '~=': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108), '.': (False, 108)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1620), 'or': (True, 346)}, {'}': (True, 1555)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), 'then': (False, 108), '<=': (False, 108), '~=': (False, 108), '<': (False, 108), '(': (False, 108), '^': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108)}, {'if': (False, 101), 'goto': (False, 101), '%': (False, 101), 'repeat': (False, 101), 'NAME': (False, 101), 'for': (False, 101), 'or': (False, 101), 'EMBEDSTAT': (False, 101), 'break': (False, 101), 'while': (False, 101), '*': (False, 101), '>=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '::': (False, 101), 'return': (False, 101), 'and': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'function': (False, 101), 'until': (False, 101), ',': (False, 101), '(': (False, 101), '^': (True, 1136), 'do': (False, 101), '>': (False, 101), ';': (False, 101), '==': (False, 101), '~=': (False, 101), '..': (False, 101)}, {'if': (False, 4), '[': (False, 4), 'return': (False, 4), 'function': (False, 4), '::': (False, 4), 'repeat': (False, 4), 'NAME': (False, 4), 'for': (False, 4), 'goto': (False, 4), 'until': (False, 4), '(': (False, 4), 'EMBEDSTAT': (False, 4), 'do': (False, 4), 'break': (False, 4), ':': (False, 4), 'while': (False, 4), ';': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), 'local': (False, 4)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1216), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1213), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'NAME': (False, 13), 'for': (False, 13), 'local': (False, 13), 'EMBEDSTAT': (False, 13), 'break': (False, 13), 'while': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'repeat': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'until': (False, 13), ',': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '..': (False, 13), 'function': (False, 13), '~=': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'break': (False, 12), 'while': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), 'goto': (False, 12), 'until': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1220)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1222), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '%': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'goto': (False, 107), 'break': (False, 107), 'while': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'until': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 1232)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1552), 'or': (True, 346)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 496), '+': (True, 497), ',': (False, 89), '<': (False, 89), '>=': (False, 89), '<=': (False, 89), '^': (True, 495), '}': (False, 89), '>': (False, 89), '*': (True, 499), ';': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'*': (True, 499), ';': (False, 86), 'or': (False, 86), '^': (True, 495), ',': (False, 86), '%': (True, 496), '+': (True, 497), '}': (False, 86), '>': (True, 498), '<=': (True, 493), '>=': (True, 500), '<': (True, 501), '..': (True, 506), '-': (True, 503), '==': (True, 504), '/': (True, 505), 'and': (False, 86), '~=': (True, 502)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), ',': (False, 101), '^': (True, 1153), 'do': (False, 101), '>': (False, 101), '*': (False, 101), '>=': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'if': (False, 60), 'goto': (False, 60), '%': (False, 60), 'repeat': (False, 60), 'return': (False, 60), 'for': (False, 60), 'or': (False, 60), 'EMBEDSTAT': (False, 60), 'break': (False, 60), 'while': (False, 60), '*': (False, 60), '>=': (False, 60), '-': (False, 60), '/': (False, 60), 'local': (False, 60), '::': (False, 60), 'NAME': (False, 60), 'and': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), 'function': (False, 60), 'until': (False, 60), '<=': (False, 60), '(': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), ';': (False, 60), '==': (False, 60), '~=': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1528)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), '%': (False, 99), '<=': (False, 99), '^': (True, 495), '}': (False, 99), '>': (False, 99), '*': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1594), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1595), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ',': (False, 13), '<': (False, 13), '..': (False, 13), '<=': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), ',': (False, 12), '~=': (False, 12), '<': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '..': (False, 12)}, {'NAME': (True, 1597)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1599), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), '..': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '~=': (False, 107)}, {'NAME': (True, 1602)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), '%': (False, 98), '<=': (False, 98), '^': (True, 495), '}': (False, 98), '>': (False, 98), '*': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'if': (False, 102), 'goto': (False, 102), '>=': (False, 102), 'NAME': (False, 102), 'for': (False, 102), 'local': (False, 102), 'or': (False, 102), 'EMBEDSTAT': (False, 102), 'break': (False, 102), 'until': (False, 102), '*': (False, 102), '%': (False, 102), '-': (False, 102), '/': (False, 102), 'repeat': (False, 102), '::': (False, 102), 'return': (False, 102), 'and': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'function': (False, 102), 'while': (False, 102), ',': (False, 102), '(': (False, 102), '^': (True, 1136), 'do': (False, 102), '>': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '~=': (False, 102)}, {'or': (False, 61), 'and': (False, 61), '%': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), '>=': (False, 61), '<=': (False, 61), '^': (False, 61), '}': (False, 61), '>': (False, 61), '*': (False, 61), ';': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 496), '+': (False, 94), ',': (False, 94), '<': (False, 94), '<=': (False, 94), '^': (True, 495), ';': (False, 94), '}': (False, 94), '>': (False, 94), '*': (True, 499), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 505), '~=': (False, 94)}, {'if': (False, 100), 'goto': (False, 100), '>=': (False, 100), 'repeat': (False, 100), 'return': (False, 100), 'for': (False, 100), 'or': (False, 100), 'EMBEDSTAT': (False, 100), 'break': (False, 100), 'until': (False, 100), '*': (False, 100), '%': (False, 100), '-': (False, 100), '/': (False, 100), 'local': (False, 100), '::': (False, 100), 'NAME': (False, 100), 'and': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'function': (False, 100), 'while': (False, 100), ',': (False, 100), '(': (False, 100), '^': (True, 1136), 'do': (False, 100), '>': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '..': (False, 100)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 496), '+': (True, 497), ',': (False, 88), '<': (False, 88), '>=': (False, 88), '<=': (False, 88), '^': (True, 495), '}': (False, 88), '>': (False, 88), '*': (True, 499), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), '%': (False, 96), ',': (False, 96), '^': (True, 495), '}': (False, 96), '>': (False, 96), '*': (False, 96), ';': (False, 96), '==': (False, 96), '..': (False, 96), '-': (False, 96), '/': (False, 96), '~=': (False, 96)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1183), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1342), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1345), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1347), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1348), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1350), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1351), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1353), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1356), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1358), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1359), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1362), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1364), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1373), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'::': (False, 71), 'NAME': (False, 71), 'function': (False, 71), 'if': (False, 71), 'return': (False, 71), 'for': (False, 71), 'goto': (False, 71), 'local': (False, 71), 'while': (False, 71), '(': (False, 71), 'EMBEDSTAT': (False, 71), 'do': (False, 71), 'break': (False, 71), 'until': (False, 71), ';': (False, 71), 'repeat': (False, 71)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1377), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1381), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'var': (True, 466), '(': (True, 467), 'NAME': (True, 468), 'tableconstructor': (True, 469), 'function': (True, 480), 'NUMBER': (True, 473), 'EMBEDEXPR': (True, 472), 'functiondef': (True, 471), '#': (True, 474), 'prefixexp': (True, 475), '...': (True, 476), 'true': (True, 477), 'STRING': (True, 478), '{': (True, 470), '-': (True, 481), 'not': (True, 482), 'exp': (True, 1386), 'nil': (True, 484), 'false': (True, 485), 'functioncall': (True, 486)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 496), '+': (True, 497), ',': (False, 90), '<': (False, 90), '>=': (False, 90), '<=': (False, 90), '^': (True, 495), '}': (False, 90), '>': (False, 90), '*': (True, 499), ';': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'}': (True, 1178)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 496), '+': (True, 497), '<=': (False, 87), '<': (False, 87), '>=': (False, 87), ',': (False, 87), '^': (True, 495), '}': (False, 87), '>': (False, 87), '*': (True, 499), ';': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), '<=': (False, 102), '^': (True, 1153), 'do': (False, 102), '>': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 496), '+': (True, 497), '<=': (False, 91), '<': (False, 91), ',': (False, 91), '^': (True, 495), ';': (False, 91), '}': (False, 91), '>': (False, 91), '*': (True, 499), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 503), '/': (True, 505), '..': (True, 506)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), '<=': (False, 100), '^': (True, 1153), 'do': (False, 100), '>': (False, 100), '*': (False, 100), '%': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), 'end': (False, 39), '<': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), ';': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'}': (True, 1615)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), '<=': (False, 20), '(': (False, 20), ';': (False, 20), '^': (False, 20), 'end': (False, 20), '..': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '~=': (False, 20)}, {'(': (True, 854), 'args': (True, 1636), 'tableconstructor': (True, 857), 'STRING': (True, 856), '{': (True, 859)}, {')': (True, 1637)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1658), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'return': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), 'break': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'NAME': (False, 38), 'and': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '(': (False, 38), 'EOF': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), ';': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'end': (True, 1204)}, {'if': (False, 108), '[': (False, 108), 'function': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), ';': (False, 108), 'break': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), 'goto': (False, 108), 'while': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), 'end': (False, 108), '==': (False, 108), '~=': (False, 108), '..': (False, 108)}, {'(': (False, 38), '[': (False, 38), ':': (False, 38), ',': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '=': (False, 38)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '>=': (False, 4), 'until': (False, 4), '<=': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), ';': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'*': (True, 986), 'or': (False, 86), '^': (True, 981), ',': (False, 86), '%': (True, 983), '+': (True, 984), '>': (True, 985), '<=': (True, 979), '>=': (True, 987), '<': (True, 988), '..': (True, 993), '-': (True, 990), '==': (True, 991), '/': (True, 992), 'and': (False, 86), '~=': (True, 989)}, {')': (False, 32)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 983), '+': (True, 984), ',': (False, 89), '<': (False, 89), '<=': (False, 89), '^': (True, 981), '>': (False, 89), '*': (True, 986), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), '<=': (False, 99), '^': (True, 981), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {',': (True, 1260), '*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), '%': (True, 1188), 'stat__3': (True, 1261), 'do': (False, 10), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '~=': (True, 1199), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), '..': (True, 1194), 'or': (True, 1196)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), '<=': (False, 98), '^': (True, 981), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {')': (True, 1569)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 983), '+': (False, 94), ',': (False, 94), '<': (False, 94), '<=': (False, 94), '^': (True, 981), '>': (False, 94), '*': (True, 986), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 992), '~=': (False, 94)}, {'do': (True, 1660)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 983), '+': (True, 984), ',': (False, 88), '<': (False, 88), '<=': (False, 88), '^': (True, 981), '>': (False, 88), '*': (True, 986), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), ',': (False, 96), '^': (True, 981), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 983), '+': (True, 984), ',': (False, 90), '<': (False, 90), '<=': (False, 90), '^': (True, 981), '>': (False, 90), '*': (True, 986), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 983), '+': (True, 984), '<=': (False, 87), '<': (False, 87), ',': (False, 87), '^': (True, 981), '>': (False, 87), '*': (True, 986), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 983), '+': (True, 984), '<=': (False, 91), '<': (False, 91), ',': (False, 91), '^': (True, 981), '>': (False, 91), '*': (True, 986), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 983), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ',': (False, 95), '^': (True, 981), '>': (False, 95), '*': (True, 986), '>=': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 992), '~=': (False, 95)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 983), '+': (True, 984), ',': (False, 92), '<': (False, 92), '<=': (False, 92), '^': (True, 981), '>': (False, 92), '*': (True, 986), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), ',': (False, 97), '^': (True, 981), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 983), '+': (True, 984), ',': (False, 93), '<': (False, 93), '<=': (False, 93), '^': (True, 981), '>': (False, 93), '*': (True, 986), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 990), '/': (True, 992), '..': (True, 993)}, {'*': (True, 986), '^': (True, 981), 'and': (True, 980), ',': (False, 85), '%': (True, 983), '+': (True, 984), '>': (True, 985), '<=': (True, 979), '>=': (True, 987), '<': (True, 988), '~=': (True, 989), '-': (True, 990), '==': (True, 991), '/': (True, 992), '..': (True, 993), 'or': (False, 85)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '<=': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {')': (True, 1259)}, {'if': (False, 4), '[': (False, 4), 'return': (False, 4), 'function': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'for': (False, 4), 'goto': (False, 4), 'local': (False, 4), 'while': (False, 4), '(': (False, 4), 'EMBEDSTAT': (False, 4), 'end': (False, 4), 'do': (False, 4), 'break': (False, 4), ':': (False, 4), ';': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), 'repeat': (False, 4)}, {'}': (True, 1571)}, {'(': (True, 995), 'args': (True, 1574), 'tableconstructor': (True, 997), 'STRING': (True, 996), '{': (True, 998)}, {'end': (True, 1702)}, {'if': (False, 25), 'return': (False, 25), 'function': (False, 25), '::': (False, 25), 'repeat': (False, 25), 'NAME': (False, 25), 'for': (False, 25), 'goto': (False, 25), '=': (False, 25), 'while': (False, 25), 'EMBEDSTAT': (False, 25), '(': (False, 25), 'EOF': (False, 25), 'do': (False, 25), 'break': (False, 25), ';': (False, 25), 'local': (False, 25)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1704), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1703), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1705), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1706), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1707), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'do': (False, 71)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1708), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1709), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1710), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1712), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1714), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1717), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1718), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1719), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1720), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1721), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), '<=': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1726)}, {'if': (False, 4), 'goto': (False, 4), '>=': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '%': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'if': (False, 61), 'return': (False, 61), 'goto': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'for': (False, 61), 'function': (False, 61), 'local': (False, 61), 'until': (False, 61), '(': (False, 61), 'EMBEDSTAT': (False, 61), 'do': (False, 61), 'break': (False, 61), 'while': (False, 61), ';': (False, 61), 'repeat': (False, 61)}, {'(': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '[': (False, 20), ':': (False, 20)}, {'::': (False, 46), 'NAME': (False, 46), 'function': (False, 46), 'if': (False, 46), 'repeat': (False, 46), 'return': (False, 46), 'for': (False, 46), 'goto': (False, 46), 'while': (False, 46), 'EOF': (False, 46), '(': (False, 46), 'EMBEDSTAT': (False, 46), 'do': (False, 46), 'break': (False, 46), ';': (False, 46), 'local': (False, 46)}, {')': (True, 1713)}, {'}': (True, 1661)}, {'(': (True, 576), 'args': (True, 1737), 'tableconstructor': (True, 578), 'STRING': (True, 577), '{': (True, 579)}, {')': (True, 1738)}, {'in': (False, 25)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), 'break': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '(': (False, 4), 'EOF': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1572), '~=': (True, 414), 'or': (True, 419)}, {'::': (True, 1591)}, {'if': (False, 28), 'return': (False, 28), 'function': (False, 28), '::': (False, 28), 'repeat': (False, 28), 'NAME': (False, 28), 'for': (False, 28), 'goto': (False, 28), 'while': (False, 28), '(': (False, 28), 'EMBEDSTAT': (False, 28), ';': (False, 28), 'do': (False, 28), 'break': (False, 28), 'end': (False, 28), 'local': (False, 28)}, {')': (True, 1316)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'explist': (True, 1331), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1335), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'until': (True, 1344)}, {'if': (False, 108), '[': (False, 108), 'goto': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), 'break': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), '<=': (False, 108), '<': (False, 108), 'function': (False, 108), 'while': (False, 108), '(': (False, 108), 'EOF': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), ';': (False, 108), '==': (False, 108), '..': (False, 108), '~=': (False, 108)}, {'if': (False, 39), '[': (False, 39), 'function': (False, 39), '%': (False, 39), 'return': (False, 39), 'for': (False, 39), 'local': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'break': (False, 39), 'until': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'repeat': (False, 39), '::': (False, 39), 'NAME': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'goto': (False, 39), 'while': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '..': (False, 39), '~=': (False, 39)}, {'funcbody': (True, 1354), '(': (True, 1355)}, {'}': (True, 1616)}, {'*': (True, 450), 'and': (True, 446), '^': (True, 445), '%': (True, 447), '+': (True, 448), 'then': (True, 1596), '<=': (True, 444), '>=': (True, 451), '>': (True, 459), '<': (True, 452), '..': (True, 458), '-': (True, 454), '==': (True, 456), '/': (True, 457), '~=': (True, 453), 'or': (True, 455)}, {'var': (True, 241), '(': (True, 242), 'tableconstructor': (True, 234), 'function': (True, 238), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'NAME': (True, 355), '#': (True, 248), 'prefixexp': (True, 236), '...': (True, 249), 'true': (True, 237), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'not': (True, 239), 'exp': (True, 1600), 'functioncall': (True, 255), 'nil': (True, 254), 'false': (True, 240), 'functiondef': (True, 247)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 770), 'namelist__1': (True, 1601), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), '(': (False, 26), 'EMBEDSTAT': (False, 26), 'end': (False, 26), 'do': (False, 26), 'break': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1603), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'::': (False, 13), '[': (False, 13), 'return': (False, 13), 'goto': (False, 13), 'if': (False, 13), 'NAME': (False, 13), 'elseif': (False, 13), 'else': (False, 13), 'for': (False, 13), 'function': (False, 13), 'local': (False, 13), 'while': (False, 13), '(': (False, 13), 'EMBEDSTAT': (False, 13), ';': (False, 13), 'do': (False, 13), 'break': (False, 13), ':': (False, 13), 'end': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), 'repeat': (False, 13)}, {'::': (False, 12), '[': (False, 12), 'return': (False, 12), 'goto': (False, 12), 'if': (False, 12), 'repeat': (False, 12), 'NAME': (False, 12), 'elseif': (False, 12), 'else': (False, 12), 'for': (False, 12), 'function': (False, 12), 'while': (False, 12), '(': (False, 12), 'EMBEDSTAT': (False, 12), 'end': (False, 12), 'do': (False, 12), 'break': (False, 12), ':': (False, 12), ';': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), 'local': (False, 12)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1388), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'return': (False, 107), 'goto': (False, 107), '::': (False, 107), 'repeat': (False, 107), 'NAME': (False, 107), 'elseif': (False, 107), 'else': (False, 107), 'for': (False, 107), 'function': (False, 107), 'while': (False, 107), '(': (False, 107), 'EMBEDSTAT': (False, 107), 'end': (False, 107), 'do': (False, 107), 'break': (False, 107), ':': (False, 107), ';': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), 'local': (False, 107)}, {'NAME': (True, 1391)}, {'(': (True, 1094), 'args': (True, 1394), 'tableconstructor': (True, 1097), 'STRING': (True, 1096), '{': (True, 1099)}, {'in': (True, 1396)}, {',': (True, 509), '=': (True, 1395), 'in': (False, 26), 'namelist__1': (True, 511)}, {',': (True, 1262), '*': (True, 986), '^': (True, 981), 'and': (True, 980), '%': (True, 983), '+': (True, 984), '>': (True, 985), '<=': (True, 979), '>=': (True, 987), '<': (True, 988), '..': (True, 993), '-': (True, 990), '==': (True, 991), '/': (True, 992), '~=': (True, 989), 'or': (True, 994)}, {'::': (False, 45), 'NAME': (False, 45), 'function': (False, 45), 'if': (False, 45), 'repeat': (False, 45), 'return': (False, 45), 'elseif': (False, 45), 'else': (False, 45), 'for': (False, 45), 'goto': (False, 45), 'while': (False, 45), '(': (False, 45), 'EMBEDSTAT': (False, 45), 'end': (False, 45), 'do': (False, 45), 'break': (False, 45), ';': (False, 45), 'local': (False, 45)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), 'then': (False, 38), '<=': (False, 38), '<': (False, 38), '(': (False, 38), '^': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '..': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '~=': (False, 38), '.': (False, 38)}, {'*': (True, 265), 'and': (True, 260), '^': (True, 259), '%': (True, 261), 'do': (True, 1564), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '<': (True, 267), '~=': (True, 272), '-': (True, 269), '==': (True, 270), '/': (True, 271), '..': (True, 268), 'or': (True, 273)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1763), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'elseif': (False, 62), 'end': (False, 62), 'else': (False, 62), 'return': (False, 62)}, {'var': (True, 50), '(': (True, 51), 'tableconstructor': (True, 52), '{': (True, 62), 'functiondef': (True, 54), 'EMBEDEXPR': (True, 55), 'NAME': (True, 56), '#': (True, 57), 'prefixexp': (True, 58), '...': (True, 59), 'true': (True, 60), 'STRING': (True, 61), 'function': (True, 53), '-': (True, 63), 'not': (True, 64), 'exp': (True, 1382), 'NUMBER': (True, 66), 'nil': (True, 67), 'false': (True, 68), 'functioncall': (True, 69)}, {'end': (False, 35), 'else': (True, 1562), 'stat__2': (True, 1563)}, {'end': (True, 1570)}, {'elseif': (False, 103), 'end': (False, 103), 'else': (False, 103)}, {'elseif': (False, 56), 'end': (False, 56), 'else': (False, 56)}, {'tableconstructor': (True, 1397), 'NAME': (True, 1398), 'retstat__1': (True, 1399), 'prefixexp': (True, 1400), 'elseif': (False, 17), 'true': (True, 1401), 'else': (False, 17), 'function': (True, 1402), 'not': (True, 1403), 'false': (True, 1404), 'var': (True, 1405), '(': (True, 1406), ';': (False, 17), 'functiondef': (True, 1407), 'EMBEDEXPR': (True, 1408), 'NUMBER': (True, 1409), '#': (True, 1410), '...': (True, 1411), 'end': (False, 17), 'STRING': (True, 1412), 'explist': (True, 1413), '{': (True, 1414), '-': (True, 1415), 'exp': (True, 1416), 'nil': (True, 1417), 'functioncall': (True, 1418)}, {'::': (False, 8), 'NAME': (False, 8), 'function': (False, 8), 'stat__4': (True, 1423), 'if': (False, 8), 'repeat': (False, 8), 'return': (False, 8), 'elseif': (False, 8), 'else': (False, 8), 'for': (False, 8), 'goto': (False, 8), '=': (True, 1422), 'while': (False, 8), '(': (False, 8), 'EMBEDSTAT': (False, 8), 'end': (False, 8), 'do': (False, 8), 'break': (False, 8), ';': (False, 8), 'local': (False, 8)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 1420), 'else': (False, 26), 'namelist__1': (True, 1421), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), 'elseif': (False, 26), '(': (False, 26), 'EMBEDSTAT': (False, 26), 'end': (False, 26), 'do': (False, 26), 'break': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {'NAME': (True, 1426)}, {')': (True, 1384)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1253), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '~=': (False, 39), '<': (False, 39), ']': (False, 39), '(': (False, 39), '^': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ']': (False, 38), '(': (False, 38), '^': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '..': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '~=': (False, 38), '.': (False, 38)}, {'}': (True, 1606)}, {'end': (False, 35), 'else': (True, 1562), 'stat__2': (True, 1607)}, {'(': (True, 535), 'args': (True, 1611), 'tableconstructor': (True, 538), 'STRING': (True, 537), '{': (True, 540)}, {'::': (False, 27), 'return': (False, 27), 'goto': (False, 27), 'if': (False, 27), 'repeat': (False, 27), 'NAME': (False, 27), 'for': (False, 27), 'function': (False, 27), 'while': (False, 27), 'EMBEDSTAT': (False, 27), '(': (False, 27), 'EOF': (False, 27), 'do': (False, 27), 'break': (False, 27), ';': (False, 27), 'local': (False, 27)}, {'::': (False, 41), 'return': (False, 41), 'function': (False, 41), 'if': (False, 41), 'NAME': (False, 41), 'for': (False, 41), 'goto': (False, 41), 'local': (False, 41), 'while': (False, 41), 'EOF': (False, 41), '(': (False, 41), 'EMBEDSTAT': (False, 41), 'do': (False, 41), 'break': (False, 41), ';': (False, 41), 'repeat': (False, 41)}, {'(': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '[': (False, 11), ':': (False, 11)}, {'var': (True, 70), '(': (True, 71), 'tableconstructor': (True, 72), '{': (True, 82), 'functiondef': (True, 74), 'EMBEDEXPR': (True, 75), 'NAME': (True, 76), '#': (True, 77), 'prefixexp': (True, 78), '...': (True, 79), 'true': (True, 80), 'STRING': (True, 81), 'function': (True, 73), '-': (True, 83), 'not': (True, 84), 'exp': (True, 1612), 'NUMBER': (True, 86), 'nil': (True, 87), 'false': (True, 88), 'functioncall': (True, 89)}, {'do': (True, 1610)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1613), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1617), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1619), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), 'then': (False, 11), '<=': (False, 11), '<': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '<=': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ',': (False, 38), '(': (False, 38), ';': (False, 38), '^': (False, 38), 'end': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '~=': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '..': (False, 38), '.': (False, 38)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1622), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {')': (True, 1624)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '..': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '~=': (False, 38), '.': (False, 38)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 884), '+': (True, 885), '<=': (False, 89), '<': (False, 89), '>=': (False, 89), ',': (False, 89), '^': (True, 891), ';': (False, 89), '>': (False, 89), '*': (True, 888), 'end': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'*': (True, 888), 'and': (True, 882), '^': (True, 891), ';': (False, 85), '%': (True, 884), '+': (True, 885), '>': (True, 887), '<=': (True, 880), '>=': (True, 894), ',': (False, 85), '<': (True, 886), '..': (True, 896), '-': (True, 892), 'end': (False, 85), '==': (True, 890), '/': (True, 895), '~=': (True, 889), 'or': (False, 85)}, {'*': (True, 888), ';': (False, 86), 'or': (False, 86), '^': (True, 891), 'end': (False, 86), '%': (True, 884), '+': (True, 885), '>': (True, 887), '<=': (True, 880), '>=': (True, 894), ',': (False, 86), '<': (True, 886), '..': (True, 896), '-': (True, 892), '==': (True, 890), '/': (True, 895), 'and': (False, 86), '~=': (True, 889)}, {',': (True, 883), '*': (True, 888), 'or': (True, 881), '^': (True, 891), ';': (False, 29), '%': (True, 884), '..': (True, 896), '+': (True, 885), '>': (True, 887), '<=': (True, 880), '>=': (True, 894), 'end': (False, 29), '<': (True, 886), 'explist__1': (True, 1802), '-': (True, 892), '==': (True, 890), '/': (True, 895), 'and': (True, 882), '~=': (True, 889)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), '%': (False, 98), '<=': (False, 98), '^': (True, 891), ';': (False, 98), '>': (False, 98), '*': (False, 98), 'end': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 884), '+': (False, 94), ',': (False, 94), '<': (False, 94), '>=': (False, 94), '<=': (False, 94), '^': (True, 891), 'end': (False, 94), '>': (False, 94), '*': (True, 888), ';': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 895), '~=': (False, 94)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 884), '+': (True, 885), '<=': (False, 87), '<': (False, 87), '>=': (False, 87), ',': (False, 87), '^': (True, 891), ';': (False, 87), '>': (False, 87), '*': (True, 888), 'end': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 884), '+': (True, 885), ',': (False, 88), '<': (False, 88), '>=': (False, 88), '<=': (False, 88), '^': (True, 891), 'end': (False, 88), '>': (False, 88), '*': (True, 888), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), '%': (False, 96), ',': (False, 96), '^': (True, 891), ';': (False, 96), '>': (False, 96), '*': (False, 96), 'end': (False, 96), '==': (False, 96), '..': (False, 96), '-': (False, 96), '/': (False, 96), '~=': (False, 96)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 884), '+': (True, 885), '<=': (False, 91), '<': (False, 91), '>=': (False, 91), ',': (False, 91), '^': (True, 891), ';': (False, 91), '>': (False, 91), '*': (True, 888), 'end': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 884), '+': (True, 885), ',': (False, 92), '<': (False, 92), '>=': (False, 92), '<=': (False, 92), '^': (True, 891), ';': (False, 92), '>': (False, 92), '*': (True, 888), 'end': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1286), 'or': (True, 346)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'NAME': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), ';': (False, 38), 'break': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'return': (False, 38), 'and': (False, 38), '+': (False, 38), ',': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '<=': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), 'end': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'}': (True, 1553)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), ')': (False, 4), '<=': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'end': (False, 20), 'break': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), '<=': (False, 20), '<': (False, 20), 'function': (False, 20), 'while': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), '<=': (False, 20), '<': (False, 20), ')': (False, 20), '(': (False, 20), '^': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '..': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '~=': (False, 20), '.': (False, 20)}, {'if': (False, 101), 'NAME': (False, 101), 'or': (False, 101), 'and': (False, 101), '::': (False, 101), '>=': (False, 101), 'repeat': (False, 101), 'return': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'for': (False, 101), 'function': (False, 101), 'while': (False, 101), '(': (False, 101), 'EMBEDSTAT': (False, 101), '^': (True, 1312), ';': (False, 101), 'goto': (False, 101), 'do': (False, 101), 'break': (False, 101), '>': (False, 101), '*': (False, 101), 'end': (False, 101), '==': (False, 101), '~=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '..': (False, 101), '%': (False, 101)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1834), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1835), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'repeat': (False, 13), 'NAME': (False, 13), 'for': (False, 13), 'EMBEDSTAT': (False, 13), 'end': (False, 13), 'break': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'local': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'while': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '~=': (False, 13), 'function': (False, 13), '..': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'end': (False, 12), 'break': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), '<=': (False, 12), '<': (False, 12), 'goto': (False, 12), 'while': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1838)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1840), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '>=': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'end': (False, 107), 'goto': (False, 107), 'break': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 1843)}, {'if': (False, 60), 'return': (False, 60), 'goto': (False, 60), 'and': (False, 60), '::': (False, 60), '%': (False, 60), 'NAME': (False, 60), '+': (False, 60), '<=': (False, 60), '<': (False, 60), 'for': (False, 60), 'function': (False, 60), 'local': (False, 60), 'while': (False, 60), 'or': (False, 60), '(': (False, 60), ';': (False, 60), 'EMBEDSTAT': (False, 60), '^': (False, 60), 'end': (False, 60), 'do': (False, 60), 'break': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '..': (False, 60), '-': (False, 60), '/': (False, 60), 'repeat': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1349)}, {'if': (False, 102), 'NAME': (False, 102), 'or': (False, 102), 'and': (False, 102), '::': (False, 102), '>=': (False, 102), 'repeat': (False, 102), 'return': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'for': (False, 102), 'function': (False, 102), 'while': (False, 102), '(': (False, 102), 'EMBEDSTAT': (False, 102), '^': (True, 1312), ';': (False, 102), 'goto': (False, 102), 'do': (False, 102), 'break': (False, 102), '>': (False, 102), '*': (False, 102), 'end': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), 'local': (False, 102), '~=': (False, 102), '%': (False, 102)}, {'if': (False, 100), 'return': (False, 100), 'goto': (False, 100), 'and': (False, 100), '::': (False, 100), '>=': (False, 100), 'NAME': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'for': (False, 100), 'function': (False, 100), 'local': (False, 100), 'while': (False, 100), 'or': (False, 100), '(': (False, 100), 'EMBEDSTAT': (False, 100), '^': (True, 1312), ';': (False, 100), 'do': (False, 100), 'break': (False, 100), '>': (False, 100), '*': (False, 100), 'end': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), 'repeat': (False, 100), '..': (False, 100), '%': (False, 100)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1722), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1723), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1725), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1727), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1728), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1729), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1730), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1731), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1732), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1733), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1734), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1821), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1824), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1827), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'var': (True, 680), '(': (True, 681), 'NAME': (True, 682), 'tableconstructor': (True, 683), 'function': (True, 693), 'NUMBER': (True, 687), 'EMBEDEXPR': (True, 686), 'functiondef': (True, 685), '#': (True, 688), 'prefixexp': (True, 689), '...': (True, 690), 'true': (True, 691), 'STRING': (True, 692), '{': (True, 684), '-': (True, 694), 'not': (True, 695), 'exp': (True, 1829), 'nil': (True, 697), 'false': (True, 698), 'functioncall': (True, 699)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'NAME': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), 'break': (False, 11), 'until': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'return': (False, 11), 'and': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), ';': (False, 11), '==': (False, 11), '..': (False, 11), '~=': (False, 11)}, {')': (True, 1436)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1389), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'elseif': (False, 18), 'else': (False, 18), 'for': (False, 18), 'EMBEDSTAT': (False, 18), 'end': (False, 18), 'break': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), ',': (False, 18), '<': (False, 18), 'goto': (False, 18), 'while': (False, 18), '<=': (False, 18), '(': (False, 18), '^': (False, 18), 'local': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), 'do': (False, 18), 'function': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1662), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 84), 'or': (False, 84), '%': (False, 84), 'NAME': (False, 84), 'elseif': (False, 84), 'else': (False, 84), 'for': (False, 84), 'EMBEDSTAT': (False, 84), 'end': (False, 84), 'break': (False, 84), '*': (False, 84), '>=': (False, 84), '-': (False, 84), '/': (False, 84), 'repeat': (False, 84), '::': (False, 84), 'return': (False, 84), 'and': (False, 84), '+': (False, 84), ',': (False, 84), '<': (False, 84), 'goto': (False, 84), 'while': (False, 84), '<=': (False, 84), '(': (False, 84), '^': (False, 84), 'local': (False, 84), '>': (False, 84), ';': (False, 84), '==': (False, 84), '..': (False, 84), 'do': (False, 84), 'function': (False, 84), '~=': (False, 84)}, {'funcbody': (True, 1664), '(': (True, 1665)}, {'if': (False, 82), 'or': (False, 82), '%': (False, 82), 'repeat': (False, 82), 'NAME': (False, 82), 'elseif': (False, 82), 'else': (False, 82), 'for': (False, 82), 'EMBEDSTAT': (False, 82), ';': (False, 82), 'break': (False, 82), '*': (False, 82), '>=': (False, 82), '-': (False, 82), '/': (False, 82), 'local': (False, 82), '::': (False, 82), 'return': (False, 82), 'and': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'goto': (False, 82), 'while': (False, 82), ',': (False, 82), '(': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), 'end': (False, 82), '==': (False, 82), '~=': (False, 82), 'function': (False, 82), '..': (False, 82)}, {'if': (False, 80), 'goto': (False, 80), '%': (False, 80), 'NAME': (False, 80), 'elseif': (False, 80), 'else': (False, 80), 'for': (False, 80), 'local': (False, 80), 'or': (False, 80), 'EMBEDSTAT': (False, 80), 'end': (False, 80), 'break': (False, 80), '*': (False, 80), '>=': (False, 80), '-': (False, 80), '/': (False, 80), 'repeat': (False, 80), '::': (False, 80), 'return': (False, 80), 'and': (False, 80), '+': (False, 80), ',': (False, 80), '<': (False, 80), 'function': (False, 80), 'while': (False, 80), '<=': (False, 80), '(': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), ';': (False, 80), '==': (False, 80), '~=': (False, 80), '..': (False, 80)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'elseif': (False, 37), 'else': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), 'end': (False, 37), 'break': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), 'goto': (False, 37), 'while': (False, 37), ',': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), ';': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1668), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'if': (False, 83), '[': (True, 1671), 'or': (False, 83), '>=': (False, 83), 'repeat': (False, 83), 'NAME': (False, 83), 'elseif': (False, 83), 'else': (False, 83), 'for': (False, 83), 'EMBEDSTAT': (False, 83), ';': (False, 83), 'goto': (False, 83), 'break': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1672), '.': (True, 1674), '{': (True, 1675), '-': (False, 83), '/': (False, 83), 'local': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 1673), 'and': (False, 83), 'args': (True, 1676), '+': (False, 83), ',': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '<=': (False, 83), '(': (True, 1670), '^': (False, 83), 'do': (False, 83), ':': (True, 1677), '>': (False, 83), 'end': (False, 83), '==': (False, 83), '~=': (False, 83), '..': (False, 83)}, {'if': (False, 81), 'or': (False, 81), '%': (False, 81), 'repeat': (False, 81), 'NAME': (False, 81), 'elseif': (False, 81), 'else': (False, 81), 'for': (False, 81), 'EMBEDSTAT': (False, 81), 'end': (False, 81), 'goto': (False, 81), 'break': (False, 81), '*': (False, 81), '>=': (False, 81), '-': (False, 81), '/': (False, 81), 'local': (False, 81), '::': (False, 81), 'return': (False, 81), 'and': (False, 81), '+': (False, 81), ',': (False, 81), '<': (False, 81), 'function': (False, 81), 'while': (False, 81), '<=': (False, 81), '(': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), ';': (False, 81), '==': (False, 81), '~=': (False, 81), '..': (False, 81)}, {'if': (False, 77), 'goto': (False, 77), '%': (False, 77), 'repeat': (False, 77), 'NAME': (False, 77), 'elseif': (False, 77), 'else': (False, 77), 'for': (False, 77), 'or': (False, 77), 'EMBEDSTAT': (False, 77), ';': (False, 77), 'break': (False, 77), '*': (False, 77), '>=': (False, 77), '-': (False, 77), '/': (False, 77), 'local': (False, 77), '::': (False, 77), 'return': (False, 77), 'and': (False, 77), '+': (False, 77), ',': (False, 77), '<': (False, 77), 'function': (False, 77), 'while': (False, 77), '<=': (False, 77), '(': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), 'end': (False, 77), '==': (False, 77), '~=': (False, 77), '..': (False, 77)}, {'if': (False, 79), 'goto': (False, 79), '>=': (False, 79), 'return': (False, 79), 'elseif': (False, 79), 'else': (False, 79), 'for': (False, 79), 'local': (False, 79), 'or': (False, 79), 'EMBEDSTAT': (False, 79), ';': (False, 79), 'break': (False, 79), '*': (False, 79), '%': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '::': (False, 79), 'NAME': (False, 79), 'and': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'function': (False, 79), 'while': (False, 79), ',': (False, 79), '(': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), 'end': (False, 79), '==': (False, 79), '~=': (False, 79), '..': (False, 79)}, {'if': (False, 41), 'return': (False, 41), 'function': (False, 41), '::': (False, 41), 'NAME': (False, 41), 'elseif': (False, 41), 'else': (False, 41), 'for': (False, 41), 'goto': (False, 41), 'local': (False, 41), 'while': (False, 41), '(': (False, 41), 'EMBEDSTAT': (False, 41), 'end': (False, 41), 'do': (False, 41), 'break': (False, 41), ';': (False, 41), 'repeat': (False, 41)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1678), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1679), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1680), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'if': (False, 29), 'or': (True, 1682), '%': (True, 1685), 'repeat': (False, 29), 'return': (False, 29), 'elseif': (False, 29), 'else': (False, 29), 'for': (False, 29), 'EMBEDSTAT': (False, 29), 'end': (False, 29), 'break': (False, 29), '*': (True, 1689), '>=': (True, 1690), '-': (True, 1693), '/': (True, 1695), 'local': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 1696), '+': (True, 1686), ',': (True, 1684), '<': (True, 1691), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 1681), '(': (False, 29), '^': (True, 1683), 'do': (False, 29), '>': (True, 1688), ';': (False, 29), '==': (True, 1687), '~=': (True, 1692), 'explist__1': (True, 1694), 'function': (False, 29), '..': (True, 1697)}, {'if': (False, 78), 'or': (False, 78), '%': (False, 78), 'NAME': (False, 78), 'elseif': (False, 78), 'else': (False, 78), 'for': (False, 78), 'local': (False, 78), 'EMBEDSTAT': (False, 78), 'end': (False, 78), 'break': (False, 78), '*': (False, 78), '>=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '::': (False, 78), 'return': (False, 78), 'and': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'goto': (False, 78), 'while': (False, 78), ',': (False, 78), '(': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), ';': (False, 78), '==': (False, 78), '..': (False, 78), 'function': (False, 78), '~=': (False, 78)}, {'if': (False, 75), 'or': (False, 75), '>=': (False, 75), 'repeat': (False, 75), 'return': (False, 75), 'elseif': (False, 75), 'else': (False, 75), 'for': (False, 75), 'EMBEDSTAT': (False, 75), ';': (False, 75), 'break': (False, 75), '*': (False, 75), '%': (False, 75), '-': (False, 75), '/': (False, 75), 'local': (False, 75), '::': (False, 75), 'NAME': (False, 75), 'and': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), 'goto': (False, 75), 'while': (False, 75), ',': (False, 75), '(': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), 'end': (False, 75), '==': (False, 75), '~=': (False, 75), 'function': (False, 75), '..': (False, 75)}, {'if': (False, 76), 'or': (False, 76), '>=': (False, 76), 'NAME': (False, 76), 'elseif': (False, 76), 'else': (False, 76), 'for': (False, 76), 'EMBEDSTAT': (False, 76), ';': (False, 76), 'break': (False, 76), '*': (False, 76), '%': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '::': (False, 76), 'return': (False, 76), 'and': (False, 76), '+': (False, 76), ',': (False, 76), '<': (False, 76), 'goto': (False, 76), 'while': (False, 76), '<=': (False, 76), '(': (False, 76), '^': (False, 76), 'local': (False, 76), '>': (False, 76), 'end': (False, 76), '==': (False, 76), '..': (False, 76), 'do': (False, 76), 'function': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'function': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'elseif': (False, 19), 'else': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'end': (False, 19), 'break': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), ',': (False, 19), '<': (False, 19), 'goto': (False, 19), 'while': (False, 19), '<=': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), ')': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'if': (False, 89), 'goto': (False, 89), '%': (True, 1134), 'repeat': (False, 89), 'NAME': (False, 89), 'for': (False, 89), 'or': (False, 89), 'EMBEDSTAT': (False, 89), 'break': (False, 89), 'until': (False, 89), '*': (True, 1133), '>=': (False, 89), '-': (True, 1137), '/': (True, 1139), 'local': (False, 89), '::': (False, 89), 'return': (False, 89), 'and': (False, 89), '+': (True, 1130), ',': (False, 89), '<': (False, 89), 'function': (False, 89), 'while': (False, 89), '<=': (False, 89), '(': (False, 89), '^': (True, 1136), 'do': (False, 89), '>': (False, 89), ';': (False, 89), '==': (False, 89), '~=': (False, 89), '..': (True, 1141)}, {'}': (True, 1846)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 1863), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'if': (False, 85), 'goto': (False, 85), '%': (True, 1134), 'return': (False, 85), 'for': (False, 85), 'local': (False, 85), 'or': (False, 85), 'EMBEDSTAT': (False, 85), 'break': (False, 85), 'while': (False, 85), '*': (True, 1133), '>=': (True, 1129), '-': (True, 1137), '/': (True, 1139), 'repeat': (False, 85), '::': (False, 85), 'NAME': (False, 85), 'and': (True, 1127), '+': (True, 1130), '<=': (True, 1125), '<': (True, 1131), 'function': (False, 85), 'until': (False, 85), ',': (False, 85), '(': (False, 85), '^': (True, 1136), 'do': (False, 85), '>': (True, 1132), ';': (False, 85), '==': (True, 1135), '..': (True, 1141), '~=': (True, 1140)}, {'(': (True, 867), 'args': (True, 1556), 'tableconstructor': (True, 870), 'STRING': (True, 869), '{': (True, 872)}, {'if': (False, 86), 'or': (False, 86), '%': (True, 1134), 'repeat': (False, 86), 'NAME': (False, 86), 'for': (False, 86), 'EMBEDSTAT': (False, 86), 'break': (False, 86), 'until': (False, 86), '*': (True, 1133), '>=': (True, 1129), '-': (True, 1137), '/': (True, 1139), 'local': (False, 86), '::': (False, 86), 'return': (False, 86), 'and': (False, 86), '+': (True, 1130), '<=': (True, 1125), '<': (True, 1131), 'goto': (False, 86), 'while': (False, 86), ',': (False, 86), '(': (False, 86), '^': (True, 1136), 'do': (False, 86), '>': (True, 1132), ';': (False, 86), '==': (True, 1135), '..': (True, 1141), 'function': (False, 86), '~=': (True, 1140)}, {'if': (False, 29), 'or': (True, 1126), '%': (True, 1134), 'return': (False, 29), 'for': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'break': (False, 29), 'until': (False, 29), '*': (True, 1133), '>=': (True, 1129), '-': (True, 1137), '/': (True, 1139), 'repeat': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 1127), '+': (True, 1130), ',': (True, 1128), '<': (True, 1131), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 1125), '(': (False, 29), '^': (True, 1136), 'do': (False, 29), '>': (True, 1132), ';': (False, 29), '==': (True, 1135), '~=': (True, 1140), 'explist__1': (True, 1667), 'function': (False, 29), '..': (True, 1141)}, {')': (True, 1698)}, {'if': (False, 90), 'or': (False, 90), '%': (True, 1134), 'return': (False, 90), 'for': (False, 90), 'local': (False, 90), 'EMBEDSTAT': (False, 90), 'break': (False, 90), 'until': (False, 90), '*': (True, 1133), '>=': (False, 90), '-': (True, 1137), '/': (True, 1139), 'repeat': (False, 90), '::': (False, 90), 'NAME': (False, 90), 'and': (False, 90), '+': (True, 1130), ',': (False, 90), '<': (False, 90), 'goto': (False, 90), 'while': (False, 90), '<=': (False, 90), '(': (False, 90), '^': (True, 1136), 'do': (False, 90), '>': (False, 90), ';': (False, 90), '==': (False, 90), '~=': (False, 90), 'function': (False, 90), '..': (True, 1141)}, {'if': (False, 94), 'or': (False, 94), '%': (True, 1134), 'repeat': (False, 94), 'return': (False, 94), 'for': (False, 94), 'EMBEDSTAT': (False, 94), 'break': (False, 94), 'while': (False, 94), '*': (True, 1133), '>=': (False, 94), '-': (False, 94), '/': (True, 1139), 'local': (False, 94), '::': (False, 94), 'NAME': (False, 94), 'and': (False, 94), '+': (False, 94), ',': (False, 94), '<': (False, 94), 'goto': (False, 94), 'until': (False, 94), '<=': (False, 94), '(': (False, 94), '^': (True, 1136), 'do': (False, 94), '>': (False, 94), ';': (False, 94), '==': (False, 94), '~=': (False, 94), 'function': (False, 94), '..': (False, 94)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1530), 'or': (True, 346)}, {'if': (False, 87), 'goto': (False, 87), '%': (True, 1134), 'repeat': (False, 87), 'NAME': (False, 87), 'for': (False, 87), 'or': (False, 87), 'EMBEDSTAT': (False, 87), 'break': (False, 87), 'while': (False, 87), '*': (True, 1133), '>=': (False, 87), '-': (True, 1137), '/': (True, 1139), 'local': (False, 87), '::': (False, 87), 'return': (False, 87), 'and': (False, 87), '+': (True, 1130), ',': (False, 87), '<': (False, 87), 'function': (False, 87), 'until': (False, 87), '<=': (False, 87), '(': (False, 87), '^': (True, 1136), 'do': (False, 87), '>': (False, 87), ';': (False, 87), '==': (False, 87), '~=': (False, 87), '..': (True, 1141)}, {'if': (False, 52), 'NAME': (False, 52), 'function': (False, 52), '::': (False, 52), 'repeat': (False, 52), 'return': (False, 52), 'elseif': (False, 52), 'else': (False, 52), 'for': (False, 52), 'goto': (False, 52), 'while': (False, 52), '(': (False, 52), 'EMBEDSTAT': (False, 52), 'end': (False, 52), 'do': (False, 52), 'break': (False, 52), ';': (False, 52), 'local': (False, 52)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1699)}, {'if': (False, 88), 'or': (False, 88), '%': (True, 1134), 'repeat': (False, 88), 'return': (False, 88), 'for': (False, 88), 'EMBEDSTAT': (False, 88), 'goto': (False, 88), 'break': (False, 88), 'until': (False, 88), '*': (True, 1133), '>=': (False, 88), '-': (True, 1137), '/': (True, 1139), 'local': (False, 88), '::': (False, 88), 'NAME': (False, 88), 'and': (False, 88), '+': (True, 1130), '<=': (False, 88), '<': (False, 88), 'function': (False, 88), 'while': (False, 88), ',': (False, 88), '(': (False, 88), '^': (True, 1136), 'do': (False, 88), '>': (False, 88), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '..': (True, 1141)}, {'}': (True, 1642)}, {'if': (False, 96), 'goto': (False, 96), '>=': (False, 96), 'return': (False, 96), 'for': (False, 96), 'local': (False, 96), 'or': (False, 96), 'EMBEDSTAT': (False, 96), 'break': (False, 96), 'while': (False, 96), '*': (False, 96), '%': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '::': (False, 96), 'NAME': (False, 96), 'and': (False, 96), '+': (False, 96), ',': (False, 96), '<': (False, 96), 'function': (False, 96), 'until': (False, 96), '<=': (False, 96), '(': (False, 96), '^': (True, 1136), 'do': (False, 96), '>': (False, 96), ';': (False, 96), '==': (False, 96), '..': (False, 96), '~=': (False, 96)}, {'if': (False, 98), 'goto': (False, 98), '>=': (False, 98), 'return': (False, 98), 'for': (False, 98), 'local': (False, 98), 'or': (False, 98), 'EMBEDSTAT': (False, 98), 'break': (False, 98), 'until': (False, 98), '*': (False, 98), '%': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '::': (False, 98), 'NAME': (False, 98), 'and': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), 'function': (False, 98), 'while': (False, 98), '<=': (False, 98), '(': (False, 98), '^': (True, 1136), 'do': (False, 98), '>': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '..': (False, 98)}, {')': (True, 1558)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1700), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'if': (False, 92), 'or': (False, 92), '%': (True, 1134), 'repeat': (False, 92), 'return': (False, 92), 'for': (False, 92), 'EMBEDSTAT': (False, 92), 'break': (False, 92), 'while': (False, 92), '*': (True, 1133), '>=': (False, 92), '-': (True, 1137), '/': (True, 1139), 'local': (False, 92), '::': (False, 92), 'NAME': (False, 92), 'and': (False, 92), '+': (True, 1130), ',': (False, 92), '<': (False, 92), 'goto': (False, 92), 'until': (False, 92), '<=': (False, 92), '(': (False, 92), '^': (True, 1136), 'do': (False, 92), '>': (False, 92), ';': (False, 92), '==': (False, 92), '~=': (False, 92), 'function': (False, 92), '..': (True, 1141)}, {'if': (False, 101), 'goto': (False, 101), '%': (False, 101), 'repeat': (False, 101), 'NAME': (False, 101), 'for': (False, 101), 'or': (False, 101), 'EMBEDSTAT': (False, 101), 'break': (False, 101), '*': (False, 101), '>=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '::': (False, 101), 'return': (False, 101), 'and': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'function': (False, 101), 'while': (False, 101), ',': (False, 101), '(': (False, 101), 'EOF': (False, 101), '^': (True, 1546), 'do': (False, 101), '>': (False, 101), ';': (False, 101), '==': (False, 101), '~=': (False, 101), '..': (False, 101)}, {'if': (False, 99), 'or': (False, 99), '>=': (False, 99), 'repeat': (False, 99), 'NAME': (False, 99), 'for': (False, 99), 'EMBEDSTAT': (False, 99), 'break': (False, 99), 'until': (False, 99), '*': (False, 99), '%': (False, 99), '-': (False, 99), '/': (False, 99), 'local': (False, 99), '::': (False, 99), 'return': (False, 99), 'and': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), 'goto': (False, 99), 'while': (False, 99), ',': (False, 99), '(': (False, 99), '^': (True, 1136), 'do': (False, 99), '>': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), 'function': (False, 99), '~=': (False, 99)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1573), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1575), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'NAME': (False, 13), 'for': (False, 13), 'local': (False, 13), 'EMBEDSTAT': (False, 13), 'break': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'repeat': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), ',': (False, 13), '<': (False, 13), 'goto': (False, 13), 'while': (False, 13), '<=': (False, 13), '(': (False, 13), 'EOF': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '~=': (False, 13), 'function': (False, 13), '..': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'break': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), 'goto': (False, 12), 'while': (False, 12), '<=': (False, 12), '(': (False, 12), 'EOF': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1586)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1588), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '%': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'goto': (False, 107), 'break': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), ',': (False, 107), '(': (False, 107), 'EOF': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 1592)}, {'if': (False, 95), 'or': (False, 95), '%': (True, 1134), 'NAME': (False, 95), 'for': (False, 95), 'local': (False, 95), 'EMBEDSTAT': (False, 95), 'goto': (False, 95), 'break': (False, 95), 'while': (False, 95), '*': (True, 1133), '>=': (False, 95), '-': (False, 95), '/': (True, 1139), 'repeat': (False, 95), '::': (False, 95), 'return': (False, 95), 'and': (False, 95), '+': (False, 95), ',': (False, 95), '<': (False, 95), 'function': (False, 95), 'until': (False, 95), '<=': (False, 95), '(': (False, 95), '^': (True, 1136), 'do': (False, 95), '>': (False, 95), ';': (False, 95), '==': (False, 95), '~=': (False, 95), '..': (False, 95)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'until': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), ';': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1587), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'}': (True, 1557)}, {'if': (False, 97), 'function': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), 'for': (False, 97), 'or': (False, 97), 'EMBEDSTAT': (False, 97), 'break': (False, 97), 'while': (False, 97), '*': (False, 97), '%': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '::': (False, 97), 'NAME': (False, 97), 'and': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'goto': (False, 97), 'until': (False, 97), ',': (False, 97), '(': (False, 97), '^': (True, 1136), 'do': (False, 97), '>': (False, 97), ';': (False, 97), '==': (False, 97), '~=': (False, 97), '..': (False, 97)}, {'if': (False, 60), 'goto': (False, 60), '%': (False, 60), 'repeat': (False, 60), 'return': (False, 60), 'for': (False, 60), 'or': (False, 60), 'EMBEDSTAT': (False, 60), 'break': (False, 60), '*': (False, 60), '>=': (False, 60), '-': (False, 60), '/': (False, 60), 'local': (False, 60), '::': (False, 60), 'NAME': (False, 60), 'and': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), 'function': (False, 60), 'while': (False, 60), '<=': (False, 60), '(': (False, 60), 'EOF': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), ';': (False, 60), '==': (False, 60), '~=': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1715)}, {'if': (False, 102), 'goto': (False, 102), '>=': (False, 102), 'NAME': (False, 102), 'for': (False, 102), 'local': (False, 102), 'or': (False, 102), 'EMBEDSTAT': (False, 102), 'break': (False, 102), '*': (False, 102), '%': (False, 102), '-': (False, 102), '/': (False, 102), 'repeat': (False, 102), '::': (False, 102), 'return': (False, 102), 'and': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'function': (False, 102), 'while': (False, 102), ',': (False, 102), '(': (False, 102), 'EOF': (False, 102), '^': (True, 1546), 'do': (False, 102), '>': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '~=': (False, 102)}, {'if': (False, 91), 'function': (False, 91), '%': (True, 1134), 'return': (False, 91), 'for': (False, 91), 'local': (False, 91), 'or': (False, 91), 'EMBEDSTAT': (False, 91), 'break': (False, 91), 'while': (False, 91), '*': (True, 1133), '>=': (False, 91), '-': (True, 1137), '/': (True, 1139), 'repeat': (False, 91), '::': (False, 91), 'NAME': (False, 91), 'and': (False, 91), '+': (True, 1130), ',': (False, 91), '<': (False, 91), 'goto': (False, 91), 'until': (False, 91), '<=': (False, 91), '(': (False, 91), '^': (True, 1136), 'do': (False, 91), '>': (False, 91), ';': (False, 91), '==': (False, 91), '~=': (False, 91), '..': (True, 1141)}, {'*': (True, 450), '/': (True, 457), '^': (True, 445), 'and': (True, 446), '%': (True, 447), '+': (True, 448), '>': (True, 459), '<=': (True, 444), '>=': (True, 451), '==': (True, 456), '..': (True, 458), '-': (True, 454), '<': (True, 452), 'then': (True, 1618), '~=': (True, 453), 'or': (True, 455)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), '%': (False, 99), '<=': (False, 99), '^': (True, 891), ';': (False, 99), '>': (False, 99), '*': (False, 99), 'end': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), ']': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'(': (True, 735), 'args': (True, 1419), 'tableconstructor': (True, 738), 'STRING': (True, 737), '{': (True, 740)}, {'if': (False, 93), 'or': (False, 93), '%': (True, 1134), 'repeat': (False, 93), 'NAME': (False, 93), 'for': (False, 93), 'EMBEDSTAT': (False, 93), 'goto': (False, 93), 'break': (False, 93), 'while': (False, 93), '*': (True, 1133), '>=': (False, 93), '-': (True, 1137), '/': (True, 1139), 'local': (False, 93), '::': (False, 93), 'return': (False, 93), 'and': (False, 93), '+': (True, 1130), ',': (False, 93), '<': (False, 93), 'function': (False, 93), 'until': (False, 93), '<=': (False, 93), '(': (False, 93), '^': (True, 1136), 'do': (False, 93), '>': (False, 93), ';': (False, 93), '==': (False, 93), '~=': (False, 93), '..': (True, 1141)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 884), '+': (False, 95), '<=': (False, 95), '<': (False, 95), '>=': (False, 95), ',': (False, 95), '^': (True, 891), 'end': (False, 95), '>': (False, 95), '*': (True, 888), ';': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 895), '~=': (False, 95)}, {'}': (True, 1798)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ')': (False, 38), ',': (False, 38), '(': (False, 38), '^': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '~=': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '..': (False, 38), '.': (False, 38)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 884), '+': (True, 885), ',': (False, 90), '<': (False, 90), '>=': (False, 90), '<=': (False, 90), '^': (True, 891), ';': (False, 90), '>': (False, 90), '*': (True, 888), 'end': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'(': (True, 1226), 'args': (True, 1762), 'tableconstructor': (True, 1228), 'STRING': (True, 1227), '{': (True, 1229)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), '>=': (False, 97), ',': (False, 97), '^': (True, 891), 'end': (False, 97), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 884), '+': (True, 885), ',': (False, 93), '<': (False, 93), '>=': (False, 93), '<=': (False, 93), '^': (True, 891), ';': (False, 93), '>': (False, 93), '*': (True, 888), 'end': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 892), '/': (True, 895), '..': (True, 896)}, {'if': (False, 108), '[': (False, 108), 'function': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), 'break': (False, 108), 'while': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), 'goto': (False, 108), 'until': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), ';': (False, 108), '==': (False, 108), '..': (False, 108), '~=': (False, 108)}, {'var': (True, 583), '(': (True, 584), 'tableconstructor': (True, 585), '{': (True, 595), 'functiondef': (True, 587), 'EMBEDEXPR': (True, 588), 'NAME': (True, 589), '#': (True, 590), 'prefixexp': (True, 591), '...': (True, 592), 'true': (True, 593), 'STRING': (True, 594), 'function': (True, 586), '-': (True, 596), 'not': (True, 597), 'exp': (True, 1625), 'NUMBER': (True, 599), 'nil': (True, 600), 'false': (True, 601), 'functioncall': (True, 602)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), 'explist': (True, 1635), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 571), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'or': (False, 84), 'and': (False, 84), '%': (False, 84), '+': (False, 84), '<=': (False, 84), 'else': (False, 84), '<': (False, 84), '>=': (False, 84), ',': (False, 84), '^': (False, 84), 'end': (False, 84), '>': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), '-': (False, 84), 'elseif': (False, 84), '/': (False, 84), '..': (False, 84)}, {'[': (False, 37), 'or': (False, 37), 'and': (False, 37), '%': (False, 37), '+': (False, 37), '<=': (False, 37), '~=': (False, 37), 'else': (False, 37), '<': (False, 37), ',': (False, 37), '(': (False, 37), ';': (False, 37), '^': (False, 37), 'end': (False, 37), ':': (False, 37), '>': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '==': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), 'elseif': (False, 37), '/': (False, 37), '..': (False, 37)}, {'elseif': (False, 1), 'retstat__2': (True, 1576), 'end': (False, 1), 'else': (False, 1), ';': (True, 1577)}, {'[': (True, 1579), 'tableconstructor': (True, 1581), 'or': (False, 83), 'and': (False, 83), '>=': (False, 83), 'args': (True, 1584), '+': (False, 83), ',': (False, 83), 'else': (False, 83), '<': (False, 83), '%': (False, 83), 'elseif': (False, 83), '(': (True, 1578), '^': (False, 83), 'end': (False, 83), '..': (False, 83), ':': (True, 1585), '>': (False, 83), '*': (False, 83), ';': (False, 83), 'STRING': (True, 1580), '==': (False, 83), '.': (True, 1582), '{': (True, 1583), '-': (False, 83), '<=': (False, 83), '/': (False, 83), '~=': (False, 83)}, {'or': (False, 77), 'and': (False, 77), '%': (False, 77), '+': (False, 77), 'elseif': (False, 77), 'else': (False, 77), '<': (False, 77), '>=': (False, 77), ',': (False, 77), '^': (False, 77), ';': (False, 77), '>': (False, 77), '*': (False, 77), 'end': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '<=': (False, 77), '/': (False, 77), '..': (False, 77)}, {'funcbody': (True, 1589), '(': (True, 1590)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1593), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'or': (False, 76), 'and': (False, 76), '>=': (False, 76), '+': (False, 76), '<=': (False, 76), 'else': (False, 76), '<': (False, 76), '%': (False, 76), ',': (False, 76), '^': (False, 76), ';': (False, 76), '>': (False, 76), '*': (False, 76), 'end': (False, 76), '==': (False, 76), '~=': (False, 76), '-': (False, 76), 'elseif': (False, 76), '/': (False, 76), '..': (False, 76)}, {'[': (False, 18), 'or': (False, 18), 'and': (False, 18), '%': (False, 18), '+': (False, 18), ',': (False, 18), '~=': (False, 18), 'else': (False, 18), '<': (False, 18), 'elseif': (False, 18), '(': (False, 18), ';': (False, 18), '^': (False, 18), 'end': (False, 18), ':': (False, 18), '>': (False, 18), '*': (False, 18), '>=': (False, 18), 'STRING': (False, 18), '==': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '<=': (False, 18), '/': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'functiondef': (True, 187), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1598), 'NUMBER': (True, 199), 'nil': (True, 200), 'false': (True, 201), 'functioncall': (True, 202)}, {'or': (False, 82), 'and': (False, 82), '%': (False, 82), '+': (False, 82), ',': (False, 82), 'else': (False, 82), '<': (False, 82), '>=': (False, 82), '<=': (False, 82), '^': (False, 82), ';': (False, 82), '>': (False, 82), '*': (False, 82), 'end': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), 'elseif': (False, 82), '/': (False, 82), '~=': (False, 82)}, {'or': (False, 80), 'and': (False, 80), '%': (False, 80), '+': (False, 80), 'elseif': (False, 80), 'else': (False, 80), '<': (False, 80), '>=': (False, 80), ',': (False, 80), '^': (False, 80), 'end': (False, 80), '>': (False, 80), '*': (False, 80), ';': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), '<=': (False, 80), '/': (False, 80), '..': (False, 80)}, {'or': (False, 78), 'and': (False, 78), '%': (False, 78), '+': (False, 78), 'elseif': (False, 78), 'else': (False, 78), '<': (False, 78), '>=': (False, 78), ',': (False, 78), '^': (False, 78), 'end': (False, 78), '>': (False, 78), '*': (False, 78), ';': (False, 78), '==': (False, 78), '..': (False, 78), '-': (False, 78), '<=': (False, 78), '/': (False, 78), '~=': (False, 78)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1735), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'or': (False, 81), 'and': (False, 81), '%': (False, 81), '+': (False, 81), '<=': (False, 81), 'else': (False, 81), '<': (False, 81), '>=': (False, 81), ',': (False, 81), '^': (False, 81), ';': (False, 81), '>': (False, 81), '*': (False, 81), 'end': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), 'elseif': (False, 81), '/': (False, 81), '..': (False, 81)}, {'or': (False, 79), 'and': (False, 79), '%': (False, 79), '+': (False, 79), '<=': (False, 79), 'else': (False, 79), '<': (False, 79), '>=': (False, 79), ',': (False, 79), '^': (False, 79), 'end': (False, 79), '>': (False, 79), '*': (False, 79), ';': (False, 79), '==': (False, 79), '~=': (False, 79), '-': (False, 79), 'elseif': (False, 79), '/': (False, 79), '..': (False, 79)}, {'elseif': (False, 16), 'end': (False, 16), 'else': (False, 16), ';': (False, 16)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1739), 'field': (True, 244), 'NUMBER': (True, 245), 'EMBEDEXPR': (True, 246), 'functiondef': (True, 247), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1740), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {',': (True, 1744), '*': (True, 1749), 'or': (True, 1742), 'and': (True, 1743), ';': (False, 29), '%': (True, 1745), '..': (True, 1757), '+': (True, 1746), '>': (True, 1748), '<=': (True, 1741), '>=': (True, 1755), 'elseif': (False, 29), '<': (True, 1747), '^': (True, 1752), '-': (True, 1753), 'end': (False, 29), '==': (True, 1751), 'explist__1': (True, 1754), '/': (True, 1756), 'else': (False, 29), '~=': (True, 1750)}, {'or': (False, 75), 'and': (False, 75), '%': (False, 75), '+': (False, 75), ',': (False, 75), 'else': (False, 75), '<': (False, 75), '>=': (False, 75), '<=': (False, 75), '^': (False, 75), 'end': (False, 75), '>': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), 'elseif': (False, 75), '/': (False, 75), '~=': (False, 75)}, {'[': (False, 19), 'or': (False, 19), 'and': (False, 19), '%': (False, 19), '+': (False, 19), 'elseif': (False, 19), 'else': (False, 19), '<': (False, 19), '<=': (False, 19), ',': (False, 19), '(': (False, 19), '^': (False, 19), ';': (False, 19), '..': (False, 19), ':': (False, 19), '>': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '==': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), 'end': (False, 19), '/': (False, 19), '~=': (False, 19)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '~=': (False, 108), '<': (False, 108), 'until': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), ';': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108)}, {'NAME': (True, 1604)}, {'::': (False, 3), 'return': (False, 3), 'function': (False, 3), 'if': (False, 3), 'repeat': (False, 3), 'NAME': (False, 3), 'elseif': (False, 3), 'else': (False, 3), 'for': (False, 3), 'goto': (False, 3), '=': (False, 3), 'while': (False, 3), '(': (False, 3), 'EMBEDSTAT': (False, 3), ';': (False, 3), 'do': (False, 3), 'break': (False, 3), 'end': (False, 3), 'local': (False, 3)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'explist': (True, 1605), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1335), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'::': (False, 54), 'return': (False, 54), 'function': (False, 54), 'if': (False, 54), 'repeat': (False, 54), 'NAME': (False, 54), 'elseif': (False, 54), 'else': (False, 54), 'for': (False, 54), 'goto': (False, 54), 'while': (False, 54), '(': (False, 54), 'EMBEDSTAT': (False, 54), ';': (False, 54), 'do': (False, 54), 'break': (False, 54), 'end': (False, 54), 'local': (False, 54)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 797), '+': (True, 798), ',': (False, 89), '<': (False, 89), '>=': (False, 89), 'until': (False, 89), '<=': (False, 89), '^': (True, 795), '>': (False, 89), '*': (True, 800), ';': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'*': (True, 800), ';': (False, 86), 'or': (False, 86), '^': (True, 795), ',': (False, 86), '%': (True, 797), '+': (True, 798), '>': (True, 799), '<=': (True, 793), '>=': (True, 801), '<': (True, 802), '~=': (True, 808), '-': (True, 804), '==': (True, 805), '/': (True, 807), 'and': (False, 86), 'until': (False, 86), '..': (True, 803)}, {'funcbody': (True, 1471), '(': (True, 1355)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), '%': (False, 99), 'until': (False, 99), '<=': (False, 99), '^': (True, 795), '>': (False, 99), '*': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {',': (True, 796), '*': (True, 800), '^': (True, 795), 'and': (True, 794), ';': (False, 29), '%': (True, 797), '+': (True, 798), '>': (True, 799), '<=': (True, 793), '>=': (True, 801), '~=': (True, 808), '<': (True, 802), 'explist__1': (True, 1766), '-': (True, 804), '==': (True, 805), '/': (True, 807), 'until': (False, 29), '..': (True, 803), 'or': (True, 809)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), '%': (False, 98), 'until': (False, 98), '<=': (False, 98), '^': (True, 795), '>': (False, 98), '*': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 797), '+': (False, 94), ',': (False, 94), '<': (False, 94), 'until': (False, 94), '<=': (False, 94), '^': (True, 795), ';': (False, 94), '>': (False, 94), '*': (True, 800), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 807), '~=': (False, 94)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), ')': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), '..': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '~=': (False, 20)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 797), '+': (True, 798), ',': (False, 88), '<': (False, 88), '>=': (False, 88), 'until': (False, 88), '<=': (False, 88), '^': (True, 795), '>': (False, 88), '*': (True, 800), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), '%': (False, 96), 'until': (False, 96), ',': (False, 96), '^': (True, 795), '>': (False, 96), '*': (False, 96), ';': (False, 96), '==': (False, 96), '..': (False, 96), '-': (False, 96), '/': (False, 96), '~=': (False, 96)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 797), '+': (True, 798), ',': (False, 90), '<': (False, 90), '>=': (False, 90), 'until': (False, 90), '<=': (False, 90), '^': (True, 795), '>': (False, 90), '*': (True, 800), ';': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), ')': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 797), '+': (True, 798), '<=': (False, 87), '<': (False, 87), '>=': (False, 87), 'until': (False, 87), ',': (False, 87), '^': (True, 795), '>': (False, 87), '*': (True, 800), ';': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 908), '+': (True, 909), ',': (False, 89), '<': (False, 89), ')': (False, 89), '<=': (False, 89), '^': (True, 906), '>': (False, 89), '*': (True, 911), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {')': (False, 86), '*': (True, 911), 'or': (False, 86), '^': (True, 906), ',': (False, 86), '%': (True, 908), '+': (True, 909), '>': (True, 910), '<=': (True, 904), '>=': (True, 912), '<': (True, 913), '..': (True, 914), '-': (True, 915), '==': (True, 916), '/': (True, 918), 'and': (False, 86), '~=': (True, 919)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 797), '+': (True, 798), ',': (False, 93), '<': (False, 93), '>=': (False, 93), 'until': (False, 93), '<=': (False, 93), '^': (True, 795), '>': (False, 93), '*': (True, 800), ';': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), ')': (False, 99), '<=': (False, 99), '^': (True, 906), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 797), '+': (False, 95), '<=': (False, 95), '<': (False, 95), '>=': (False, 95), 'until': (False, 95), ',': (False, 95), '^': (True, 795), '>': (False, 95), '*': (True, 800), ';': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 807), '~=': (False, 95)}, {',': (True, 907), '*': (True, 911), '^': (True, 906), 'and': (True, 905), '%': (True, 908), '..': (True, 914), '+': (True, 909), '>': (True, 910), '<=': (True, 904), '>=': (True, 912), '<': (True, 913), 'explist__1': (True, 1867), '-': (True, 915), '==': (True, 916), '/': (True, 918), ')': (False, 29), '~=': (True, 919), 'or': (True, 920)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 797), '+': (True, 798), ',': (False, 92), '<': (False, 92), '>=': (False, 92), 'until': (False, 92), '<=': (False, 92), '^': (True, 795), '>': (False, 92), '*': (True, 800), ';': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), ')': (False, 98), '<=': (False, 98), '^': (True, 906), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 908), '+': (False, 94), ',': (False, 94), '<': (False, 94), ')': (False, 94), '<=': (False, 94), '^': (True, 906), '>': (False, 94), '*': (True, 911), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 918), '~=': (False, 94)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), '>=': (False, 97), 'until': (False, 97), ',': (False, 97), '^': (True, 795), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 908), '+': (True, 909), ',': (False, 88), '<': (False, 88), ')': (False, 88), '<=': (False, 88), '^': (True, 906), '>': (False, 88), '*': (True, 911), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 797), '+': (True, 798), '<=': (False, 91), '<': (False, 91), 'until': (False, 91), ',': (False, 91), '^': (True, 795), ';': (False, 91), '>': (False, 91), '*': (True, 800), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 804), '/': (True, 807), '..': (True, 803)}, {'EOF': (False, 0)}, {'EOF': (False, 74)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), ')': (False, 96), ',': (False, 96), '^': (True, 906), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'*': (True, 800), '^': (True, 795), 'and': (True, 794), ';': (False, 85), '%': (True, 797), '+': (True, 798), '>': (True, 799), '<=': (True, 793), '>=': (True, 801), ',': (False, 85), '<': (True, 802), '~=': (True, 808), '-': (True, 804), '==': (True, 805), '/': (True, 807), 'until': (False, 85), '..': (True, 803), 'or': (False, 85)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1795), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1797), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), ',': (False, 13), '(': (False, 13), 'EOF': (False, 13), '^': (False, 13), ';': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '%': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), '<=': (False, 12), '(': (False, 12), 'EOF': (False, 12), '^': (False, 12), ';': (False, 12), '..': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '>=': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1799)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1800), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '~=': (False, 107), '<': (False, 107), '>=': (False, 107), ',': (False, 107), '(': (False, 107), 'EOF': (False, 107), '^': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), ';': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), '..': (False, 107)}, {'NAME': (True, 1801)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 908), '+': (True, 909), ',': (False, 90), '<': (False, 90), ')': (False, 90), '<=': (False, 90), '^': (True, 906), '>': (False, 90), '*': (True, 911), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 908), '+': (True, 909), '<=': (False, 87), '<': (False, 87), ')': (False, 87), ',': (False, 87), '^': (True, 906), '>': (False, 87), '*': (True, 911), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), '<': (False, 60), '>=': (False, 60), '<=': (False, 60), 'EOF': (False, 60), '^': (False, 60), '>': (False, 60), '*': (False, 60), ';': (False, 60), '==': (False, 60), '..': (False, 60), '-': (False, 60), '/': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1559)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 908), '+': (True, 909), ',': (False, 93), '<': (False, 93), ')': (False, 93), '<=': (False, 93), '^': (True, 906), '>': (False, 93), '*': (True, 911), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), ',': (False, 100), '<': (False, 100), '%': (False, 100), '<=': (False, 100), 'EOF': (False, 100), '^': (True, 1485), '>': (False, 100), '*': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), '..': (False, 100)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 908), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ')': (False, 95), ',': (False, 95), '^': (True, 906), '>': (False, 95), '*': (True, 911), '>=': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 918), '~=': (False, 95)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 908), '+': (True, 909), ',': (False, 92), '<': (False, 92), ')': (False, 92), '<=': (False, 92), '^': (True, 906), '>': (False, 92), '*': (True, 911), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1554), 'or': (True, 346)}, {'::': (False, 53), 'NAME': (False, 53), 'goto': (False, 53), 'if': (False, 53), 'return': (False, 53), 'elseif': (False, 53), 'else': (False, 53), 'for': (False, 53), 'function': (False, 53), 'local': (False, 53), 'while': (False, 53), '(': (False, 53), 'EMBEDSTAT': (False, 53), 'end': (False, 53), 'do': (False, 53), 'break': (False, 53), ';': (False, 53), 'repeat': (False, 53)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), ')': (False, 97), ',': (False, 97), '^': (True, 906), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1889), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 908), '+': (True, 909), '<=': (False, 91), '<': (False, 91), ')': (False, 91), ',': (False, 91), '^': (True, 906), '>': (False, 91), '*': (True, 911), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 915), '/': (True, 918), '..': (True, 914)}, {'*': (True, 911), '^': (True, 906), 'and': (True, 905), ',': (False, 85), '%': (True, 908), '+': (True, 909), '>': (True, 910), '<=': (True, 904), '>=': (True, 912), '<': (True, 913), '~=': (True, 919), '-': (True, 915), '==': (True, 916), '/': (True, 918), ')': (False, 85), '..': (True, 914), 'or': (False, 85)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), '>=': (False, 101), ',': (False, 101), 'EOF': (False, 101), '^': (True, 1485), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'}': (True, 1803)}, {')': (True, 1804)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), '<': (False, 102), '%': (False, 102), '<=': (False, 102), 'EOF': (False, 102), '^': (True, 1485), '>': (False, 102), '*': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1669), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {')': (True, 1768)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1771), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1773), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1775), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1776), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1822), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1825), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1828), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1830), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1831), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1832), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1833), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1836), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1837), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {';': (False, 71), 'EOF': (False, 71)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1839), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1841), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'var': (True, 939), '(': (True, 940), 'tableconstructor': (True, 931), 'function': (True, 936), 'NUMBER': (True, 943), 'EMBEDEXPR': (True, 942), 'NAME': (True, 932), '#': (True, 944), 'prefixexp': (True, 934), '...': (True, 945), 'true': (True, 935), 'STRING': (True, 946), '{': (True, 948), '-': (True, 949), 'not': (True, 937), 'exp': (True, 1842), 'functioncall': (True, 952), 'nil': (True, 951), 'false': (True, 938), 'functiondef': (True, 941)}, {'elseif': (True, 1241), 'end': (False, 15), 'else': (False, 15), 'stat__1': (True, 1886)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ')': (False, 38), '(': (False, 38), '^': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '~=': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '..': (False, 38), '.': (False, 38)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'}': (True, 1760)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'goto': (False, 18), 'break': (False, 18), 'while': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), 'function': (False, 18), 'until': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1621), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), 'break': (False, 37), 'while': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), 'goto': (False, 37), 'until': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), ';': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'::': (False, 84), 'return': (False, 84), 'goto': (False, 84), 'and': (False, 84), 'if': (False, 84), '%': (False, 84), 'repeat': (False, 84), 'NAME': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), 'for': (False, 84), 'function': (False, 84), '>=': (False, 84), '>': (False, 84), 'while': (False, 84), 'or': (False, 84), '(': (False, 84), 'EMBEDSTAT': (False, 84), '^': (False, 84), 'do': (False, 84), 'break': (False, 84), 'until': (False, 84), '*': (False, 84), ';': (False, 84), '==': (False, 84), '..': (False, 84), '-': (False, 84), '/': (False, 84), 'local': (False, 84), '~=': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1623), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'::': (False, 82), 'return': (False, 82), 'or': (False, 82), 'and': (False, 82), 'if': (False, 82), '%': (False, 82), 'NAME': (False, 82), '+': (False, 82), '<=': (False, 82), 'until': (False, 82), '<': (False, 82), 'for': (False, 82), 'goto': (False, 82), 'local': (False, 82), 'while': (False, 82), '(': (False, 82), 'EMBEDSTAT': (False, 82), '^': (False, 82), ';': (False, 82), 'do': (False, 82), 'break': (False, 82), '>': (False, 82), '*': (False, 82), '>=': (False, 82), '==': (False, 82), '..': (False, 82), '-': (False, 82), 'function': (False, 82), '/': (False, 82), 'repeat': (False, 82), '~=': (False, 82)}, {'::': (False, 80), 'while': (False, 80), 'NAME': (False, 80), 'or': (False, 80), 'and': (False, 80), 'if': (False, 80), '%': (False, 80), 'repeat': (False, 80), 'return': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'for': (False, 80), 'goto': (False, 80), 'until': (False, 80), '(': (False, 80), 'EMBEDSTAT': (False, 80), '^': (False, 80), ';': (False, 80), 'do': (False, 80), 'break': (False, 80), '>': (False, 80), '*': (False, 80), '>=': (False, 80), '==': (False, 80), '~=': (False, 80), '-': (False, 80), 'function': (False, 80), '/': (False, 80), 'local': (False, 80), '..': (False, 80)}, {'::': (False, 78), 'return': (False, 78), 'or': (False, 78), 'and': (False, 78), 'if': (False, 78), '%': (False, 78), 'NAME': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'for': (False, 78), 'function': (False, 78), 'local': (False, 78), '>': (False, 78), 'while': (False, 78), '(': (False, 78), 'EMBEDSTAT': (False, 78), '^': (False, 78), ';': (False, 78), 'goto': (False, 78), 'do': (False, 78), 'break': (False, 78), 'until': (False, 78), '*': (False, 78), '>=': (False, 78), '==': (False, 78), '~=': (False, 78), '-': (False, 78), '/': (False, 78), 'repeat': (False, 78), '..': (False, 78)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1626), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'if': (False, 83), '[': (True, 1628), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), 'goto': (False, 83), 'break': (False, 83), 'until': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1629), '.': (True, 1631), '{': (True, 1632), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 1630), 'and': (False, 83), 'args': (True, 1633), '+': (False, 83), '<=': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '(': (True, 1627), '^': (False, 83), 'do': (False, 83), ':': (True, 1634), '>': (False, 83), ';': (False, 83), '==': (False, 83), '~=': (False, 83), '..': (False, 83)}, {'::': (False, 81), 'return': (False, 81), 'goto': (False, 81), 'and': (False, 81), 'if': (False, 81), '%': (False, 81), 'NAME': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), 'for': (False, 81), 'function': (False, 81), 'local': (False, 81), '>': (False, 81), 'while': (False, 81), 'or': (False, 81), '(': (False, 81), 'EMBEDSTAT': (False, 81), '^': (False, 81), ';': (False, 81), 'do': (False, 81), 'break': (False, 81), 'until': (False, 81), '*': (False, 81), '>=': (False, 81), '==': (False, 81), '~=': (False, 81), '-': (False, 81), '/': (False, 81), 'repeat': (False, 81), '..': (False, 81)}, {'::': (False, 77), 'NAME': (False, 77), 'goto': (False, 77), 'and': (False, 77), 'if': (False, 77), '%': (False, 77), 'repeat': (False, 77), 'return': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'for': (False, 77), 'function': (False, 77), '>': (False, 77), 'while': (False, 77), 'or': (False, 77), '(': (False, 77), 'EMBEDSTAT': (False, 77), '^': (False, 77), ';': (False, 77), 'do': (False, 77), 'break': (False, 77), 'until': (False, 77), '*': (False, 77), '>=': (False, 77), '==': (False, 77), '~=': (False, 77), '-': (False, 77), '/': (False, 77), 'local': (False, 77), '..': (False, 77)}, {'::': (False, 79), 'NAME': (False, 79), 'goto': (False, 79), 'and': (False, 79), 'if': (False, 79), '%': (False, 79), 'return': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'for': (False, 79), 'function': (False, 79), 'local': (False, 79), '>': (False, 79), 'while': (False, 79), 'or': (False, 79), '(': (False, 79), 'EMBEDSTAT': (False, 79), '^': (False, 79), ';': (False, 79), 'do': (False, 79), 'break': (False, 79), 'until': (False, 79), '*': (False, 79), '>=': (False, 79), '==': (False, 79), '..': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '~=': (False, 79)}, {'funcbody': (True, 1638), '(': (True, 1639)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1640), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1641), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'if': (False, 48), 'while': (False, 48), 'NAME': (False, 48), 'or': (True, 1644), 'and': (True, 1645), '::': (False, 48), '%': (True, 1650), 'return': (False, 48), '+': (True, 1647), '<=': (True, 1643), '<': (True, 1655), 'for': (False, 48), 'goto': (False, 48), 'local': (False, 48), 'until': (False, 48), '(': (False, 48), 'EMBEDSTAT': (False, 48), '^': (True, 1654), ';': (False, 48), 'do': (False, 48), 'break': (False, 48), '>': (True, 1648), '*': (True, 1649), '>=': (True, 1646), '==': (True, 1651), '..': (True, 1652), '-': (True, 1653), 'function': (False, 48), '/': (True, 1656), 'repeat': (False, 48), '~=': (True, 1657)}, {'::': (False, 75), 'return': (False, 75), 'goto': (False, 75), 'and': (False, 75), 'if': (False, 75), '%': (False, 75), 'NAME': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), 'for': (False, 75), 'function': (False, 75), 'local': (False, 75), '>=': (False, 75), '>': (False, 75), 'while': (False, 75), 'or': (False, 75), '(': (False, 75), 'EMBEDSTAT': (False, 75), '^': (False, 75), 'do': (False, 75), 'break': (False, 75), 'until': (False, 75), '*': (False, 75), ';': (False, 75), '==': (False, 75), '..': (False, 75), '-': (False, 75), '/': (False, 75), 'repeat': (False, 75), '~=': (False, 75)}, {'::': (False, 76), 'return': (False, 76), 'or': (False, 76), 'and': (False, 76), 'if': (False, 76), '%': (False, 76), 'NAME': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), 'for': (False, 76), 'function': (False, 76), 'local': (False, 76), '>': (False, 76), 'while': (False, 76), '(': (False, 76), 'EMBEDSTAT': (False, 76), '^': (False, 76), ';': (False, 76), 'goto': (False, 76), 'do': (False, 76), 'break': (False, 76), 'until': (False, 76), '*': (False, 76), '>=': (False, 76), '==': (False, 76), '..': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'break': (False, 19), 'until': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), '<=': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {'if': (False, 89), 'goto': (False, 89), '%': (True, 823), 'repeat': (False, 89), 'NAME': (False, 89), 'for': (False, 89), 'or': (False, 89), 'EMBEDSTAT': (False, 89), ';': (False, 89), 'break': (False, 89), '*': (True, 822), '>=': (False, 89), '-': (True, 827), '/': (True, 829), 'local': (False, 89), '::': (False, 89), 'return': (False, 89), 'and': (False, 89), '+': (True, 819), ',': (False, 89), '<': (False, 89), 'function': (False, 89), 'while': (False, 89), '<=': (False, 89), '(': (False, 89), '^': (True, 826), 'do': (False, 89), '>': (False, 89), 'end': (False, 89), '==': (False, 89), '~=': (False, 89), '..': (True, 830)}, {'(': (True, 965), 'args': (True, 1608), 'tableconstructor': (True, 968), 'STRING': (True, 967), '{': (True, 970)}, {'if': (False, 85), 'goto': (False, 85), '%': (True, 823), 'return': (False, 85), 'for': (False, 85), 'local': (False, 85), 'or': (False, 85), 'EMBEDSTAT': (False, 85), 'end': (False, 85), 'break': (False, 85), '*': (True, 822), '>=': (True, 818), '-': (True, 827), '/': (True, 829), 'repeat': (False, 85), '::': (False, 85), 'NAME': (False, 85), 'and': (True, 816), '+': (True, 819), '<=': (True, 814), '<': (True, 820), 'function': (False, 85), 'while': (False, 85), ',': (False, 85), '(': (False, 85), '^': (True, 826), 'do': (False, 85), '>': (True, 821), ';': (False, 85), '==': (True, 825), '~=': (True, 824), '..': (True, 830)}, {'if': (False, 86), 'or': (False, 86), '%': (True, 823), 'repeat': (False, 86), 'NAME': (False, 86), 'for': (False, 86), 'EMBEDSTAT': (False, 86), ';': (False, 86), 'break': (False, 86), '*': (True, 822), '>=': (True, 818), '-': (True, 827), '/': (True, 829), 'local': (False, 86), '::': (False, 86), 'return': (False, 86), 'and': (False, 86), '+': (True, 819), '<=': (True, 814), '<': (True, 820), 'goto': (False, 86), 'while': (False, 86), ',': (False, 86), '(': (False, 86), '^': (True, 826), 'do': (False, 86), '>': (True, 821), 'end': (False, 86), '==': (True, 825), '~=': (True, 824), 'function': (False, 86), '..': (True, 830)}, {')': (True, 1711)}, {'end': (True, 1716)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'break': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), 'function': (False, 20), 'while': (False, 20), '<=': (False, 20), '(': (False, 20), 'EOF': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), ')': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'::': (False, 47), 'NAME': (False, 47), 'goto': (False, 47), 'if': (False, 47), 'repeat': (False, 47), 'return': (False, 47), 'for': (False, 47), 'function': (False, 47), 'while': (False, 47), '(': (False, 47), 'EMBEDSTAT': (False, 47), ';': (False, 47), 'do': (False, 47), 'break': (False, 47), 'end': (False, 47), 'local': (False, 47)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '>=': (False, 4), '<=': (False, 4), '^': (False, 4), ';': (False, 4), '>': (False, 4), '*': (False, 4), 'end': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'if': (False, 100), 'goto': (False, 100), '>=': (False, 100), 'repeat': (False, 100), 'return': (False, 100), 'for': (False, 100), 'or': (False, 100), 'EMBEDSTAT': (False, 100), 'break': (False, 100), '*': (False, 100), '%': (False, 100), '-': (False, 100), '/': (False, 100), 'local': (False, 100), '::': (False, 100), 'NAME': (False, 100), 'and': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'function': (False, 100), 'while': (False, 100), ',': (False, 100), '(': (False, 100), 'EOF': (False, 100), '^': (True, 1546), 'do': (False, 100), '>': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '..': (False, 100)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1809), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1810), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1811), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1812), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1813), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1814), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1816), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1817), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1818), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1819), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1820), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1876), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1878), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'::': (False, 71), 'NAME': (False, 71), 'function': (False, 71), 'if': (False, 71), 'return': (False, 71), 'for': (False, 71), 'goto': (False, 71), 'local': (False, 71), 'while': (False, 71), 'EMBEDSTAT': (False, 71), '(': (False, 71), 'EOF': (False, 71), 'do': (False, 71), 'break': (False, 71), ';': (False, 71), 'repeat': (False, 71)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1880), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1882), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'var': (True, 1006), '(': (True, 1007), 'NAME': (True, 1008), 'tableconstructor': (True, 1009), 'function': (True, 1020), 'NUMBER': (True, 1013), 'EMBEDEXPR': (True, 1012), 'functiondef': (True, 1011), '#': (True, 1014), 'prefixexp': (True, 1015), '...': (True, 1016), 'true': (True, 1017), 'STRING': (True, 1018), '{': (True, 1010), '-': (True, 1021), 'not': (True, 1022), 'exp': (True, 1883), 'nil': (True, 1024), 'false': (True, 1025), 'functioncall': (True, 1026)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), '~=': (False, 20), '<': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '..': (False, 20)}, {'::': (False, 4), 'return': (False, 4), 'or': (False, 4), 'and': (False, 4), 'if': (False, 4), '>=': (False, 4), 'repeat': (False, 4), 'NAME': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'for': (False, 4), 'goto': (False, 4), 'while': (False, 4), '(': (False, 4), 'EMBEDSTAT': (False, 4), '^': (False, 4), ';': (False, 4), 'do': (False, 4), 'break': (False, 4), '>': (False, 4), '*': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '-': (False, 4), 'function': (False, 4), '/': (False, 4), 'local': (False, 4), '~=': (False, 4), '%': (False, 4)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), '<=': (False, 20), '(': (False, 20), 'EOF': (False, 20), '^': (False, 20), ';': (False, 20), '..': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), '~=': (False, 20)}, {'if': (False, 4), 'goto': (False, 4), '>=': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), 'break': (False, 4), 'while': (False, 4), '*': (False, 4), '%': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'until': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), ')': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '~=': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108), '.': (False, 108)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'until': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), ';': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), '>=': (False, 11), 'until': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), ';': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {')': (True, 1565)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1566), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), ')': (False, 4), '(': (False, 4), '^': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1924), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'end': (True, 1922)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1925), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1927), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'end': (True, 1609)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), '>=': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), ';': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), 'end': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {')': (True, 1869)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1870), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (False, 46), 'NAME': (False, 46), 'function': (False, 46), 'if': (False, 46), 'return': (False, 46), 'elseif': (False, 46), 'else': (False, 46), 'for': (False, 46), 'goto': (False, 46), 'local': (False, 46), 'while': (False, 46), '(': (False, 46), 'EMBEDSTAT': (False, 46), ';': (False, 46), 'do': (False, 46), 'break': (False, 46), 'end': (False, 46), 'repeat': (False, 46)}, {'(': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '[': (False, 4), ':': (False, 4)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'NAME': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), 'break': (False, 38), 'until': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'return': (False, 38), 'and': (False, 38), '+': (False, 38), ',': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '<=': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), ';': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {')': (True, 1767)}, {'[': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '(': (False, 108), ':': (False, 108)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1815), '~=': (True, 414), 'or': (True, 419)}, {'elseif': (False, 74), 'end': (False, 74), 'else': (False, 74)}, {'elseif': (False, 0), 'end': (False, 0), 'else': (False, 0)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1928), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'functiondef': (True, 302), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1926), 'NUMBER': (True, 314), 'nil': (True, 315), 'false': (True, 316), 'functioncall': (True, 317)}, {'[': (False, 13), 'or': (False, 13), 'and': (False, 13), '%': (False, 13), '+': (False, 13), ',': (False, 13), 'else': (False, 13), '<': (False, 13), '<=': (False, 13), 'elseif': (False, 13), '(': (False, 13), '^': (False, 13), ';': (False, 13), '..': (False, 13), ':': (False, 13), '>': (False, 13), '*': (False, 13), '>=': (False, 13), 'STRING': (False, 13), '==': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), 'end': (False, 13), '/': (False, 13), '~=': (False, 13)}, {'[': (False, 12), 'or': (False, 12), 'and': (False, 12), '>=': (False, 12), '+': (False, 12), ',': (False, 12), '~=': (False, 12), 'else': (False, 12), '<': (False, 12), '<=': (False, 12), 'elseif': (False, 12), '(': (False, 12), '^': (False, 12), ';': (False, 12), ':': (False, 12), '>': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '==': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), 'end': (False, 12), '/': (False, 12), '..': (False, 12)}, {'NAME': (True, 1930)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1932), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'[': (False, 107), 'or': (False, 107), 'and': (False, 107), '%': (False, 107), '+': (False, 107), '<=': (False, 107), '~=': (False, 107), 'else': (False, 107), '<': (False, 107), '>=': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), 'end': (False, 107), ':': (False, 107), '>': (False, 107), '*': (False, 107), ';': (False, 107), 'STRING': (False, 107), '==': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), 'elseif': (False, 107), '/': (False, 107), '..': (False, 107)}, {'NAME': (True, 1933)}, {'if': (False, 39), '[': (False, 39), 'goto': (False, 39), '%': (False, 39), 'return': (False, 39), 'for': (False, 39), 'local': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'break': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'repeat': (False, 39), '::': (False, 39), 'NAME': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'function': (False, 39), 'while': (False, 39), ',': (False, 39), '(': (False, 39), 'EOF': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '..': (False, 39), '~=': (False, 39)}, {'end': (True, 1759)}, {'}': (True, 1912)}, {'or': (False, 60), 'and': (False, 60), '%': (False, 60), '+': (False, 60), ',': (False, 60), 'else': (False, 60), '<': (False, 60), '>=': (False, 60), 'elseif': (False, 60), '^': (False, 60), 'end': (False, 60), '>': (False, 60), '*': (False, 60), ';': (False, 60), '==': (False, 60), '~=': (False, 60), '-': (False, 60), '<=': (False, 60), '/': (False, 60), '..': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1913)}, {'::': (False, 27), 'NAME': (False, 27), 'goto': (False, 27), 'if': (False, 27), 'repeat': (False, 27), 'return': (False, 27), 'elseif': (False, 27), 'else': (False, 27), 'for': (False, 27), 'function': (False, 27), 'while': (False, 27), '(': (False, 27), 'EMBEDSTAT': (False, 27), 'end': (False, 27), 'do': (False, 27), 'break': (False, 27), ';': (False, 27), 'local': (False, 27)}, {'(': (True, 1365), 'args': (True, 1914), 'tableconstructor': (True, 1368), 'STRING': (True, 1367), '{': (True, 1370)}, {'or': (False, 100), 'and': (False, 100), '>=': (False, 100), '+': (False, 100), 'elseif': (False, 100), 'else': (False, 100), '<': (False, 100), '%': (False, 100), ',': (False, 100), '^': (True, 1752), ';': (False, 100), '>': (False, 100), '*': (False, 100), 'end': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '<=': (False, 100), '/': (False, 100), '..': (False, 100)}, {')': (True, 1805)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1761), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'::': (True, 655), 'varlist': (True, 656), 'repeat': (True, 657), 'function': (True, 658), 'if': (True, 659), 'NAME': (True, 6), 'prefixexp': (True, 660), 'elseif': (False, 63), 'else': (False, 63), 'for': (True, 661), 'goto': (True, 662), 'label': (True, 663), 'while': (True, 664), 'return': (False, 63), 'EMBEDSTAT': (True, 665), 'var': (True, 13), '(': (True, 14), 'stat': (True, 666), 'block': (True, 1765), 'end': (False, 63), 'do': (True, 668), 'break': (True, 669), ';': (True, 670), 'block__1': (True, 671), 'local': (True, 672), 'functioncall': (True, 673)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1659), 'or': (True, 346)}, {'}': (True, 1872)}, {'*': (True, 499), ';': (False, 57), '^': (True, 495), 'and': (True, 494), ',': (False, 57), '%': (True, 496), '+': (True, 497), '}': (False, 57), '>': (True, 498), '<=': (True, 493), '>=': (True, 500), '<': (True, 501), '..': (True, 506), '-': (True, 503), '==': (True, 504), '/': (True, 505), '~=': (True, 502), 'or': (True, 507)}, {'if': (False, 25), 'NAME': (False, 25), 'goto': (False, 25), '::': (False, 25), 'return': (False, 25), 'for': (False, 25), 'function': (False, 25), 'local': (False, 25), '=': (False, 25), 'while': (False, 25), '(': (False, 25), 'EMBEDSTAT': (False, 25), ';': (False, 25), 'do': (False, 25), 'break': (False, 25), 'end': (False, 25), 'repeat': (False, 25)}, {'(': (True, 1109), 'args': (True, 1614), 'tableconstructor': (True, 1112), 'STRING': (True, 1111), '{': (True, 1114)}, {')': (True, 1873)}, {'::': (False, 26), 'return': (False, 26), 'function': (False, 26), 'if': (False, 26), 'repeat': (False, 26), 'NAME': (False, 26), ',': (True, 1420), 'else': (False, 26), 'namelist__1': (True, 1934), 'goto': (False, 26), '=': (False, 26), 'while': (False, 26), 'elseif': (False, 26), '(': (False, 26), 'EMBEDSTAT': (False, 26), 'end': (False, 26), 'do': (False, 26), 'break': (False, 26), ';': (False, 26), 'local': (False, 26), 'for': (False, 26)}, {'if': (False, 7), 'NAME': (False, 7), 'function': (False, 7), '::': (False, 7), 'return': (False, 7), 'elseif': (False, 7), 'else': (False, 7), 'for': (False, 7), 'goto': (False, 7), 'local': (False, 7), 'while': (False, 7), '(': (False, 7), 'EMBEDSTAT': (False, 7), ';': (False, 7), 'do': (False, 7), 'break': (False, 7), 'end': (False, 7), 'repeat': (False, 7)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), ']': (False, 4), '(': (False, 4), '^': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'end': (True, 1806)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '~=': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108), '.': (False, 108)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), ']': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1808), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), '<=': (False, 108), '~=': (False, 108), '<': (False, 108), ']': (False, 108), '(': (False, 108), '^': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108)}, {'*': (True, 265), '^': (True, 259), 'and': (True, 260), '%': (True, 261), 'do': (False, 9), '+': (True, 263), '>': (True, 264), '<=': (True, 258), '>=': (True, 266), '==': (True, 270), '..': (True, 268), '-': (True, 269), '<': (True, 267), '/': (True, 271), '~=': (True, 272), 'or': (True, 273)}, {',': (True, 1260), '*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), '%': (True, 1188), 'stat__3': (True, 1826), 'do': (False, 10), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '~=': (True, 1199), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), '..': (True, 1194), 'or': (True, 1196)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '~=': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108), '.': (False, 108)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), 'end': (False, 4), '<': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), ';': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'NAME': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), 'break': (False, 4), 'until': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'return': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'end': (True, 1888)}, {'::': (True, 655), 'varlist': (True, 656), 'repeat': (True, 657), 'function': (True, 658), 'if': (True, 659), 'NAME': (True, 6), 'prefixexp': (True, 660), 'elseif': (False, 63), 'else': (False, 63), 'for': (True, 661), 'goto': (True, 662), 'label': (True, 663), 'while': (True, 664), 'return': (False, 63), 'EMBEDSTAT': (True, 665), 'var': (True, 13), '(': (True, 14), 'stat': (True, 666), 'block': (True, 1701), 'end': (False, 63), 'do': (True, 668), 'break': (True, 669), ';': (True, 670), 'block__1': (True, 671), 'local': (True, 672), 'functioncall': (True, 673)}, {',': (True, 1260), '*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), '%': (True, 1188), 'stat__3': (True, 1778), 'do': (False, 10), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '~=': (True, 1199), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), '..': (True, 1194), 'or': (True, 1196)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'break': (False, 20), 'while': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), 'function': (False, 20), 'until': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1764), 'or': (True, 346)}, {'end': (True, 1736)}, {'}': (True, 1875)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1908), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {',': (True, 1758), '^': (True, 981), 'and': (True, 980), '%': (True, 983), '+': (True, 984), '>': (True, 985), '*': (True, 986), '>=': (True, 987), '<': (True, 988), '..': (True, 993), '-': (True, 990), '<=': (True, 979), '==': (True, 991), '/': (True, 992), '~=': (True, 989), 'or': (True, 994)}, {'if': (False, 101), 'while': (False, 101), 'NAME': (False, 101), 'or': (False, 101), 'and': (False, 101), '::': (False, 101), '>=': (False, 101), 'repeat': (False, 101), 'return': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'for': (False, 101), 'function': (False, 101), 'until': (False, 101), '(': (False, 101), 'EMBEDSTAT': (False, 101), '^': (True, 1654), 'goto': (False, 101), 'do': (False, 101), 'break': (False, 101), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '~=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '..': (False, 101), '%': (False, 101)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1919), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1918), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'NAME': (False, 13), 'for': (False, 13), 'local': (False, 13), 'EMBEDSTAT': (False, 13), 'break': (False, 13), 'while': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'repeat': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'until': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '~=': (False, 13), 'function': (False, 13), '..': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'break': (False, 12), 'while': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), '<=': (False, 12), '<': (False, 12), 'goto': (False, 12), 'until': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 1920)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1921), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '>=': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'goto': (False, 107), 'break': (False, 107), 'until': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 1923)}, {'do': (True, 1845)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '~=': (False, 108), '<': (False, 108), '<=': (False, 108), '(': (False, 108), ';': (False, 108), '^': (False, 108), 'end': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1663), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'if': (False, 60), 'while': (False, 60), 'return': (False, 60), 'or': (False, 60), 'and': (False, 60), '::': (False, 60), '%': (False, 60), 'NAME': (False, 60), '+': (False, 60), '<=': (False, 60), '-': (False, 60), '<': (False, 60), 'for': (False, 60), 'goto': (False, 60), 'until': (False, 60), '(': (False, 60), 'EMBEDSTAT': (False, 60), '^': (False, 60), ';': (False, 60), 'local': (False, 60), 'break': (False, 60), '>': (False, 60), '*': (False, 60), '>=': (False, 60), '==': (False, 60), '..': (False, 60), 'do': (False, 60), 'function': (False, 60), '/': (False, 60), 'repeat': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1666)}, {'if': (False, 102), 'NAME': (False, 102), 'or': (False, 102), 'and': (False, 102), '::': (False, 102), '>=': (False, 102), 'repeat': (False, 102), 'return': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'for': (False, 102), 'function': (False, 102), '>': (False, 102), 'until': (False, 102), '(': (False, 102), 'EMBEDSTAT': (False, 102), '^': (True, 1654), ';': (False, 102), 'goto': (False, 102), 'do': (False, 102), 'break': (False, 102), 'while': (False, 102), '*': (False, 102), '%': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), '/': (False, 102), 'local': (False, 102), '~=': (False, 102)}, {'if': (False, 100), 'return': (False, 100), 'goto': (False, 100), 'and': (False, 100), '::': (False, 100), '>=': (False, 100), 'NAME': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'for': (False, 100), 'function': (False, 100), 'local': (False, 100), '>': (False, 100), 'until': (False, 100), 'or': (False, 100), '(': (False, 100), 'EMBEDSTAT': (False, 100), '^': (True, 1654), 'do': (False, 100), 'break': (False, 100), 'while': (False, 100), '*': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '-': (False, 100), '/': (False, 100), 'repeat': (False, 100), '..': (False, 100), '%': (False, 100)}, {'if': (False, 4), 'goto': (False, 4), '>=': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), 'break': (False, 4), '*': (False, 4), '%': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), 'EOF': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1892), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1891), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1893), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1894), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1895), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1896), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1897), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1898), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1899), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1900), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1901), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1902), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1903), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1904), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'var': (True, 1504), '(': (True, 1505), 'NAME': (True, 1506), 'tableconstructor': (True, 1507), 'function': (True, 1517), 'NUMBER': (True, 1511), 'EMBEDEXPR': (True, 1510), 'functiondef': (True, 1509), '#': (True, 1512), 'prefixexp': (True, 1513), '...': (True, 1514), 'true': (True, 1515), 'STRING': (True, 1516), '{': (True, 1508), '-': (True, 1518), 'not': (True, 1519), 'exp': (True, 1905), 'nil': (True, 1521), 'false': (True, 1522), 'functioncall': (True, 1523)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), '<=': (False, 99), '^': (True, 1153), 'do': (False, 99), '>': (False, 99), '*': (False, 99), '%': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'[': (False, 20), 'or': (False, 20), 'and': (False, 20), '>=': (False, 20), '+': (False, 20), ',': (False, 20), 'else': (False, 20), '<': (False, 20), '%': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), 'end': (False, 20), '..': (False, 20), ':': (False, 20), '>': (False, 20), '*': (False, 20), ';': (False, 20), 'STRING': (False, 20), '==': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), 'elseif': (False, 20), '/': (False, 20), '~=': (False, 20)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1944), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'if': (False, 4), '[': (False, 4), 'return': (False, 4), 'function': (False, 4), '::': (False, 4), 'repeat': (False, 4), 'NAME': (False, 4), 'for': (False, 4), 'goto': (False, 4), 'while': (False, 4), 'EOF': (False, 4), '(': (False, 4), 'EMBEDSTAT': (False, 4), 'do': (False, 4), 'break': (False, 4), ':': (False, 4), ';': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), 'local': (False, 4)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 1724), 'or': (True, 346)}, {'end': (True, 1887)}, {'if': (False, 60), 'goto': (False, 60), '>=': (False, 60), 'repeat': (False, 60), 'return': (False, 60), 'elseif': (False, 60), 'else': (False, 60), 'for': (False, 60), 'or': (False, 60), 'EMBEDSTAT': (False, 60), ';': (False, 60), 'break': (False, 60), '*': (False, 60), '%': (False, 60), '-': (False, 60), '/': (False, 60), 'local': (False, 60), '::': (False, 60), 'NAME': (False, 60), 'and': (False, 60), '+': (False, 60), '<=': (False, 60), '<': (False, 60), 'function': (False, 60), 'while': (False, 60), ',': (False, 60), '(': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), 'end': (False, 60), '==': (False, 60), '..': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 1951)}, {')': (True, 1952)}, {'if': (False, 28), 'return': (False, 28), 'function': (False, 28), '::': (False, 28), 'repeat': (False, 28), 'NAME': (False, 28), 'for': (False, 28), 'goto': (False, 28), 'while': (False, 28), '(': (False, 28), 'EMBEDSTAT': (False, 28), 'do': (False, 28), 'break': (False, 28), 'until': (False, 28), ';': (False, 28), 'local': (False, 28)}, {'if': (False, 101), 'goto': (False, 101), '%': (False, 101), 'repeat': (False, 101), 'NAME': (False, 101), 'elseif': (False, 101), 'else': (False, 101), 'for': (False, 101), 'or': (False, 101), 'EMBEDSTAT': (False, 101), ';': (False, 101), 'break': (False, 101), '*': (False, 101), '>=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '::': (False, 101), 'return': (False, 101), 'and': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'function': (False, 101), 'while': (False, 101), ',': (False, 101), '(': (False, 101), '^': (True, 1683), 'do': (False, 101), '>': (False, 101), 'end': (False, 101), '==': (False, 101), '~=': (False, 101), '..': (False, 101)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ',': (False, 38), '(': (False, 38), '^': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '..': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '~=': (False, 38), '.': (False, 38)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 1770), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 1774), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'NAME': (False, 13), 'elseif': (False, 13), 'else': (False, 13), 'for': (False, 13), 'local': (False, 13), 'EMBEDSTAT': (False, 13), 'end': (False, 13), 'break': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'repeat': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'while': (False, 13), ',': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '~=': (False, 13), 'function': (False, 13), '..': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'elseif': (False, 12), 'else': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), ';': (False, 12), 'break': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), ',': (False, 12), '<': (False, 12), 'goto': (False, 12), 'while': (False, 12), '<=': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), 'end': (False, 12), '==': (False, 12), '~=': (False, 12), 'function': (False, 12), '..': (False, 12)}, {'NAME': (True, 1877)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1879), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '%': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'elseif': (False, 107), 'else': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'end': (False, 107), 'goto': (False, 107), 'break': (False, 107), '*': (False, 107), '>=': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), ',': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 1881)}, {'}': (True, 1907)}, {'if': (False, 102), 'goto': (False, 102), '>=': (False, 102), 'NAME': (False, 102), 'elseif': (False, 102), 'else': (False, 102), 'for': (False, 102), 'local': (False, 102), 'or': (False, 102), 'EMBEDSTAT': (False, 102), 'end': (False, 102), 'break': (False, 102), '*': (False, 102), '%': (False, 102), '-': (False, 102), '/': (False, 102), 'repeat': (False, 102), '::': (False, 102), 'return': (False, 102), 'and': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'function': (False, 102), 'while': (False, 102), ',': (False, 102), '(': (False, 102), '^': (True, 1683), 'do': (False, 102), '>': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '~=': (False, 102)}, {'if': (False, 100), 'goto': (False, 100), '>=': (False, 100), 'repeat': (False, 100), 'return': (False, 100), 'elseif': (False, 100), 'else': (False, 100), 'for': (False, 100), 'or': (False, 100), 'EMBEDSTAT': (False, 100), 'end': (False, 100), 'break': (False, 100), '*': (False, 100), '%': (False, 100), '-': (False, 100), '/': (False, 100), 'local': (False, 100), '::': (False, 100), 'NAME': (False, 100), 'and': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'function': (False, 100), 'while': (False, 100), ',': (False, 100), '(': (False, 100), '^': (True, 1683), 'do': (False, 100), '>': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '..': (False, 100)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1777), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1779), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1780), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'NAME': (True, 1325), 'tableconstructor': (True, 1321), 'function': (True, 1322), 'NUMBER': (True, 1336), 'EMBEDEXPR': (True, 1324), 'functiondef': (True, 1323), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), '{': (True, 1332), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1781), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1782), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1783), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1784), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1785), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1786), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1787), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1788), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1789), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1790), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'::': (False, 71), 'NAME': (False, 71), 'function': (False, 71), 'if': (False, 71), 'repeat': (False, 71), 'return': (False, 71), 'elseif': (False, 71), 'else': (False, 71), 'for': (False, 71), 'goto': (False, 71), 'while': (False, 71), '(': (False, 71), 'EMBEDSTAT': (False, 71), ';': (False, 71), 'do': (False, 71), 'break': (False, 71), 'end': (False, 71), 'local': (False, 71)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1791), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1792), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'var': (True, 1319), '(': (True, 1320), 'tableconstructor': (True, 1321), '{': (True, 1332), 'functiondef': (True, 1323), 'EMBEDEXPR': (True, 1324), 'NAME': (True, 1325), '#': (True, 1326), 'prefixexp': (True, 1327), '...': (True, 1328), 'true': (True, 1329), 'STRING': (True, 1330), 'function': (True, 1322), '-': (True, 1333), 'not': (True, 1334), 'exp': (True, 1793), 'NUMBER': (True, 1336), 'nil': (True, 1337), 'false': (True, 1338), 'functioncall': (True, 1339)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1794), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {')': (True, 1796)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), 'until': (False, 38), ',': (False, 38), '(': (False, 38), '^': (False, 38), ';': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '~=': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '..': (False, 38), '.': (False, 38)}, {'elseif': (True, 1241), 'end': (False, 15), 'else': (False, 15), 'stat__1': (True, 1772)}, {'::': (False, 51), 'NAME': (False, 51), 'function': (False, 51), 'if': (False, 51), 'repeat': (False, 51), 'return': (False, 51), 'for': (False, 51), 'goto': (False, 51), 'while': (False, 51), '(': (False, 51), 'EMBEDSTAT': (False, 51), 'do': (False, 51), 'break': (False, 51), 'until': (False, 51), ';': (False, 51), 'local': (False, 51)}, {'*': (True, 1191), 'or': (False, 86), '^': (True, 1153), ',': (False, 86), '%': (True, 1188), 'do': (False, 86), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '..': (True, 1194), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), 'and': (False, 86), '~=': (True, 1199)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 1188), '+': (True, 1189), ',': (False, 89), '<': (False, 89), '<=': (False, 89), '^': (True, 1153), 'do': (False, 89), '>': (False, 89), '*': (True, 1191), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {',': (True, 1187), '*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), '%': (True, 1188), '..': (True, 1194), 'do': (False, 29), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), 'explist__1': (True, 1938), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), '~=': (True, 1199), 'or': (True, 1196)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), '<=': (False, 98), '^': (True, 1153), 'do': (False, 98), '>': (False, 98), '*': (False, 98), '%': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 1188), '+': (False, 94), ',': (False, 94), '<': (False, 94), '<=': (False, 94), '^': (True, 1153), 'do': (False, 94), '>': (False, 94), '*': (True, 1191), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 1198), '~=': (False, 94)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), ',': (False, 96), '^': (True, 1153), 'do': (False, 96), '>': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), '..': (False, 96)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 1188), '+': (True, 1189), ',': (False, 90), '<': (False, 90), '<=': (False, 90), '^': (True, 1153), 'do': (False, 90), '>': (False, 90), '*': (True, 1191), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 1188), '+': (True, 1189), '<=': (False, 87), '<': (False, 87), ',': (False, 87), '^': (True, 1153), 'do': (False, 87), '>': (False, 87), '*': (True, 1191), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1945), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 1188), '+': (True, 1189), ',': (False, 93), '<': (False, 93), '<=': (False, 93), '^': (True, 1153), 'do': (False, 93), '>': (False, 93), '*': (True, 1191), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {'if': (False, 11), '[': (False, 11), 'NAME': (False, 11), 'goto': (False, 11), '::': (False, 11), 'repeat': (False, 11), 'return': (False, 11), 'for': (False, 11), 'function': (False, 11), 'while': (False, 11), 'EOF': (False, 11), '(': (False, 11), 'EMBEDSTAT': (False, 11), 'do': (False, 11), 'break': (False, 11), ':': (False, 11), ';': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), 'local': (False, 11)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 1188), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ',': (False, 95), '^': (True, 1153), 'do': (False, 95), '>': (False, 95), '*': (True, 1191), '>=': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 1198), '~=': (False, 95)}, {')': (True, 1868)}, {'::': (False, 61), 'return': (False, 61), 'goto': (False, 61), 'and': (False, 61), 'if': (False, 61), '%': (False, 61), 'repeat': (False, 61), 'NAME': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), 'for': (False, 61), 'function': (False, 61), 'while': (False, 61), 'or': (False, 61), '(': (False, 61), 'EOF': (False, 61), '^': (False, 61), ';': (False, 61), 'do': (False, 61), 'break': (False, 61), 'EMBEDSTAT': (False, 61), '>': (False, 61), '*': (False, 61), '>=': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), 'local': (False, 61), '..': (False, 61)}, {'*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), ',': (False, 85), '%': (True, 1188), 'do': (False, 85), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '~=': (True, 1199), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), '..': (True, 1194), 'or': (False, 85)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 1188), '+': (True, 1189), ',': (False, 92), '<': (False, 92), '<=': (False, 92), '^': (True, 1153), 'do': (False, 92), '>': (False, 92), '*': (True, 1191), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), ',': (False, 97), '^': (True, 1153), 'do': (False, 97), '>': (False, 97), '*': (False, 97), '>=': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 1188), '+': (True, 1189), '<=': (False, 91), '<': (False, 91), ',': (False, 91), '^': (True, 1153), 'do': (False, 91), '>': (False, 91), '*': (True, 1191), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 1188), '+': (True, 1189), ',': (False, 88), '<': (False, 88), '<=': (False, 88), '^': (True, 1153), 'do': (False, 88), '>': (False, 88), '*': (True, 1191), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 1195), '/': (True, 1198), '..': (True, 1194)}, {'::': (False, 89), 'return': (False, 89), 'or': (False, 89), 'and': (False, 89), 'if': (False, 89), '%': (True, 1308), 'repeat': (False, 89), 'NAME': (False, 89), '+': (True, 1305), '<=': (False, 89), 'end': (False, 89), '<': (False, 89), 'for': (False, 89), 'goto': (False, 89), 'while': (False, 89), '(': (False, 89), 'EMBEDSTAT': (False, 89), '^': (True, 1312), ';': (False, 89), 'do': (False, 89), 'break': (False, 89), '>': (False, 89), '*': (True, 1307), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 1311), 'function': (False, 89), '/': (True, 1314), 'local': (False, 89), '..': (True, 1315)}, {'if': (False, 85), 'return': (False, 85), 'function': (False, 85), 'and': (True, 1303), '::': (False, 85), '%': (True, 1308), 'repeat': (False, 85), 'NAME': (False, 85), '+': (True, 1305), '<=': (True, 1301), 'end': (False, 85), '<': (True, 1313), 'for': (False, 85), 'goto': (False, 85), 'while': (False, 85), 'or': (False, 85), '(': (False, 85), 'EMBEDSTAT': (False, 85), '^': (True, 1312), ';': (False, 85), 'do': (False, 85), 'break': (False, 85), '>': (True, 1306), '*': (True, 1307), '>=': (True, 1304), '==': (True, 1309), '~=': (True, 1310), '-': (True, 1311), '/': (True, 1314), 'local': (False, 85), '..': (True, 1315)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'elseif': (False, 20), 'else': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'end': (False, 20), 'break': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), ',': (False, 20), '<': (False, 20), 'function': (False, 20), 'while': (False, 20), '<=': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'::': (False, 86), 'NAME': (False, 86), 'or': (False, 86), 'and': (False, 86), 'if': (False, 86), '%': (True, 1308), 'repeat': (False, 86), 'return': (False, 86), '+': (True, 1305), '<=': (True, 1301), 'end': (False, 86), '<': (True, 1313), 'for': (False, 86), 'goto': (False, 86), 'while': (False, 86), '(': (False, 86), 'EMBEDSTAT': (False, 86), '^': (True, 1312), ';': (False, 86), 'do': (False, 86), 'break': (False, 86), '>': (True, 1306), '*': (True, 1307), '>=': (True, 1304), '==': (True, 1309), '~=': (True, 1310), '-': (True, 1311), 'function': (False, 86), '/': (True, 1314), 'local': (False, 86), '..': (True, 1315)}, {')': (True, 1769)}, {'::': (False, 90), 'NAME': (False, 90), 'or': (False, 90), 'and': (False, 90), 'if': (False, 90), '%': (True, 1308), 'repeat': (False, 90), 'return': (False, 90), '+': (True, 1305), '<=': (False, 90), 'end': (False, 90), '<': (False, 90), 'for': (False, 90), 'goto': (False, 90), 'while': (False, 90), '(': (False, 90), 'EMBEDSTAT': (False, 90), '^': (True, 1312), ';': (False, 90), 'do': (False, 90), 'break': (False, 90), '>': (False, 90), '*': (True, 1307), '>=': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 1311), 'function': (False, 90), '/': (True, 1314), 'local': (False, 90), '..': (True, 1315)}, {'if': (False, 94), 'return': (False, 94), 'or': (False, 94), 'and': (False, 94), '::': (False, 94), '%': (True, 1308), 'repeat': (False, 94), 'NAME': (False, 94), '+': (False, 94), '<=': (False, 94), '<': (False, 94), 'for': (False, 94), 'goto': (False, 94), 'while': (False, 94), '(': (False, 94), ';': (False, 94), 'EMBEDSTAT': (False, 94), '^': (True, 1312), 'end': (False, 94), 'do': (False, 94), 'break': (False, 94), '>': (False, 94), '*': (True, 1307), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), 'function': (False, 94), '/': (True, 1314), 'local': (False, 94), '~=': (False, 94)}, {'if': (False, 88), 'return': (False, 88), 'or': (False, 88), 'and': (False, 88), '::': (False, 88), '%': (True, 1308), 'repeat': (False, 88), 'NAME': (False, 88), '+': (True, 1305), '<=': (False, 88), 'end': (False, 88), '<': (False, 88), 'for': (False, 88), 'goto': (False, 88), 'while': (False, 88), '(': (False, 88), 'EMBEDSTAT': (False, 88), '^': (True, 1312), ';': (False, 88), 'do': (False, 88), 'break': (False, 88), '>': (False, 88), '*': (True, 1307), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 1311), 'function': (False, 88), '/': (True, 1314), 'local': (False, 88), '..': (True, 1315)}, {'::': (False, 96), 'return': (False, 96), 'goto': (False, 96), 'and': (False, 96), 'if': (False, 96), '>=': (False, 96), 'NAME': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), 'for': (False, 96), 'function': (False, 96), 'local': (False, 96), 'while': (False, 96), 'or': (False, 96), '(': (False, 96), 'EMBEDSTAT': (False, 96), '^': (True, 1312), 'end': (False, 96), 'do': (False, 96), 'break': (False, 96), '>': (False, 96), '*': (False, 96), ';': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '..': (False, 96), '%': (False, 96)}, {'if': (False, 98), 'NAME': (False, 98), 'or': (False, 98), 'and': (False, 98), '::': (False, 98), '>=': (False, 98), 'return': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), 'for': (False, 98), 'function': (False, 98), 'local': (False, 98), 'while': (False, 98), '(': (False, 98), 'EMBEDSTAT': (False, 98), '^': (True, 1312), ';': (False, 98), 'goto': (False, 98), 'do': (False, 98), 'break': (False, 98), '>': (False, 98), '*': (False, 98), 'end': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '..': (False, 98), '%': (False, 98)}, {'::': (False, 92), 'NAME': (False, 92), 'or': (False, 92), 'and': (False, 92), 'if': (False, 92), '%': (True, 1308), 'repeat': (False, 92), 'return': (False, 92), '+': (True, 1305), '<=': (False, 92), '<': (False, 92), 'for': (False, 92), 'goto': (False, 92), 'while': (False, 92), '(': (False, 92), ';': (False, 92), 'EMBEDSTAT': (False, 92), '^': (True, 1312), 'end': (False, 92), 'do': (False, 92), 'break': (False, 92), '>': (False, 92), '*': (True, 1307), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 1311), 'function': (False, 92), '/': (True, 1314), 'local': (False, 92), '..': (True, 1315)}, {'if': (False, 91), 'return': (False, 91), 'goto': (False, 91), 'and': (False, 91), '::': (False, 91), '%': (True, 1308), 'NAME': (False, 91), '+': (True, 1305), '<=': (False, 91), '<': (False, 91), 'for': (False, 91), 'function': (False, 91), 'local': (False, 91), 'while': (False, 91), 'or': (False, 91), '(': (False, 91), ';': (False, 91), 'EMBEDSTAT': (False, 91), '^': (True, 1312), 'end': (False, 91), 'do': (False, 91), 'break': (False, 91), '>': (False, 91), '*': (True, 1307), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 1311), '/': (True, 1314), 'repeat': (False, 91), '..': (True, 1315)}, {'::': (False, 95), 'NAME': (False, 95), 'or': (False, 95), 'and': (False, 95), 'if': (False, 95), '%': (True, 1308), 'repeat': (False, 95), 'return': (False, 95), '+': (False, 95), '<=': (False, 95), '<': (False, 95), 'for': (False, 95), 'function': (False, 95), 'while': (False, 95), '(': (False, 95), ';': (False, 95), 'EMBEDSTAT': (False, 95), '^': (True, 1312), 'end': (False, 95), 'goto': (False, 95), 'do': (False, 95), 'break': (False, 95), '>': (False, 95), '*': (True, 1307), '>=': (False, 95), '==': (False, 95), '~=': (False, 95), '-': (False, 95), '/': (True, 1314), 'local': (False, 95), '..': (False, 95)}, {'or': (False, 101), 'and': (False, 101), '%': (False, 101), '+': (False, 101), '<=': (False, 101), 'else': (False, 101), '<': (False, 101), '>=': (False, 101), ',': (False, 101), '^': (True, 1752), 'end': (False, 101), '>': (False, 101), '*': (False, 101), ';': (False, 101), '==': (False, 101), '..': (False, 101), '-': (False, 101), 'elseif': (False, 101), '/': (False, 101), '~=': (False, 101)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), '<=': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'if': (False, 108), '[': (False, 108), 'NAME': (False, 108), 'function': (False, 108), '::': (False, 108), 'return': (False, 108), 'for': (False, 108), 'goto': (False, 108), 'local': (False, 108), 'while': (False, 108), 'EMBEDSTAT': (False, 108), '(': (False, 108), 'EOF': (False, 108), 'do': (False, 108), 'break': (False, 108), ':': (False, 108), ';': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), 'repeat': (False, 108)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1931), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'}': (True, 1807)}, {'or': (False, 102), 'and': (False, 102), '>=': (False, 102), '+': (False, 102), ',': (False, 102), 'else': (False, 102), '<': (False, 102), '%': (False, 102), '<=': (False, 102), '^': (True, 1752), 'end': (False, 102), '>': (False, 102), '*': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '-': (False, 102), 'elseif': (False, 102), '/': (False, 102), '~=': (False, 102)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1958), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1959), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1960), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1961), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1962), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1963), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1965), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1966), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1967), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1968), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1969), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1970), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1971), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'elseif': (False, 71), 'end': (False, 71), 'else': (False, 71), ';': (False, 71)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1972), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1973), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 1405), '(': (True, 1406), 'tableconstructor': (True, 1397), 'function': (True, 1402), 'NUMBER': (True, 1409), 'EMBEDEXPR': (True, 1408), 'NAME': (True, 1398), '#': (True, 1410), 'prefixexp': (True, 1400), '...': (True, 1411), 'true': (True, 1401), 'STRING': (True, 1412), '{': (True, 1414), '-': (True, 1415), 'not': (True, 1403), 'exp': (True, 1975), 'functioncall': (True, 1418), 'nil': (True, 1417), 'false': (True, 1404), 'functiondef': (True, 1407)}, {'var': (True, 555), '(': (True, 556), 'tableconstructor': (True, 557), 'function': (True, 572), 'NUMBER': (True, 559), 'EMBEDEXPR': (True, 560), 'NAME': (True, 561), '#': (True, 562), 'prefixexp': (True, 563), '...': (True, 564), 'true': (True, 565), 'STRING': (True, 566), '{': (True, 568), '-': (True, 569), 'not': (True, 570), 'exp': (True, 1823), 'functioncall': (True, 575), 'nil': (True, 573), 'false': (True, 574), 'functiondef': (True, 558)}, {'if': (False, 51), 'NAME': (False, 51), 'function': (False, 51), '::': (False, 51), 'repeat': (False, 51), 'return': (False, 51), 'for': (False, 51), 'goto': (False, 51), 'while': (False, 51), '(': (False, 51), 'EMBEDSTAT': (False, 51), 'end': (False, 51), 'do': (False, 51), 'break': (False, 51), ';': (False, 51), 'local': (False, 51)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ',': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '..': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '~=': (False, 38), '.': (False, 38)}, {'if': (False, 108), '[': (False, 108), 'NAME': (False, 108), 'goto': (False, 108), '::': (False, 108), 'repeat': (False, 108), 'return': (False, 108), 'elseif': (False, 108), 'else': (False, 108), 'for': (False, 108), 'function': (False, 108), 'while': (False, 108), '(': (False, 108), 'EMBEDSTAT': (False, 108), 'end': (False, 108), 'do': (False, 108), 'break': (False, 108), ':': (False, 108), ';': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), 'local': (False, 108)}, {'end': (True, 1915)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'break': (False, 20), 'while': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), '<=': (False, 20), '<': (False, 20), 'function': (False, 20), 'until': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'elseif': (True, 1241), 'end': (False, 15), 'else': (False, 15), 'stat__1': (True, 1844)}, {';': (False, 28), 'until': (False, 28)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'NAME': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), 'break': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'return': (False, 11), 'and': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '<=': (False, 11), '(': (False, 11), 'EOF': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), ';': (False, 11), '==': (False, 11), '~=': (False, 11), '..': (False, 11)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1909), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {')': (True, 1890)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 1487), '+': (True, 1488), ',': (False, 89), '<': (False, 89), '>=': (False, 89), '<=': (False, 89), 'EOF': (False, 89), '^': (True, 1485), '>': (False, 89), '*': (True, 1490), ';': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {'end': (False, 14), 'else': (False, 14)}, {'*': (True, 1490), ';': (False, 86), 'EOF': (False, 86), '^': (True, 1485), ',': (False, 86), '%': (True, 1487), '+': (True, 1488), '>': (True, 1489), '<=': (True, 1483), '>=': (True, 1491), '<': (True, 1492), '..': (True, 1493), '-': (True, 1494), '==': (True, 1495), '/': (True, 1497), 'and': (False, 86), '~=': (True, 1498), 'or': (False, 86)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1929), '~=': (True, 414), 'or': (True, 419)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), '<': (False, 99), '%': (False, 99), '<=': (False, 99), 'EOF': (False, 99), '^': (True, 1485), '>': (False, 99), '*': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), '/': (False, 99), '~=': (False, 99)}, {',': (True, 1486), '*': (True, 1490), '^': (True, 1485), 'and': (True, 1484), ';': (False, 29), '%': (True, 1487), '+': (True, 1488), '>': (True, 1489), '<=': (True, 1483), '>=': (True, 1491), '~=': (True, 1498), 'EOF': (False, 29), '<': (True, 1492), 'explist__1': (True, 1871), '-': (True, 1494), '==': (True, 1495), '/': (True, 1497), '..': (True, 1493), 'or': (True, 1499)}, {'if': (False, 89), 'goto': (False, 89), '%': (True, 1685), 'repeat': (False, 89), 'NAME': (False, 89), 'elseif': (False, 89), 'else': (False, 89), 'for': (False, 89), 'or': (False, 89), 'EMBEDSTAT': (False, 89), ';': (False, 89), 'break': (False, 89), '*': (True, 1689), '>=': (False, 89), '-': (True, 1693), '/': (True, 1695), 'local': (False, 89), '::': (False, 89), 'return': (False, 89), 'and': (False, 89), '+': (True, 1686), ',': (False, 89), '<': (False, 89), 'function': (False, 89), 'while': (False, 89), '<=': (False, 89), '(': (False, 89), '^': (True, 1683), 'do': (False, 89), '>': (False, 89), 'end': (False, 89), '==': (False, 89), '~=': (False, 89), '..': (True, 1697)}, {'do': (True, 1974)}, {'if': (False, 85), 'goto': (False, 85), '%': (True, 1685), 'return': (False, 85), 'elseif': (False, 85), 'else': (False, 85), 'for': (False, 85), 'local': (False, 85), 'or': (False, 85), 'EMBEDSTAT': (False, 85), 'end': (False, 85), 'break': (False, 85), '*': (True, 1689), '>=': (True, 1690), '-': (True, 1693), '/': (True, 1695), 'repeat': (False, 85), '::': (False, 85), 'NAME': (False, 85), 'and': (True, 1696), '+': (True, 1686), '<=': (True, 1681), '<': (True, 1691), 'function': (False, 85), 'while': (False, 85), ',': (False, 85), '(': (False, 85), '^': (True, 1683), 'do': (False, 85), '>': (True, 1688), ';': (False, 85), '==': (True, 1687), '~=': (True, 1692), '..': (True, 1697)}, {'if': (False, 99), 'or': (False, 99), '>=': (False, 99), 'repeat': (False, 99), 'NAME': (False, 99), 'elseif': (False, 99), 'else': (False, 99), 'for': (False, 99), 'EMBEDSTAT': (False, 99), ';': (False, 99), 'break': (False, 99), '*': (False, 99), '%': (False, 99), '-': (False, 99), '/': (False, 99), 'local': (False, 99), '::': (False, 99), 'return': (False, 99), 'and': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), 'goto': (False, 99), 'while': (False, 99), ',': (False, 99), '(': (False, 99), '^': (True, 1683), 'do': (False, 99), '>': (False, 99), 'end': (False, 99), '==': (False, 99), '..': (False, 99), 'function': (False, 99), '~=': (False, 99)}, {'if': (False, 29), 'or': (True, 1682), '%': (True, 1685), 'repeat': (False, 29), 'return': (False, 29), 'elseif': (False, 29), 'else': (False, 29), 'for': (False, 29), 'EMBEDSTAT': (False, 29), 'end': (False, 29), 'break': (False, 29), '*': (True, 1689), '>=': (True, 1690), '-': (True, 1693), '/': (True, 1695), 'local': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 1696), '+': (True, 1686), ',': (True, 1684), '<': (True, 1691), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 1681), '(': (False, 29), '^': (True, 1683), 'do': (False, 29), '>': (True, 1688), ';': (False, 29), '==': (True, 1687), '~=': (True, 1692), 'explist__1': (True, 1916), 'function': (False, 29), '..': (True, 1697)}, {'if': (False, 98), 'goto': (False, 98), '>=': (False, 98), 'return': (False, 98), 'elseif': (False, 98), 'else': (False, 98), 'for': (False, 98), 'local': (False, 98), 'or': (False, 98), 'EMBEDSTAT': (False, 98), ';': (False, 98), 'break': (False, 98), '*': (False, 98), '%': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '::': (False, 98), 'NAME': (False, 98), 'and': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), 'function': (False, 98), 'while': (False, 98), '<=': (False, 98), '(': (False, 98), '^': (True, 1683), 'do': (False, 98), '>': (False, 98), 'end': (False, 98), '==': (False, 98), '~=': (False, 98), '..': (False, 98)}, {'if': (False, 94), 'or': (False, 94), '%': (True, 1685), 'repeat': (False, 94), 'return': (False, 94), 'elseif': (False, 94), 'else': (False, 94), 'for': (False, 94), 'EMBEDSTAT': (False, 94), 'end': (False, 94), 'break': (False, 94), '*': (True, 1689), '>=': (False, 94), '-': (False, 94), '/': (True, 1695), 'local': (False, 94), '::': (False, 94), 'NAME': (False, 94), 'and': (False, 94), '+': (False, 94), ',': (False, 94), '<': (False, 94), 'goto': (False, 94), 'while': (False, 94), '<=': (False, 94), '(': (False, 94), '^': (True, 1683), 'do': (False, 94), '>': (False, 94), ';': (False, 94), '==': (False, 94), '~=': (False, 94), 'function': (False, 94), '..': (False, 94)}, {'if': (False, 92), 'or': (False, 92), '%': (True, 1685), 'repeat': (False, 92), 'return': (False, 92), 'elseif': (False, 92), 'else': (False, 92), 'for': (False, 92), 'EMBEDSTAT': (False, 92), 'end': (False, 92), 'break': (False, 92), '*': (True, 1689), '>=': (False, 92), '-': (True, 1693), '/': (True, 1695), 'local': (False, 92), '::': (False, 92), 'NAME': (False, 92), 'and': (False, 92), '+': (True, 1686), ',': (False, 92), '<': (False, 92), 'goto': (False, 92), 'while': (False, 92), '<=': (False, 92), '(': (False, 92), '^': (True, 1683), 'do': (False, 92), '>': (False, 92), ';': (False, 92), '==': (False, 92), '~=': (False, 92), 'function': (False, 92), '..': (True, 1697)}, {'if': (False, 88), 'or': (False, 88), '%': (True, 1685), 'repeat': (False, 88), 'return': (False, 88), 'elseif': (False, 88), 'else': (False, 88), 'for': (False, 88), 'EMBEDSTAT': (False, 88), 'end': (False, 88), 'goto': (False, 88), 'break': (False, 88), '*': (True, 1689), '>=': (False, 88), '-': (True, 1693), '/': (True, 1695), 'local': (False, 88), '::': (False, 88), 'NAME': (False, 88), 'and': (False, 88), '+': (True, 1686), '<=': (False, 88), '<': (False, 88), 'function': (False, 88), 'while': (False, 88), ',': (False, 88), '(': (False, 88), '^': (True, 1683), 'do': (False, 88), '>': (False, 88), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '..': (True, 1697)}, {'if': (False, 96), 'goto': (False, 96), '>=': (False, 96), 'return': (False, 96), 'elseif': (False, 96), 'else': (False, 96), 'for': (False, 96), 'local': (False, 96), 'or': (False, 96), 'EMBEDSTAT': (False, 96), ';': (False, 96), 'break': (False, 96), '*': (False, 96), '%': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '::': (False, 96), 'NAME': (False, 96), 'and': (False, 96), '+': (False, 96), ',': (False, 96), '<': (False, 96), 'function': (False, 96), 'while': (False, 96), '<=': (False, 96), '(': (False, 96), '^': (True, 1683), 'do': (False, 96), '>': (False, 96), 'end': (False, 96), '==': (False, 96), '..': (False, 96), '~=': (False, 96)}, {'if': (False, 90), 'or': (False, 90), '%': (True, 1685), 'return': (False, 90), 'elseif': (False, 90), 'else': (False, 90), 'for': (False, 90), 'local': (False, 90), 'EMBEDSTAT': (False, 90), ';': (False, 90), 'break': (False, 90), '*': (True, 1689), '>=': (False, 90), '-': (True, 1693), '/': (True, 1695), 'repeat': (False, 90), '::': (False, 90), 'NAME': (False, 90), 'and': (False, 90), '+': (True, 1686), ',': (False, 90), '<': (False, 90), 'goto': (False, 90), 'while': (False, 90), '<=': (False, 90), '(': (False, 90), '^': (True, 1683), 'do': (False, 90), '>': (False, 90), 'end': (False, 90), '==': (False, 90), '~=': (False, 90), 'function': (False, 90), '..': (True, 1697)}, {'if': (False, 87), 'goto': (False, 87), '%': (True, 1685), 'repeat': (False, 87), 'NAME': (False, 87), 'elseif': (False, 87), 'else': (False, 87), 'for': (False, 87), 'or': (False, 87), 'EMBEDSTAT': (False, 87), 'end': (False, 87), 'break': (False, 87), '*': (True, 1689), '>=': (False, 87), '-': (True, 1693), '/': (True, 1695), 'local': (False, 87), '::': (False, 87), 'return': (False, 87), 'and': (False, 87), '+': (True, 1686), ',': (False, 87), '<': (False, 87), 'function': (False, 87), 'while': (False, 87), '<=': (False, 87), '(': (False, 87), '^': (True, 1683), 'do': (False, 87), '>': (False, 87), ';': (False, 87), '==': (False, 87), '~=': (False, 87), '..': (True, 1697)}, {'if': (False, 91), 'function': (False, 91), '%': (True, 1685), 'return': (False, 91), 'elseif': (False, 91), 'else': (False, 91), 'for': (False, 91), 'local': (False, 91), 'or': (False, 91), 'EMBEDSTAT': (False, 91), ';': (False, 91), 'break': (False, 91), '*': (True, 1689), '>=': (False, 91), '-': (True, 1693), '/': (True, 1695), 'repeat': (False, 91), '::': (False, 91), 'NAME': (False, 91), 'and': (False, 91), '+': (True, 1686), ',': (False, 91), '<': (False, 91), 'goto': (False, 91), 'while': (False, 91), '<=': (False, 91), '(': (False, 91), '^': (True, 1683), 'do': (False, 91), '>': (False, 91), 'end': (False, 91), '==': (False, 91), '~=': (False, 91), '..': (True, 1697)}, {'if': (False, 95), 'or': (False, 95), '%': (True, 1685), 'repeat': (False, 95), 'return': (False, 95), 'elseif': (False, 95), 'else': (False, 95), 'for': (False, 95), 'EMBEDSTAT': (False, 95), ';': (False, 95), 'goto': (False, 95), 'break': (False, 95), '*': (True, 1689), '>=': (False, 95), '-': (False, 95), '/': (True, 1695), 'local': (False, 95), '::': (False, 95), 'NAME': (False, 95), 'and': (False, 95), '+': (False, 95), ',': (False, 95), '<': (False, 95), 'function': (False, 95), 'while': (False, 95), '<=': (False, 95), '(': (False, 95), '^': (True, 1683), 'do': (False, 95), '>': (False, 95), 'end': (False, 95), '==': (False, 95), '~=': (False, 95), '..': (False, 95)}, {'if': (False, 97), 'function': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), 'elseif': (False, 97), 'else': (False, 97), 'for': (False, 97), 'or': (False, 97), 'EMBEDSTAT': (False, 97), ';': (False, 97), 'break': (False, 97), '*': (False, 97), '%': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '::': (False, 97), 'NAME': (False, 97), 'and': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'goto': (False, 97), 'while': (False, 97), ',': (False, 97), '(': (False, 97), '^': (True, 1683), 'do': (False, 97), '>': (False, 97), 'end': (False, 97), '==': (False, 97), '..': (False, 97), '~=': (False, 97)}, {'if': (False, 86), 'or': (False, 86), '%': (True, 1685), 'repeat': (False, 86), 'NAME': (False, 86), 'elseif': (False, 86), 'else': (False, 86), 'for': (False, 86), 'EMBEDSTAT': (False, 86), ';': (False, 86), 'break': (False, 86), '*': (True, 1689), '>=': (True, 1690), '-': (True, 1693), '/': (True, 1695), 'local': (False, 86), '::': (False, 86), 'return': (False, 86), 'and': (False, 86), '+': (True, 1686), '<=': (True, 1681), '<': (True, 1691), 'goto': (False, 86), 'while': (False, 86), ',': (False, 86), '(': (False, 86), '^': (True, 1683), 'do': (False, 86), '>': (True, 1688), 'end': (False, 86), '==': (True, 1687), '~=': (True, 1692), 'function': (False, 86), '..': (True, 1697)}, {'if': (False, 93), 'or': (False, 93), '%': (True, 1685), 'repeat': (False, 93), 'NAME': (False, 93), 'elseif': (False, 93), 'else': (False, 93), 'for': (False, 93), 'EMBEDSTAT': (False, 93), ';': (False, 93), 'goto': (False, 93), 'break': (False, 93), '*': (True, 1689), '>=': (False, 93), '-': (True, 1693), '/': (True, 1695), 'local': (False, 93), '::': (False, 93), 'return': (False, 93), 'and': (False, 93), '+': (True, 1686), '<=': (False, 93), '<': (False, 93), 'function': (False, 93), 'while': (False, 93), ',': (False, 93), '(': (False, 93), '^': (True, 1683), 'do': (False, 93), '>': (False, 93), 'end': (False, 93), '==': (False, 93), '~=': (False, 93), '..': (True, 1697)}, {'end': (True, 1874)}, {')': (True, 1936)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1937), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 1884), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'::': (False, 4), '[': (False, 4), 'return': (False, 4), 'goto': (False, 4), 'if': (False, 4), 'repeat': (False, 4), 'NAME': (False, 4), 'elseif': (False, 4), 'else': (False, 4), 'for': (False, 4), 'function': (False, 4), 'while': (False, 4), '(': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'do': (False, 4), 'break': (False, 4), ':': (False, 4), 'end': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), 'local': (False, 4)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), ',': (False, 39), '(': (False, 39), 'EOF': (False, 39), '^': (False, 39), ';': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'}': (True, 2009)}, {'(': (True, 1454), 'args': (True, 2013), 'tableconstructor': (True, 1457), 'STRING': (True, 1456), '{': (True, 1459)}, {'end': (False, 28), ';': (False, 28)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '>=': (False, 4), '<=': (False, 4), 'EOF': (False, 4), '^': (False, 4), '>': (False, 4), '*': (False, 4), ';': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), '/': (False, 4), '..': (False, 4)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2015), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), '>=': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'if': (False, 49), 'NAME': (False, 49), 'function': (False, 49), '::': (False, 49), 'return': (False, 49), 'for': (False, 49), 'goto': (False, 49), 'local': (False, 49), 'while': (False, 49), '(': (False, 49), 'EMBEDSTAT': (False, 49), 'end': (False, 49), 'do': (False, 49), 'break': (False, 49), ';': (False, 49), 'repeat': (False, 49)}, {'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), 'else': (False, 4), '<': (False, 4), '>=': (False, 4), '<=': (False, 4), '^': (False, 4), ';': (False, 4), '>': (False, 4), '*': (False, 4), 'end': (False, 4), '==': (False, 4), '~=': (False, 4), '-': (False, 4), 'elseif': (False, 4), '/': (False, 4), '..': (False, 4)}, {'end': (True, 1947)}, {'if': (False, 89), 'or': (False, 89), '%': (True, 1544), 'repeat': (False, 89), 'NAME': (False, 89), 'for': (False, 89), 'EMBEDSTAT': (False, 89), 'break': (False, 89), '*': (True, 1543), '>=': (False, 89), '-': (True, 1547), '/': (True, 1549), 'local': (False, 89), '::': (False, 89), 'return': (False, 89), 'and': (False, 89), '+': (True, 1540), ',': (False, 89), '<': (False, 89), 'goto': (False, 89), 'while': (False, 89), '<=': (False, 89), '(': (False, 89), 'EOF': (False, 89), '^': (True, 1546), 'do': (False, 89), '>': (False, 89), ';': (False, 89), '==': (False, 89), '~=': (False, 89), 'function': (False, 89), '..': (True, 1551)}, {'if': (False, 85), 'goto': (False, 85), '%': (True, 1544), 'return': (False, 85), 'for': (False, 85), 'local': (False, 85), 'or': (False, 85), 'EMBEDSTAT': (False, 85), 'break': (False, 85), '*': (True, 1543), '>=': (True, 1539), '-': (True, 1547), '/': (True, 1549), 'repeat': (False, 85), '::': (False, 85), 'NAME': (False, 85), 'and': (True, 1537), '+': (True, 1540), '<=': (True, 1535), '<': (True, 1541), 'function': (False, 85), 'while': (False, 85), ',': (False, 85), '(': (False, 85), 'EOF': (False, 85), '^': (True, 1546), 'do': (False, 85), '>': (True, 1542), ';': (False, 85), '==': (True, 1545), '~=': (True, 1550), '..': (True, 1551)}, {'if': (False, 86), 'or': (False, 86), '%': (True, 1544), 'repeat': (False, 86), 'NAME': (False, 86), 'for': (False, 86), 'EMBEDSTAT': (False, 86), 'break': (False, 86), '*': (True, 1543), '>=': (True, 1539), '-': (True, 1547), '/': (True, 1549), 'local': (False, 86), '::': (False, 86), 'return': (False, 86), 'and': (False, 86), '+': (True, 1540), '<=': (True, 1535), '<': (True, 1541), 'goto': (False, 86), 'while': (False, 86), ',': (False, 86), '(': (False, 86), 'EOF': (False, 86), '^': (True, 1546), 'do': (False, 86), '>': (True, 1542), ';': (False, 86), '==': (True, 1545), '~=': (True, 1550), 'function': (False, 86), '..': (True, 1551)}, {'if': (False, 29), 'or': (True, 1536), '%': (True, 1544), 'return': (False, 29), 'for': (False, 29), 'local': (False, 29), 'EMBEDSTAT': (False, 29), 'break': (False, 29), '*': (True, 1543), '>=': (True, 1539), '-': (True, 1547), '/': (True, 1549), 'repeat': (False, 29), '::': (False, 29), 'NAME': (False, 29), 'and': (True, 1537), '+': (True, 1540), ',': (True, 1538), '<': (True, 1541), 'goto': (False, 29), 'while': (False, 29), '<=': (True, 1535), '(': (False, 29), 'EOF': (False, 29), '^': (True, 1546), 'do': (False, 29), '>': (True, 1542), ';': (False, 29), '==': (True, 1545), '~=': (True, 1550), 'explist__1': (True, 1917), 'function': (False, 29), '..': (True, 1551)}, {'if': (False, 90), 'or': (False, 90), '%': (True, 1544), 'return': (False, 90), 'for': (False, 90), 'local': (False, 90), 'EMBEDSTAT': (False, 90), 'break': (False, 90), '*': (True, 1543), '>=': (False, 90), '-': (True, 1547), '/': (True, 1549), 'repeat': (False, 90), '::': (False, 90), 'NAME': (False, 90), 'and': (False, 90), '+': (True, 1540), ',': (False, 90), '<': (False, 90), 'goto': (False, 90), 'while': (False, 90), '<=': (False, 90), '(': (False, 90), 'EOF': (False, 90), '^': (True, 1546), 'do': (False, 90), '>': (False, 90), ';': (False, 90), '==': (False, 90), '~=': (False, 90), 'function': (False, 90), '..': (True, 1551)}, {'if': (False, 94), 'or': (False, 94), '%': (True, 1544), 'repeat': (False, 94), 'return': (False, 94), 'for': (False, 94), 'EMBEDSTAT': (False, 94), 'break': (False, 94), '*': (True, 1543), '>=': (False, 94), '-': (False, 94), '/': (True, 1549), 'local': (False, 94), '::': (False, 94), 'NAME': (False, 94), 'and': (False, 94), '+': (False, 94), ',': (False, 94), '<': (False, 94), 'goto': (False, 94), 'while': (False, 94), '<=': (False, 94), '(': (False, 94), 'EOF': (False, 94), '^': (True, 1546), 'do': (False, 94), '>': (False, 94), ';': (False, 94), '==': (False, 94), '~=': (False, 94), 'function': (False, 94), '..': (False, 94)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'NAME': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), 'break': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'return': (False, 38), 'and': (False, 38), '+': (False, 38), ',': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '<=': (False, 38), '(': (False, 38), 'EOF': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), ';': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'if': (False, 87), 'goto': (False, 87), '%': (True, 1544), 'repeat': (False, 87), 'NAME': (False, 87), 'for': (False, 87), 'or': (False, 87), 'EMBEDSTAT': (False, 87), 'break': (False, 87), '*': (True, 1543), '>=': (False, 87), '-': (True, 1547), '/': (True, 1549), 'local': (False, 87), '::': (False, 87), 'return': (False, 87), 'and': (False, 87), '+': (True, 1540), ',': (False, 87), '<': (False, 87), 'function': (False, 87), 'while': (False, 87), '<=': (False, 87), '(': (False, 87), 'EOF': (False, 87), '^': (True, 1546), 'do': (False, 87), '>': (False, 87), ';': (False, 87), '==': (False, 87), '~=': (False, 87), '..': (True, 1551)}, {'if': (False, 88), 'or': (False, 88), '%': (True, 1544), 'repeat': (False, 88), 'return': (False, 88), 'for': (False, 88), 'EMBEDSTAT': (False, 88), 'goto': (False, 88), 'break': (False, 88), '*': (True, 1543), '>=': (False, 88), '-': (True, 1547), '/': (True, 1549), 'local': (False, 88), '::': (False, 88), 'NAME': (False, 88), 'and': (False, 88), '+': (True, 1540), '<=': (False, 88), '<': (False, 88), 'function': (False, 88), 'while': (False, 88), ',': (False, 88), '(': (False, 88), 'EOF': (False, 88), '^': (True, 1546), 'do': (False, 88), '>': (False, 88), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '..': (True, 1551)}, {'if': (False, 96), 'or': (False, 96), '>=': (False, 96), 'return': (False, 96), 'for': (False, 96), 'local': (False, 96), 'EMBEDSTAT': (False, 96), 'goto': (False, 96), 'break': (False, 96), '*': (False, 96), '%': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '::': (False, 96), 'NAME': (False, 96), 'and': (False, 96), '+': (False, 96), ',': (False, 96), '<': (False, 96), 'function': (False, 96), 'while': (False, 96), '<=': (False, 96), '(': (False, 96), 'EOF': (False, 96), '^': (True, 1546), 'do': (False, 96), '>': (False, 96), ';': (False, 96), '==': (False, 96), '..': (False, 96), '~=': (False, 96)}, {'if': (False, 98), 'goto': (False, 98), '>=': (False, 98), 'return': (False, 98), 'for': (False, 98), 'local': (False, 98), 'or': (False, 98), 'EMBEDSTAT': (False, 98), 'break': (False, 98), '*': (False, 98), '%': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '::': (False, 98), 'NAME': (False, 98), 'and': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), 'function': (False, 98), 'while': (False, 98), '<=': (False, 98), '(': (False, 98), 'EOF': (False, 98), '^': (True, 1546), 'do': (False, 98), '>': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '..': (False, 98)}, {'if': (False, 92), 'or': (False, 92), '%': (True, 1544), 'repeat': (False, 92), 'return': (False, 92), 'for': (False, 92), 'EMBEDSTAT': (False, 92), 'break': (False, 92), '*': (True, 1543), '>=': (False, 92), '-': (True, 1547), '/': (True, 1549), 'local': (False, 92), '::': (False, 92), 'NAME': (False, 92), 'and': (False, 92), '+': (True, 1540), ',': (False, 92), '<': (False, 92), 'goto': (False, 92), 'while': (False, 92), '<=': (False, 92), '(': (False, 92), 'EOF': (False, 92), '^': (True, 1546), 'do': (False, 92), '>': (False, 92), ';': (False, 92), '==': (False, 92), '~=': (False, 92), 'function': (False, 92), '..': (True, 1551)}, {'::': (False, 99), 'NAME': (False, 99), 'or': (False, 99), 'and': (False, 99), 'if': (False, 99), '>=': (False, 99), 'return': (False, 99), '+': (False, 99), '<=': (False, 99), '-': (False, 99), '<': (False, 99), 'for': (False, 99), 'goto': (False, 99), 'while': (False, 99), '(': (False, 99), 'EMBEDSTAT': (False, 99), '^': (True, 1312), ';': (False, 99), 'local': (False, 99), 'break': (False, 99), '>': (False, 99), '*': (False, 99), 'end': (False, 99), '==': (False, 99), '..': (False, 99), 'do': (False, 99), 'function': (False, 99), '/': (False, 99), 'repeat': (False, 99), '~=': (False, 99), '%': (False, 99)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), ',': (False, 98), '<': (False, 98), '%': (False, 98), '<=': (False, 98), 'EOF': (False, 98), '^': (True, 1485), '>': (False, 98), '*': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), '..': (False, 98)}, {',': (True, 1260), '*': (True, 1191), '^': (True, 1153), 'and': (True, 1186), '%': (True, 1188), 'stat__3': (True, 2007), 'do': (False, 10), '+': (True, 1189), '>': (True, 1200), '<=': (True, 1185), '>=': (True, 1192), '<': (True, 1193), '~=': (True, 1199), '-': (True, 1195), '==': (True, 1197), '/': (True, 1198), '..': (True, 1194), 'or': (True, 1196)}, {'if': (False, 87), 'NAME': (False, 87), 'or': (False, 87), 'and': (False, 87), '::': (False, 87), '%': (True, 1308), 'repeat': (False, 87), 'return': (False, 87), '+': (True, 1305), '<=': (False, 87), 'end': (False, 87), '<': (False, 87), 'for': (False, 87), 'goto': (False, 87), 'while': (False, 87), '(': (False, 87), 'EMBEDSTAT': (False, 87), '^': (True, 1312), ';': (False, 87), 'do': (False, 87), 'break': (False, 87), '>': (False, 87), '*': (True, 1307), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 1311), 'function': (False, 87), '/': (True, 1314), 'local': (False, 87), '..': (True, 1315)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 1487), '+': (False, 94), ',': (False, 94), '<': (False, 94), '<=': (False, 94), 'EOF': (False, 94), '^': (True, 1485), ';': (False, 94), '>': (False, 94), '*': (True, 1490), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '/': (True, 1497), '~=': (False, 94)}, {'do': (True, 1964)}, {'::': (False, 97), 'NAME': (False, 97), 'function': (False, 97), 'and': (False, 97), 'if': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'for': (False, 97), 'goto': (False, 97), 'while': (False, 97), 'or': (False, 97), '(': (False, 97), 'EMBEDSTAT': (False, 97), '^': (True, 1312), 'end': (False, 97), 'do': (False, 97), 'break': (False, 97), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '~=': (False, 97), '%': (False, 97)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 1487), '+': (True, 1488), ',': (False, 88), '<': (False, 88), '>=': (False, 88), '<=': (False, 88), 'EOF': (False, 88), '^': (True, 1485), '>': (False, 88), '*': (True, 1490), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {'if': (False, 93), 'NAME': (False, 93), 'or': (False, 93), 'and': (False, 93), '::': (False, 93), '%': (True, 1308), 'return': (False, 93), '+': (True, 1305), '<=': (False, 93), '<': (False, 93), 'for': (False, 93), 'goto': (False, 93), 'while': (False, 93), '(': (False, 93), ';': (False, 93), 'EMBEDSTAT': (False, 93), '^': (True, 1312), 'end': (False, 93), 'local': (False, 93), 'break': (False, 93), 'do': (False, 93), '>': (False, 93), '*': (True, 1307), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 1311), 'function': (False, 93), '/': (True, 1314), 'repeat': (False, 93), '..': (True, 1315)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), '%': (False, 96), ',': (False, 96), 'EOF': (False, 96), '^': (True, 1485), '>': (False, 96), '*': (False, 96), ';': (False, 96), '==': (False, 96), '..': (False, 96), '-': (False, 96), '/': (False, 96), '~=': (False, 96)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 1487), '+': (True, 1488), ',': (False, 90), '<': (False, 90), '>=': (False, 90), '<=': (False, 90), 'EOF': (False, 90), '^': (True, 1485), '>': (False, 90), '*': (True, 1490), ';': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 1487), '+': (True, 1488), '<=': (False, 87), '<': (False, 87), '>=': (False, 87), ',': (False, 87), 'EOF': (False, 87), '^': (True, 1485), '>': (False, 87), '*': (True, 1490), ';': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 1487), '+': (True, 1488), ',': (False, 93), '<': (False, 93), '>=': (False, 93), '<=': (False, 93), 'EOF': (False, 93), '^': (True, 1485), '>': (False, 93), '*': (True, 1490), ';': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {')': (True, 1943)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1946), '~=': (True, 414), 'or': (True, 419)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 1487), '+': (False, 95), '<=': (False, 95), '<': (False, 95), ',': (False, 95), 'EOF': (False, 95), '^': (True, 1485), ';': (False, 95), '>': (False, 95), '*': (True, 1490), '>=': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '/': (True, 1497), '~=': (False, 95)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 1487), '+': (True, 1488), ',': (False, 92), '<': (False, 92), '>=': (False, 92), '<=': (False, 92), 'EOF': (False, 92), '^': (True, 1485), '>': (False, 92), '*': (True, 1490), ';': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {'if': (False, 39), '[': (False, 39), 'function': (False, 39), '%': (False, 39), 'return': (False, 39), 'for': (False, 39), 'local': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'end': (False, 39), 'break': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'repeat': (False, 39), '::': (False, 39), 'NAME': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'goto': (False, 39), 'while': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '~=': (False, 39), '..': (False, 39)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), '>=': (False, 97), ',': (False, 97), 'EOF': (False, 97), '^': (True, 1485), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'}': (True, 1957)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 1487), '+': (True, 1488), '<=': (False, 91), '<': (False, 91), ',': (False, 91), 'EOF': (False, 91), '^': (True, 1485), ';': (False, 91), '>': (False, 91), '*': (True, 1490), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 1494), '/': (True, 1497), '..': (True, 1493)}, {'*': (True, 1490), '^': (True, 1485), 'and': (True, 1484), ';': (False, 85), '%': (True, 1487), '+': (True, 1488), '>': (True, 1489), '<=': (True, 1483), '>=': (True, 1491), ',': (False, 85), '<': (True, 1492), '~=': (True, 1498), '-': (True, 1494), 'or': (False, 85), '==': (True, 1495), '/': (True, 1497), '..': (True, 1493), 'EOF': (False, 85)}, {'(': (True, 1289), 'args': (True, 1949), 'tableconstructor': (True, 1292), 'STRING': (True, 1291), '{': (True, 1294)}, {'end': (False, 35), 'else': (True, 1562), 'stat__2': (True, 1950)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2010), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), ')': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'if': (False, 18), '[': (False, 18), 'or': (False, 18), '>=': (False, 18), 'NAME': (False, 18), 'elseif': (False, 18), 'else': (False, 18), 'for': (False, 18), 'local': (False, 18), 'EMBEDSTAT': (False, 18), 'end': (False, 18), 'goto': (False, 18), 'break': (False, 18), '*': (False, 18), '%': (False, 18), 'STRING': (False, 18), '.': (False, 18), '{': (False, 18), '-': (False, 18), '/': (False, 18), 'repeat': (False, 18), '::': (False, 18), 'return': (False, 18), 'and': (False, 18), '+': (False, 18), '<=': (False, 18), '<': (False, 18), 'function': (False, 18), 'while': (False, 18), '(': (False, 18), '^': (False, 18), 'do': (False, 18), ':': (False, 18), '>': (False, 18), ';': (False, 18), '==': (False, 18), '~=': (False, 18), '..': (False, 18)}, {'var': (True, 183), '(': (True, 184), 'tableconstructor': (True, 185), '{': (True, 195), 'NUMBER': (True, 199), 'EMBEDEXPR': (True, 188), 'NAME': (True, 189), '#': (True, 190), 'prefixexp': (True, 191), '...': (True, 192), 'true': (True, 193), 'STRING': (True, 194), 'function': (True, 186), '-': (True, 196), 'not': (True, 197), 'exp': (True, 1977), 'functioncall': (True, 202), 'nil': (True, 200), 'false': (True, 201), 'functiondef': (True, 187)}, {'if': (False, 37), '[': (False, 37), 'function': (False, 37), '%': (False, 37), 'repeat': (False, 37), 'NAME': (False, 37), 'elseif': (False, 37), 'else': (False, 37), 'for': (False, 37), 'or': (False, 37), 'EMBEDSTAT': (False, 37), 'end': (False, 37), 'break': (False, 37), '*': (False, 37), '>=': (False, 37), 'STRING': (False, 37), '.': (False, 37), '{': (False, 37), '-': (False, 37), '/': (False, 37), 'local': (False, 37), '::': (False, 37), 'return': (False, 37), 'and': (False, 37), '+': (False, 37), '<=': (False, 37), '<': (False, 37), 'goto': (False, 37), 'while': (False, 37), '(': (False, 37), '^': (False, 37), 'do': (False, 37), ':': (False, 37), '>': (False, 37), ';': (False, 37), '==': (False, 37), '~=': (False, 37), '..': (False, 37)}, {'if': (False, 84), 'or': (False, 84), '%': (False, 84), 'NAME': (False, 84), 'elseif': (False, 84), 'else': (False, 84), 'for': (False, 84), 'EMBEDSTAT': (False, 84), 'end': (False, 84), 'break': (False, 84), '*': (False, 84), '>=': (False, 84), '-': (False, 84), '/': (False, 84), 'repeat': (False, 84), '::': (False, 84), 'return': (False, 84), 'and': (False, 84), '+': (False, 84), '<=': (False, 84), '<': (False, 84), 'goto': (False, 84), 'while': (False, 84), '(': (False, 84), '^': (False, 84), 'local': (False, 84), '>': (False, 84), ';': (False, 84), '==': (False, 84), '~=': (False, 84), 'do': (False, 84), 'function': (False, 84), '..': (False, 84)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 1978), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 82), 'or': (False, 82), '%': (False, 82), 'repeat': (False, 82), 'return': (False, 82), 'elseif': (False, 82), 'else': (False, 82), 'for': (False, 82), 'EMBEDSTAT': (False, 82), 'end': (False, 82), 'break': (False, 82), '*': (False, 82), '>=': (False, 82), '-': (False, 82), '/': (False, 82), 'local': (False, 82), '::': (False, 82), 'NAME': (False, 82), 'and': (False, 82), '+': (False, 82), '<=': (False, 82), '<': (False, 82), 'goto': (False, 82), 'while': (False, 82), '(': (False, 82), '^': (False, 82), 'do': (False, 82), '>': (False, 82), ';': (False, 82), '==': (False, 82), '~=': (False, 82), 'function': (False, 82), '..': (False, 82)}, {'if': (False, 80), 'goto': (False, 80), '>=': (False, 80), 'NAME': (False, 80), 'elseif': (False, 80), 'else': (False, 80), 'for': (False, 80), 'local': (False, 80), 'or': (False, 80), 'EMBEDSTAT': (False, 80), 'end': (False, 80), 'break': (False, 80), '*': (False, 80), '%': (False, 80), '-': (False, 80), '/': (False, 80), 'repeat': (False, 80), '::': (False, 80), 'return': (False, 80), 'and': (False, 80), '+': (False, 80), '<=': (False, 80), '<': (False, 80), 'function': (False, 80), 'while': (False, 80), '(': (False, 80), '^': (False, 80), 'do': (False, 80), '>': (False, 80), ';': (False, 80), '==': (False, 80), '..': (False, 80), '~=': (False, 80)}, {'if': (False, 78), 'or': (False, 78), '>=': (False, 78), 'repeat': (False, 78), 'return': (False, 78), 'elseif': (False, 78), 'else': (False, 78), 'for': (False, 78), 'EMBEDSTAT': (False, 78), ';': (False, 78), 'break': (False, 78), '*': (False, 78), '%': (False, 78), '-': (False, 78), '/': (False, 78), 'local': (False, 78), '::': (False, 78), 'NAME': (False, 78), 'and': (False, 78), '+': (False, 78), '<=': (False, 78), '<': (False, 78), 'goto': (False, 78), 'while': (False, 78), '(': (False, 78), '^': (False, 78), 'do': (False, 78), '>': (False, 78), 'end': (False, 78), '==': (False, 78), '..': (False, 78), 'function': (False, 78), '~=': (False, 78)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 1979), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'if': (False, 83), '[': (True, 1981), 'or': (False, 83), '>=': (False, 83), 'NAME': (False, 83), 'elseif': (False, 83), 'else': (False, 83), 'for': (False, 83), 'local': (False, 83), 'EMBEDSTAT': (False, 83), 'end': (False, 83), 'goto': (False, 83), 'break': (False, 83), '*': (False, 83), '%': (False, 83), 'STRING': (True, 1982), '.': (True, 1984), '{': (True, 1985), '-': (False, 83), '/': (False, 83), 'repeat': (False, 83), '::': (False, 83), 'return': (False, 83), 'tableconstructor': (True, 1983), 'and': (False, 83), 'args': (True, 1986), '+': (False, 83), '<=': (False, 83), '<': (False, 83), 'function': (False, 83), 'while': (False, 83), '(': (True, 1980), '^': (False, 83), 'do': (False, 83), ':': (True, 1987), '>': (False, 83), ';': (False, 83), '==': (False, 83), '..': (False, 83), '~=': (False, 83)}, {'if': (False, 81), 'or': (False, 81), '%': (False, 81), 'repeat': (False, 81), 'NAME': (False, 81), 'elseif': (False, 81), 'else': (False, 81), 'for': (False, 81), 'EMBEDSTAT': (False, 81), ';': (False, 81), 'break': (False, 81), '*': (False, 81), '>=': (False, 81), '-': (False, 81), '/': (False, 81), 'local': (False, 81), '::': (False, 81), 'return': (False, 81), 'and': (False, 81), '+': (False, 81), '<=': (False, 81), '<': (False, 81), 'goto': (False, 81), 'while': (False, 81), '(': (False, 81), '^': (False, 81), 'do': (False, 81), '>': (False, 81), 'end': (False, 81), '==': (False, 81), '~=': (False, 81), 'function': (False, 81), '..': (False, 81)}, {'if': (False, 77), 'goto': (False, 77), '%': (False, 77), 'return': (False, 77), 'elseif': (False, 77), 'else': (False, 77), 'for': (False, 77), 'local': (False, 77), 'or': (False, 77), 'EMBEDSTAT': (False, 77), ';': (False, 77), 'break': (False, 77), '*': (False, 77), '>=': (False, 77), '-': (False, 77), '/': (False, 77), 'repeat': (False, 77), '::': (False, 77), 'NAME': (False, 77), 'and': (False, 77), '+': (False, 77), '<=': (False, 77), '<': (False, 77), 'function': (False, 77), 'while': (False, 77), '(': (False, 77), '^': (False, 77), 'do': (False, 77), '>': (False, 77), 'end': (False, 77), '==': (False, 77), '~=': (False, 77), '..': (False, 77)}, {'if': (False, 79), 'function': (False, 79), '>=': (False, 79), 'return': (False, 79), 'elseif': (False, 79), 'else': (False, 79), 'for': (False, 79), 'local': (False, 79), 'or': (False, 79), 'EMBEDSTAT': (False, 79), ';': (False, 79), 'break': (False, 79), '*': (False, 79), '%': (False, 79), '-': (False, 79), '/': (False, 79), 'repeat': (False, 79), '::': (False, 79), 'NAME': (False, 79), 'and': (False, 79), '+': (False, 79), '<=': (False, 79), '<': (False, 79), 'goto': (False, 79), 'while': (False, 79), '(': (False, 79), '^': (False, 79), 'do': (False, 79), '>': (False, 79), 'end': (False, 79), '==': (False, 79), '~=': (False, 79), '..': (False, 79)}, {'funcbody': (True, 1988), '(': (True, 1989)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 1990), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 1991), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'if': (False, 48), 'or': (True, 1993), '%': (True, 1995), 'return': (False, 48), 'elseif': (False, 48), 'else': (False, 48), 'for': (False, 48), 'local': (False, 48), 'EMBEDSTAT': (False, 48), 'end': (False, 48), 'goto': (False, 48), 'break': (False, 48), '*': (True, 1998), '>=': (True, 1999), '-': (True, 2002), '/': (True, 2005), 'repeat': (False, 48), '::': (False, 48), 'NAME': (False, 48), 'and': (True, 1994), '+': (True, 1996), '<=': (True, 1992), '<': (True, 2000), 'function': (False, 48), 'while': (False, 48), '(': (False, 48), '^': (True, 2003), 'do': (False, 48), '>': (True, 1997), ';': (False, 48), '==': (True, 2004), '~=': (True, 2001), '..': (True, 2006)}, {'if': (False, 75), 'or': (False, 75), '%': (False, 75), 'repeat': (False, 75), 'return': (False, 75), 'elseif': (False, 75), 'else': (False, 75), 'for': (False, 75), 'EMBEDSTAT': (False, 75), 'end': (False, 75), 'goto': (False, 75), 'break': (False, 75), '*': (False, 75), '>=': (False, 75), '-': (False, 75), '/': (False, 75), 'local': (False, 75), '::': (False, 75), 'NAME': (False, 75), 'and': (False, 75), '+': (False, 75), '<=': (False, 75), '<': (False, 75), 'function': (False, 75), 'while': (False, 75), '(': (False, 75), '^': (False, 75), 'do': (False, 75), '>': (False, 75), ';': (False, 75), '==': (False, 75), '~=': (False, 75), '..': (False, 75)}, {'if': (False, 76), 'or': (False, 76), '>=': (False, 76), 'NAME': (False, 76), 'elseif': (False, 76), 'else': (False, 76), 'for': (False, 76), 'EMBEDSTAT': (False, 76), 'end': (False, 76), 'break': (False, 76), '*': (False, 76), '%': (False, 76), '-': (False, 76), '/': (False, 76), 'repeat': (False, 76), '::': (False, 76), 'return': (False, 76), 'and': (False, 76), '+': (False, 76), '<=': (False, 76), '<': (False, 76), 'goto': (False, 76), 'while': (False, 76), '(': (False, 76), '^': (False, 76), 'local': (False, 76), '>': (False, 76), ';': (False, 76), '==': (False, 76), '..': (False, 76), 'do': (False, 76), 'function': (False, 76), '~=': (False, 76)}, {'if': (False, 19), '[': (False, 19), 'goto': (False, 19), '%': (False, 19), 'repeat': (False, 19), 'NAME': (False, 19), 'elseif': (False, 19), 'else': (False, 19), 'for': (False, 19), 'or': (False, 19), 'EMBEDSTAT': (False, 19), 'end': (False, 19), 'break': (False, 19), '*': (False, 19), '>=': (False, 19), 'STRING': (False, 19), '.': (False, 19), '{': (False, 19), '-': (False, 19), '/': (False, 19), 'local': (False, 19), '::': (False, 19), 'return': (False, 19), 'and': (False, 19), '+': (False, 19), '<=': (False, 19), '<': (False, 19), 'function': (False, 19), 'while': (False, 19), '(': (False, 19), '^': (False, 19), 'do': (False, 19), ':': (False, 19), '>': (False, 19), ';': (False, 19), '==': (False, 19), '..': (False, 19), '~=': (False, 19)}, {')': (False, 28)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1910), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 1911), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'end': (True, 1885)}, {';': (False, 28), 'EOF': (False, 28)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'::': (False, 11), '[': (False, 11), 'return': (False, 11), 'goto': (False, 11), 'if': (False, 11), 'NAME': (False, 11), 'elseif': (False, 11), 'else': (False, 11), 'for': (False, 11), 'function': (False, 11), 'local': (False, 11), 'while': (False, 11), '(': (False, 11), 'EMBEDSTAT': (False, 11), ';': (False, 11), 'do': (False, 11), 'break': (False, 11), ':': (False, 11), 'end': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), 'repeat': (False, 11)}, {'::': (False, 61), 'return': (False, 61), 'goto': (False, 61), 'and': (False, 61), 'if': (False, 61), '%': (False, 61), 'repeat': (False, 61), 'NAME': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), 'for': (False, 61), 'function': (False, 61), 'while': (False, 61), 'or': (False, 61), '(': (False, 61), ';': (False, 61), 'EMBEDSTAT': (False, 61), '^': (False, 61), 'end': (False, 61), 'do': (False, 61), 'break': (False, 61), '>': (False, 61), '*': (False, 61), '>=': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), 'local': (False, 61), '..': (False, 61)}, {'::': (False, 4), 'return': (False, 4), 'or': (False, 4), 'and': (False, 4), 'if': (False, 4), '>=': (False, 4), 'repeat': (False, 4), 'NAME': (False, 4), '+': (False, 4), '<=': (False, 4), 'until': (False, 4), '<': (False, 4), 'for': (False, 4), 'goto': (False, 4), 'while': (False, 4), '(': (False, 4), 'EMBEDSTAT': (False, 4), '^': (False, 4), 'do': (False, 4), 'break': (False, 4), '>': (False, 4), '*': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '-': (False, 4), 'function': (False, 4), '/': (False, 4), 'local': (False, 4), '~=': (False, 4), '%': (False, 4)}, {'if': (False, 99), 'or': (False, 99), '>=': (False, 99), 'repeat': (False, 99), 'NAME': (False, 99), 'for': (False, 99), 'EMBEDSTAT': (False, 99), 'break': (False, 99), '*': (False, 99), '%': (False, 99), '-': (False, 99), '/': (False, 99), 'local': (False, 99), '::': (False, 99), 'return': (False, 99), 'and': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), 'goto': (False, 99), 'while': (False, 99), ',': (False, 99), '(': (False, 99), 'EOF': (False, 99), '^': (True, 1546), 'do': (False, 99), '>': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), 'function': (False, 99), '~=': (False, 99)}, {'if': (False, 39), '[': (False, 39), 'function': (False, 39), '%': (False, 39), 'repeat': (False, 39), 'NAME': (False, 39), 'elseif': (False, 39), 'else': (False, 39), 'for': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'end': (False, 39), 'break': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'local': (False, 39), '::': (False, 39), 'return': (False, 39), 'and': (False, 39), '+': (False, 39), ',': (False, 39), '<': (False, 39), 'goto': (False, 39), 'while': (False, 39), '<=': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '..': (False, 39), '~=': (False, 39)}, {'if': (False, 95), 'or': (False, 95), '%': (True, 1544), 'NAME': (False, 95), 'for': (False, 95), 'local': (False, 95), 'EMBEDSTAT': (False, 95), 'goto': (False, 95), 'break': (False, 95), '*': (True, 1543), '>=': (False, 95), '-': (False, 95), '/': (True, 1549), 'repeat': (False, 95), '::': (False, 95), 'return': (False, 95), 'and': (False, 95), '+': (False, 95), ',': (False, 95), '<': (False, 95), 'function': (False, 95), 'while': (False, 95), '<=': (False, 95), '(': (False, 95), 'EOF': (False, 95), '^': (True, 1546), 'do': (False, 95), '>': (False, 95), ';': (False, 95), '==': (False, 95), '~=': (False, 95), '..': (False, 95)}, {'}': (True, 1906)}, {'if': (False, 97), 'function': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), 'for': (False, 97), 'or': (False, 97), 'EMBEDSTAT': (False, 97), 'break': (False, 97), '*': (False, 97), '%': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '::': (False, 97), 'NAME': (False, 97), 'and': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'goto': (False, 97), 'while': (False, 97), ',': (False, 97), '(': (False, 97), 'EOF': (False, 97), '^': (True, 1546), 'do': (False, 97), '>': (False, 97), ';': (False, 97), '==': (False, 97), '~=': (False, 97), '..': (False, 97)}, {'(': (True, 1670), 'args': (True, 1976), 'tableconstructor': (True, 1673), 'STRING': (True, 1672), '{': (True, 1675)}, {'if': (False, 91), 'goto': (False, 91), '%': (True, 1544), 'return': (False, 91), 'for': (False, 91), 'local': (False, 91), 'or': (False, 91), 'EMBEDSTAT': (False, 91), 'break': (False, 91), '*': (True, 1543), '>=': (False, 91), '-': (True, 1547), '/': (True, 1549), 'repeat': (False, 91), '::': (False, 91), 'NAME': (False, 91), 'and': (False, 91), '+': (True, 1540), ',': (False, 91), '<': (False, 91), 'function': (False, 91), 'while': (False, 91), '<=': (False, 91), '(': (False, 91), 'EOF': (False, 91), '^': (True, 1546), 'do': (False, 91), '>': (False, 91), ';': (False, 91), '==': (False, 91), '~=': (False, 91), '..': (True, 1551)}, {'if': (False, 93), 'or': (False, 93), '%': (True, 1544), 'repeat': (False, 93), 'NAME': (False, 93), 'for': (False, 93), 'EMBEDSTAT': (False, 93), 'goto': (False, 93), 'break': (False, 93), '*': (True, 1543), '>=': (False, 93), '-': (True, 1547), '/': (True, 1549), 'local': (False, 93), '::': (False, 93), 'return': (False, 93), 'and': (False, 93), '+': (True, 1540), ',': (False, 93), '<': (False, 93), 'function': (False, 93), 'while': (False, 93), '<=': (False, 93), '(': (False, 93), 'EOF': (False, 93), '^': (True, 1546), 'do': (False, 93), '>': (False, 93), ';': (False, 93), '==': (False, 93), '~=': (False, 93), '..': (True, 1551)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), ',': (False, 38), '(': (False, 38), 'EOF': (False, 38), '^': (False, 38), ';': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '~=': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), '..': (False, 38), '.': (False, 38)}, {'if': (False, 61), 'goto': (False, 61), '%': (False, 61), 'return': (False, 61), 'for': (False, 61), 'local': (False, 61), 'or': (False, 61), 'EMBEDSTAT': (False, 61), ';': (False, 61), 'break': (False, 61), '*': (False, 61), '>=': (False, 61), '-': (False, 61), '/': (False, 61), 'repeat': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'and': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), 'function': (False, 61), 'while': (False, 61), '<=': (False, 61), '(': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), 'end': (False, 61), '==': (False, 61), '~=': (False, 61), '..': (False, 61)}, {'end': (False, 35), 'else': (True, 1562), 'stat__2': (True, 1953)}, {'or': (False, 61), 'and': (False, 61), '%': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), '>=': (False, 61), '<=': (False, 61), '^': (False, 61), 'end': (False, 61), '>': (False, 61), '*': (False, 61), ';': (False, 61), '==': (False, 61), '..': (False, 61), '-': (False, 61), '/': (False, 61), '~=': (False, 61)}, {'if': (False, 61), 'return': (False, 61), 'goto': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'for': (False, 61), 'function': (False, 61), 'local': (False, 61), 'while': (False, 61), 'EOF': (False, 61), '(': (False, 61), 'EMBEDSTAT': (False, 61), 'do': (False, 61), 'break': (False, 61), ';': (False, 61), 'repeat': (False, 61)}, {'end': (True, 1954)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'return': (False, 11), 'elseif': (False, 11), 'else': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), ';': (False, 11), 'break': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'NAME': (False, 11), 'and': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), 'end': (False, 11), '==': (False, 11), '~=': (False, 11), '..': (False, 11)}, {'if': (False, 85), 'return': (False, 85), 'function': (False, 85), 'and': (True, 1645), '::': (False, 85), '%': (True, 1650), 'repeat': (False, 85), 'NAME': (False, 85), '+': (True, 1647), '<=': (True, 1643), 'until': (False, 85), '<': (True, 1655), 'for': (False, 85), 'goto': (False, 85), 'while': (False, 85), 'or': (False, 85), '(': (False, 85), 'EMBEDSTAT': (False, 85), '^': (True, 1654), ';': (False, 85), 'do': (False, 85), 'break': (False, 85), '>': (True, 1648), '*': (True, 1649), '>=': (True, 1646), '==': (True, 1651), '..': (True, 1652), '-': (True, 1653), '/': (True, 1656), 'local': (False, 85), '~=': (True, 1657)}, {'::': (False, 89), 'while': (False, 89), 'return': (False, 89), 'or': (False, 89), 'and': (False, 89), 'if': (False, 89), '%': (True, 1650), 'repeat': (False, 89), 'NAME': (False, 89), '+': (True, 1647), '<=': (False, 89), '<': (False, 89), 'for': (False, 89), 'goto': (False, 89), 'until': (False, 89), '(': (False, 89), 'EMBEDSTAT': (False, 89), '^': (True, 1654), ';': (False, 89), 'do': (False, 89), 'break': (False, 89), '>': (False, 89), '*': (True, 1649), '>=': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 1653), 'function': (False, 89), '/': (True, 1656), 'local': (False, 89), '..': (True, 1652)}, {'::': (False, 86), 'while': (False, 86), 'NAME': (False, 86), 'or': (False, 86), 'and': (False, 86), 'if': (False, 86), '%': (True, 1650), 'repeat': (False, 86), 'return': (False, 86), '+': (True, 1647), '<=': (True, 1643), '<': (True, 1655), 'for': (False, 86), 'goto': (False, 86), 'until': (False, 86), '(': (False, 86), 'EMBEDSTAT': (False, 86), '^': (True, 1654), ';': (False, 86), 'do': (False, 86), 'break': (False, 86), '>': (True, 1648), '*': (True, 1649), '>=': (True, 1646), '==': (True, 1651), '..': (True, 1652), '-': (True, 1653), 'function': (False, 86), '/': (True, 1656), 'local': (False, 86), '~=': (True, 1657)}, {'::': (False, 90), 'return': (False, 90), 'or': (False, 90), 'and': (False, 90), 'if': (False, 90), '%': (True, 1650), 'NAME': (False, 90), '+': (True, 1647), '<=': (False, 90), '<': (False, 90), 'for': (False, 90), 'goto': (False, 90), 'local': (False, 90), '>=': (False, 90), '>': (False, 90), 'until': (False, 90), '(': (False, 90), 'EMBEDSTAT': (False, 90), '^': (True, 1654), 'do': (False, 90), 'break': (False, 90), 'while': (False, 90), '*': (True, 1649), ';': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 1653), 'function': (False, 90), '/': (True, 1656), 'repeat': (False, 90), '..': (True, 1652)}, {'if': (False, 94), 'return': (False, 94), 'or': (False, 94), 'and': (False, 94), '::': (False, 94), '%': (True, 1650), 'repeat': (False, 94), 'NAME': (False, 94), '+': (False, 94), '<=': (False, 94), '<': (False, 94), 'for': (False, 94), 'goto': (False, 94), '>': (False, 94), 'until': (False, 94), '(': (False, 94), 'EMBEDSTAT': (False, 94), '^': (True, 1654), ';': (False, 94), 'do': (False, 94), 'break': (False, 94), 'while': (False, 94), '*': (True, 1649), '>=': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), 'function': (False, 94), '/': (True, 1656), 'local': (False, 94), '~=': (False, 94)}, {'if': (False, 88), 'return': (False, 88), 'or': (False, 88), 'and': (False, 88), '::': (False, 88), '%': (True, 1650), 'repeat': (False, 88), 'NAME': (False, 88), '+': (True, 1647), '<=': (False, 88), '<': (False, 88), 'for': (False, 88), 'goto': (False, 88), '>': (False, 88), 'until': (False, 88), '(': (False, 88), 'EMBEDSTAT': (False, 88), '^': (True, 1654), ';': (False, 88), 'do': (False, 88), 'break': (False, 88), 'while': (False, 88), '*': (True, 1649), '>=': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 1653), 'function': (False, 88), '/': (True, 1656), 'local': (False, 88), '..': (True, 1652)}, {'::': (False, 96), 'return': (False, 96), 'goto': (False, 96), 'and': (False, 96), 'if': (False, 96), '>=': (False, 96), 'repeat': (False, 96), 'NAME': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), 'for': (False, 96), 'function': (False, 96), '>': (False, 96), 'until': (False, 96), 'or': (False, 96), '(': (False, 96), 'EMBEDSTAT': (False, 96), '^': (True, 1654), ';': (False, 96), 'do': (False, 96), 'break': (False, 96), 'while': (False, 96), '*': (False, 96), '%': (False, 96), '==': (False, 96), '~=': (False, 96), '-': (False, 96), '/': (False, 96), 'local': (False, 96), '..': (False, 96)}, {'if': (False, 98), 'NAME': (False, 98), 'or': (False, 98), 'and': (False, 98), '::': (False, 98), '>=': (False, 98), 'return': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), 'for': (False, 98), 'function': (False, 98), 'local': (False, 98), '>': (False, 98), 'until': (False, 98), '(': (False, 98), 'EMBEDSTAT': (False, 98), '^': (True, 1654), 'goto': (False, 98), 'do': (False, 98), 'break': (False, 98), 'while': (False, 98), '*': (False, 98), ';': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '..': (False, 98), '%': (False, 98)}, {'::': (False, 92), 'NAME': (False, 92), 'or': (False, 92), 'and': (False, 92), 'if': (False, 92), '%': (True, 1650), 'repeat': (False, 92), 'return': (False, 92), '+': (True, 1647), '<=': (False, 92), '<': (False, 92), 'for': (False, 92), 'goto': (False, 92), '>': (False, 92), 'while': (False, 92), '(': (False, 92), 'EMBEDSTAT': (False, 92), '^': (True, 1654), ';': (False, 92), 'do': (False, 92), 'break': (False, 92), 'until': (False, 92), '*': (True, 1649), '>=': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 1653), 'function': (False, 92), '/': (True, 1656), 'local': (False, 92), '..': (True, 1652)}, {'if': (False, 93), 'NAME': (False, 93), 'or': (False, 93), 'and': (False, 93), '::': (False, 93), '%': (True, 1650), 'return': (False, 93), '+': (True, 1647), '<=': (False, 93), '<': (False, 93), 'for': (False, 93), 'goto': (False, 93), '>': (False, 93), 'until': (False, 93), '(': (False, 93), 'EMBEDSTAT': (False, 93), '^': (True, 1654), ';': (False, 93), 'local': (False, 93), 'break': (False, 93), 'do': (False, 93), 'while': (False, 93), '*': (True, 1649), '>=': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 1653), 'function': (False, 93), '/': (True, 1656), 'repeat': (False, 93), '..': (True, 1652)}, {'::': (False, 95), 'NAME': (False, 95), 'or': (False, 95), 'and': (False, 95), 'if': (False, 95), '%': (True, 1650), 'repeat': (False, 95), 'return': (False, 95), '+': (False, 95), '<=': (False, 95), '<': (False, 95), 'for': (False, 95), 'function': (False, 95), '>': (False, 95), 'while': (False, 95), '(': (False, 95), 'EMBEDSTAT': (False, 95), '^': (True, 1654), ';': (False, 95), 'goto': (False, 95), 'do': (False, 95), 'break': (False, 95), 'until': (False, 95), '*': (True, 1649), '>=': (False, 95), '==': (False, 95), '~=': (False, 95), '-': (False, 95), '/': (True, 1656), 'local': (False, 95), '..': (False, 95)}, {'::': (False, 99), 'NAME': (False, 99), 'or': (False, 99), 'and': (False, 99), 'if': (False, 99), '>=': (False, 99), 'return': (False, 99), '+': (False, 99), '<=': (False, 99), '-': (False, 99), '<': (False, 99), 'for': (False, 99), 'goto': (False, 99), '>': (False, 99), 'until': (False, 99), '(': (False, 99), 'EMBEDSTAT': (False, 99), '^': (True, 1654), 'local': (False, 99), 'break': (False, 99), 'while': (False, 99), '*': (False, 99), ';': (False, 99), '==': (False, 99), '..': (False, 99), 'do': (False, 99), 'function': (False, 99), '/': (False, 99), 'repeat': (False, 99), '~=': (False, 99), '%': (False, 99)}, {'if': (False, 87), 'NAME': (False, 87), 'or': (False, 87), 'and': (False, 87), '::': (False, 87), '%': (True, 1650), 'repeat': (False, 87), 'return': (False, 87), '+': (True, 1647), '<=': (False, 87), '<': (False, 87), 'for': (False, 87), 'goto': (False, 87), '>': (False, 87), 'until': (False, 87), '(': (False, 87), 'EMBEDSTAT': (False, 87), '^': (True, 1654), ';': (False, 87), 'do': (False, 87), 'break': (False, 87), 'while': (False, 87), '*': (True, 1649), '>=': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 1653), 'function': (False, 87), '/': (True, 1656), 'local': (False, 87), '..': (True, 1652)}, {'::': (False, 97), 'NAME': (False, 97), 'function': (False, 97), 'and': (False, 97), 'if': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'for': (False, 97), 'goto': (False, 97), '>': (False, 97), 'until': (False, 97), 'or': (False, 97), '(': (False, 97), 'EMBEDSTAT': (False, 97), '^': (True, 1654), 'do': (False, 97), 'break': (False, 97), 'while': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '~=': (False, 97), '%': (False, 97)}, {'if': (False, 91), 'return': (False, 91), 'goto': (False, 91), 'and': (False, 91), '::': (False, 91), '%': (True, 1650), 'NAME': (False, 91), '+': (True, 1647), '<=': (False, 91), '<': (False, 91), 'for': (False, 91), 'function': (False, 91), 'local': (False, 91), '>': (False, 91), 'until': (False, 91), 'or': (False, 91), '(': (False, 91), 'EMBEDSTAT': (False, 91), '^': (True, 1654), ';': (False, 91), 'do': (False, 91), 'break': (False, 91), 'while': (False, 91), '*': (True, 1649), '>=': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 1653), '/': (True, 1656), 'repeat': (False, 91), '..': (True, 1652)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'return': (False, 4), 'elseif': (False, 4), 'else': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'if': (False, 4), 'goto': (False, 4), '>=': (False, 4), 'return': (False, 4), 'elseif': (False, 4), 'else': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '%': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'end': (True, 2011)}, {'end': (True, 2012)}, {'end': (True, 1955)}, {'end': (True, 1941)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), 'break': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '<=': (False, 4), '(': (False, 4), 'EOF': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {')': (True, 1942)}, {'if': (False, 108), '[': (False, 108), 'goto': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), 'break': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), 'function': (False, 108), 'while': (False, 108), '<=': (False, 108), '(': (False, 108), 'EOF': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), ';': (False, 108), '==': (False, 108), '..': (False, 108), '~=': (False, 108)}, {'::': (False, 47), 'NAME': (False, 47), 'goto': (False, 47), 'if': (False, 47), 'repeat': (False, 47), 'return': (False, 47), 'for': (False, 47), 'function': (False, 47), 'while': (False, 47), 'EOF': (False, 47), '(': (False, 47), 'EMBEDSTAT': (False, 47), 'do': (False, 47), 'break': (False, 47), ';': (False, 47), 'local': (False, 47)}, {'::': (False, 28), 'NAME': (False, 28), 'function': (False, 28), 'if': (False, 28), 'repeat': (False, 28), 'return': (False, 28), 'elseif': (False, 28), 'else': (False, 28), 'for': (False, 28), 'goto': (False, 28), 'while': (False, 28), '(': (False, 28), 'EMBEDSTAT': (False, 28), ';': (False, 28), 'do': (False, 28), 'break': (False, 28), 'end': (False, 28), 'local': (False, 28)}, {'if': (False, 28), 'NAME': (False, 28), 'function': (False, 28), '::': (False, 28), 'repeat': (False, 28), 'return': (False, 28), 'for': (False, 28), 'goto': (False, 28), 'while': (False, 28), 'EMBEDSTAT': (False, 28), '(': (False, 28), 'EOF': (False, 28), 'do': (False, 28), 'break': (False, 28), ';': (False, 28), 'local': (False, 28)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 1948), '~=': (True, 414), 'or': (True, 419)}, {')': (True, 2014)}, {'if': (False, 39), '[': (False, 39), 'function': (False, 39), '%': (False, 39), 'return': (False, 39), 'for': (False, 39), 'local': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'break': (False, 39), 'until': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'repeat': (False, 39), '::': (False, 39), 'NAME': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'goto': (False, 39), 'while': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '..': (False, 39), '~=': (False, 39)}, {'}': (True, 2016)}, {'if': (False, 49), 'NAME': (False, 49), 'goto': (False, 49), '::': (False, 49), 'return': (False, 49), 'for': (False, 49), 'function': (False, 49), 'local': (False, 49), 'while': (False, 49), 'EMBEDSTAT': (False, 49), '(': (False, 49), 'EOF': (False, 49), 'do': (False, 49), 'break': (False, 49), ';': (False, 49), 'repeat': (False, 49)}, {'(': (True, 1627), 'args': (True, 2025), 'tableconstructor': (True, 1630), 'STRING': (True, 1629), '{': (True, 1632)}, {'end': (False, 34)}, {'end': (True, 1939)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '==': (True, 416), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '<': (True, 413), '..': (True, 418), '-': (True, 415), ']': (True, 2028), '/': (True, 417), '~=': (True, 414), 'or': (True, 419)}, {'end': (True, 2020)}, {')': (True, 2029)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'NAME': (False, 38), 'elseif': (False, 38), 'else': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), 'end': (False, 38), 'break': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'return': (False, 38), 'and': (False, 38), '+': (False, 38), ',': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '<=': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), ';': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'[': (False, 39), 'or': (False, 39), 'and': (False, 39), '%': (False, 39), '+': (False, 39), '<=': (False, 39), 'else': (False, 39), '<': (False, 39), ',': (False, 39), '(': (False, 39), '^': (False, 39), ';': (False, 39), ':': (False, 39), '>': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '==': (False, 39), '~=': (False, 39), '{': (False, 39), '-': (False, 39), 'end': (False, 39), 'elseif': (False, 39), '/': (False, 39), '..': (False, 39), '.': (False, 39)}, {'end': (True, 1935)}, {'}': (True, 2030)}, {'(': (True, 1578), 'args': (True, 2031), 'tableconstructor': (True, 1581), 'STRING': (True, 1580), '{': (True, 1583)}, {'if': (False, 25), 'NAME': (False, 25), 'goto': (False, 25), '::': (False, 25), 'return': (False, 25), 'elseif': (False, 25), 'else': (False, 25), 'for': (False, 25), 'function': (False, 25), 'local': (False, 25), '=': (False, 25), 'while': (False, 25), '(': (False, 25), 'EMBEDSTAT': (False, 25), 'end': (False, 25), 'do': (False, 25), 'break': (False, 25), ';': (False, 25), 'repeat': (False, 25)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), 'then': (False, 61), '<=': (False, 61), '<': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), '<': (False, 11), '>=': (False, 11), '<=': (False, 11), '(': (False, 11), 'EOF': (False, 11), '^': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), ';': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'end': (True, 1940)}, {'do': (False, 28)}, {'::': (False, 47), 'NAME': (False, 47), 'goto': (False, 47), 'if': (False, 47), 'repeat': (False, 47), 'return': (False, 47), 'elseif': (False, 47), 'else': (False, 47), 'for': (False, 47), 'function': (False, 47), 'while': (False, 47), '(': (False, 47), 'EMBEDSTAT': (False, 47), ';': (False, 47), 'do': (False, 47), 'break': (False, 47), 'end': (False, 47), 'local': (False, 47)}, {'if': (False, 61), 'NAME': (False, 61), 'goto': (False, 61), '::': (False, 61), 'return': (False, 61), 'elseif': (False, 61), 'else': (False, 61), 'for': (False, 61), 'function': (False, 61), 'local': (False, 61), 'while': (False, 61), '(': (False, 61), 'EMBEDSTAT': (False, 61), 'end': (False, 61), 'do': (False, 61), 'break': (False, 61), ';': (False, 61), 'repeat': (False, 61)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), ')': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2018), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'NAME': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), ';': (False, 11), 'break': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'return': (False, 11), 'and': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), 'end': (False, 11), '==': (False, 11), '..': (False, 11), '~=': (False, 11)}, {'end': (True, 2019)}, {'end': (True, 1956)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'return': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), ';': (False, 38), 'break': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'NAME': (False, 38), 'and': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), 'end': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'::': (False, 50), 'NAME': (False, 50), 'function': (False, 50), 'if': (False, 50), 'repeat': (False, 50), 'return': (False, 50), 'for': (False, 50), 'goto': (False, 50), 'while': (False, 50), '(': (False, 50), 'EMBEDSTAT': (False, 50), 'do': (False, 50), 'break': (False, 50), 'until': (False, 50), ';': (False, 50), 'local': (False, 50)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'return': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), 'break': (False, 38), 'until': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'NAME': (False, 38), 'and': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), ';': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'if': (False, 108), '[': (False, 108), 'function': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), ';': (False, 108), 'break': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), '<=': (False, 108), '<': (False, 108), 'goto': (False, 108), 'while': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), 'end': (False, 108), '==': (False, 108), '~=': (False, 108), '..': (False, 108)}, {'end': (True, 2021)}, {')': (True, 2022)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2023), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'end': (True, 2024)}, {'or': (False, 61), 'and': (False, 61), '%': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), '>=': (False, 61), 'until': (False, 61), '<=': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), ';': (False, 61), '==': (False, 61), '..': (False, 61), '-': (False, 61), '/': (False, 61), '~=': (False, 61)}, {'if': (False, 61), 'goto': (False, 61), '%': (False, 61), 'return': (False, 61), 'for': (False, 61), 'local': (False, 61), 'or': (False, 61), 'EMBEDSTAT': (False, 61), 'break': (False, 61), '*': (False, 61), '>=': (False, 61), '-': (False, 61), '/': (False, 61), 'repeat': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'and': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), 'function': (False, 61), 'while': (False, 61), '<=': (False, 61), '(': (False, 61), 'EOF': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), ';': (False, 61), '==': (False, 61), '..': (False, 61), '~=': (False, 61)}, {'if': (False, 61), 'goto': (False, 61), '%': (False, 61), 'return': (False, 61), 'for': (False, 61), 'local': (False, 61), 'or': (False, 61), 'EMBEDSTAT': (False, 61), 'break': (False, 61), 'until': (False, 61), '*': (False, 61), '>=': (False, 61), '-': (False, 61), '/': (False, 61), 'repeat': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'and': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), 'function': (False, 61), 'while': (False, 61), '<=': (False, 61), '(': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), ';': (False, 61), '==': (False, 61), '..': (False, 61), '~=': (False, 61)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '>=': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '%': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'or': (False, 89), 'and': (False, 89), '%': (True, 1745), '+': (True, 1746), 'elseif': (False, 89), 'else': (False, 89), '<': (False, 89), '>=': (False, 89), '<=': (False, 89), '^': (True, 1752), ';': (False, 89), ',': (False, 89), '>': (False, 89), '*': (True, 1749), 'end': (False, 89), '==': (False, 89), '~=': (False, 89), '-': (True, 1753), '/': (True, 1756), '..': (True, 1757)}, {'*': (True, 1749), 'and': (True, 1743), '^': (True, 1752), ';': (False, 85), '%': (True, 1745), 'else': (False, 85), '+': (True, 1746), '>': (True, 1748), '<=': (True, 1741), '>=': (True, 1755), ',': (False, 85), '<': (True, 1747), '..': (True, 1757), '-': (True, 1753), 'end': (False, 85), '==': (True, 1751), 'elseif': (False, 85), '/': (True, 1756), '~=': (True, 1750), 'or': (False, 85)}, {'*': (True, 1749), ';': (False, 86), 'or': (False, 86), '^': (True, 1752), 'end': (False, 86), '%': (True, 1745), '+': (True, 1746), '>': (True, 1748), '<=': (True, 1741), '>=': (True, 1755), 'else': (False, 86), '<': (True, 1747), '..': (True, 1757), ',': (False, 86), '-': (True, 1753), '==': (True, 1751), 'elseif': (False, 86), '/': (True, 1756), 'and': (False, 86), '~=': (True, 1750)}, {',': (True, 1744), '*': (True, 1749), 'or': (True, 1742), '^': (True, 1752), ';': (False, 29), '%': (True, 1745), '..': (True, 1757), '+': (True, 1746), '>': (True, 1748), '<=': (True, 1741), '>=': (True, 1755), 'else': (False, 29), '<': (True, 1747), 'explist__1': (True, 2017), '-': (True, 1753), 'end': (False, 29), '==': (True, 1751), 'elseif': (False, 29), '/': (True, 1756), 'and': (True, 1743), '~=': (True, 1750)}, {'or': (False, 98), 'and': (False, 98), '>=': (False, 98), '+': (False, 98), 'elseif': (False, 98), 'else': (False, 98), '<': (False, 98), '%': (False, 98), ',': (False, 98), '^': (True, 1752), ';': (False, 98), '>': (False, 98), '*': (False, 98), 'end': (False, 98), '==': (False, 98), '~=': (False, 98), '-': (False, 98), '<=': (False, 98), '/': (False, 98), '..': (False, 98)}, {'or': (False, 94), 'and': (False, 94), '%': (True, 1745), '+': (False, 94), ',': (False, 94), 'else': (False, 94), '<': (False, 94), '>=': (False, 94), 'elseif': (False, 94), '^': (True, 1752), 'end': (False, 94), '>': (False, 94), '*': (True, 1749), ';': (False, 94), '==': (False, 94), '..': (False, 94), '-': (False, 94), '<=': (False, 94), '/': (True, 1756), '~=': (False, 94)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2026), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'or': (False, 87), 'and': (False, 87), '%': (True, 1745), '+': (True, 1746), ',': (False, 87), 'else': (False, 87), '<': (False, 87), '>=': (False, 87), 'elseif': (False, 87), '^': (True, 1752), ';': (False, 87), '>': (False, 87), '*': (True, 1749), 'end': (False, 87), '==': (False, 87), '~=': (False, 87), '-': (True, 1753), '<=': (False, 87), '/': (True, 1756), '..': (True, 1757)}, {'or': (False, 88), 'and': (False, 88), '%': (True, 1745), '+': (True, 1746), 'elseif': (False, 88), 'else': (False, 88), '<': (False, 88), '>=': (False, 88), ',': (False, 88), '^': (True, 1752), 'end': (False, 88), '>': (False, 88), '*': (True, 1749), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '-': (True, 1753), '<=': (False, 88), '/': (True, 1756), '..': (True, 1757)}, {'or': (False, 96), 'and': (False, 96), '>=': (False, 96), '+': (False, 96), '<=': (False, 96), 'else': (False, 96), '<': (False, 96), '%': (False, 96), ',': (False, 96), '^': (True, 1752), ';': (False, 96), '>': (False, 96), '*': (False, 96), 'end': (False, 96), '==': (False, 96), '..': (False, 96), '-': (False, 96), 'elseif': (False, 96), '/': (False, 96), '~=': (False, 96)}, {'or': (False, 91), 'and': (False, 91), '%': (True, 1745), '+': (True, 1746), ',': (False, 91), 'else': (False, 91), '<': (False, 91), '>=': (False, 91), 'elseif': (False, 91), '^': (True, 1752), ';': (False, 91), '>': (False, 91), '*': (True, 1749), 'end': (False, 91), '==': (False, 91), '~=': (False, 91), '-': (True, 1753), '<=': (False, 91), '/': (True, 1756), '..': (True, 1757)}, {'or': (False, 92), 'and': (False, 92), '%': (True, 1745), '+': (True, 1746), ',': (False, 92), 'else': (False, 92), '<': (False, 92), '>=': (False, 92), 'elseif': (False, 92), '^': (True, 1752), 'end': (False, 92), '>': (False, 92), '*': (True, 1749), ';': (False, 92), '==': (False, 92), '~=': (False, 92), '-': (True, 1753), '<=': (False, 92), '/': (True, 1756), '..': (True, 1757)}, {'or': (False, 99), 'and': (False, 99), '>=': (False, 99), '+': (False, 99), ',': (False, 99), 'else': (False, 99), '<': (False, 99), '%': (False, 99), '<=': (False, 99), '^': (True, 1752), ';': (False, 99), '>': (False, 99), '*': (False, 99), 'end': (False, 99), '==': (False, 99), '..': (False, 99), '-': (False, 99), 'elseif': (False, 99), '/': (False, 99), '~=': (False, 99)}, {'or': (False, 95), 'and': (False, 95), '%': (True, 1745), '+': (False, 95), ',': (False, 95), 'else': (False, 95), '<': (False, 95), '>=': (False, 95), 'elseif': (False, 95), '^': (True, 1752), 'end': (False, 95), '>': (False, 95), '*': (True, 1749), ';': (False, 95), '==': (False, 95), '..': (False, 95), '-': (False, 95), '<=': (False, 95), '/': (True, 1756), '~=': (False, 95)}, {'or': (False, 90), 'and': (False, 90), '%': (True, 1745), '+': (True, 1746), ',': (False, 90), 'else': (False, 90), '<': (False, 90), '>=': (False, 90), '<=': (False, 90), '^': (True, 1752), ';': (False, 90), '>': (False, 90), '*': (True, 1749), 'end': (False, 90), '==': (False, 90), '~=': (False, 90), '-': (True, 1753), 'elseif': (False, 90), '/': (True, 1756), '..': (True, 1757)}, {'or': (False, 97), 'and': (False, 97), '%': (False, 97), '+': (False, 97), 'elseif': (False, 97), 'else': (False, 97), '<': (False, 97), '>=': (False, 97), ',': (False, 97), '^': (True, 1752), 'end': (False, 97), '>': (False, 97), '*': (False, 97), ';': (False, 97), '==': (False, 97), '..': (False, 97), '-': (False, 97), '<=': (False, 97), '/': (False, 97), '~=': (False, 97)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2027), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'or': (False, 93), 'and': (False, 93), '%': (True, 1745), '+': (True, 1746), 'elseif': (False, 93), 'else': (False, 93), '<': (False, 93), '>=': (False, 93), ',': (False, 93), '^': (True, 1752), ';': (False, 93), '>': (False, 93), '*': (True, 1749), 'end': (False, 93), '==': (False, 93), '~=': (False, 93), '-': (True, 1753), '<=': (False, 93), '/': (True, 1756), '..': (True, 1757)}, {'if': (False, 108), '[': (False, 108), 'function': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'elseif': (False, 108), 'else': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), ';': (False, 108), 'break': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), ',': (False, 108), '<': (False, 108), 'goto': (False, 108), 'while': (False, 108), '<=': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), 'end': (False, 108), '==': (False, 108), '~=': (False, 108), '..': (False, 108)}, {'*': (True, 337), 'and': (True, 333), '^': (True, 332), '%': (True, 334), '..': (True, 345), '+': (True, 335), '>': (True, 336), '<=': (True, 331), '>=': (True, 343), '<': (True, 339), '~=': (True, 338), '-': (True, 341), '==': (True, 342), '/': (True, 344), ')': (True, 2033), 'or': (True, 346)}, {'}': (True, 2008)}, {'if': (False, 101), 'goto': (False, 101), '%': (False, 101), 'repeat': (False, 101), 'NAME': (False, 101), 'elseif': (False, 101), 'else': (False, 101), 'for': (False, 101), 'or': (False, 101), 'EMBEDSTAT': (False, 101), ';': (False, 101), 'break': (False, 101), '*': (False, 101), '>=': (False, 101), '-': (False, 101), '/': (False, 101), 'local': (False, 101), '::': (False, 101), 'return': (False, 101), 'and': (False, 101), '+': (False, 101), '<=': (False, 101), '<': (False, 101), 'function': (False, 101), 'while': (False, 101), '(': (False, 101), '^': (True, 2003), 'do': (False, 101), '>': (False, 101), 'end': (False, 101), '==': (False, 101), '~=': (False, 101), '..': (False, 101)}, {'tableconstructor': (True, 382), 'NAME': (True, 383), 'prefixexp': (True, 384), 'true': (True, 385), 'args__1': (True, 2035), 'function': (True, 387), 'not': (True, 388), 'false': (True, 389), 'var': (True, 390), '(': (True, 391), 'functiondef': (True, 392), 'EMBEDEXPR': (True, 393), 'NUMBER': (True, 394), '#': (True, 395), '...': (True, 396), 'STRING': (True, 397), 'explist': (True, 398), ')': (False, 31), '{': (True, 399), '-': (True, 400), 'exp': (True, 401), 'nil': (True, 402), 'functioncall': (True, 403)}, {'var': (True, 298), '(': (True, 299), 'tableconstructor': (True, 300), '{': (True, 310), 'NUMBER': (True, 314), 'EMBEDEXPR': (True, 303), 'NAME': (True, 304), '#': (True, 305), 'prefixexp': (True, 306), '...': (True, 307), 'true': (True, 308), 'STRING': (True, 309), 'function': (True, 301), '-': (True, 311), 'not': (True, 312), 'exp': (True, 2034), 'functioncall': (True, 317), 'nil': (True, 315), 'false': (True, 316), 'functiondef': (True, 302)}, {'if': (False, 13), '[': (False, 13), 'or': (False, 13), '>=': (False, 13), 'NAME': (False, 13), 'elseif': (False, 13), 'else': (False, 13), 'for': (False, 13), 'local': (False, 13), 'EMBEDSTAT': (False, 13), 'end': (False, 13), 'break': (False, 13), '*': (False, 13), '%': (False, 13), 'STRING': (False, 13), '.': (False, 13), '{': (False, 13), '-': (False, 13), '/': (False, 13), 'repeat': (False, 13), '::': (False, 13), 'return': (False, 13), 'and': (False, 13), '+': (False, 13), '<=': (False, 13), '<': (False, 13), 'goto': (False, 13), 'while': (False, 13), '(': (False, 13), '^': (False, 13), 'do': (False, 13), ':': (False, 13), '>': (False, 13), ';': (False, 13), '==': (False, 13), '~=': (False, 13), 'function': (False, 13), '..': (False, 13)}, {'if': (False, 12), '[': (False, 12), 'or': (False, 12), '>=': (False, 12), 'repeat': (False, 12), 'return': (False, 12), 'elseif': (False, 12), 'else': (False, 12), 'for': (False, 12), 'EMBEDSTAT': (False, 12), 'end': (False, 12), 'break': (False, 12), '*': (False, 12), '%': (False, 12), 'STRING': (False, 12), '.': (False, 12), '{': (False, 12), '-': (False, 12), '/': (False, 12), 'local': (False, 12), '::': (False, 12), 'NAME': (False, 12), 'and': (False, 12), '+': (False, 12), '<=': (False, 12), '<': (False, 12), 'goto': (False, 12), 'while': (False, 12), '(': (False, 12), '^': (False, 12), 'do': (False, 12), ':': (False, 12), '>': (False, 12), ';': (False, 12), '==': (False, 12), '..': (False, 12), 'function': (False, 12), '~=': (False, 12)}, {'NAME': (True, 2036)}, {'[': (True, 233), 'tableconstructor': (True, 234), 'NAME': (True, 235), 'prefixexp': (True, 236), 'true': (True, 237), 'function': (True, 238), 'not': (True, 239), 'false': (True, 240), 'var': (True, 241), '(': (True, 242), 'tableconstructor__1': (True, 2040), 'field': (True, 244), 'functiondef': (True, 247), 'EMBEDEXPR': (True, 246), 'NUMBER': (True, 245), '#': (True, 248), '}': (False, 70), '...': (True, 249), 'STRING': (True, 250), '{': (True, 251), '-': (True, 252), 'exp': (True, 253), 'nil': (True, 254), 'functioncall': (True, 255)}, {'if': (False, 107), '[': (False, 107), 'or': (False, 107), '>=': (False, 107), 'repeat': (False, 107), 'return': (False, 107), 'elseif': (False, 107), 'else': (False, 107), 'for': (False, 107), 'EMBEDSTAT': (False, 107), 'end': (False, 107), 'goto': (False, 107), 'break': (False, 107), '*': (False, 107), '%': (False, 107), 'STRING': (False, 107), '.': (False, 107), '{': (False, 107), '-': (False, 107), '/': (False, 107), 'local': (False, 107), '::': (False, 107), 'NAME': (False, 107), 'and': (False, 107), '+': (False, 107), '<=': (False, 107), '<': (False, 107), 'function': (False, 107), 'while': (False, 107), '(': (False, 107), '^': (False, 107), 'do': (False, 107), ':': (False, 107), '>': (False, 107), ';': (False, 107), '==': (False, 107), '~=': (False, 107), '..': (False, 107)}, {'NAME': (True, 2041)}, {'if': (False, 60), 'goto': (False, 60), '%': (False, 60), 'repeat': (False, 60), 'return': (False, 60), 'elseif': (False, 60), 'else': (False, 60), 'for': (False, 60), 'or': (False, 60), 'EMBEDSTAT': (False, 60), ';': (False, 60), 'break': (False, 60), '*': (False, 60), '>=': (False, 60), '-': (False, 60), '/': (False, 60), 'local': (False, 60), '::': (False, 60), 'NAME': (False, 60), 'and': (False, 60), '+': (False, 60), '<=': (False, 60), '<': (False, 60), 'function': (False, 60), 'while': (False, 60), '(': (False, 60), '^': (False, 60), 'do': (False, 60), '>': (False, 60), 'end': (False, 60), '==': (False, 60), '..': (False, 60), '~=': (False, 60)}, {'...': (True, 360), 'NAME': (True, 361), 'parlist': (True, 362), ')': (False, 6), 'funcbody__1': (True, 2042)}, {'if': (False, 102), 'goto': (False, 102), '>=': (False, 102), 'NAME': (False, 102), 'elseif': (False, 102), 'else': (False, 102), 'for': (False, 102), 'local': (False, 102), 'or': (False, 102), 'EMBEDSTAT': (False, 102), 'end': (False, 102), 'break': (False, 102), '*': (False, 102), '%': (False, 102), '-': (False, 102), '/': (False, 102), 'repeat': (False, 102), '::': (False, 102), 'return': (False, 102), 'and': (False, 102), '+': (False, 102), '<=': (False, 102), '<': (False, 102), 'function': (False, 102), 'while': (False, 102), '(': (False, 102), '^': (True, 2003), 'do': (False, 102), '>': (False, 102), ';': (False, 102), '==': (False, 102), '..': (False, 102), '~=': (False, 102)}, {'if': (False, 100), 'goto': (False, 100), '>=': (False, 100), 'repeat': (False, 100), 'return': (False, 100), 'elseif': (False, 100), 'else': (False, 100), 'for': (False, 100), 'or': (False, 100), 'EMBEDSTAT': (False, 100), 'end': (False, 100), 'break': (False, 100), '*': (False, 100), '%': (False, 100), '-': (False, 100), '/': (False, 100), 'local': (False, 100), '::': (False, 100), 'NAME': (False, 100), 'and': (False, 100), '+': (False, 100), '<=': (False, 100), '<': (False, 100), 'function': (False, 100), 'while': (False, 100), '(': (False, 100), '^': (True, 2003), 'do': (False, 100), '>': (False, 100), ';': (False, 100), '==': (False, 100), '~=': (False, 100), '..': (False, 100)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2046), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2045), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2047), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2048), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2049), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2050), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2051), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2052), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2053), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2054), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2055), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2056), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2057), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2058), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'var': (True, 1847), '(': (True, 1848), 'NAME': (True, 1849), 'tableconstructor': (True, 1850), 'function': (True, 1860), 'NUMBER': (True, 1854), 'EMBEDEXPR': (True, 1853), 'functiondef': (True, 1852), '#': (True, 1855), 'prefixexp': (True, 1856), '...': (True, 1857), 'true': (True, 1858), 'STRING': (True, 1859), '{': (True, 1851), '-': (True, 1861), 'not': (True, 1862), 'exp': (True, 2059), 'nil': (True, 1864), 'false': (True, 1865), 'functioncall': (True, 1866)}, {'do': (True, 2060)}, {'if': (False, 4), 'goto': (False, 4), '>=': (False, 4), 'return': (False, 4), 'elseif': (False, 4), 'else': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '%': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '%': (False, 4), '+': (False, 4), ',': (False, 4), '<': (False, 4), '<=': (False, 4), '(': (False, 4), 'EOF': (False, 4), '^': (False, 4), ';': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'end': (True, 2061)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), ')': (False, 61), '<=': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), '<=': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), '*': (False, 61), '%': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '~=': (False, 108), '<': (False, 108), '<=': (False, 108), '(': (False, 108), 'EOF': (False, 108), '^': (False, 108), ';': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), '..': (False, 108)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'NAME': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), 'break': (False, 11), 'until': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'return': (False, 11), 'and': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), ';': (False, 11), '==': (False, 11), '..': (False, 11), '~=': (False, 11)}, {'end': (True, 2038)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'return': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), 'break': (False, 4), 'until': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), ';': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'elseif': (False, 28), 'end': (False, 28), 'else': (False, 28), ';': (False, 28)}, {'end': (True, 2043)}, {'if': (False, 51), 'return': (False, 51), 'function': (False, 51), '::': (False, 51), 'repeat': (False, 51), 'NAME': (False, 51), 'for': (False, 51), 'goto': (False, 51), 'while': (False, 51), 'EOF': (False, 51), '(': (False, 51), 'EMBEDSTAT': (False, 51), 'do': (False, 51), 'break': (False, 51), ';': (False, 51), 'local': (False, 51)}, {'or': (False, 61), 'and': (False, 61), '%': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), '>=': (False, 61), '<=': (False, 61), 'EOF': (False, 61), '^': (False, 61), '>': (False, 61), '*': (False, 61), ';': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), '..': (False, 61)}, {'if': (False, 49), 'NAME': (False, 49), 'function': (False, 49), '::': (False, 49), 'repeat': (False, 49), 'return': (False, 49), 'elseif': (False, 49), 'else': (False, 49), 'for': (False, 49), 'goto': (False, 49), 'while': (False, 49), '(': (False, 49), 'EMBEDSTAT': (False, 49), 'end': (False, 49), 'do': (False, 49), 'break': (False, 49), ';': (False, 49), 'local': (False, 49)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2044), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'end': (True, 2063)}, {'if': (False, 49), 'NAME': (False, 49), 'function': (False, 49), '::': (False, 49), 'return': (False, 49), 'for': (False, 49), 'goto': (False, 49), 'local': (False, 49), 'until': (False, 49), '(': (False, 49), 'EMBEDSTAT': (False, 49), 'do': (False, 49), 'break': (False, 49), 'while': (False, 49), ';': (False, 49), 'repeat': (False, 49)}, {'if': (False, 108), '[': (False, 108), 'function': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), 'break': (False, 108), 'while': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), '<=': (False, 108), '<': (False, 108), 'goto': (False, 108), 'until': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), ';': (False, 108), '==': (False, 108), '..': (False, 108), '~=': (False, 108)}, {'end': (True, 2037)}, {'end': (True, 2032)}, {'[': (False, 38), 'or': (False, 38), 'and': (False, 38), '%': (False, 38), '+': (False, 38), '<=': (False, 38), 'else': (False, 38), '<': (False, 38), ',': (False, 38), '(': (False, 38), '^': (False, 38), ';': (False, 38), ':': (False, 38), '>': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '==': (False, 38), '..': (False, 38), '{': (False, 38), '-': (False, 38), 'end': (False, 38), 'elseif': (False, 38), '/': (False, 38), '~=': (False, 38), '.': (False, 38)}, {'[': (False, 11), 'or': (False, 11), 'and': (False, 11), '%': (False, 11), '+': (False, 11), ',': (False, 11), 'else': (False, 11), '<': (False, 11), '>=': (False, 11), '<=': (False, 11), '(': (False, 11), '^': (False, 11), 'end': (False, 11), ':': (False, 11), '>': (False, 11), '*': (False, 11), ';': (False, 11), 'STRING': (False, 11), '==': (False, 11), '~=': (False, 11), '{': (False, 11), '-': (False, 11), 'elseif': (False, 11), '/': (False, 11), '..': (False, 11), '.': (False, 11)}, {'[': (False, 4), 'or': (False, 4), 'and': (False, 4), '>=': (False, 4), '+': (False, 4), ',': (False, 4), 'else': (False, 4), '<': (False, 4), '<=': (False, 4), 'elseif': (False, 4), '(': (False, 4), '^': (False, 4), ';': (False, 4), ':': (False, 4), '>': (False, 4), '*': (False, 4), '%': (False, 4), 'STRING': (False, 4), '==': (False, 4), '..': (False, 4), '{': (False, 4), '-': (False, 4), 'end': (False, 4), '/': (False, 4), '~=': (False, 4), '.': (False, 4)}, {'[': (False, 108), 'or': (False, 108), 'and': (False, 108), '>=': (False, 108), '+': (False, 108), ',': (False, 108), '~=': (False, 108), 'else': (False, 108), '<': (False, 108), '<=': (False, 108), '(': (False, 108), ';': (False, 108), '^': (False, 108), 'end': (False, 108), ':': (False, 108), '>': (False, 108), '*': (False, 108), '%': (False, 108), 'STRING': (False, 108), '==': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), 'elseif': (False, 108), '/': (False, 108), '..': (False, 108)}, {'::': (False, 50), 'NAME': (False, 50), 'function': (False, 50), 'if': (False, 50), 'repeat': (False, 50), 'return': (False, 50), 'for': (False, 50), 'goto': (False, 50), 'while': (False, 50), '(': (False, 50), 'EMBEDSTAT': (False, 50), 'end': (False, 50), 'do': (False, 50), 'break': (False, 50), ';': (False, 50), 'local': (False, 50)}, {'if': (False, 20), '[': (False, 20), 'goto': (False, 20), '>=': (False, 20), 'NAME': (False, 20), 'elseif': (False, 20), 'else': (False, 20), 'for': (False, 20), 'local': (False, 20), 'or': (False, 20), 'EMBEDSTAT': (False, 20), 'end': (False, 20), 'break': (False, 20), '*': (False, 20), '%': (False, 20), 'STRING': (False, 20), '.': (False, 20), '{': (False, 20), '-': (False, 20), '/': (False, 20), 'repeat': (False, 20), '::': (False, 20), 'return': (False, 20), 'and': (False, 20), '+': (False, 20), '<=': (False, 20), '<': (False, 20), 'function': (False, 20), 'while': (False, 20), '(': (False, 20), '^': (False, 20), 'do': (False, 20), ':': (False, 20), '>': (False, 20), ';': (False, 20), '==': (False, 20), '..': (False, 20), '~=': (False, 20)}, {'*': (True, 411), 'and': (True, 406), '^': (True, 405), '%': (True, 407), '+': (True, 408), '>': (True, 410), '<=': (True, 404), '>=': (True, 412), '==': (True, 416), '..': (True, 418), '-': (True, 415), '<': (True, 413), '/': (True, 417), ']': (True, 2039), '~=': (True, 414), 'or': (True, 419)}, {')': (True, 2066)}, {'if': (False, 39), '[': (False, 39), 'function': (False, 39), '%': (False, 39), 'repeat': (False, 39), 'NAME': (False, 39), 'elseif': (False, 39), 'else': (False, 39), 'for': (False, 39), 'or': (False, 39), 'EMBEDSTAT': (False, 39), 'end': (False, 39), 'break': (False, 39), '*': (False, 39), '>=': (False, 39), 'STRING': (False, 39), '.': (False, 39), '{': (False, 39), '-': (False, 39), '/': (False, 39), 'local': (False, 39), '::': (False, 39), 'return': (False, 39), 'and': (False, 39), '+': (False, 39), '<=': (False, 39), '<': (False, 39), 'goto': (False, 39), 'while': (False, 39), '(': (False, 39), '^': (False, 39), 'do': (False, 39), ':': (False, 39), '>': (False, 39), ';': (False, 39), '==': (False, 39), '~=': (False, 39), '..': (False, 39)}, {'::': (False, 50), 'NAME': (False, 50), 'function': (False, 50), 'if': (False, 50), 'repeat': (False, 50), 'return': (False, 50), 'for': (False, 50), 'goto': (False, 50), 'while': (False, 50), 'EOF': (False, 50), '(': (False, 50), 'EMBEDSTAT': (False, 50), 'do': (False, 50), 'break': (False, 50), ';': (False, 50), 'local': (False, 50)}, {'if': (False, 61), 'return': (False, 61), 'goto': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'for': (False, 61), 'function': (False, 61), 'local': (False, 61), 'while': (False, 61), '(': (False, 61), 'EMBEDSTAT': (False, 61), 'end': (False, 61), 'do': (False, 61), 'break': (False, 61), ';': (False, 61), 'repeat': (False, 61)}, {'if': (False, 38), '[': (False, 38), 'function': (False, 38), '%': (False, 38), 'repeat': (False, 38), 'return': (False, 38), 'elseif': (False, 38), 'else': (False, 38), 'for': (False, 38), 'or': (False, 38), 'EMBEDSTAT': (False, 38), 'end': (False, 38), 'break': (False, 38), '*': (False, 38), '>=': (False, 38), 'STRING': (False, 38), '.': (False, 38), '{': (False, 38), '-': (False, 38), '/': (False, 38), 'local': (False, 38), '::': (False, 38), 'NAME': (False, 38), 'and': (False, 38), '+': (False, 38), '<=': (False, 38), '<': (False, 38), 'goto': (False, 38), 'while': (False, 38), '(': (False, 38), '^': (False, 38), 'do': (False, 38), ':': (False, 38), '>': (False, 38), ';': (False, 38), '==': (False, 38), '..': (False, 38), '~=': (False, 38)}, {'}': (True, 2067)}, {'(': (True, 1980), 'args': (True, 2068), 'tableconstructor': (True, 1983), 'STRING': (True, 1982), '{': (True, 1985)}, {')': (True, 2069)}, {'or': (False, 61), 'and': (False, 61), '>=': (False, 61), '+': (False, 61), '<=': (False, 61), 'else': (False, 61), '<': (False, 61), '%': (False, 61), ',': (False, 61), '^': (False, 61), 'end': (False, 61), '>': (False, 61), '*': (False, 61), ';': (False, 61), '==': (False, 61), '..': (False, 61), '-': (False, 61), 'elseif': (False, 61), '/': (False, 61), '~=': (False, 61)}, {'end': (True, 2062)}, {'if': (False, 85), 'goto': (False, 85), '%': (True, 1995), 'return': (False, 85), 'elseif': (False, 85), 'else': (False, 85), 'for': (False, 85), 'local': (False, 85), 'or': (False, 85), 'EMBEDSTAT': (False, 85), 'end': (False, 85), 'break': (False, 85), '*': (True, 1998), '>=': (True, 1999), '-': (True, 2002), '/': (True, 2005), 'repeat': (False, 85), '::': (False, 85), 'NAME': (False, 85), 'and': (True, 1994), '+': (True, 1996), '<=': (True, 1992), '<': (True, 2000), 'function': (False, 85), 'while': (False, 85), '(': (False, 85), '^': (True, 2003), 'do': (False, 85), '>': (True, 1997), ';': (False, 85), '==': (True, 2004), '~=': (True, 2001), '..': (True, 2006)}, {'if': (False, 89), 'goto': (False, 89), '%': (True, 1995), 'repeat': (False, 89), 'NAME': (False, 89), 'elseif': (False, 89), 'else': (False, 89), 'for': (False, 89), 'or': (False, 89), 'EMBEDSTAT': (False, 89), ';': (False, 89), 'break': (False, 89), '*': (True, 1998), '>=': (False, 89), '-': (True, 2002), '/': (True, 2005), 'local': (False, 89), '::': (False, 89), 'return': (False, 89), 'and': (False, 89), '+': (True, 1996), '<=': (False, 89), '<': (False, 89), 'function': (False, 89), 'while': (False, 89), '(': (False, 89), '^': (True, 2003), 'do': (False, 89), '>': (False, 89), 'end': (False, 89), '==': (False, 89), '~=': (False, 89), '..': (True, 2006)}, {'if': (False, 86), 'or': (False, 86), '%': (True, 1995), 'repeat': (False, 86), 'NAME': (False, 86), 'elseif': (False, 86), 'else': (False, 86), 'for': (False, 86), 'EMBEDSTAT': (False, 86), ';': (False, 86), 'break': (False, 86), '*': (True, 1998), '>=': (True, 1999), '-': (True, 2002), '/': (True, 2005), 'local': (False, 86), '::': (False, 86), 'return': (False, 86), 'and': (False, 86), '+': (True, 1996), '<=': (True, 1992), '<': (True, 2000), 'goto': (False, 86), 'while': (False, 86), '(': (False, 86), '^': (True, 2003), 'do': (False, 86), '>': (True, 1997), 'end': (False, 86), '==': (True, 2004), '~=': (True, 2001), 'function': (False, 86), '..': (True, 2006)}, {'if': (False, 98), 'goto': (False, 98), '>=': (False, 98), 'return': (False, 98), 'elseif': (False, 98), 'else': (False, 98), 'for': (False, 98), 'local': (False, 98), 'or': (False, 98), 'EMBEDSTAT': (False, 98), ';': (False, 98), 'break': (False, 98), '*': (False, 98), '%': (False, 98), '-': (False, 98), '/': (False, 98), 'repeat': (False, 98), '::': (False, 98), 'NAME': (False, 98), 'and': (False, 98), '+': (False, 98), '<=': (False, 98), '<': (False, 98), 'function': (False, 98), 'while': (False, 98), '(': (False, 98), '^': (True, 2003), 'do': (False, 98), '>': (False, 98), 'end': (False, 98), '==': (False, 98), '~=': (False, 98), '..': (False, 98)}, {'if': (False, 94), 'or': (False, 94), '%': (True, 1995), 'repeat': (False, 94), 'return': (False, 94), 'elseif': (False, 94), 'else': (False, 94), 'for': (False, 94), 'EMBEDSTAT': (False, 94), 'end': (False, 94), 'break': (False, 94), '*': (True, 1998), '>=': (False, 94), '-': (False, 94), '/': (True, 2005), 'local': (False, 94), '::': (False, 94), 'NAME': (False, 94), 'and': (False, 94), '+': (False, 94), '<=': (False, 94), '<': (False, 94), 'goto': (False, 94), 'while': (False, 94), '(': (False, 94), '^': (True, 2003), 'do': (False, 94), '>': (False, 94), ';': (False, 94), '==': (False, 94), '~=': (False, 94), 'function': (False, 94), '..': (False, 94)}, {'if': (False, 88), 'or': (False, 88), '%': (True, 1995), 'repeat': (False, 88), 'return': (False, 88), 'elseif': (False, 88), 'else': (False, 88), 'for': (False, 88), 'EMBEDSTAT': (False, 88), 'end': (False, 88), 'goto': (False, 88), 'break': (False, 88), '*': (True, 1998), '>=': (False, 88), '-': (True, 2002), '/': (True, 2005), 'local': (False, 88), '::': (False, 88), 'NAME': (False, 88), 'and': (False, 88), '+': (True, 1996), '<=': (False, 88), '<': (False, 88), 'function': (False, 88), 'while': (False, 88), '(': (False, 88), '^': (True, 2003), 'do': (False, 88), '>': (False, 88), ';': (False, 88), '==': (False, 88), '~=': (False, 88), '..': (True, 2006)}, {'if': (False, 96), 'goto': (False, 96), '>=': (False, 96), 'return': (False, 96), 'elseif': (False, 96), 'else': (False, 96), 'for': (False, 96), 'local': (False, 96), 'or': (False, 96), 'EMBEDSTAT': (False, 96), ';': (False, 96), 'break': (False, 96), '*': (False, 96), '%': (False, 96), '-': (False, 96), '/': (False, 96), 'repeat': (False, 96), '::': (False, 96), 'NAME': (False, 96), 'and': (False, 96), '+': (False, 96), '<=': (False, 96), '<': (False, 96), 'function': (False, 96), 'while': (False, 96), '(': (False, 96), '^': (True, 2003), 'do': (False, 96), '>': (False, 96), 'end': (False, 96), '==': (False, 96), '..': (False, 96), '~=': (False, 96)}, {'if': (False, 90), 'or': (False, 90), '%': (True, 1995), 'return': (False, 90), 'elseif': (False, 90), 'else': (False, 90), 'for': (False, 90), 'local': (False, 90), 'EMBEDSTAT': (False, 90), ';': (False, 90), 'break': (False, 90), '*': (True, 1998), '>=': (False, 90), '-': (True, 2002), '/': (True, 2005), 'repeat': (False, 90), '::': (False, 90), 'NAME': (False, 90), 'and': (False, 90), '+': (True, 1996), '<=': (False, 90), '<': (False, 90), 'goto': (False, 90), 'while': (False, 90), '(': (False, 90), '^': (True, 2003), 'do': (False, 90), '>': (False, 90), 'end': (False, 90), '==': (False, 90), '~=': (False, 90), 'function': (False, 90), '..': (True, 2006)}, {'if': (False, 87), 'goto': (False, 87), '%': (True, 1995), 'repeat': (False, 87), 'NAME': (False, 87), 'elseif': (False, 87), 'else': (False, 87), 'for': (False, 87), 'or': (False, 87), 'EMBEDSTAT': (False, 87), ';': (False, 87), 'break': (False, 87), '*': (True, 1998), '>=': (False, 87), '-': (True, 2002), '/': (True, 2005), 'local': (False, 87), '::': (False, 87), 'return': (False, 87), 'and': (False, 87), '+': (True, 1996), '<=': (False, 87), '<': (False, 87), 'function': (False, 87), 'while': (False, 87), '(': (False, 87), '^': (True, 2003), 'do': (False, 87), '>': (False, 87), 'end': (False, 87), '==': (False, 87), '~=': (False, 87), '..': (True, 2006)}, {'if': (False, 91), 'function': (False, 91), '%': (True, 1995), 'return': (False, 91), 'elseif': (False, 91), 'else': (False, 91), 'for': (False, 91), 'local': (False, 91), 'or': (False, 91), 'EMBEDSTAT': (False, 91), ';': (False, 91), 'break': (False, 91), '*': (True, 1998), '>=': (False, 91), '-': (True, 2002), '/': (True, 2005), 'repeat': (False, 91), '::': (False, 91), 'NAME': (False, 91), 'and': (False, 91), '+': (True, 1996), '<=': (False, 91), '<': (False, 91), 'goto': (False, 91), 'while': (False, 91), '(': (False, 91), '^': (True, 2003), 'do': (False, 91), '>': (False, 91), 'end': (False, 91), '==': (False, 91), '~=': (False, 91), '..': (True, 2006)}, {'if': (False, 95), 'or': (False, 95), '%': (True, 1995), 'NAME': (False, 95), 'elseif': (False, 95), 'else': (False, 95), 'for': (False, 95), 'local': (False, 95), 'EMBEDSTAT': (False, 95), ';': (False, 95), 'goto': (False, 95), 'break': (False, 95), '*': (True, 1998), '>=': (False, 95), '-': (False, 95), '/': (True, 2005), 'repeat': (False, 95), '::': (False, 95), 'return': (False, 95), 'and': (False, 95), '+': (False, 95), '<=': (False, 95), '<': (False, 95), 'function': (False, 95), 'while': (False, 95), '(': (False, 95), '^': (True, 2003), 'do': (False, 95), '>': (False, 95), 'end': (False, 95), '==': (False, 95), '~=': (False, 95), '..': (False, 95)}, {'if': (False, 99), 'or': (False, 99), '>=': (False, 99), 'repeat': (False, 99), 'NAME': (False, 99), 'elseif': (False, 99), 'else': (False, 99), 'for': (False, 99), 'EMBEDSTAT': (False, 99), ';': (False, 99), 'break': (False, 99), '*': (False, 99), '%': (False, 99), '-': (False, 99), '/': (False, 99), 'local': (False, 99), '::': (False, 99), 'return': (False, 99), 'and': (False, 99), '+': (False, 99), '<=': (False, 99), '<': (False, 99), 'goto': (False, 99), 'while': (False, 99), '(': (False, 99), '^': (True, 2003), 'do': (False, 99), '>': (False, 99), 'end': (False, 99), '==': (False, 99), '..': (False, 99), 'function': (False, 99), '~=': (False, 99)}, {'if': (False, 92), 'or': (False, 92), '%': (True, 1995), 'repeat': (False, 92), 'return': (False, 92), 'elseif': (False, 92), 'else': (False, 92), 'for': (False, 92), 'EMBEDSTAT': (False, 92), 'end': (False, 92), 'break': (False, 92), '*': (True, 1998), '>=': (False, 92), '-': (True, 2002), '/': (True, 2005), 'local': (False, 92), '::': (False, 92), 'NAME': (False, 92), 'and': (False, 92), '+': (True, 1996), '<=': (False, 92), '<': (False, 92), 'goto': (False, 92), 'while': (False, 92), '(': (False, 92), '^': (True, 2003), 'do': (False, 92), '>': (False, 92), ';': (False, 92), '==': (False, 92), '~=': (False, 92), 'function': (False, 92), '..': (True, 2006)}, {'if': (False, 97), 'function': (False, 97), '>=': (False, 97), 'repeat': (False, 97), 'return': (False, 97), 'elseif': (False, 97), 'else': (False, 97), 'for': (False, 97), 'or': (False, 97), 'EMBEDSTAT': (False, 97), ';': (False, 97), 'break': (False, 97), '*': (False, 97), '%': (False, 97), '-': (False, 97), '/': (False, 97), 'local': (False, 97), '::': (False, 97), 'NAME': (False, 97), 'and': (False, 97), '+': (False, 97), '<=': (False, 97), '<': (False, 97), 'goto': (False, 97), 'while': (False, 97), '(': (False, 97), '^': (True, 2003), 'do': (False, 97), '>': (False, 97), 'end': (False, 97), '==': (False, 97), '..': (False, 97), '~=': (False, 97)}, {'if': (False, 93), 'or': (False, 93), '%': (True, 1995), 'repeat': (False, 93), 'NAME': (False, 93), 'elseif': (False, 93), 'else': (False, 93), 'for': (False, 93), 'EMBEDSTAT': (False, 93), ';': (False, 93), 'goto': (False, 93), 'break': (False, 93), '*': (True, 1998), '>=': (False, 93), '-': (True, 2002), '/': (True, 2005), 'local': (False, 93), '::': (False, 93), 'return': (False, 93), 'and': (False, 93), '+': (True, 1996), '<=': (False, 93), '<': (False, 93), 'function': (False, 93), 'while': (False, 93), '(': (False, 93), '^': (True, 2003), 'do': (False, 93), '>': (False, 93), 'end': (False, 93), '==': (False, 93), '~=': (False, 93), '..': (True, 2006)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2064), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'::': (False, 51), 'NAME': (False, 51), 'function': (False, 51), 'if': (False, 51), 'repeat': (False, 51), 'return': (False, 51), 'elseif': (False, 51), 'else': (False, 51), 'for': (False, 51), 'goto': (False, 51), 'while': (False, 51), '(': (False, 51), 'EMBEDSTAT': (False, 51), 'end': (False, 51), 'do': (False, 51), 'break': (False, 51), ';': (False, 51), 'local': (False, 51)}, {'if': (False, 61), 'goto': (False, 61), '%': (False, 61), 'repeat': (False, 61), 'return': (False, 61), 'elseif': (False, 61), 'else': (False, 61), 'for': (False, 61), 'or': (False, 61), 'EMBEDSTAT': (False, 61), ';': (False, 61), 'break': (False, 61), '*': (False, 61), '>=': (False, 61), '-': (False, 61), '/': (False, 61), 'local': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'and': (False, 61), '+': (False, 61), ',': (False, 61), '<': (False, 61), 'function': (False, 61), 'while': (False, 61), '<=': (False, 61), '(': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), 'end': (False, 61), '==': (False, 61), '~=': (False, 61), '..': (False, 61)}, {'::': (False, 61), 'return': (False, 61), 'goto': (False, 61), 'and': (False, 61), 'if': (False, 61), '%': (False, 61), 'repeat': (False, 61), 'NAME': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), 'for': (False, 61), 'function': (False, 61), '>': (False, 61), 'while': (False, 61), 'or': (False, 61), '(': (False, 61), 'EMBEDSTAT': (False, 61), '^': (False, 61), ';': (False, 61), 'do': (False, 61), 'break': (False, 61), 'until': (False, 61), '*': (False, 61), '>=': (False, 61), '==': (False, 61), '~=': (False, 61), '-': (False, 61), '/': (False, 61), 'local': (False, 61), '..': (False, 61)}, {'end': (True, 2065)}, {'::': (False, 50), 'NAME': (False, 50), 'goto': (False, 50), 'if': (False, 50), 'return': (False, 50), 'elseif': (False, 50), 'else': (False, 50), 'for': (False, 50), 'function': (False, 50), 'local': (False, 50), 'while': (False, 50), '(': (False, 50), 'EMBEDSTAT': (False, 50), 'end': (False, 50), 'do': (False, 50), 'break': (False, 50), ';': (False, 50), 'repeat': (False, 50)}, {'if': (False, 11), '[': (False, 11), 'goto': (False, 11), '>=': (False, 11), 'repeat': (False, 11), 'return': (False, 11), 'elseif': (False, 11), 'else': (False, 11), 'for': (False, 11), 'or': (False, 11), 'EMBEDSTAT': (False, 11), 'end': (False, 11), 'break': (False, 11), '*': (False, 11), '%': (False, 11), 'STRING': (False, 11), '.': (False, 11), '{': (False, 11), '-': (False, 11), '/': (False, 11), 'local': (False, 11), '::': (False, 11), 'NAME': (False, 11), 'and': (False, 11), '+': (False, 11), '<=': (False, 11), '<': (False, 11), 'function': (False, 11), 'while': (False, 11), '(': (False, 11), '^': (False, 11), 'do': (False, 11), ':': (False, 11), '>': (False, 11), ';': (False, 11), '==': (False, 11), '~=': (False, 11), '..': (False, 11)}, {'if': (False, 4), '[': (False, 4), 'goto': (False, 4), '%': (False, 4), 'return': (False, 4), 'elseif': (False, 4), 'else': (False, 4), 'for': (False, 4), 'local': (False, 4), 'or': (False, 4), 'EMBEDSTAT': (False, 4), ';': (False, 4), 'break': (False, 4), '*': (False, 4), '>=': (False, 4), 'STRING': (False, 4), '.': (False, 4), '{': (False, 4), '-': (False, 4), '/': (False, 4), 'repeat': (False, 4), '::': (False, 4), 'NAME': (False, 4), 'and': (False, 4), '+': (False, 4), '<=': (False, 4), '<': (False, 4), 'function': (False, 4), 'while': (False, 4), '(': (False, 4), '^': (False, 4), 'do': (False, 4), ':': (False, 4), '>': (False, 4), 'end': (False, 4), '==': (False, 4), '..': (False, 4), '~=': (False, 4)}, {'if': (False, 108), '[': (False, 108), 'function': (False, 108), '%': (False, 108), 'repeat': (False, 108), 'NAME': (False, 108), 'elseif': (False, 108), 'else': (False, 108), 'for': (False, 108), 'or': (False, 108), 'EMBEDSTAT': (False, 108), ';': (False, 108), 'break': (False, 108), '*': (False, 108), '>=': (False, 108), 'STRING': (False, 108), '.': (False, 108), '{': (False, 108), '-': (False, 108), '/': (False, 108), 'local': (False, 108), '::': (False, 108), 'return': (False, 108), 'and': (False, 108), '+': (False, 108), '<=': (False, 108), '<': (False, 108), 'goto': (False, 108), 'while': (False, 108), '(': (False, 108), '^': (False, 108), 'do': (False, 108), ':': (False, 108), '>': (False, 108), 'end': (False, 108), '==': (False, 108), '~=': (False, 108), '..': (False, 108)}, {'::': (True, 92), 'varlist': (True, 93), 'repeat': (True, 94), 'function': (True, 95), 'if': (True, 96), 'NAME': (True, 6), 'prefixexp': (True, 97), 'return': (False, 63), 'for': (True, 98), 'goto': (True, 99), 'label': (True, 100), 'while': (True, 101), 'EMBEDSTAT': (True, 102), 'var': (True, 13), '(': (True, 14), 'stat': (True, 103), 'block': (True, 2070), 'end': (False, 63), 'do': (True, 105), 'break': (True, 106), ';': (True, 107), 'block__1': (True, 108), 'local': (True, 109), 'functioncall': (True, 110)}, {'end': (True, 2071)}, {'if': (False, 61), 'goto': (False, 61), '%': (False, 61), 'repeat': (False, 61), 'return': (False, 61), 'elseif': (False, 61), 'else': (False, 61), 'for': (False, 61), 'or': (False, 61), 'EMBEDSTAT': (False, 61), ';': (False, 61), 'break': (False, 61), '*': (False, 61), '>=': (False, 61), '-': (False, 61), '/': (False, 61), 'local': (False, 61), '::': (False, 61), 'NAME': (False, 61), 'and': (False, 61), '+': (False, 61), '<=': (False, 61), '<': (False, 61), 'function': (False, 61), 'while': (False, 61), '(': (False, 61), '^': (False, 61), 'do': (False, 61), '>': (False, 61), 'end': (False, 61), '==': (False, 61), '~=': (False, 61), '..': (False, 61)}]
