/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import org.jgroups.util.Util;

public class MyCanvas
extends JPanel
implements MouseInputListener {
    public final int xSize = 1024;
    public final int ySize = 768;
    public BufferedImage image;
    private Comm comm;
    private Point cursor = new Point(0, 0);
    public boolean observer = true;
    private boolean draw = true;
    Tool[] tools;
    Tool drawTool;
    public MainFrame hostWindow;
    public ChatFrame chatFrame;

    public void drawObject(Tool t) {
        if (t.isDrawable()) {
            t.draw(this.image.getGraphics());
        } else {
            this.chatFrame.messageReceived((ChatMessage)t);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.drawImage(this.image, 0, 0, this);
        this.drawTool.drawPreview(g);
    }

    public MyCanvas(Comm c, boolean observer) {
        this.image = new BufferedImage(1024, 768, 2);
        Graphics g = this.image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 1024, 768);
        this.comm = c;
        this.setPreferredSize(new Dimension(1024, 768));
        if (!observer) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.tools = this.createTools();
        this.drawTool = this.tools[0];
        this.chatFrame = new ChatFrame(this);
    }

    public MyCanvas(Comm c, MainFrame f, boolean observing) {
        this(c, observing);
        this.observer = observing;
        this.hostWindow = f;
    }

    public MyCanvas(GraphicsConfiguration arg0) {
    }

    public void setToolColor(Color c) {
        int i = 0;
        while (i < this.tools.length) {
            this.tools[i].setColor(c);
            ++i;
        }
    }

    public void setToolBgColor(Color c) {
        int i = 0;
        while (i < this.tools.length) {
            this.tools[i].setBgColor(c);
            ++i;
        }
    }

    public void setDrawTool(int i) {
        this.tools[i].setColor((Color)this.drawTool.colors.get(0));
        this.drawTool = this.tools[i];
    }

    public int toolsNumber() {
        return this.tools.length;
    }

    public Tool[] createTools() {
        Tool[] tools = new Tool[]{new WaterBrush(), new Pencil(), new FeltTipPen(), new InkPen(), new SimplePen(), new SimpleLine(), new SimpleRectangle(), new SimpleEllipse(), new SimpleRotRectangle(), new SimpleRotEllipse(), new Eraser(), new Text(), new Stamp()};
        return tools;
    }

    public void sendTool(Tool t) {
        try {
            this.comm.send(Util.objectToByteBuffer((Object)t));
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.draw) {
            this.drawTool.addPoint(new Point(e.getX(), e.getY()));
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.draw = false;
        } else {
            this.draw = true;
            this.drawTool.addPoint(new Point(e.getX(), e.getY()));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.drawTool.points.size() == 1) {
            this.drawTool.addPoint(new Point(e.getX(), e.getY()));
        }
        if (this.draw) {
            this.sendTool(this.drawTool);
        } else {
            this.repaint();
        }
        this.drawTool.clearPoints();
    }
}

