/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Pencil
extends Tool {
    public final boolean drawable = true;
    final int xSize = 1024;
    final int ySize = 768;
    public float width = 2.0f;
    public float hardness = 0.8f;
    private static final long serialVersionUID = 11L;

    public Pencil() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.DARK_GRAY);
        this.colors.add(Color.blue);
    }

    public Pencil(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(c);
        this.colors.add(Color.blue);
    }

    public void draw(Graphics g2) {
        BufferedImage buf = new BufferedImage(1024, 768, 2);
        Graphics2D g = (Graphics2D)buf.getGraphics();
        g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g.fillRect(0, 0, 1024, 768);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.width, 0, 2, 1.0f);
        g.setStroke(thindashed);
        g.setColor((Color)this.colors.get(0));
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < this.points.size() - 1) {
            gp.append(new Line2D.Float((Point)this.points.get(i), (Point)this.points.get(i + 1)), true);
            ++i;
        }
        g.draw(gp);
        BufferedImage noise = new BufferedImage(1024, 768, 2);
        int i2 = 0;
        while (i2 < 1024) {
            int j = 0;
            while (j < 768) {
                if (buf.getRGB(i2, j) != 0) {
                    int tmp = buf.getRGB(i2, j);
                    Color c = new Color(tmp, true);
                    int R = c.getRed();
                    int G = c.getGreen();
                    int B = c.getBlue();
                    float rate = (float)Math.random() * this.hardness + (1.0f - this.hardness);
                    int A = Math.round((float)c.getAlpha() * rate);
                    Color c2 = new Color(R, G, B, A);
                    buf.setRGB(i2, j, c2.getRGB());
                }
                ++j;
            }
            ++i2;
        }
        float cent = 0.9f;
        float sur = (1.0f - cent) / 24.0f;
        ConvolveOp Op = new ConvolveOp(new Kernel(5, 5, new float[]{sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, cent, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur}));
        buf = Op.filter(buf, null);
        g2.drawImage(buf, 0, 0, null);
    }

    public void setColor(Color c) {
        this.colors.set(0, new Color(c.getRed(), c.getGreen(), c.getBlue(), 255));
    }

    public void drawPreview(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BasicStroke thindashed = new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
        g.setColor(Color.GRAY);
        int i = 0;
        while (i < this.points.size() - 1) {
            g.drawLine(((Point)this.points.get((int)i)).x, ((Point)this.points.get((int)i)).y, ((Point)this.points.get((int)(i + 1))).x, ((Point)this.points.get((int)(i + 1))).y);
            ++i;
        }
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Set width"));
        JSlider widthSlider = new JSlider(0, 50, 800, 200);
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Pencil.this.width = (float)((JSlider)e.getSource()).getValue() / 100.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Hardness"));
        JSlider hardSlider = new JSlider(0, 50, 100, 80);
        hardSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Pencil.this.hardness = (float)((JSlider)e.getSource()).getValue() / 100.0f;
            }
        });
        hardSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(hardSlider);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

