/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleRotEllipse
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 25L;
    public float width = 2.0f;
    public int alpha = 255;
    public int bgAlpha = 0;

    public SimpleRotEllipse() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), this.bgAlpha));
    }

    public SimpleRotEllipse(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), this.bgAlpha));
    }

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.width, 2, 1, 10.0f);
        g.setStroke(thindashed);
        AffineTransform at = new AffineTransform();
        at.setToRotation(this.angle);
        AffineTransform at2 = new AffineTransform();
        at2.setToRotation(-this.angle);
        Point p0 = (Point)this.points.firstElement();
        Point p1 = (Point)this.points.lastElement();
        int x = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().x;
        int y = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().y;
        int x1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().x;
        int y1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().y;
        int w = x1 - x;
        int h = y1 - y;
        if (w < 0) {
            x += w;
            w = Math.abs(w);
        }
        if (h < 0) {
            y += h;
            h = Math.abs(h);
        }
        g.setTransform(at);
        g.setColor((Color)this.colors.get(1));
        g.fillOval(x, y, w, h);
        g.setColor((Color)this.colors.get(0));
        g.drawOval(x, y, w, h);
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void setBgColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.bgAlpha);
        this.colors.set(1, cc);
    }

    public void drawPreview(Graphics g1) {
        if (this.points.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        AffineTransform at = new AffineTransform();
        at.setToRotation(this.angle);
        AffineTransform at2 = new AffineTransform();
        at2.setToRotation(-this.angle);
        g.setColor(Color.GRAY);
        Point p0 = (Point)this.points.firstElement();
        Point p1 = (Point)this.points.lastElement();
        int x = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().x;
        int y = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().y;
        int x1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().x;
        int y1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().y;
        int w = x1 - x;
        int h = y1 - y;
        if (w < 0) {
            x += w;
            w = Math.abs(w);
        }
        if (h < 0) {
            y += h;
            h = Math.abs(h);
        }
        g.setTransform(at);
        g.drawOval(x, y, w, h);
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Line width"));
        JSlider widthSlider = new JSlider(0, 0, 100, Math.round(this.width * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleRotEllipse.this.width = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Edge opacity"));
        JSlider alphaSlider = new JSlider(0, 0, 255, this.alpha);
        alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleRotEllipse.this.alpha = ((JSlider)e.getSource()).getValue();
                SimpleRotEllipse.this.setColor((Color)SimpleRotEllipse.this.colors.get(0));
            }
        });
        alphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(alphaSlider);
        panel.add(new JLabel("Interior opacity"));
        JSlider bgAlphaSlider = new JSlider(0, 0, 255, this.bgAlpha);
        bgAlphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleRotEllipse.this.bgAlpha = ((JSlider)e.getSource()).getValue();
                SimpleRotEllipse.this.setBgColor((Color)SimpleRotEllipse.this.colors.get(1));
            }
        });
        bgAlphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(bgAlphaSlider);
        panel.add(new JLabel("Orientation"));
        AngleChooser angleChooser = new AngleChooser(this, this.angle);
        panel.add(angleChooser);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

