/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Text
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 30L;
    private String textMsg = "text";
    public float size = 2.0f;
    public int alpha = 255;

    public Text() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(Color.blue);
    }

    public Text(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(Color.blue);
    }

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor((Color)this.colors.get(0));
        AffineTransform at = new AffineTransform();
        if (this.points.size() > 0) {
            at.translate(((Point)this.points.lastElement()).x, ((Point)this.points.lastElement()).y);
        }
        at.scale(this.size, this.size);
        at.rotate(this.angle);
        g.setTransform(at);
        if (this.points.size() > 0) {
            g.drawBytes(this.textMsg.getBytes(), 0, this.textMsg.length(), 0, 0);
        }
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void drawPreview(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setColor(Color.GRAY);
        AffineTransform at = new AffineTransform();
        if (this.points.size() > 0) {
            at.translate(((Point)this.points.lastElement()).x, ((Point)this.points.lastElement()).y);
        }
        at.scale(this.size, this.size);
        at.rotate(this.angle);
        g.setTransform(at);
        if (this.points.size() > 0) {
            g.drawBytes(this.textMsg.getBytes(), 0, this.textMsg.length(), 0, 0);
        }
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Enter text:"));
        JTextField textField = new JTextField(this.textMsg, 7){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Text.this.textMsg = this.getText();
                    }
                });
                this.addCaretListener(new CaretListener(){

                    public void caretUpdate(CaretEvent e) {
                        Text.this.textMsg = this.getText();
                    }
                });
            }
        };
        panel.add(textField);
        panel.add(new JLabel("Orientation"));
        AngleChooser angleChooser = new AngleChooser(this, this.angle);
        panel.add(angleChooser);
        panel.add(new JLabel("Text size"));
        JSlider widthSlider = new JSlider(0, 1, 100, Math.round(this.size * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Text.this.size = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Opacity"));
        JSlider alphaSlider = new JSlider(0, 0, 255, this.alpha);
        alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Text.this.alpha = ((JSlider)e.getSource()).getValue();
                Text.this.setColor((Color)Text.this.colors.get(0));
            }
        });
        alphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(alphaSlider);
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

