/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WaterBrush
extends Tool {
    private static final long serialVersionUID = 10L;
    public float width = 20.0f;
    public float wetness = 0.5f;
    public int hair = 50;
    public int colorAmount = 30;
    public int[] brushX;
    public int[] brushY;
    final int xSize = 1024;
    final int ySize = 768;

    public WaterBrush() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(new Color(0.0f, 0.0f, 1.0f, 0.2f));
        this.colors.add(Color.blue);
    }

    public WaterBrush(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(new Color(c.getRed(), c.getGreen(), c.getBlue(), this.colorAmount));
        this.colors.add(Color.blue);
    }

    private void generateBrush() {
        float radius = this.width / 2.0f;
        this.brushX = new int[this.hair];
        this.brushY = new int[this.hair];
        int i = 0;
        while (i < this.hair) {
            double angle = Math.random() * 2.0 * Math.PI;
            double distance = Math.sqrt(Math.random()) * (double)radius;
            this.brushX[i] = (int)Math.round(Math.sin(angle) * distance);
            this.brushY[i] = (int)Math.round(Math.cos(angle) * distance);
            ++i;
        }
    }

    public void draw(Graphics g1) {
        int j;
        Graphics2D g2 = (Graphics2D)g1;
        float sur = (1.0f - 0.8f * (1.0f - this.wetness)) / 24.0f;
        float cent = 0.8f * (1.0f - this.wetness);
        ConvolveOp Op = new ConvolveOp(new Kernel(5, 5, new float[]{sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, cent, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur, sur}));
        BufferedImage buf = new BufferedImage(1024, 768, 2);
        Graphics2D g = (Graphics2D)buf.getGraphics();
        Color cc = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        int i = 0;
        while (i < 1024) {
            j = 0;
            while (j < 768) {
                buf.setRGB(i, j, cc.getRGB());
                ++j;
            }
            ++i;
        }
        BasicStroke thindashed = new BasicStroke(1.0f, 0, 2, 4.0f);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(thindashed);
        g.setColor((Color)this.colors.get(0));
        this.generateBrush();
        j = 0;
        while (j < this.hair) {
            GeneralPath gp = new GeneralPath();
            int i2 = 0;
            while (i2 < this.points.size() - 1) {
                gp.append(new Line2D.Float(new Point(((Point)this.points.get((int)i2)).x + this.brushX[j], ((Point)this.points.get((int)i2)).y + this.brushY[j]), new Point(((Point)this.points.get((int)(i2 + 1))).x + this.brushX[j], ((Point)this.points.get((int)(i2 + 1))).y + this.brushY[j])), true);
                ++i2;
            }
            g.draw(gp);
            ++j;
        }
        buf = Op.filter(buf, null);
        buf = Op.filter(buf, null);
        buf = Op.filter(buf, null);
        g2.drawImage(buf, 0, 0, 1024, 768, null);
    }

    public void setColor(Color c) {
        this.colors.set(0, new Color(c.getRed(), c.getGreen(), c.getBlue(), this.colorAmount));
    }

    public void drawPreview(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BasicStroke thindashed = new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
        g.setColor(Color.GRAY);
        int i = 0;
        while (i < this.points.size() - 1) {
            Line2D.Float l = new Line2D.Float(((Point)this.points.get((int)i)).x, ((Point)this.points.get((int)i)).y, ((Point)this.points.get((int)(i + 1))).x, ((Point)this.points.get((int)(i + 1))).y);
            g.drawLine(((Point)this.points.get((int)i)).x, ((Point)this.points.get((int)i)).y, ((Point)this.points.get((int)(i + 1))).x, ((Point)this.points.get((int)(i + 1))).y);
            ++i;
        }
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Set width"));
        JSlider widthSlider = new JSlider(0, 2, 30, Math.round(this.width));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WaterBrush.this.width = ((JSlider)e.getSource()).getValue();
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Hair amount"));
        JSlider hairSlider = new JSlider(0, 15, 100, this.hair);
        hairSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WaterBrush.this.hair = ((JSlider)e.getSource()).getValue();
            }
        });
        hairSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(hairSlider);
        panel.add(new JLabel("Wetness"));
        JSlider wetnessSlider = new JSlider(0, 0, 100, Math.round(this.wetness * 100.0f));
        wetnessSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WaterBrush.this.wetness = (float)((JSlider)e.getSource()).getValue() / 100.0f;
            }
        });
        wetnessSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(wetnessSlider);
        panel.add(new JLabel("Color amount"));
        JSlider colorAmountSlider = new JSlider(0, 0, 120, this.colorAmount);
        colorAmountSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WaterBrush.this.colorAmount = ((JSlider)e.getSource()).getValue();
                WaterBrush.this.setColor((Color)WaterBrush.this.colors.get(0));
            }
        });
        colorAmountSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(colorAmountSlider);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

