/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.TimeoutException;
import org.jgroups.blocks.RpcDispatcher;

public class RpcDispatcherUnicastMethodExceptionTest
extends TestCase {
    RpcDispatcher disp;
    JChannel channel;

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel();
        this.disp = new RpcDispatcher((Channel)this.channel, null, null, (Object)this);
        this.channel.connect("demo");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.disp.stop();
        this.channel.close();
    }

    public Object foo() {
        System.out.println("-- foo()");
        return "foo(): OK";
    }

    public Object bar() throws Exception {
        System.out.println("-- bar()");
        throw new TimeoutException("this is an exception");
    }

    public Object foobar() {
        System.out.println("-- foobar()");
        throw new IllegalArgumentException("bla bla bla from foobar");
    }

    public Object foofoobar() {
        System.out.println("-- foofoobar()");
        throw new AssertionError((Object)"bla bla bla from foofoobar");
    }

    public void fooWithThrowable() throws Throwable {
        System.out.println("-- fooWithThrowable()");
        throw new Throwable("this is an exception");
    }

    public void testMethodWithoutException() throws Throwable {
        Object retval = this.disp.callRemoteMethod(this.channel.getLocalAddress(), "foo", null, (Class[])null, 2, 5000L);
        System.out.println("retval: " + retval);
        RpcDispatcherUnicastMethodExceptionTest.assertNotNull((Object)retval);
    }

    public void testMethodWithException() throws ChannelException {
        try {
            Object retval = this.disp.callRemoteMethod(this.channel.getLocalAddress(), "bar", null, (Class[])null, 2, 5000L);
            System.out.println("retval: " + retval);
            RpcDispatcherUnicastMethodExceptionTest.fail((String)"we should not get here; bar() should throw an exception");
        }
        catch (Throwable e) {
            System.out.println("caught exception (" + e + ") - as expected");
            RpcDispatcherUnicastMethodExceptionTest.assertTrue((boolean)(e instanceof TimeoutException));
        }
    }

    public void testMethodWithException2() throws ChannelException {
        try {
            Object retval = this.disp.callRemoteMethod(this.channel.getLocalAddress(), "foobar", null, (Class[])null, 2, 5000L);
            System.out.println("retval: " + retval);
            RpcDispatcherUnicastMethodExceptionTest.fail((String)"we should not get here; foobar() should throw an exception");
        }
        catch (Throwable e) {
            System.out.println("caught exception (" + e + ") - as expected");
            RpcDispatcherUnicastMethodExceptionTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    public void testMethodWithError() throws ChannelException {
        try {
            Object retval = this.disp.callRemoteMethod(this.channel.getLocalAddress(), "foofoobar", null, (Class[])null, 2, 5000L);
            System.out.println("retval: " + retval);
            RpcDispatcherUnicastMethodExceptionTest.fail((String)"we should not get here; foofoobar() should throw an exception");
        }
        catch (Throwable e) {
            System.out.println("caught exception (" + e + ") - as expected");
            RpcDispatcherUnicastMethodExceptionTest.assertTrue((boolean)(e instanceof AssertionError));
        }
    }

    public void testMethodWithThrowable() throws ChannelException {
        try {
            Object retval = this.disp.callRemoteMethod(this.channel.getLocalAddress(), "fooWithThrowable", null, (Class[])null, 2, 5000L);
            System.out.println("retval: " + retval);
            RpcDispatcherUnicastMethodExceptionTest.fail((String)"we should not get here; foofoobar() should throw an exception");
        }
        catch (Throwable e) {
            System.out.println("caught exception (" + e + ") - as expected");
            RpcDispatcherUnicastMethodExceptionTest.assertTrue((boolean)(e instanceof Throwable));
        }
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherUnicastMethodExceptionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherUnicastMethodExceptionTest.suite());
    }
}

