/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;

public class DisconnectStressTest
extends TestCase {
    static CyclicBarrier all_disconnected = null;
    static CyclicBarrier start_disconnecting = null;
    static final int NUM = 30;
    static final long TIMEOUT = 50000L;
    static final MyThread[] threads = new MyThread[30];
    static String groupname = "ConcurrentTestDemo";
    static String props = "UDP(mcast_addr=228.8.8.9;mcast_port=7788;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=3000;num_initial_members=3):MERGE2(min_interval=3000;max_interval=5000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400):pbcast.STABLE(desired_avg_gossip=5000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=false;view_ack_collection_timeout=5000;digest_timeout=0;merge_timeout=30000;handle_concurrent_startup=true)";

    public DisconnectStressTest(String name) {
        super(name);
    }

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStartupAndMerging() throws Exception {
        all_disconnected = new CyclicBarrier(31);
        start_disconnecting = new CyclicBarrier(31);
        for (int i = 0; i < threads.length; ++i) {
            DisconnectStressTest.threads[i] = new MyThread(i);
            MyThread myThread = threads[i];
            synchronized (myThread) {
                threads[i].start();
                threads[i].wait(20000L);
                continue;
            }
        }
        DisconnectStressTest.log("DISCONNECTING");
        start_disconnecting.barrier();
        all_disconnected.barrier();
    }

    public static Test suite() {
        return new TestSuite(DisconnectStressTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{DisconnectStressTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static class MyThread
    extends Thread {
        int index = -1;
        long total_connect_time = 0L;
        long total_disconnect_time = 0L;
        private JChannel ch = null;
        private Address my_addr = null;

        public MyThread(int i) {
            super("thread #" + i);
            this.index = i;
        }

        public void closeChannel() {
            if (this.ch != null) {
                this.ch.close();
            }
        }

        public int numMembers() {
            return this.ch.getView().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.ch = new JChannel(props);
                DisconnectStressTest.log("connecting to channel");
                long start = System.currentTimeMillis();
                this.ch.connect(groupname);
                long stop = System.currentTimeMillis();
                MyThread myThread = this;
                synchronized (myThread) {
                    this.notify();
                }
                this.total_connect_time = stop - start;
                View view = this.ch.getView();
                this.my_addr = this.ch.getLocalAddress();
                DisconnectStressTest.log(this.my_addr + " connected in " + this.total_connect_time + " msecs (" + view.getMembers().size() + " members). VID=" + this.ch.getView());
                start_disconnecting.barrier();
                start = System.currentTimeMillis();
                this.ch.disconnect();
                stop = System.currentTimeMillis();
                DisconnectStressTest.log(this.my_addr + " disconnected in " + (stop - start) + " msecs");
                all_disconnected.barrier();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

