/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FlushTest
extends TestCase {
    Channel c1;
    Channel c2;
    Channel c3;
    static final String CONFIG = "flush-udp.xml";

    public FlushTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.c3 != null) {
            this.c3.close();
            FlushTest.assertFalse((boolean)this.c3.isOpen());
            FlushTest.assertFalse((boolean)this.c3.isConnected());
            this.c3 = null;
        }
        if (this.c2 != null) {
            this.c2.close();
            FlushTest.assertFalse((boolean)this.c2.isOpen());
            FlushTest.assertFalse((boolean)this.c2.isConnected());
            this.c2 = null;
        }
        if (this.c1 != null) {
            this.c1.close();
            FlushTest.assertFalse((boolean)this.c1.isOpen());
            FlushTest.assertFalse((boolean)this.c1.isConnected());
            this.c1 = null;
        }
        Util.sleep(1000L);
    }

    public void testSingleChannel() throws ChannelException {
        this.c1 = this.createChannel();
        MyReceiver receiver = new MyReceiver("c1");
        this.c1.setReceiver(receiver);
        this.c1.connect("bla");
        this.checkEventSequence(receiver);
    }

    public void testJoinFollowedByUnicast() throws ChannelException {
        this.c1 = this.createChannel();
        this.c1.setReceiver(new MySimpleReplier(this.c1, true));
        this.c1.connect("bla");
        Address target = this.c1.getLocalAddress();
        Message unicast_msg = new Message(target);
        this.c2 = this.createChannel();
        this.c2.setReceiver(new MySimpleReplier(this.c2, false));
        this.c2.connect("bla");
        this.c2.send(unicast_msg);
    }

    public void testStateTransferFollowedByUnicast() throws ChannelException {
        this.c1 = this.createChannel();
        this.c1.setReceiver(new MySimpleReplier(this.c1, true));
        this.c1.connect("bla");
        Address target = this.c1.getLocalAddress();
        Message unicast_msg = new Message(target);
        this.c2 = this.createChannel();
        this.c2.setReceiver(new MySimpleReplier(this.c2, false));
        this.c2.connect("bla");
        System.out.println("\n** Getting the state **");
        this.c2.getState(null, 10000L);
        this.c2.send(unicast_msg);
    }

    public void testTwoChannelsWithMessages() throws ChannelException {
        this.twoChannelsTestHelper(true);
    }

    public void testTwoChannelsNoMessages() throws ChannelException {
        this.twoChannelsTestHelper(false);
    }

    public void testThreeChannelsWithMessages() throws ChannelException {
        this.threeChannelsTestHelper(true);
    }

    public void testThreeChannelsNoMessages() throws ChannelException {
        this.threeChannelsTestHelper(false);
    }

    public void testStateTransferWithMessages() throws ChannelException {
        this.stateTransferTestHelper(true);
    }

    public void testStateTransferNoMessages() throws ChannelException {
        this.stateTransferTestHelper(false);
    }

    private void twoChannelsTestHelper(boolean sendMessages) throws ChannelException {
        this.c1 = this.createChannel();
        MyReceiver receiver = new MyReceiver("c1");
        this.c1.setReceiver(receiver);
        this.c1.connect("bla");
        if (sendMessages) {
            this.c1.send(new Message());
        }
        this.c2 = this.createChannel();
        MyReceiver receiver2 = new MyReceiver("c2");
        this.c2.setReceiver(receiver2);
        this.c2.connect("bla");
        View view = this.c2.getView();
        FlushTest.assertEquals((int)2, (int)view.size());
        if (sendMessages) {
            this.c1.send(new Message());
            this.c2.send(new Message());
        }
        this.checkEventSequence(receiver2);
        this.c2.close();
        if (sendMessages) {
            this.c1.send(new Message());
        }
        this.checkEventSequence(receiver);
    }

    private void threeChannelsTestHelper(boolean sendMessages) throws ChannelException {
        this.c1 = this.createChannel();
        MyReceiver receiver = new MyReceiver("c1");
        this.c1.setReceiver(receiver);
        this.c1.connect("bla");
        if (sendMessages) {
            this.c1.send(new Message());
        }
        this.c2 = this.createChannel();
        MyReceiver receiver2 = new MyReceiver("c2");
        this.c2.setReceiver(receiver2);
        this.c2.connect("bla");
        View view = this.c2.getView();
        FlushTest.assertEquals((int)2, (int)view.size());
        if (sendMessages) {
            this.c1.send(new Message());
            this.c2.send(new Message());
        }
        this.c3 = this.createChannel();
        MyReceiver receiver3 = new MyReceiver("c3");
        this.c3.setReceiver(receiver3);
        this.c3.connect("bla");
        view = this.c3.getView();
        FlushTest.assertEquals((int)3, (int)view.size());
        if (sendMessages) {
            this.c1.send(new Message());
            this.c2.send(new Message());
            this.c3.send(new Message());
        }
        this.checkEventSequence(receiver);
        this.c1.close();
        if (sendMessages) {
            this.c2.send(new Message());
            this.c2.send(new Message());
        }
        this.checkEventSequence(receiver2);
        this.c2.close();
        this.checkEventSequence(receiver3);
    }

    private void stateTransferTestHelper(boolean sendMessages) throws ChannelException {
        this.c1 = this.createChannel();
        MyReceiver receiver = new MyReceiver(this.c1, "c1");
        this.c1.setReceiver(receiver);
        this.c1.connect("bla");
        if (sendMessages) {
            this.c1.send(new Message());
            this.c1.send(new Message());
        }
        this.c2 = this.createChannel();
        MyReceiver receiver2 = new MyReceiver(this.c2, "c2");
        this.c2.setReceiver(receiver2);
        this.c2.connect("bla");
        this.c3 = this.createChannel();
        MyReceiver receiver3 = new MyReceiver(this.c3, "c3");
        this.c3.setReceiver(receiver3);
        this.c3.connect("bla");
        if (sendMessages) {
            this.c1.send(new Message());
            this.c2.send(new Message());
        }
        if (sendMessages) {
            this.c1.send(new Message());
            this.c2.send(new Message());
            this.c3.send(new Message());
        }
        this.checkEventSequence(receiver);
        this.checkEventSequence(receiver2);
        this.checkEventSequence(receiver3);
        System.out.println("=== fetching the state ====");
        this.c2.getState(null, 10000L);
        if (sendMessages) {
            this.c1.send(new Message());
            this.c1.send(new Message());
            this.c2.send(new Message());
            this.c2.send(new Message());
        }
        this.checkNonStateTransferMemberSequence(receiver3);
        this.checkBlockStateUnBlockSequence(receiver);
        this.checkBlockStateUnBlockSequence(receiver2);
        this.c2.close();
        this.c2 = null;
        this.c2 = this.createChannel();
        receiver2 = new MyReceiver(this.c2, "c2");
        this.c2.setReceiver(receiver2);
        this.c2.connect("bla");
        if (sendMessages) {
            this.c1.send(new Message());
        }
        this.checkEventSequence(receiver);
        this.checkEventSequence(receiver2);
        this.checkEventSequence(receiver3);
        System.out.println("=== fetching the state ====");
        this.c3.getState(null, 10000L);
        if (sendMessages) {
            this.c1.send(new Message());
            this.c2.send(new Message());
        }
        this.checkNonStateTransferMemberSequence(receiver2);
        this.checkBlockStateUnBlockSequence(receiver);
        this.checkBlockStateUnBlockSequence(receiver3);
    }

    private void checkBlockStateUnBlockSequence(MyReceiver receiver) {
        List events = receiver.getEvents();
        String name = receiver.getName();
        FlushTest.assertNotNull((Object)events);
        FlushTest.assertEquals((String)("Should have three events [block,get|setstate,unblock] but " + name + " has " + events), (int)3, (int)events.size());
        Object obj = events.remove(0);
        FlushTest.assertTrue((String)name, (boolean)(obj instanceof BlockEvent));
        obj = events.remove(0);
        FlushTest.assertTrue((String)name, (obj instanceof GetStateEvent || obj instanceof SetStateEvent ? 1 : 0) != 0);
        obj = events.remove(0);
        FlushTest.assertTrue((String)name, (boolean)(obj instanceof UnblockEvent));
        receiver.clear();
    }

    private void checkEventSequence(MyReceiver receiver) {
        List events = receiver.getEvents();
        String eventString = "[" + receiver.getName() + ",events:" + events;
        FlushTest.assertNotNull((Object)events);
        int size = events.size();
        for (int i = 0; i < size; ++i) {
            Object event = events.get(i);
            if (event instanceof BlockEvent) {
                if (i + 1 < size) {
                    FlushTest.assertTrue((String)("After Block should be View " + eventString), (boolean)(events.get(i + 1) instanceof View));
                }
                if (i != 0) {
                    FlushTest.assertTrue((String)("Before Block should be Unblock " + eventString), (boolean)(events.get(i - 1) instanceof UnblockEvent));
                }
            }
            if (event instanceof View) {
                if (i + 1 < size) {
                    FlushTest.assertTrue((String)("After View should be Unblock " + eventString), (boolean)(events.get(i + 1) instanceof UnblockEvent));
                }
                FlushTest.assertTrue((String)("Before View should be Block " + eventString), (boolean)(events.get(i - 1) instanceof BlockEvent));
            }
            if (!(event instanceof UnblockEvent)) continue;
            if (i + 1 < size) {
                FlushTest.assertTrue((String)("After UnBlock should be Block " + eventString), (boolean)(events.get(i + 1) instanceof BlockEvent));
            }
            FlushTest.assertTrue((String)("Before UnBlock should be View " + eventString), (boolean)(events.get(i - 1) instanceof View));
        }
        receiver.clear();
    }

    private void checkNonStateTransferMemberSequence(MyReceiver receiver) {
        List events = receiver.getEvents();
        FlushTest.assertNotNull((Object)events);
        FlushTest.assertEquals((String)("Should have two events [block,unblock] but " + receiver.getName() + " has " + events), (int)2, (int)events.size());
        Object obj = events.remove(0);
        FlushTest.assertTrue((boolean)(obj instanceof BlockEvent));
        obj = events.remove(0);
        FlushTest.assertTrue((boolean)(obj instanceof UnblockEvent));
        receiver.clear();
    }

    private Channel createChannel() throws ChannelException {
        JChannel ret = new JChannel(CONFIG);
        ((Channel)ret).setOpt(0, Boolean.TRUE);
        Protocol flush = ret.getProtocolStack().findProtocol("FLUSH");
        if (flush != null) {
            Properties p = new Properties();
            p.setProperty("timeout", "0");
            flush.setProperties(p);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("flush_timeout", new Long(0L));
            flush.passUp(new Event(56, map));
            flush.passDown(new Event(56, map));
        }
        return ret;
    }

    public static Test suite() {
        return new TestSuite(FlushTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FlushTest.suite());
    }

    private static class MySimpleReplier
    extends ExtendedReceiverAdapter {
        Channel channel;
        boolean handle_requests = false;

        public MySimpleReplier(Channel channel, boolean handle_requests) {
            this.channel = channel;
            this.handle_requests = handle_requests;
        }

        public void receive(Message msg) {
            Message reply = new Message(msg.getSrc());
            try {
                System.out.print("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: received message from " + msg.getSrc());
                if (this.handle_requests) {
                    System.out.println(", sending reply");
                    this.channel.send(reply);
                } else {
                    System.out.println("\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void viewAccepted(View new_view) {
            System.out.println("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: viewAccepted(" + new_view + ")");
        }

        public void block() {
            System.out.println("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: block()");
        }

        public void unblock() {
            System.out.println("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: unblock()");
        }
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        List events;
        String name;
        boolean verbose = true;
        Channel channel = null;

        public MyReceiver(Channel ch, String name) {
            this.name = name;
            this.channel = ch;
            this.events = Collections.synchronizedList(new LinkedList());
        }

        public MyReceiver(String name) {
            this.name = name;
            this.events = Collections.synchronizedList(new LinkedList());
        }

        public String getLocalAddress() {
            String address = "";
            if (this.channel != null) {
                address = this.channel.getLocalAddress().toString();
            }
            return address;
        }

        public String getName() {
            return this.name;
        }

        public void clear() {
            this.events.clear();
        }

        public List getEvents() {
            return new LinkedList(this.events);
        }

        public void block() {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: BLOCK");
            }
            this.events.add(new BlockEvent());
        }

        public void unblock() {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: UNBLOCK");
            }
            this.events.add(new UnblockEvent());
        }

        public void viewAccepted(View new_view) {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: " + new_view);
            }
            this.events.add(new_view);
        }

        public byte[] getState() {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: GetStateEvent");
            }
            this.events.add(new GetStateEvent(null, null));
            return new byte[]{98, 101, 108, 97};
        }

        public void setState(byte[] state) {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: SetStateEvent");
            }
            this.events.add(new SetStateEvent(null, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: GetStateEvent streamed");
            }
            this.events.add(new GetStateEvent(null, null));
            byte[] payload = new byte[]{98, 101, 108, 97};
            try {
                ostream.write(payload);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Util.close(ostream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            if (this.verbose) {
                System.out.println("[" + this.name + ":" + this.getLocalAddress() + "]: SetStateEvent streamed");
            }
            this.events.add(new SetStateEvent(null, null));
            byte[] payload = new byte[4];
            try {
                istream.read(payload);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Util.close(istream);
            }
        }
    }
}

