import java.awt.Point;
import java.util.Vector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.BasicStroke;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import java.awt.Dimension;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.BoxLayout;

/**
 * @author Milan Ruzicka
 *
 */

public class Eraser extends Tool {
	public final boolean drawable = true;
	private static final long serialVersionUID = 20L; 
	
	public float width = 9.0f;
	public int alpha = 255;
	
	public Eraser() {
		points = new Vector();
		colors = new Vector();
		
		colors.add(Color.blue);
		colors.add(Color.blue);
	}
	
	public Eraser(Color c) {
		points = new Vector();
		colors = new Vector();
		
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),alpha);
		colors.add(cc);
		colors.add(Color.blue);
	}

	/* (non-Javadoc)
	 * @see Tool#draw(java.awt.Image)
	 */
	@Override
	public void draw(Graphics g1) {
		Graphics2D g = (Graphics2D) g1;
				
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
     	  Stroke thindashed = new BasicStroke(width, // line width
			      /* cap style */BasicStroke.CAP_BUTT,
			      /* join style, miter limit */BasicStroke.JOIN_BEVEL, 1.0f);//,
			      /* the dash pattern *///new float[] { 8.0f, 3.0f, 2.0f, 3.0f },
			      /* the dash phase *///0.0f); /* on 8, off 3, on 2, off 3 */
		g.setStroke(thindashed);
		g.setColor((Color) colors.get(1));
		
		GeneralPath gp = new GeneralPath();
		for (int i=0; i < points.size()-1;i++) {
			
			gp.append(new Line2D.Float((Point)points.get(i),(Point)points.get(i+1)), true);
		}
		g.draw(gp);
		
	}
	
	public void setColor(Color c){
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),alpha);
		colors.set(0, cc);
	}
	
	public void drawPreview(Graphics g1) {
		Graphics2D g = (Graphics2D) g1;
		
		  Stroke thindashed = new BasicStroke(width, // line width
			      /* cap style */BasicStroke.CAP_BUTT,
			      /* join style, miter limit */BasicStroke.JOIN_BEVEL, 1.0f);//,
			      /* the dash pattern *///new float[] { 8.0f, 3.0f, 2.0f, 3.0f },
			      /* the dash phase *///0.0f); /* on 8, off 3, on 2, off 3 */
		g.setStroke(thindashed);
	
		g.setColor(Color.GRAY);
		
		GeneralPath gp = new GeneralPath();
		for (int i=0; i < points.size()-1;i++) {
			
			gp.append(new Line2D.Float((Point)points.get(i),(Point)points.get(i+1)), true);
		}
		g.draw(gp);
	}
	
	public JPanel settingPanel(){
		JPanel panel = new JPanel();
		
		panel.add(new JLabel("Line width"));
		
		JSlider widthSlider = new JSlider(JSlider.HORIZONTAL,50,300,Math.round(width*10f));
		widthSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				width = (float)((JSlider)e.getSource()).getValue()/10f;
			}
		});
		widthSlider.setPreferredSize(new Dimension(50,20));
        panel.add(widthSlider);
        
        panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		return panel;
	}
	
	public boolean isDrawable(){
		return true;
	}

}