import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JSplitPane;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import java.awt.FileDialog;
import javax.imageio.ImageIO;
import java.io.File;
import java.awt.image.BufferedImage;

import javax.swing.JOptionPane;

import javax.swing.JToolBar;
import javax.swing.JToggleButton;
import java.awt.BorderLayout;
import javax.swing.ButtonGroup;

import javax.swing.JColorChooser;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.JDialog;
import javax.swing.ImageIcon;
import java.awt.Point;



/**
 * @author Milan Ruzicka
 *
 */



public class MainFrame extends JFrame {

	final int xSize = 600;
	final int ySize = 450;
	JButton button;
	Comm comm;
	JSplitPane splitPane;
	JPanel canvasPanel;
	JScrollPane canvasScrollPane;
	MyCanvas canvas;
	
	public boolean observer;
	
	FileDialog saveDialog;
	
	JToolBar toolSettingToolBar;
	
	private final MainFrame frame = this;



	/**
	 * @throws HeadlessException
	 */
	public MainFrame(Comm c, boolean observing) throws HeadlessException {
		super("Collaborative Painting");
		setDefaultLookAndFeelDecorated(true);
		setSize(xSize, ySize);
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		observer = observing;
		
		comm = c;
		initComponents();
		

		setVisible(true);
		
		splitPane.setLeftComponent(canvas.drawTool.settingPanel());
		
	}
	
	
	private void initComponents() {
		canvasPanel = new JPanel();
		
		canvas = new MyCanvas(comm,this,observer);
		canvasScrollPane = new JScrollPane(canvas);
		canvasPanel.add(canvasScrollPane);
		
		splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, canvas.drawTool.settingPanel(), canvasScrollPane);
		splitPane.setDividerLocation(100);
		splitPane.setDividerSize(3);
		
		if (!observer) add(splitPane);
		else add (canvasScrollPane);
		
		
		
		
		setJMenuBar(createMenuBar());
		
		if (!observer) add(selectToolBar(), BorderLayout.NORTH);
		
		
	}

	private int i=0;
	private JToolBar selectToolBar(){
		ButtonGroup bg = new ButtonGroup();
		
		JToolBar bar = new JToolBar();
		
		JToggleButton jb;

		String[] icons = {"gbrush.png","gpencil.png","felttippen.png","gpen.png", "pencil.gif","line.gif","rectangle.gif","ellipse.gif","rotrectangle.gif","rotellipse.gif", "eraser.png", "gtext.png","gstamp.png", "gpencil.png","gpencil.png"};
		String[] toolTips = {"NPR water paint","NPR pencil","NPR felt-tip pen","NPR ink pen", "Simple pen","Line","Rectangle","Ellipse","Rotated rectangle","Rotated ellipse", "Eraser", "Text","Stamp", "Text","gpencil.png"};

		
		for (i=0; i < canvas.toolsNumber(); i++) {
			jb = new JToggleButton(new ImageIcon(icons[i]));
		    jb.setToolTipText(toolTips[i]);
		    jb.addActionListener(new ActionListener(){
		    	int p = i;
		    	public void actionPerformed(ActionEvent e){
		    		canvas.setDrawTool(p);
		    		frame.splitPane.setLeftComponent(canvas.drawTool.settingPanel());
		    		splitPane.setDividerLocation(100);
		    	}
		    });
		    
		    bar.add(jb);
		    bg.add(jb);

		    if (i==0) jb.setSelected(true);
		    		    
		    if ((i == 3)||(i==9)) {
		      bar.addSeparator();
		    }
		}
		
		
		JButton colBut = new JButton() {
			public MyCanvas canv = canvas;
			public Color c = Color.BLUE;
			public JColorChooser colCh = new JColorChooser();
			public JDialog colDialog = JColorChooser.createDialog(frame, "Choose foreground color", false, colCh,
					new ActionListener(){
				public void actionPerformed(ActionEvent e){
					c = colCh.getColor();
					canv.setToolColor(c);
					repaint();
				}
			},
			new ActionListener(){
				public void actionPerformed(ActionEvent e){}
			});
			public void paint(Graphics g){
				g.setColor(c);
				g.fillRect(0, 0, getWidth()-1, getHeight()-1);
				g.setColor(Color.WHITE);
				g.drawRect(0, 0, getWidth()-1, getHeight()-1);
			}
			
			{
				addActionListener( new ActionListener(){
					public void actionPerformed(ActionEvent e){
						colDialog.setVisible(true);
						
						}
				});
				setToolTipText("Set foreground color");
				
			}
		};
		
		bar.addSeparator();
		bar.add(colBut);
		
		JButton colBut2 = new JButton() {
			public MyCanvas canv = canvas;
			public Color c = Color.BLUE;
			public JColorChooser colCh = new JColorChooser();
			public JDialog colDialog = JColorChooser.createDialog(frame, "Choose background color", false, colCh,
					new ActionListener(){
				public void actionPerformed(ActionEvent e){
					c = colCh.getColor();
					canv.setToolBgColor(c);
					repaint();
				}
			},
			new ActionListener(){
				public void actionPerformed(ActionEvent e){}
			});
			public void paint(Graphics g){
				g.setColor(c);
				g.fillRect(0, 0, getWidth()-1, getHeight()-1);
				g.setColor(Color.WHITE);
				g.drawRect(0, 0, getWidth()-1, getHeight()-1);
			}
			
			{
				addActionListener( new ActionListener(){
					public void actionPerformed(ActionEvent e){
						colDialog.setVisible(true);
						
						}
				});
				setToolTipText("Set background color");
				
				
			}
		};
		
		bar.addSeparator();
		bar.add(colBut2);

		return bar;		
	}
	
	
	
	private JMenuBar createMenuBar() {
		JMenuBar menuBar = new JMenuBar();
		
		JMenu menuFile = new JMenu("File"); 
		menuBar.add(menuFile);
		
		saveDialog = new FileDialog(this,"Save drawing as..",FileDialog.SAVE);
		
		JMenuItem menuItemSave = new JMenuItem("Save drawing as PNG..");
		menuFile.add(menuItemSave);
		menuItemSave.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				saveDialog.show();;
				try {
					BufferedImage rgbClone= new BufferedImage(canvas.xSize, canvas.ySize,BufferedImage.TYPE_INT_RGB);
					rgbClone.getGraphics().drawImage(canvas.image, 0, 0, null);					
					if (saveDialog.getFile() != null) ImageIO.write(rgbClone,"png",new File(saveDialog.getDirectory()+saveDialog.getFile()));
				}
				
				catch(Exception ex){
					System.err.println(ex.getMessage());
				}
				
			}
		});
		
		JMenuItem menuItemExit = new JMenuItem("Exit");
		menuFile.add(menuItemExit);
		menuItemExit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				System.exit(0);
			}
		});
		
		
		JMenu menuTool = new JMenu("Tool"); 
		menuBar.add(menuTool);
		
		JMenuItem menuItemShowChat = new JMenuItem("Show chat window");
		menuTool.add(menuItemShowChat);
		menuItemShowChat.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				canvas.chatFrame.setVisible(true);
			}
		});
		
		menuTool.addSeparator();
		
		JMenuItem menuItemSendCanvas = new JMenuItem("Send whole canvas");
		menuTool.add(menuItemSendCanvas);
		if (!observer) menuItemSendCanvas.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				canvas.sendTool(new Stamp(canvas.image));
			}
		});
		
		
		JMenuItem menuItemClearCanvas = new JMenuItem("Clear whole canvas");
		menuTool.add(menuItemClearCanvas);
		if (!observer) menuItemClearCanvas.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				SimpleRectangle clr = new SimpleRectangle();
				clr.alpha=255;
				clr.bgAlpha=255;
				clr.setColor(Color.WHITE);
				clr.setBgColor(Color.WHITE);
				clr.addPoint(new Point(0,0));
				clr.addPoint(new Point(canvas.xSize, canvas.ySize));
				canvas.sendTool(clr);
			}
		});
		
		
		
		
		JMenu menuHelp = new JMenu("Help"); 
		menuBar.add(menuHelp);
		
		JMenuItem menuItemAbout = new JMenuItem("About ..");
		menuHelp.add(menuItemAbout);
		menuItemAbout.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				JOptionPane.showMessageDialog(frame,"Copyright (c) 2007 Milan Ruzicka", "About", JOptionPane.INFORMATION_MESSAGE);
			}
		});
		
		
		
		return menuBar;
	}
	

	/**
	 * @param arg0
	 */
	public MainFrame(GraphicsConfiguration arg0) {
		super(arg0);
	}

	/**
	 * @param arg0
	 * @throws HeadlessException
	 */
	public MainFrame(String arg0) throws HeadlessException {
		super(arg0);
	}

	/**
	 * @param arg0
	 * @param arg1
	 */
	public MainFrame(String arg0, GraphicsConfiguration arg1) {
		super(arg0, arg1);
	}

}
