import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.event.MouseInputListener;
import java.awt.event.MouseEvent;
import java.awt.Point;
import javax.swing.JPanel;
import org.jgroups.util.Util;


/**
 * @author Milan Ruzicka
 *
 */
public class MyCanvas extends JPanel implements MouseInputListener {

	public final int xSize = 1024;
	public final int ySize = 768;
	public BufferedImage image;
	private Comm comm;
	private Point cursor = new Point(0,0);
	
	public boolean observer=true;

	private boolean draw = true;
	
	Tool[] tools;
	Tool drawTool;
	public MainFrame hostWindow;
	public ChatFrame chatFrame;
	
	public void drawObject(Tool t) {
		if (t.isDrawable()) {
			t.draw(image.getGraphics());
		}
		else {
			chatFrame.messageReceived((ChatMessage)t);
		}
		repaint();
	}

	public void paint(Graphics g) {
		super.paint(g);
		g.drawImage(image,0,0,this);
		drawTool.drawPreview(g);
	}
	
	public MyCanvas(Comm c,boolean observer) {
		super();
		image = new BufferedImage(xSize, ySize,BufferedImage.TYPE_INT_ARGB);
		Graphics g = image.getGraphics();
		g.setColor(Color.WHITE);
		g.fillRect(0, 0, xSize, ySize);

		comm = c;

		this.setPreferredSize(new Dimension(xSize,ySize));
		
		if (!observer) {
			addMouseListener(this);
			addMouseMotionListener(this);
		}
		
		tools = createTools();
		drawTool = tools[0];
		
		chatFrame = new ChatFrame(this);
	}
	
	
	public MyCanvas(Comm c, MainFrame f, boolean observing){
		this(c,observing);
		observer = observing;
		hostWindow = f;
	}
	
	public MyCanvas(GraphicsConfiguration arg0) {
	}
	
	public void setToolColor(Color c){
		for (int i=0; i<tools.length;i++){
			tools[i].setColor(c);
		}
		
	}
	
	public void setToolBgColor(Color c){
		for (int i=0; i<tools.length;i++){
			tools[i].setBgColor(c);
		}		
	}
	
	public void setDrawTool(int i){
		tools[i].setColor((Color)drawTool.colors.get(0));
		drawTool = tools[i];
	}
	
	public int toolsNumber(){
		return tools.length;
	}
	
	public Tool[] createTools(){
		Tool[] tools = new Tool[] {
			new WaterBrush(),
			new Pencil(),
			new FeltTipPen(),
			new InkPen(),
			
			new SimplePen(),
			new SimpleLine(),
			new SimpleRectangle(),
			new SimpleEllipse(),
			new SimpleRotRectangle(),
			new SimpleRotEllipse(),
			new Eraser(),
			
			new Text(),
			new Stamp(),

		};
		
		return tools;
	}
	
	
	public void sendTool(Tool t){
			try{
				comm.send(Util.objectToByteBuffer(t));
			}
			catch (Exception ex) {
				System.err.println(ex.toString());
			}
	}
	

	public void mouseMoved(MouseEvent e) {
	}
	
	public void mouseDragged(MouseEvent e) {
		
    	if (draw) drawTool.addPoint(new Point(e.getX(), e.getY() ) );
    	repaint();
	}
	
	public void mouseClicked(MouseEvent e) {
	}	
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {
    	if (e.getButton()==3){
    		draw = false;
    	}
    	else {
    		draw = true;
        	drawTool.addPoint(new Point(e.getX(), e.getY() ) );
    	}

    }	
    	    	
    public void mouseReleased(MouseEvent e) {
    	if (drawTool.points.size() == 1) {
        	drawTool.addPoint(new Point(e.getX(), e.getY() ) );
        }
    	if (draw) sendTool(drawTool);
    	else repaint();
    	drawTool.clearPoints();

    }

}