import java.awt.Point;
import java.util.Vector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

import javax.swing.JPanel;
import javax.swing.JSlider;
import java.awt.Dimension;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;

import javax.swing.JTextField;
import java.awt.geom.AffineTransform;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CaretEvent;
import javax.swing.JLabel;

/**
 * @author Milan Ruzicka
 *
 */

public class Text extends Tool {
	public final boolean drawable = true;
	private static final long serialVersionUID = 30L; 
	
	private String textMsg="text";
	
	public float size = 2.0f;
	public int alpha = 255;
	
	public Text() {
		points = new Vector();
		colors = new Vector();
		
		colors.add(Color.blue);
		colors.add(Color.blue);
	}
	
	public Text(Color c) {
		points = new Vector();
		colors = new Vector();
		
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),alpha);
		colors.add(cc);
		colors.add(Color.blue);
	}

	/* (non-Javadoc)
	 * @see Tool#draw(java.awt.Image)
	 */
	@Override
	public void draw(Graphics g1) {
		Graphics2D g = (Graphics2D) g1;
				
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g.setColor((Color) colors.get(0));

		AffineTransform at = new AffineTransform();
		if (points.size() > 0) at.translate(((Point)points.lastElement()).x, ((Point)points.lastElement()).y);
		at.scale(size,size);
		at.rotate(this.angle);
		
		g.setTransform(at);
		
		if (points.size() > 0) g.drawBytes(textMsg.getBytes(), 0, textMsg.length(), 0,0);
		
	}
	
	public void setColor(Color c){
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),alpha);
		colors.set(0, cc);
	}
	
	public void drawPreview(Graphics g1) {
		Graphics2D g = (Graphics2D) g1;
	
		g.setColor(Color.GRAY);
		
		AffineTransform at = new AffineTransform();
		if (points.size() > 0) at.translate(((Point)points.lastElement()).x, ((Point)points.lastElement()).y);
		at.scale(size,size);
		at.rotate(this.angle);
		
		g.setTransform(at);
		
		if (points.size() > 0) g.drawBytes(textMsg.getBytes(), 0, textMsg.length(), 0,0);
		
	}
	
	public JPanel settingPanel(){
		JPanel panel = new JPanel();
		
		panel.add(new JLabel("Enter text:"));
		
		JTextField textField = new JTextField(textMsg,7){
			{
				this.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e){
						textMsg = getText();
					}
				});
				this.addCaretListener(new CaretListener(){
					public void caretUpdate(CaretEvent e){
						textMsg = getText();	
					}
				});
			}
		};
		panel.add(textField);
		
		panel.add(new JLabel("Orientation"));
		
		AngleChooser angleChooser = new AngleChooser(this,angle);
		panel.add(angleChooser);
		
		panel.add(new JLabel("Text size"));
		
		JSlider widthSlider = new JSlider(JSlider.HORIZONTAL,1,100,Math.round(size*10f));
		widthSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				size = (float)((JSlider)e.getSource()).getValue()/10f;
			}
		});
		widthSlider.setPreferredSize(new Dimension(50,20));
        panel.add(widthSlider);
        
        panel.add(new JLabel("Opacity"));
        
		JSlider alphaSlider = new JSlider(JSlider.HORIZONTAL,0,255,alpha);
		alphaSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				alpha = (int)((JSlider)e.getSource()).getValue();
				setColor((Color)colors.get(0));
			}
		});
		alphaSlider.setPreferredSize(new Dimension(50,20));
        panel.add(alphaSlider);
        
		return panel;
	}
	
	public boolean isDrawable(){
		return true;
	}

}