import java.io.Serializable;
import java.util.Vector;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.JPanel;

/**
 * @author Milan Ruzicka
 *
 */

public abstract class Tool implements Serializable {
	
	public double angle=0;
	
	public Vector points;
	public Vector colors;
	public Vector data;
	public Vector time;

	public abstract void draw(Graphics g);
	public abstract void drawPreview(Graphics g);
	public abstract JPanel settingPanel();
	
	public void addPoint(Point p) {
		points.add(p);
	}
	
	public void clearPoints() {
		points.removeAllElements();
	}
	
	public void setColor(Color c){
		colors.set(0, c);
	}
	
	public void setBgColor(Color c){
		colors.set(1, c);
	}
	
	public abstract boolean isDrawable();
	
}