function OnLoad(){
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
  var BasEnabled = false;
  var Address = "";
  var Port = "2222";
  var GpgPath = "";
  try{
    BasEnabled = prefs.getBoolPref("extensions.bas.enabled");
  }
  catch(ex){  }
  try{
    Address = prefs.getCharPref("extensions.bas.address");
  }
  catch(ex){  }
  try{
    Port = prefs.getCharPref("extensions.bas.port");
  }
  catch(ex){  }
  try{
    GpgPath = prefs.getCharPref("extensions.bas.gpgpath");
  }
  catch(ex){  }

  document.getElementById("BasEnabledCheckBox").setAttribute("checked", BasEnabled);
  document.getElementById("AddressTextBox").value = Address;
  document.getElementById("PortTextBox").value = Port;
  document.getElementById("BASGpgPathTextBox").value = GpgPath;
}

function OnAccept(){
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
  var BasEnabled = document.getElementById("BasEnabledCheckBox").checked;
  var Address = document.getElementById("AddressTextBox").value;
  var Port = document.getElementById("PortTextBox").value;
  var GpgPath = document.getElementById("BASGpgPathTextBox").value;
  prefs.setBoolPref("extensions.bas.enabled", BasEnabled);
  prefs.setCharPref("extensions.bas.address", Address);
  prefs.setCharPref("extensions.bas.port", Port);
  prefs.setCharPref("extensions.bas.gpgpath", GpgPath);
  var cr = window.opener.document.getElementById("button-credits");
  if(BasEnabled){
    cr.disabled = false;
    var folder = window.opener.GetFirstSelectedMsgFolder();
    window.opener.OnCreditsClick();
  } else {
    cr.disabled = true;
    cr.label = "-";
  }
  BASSetPGP();
}

function GetGpgFilePath(){
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var mode = Components.interfaces.nsIFilePicker.modeOpen;

  fp.init(window,"Open file", mode);

  fp.appendFilter("GnuPG executable","gpg.exe")
  fp.defaultString = "gpg.exe";
  res = fp.show();

  if (res!=Components.interfaces.nsIFilePicker.returnOK)
    return null;

  var file = fp.file.QueryInterface(Components.interfaces.nsILocalFile);
  return file;
}

function BrowseClick(){
  var file = GetGpgFilePath();
  if(file!=null){
    document.getElementById("BASGpgPathTextBox").value = file.path;
  }
}