﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TCPServer
{
    public partial class Settings : Form
    {
        public event EventHandler OnStartClick;
        public event EventHandler OnStopClick;
        
        public Settings()
        {
            InitializeComponent();
        }

        private void BrowseButton_Click(object sender, EventArgs e)
        {
            if (BrowseOpenFileDialog.ShowDialog() == DialogResult.OK)
            {
                GPGTextBox.Text = BrowseOpenFileDialog.FileName;
                ServerData.GPGPath = BrowseOpenFileDialog.FileName;
            }
        }

        private void StartButton_Click(object sender, EventArgs e)
        {
            if (ServerData.Enabled)
            {
                OnStopClick.Invoke(sender, EventArgs.Empty);
                ServerData.Enabled = false;
                StartButton.Text = "Start Server";
            }
            else
            {
                OnStartClick.Invoke(sender, EventArgs.Empty);
                ServerData.Enabled = true;
                StartButton.Text = "Stop Server";
            }
        }


    }
}
