﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Data.SqlServerCe;

namespace TCPServer
{
    public class MailData
    {
        public int ID;
        public string From;
        public string To;
        public string Stamp;
        public string TimeStamp;

        public MailData(int iID, string iFrom, string iTo, string iStamp)
        {
            ID = iID;
            From = iFrom;
            To = iTo;
            Stamp = iStamp;
        }
    }

    public class User
    {
        public int ID;
        public string Email;
        public int Credits;
        public Connection Connection = null;
        public List<MailData> OutgoingMail = new List<MailData>();
        public List<MailData> IncomingMail = new List<MailData>();

        public User(int iID, string iEmail, int iCredits)
        {
            ID = iID;
            Email = iEmail;
            Credits = iCredits;
        }
    }

    public class Connection
    {
        public const int BufferSize = 1024;
        public Socket WorkSocket = null;
        public byte[] Buffer = new byte[BufferSize];
        public StringBuilder Data = new StringBuilder();
        public DateTime TimeStamp;
        public User User;
        public long ServerNonce;
        public long UserNonce;

        public bool CompareNonce(long usernonce, long servernonce)
        {
            if ((usernonce != UserNonce + 1) || (servernonce != ServerNonce + 1))
                return false;
            UserNonce = usernonce;
            ServerNonce = servernonce;
            return true;
        }
        public void NextNonce()
        {
            UserNonce++;
            ServerNonce++;
        }

    }

    public class ServerData
    {
        public static bool Enabled = false;
        public static string GPGPath;
        public static TcpListener Server;
        public Database database;

        public List<User> Users = new List<User>();
        public List<Connection> Connections = new List<Connection>();

        public ServerData(string dbname)
        {
            database = new Database(dbname);
            Users = database.GetUserData();
        }
    }
    
}
