  // set compose listener
  window.addEventListener("load", BASMsgComposeStartup, false);
  window.addEventListener('compose-window-reopen', BASMsgComposeReopen, true);
  window.addEventListener('compose-window-close', BASMsgComposeClose, true);

  // Listen to message sending event
  window.addEventListener('compose-send-message', BASSendMessageListener, true);

var composeStateListener;

function BASMsgComposeStartup() {
  composeStateListener = new BASComposeStateListener();
  gMsgCompose.RegisterStateListener(composeStateListener);
}

function BASMsgComposeReopen(){
  composeStateListener = new BASComposeStateListener();
  gMsgCompose.RegisterStateListener(composeStateListener);
}

function BASMsgComposeClose(){
  if (gMsgCompose){
    gMsgCompose.UnregisterStateListener(composeStateListener);
  }
}

function GetWindow(WinID){
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].
                                 getService(Components.interfaces.nsIWindowMediator);
  return windowManager.getMostRecentWindow(WinID);
}

// state listener
function BASComposeStateListener() {}

BASComposeStateListener.prototype = {
  NotifyComposeFieldsReady: function() {  },

  ComposeProcessDone: function(aResult) {
    if (aResult== Components.results.NS_OK) {
      try{
        var composeservice = Components.classes["@mozilla.org/messengercompose;1"].getService(Components.interfaces.nsIMsgComposeService);
        var subject = gMsgCompose.compFields.subject;
        //BASLog(gMsgCompose.originalMsgURI + "\n");
        //BASLog(gMsgCompose.savedFolderURI + "\n");
        // set send flag
        var mailWindow = GetWindow("mail:3pane");
        var sentmessageobj = mailWindow.document.getElementById("sentmessage");
        sentmessageobj.value = "true";
        var sentmessagesubjectobj = mailWindow.document.getElementById("sentmessagesubject");
        sentmessagesubjectobj.value = subject;
      }
      catch(ex){
        alert(ex);
      }
    } else {
    }
  },

  NotifyComposeBodyReady: function() { },

  SaveInFolderDone: function(folderURI) { }

};

var GenericSendMessageOld = GenericSendMessage;
GenericSendMessage = function (msgType) {
  Recipients2CompFields(gMsgCompose.compFields);
  var to = gMsgCompose.compFields.to;
  SendAvailableAsync = SendAvailable(msgType, gCurrentIdentity.email, to);
  SendAvailableAsync.next();
}

var gBoolSendMessage = true;
var SendAvailableAsync;
function SendAvailable(msgType, from, to){
  self = SendAvailableAsync;
  gBoolSendMessage = true;
  if(BASEnabled()){
    EnoughCreditsAsync = EnoughCredits(self, from, to);
    EnoughCreditsAsync.next(); 
    var res = yield;
    if(res==false){
      gBoolSendMessage = confirm("You Credit count is too low, some recipients will recieve non-legitimate messages.\nDo you really want to send message?");
    }
  }
  GenericSendMessageOld(msgType);
}

function BASSendMessageListener(event) {
  var to = gMsgCompose.compFields.to;
  try {
    if (!gBoolSendMessage) {
      event.preventDefault();
      event.stopPropagation();
    }
  }
  catch (ex) {
    alert(ex);
  }
}

