<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:my="http://blog.matfyz.sk"
	xmlns:func="http://exslt.org/functions"
	extension-element-prefixes="my func">
<xsl:output omit-xml-declaration="no" method="xml" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" indent="yes" encoding="utf-8" />
	
<xsl:param name="base"/>
<xsl:param name="tag"/>
<xsl:param name="filter"/>
<xsl:param name="page"/>


<xsl:template match="module[@name='TagAdmin']">
	<h1>ADMINISTRÁCIA TAGOV</h1>
	<xsl:apply-templates select="message"/>
	jazyk: <xsl:value-of select="@lang"/>
	<hr/>
	<a href="?type=tagAdmin">Nastavenia tagov</a>|
	<a href="?type=tagAdmin&amp;page=statistics">Štatistiky</a> |
	<a href="?type=tagAdmin&amp;page=importAnnotations">Znovu načítať tagy</a> |
	<!--<a href="?type=tagAdmin&amp;page=resetSystem">!!!zresetovat cely system!!!</a> |-->
	<br/>
	<br/>
	<xsl:apply-templates select="statistics"/>
	<xsl:apply-templates select="importResult"/>
	<xsl:apply-templates select="tags"/>
	<br/>
	<br/>
	
</xsl:template>

<xsl:template match="statistics">
	<xsl:copy-of select="." />
</xsl:template>

<xsl:template match="importResult">
	<xsl:copy-of select="." />
</xsl:template>

<xsl:template match="message">
	<div style="border:1px #FF0000 solid;">
	<xsl:value-of select="./text()" />
	</div>
</xsl:template>

<xsl:template match="tags">
	<div>
	Filtruj: <form method="get" action=""><input type="hidden" name="type" value="tagAdmin"/><input name="filter" type="text" value="{$filter}"/><input type="submit" name="submit" value="Filtruj"/></form>
	<xsl:if test="$filter!=''"> <a href="?type=tagAdmin">Zruš filter</a></xsl:if><br/>
	Celkovo <xsl:value-of select="@count"/> tagov.<br/>
	<xsl:call-template name="paginationNumbers">
		<xsl:with-param name="count" select="@count"/>
		<xsl:with-param name="page" select="@page"/>
		<xsl:with-param name="i" select="0"/>
	</xsl:call-template>
	
	<table border="1" width="100%">
	<tr>
		<th width="25%">meno tagu</th>
		<th width="40%">alternativy</th>
		<th>zobrazenie</th>
		<th width="25%">zlúč pod kanonický</th>
		<!--<th>obrázok</th>-->
	</tr>
	<xsl:for-each select="tag">
		<tr id="tag{@id}">
			<td><xsl:value-of select="@name"/></td>
			<td>
				<xsl:for-each select="alternative">
					<a href="?type=tagAdmin&amp;filter={$filter}&amp;page={$page}&amp;tag={@id}&amp;split={@id}#tag{@id}">
					<xsl:value-of select="."/>
					</a>| 
				</xsl:for-each>
			</td>
			<td>
				<xsl:if test="@visible='1'"><a href="?type=tagAdmin&amp;filter={$filter}&amp;page={$page}&amp;tag={@id}&amp;display=false#tag{@id}">zobrazený</a></xsl:if>
				<xsl:if test="@visible='0'"><a href="?type=tagAdmin&amp;filter={$filter}&amp;page={$page}&amp;tag={@id}&amp;display=true#tag{@id}">skrytý</a></xsl:if>
			</td>
			<td>
			<form method="post" action="?type=tagAdmin&amp;filter={$filter}&amp;page={$page}">
				<input type="hidden" name="tag" value="{@id}"/>
				<input name="canonical" type="text" value=""/><input type="submit" name="merge" value="zlúč"/></form>
			</td>
			<!--<td><xsl:value-of select="@image"/></td>-->
		</tr>
	</xsl:for-each>
	</table>
	</div>
</xsl:template>

<xsl:template name="paginationNumbers">
    <xsl:param name="page"/>
	<xsl:param name="count"/>
	<xsl:param name="i" select="0"/>
	<xsl:param name="skip" select="50"/> <!-- pocet veci na stranu -->
    <xsl:if test="$count > ($i * $skip)">
		<xsl:choose>
			<xsl:when test="$i=$page">
				<strong><xsl:value-of select="$i+1"/></strong>
			</xsl:when>
			<xsl:otherwise>
				<a href="?type=tagAdmin&amp;filter={$filter}&amp;pagination={$i}"><xsl:value-of select="$i+1"/></a>
			</xsl:otherwise>
		</xsl:choose>
		 <xsl:text disable-output-escaping="yes">&#160;&#160;&#160;&#160;</xsl:text>
		<xsl:call-template name="paginationNumbers">
			<xsl:with-param name="count" select="$count"/>
			<xsl:with-param name="page" select="$page"/>
			<xsl:with-param name="i" select="$i+1"/>
		</xsl:call-template>
	</xsl:if>      
  </xsl:template>
  
</xsl:stylesheet>