<?php

require_once 'classes/Session.php';
require_once 'classes/Controler.php';
require_once 'classes/Portlet.php';
require_once 'classes/Sedna.php';
require_once 'classes/Filters.php';
require_once 'classes/SortQueries.php';
require_once 'classes/Tagging.php';
require_once 'classes/Graph.php';
class RelationalTagBrowser implements Portlet {

/*
TODO:

*/
	private $tagging;
	public function init($params) {
		$this->tagging = Tagging::getInstance();
	}
	public function getXML($params) {
		$data="";
		switch ($params['type']) {
			case "search":
			case "portalView": {
				if ($params['tag']!=''){
					$data .= '<module name="TagBrowser">'.$this->tagging->getRelatedTagsXML(formatText($params['tag']),20).'</module>';
				}
				break;
			}
			case "getTagBrowserSVG":
				echo $this->generateTagBrowserSVG($params["tag"]);
				exit();
				break;
		}
		
		return $data;
	}
	
	public function generateTagBrowserSVG($selectedTag, $limit = 10){
		//GET NODES
		$selectedTagID = $this->tagging->tagregator->getRootCanonicalID($selectedTag);
		$cloud = $this->tagging->cloudMaker->getRelatedTags($selectedTagID,$limit);
		$graph = new Graph();
		
		$graph->addNode($selectedTagID,0.1,true);
		
		$tags = array(); //chcem vediet co mam v grafe, nech viem vybrat spravne hrany
		foreach($cloud as $tag){
			if($tag['tag'] != $selectedTagID){
					$graph->addNode($tag['tag'],$tag['strength']);
					$graph->addEdge($tag['tag'],$selectedTagID);
				} else {
					$graph->nodes[$selectedTagID]->size=$tag['strength'];
				}
			$tags[]=$tag['tag'];
		}
		
		foreach($graph->nodes as &$node){
			$nodeTagID = $node->name;
			//vytvorime si zoznam resourcov z danym tagom
			$cloud = $this->tagging->cloudMaker->getCloud("resource","linear",null,null,null,$nodeTagID,null);
			$resources = array(); 
			foreach($cloud as $res){
				$resources[]=$res['resource'];
			}
			$cloud = $this->tagging->cloudMaker->getCloud("tag","logarithmic",null,null,$resources,$tags,$limit); //vyberieme "hrany", tj. chceme take anotacie, ktore su v zozname clankov kde je aj nas tag, a zaroven je tam tag z grafu
			
			foreach($cloud as $tag){
				if ($graph->hasNode($tag['tag'])){
					if ($tag['tag']!=$selectedTagID){
						$graph->addEdge($node->name,$tag['tag']);
					}
				}// else echo("ERROR");
			}
		}
		
		$graph->makeCircle();
		$graph->make();
		$graph->normalize();
		//vsade mam id-cka, budem potrebovat vypisat texty
		$tags[]=$selectedTagID;
		$canonicals = $this->tagging->tagregator->getCanonicalsByIDs($tags);
		
		$result = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
		<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 20000303 Stylable//EN" "http://www.w3.org/TR/2000/03/WD-SVG-20000303/DTD/svg-20000303-stylable.dtd">
		<svg xmlns="http://www.w3.org/2000/svg"  id="root" width="100%" height="100%" xmlns:xlink="http://www.w3.org/1999/xlink" onload="loadsvgcaller(evt)">';
			
		//skript na centrovanie a focus
		$result.= '<script type="text/ecmascript"> <![CDATA[
		var popisky = new Array();
		';
		//vyrobime pole s popiskami
		$i=0;
		foreach ($graph->nodes as &$node){ 
			if ($node->name!='-1')	//ked tag je nulovy..
				$result.= 'popisky['.$i++.']="'.$node->name.'";';
		}
		$result.='
		function loadsvgcaller(evt) {
			var p;
			for (p in popisky) center(document.getElementById(popisky[p])); //vsetky vycentrujem
			//focus();
		}
		function center( targetElement ) { //vycentruje 1 popisok
			var bbox = targetElement.getBBox(); 
			var xcor = bbox.x-bbox.width/2;
			targetElement.setAttributeNS(null,"x",xcor);
		}
		//focus - focus sa pozrie na jednotlive popisky na obrazku, a nastavi viewbox tak, aby boli vsetky viditelne
		function focus(){
			var minX = document.getElementById(popisky[0]).getBBox().x;
			var maxX = minX;
			var minY = document.getElementById(popisky[0]).getBBox().y;
			var maxY = minY;
			var p;
			for (p in popisky){ //najdeme okraje tj. min a max x/y
				if (document.getElementById(popisky[p]).getBBox().x<minX) minX = document.getElementById(popisky[p]).getBBox().x;
		        if (document.getElementById(popisky[p]).getBBox().x+document.getElementById(popisky[p]).getBBox().width>maxX)
					maxX = document.getElementById(popisky[p]).getBBox().x+document.getElementById(popisky[p]).getBBox().width;
				if (document.getElementById(popisky[p]).getBBox().y<minY) minY = document.getElementById(popisky[p]).getBBox().y;
				if (document.getElementById(popisky[p]).getBBox().y+document.getElementById(popisky[p]).getBBox().height>maxY)
					maxY = document.getElementById(popisky[p]).getBBox().y+document.getElementById(popisky[p]).getBBox().height;
			}
			var mx = minX-5+" ";
			var my = minY-5+" ";
			var width = 5+(maxX-minX)+" ";
			var height = 5+(maxY-minY)+""; 
			var viewBox=mx+my+width+height;
			document.getElementById("root").setAttribute("viewBox",viewBox);
		}
		]]> </script>';

		
		$padding = 10;
		$paddingC = 100-$padding; //velkost efektivnej plochy
		foreach ($graph->edges as &$edge){
			$result.= '<line x1="'.($padding+$edge->nodes[0]->x*$paddingC).
						 '%" y1="'.($padding+$edge->nodes[0]->y*$paddingC).
						 '%" x2="'.($padding+$edge->nodes[1]->x*$paddingC).
						 '%" y2="'.($padding+$edge->nodes[1]->y*$paddingC).
						 '%" style="stroke:rgb(200,200,200);stroke-width:1"/>';	
			$result.= "\n";
	    }
		
		$maxSize = $graph->nodes[0]->size;
		$minSize = $graph->nodes[0]->size;
		foreach ($graph->nodes as &$node){
			if ($node->size > $maxSize) $maxSize = $node->size;
			if ($node->size < $minSize) $minSize = $node->size;
		}
		
		foreach ($graph->nodes as &$node){
			$nodeSize = ($node->size - $minSize)/($maxSize - $minSize+1);
			$result.='<a xlink:href="?tag='.$canonicals[$node->name].'" target="_parent">';
			$result.='<text id="'.$node->name.'" x="'.($padding+$node->x*$paddingC).
						'%" y="'.($padding+$node->y*$paddingC).
						'%" font-family="Verdana" font-size="'.(80+100*$nodeSize).'%" fill="green" >'.$canonicals[$node->name].'</text>';
			
			$result.= "</a>\n";
		}
		
		$result .=  "</svg>";
		
		header("Content-type: image/svg+xml");  //HACK!!!
		return $result;
	}
	
	
	public function getXSLlist($params) {
		switch ($params['type']) {
			case "search":
			case "portalView": {
				return array('classes/modules/tagBrowser.xsl');
				break;
			}
		}
		return array();
	}
	
	public function getXSLParams($params) {
		switch ($params['type']) {
			case "vote":
			case "postView":
			case "blogView":
			case "search":
			case "userPosts":
			case "portalView": {
				return array('base'=>BASE,'tag'=>$params['tag']);
				break;
			}
		}
		return array();
	}
}

$GLOBALS['controler']->registerPortlet(RelationalTagBrowser);

?>
