<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:my="http://blog.matfyz.sk"
	xmlns:func="http://exslt.org/functions"
	extension-element-prefixes="my func">

<xsl:template match="module[@name='TagCloud']">

<div class="portlet tagCloudPortlet">
	<h3><xsl:call-template name="getString">
		<xsl:with-param name="stringName" select="'Tags'"/>
		</xsl:call-template></h3>

			<label for="tags"><xsl:call-template name="getString">
		<xsl:with-param name="stringName" select="'tagsAdd'"/>
		</xsl:call-template>: <xsl:call-template name="questionMark"/></label><br />
				(<xsl:call-template name="getString">
					<xsl:with-param name="stringName" select="'tagsAddHint'"/>
				</xsl:call-template>.)
			<textarea id="tags" name="tags" class="tagBox">
				<xsl:for-each select="tags/tag">
					<xsl:value-of select="." />
					<xsl:if test="position() != last()">
					<xsl:text>, </xsl:text>
					</xsl:if>
				</xsl:for-each>
			</textarea>

		<label for="tags"><xsl:call-template name="getString">
			<xsl:with-param name="stringName" select="'tagsUsed'"/>
			</xsl:call-template>: <xsl:call-template name="questionMark"/></label><br/>

				(<xsl:call-template name="getString">
					<xsl:with-param name="stringName" select="'tagsUsedHint'"/>
				</xsl:call-template>.)
			<div class="tagArea" id="tagArea">
				<xsl:for-each select="tagCloud/tag">
					<span style="font-size:{2*@strength + 0.5}em" class="tagButton" title="{.}" onclick="addTag(this.innerHTML);"><xsl:value-of select="." /></span>
					<xsl:text> </xsl:text>
				</xsl:for-each>
			</div>
					<!--
					<p id="sortList" style="padding-right: 10px;">
						<xsl:call-template name="getString">
							<xsl:with-param name="stringName" select="'Sort by'"/>
						</xsl:call-template>:
						<a href="javascript:void();" onclick="tagSort('name',this);"  class="asc"><xsl:call-template name="getString">
							<xsl:with-param name="stringName" select="'Alphabet'"/>
						</xsl:call-template></a>
						<a href="javascript:void();" onclick="tagSort('size',this);"><xsl:call-template name="getString">
							<xsl:with-param name="stringName" select="'Size'"/>
						</xsl:call-template></a>
						<a href="javascript:void();" onclick="tagSort('length',this);"><xsl:call-template name="getString">
							<xsl:with-param name="stringName" select="'Length'"/>
						</xsl:call-template></a>
						<script type="text/javascript">tagSort('name',this);</script>
					</p>
					// -->
</div>

</xsl:template>

</xsl:stylesheet>