﻿package  {
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import wassil.debug.Console;
	import wassil.utils.XMLLoader;
	import wassil.utils.Waiter;
	import flash.events.KeyboardEvent;
	/**
	 * ...
	 * @author wassil
	 */
	public class Game extends MovieClip {
		var xmlLoader: XMLLoader;
		var xmlSender:XMLLoader;
		public var xml:XML;
		var fbID:String;
		var cofbID:String;
		var coStatusBar:StatusBar;
		var status:String;
		var waiter:Waiter;
		var responseTime:Number;
		public function Game() {
			
		}
		public function init(fbID:String, cofbID:String) {
			waiter = new Waiter();
			this.fbID = fbID;
			this.cofbID = cofbID;
			tfWord.text = "";
			tfCoPlayerSuggestions.text = "";
			tfScore.text = "";
			tfTimeLeft.text = "";
			tfSkipWord.text = "Ak si zúfalý, preskoč slovo";
			coStatusBar = new StatusBar();
			addChild(coStatusBar);
			coStatusBar.init(cofbID);
			status = "pending";
			xmlLoader = new XMLLoader(Main.getGameData + "&fbID=" + fbID, checkRunning);
			waiter.waitAndCall(1000,checkRunningWaiter);
		}
		private function checkRunningWaiter(e:Event = null) {
			if (status != "running"){
				if (new Date().getTime() - responseTime > 1000) {
					Console.trace("vypadol jeden request, zacnem znova");
					xmlLoader = new XMLLoader(Main.getGameData + "&fbID=" + fbID, checkRunning);
				}
				waiter.waitAndCall(1000,checkRunningWaiter);
			}
		}
		public function checkRunning(e:Event = null) {
			Console.trace("check running");
			responseTime = new Date().getTime();
			xml = xmlLoader.xml;
			status = xml.game.@status;
			if (status != "running") {
				xmlLoader = new XMLLoader(Main.getGameData + "&fbID=" + fbID, checkRunning);
			}else {
				startGame();
			}
		}
		public function startGame() {
			Console.trace("start game");
			btSend.buttonMode = true;
			btSkip.buttonMode = true;
			btSend.addEventListener(MouseEvent.CLICK, sendWord);
			btSkip.addEventListener(MouseEvent.CLICK, skipWord);
			stage.focus = tfInput;
			status = "running";
			xmlLoader = new XMLLoader(Main.getGameData + "&fbID=" + fbID, response);
			waiter = new Waiter();
			waiter.waitAndCall(500, getResponseWaiter);
			stage.addEventListener( KeyboardEvent.KEY_DOWN, keyDownHandler);
		}
		public function endGame() {
			stage.removeEventListener( KeyboardEvent.KEY_DOWN, keyDownHandler);
			this.dispatchEvent(new Event(Event.COMPLETE));
		}
		
		public function getResponseWaiter(e:Event = null) {
			if (status != "finished") {
				if (new Date().getTime() - responseTime > 500) {
					Console.trace("vypadol jeden request, zacnem znova");
					xmlLoader = new XMLLoader(Main.getGameData + "&fbID=" + fbID, response);
				}
				waiter.waitAndCall(500, getResponseWaiter);
			}
		}
		public function response(e:Event=null) {
			xml = xmlLoader.xml;
			//deal with finished game
			Console.trace(xml.toString());
			status = xml.game.@status;
			if (xml.game.@wantSkip == "me") {
				tfSkipWord.text = "Navrhol si preskočiť slovo";
			} else if (xml.game.@wantSkip == "co") {
					tfSkipWord.text = "Spoluhráč navrhol preskočiť slovo";
				}
			if (tfWord.text != xml.game.@currentWord) {
				tfSkipWord.text = "Ak si zúfalý, preskoč slovo";
			}
			tfWord.text = xml.game.@currentWord;
			tfCoPlayerSuggestions.text = xml.game.@coPlayerSuggestions;
			tfScore.text = xml.game.@score;
			tfTimeLeft.text = xml.game.@timeLeft;
			
			if (status == "finished") {
				endGame();
			}else {
				xmlLoader = new XMLLoader(Main.getGameData + "&fbID=" + fbID, response);
			}
		}
		public function sendWord(e:Event=null) {
			//url encode a nech to reaguje na enter
			xmlSender = new XMLLoader(Main.sendWord + "&fbID=" + fbID + "&word=" + encodeURIComponent(tfInput.text), responseWordSend);
			tfInput.text = "";
		}
		function keyDownHandler( e:KeyboardEvent ):void{
			if( e.charCode == 13 ){
				sendWord();
			}
		}
		public function responseWordSend(e:Event) {
			Console.trace(xmlSender.xml);
		}
		public function responseWordSkip(e:Event) {
			Console.trace(xmlSender.xml);
		}
		public function skipWord(e:Event = null) {
			xmlSender = new XMLLoader(Main.skipWord + "&fbID=" + fbID, responseWordSkip);
		}
	}

}