<?php

require_once 'classes/Session.php';
require_once 'classes/Controler.php';
require_once 'classes/Portlet.php';
require_once 'classes/Sedna.php';
require_once 'classes/Filters.php';
require_once 'classes/SortQueries.php';
require_once 'classes/modules/Tagregator.php';
require_once 'classes/modules/CloudMaker.php';

class Tagging {
/*
singleton vec ktoru pouzivaju vsetky portlety co riesia tagovanie
treba si zavolat Tagging->getInstance()
TODO:

*/
	public $tagregator;
	public $cloudMaker;
	public $lang;
	
	private static $instance; 
    public static function getInstance() { 
       if (!self::$instance) 
        { 
            self::$instance = new Tagging(); 
        } 

        return self::$instance;
    }
	
	private function __construct() {
		//vyberiem si spravny jazyk, podla toho si vyberiem varianty mojich tag struktur
		$this->lang = $_SESSION['session']->getLang();
		if ($this->lang=="ensk"){
			$this->lang = "sk";
		}
		$this->tagregator = new Tagregator($this->lang);
		$this->cloudMaker = new CloudMaker($this->lang);
		
		//$this->clearAndImportCanonicals();
	}
	public function resetSystem(){
		echo('System reseting.. canonicals and anotations will be imported');
		$this->clearAndImportCanonicals();
		$this->clearAndImportAnnotations();
	}
	/*
	vycisti kompletne tabulky s kanonickymi tagmi a nanovo naplni z databazy
	*/
	public function clearAndImportCanonicals(){
		//vycistime tabulky !!
		$this->tagregator->flushTables();
		//kompletna databaza tagov
		$xquery = 'collection("weblog")/tags/tag';
		$result= $GLOBALS['system']->getDB()->fetchNode($xquery);
		$xml = new DOMDocument();
		//echo($result);exit();
		$xml->loadXML("<tags>".$result."</tags>");
		$tags = $xml->getElementsByTagName('tag');
		foreach ($tags as $tag){
			if ($tag->getAttribute("lang")==$this->lang){
				$c = $tag->getAttribute("canonical");
				echo $c."<br/>";
				$cID = $this->tagregator->getID($c);
				if (cID!=-1){//pomergujem ich do canonical
					$alts = $tag->getElementsByTagName('alt');
					$altTags=array();
					foreach ($alts as $alt){
						$altTags[]=$alt->textContent;
					}
					$ids = $this->tagregator->getIDs($altTags);
				    foreach($ids as $id){
						if ($id!=$cID) $this->tagregator->mergeUnder($id,$cID);
					}
				}
			}
		}
	}
	/*
	vycisti kompletne tabulku s anotaciami a nanovo naplni z portalovej databazy
	*/
	public function clearAndImportAnnotations(){
		//vycistime tabulky !!
		$this->cloudMaker->flushTables();
		//vezmeme vsetky tagy z postov
		$xquery = 'for $post in collection("weblog")/user/blog/post[@status="published"]
					return <post lang="{$post/@lang}" id="{$post/@ID}" user="{$post/../../@ID}">{$post/tags/*}</post>';
		$result= $GLOBALS['system']->getDB()->fetchNode($xquery);
		
		$xml = new DOMDocument();
		//a nasupame do tabulky
		$xml->loadXML("<posts>".$result."</posts>");
		$posts = $xml->getElementsByTagName('post');
		foreach($posts as $post){
			if ($post->getAttribute("lang")==$this->lang){
				//echo $post->getAttribute("user");
				$user = $post->getAttribute("user");
				$resource = $post->getAttribute("id");
				$tags = $post->getElementsByTagName('tag');
				$tagsArray=array();
				foreach ($tags as $tag){
					$tagsArray[]=$tag->textContent;
				}
				$tagIDs = $this->tagregator->getIDs($tagsArray);
				$triplets = array();
				foreach ($tagIDs as $tagID){
					$triplets[] = array("user" => $user, "resource" => $resource, "tag" => $tagID);
				}
				if (!empty($triplets)) $this->cloudMaker->addTriplets($triplets);
			}
		}
		return "Tagy nacachovan.";
		//exit();
	}
	public function test(){
		echo $this->getUserName("u138");
		//echo $this->getRelatedTagsXML("matfyz",20);
		echo("<br><br><h1>POSTY</h1>");
		//echo $this->getRelatedResourcesXML("p2341",3);
	//	exit();
		
	}
	public function getRelatedTagsXML($tag,$limit){
		$tagID = $this->tagregator->getRootCanonicalID($tag);
		$cloud = $this->cloudMaker->getRelatedTags($tagID,$limit);
		$cloudXML = $this->getCloudXML($cloud,"alphabet");
		return $cloudXML;
	}
	public function getRelatedResourcesXML($resourceID,$limit){
		$cloud = $this->cloudMaker->getRelatedResources($resourceID,$limit);
		$cloudXML = $this->getCloudXML($cloud,"alphabet");
		return $cloudXML;
	}
	public function getRelatedUsersXML($userID,$limit){
		$cloud = $this->cloudMaker->getRelatedUsers($userID,$limit);
		$cloudXML = $this->getCloudXML($cloud,"alphabet");
		return $cloudXML;
	}
	//vrati xml-ko ked ako vstup dostane pole z cloud-makeru
	public function getCloudXML($cloudData,$ordering="alphabet"){
		$dataIDs = array();$i=0;
		$type="";
		//zistime typ cloudu a vezmeme id-cka ake potrebujeme
		foreach($cloudData as $dat) {
			if ($type==""){
				foreach($dat as $key=>$var) {
					if ($key=="tag") $type = "tag"; else if ($key=="user") $type ="user"; else if ($key=="resource") $type ="resource";
				}
			}
			$dataIDs[$i++] = $dat[$type];
		}
		//k id-ckam zistime povodne nazvy
		if ($type == "tag") $canonicals = $this->tagregator->getCanonicalsByIDs($dataIDs);
			else if ($type == "user") $canonicals =$this->getUserNames($dataIDs)/* ziskaj mena userov podla id-ciek*/;
				else $canonicals =$this->getResourceNames($dataIDs);
		//utriedenie a vystup
		
		//vystup treba upravit tak, aby isiel spravne pre jednotlive typy cloudov - asi skor presunut do xslt
		if ($ordering == "alphabet"){ // podla abecedy
			asort($canonicals,SORT_STRING);
		}else {//podla vyznamnosti
		}
		$cloudString = "";
		$strengths= array();
		foreach($cloudData as $dat){$strengths[$dat[$type]] = $dat['strength'];}
		if ($type == 'resource'){
			$authorNicks =$this->getResourceAuthorNicks($dataIDs);
			foreach($canonicals as $id=>$canonical) $cloudString.='<'.$type.' authorNick="'.$authorNicks[$id].'" id="'.$id.'" strength="'.$strengths[$id].'">'.$canonical.'</'.$type.'>';
		} else foreach($canonicals as $id=>$canonical) $cloudString.='<'.$type.' id="'.$id.'" strength="'.$strengths[$id].'">'.$canonical.'</'.$type.'>';
		
		//echo $cloudString;
		return "<tagCloud>".$cloudString."</tagCloud>";
	}
	//
	public function getResourceNames($IDs){
		$r = array();
		foreach($IDs as $id){
			$r[$id] = $this->getResourceName($id);
		}
		return $r;
	}
	public function getResourceName($id){
		$xquery = 'for $post in collection("weblog")/user/blog/post[@ID="'.$id.'"]
					return $post/title/text()';
		$result= $GLOBALS['system']->getDB()->fetchNode($xquery);
		return $result;
	}
	public function getResourceAuthorNicks($IDs){
		$r = array();
		foreach($IDs as $id){
			$r[$id] = $this->getResourceAuthorNick($id);
		}
		return $r;
	}
	public function getResourceAuthorNick($id){
		$xquery = 'for $post in collection("weblog")/user/blog/post[@ID="'.$id.'"]
					return $post/../../info/nick/text()';
		$result= $GLOBALS['system']->getDB()->fetchNode($xquery);
		return $result;
	}
	
	//
	public function getUserNames($IDs){
		$r = array();
		foreach($IDs as $id){
			$r[$id] = $this->getUserName($id);
		}
		return $r;
	}
	
	public function getUserName($id){
		$xquery = 'for $user in collection("weblog")/user[@ID="'.$id.'"]
					return $user/info/nick/text()';
		$result= $GLOBALS['system']->getDB()->fetchNode($xquery);
		return $result;
	}	
}

?>
