<?php

require_once 'classes/Session.php';
require_once 'classes/Controler.php';
require_once 'classes/Portlet.php';
require_once 'classes/Sedna.php';
require_once 'classes/Filters.php';
require_once 'classes/SortQueries.php';
require_once 'classes/Tagging.php';

class TagCloud implements Portlet {

/*
TODO:

*/
	private $tagging;
	public function init($params) {
		$this->tagging = Tagging::getInstance();
	}
	public function getXML($params) {
		$data="";
		switch ($params['type']) {
			case "vote":
			case "postView":{
				$data = '<module name="TagCloud">'. $this->tagging->getCloudXML($this->tagging->cloudMaker->getCloud("tag","linear",null,null,formatText($params['postID'], false),null),"alphabet").'</module>';
				break;
			}
			case "userPosts":
			case "blogView":{
				$data = '<module name="TagCloud">'. $this->tagging->getCloudXML($this->tagging->cloudMaker->getCloud("tag","logarithmic",null,formatText($params['userID'], false),null,null,50),"alphabet").'</module>';
			break;
			}
			case "search":
			case "portalView": {
				$data .= '<module name="TagCloud">'. $this->tagging->getCloudXML($this->tagging->cloudMaker->getCloud("tag","logarithmic",null,null,null,null,50),"alphabet").'</module>';
				break;
			}
			case "postForm": {
				$data = '<module name="TagCloud">'.$this->tagging->getCloudXML($this->tagging->cloudMaker->getCloud("tag","linear",null,formatText($params['userID'], false),null,null),"alphabet")."</module>";
				break;
			}
		}
		return $data;
	}
	public function getXSLlist($params) {
		switch ($params['type']) {
			case "vote":
			case "postView":
			case "blogView":
			case "search":
			case "portalView": {
				return array('classes/modules/tagCloud.xsl');
				break;
			}
			case "userPosts":{
				return array('classes/modules/tagCloudPosts.xsl');
			}
			case "postForm":{
				return array('classes/modules/tagCloudPostForm.xsl');
				break;
			}
		}
		return array();
	}
	
	public function getXSLParams($params) {
		switch ($params['type']) {
			case "vote":
			case "postView":
			case "blogView":
				return array('base'=>BASE,'user'=>$params['userID']); //aj aktualny user
				break;
			case "search":
			case "userPosts":
			case "portalView": {
				return array('base'=>BASE);
				break;
			}
		}
		return array();
	}
}

$GLOBALS['controler']->registerPortlet(TagCloud);

?>
