/* 
 * File:   EdgesAction.cpp
 * Author: Marcel Duris
 * 
 * Created on March 11, 2012, 10:34 AM
 */

#include "FloodfillAction.h"
#include <cstdlib>
#include <cstdio>
#include <iostream>
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

using namespace cv;
using namespace std;

FloodfillAction::FloodfillAction(Mat orig, Mat regions) {
    orig.copyTo(this->orig);
    regions.copyTo(this->regions);

    init();
    help();
}

FloodfillAction::FloodfillAction(const FloodfillAction& orig) {
}

FloodfillAction::~FloodfillAction() {
}

void FloodfillAction::help() {
    cout << "Vyber vlastnosti. Ovladanie:\n";
    cout << "Oznacime rohy oblasti, v ktorej chceme zvolit zaujimave vlastnosti.\n";
    cout << "Ak nie je oznacena oblast, zvoli sa cela plocha objektu.\n";
    cout << "Potvrdime vyber a zvolime vlastnosti v oblasti. Opakujeme.\n\n";
    
    cout << "\tA - potvrdenie vyberu regionu vyberu\n";
    cout << "\tS - vyber noveho regionu\n";
    cout << "\tR - restartovanie vyberu v aktualnom objekte\n";
    cout << "\tQ - ukoncenie vyberu, nepokracuj dalsim objektom\n";
    cout << "\tN - ukoncenie vyberu, spracovanie dalsieho objektu\n\n";
}

void FloodfillAction::init() {
    orig.copyTo(show);

    threshold(this->regions, this->regions, 10, 100, CV_THRESH_BINARY);
    this->regions.convertTo(this->regions, CV_8U);

    mask.create(orig.size(), CV_8U);
    mask.setTo(Scalar(0));

    if (show.channels() != 3) {
        cvtColor(show, show, CV_GRAY2BGR);
    }
    show.setTo(Scalar(255, 0, 0), regions);

    bfinished = false;
    showRegs = true;

    cleanRoiRect();

    state = STATE_SELECT_ROI;
}

void FloodfillAction::processMouseInput(int event, int x, int y, int flags) {
    if (event != CV_EVENT_LBUTTONDOWN)
        return;

    if (state == STATE_SELECT_ROI) {
        setRoiRectPoint(x, y);
    }

    if (state == STATE_SELECT_EDGE) {
        int xoff, yoff;
        Mat showRoi, edgeRoi, maskRoi;
        if (isRoiRectReady()) {
            xoff = roiRect.x;
            yoff = roiRect.y;
            showRoi = show(roiRect);
            edgeRoi = regions(roiRect);
            maskRoi = mask(roiRect);
            if ( ( x >= roiRect.x + roiRect.width) || (y >= roiRect.y + roiRect.height) ) {
                return;
            }
        } else {
            xoff = 0;
            yoff = 0;
            showRoi = show;
            edgeRoi = regions;
            maskRoi = mask;
        }
        
        if ( (x < xoff) || (y < yoff) ) {
            return;
        }

        Mat tmp;
        edgeRoi.copyTo(tmp);
        floodFill(tmp, Point(x - xoff, y - yoff), Scalar(250));
        subtract(tmp, Scalar(200), tmp);
        threshold(tmp, tmp, 2, 255, CV_THRESH_BINARY);

        showRoi.setTo(Scalar(0, 255, 0), tmp);
        maskRoi.setTo(Scalar(255), tmp);
    }
}

void FloodfillAction::processKeyboardInput(int key) {

    if ( (key == 'q') || (key == 'n') ) {
        bfinished = true;
    }

    if (key == 's') {
        state = STATE_SELECT_ROI;
        cleanRoiRect();
    }

    if (key == 'a') {
        if (isRoiRectReady()) {
            (regions(roiRect)).copyTo(roi);
        } else {
            regions.copyTo(roi);
        }
        state = STATE_SELECT_EDGE;
    }
    if (key == 'd') {
        showRegs = !showRegs;
    }
 
    if (key == 'r') {
        init();
    }
    
}

bool FloodfillAction::finished() {
    return bfinished;
}

Mat FloodfillAction::getImg() {
    Mat tmp;
    if (showRegs) {
        show.copyTo(tmp);
    } else {
        orig.copyTo(tmp);
    }

    if (isRoiRectReady()) {
        rectangle(tmp, roiRect, Scalar(255, 255, 0), 1);
    }

    return tmp;
}

Mat FloodfillAction::getMask() {
    return mask;
}

