/* 
 * File:   EdgesAction.h
 * Author: Marcel Duris
 *
 * Created on March 11, 2012, 10:34 AM
 * 
 * Trieda implementujuca akcie na spravne zadanie vstupu segmentacnemu algoritmu
 * floodfill.
 */

#include "SelectAction.h"
#include <cstdlib>
#include <cstdio>
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

using namespace cv;
using namespace std;

#ifndef FLOODFILLACTION_H
#define	FLOODFILLACTION_H

class FloodfillAction : public SelectAction {
public:
    FloodfillAction(Mat orig, Mat regions);
    FloodfillAction(const FloodfillAction& orig);
    virtual ~FloodfillAction();
    virtual void processMouseInput(int event, int x, int y, int flags);
    virtual void processKeyboardInput(int key);
    virtual bool finished();
    virtual Mat getImg();
    virtual Mat getMask();
    static const int STATE_SELECT_EDGE = 2;
private:
    Mat regions, roi, mask;
    bool bfinished, showRegs;
    void init();
    void help();
};

#endif	/* FLOODFILLACTION_H */

