/* 
 * File:   SelectObject.h
 * Author: Marcel Duris
 *
 * Created on February 19, 2012, 4:01 PM
 * 
 * Trieda implementujuca akcie potrebne pre spravne zadanie vstupu algoritmu
 * grabcut na segmentovanie.
 */


#include <string>
#include <opencv2/core/core.hpp>

using namespace cv;
using namespace std;

#ifndef GRABCUTACTION_H
#define	GRABCUTACTION_H


class GrabcutAction : public SelectAction {
public:
    GrabcutAction(Mat img);
    GrabcutAction(Mat img, string outfile);
    GrabcutAction(const GrabcutAction& orig);
    virtual ~GrabcutAction();
    virtual void processMouseInput(int event, int x, int y, int flags);
    virtual void processKeyboardInput(int key);
    virtual bool finished();
    virtual Mat getImg();
    virtual Mat getMask();
    
    void loadFromFile(string file, Mat &dst);
    void loadFromMask(Mat mask, Mat &dst);
    
private:
    static const int SELECT_ROI = 1;
    static const int SELECT_FGD = 2;
    static const int SELECT_PR_FGD = 3;
    static const int SELECT_PR_BGD = 4;
    static const int SELECT_BGD = 5;
    static const int FINISHED = 6;
    static const int RADIUS = 4;
    
    static const string FS_FGD;
    static const string FS_BGD;
    static const string FS_PR_FGD;
    static const string FS_PR_BGD;
    static const string FS_ROI;
    
    Scalar FGC, PFGC, PBGC, BGC, GREEN, WHITE, BLACK;
    
    string outfile;
    Point roiBegin, roiEnd;
    Rect roiRect;
    
    Mat orig, mask, bgdModel, fgdModel;
    vector< Point > bgdPxls, prBgdPxls, fgdPxls, prFgdPxls;
    
    int phase;
    bool isInitialized;
    
    void init();
    void addPoint(Point p);
    void pushPixelsToMask(bool forceReset = false);
    void setRoiInMask();
    void show();
    void nextIter();
    void save(string output);
    void load(string input);
};

#endif	/* GRABCUTACTION_H */

