/* 
 * File:   ImageTestSet.h
 * Author: Marcel Duris
 *
 * Created on March 30, 2012, 2:28 PM
 * 
 * Testovaci framework schopny ziskat ocakavane odpovede od cloveka, ulozit ich
 * nacitat zo suboru a vyhodnocovat podla zvolenych hodnot prahov.
 */

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

#include "utils.h"

using namespace cv;
using namespace std;

#ifndef IMAGETESTSET_H
#define	IMAGETESTSET_H

class ImageTestSet {
public:
    ImageTestSet();
    ImageTestSet(const ImageTestSet& orig);
    virtual ~ImageTestSet();

    void buildTestSet(string maskDescriptionFile, string imagePath, int count, bool append = false);
    void getTruthFromUser();

    void saveToFile(string outFile);
    void loadFromFile(string inFile);

    bool hasNext();
    bool next();

    int getGoodRespsForThreshold(int maskNo, float threshold);
    int getGoodRespsForThreshold(int maskNo, float threshold,
            int &truePositives, int &trueNegatives,
            int &falsePositives, int &falseNegatives);

    vector< int > getCurrentGroundTruth();
    vector< float > getCurrentResp();
    Mat getCurrentImage();
    void pushCurrentResp(vector<float> resp);

    string imagePath, maskDescriptionFile;
    
private:
    vector< vector< int > > groundTruth;
    vector< vector< float > > resps;
    //vector< string > imageList;
    vector< maskRegion > masks;

    int pos, count;

};

#endif	/* IMAGETESTSET_H */

