/* 
 * File:   PixelAction.cpp
 * Author: Marcel Duris
 * 
 * Created on April 20, 2012, 7:49 PM
 */

#include "PixelAction.h"

PixelAction::PixelAction(Mat img, Mat alt) {
    img.copyTo(this->orig);
    alt.copyTo(this->alt);

    mask.create(img.rows, img.cols, CV_8U);
    mask.setTo(Scalar(0));

    img.copyTo(show);

    altShow = false;
    
    state = STATE_SELECT_ROI;
    
    help();
}

PixelAction::PixelAction(const PixelAction& orig) {
}

PixelAction::~PixelAction() {
}

void PixelAction::help() {
    cout << "Vyber policok mriezky. Ovladanie:\n";
    cout << "\tLave tlacidlo mysi - pridaj policko do sablony\n";
    cout << "\tPrave tlacidlo mysi - vyber policko zo sablony\n";
    cout << "\tD - prepni medzi odpovedami Gaborovych filtrov a povodnym vstupom\n";
    cout << "\tA - zobraz cely vstup\n";
    cout << "\tS - zobraz zvolene policka\n";
    cout << "\tQ - ukonci vyber, nepokracuj vyberom dalsieho objektu\n";
    cout << "\tN - ukonci vyber, spracuj dalsi objektu\n\n";
}

void PixelAction::processMouseInput(int event, int x, int y, int flags) {

    if (event == CV_EVENT_LBUTTONDOWN) {
        mask.at<unsigned char>(y, x) = 255;
    }

    if (event == CV_EVENT_RBUTTONDOWN) {
        mask.at<unsigned char>(y, x) = 0;
    }
    
}

void PixelAction::processKeyboardInput(int key) {
    show.setTo(Scalar(0));
    if (key == 's') {
        if ((!altShow) || (alt.empty())) {
            orig.copyTo(show, mask);
        } else {
            alt.copyTo(show, mask);
        }
    }

    if (key == 'a') {
        if ((!altShow) || (alt.empty())) {
            orig.copyTo(show);
        } else {
            alt.copyTo(show);
        }
    }

    if (key == 'd') {
        if (!alt.empty()) {
            altShow = !altShow;
        }

        if ((!altShow) || (alt.empty())) {
            orig.copyTo(show);
        } else {
            alt.copyTo(show);
        }
    }

    if (key == 'q') {
        state = STATE_FINISHED;
    }

    if (key == 'n') {
        state = STATE_FINISHED;
    }
}

Mat PixelAction::getImg() {
    return show;
}

Mat PixelAction::getMask() {
    return mask;
}

bool PixelAction::finished() {
    return state == STATE_FINISHED;
}


