/* 
 * File:   PixelAction.h
 * Author: Marcel Duris
 *
 * Created on April 20, 2012, 7:49 PM
 * 
 * Jednoducha trieda umoznujuca volit do masky jednotlive pixely.
 */

#include "SelectAction.h"
#include <cstdlib>
#include <cstdio>
#include <iostream>
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

#ifndef PIXELACTION_H
#define	PIXELACTION_H

using namespace cv;
using namespace std;

class PixelAction : public SelectAction {
public:
    PixelAction(Mat img, Mat alt);
    PixelAction(const PixelAction& orig);
    virtual ~PixelAction();
    virtual void processMouseInput(int event, int x, int y, int flags);
    virtual void processKeyboardInput(int key);
    virtual bool finished();
    virtual Mat getImg();
    virtual Mat getMask();
    
    static const int STATE_FINISHED = 2;
private:
    Mat alt, mask;
    bool altShow;
    
    void help();
};

#endif	/* PIXELACTION_H */

