/* 
 * File:   RoiAction.cpp
 * Author: Marcel Duris
 * 
 * Created on March 24, 2012, 2:04 PM
 */

#include "RoiAction.h"
#include "iostream"

using namespace std;
using namespace cv;

RoiAction::RoiAction(Mat img) {
    img.copyTo(orig);
    state = STATE_SELECT_ROI;
    cleanRoiRect();
    
    help();
}

RoiAction::RoiAction(const RoiAction& orig) {
    cout << "toto nechcem" << endl;
}

RoiAction::~RoiAction() {
}

void RoiAction::help() {
    cout << "Vyber pozorovaneho objektu. Ovladanie:\n";
    cout << "Zvolime rohy regionu, v ktorom sa nachadza objekt, potvrdime.\n";
    cout << "\tA - potvrdenie vyberu regionu objektu\n\n";
}

void RoiAction::processKeyboardInput(int key) {
    if (finished()) {
        return;
    }

    if (key == 'a') {
        if (isRoiRectReady()) {
            state = STATE_FINISHED;
        }
    }
}

void RoiAction::processMouseInput(int event, int x, int y, int flags) {
    if (event != CV_EVENT_LBUTTONDOWN)
        return;

    if (state == STATE_SELECT_ROI) {
        setRoiRectPoint(x, y);
    }
}

Mat RoiAction::getImg() {
    Mat tmp;
    orig.copyTo(tmp);

    if (isRoiRectReady()) {
        rectangle(tmp, roiRect, Scalar(255, 255, 0), 2);
    }

    return tmp;
}

Mat RoiAction::getMask() {
    return orig(roiRect);
}

bool RoiAction::finished() {
    return state == STATE_FINISHED;
}

Rect RoiAction::getRoi() {
    return roiRect;
}

