/* 
 * File:   SelectAction.cpp
 * Author: Marcel Duris
 * 
 * Created on March 11, 2012, 10:24 AM
 */

#include "SelectAction.h"
#include <iostream>

using namespace std;

SelectAction::SelectAction() {
}

SelectAction::SelectAction(const SelectAction& orig) {
}

SelectAction::~SelectAction() {
}

void SelectAction::setRoiRectPoint(int x, int y) {
    if ( (roiRect.width != -1) || (roiRect.height != -1) ) {
        cleanRoiRect();
    }
    
    if ( (roiRect.x == -1) || (roiRect.y == -1) ) {
        roiRect.x = x;
        roiRect.y = y;
    } else {
        int x1 = min(roiRect.x, x);
        int y1 = min(roiRect.y, y);
        
        int x2 = max(roiRect.x, x);
        int y2 = max(roiRect.y, y);
        
        roiRect.x = x1;
        roiRect.y = y1;
        
        roiRect.width = x2 - x1;
        roiRect.height = y2 - y1;
        
    }
}

void SelectAction::cleanRoiRect() {
    roiRect.x = -1;
    roiRect.y = -1;
    roiRect.width = -1;
    roiRect.height = -1;
}

bool SelectAction::isRoiRectReady() {
    if ( (roiRect.height > 0) && (roiRect.width > 0) && (roiRect.x > -1) && (roiRect.y > -1) ) {
        return true;
    } else {
        return false;
    }
}

