/* 
 * File:   SelectAction.h
 * Author: Marcel Duris
 *
 * Created on March 11, 2012, 10:24 AM
 * 
 * Abstraktna trieda vykonavanej akcie.
 */

#include <opencv2/core/core.hpp>

using namespace cv;

#ifndef SELECTACTION_H
#define	SELECTACTION_H

class SelectAction {
public:
    SelectAction();
    SelectAction(const SelectAction& orig);
    virtual ~SelectAction();
    virtual void processKeyboardInput(int key) = 0;
    virtual void processMouseInput( int event, int x, int y, int flags ) = 0;
    virtual Mat getImg() = 0;
    virtual Mat getMask() = 0;
    virtual bool finished() = 0;
    
    int state;
    
    static const int STATE_SELECT_ROI = 1;
private:
    
protected:
    Rect roiRect;
    Mat orig, show;
    void setRoiRectPoint(int x, int y);
    void cleanRoiRect();
    bool isRoiRectReady();

};

#endif	/* SELECTACTION_H */

