/* 
 * File:   SelectObject.cpp
 * Author: Marcel Duris
 * 
 * Created on March 11, 2012, 9:54 AM
 */

#include "SelectObject.h"
#include "SelectAction.h"
#include <cstdlib>
#include <cstdio>
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

#include <iostream>

using namespace cv;
using namespace std;

SelectObject::SelectObject(string wname, SelectAction *action) {
    this->wname = wname;
    this->action = action;
    this->contsel = false;
}

SelectObject::SelectObject(const SelectObject& orig) {
}

SelectObject::~SelectObject() {
}

void mouseWrapperSelectObject( int event, int x, int y, int flags, void* param ) {
    void **params = (void**)param;
    
    SelectAction* a = (SelectAction*)params[0];
    SelectObject* o = (SelectObject*)params[1];
    a->processMouseInput(event, x, y, flags);
    if ((event == CV_EVENT_LBUTTONUP) || (event == CV_EVENT_RBUTTONUP)){
        o->showWindow();
    }
}

void SelectObject::getUserInput(Mat &dst) {
    namedWindow(wname, CV_WINDOW_NORMAL);
    imshow(wname, action->getImg());
    
    void *params[2];
    params[0] = action;
    params[1] = this;
    
    setMouseCallback(wname, mouseWrapperSelectObject, params);
    while (!action->finished()) {
        int key = waitKey();
        
        if (key == 'q') {
            contsel = false;
        }
        
        if (key == 'n') {
            contsel = true;
        }
        
        action->processKeyboardInput(key);
        showWindow();
    }
    
    dst = action->getMask();
    
    destroyWindow(wname);
    
}

void SelectObject::showWindow() {
    imshow(wname, action->getImg());
}

bool SelectObject::continueSelecting() {
    return contsel;
}
